# frozen_string_literal: true

# WARNING ABOUT GENERATED CODE
#
# This file is generated. See the contributing guide for more information:
# https://github.com/aws/aws-sdk-ruby/blob/version-3/CONTRIBUTING.md
#
# WARNING ABOUT GENERATED CODE

module Aws::Budgets
  module Types

    # You are not authorized to use this operation with the given
    # parameters.
    #
    # @!attribute [rw] message
    #   The error message the exception carries.
    #   @return [String]
    #
    class AccessDeniedException < Struct.new(
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # A budget action resource.
    #
    # @!attribute [rw] action_id
    #   A system-generated universally unique identifier (UUID) for the
    #   action.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   A string that represents the budget name. The ":" and "\\"
    #   characters, and the "/action/" substring, aren't allowed.
    #   @return [String]
    #
    # @!attribute [rw] notification_type
    #   The type of a notification. It must be ACTUAL or FORECASTED.
    #   @return [String]
    #
    # @!attribute [rw] action_type
    #   The type of action. This defines the type of tasks that can be
    #   carried out by this action. This field also determines the format
    #   for definition.
    #   @return [String]
    #
    # @!attribute [rw] action_threshold
    #   The trigger threshold of the action.
    #   @return [Types::ActionThreshold]
    #
    # @!attribute [rw] definition
    #   Where you specify all of the type-specific parameters.
    #   @return [Types::Definition]
    #
    # @!attribute [rw] execution_role_arn
    #   The role passed for action execution and reversion. Roles and
    #   actions must be in the same account.
    #   @return [String]
    #
    # @!attribute [rw] approval_model
    #   This specifies if the action needs manual or automatic approval.
    #   @return [String]
    #
    # @!attribute [rw] status
    #   The status of the action.
    #   @return [String]
    #
    # @!attribute [rw] subscribers
    #   A list of subscribers.
    #   @return [Array<Types::Subscriber>]
    #
    class Action < Struct.new(
      :action_id,
      :budget_name,
      :notification_type,
      :action_type,
      :action_threshold,
      :definition,
      :execution_role_arn,
      :approval_model,
      :status,
      :subscribers)
      SENSITIVE = []
      include Aws::Structure
    end

    # The historical records for a budget action.
    #
    # @!attribute [rw] timestamp
    #   A generic time stamp. In Java, it's transformed to a `Date` object.
    #   @return [Time]
    #
    # @!attribute [rw] status
    #   The status of action at the time of the event.
    #   @return [String]
    #
    # @!attribute [rw] event_type
    #   This distinguishes between whether the events are triggered by the
    #   user or are generated by the system.
    #   @return [String]
    #
    # @!attribute [rw] action_history_details
    #   The description of the details for the event.
    #   @return [Types::ActionHistoryDetails]
    #
    class ActionHistory < Struct.new(
      :timestamp,
      :status,
      :event_type,
      :action_history_details)
      SENSITIVE = []
      include Aws::Structure
    end

    # The description of the details for the event.
    #
    # @!attribute [rw] message
    #   A generic string.
    #   @return [String]
    #
    # @!attribute [rw] action
    #   The budget action resource.
    #   @return [Types::Action]
    #
    class ActionHistoryDetails < Struct.new(
      :message,
      :action)
      SENSITIVE = []
      include Aws::Structure
    end

    # The trigger threshold of the action.
    #
    # @!attribute [rw] action_threshold_value
    #   The threshold of a notification.
    #   @return [Float]
    #
    # @!attribute [rw] action_threshold_type
    #   The type of threshold for a notification.
    #   @return [String]
    #
    class ActionThreshold < Struct.new(
      :action_threshold_value,
      :action_threshold_type)
      SENSITIVE = []
      include Aws::Structure
    end

    # The parameters that determine the budget amount for an auto-adjusting
    # budget.
    #
    # @!attribute [rw] auto_adjust_type
    #   The string that defines whether your budget auto-adjusts based on
    #   historical or forecasted data.
    #   @return [String]
    #
    # @!attribute [rw] historical_options
    #   The parameters that define or describe the historical data that your
    #   auto-adjusting budget is based on.
    #   @return [Types::HistoricalOptions]
    #
    # @!attribute [rw] last_auto_adjust_time
    #   The last time that your budget was auto-adjusted.
    #   @return [Time]
    #
    class AutoAdjustData < Struct.new(
      :auto_adjust_type,
      :historical_options,
      :last_auto_adjust_time)
      SENSITIVE = []
      include Aws::Structure
    end

    # Represents the output of the `CreateBudget` operation. The content
    # consists of the detailed metadata and data file information, and the
    # current status of the `budget` object.
    #
    # This is the Amazon Resource Name (ARN) pattern for a budget:
    #
    # `arn:aws:budgets::AccountId:budget/budgetName`
    #
    # @!attribute [rw] budget_name
    #   The name of a budget. The name must be unique within an account. The
    #   `:` and `` characters, and the "/action/" substring, aren't
    #   allowed in `BudgetName`.
    #   @return [String]
    #
    # @!attribute [rw] budget_limit
    #   The total amount of cost, usage, RI utilization, RI coverage,
    #   Savings Plans utilization, or Savings Plans coverage that you want
    #   to track with your budget.
    #
    #   `BudgetLimit` is required for cost or usage budgets, but optional
    #   for RI or Savings Plans utilization or coverage budgets. RI and
    #   Savings Plans utilization or coverage budgets default to `100`. This
    #   is the only valid value for RI or Savings Plans utilization or
    #   coverage budgets. You can't use `BudgetLimit` with
    #   `PlannedBudgetLimits` for `CreateBudget` and `UpdateBudget` actions.
    #   @return [Types::Spend]
    #
    # @!attribute [rw] planned_budget_limits
    #   A map containing multiple `BudgetLimit`, including current or future
    #   limits.
    #
    #   `PlannedBudgetLimits` is available for cost or usage budget and
    #   supports both monthly and quarterly `TimeUnit`.
    #
    #   For monthly budgets, provide 12 months of `PlannedBudgetLimits`
    #   values. This must start from the current month and include the next
    #   11 months. The `key` is the start of the month, `UTC` in epoch
    #   seconds.
    #
    #   For quarterly budgets, provide four quarters of
    #   `PlannedBudgetLimits` value entries in standard calendar quarter
    #   increments. This must start from the current quarter and include the
    #   next three quarters. The `key` is the start of the quarter, `UTC` in
    #   epoch seconds.
    #
    #   If the planned budget expires before 12 months for monthly or four
    #   quarters for quarterly, provide the `PlannedBudgetLimits` values
    #   only for the remaining periods.
    #
    #   If the budget begins at a date in the future, provide
    #   `PlannedBudgetLimits` values from the start date of the budget.
    #
    #   After all of the `BudgetLimit` values in `PlannedBudgetLimits` are
    #   used, the budget continues to use the last limit as the
    #   `BudgetLimit`. At that point, the planned budget provides the same
    #   experience as a fixed budget.
    #
    #   `DescribeBudget` and `DescribeBudgets` response along with
    #   `PlannedBudgetLimits` also contain `BudgetLimit` representing the
    #   current month or quarter limit present in `PlannedBudgetLimits`.
    #   This only applies to budgets that are created with
    #   `PlannedBudgetLimits`. Budgets that are created without
    #   `PlannedBudgetLimits` only contain `BudgetLimit`. They don't
    #   contain `PlannedBudgetLimits`.
    #   @return [Hash<String,Types::Spend>]
    #
    # @!attribute [rw] cost_filters
    #   The cost filters, such as `Region`, `Service`, `LinkedAccount`,
    #   `Tag`, or `CostCategory`, that are applied to a budget.
    #
    #   Amazon Web Services Budgets supports the following services as a
    #   `Service` filter for RI budgets:
    #
    #   * Amazon EC2
    #
    #   * Amazon Redshift
    #
    #   * Amazon Relational Database Service
    #
    #   * Amazon ElastiCache
    #
    #   * Amazon OpenSearch Service
    #   @return [Hash<String,Array<String>>]
    #
    # @!attribute [rw] cost_types
    #   The types of costs that are included in this `COST` budget.
    #
    #   `USAGE`, `RI_UTILIZATION`, `RI_COVERAGE`,
    #   `SAVINGS_PLANS_UTILIZATION`, and `SAVINGS_PLANS_COVERAGE` budgets do
    #   not have `CostTypes`.
    #   @return [Types::CostTypes]
    #
    # @!attribute [rw] time_unit
    #   The length of time until a budget resets the actual and forecasted
    #   spend.
    #   @return [String]
    #
    # @!attribute [rw] time_period
    #   The period of time that's covered by a budget. You set the start
    #   date and end date. The start date must come before the end date. The
    #   end date must come before `06/15/87 00:00 UTC`.
    #
    #   If you create your budget and don't specify a start date, Amazon
    #   Web Services defaults to the start of your chosen time period
    #   (DAILY, MONTHLY, QUARTERLY, or ANNUALLY). For example, if you
    #   created your budget on January 24, 2018, chose `DAILY`, and didn't
    #   set a start date, Amazon Web Services set your start date to
    #   `01/24/18 00:00 UTC`. If you chose `MONTHLY`, Amazon Web Services
    #   set your start date to `01/01/18 00:00 UTC`. If you didn't specify
    #   an end date, Amazon Web Services set your end date to `06/15/87
    #   00:00 UTC`. The defaults are the same for the Billing and Cost
    #   Management console and the API.
    #
    #   You can change either date with the `UpdateBudget` operation.
    #
    #   After the end date, Amazon Web Services deletes the budget and all
    #   the associated notifications and subscribers.
    #   @return [Types::TimePeriod]
    #
    # @!attribute [rw] calculated_spend
    #   The actual and forecasted cost or usage that the budget tracks.
    #   @return [Types::CalculatedSpend]
    #
    # @!attribute [rw] budget_type
    #   Specifies whether this budget tracks costs, usage, RI utilization,
    #   RI coverage, Savings Plans utilization, or Savings Plans coverage.
    #   @return [String]
    #
    # @!attribute [rw] last_updated_time
    #   The last time that you updated this budget.
    #   @return [Time]
    #
    # @!attribute [rw] auto_adjust_data
    #   The parameters that determine the budget amount for an
    #   auto-adjusting budget.
    #   @return [Types::AutoAdjustData]
    #
    # @!attribute [rw] filter_expression
    #   The filtering dimensions for the budget and their corresponding
    #   values.
    #   @return [Types::Expression]
    #
    # @!attribute [rw] metrics
    #   The definition for how the budget data is aggregated.
    #   @return [Array<String>]
    #
    # @!attribute [rw] billing_view_arn
    #   The Amazon Resource Name (ARN) that uniquely identifies a specific
    #   billing view. The ARN is used to specify which particular billing
    #   view you want to interact with or retrieve information from when
    #   making API calls related to Amazon Web Services Billing and Cost
    #   Management features. The BillingViewArn can be retrieved by calling
    #   the ListBillingViews API.
    #   @return [String]
    #
    # @!attribute [rw] health_status
    #   The current operational state of a Billing View derived resource.
    #   @return [Types::HealthStatus]
    #
    class Budget < Struct.new(
      :budget_name,
      :budget_limit,
      :planned_budget_limits,
      :cost_filters,
      :cost_types,
      :time_unit,
      :time_period,
      :calculated_spend,
      :budget_type,
      :last_updated_time,
      :auto_adjust_data,
      :filter_expression,
      :metrics,
      :billing_view_arn,
      :health_status)
      SENSITIVE = []
      include Aws::Structure
    end

    # The budget name and associated notifications for an account.
    #
    # @!attribute [rw] notifications
    #   A list of notifications.
    #   @return [Array<Types::Notification>]
    #
    # @!attribute [rw] budget_name
    #   A string that represents the budget name. The ":" and "\\"
    #   characters, and the "/action/" substring, aren't allowed.
    #   @return [String]
    #
    class BudgetNotificationsForAccount < Struct.new(
      :notifications,
      :budget_name)
      SENSITIVE = []
      include Aws::Structure
    end

    # A history of the state of a budget at the end of the budget's
    # specified time period.
    #
    # @!attribute [rw] budget_name
    #   A string that represents the budget name. The ":" and "\\"
    #   characters, and the "/action/" substring, aren't allowed.
    #   @return [String]
    #
    # @!attribute [rw] budget_type
    #   The type of a budget. It must be one of the following types:
    #
    #   `COST`, `USAGE`, `RI_UTILIZATION`, `RI_COVERAGE`,
    #   `SAVINGS_PLANS_UTILIZATION`, or `SAVINGS_PLANS_COVERAGE`.
    #   @return [String]
    #
    # @!attribute [rw] cost_filters
    #   The history of the cost filters for a budget during the specified
    #   time period.
    #   @return [Hash<String,Array<String>>]
    #
    # @!attribute [rw] cost_types
    #   The history of the cost types for a budget during the specified time
    #   period.
    #   @return [Types::CostTypes]
    #
    # @!attribute [rw] time_unit
    #   The time unit of the budget, such as MONTHLY or QUARTERLY.
    #   @return [String]
    #
    # @!attribute [rw] billing_view_arn
    #   The Amazon Resource Name (ARN) that uniquely identifies a specific
    #   billing view. The ARN is used to specify which particular billing
    #   view you want to interact with or retrieve information from when
    #   making API calls related to Amazon Web Services Billing and Cost
    #   Management features. The BillingViewArn can be retrieved by calling
    #   the ListBillingViews API.
    #   @return [String]
    #
    # @!attribute [rw] budgeted_and_actual_amounts_list
    #   A list of amounts of cost or usage that you created budgets for,
    #   which are compared to your actual costs or usage.
    #   @return [Array<Types::BudgetedAndActualAmounts>]
    #
    class BudgetPerformanceHistory < Struct.new(
      :budget_name,
      :budget_type,
      :cost_filters,
      :cost_types,
      :time_unit,
      :billing_view_arn,
      :budgeted_and_actual_amounts_list)
      SENSITIVE = []
      include Aws::Structure
    end

    # The amount of cost or usage that you created the budget for, compared
    # to your actual costs or usage.
    #
    # @!attribute [rw] budgeted_amount
    #   The amount of cost or usage that you created the budget for.
    #   @return [Types::Spend]
    #
    # @!attribute [rw] actual_amount
    #   Your actual costs or usage for a budget period.
    #   @return [Types::Spend]
    #
    # @!attribute [rw] time_period
    #   The time period that's covered by this budget comparison.
    #   @return [Types::TimePeriod]
    #
    class BudgetedAndActualAmounts < Struct.new(
      :budgeted_amount,
      :actual_amount,
      :time_period)
      SENSITIVE = []
      include Aws::Structure
    end

    # The spend objects that are associated with this budget. The
    # `actualSpend` tracks how much you've used, cost, usage, RI units, or
    # Savings Plans units and the `forecastedSpend` tracks how much that
    # you're predicted to spend based on your historical usage profile.
    #
    # For example, if it's the 20th of the month and you have spent `50`
    # dollars on Amazon EC2, your `actualSpend` is `50 USD`, and your
    # `forecastedSpend` is `75 USD`.
    #
    # @!attribute [rw] actual_spend
    #   The amount of cost, usage, RI units, or Savings Plans units that you
    #   used.
    #   @return [Types::Spend]
    #
    # @!attribute [rw] forecasted_spend
    #   The amount of cost, usage, RI units, or Savings Plans units that
    #   you're forecasted to use.
    #   @return [Types::Spend]
    #
    class CalculatedSpend < Struct.new(
      :actual_spend,
      :forecasted_spend)
      SENSITIVE = []
      include Aws::Structure
    end

    # The cost category values used for filtering the costs.
    #
    # @!attribute [rw] key
    #   The unique name of the cost category.
    #   @return [String]
    #
    # @!attribute [rw] values
    #   The specific value of the cost category.
    #   @return [Array<String>]
    #
    # @!attribute [rw] match_options
    #   The match options that you can use to filter your results.
    #   @return [Array<String>]
    #
    class CostCategoryValues < Struct.new(
      :key,
      :values,
      :match_options)
      SENSITIVE = []
      include Aws::Structure
    end

    # The types of cost that are included in a `COST` budget, such as tax
    # and subscriptions.
    #
    # `USAGE`, `RI_UTILIZATION`, `RI_COVERAGE`, `SAVINGS_PLANS_UTILIZATION`,
    # and `SAVINGS_PLANS_COVERAGE` budgets don't have `CostTypes`.
    #
    # @!attribute [rw] include_tax
    #   Specifies whether a budget includes taxes.
    #
    #   The default value is `true`.
    #   @return [Boolean]
    #
    # @!attribute [rw] include_subscription
    #   Specifies whether a budget includes subscriptions.
    #
    #   The default value is `true`.
    #   @return [Boolean]
    #
    # @!attribute [rw] use_blended
    #   Specifies whether a budget uses a blended rate.
    #
    #   The default value is `false`.
    #   @return [Boolean]
    #
    # @!attribute [rw] include_refund
    #   Specifies whether a budget includes refunds.
    #
    #   The default value is `true`.
    #   @return [Boolean]
    #
    # @!attribute [rw] include_credit
    #   Specifies whether a budget includes credits.
    #
    #   The default value is `true`.
    #   @return [Boolean]
    #
    # @!attribute [rw] include_upfront
    #   Specifies whether a budget includes upfront RI costs.
    #
    #   The default value is `true`.
    #   @return [Boolean]
    #
    # @!attribute [rw] include_recurring
    #   Specifies whether a budget includes recurring fees such as monthly
    #   RI fees.
    #
    #   The default value is `true`.
    #   @return [Boolean]
    #
    # @!attribute [rw] include_other_subscription
    #   Specifies whether a budget includes non-RI subscription costs.
    #
    #   The default value is `true`.
    #   @return [Boolean]
    #
    # @!attribute [rw] include_support
    #   Specifies whether a budget includes support subscription fees.
    #
    #   The default value is `true`.
    #   @return [Boolean]
    #
    # @!attribute [rw] include_discount
    #   Specifies whether a budget includes discounts.
    #
    #   The default value is `true`.
    #   @return [Boolean]
    #
    # @!attribute [rw] use_amortized
    #   Specifies whether a budget uses the amortized rate.
    #
    #   The default value is `false`.
    #   @return [Boolean]
    #
    class CostTypes < Struct.new(
      :include_tax,
      :include_subscription,
      :use_blended,
      :include_refund,
      :include_credit,
      :include_upfront,
      :include_recurring,
      :include_other_subscription,
      :include_support,
      :include_discount,
      :use_amortized)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] account_id
    #   The account ID of the user. It's a 12-digit number.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   A string that represents the budget name. The ":" and "\\"
    #   characters, and the "/action/" substring, aren't allowed.
    #   @return [String]
    #
    # @!attribute [rw] notification_type
    #   The type of a notification. It must be ACTUAL or FORECASTED.
    #   @return [String]
    #
    # @!attribute [rw] action_type
    #   The type of action. This defines the type of tasks that can be
    #   carried out by this action. This field also determines the format
    #   for definition.
    #   @return [String]
    #
    # @!attribute [rw] action_threshold
    #   The trigger threshold of the action.
    #   @return [Types::ActionThreshold]
    #
    # @!attribute [rw] definition
    #   Specifies all of the type-specific parameters.
    #   @return [Types::Definition]
    #
    # @!attribute [rw] execution_role_arn
    #   The role passed for action execution and reversion. Roles and
    #   actions must be in the same account.
    #   @return [String]
    #
    # @!attribute [rw] approval_model
    #   This specifies if the action needs manual or automatic approval.
    #   @return [String]
    #
    # @!attribute [rw] subscribers
    #   A list of subscribers.
    #   @return [Array<Types::Subscriber>]
    #
    # @!attribute [rw] resource_tags
    #   An optional list of tags to associate with the specified budget
    #   action. Each tag consists of a key and a value, and each key must be
    #   unique for the resource.
    #   @return [Array<Types::ResourceTag>]
    #
    class CreateBudgetActionRequest < Struct.new(
      :account_id,
      :budget_name,
      :notification_type,
      :action_type,
      :action_threshold,
      :definition,
      :execution_role_arn,
      :approval_model,
      :subscribers,
      :resource_tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] account_id
    #   The account ID of the user. It's a 12-digit number.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   A string that represents the budget name. The ":" and "\\"
    #   characters, and the "/action/" substring, aren't allowed.
    #   @return [String]
    #
    # @!attribute [rw] action_id
    #   A system-generated universally unique identifier (UUID) for the
    #   action.
    #   @return [String]
    #
    class CreateBudgetActionResponse < Struct.new(
      :account_id,
      :budget_name,
      :action_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Request of CreateBudget
    #
    # @!attribute [rw] account_id
    #   The `accountId` that is associated with the budget.
    #   @return [String]
    #
    # @!attribute [rw] budget
    #   The budget object that you want to create.
    #   @return [Types::Budget]
    #
    # @!attribute [rw] notifications_with_subscribers
    #   A notification that you want to associate with a budget. A budget
    #   can have up to five notifications, and each notification can have
    #   one SNS subscriber and up to 10 email subscribers. If you include
    #   notifications and subscribers in your `CreateBudget` call, Amazon
    #   Web Services creates the notifications and subscribers for you.
    #   @return [Array<Types::NotificationWithSubscribers>]
    #
    # @!attribute [rw] resource_tags
    #   An optional list of tags to associate with the specified budget.
    #   Each tag consists of a key and a value, and each key must be unique
    #   for the resource.
    #   @return [Array<Types::ResourceTag>]
    #
    class CreateBudgetRequest < Struct.new(
      :account_id,
      :budget,
      :notifications_with_subscribers,
      :resource_tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # Response of CreateBudget
    #
    class CreateBudgetResponse < Aws::EmptyStructure; end

    # Request of CreateNotification
    #
    # @!attribute [rw] account_id
    #   The `accountId` that is associated with the budget that you want to
    #   create a notification for.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   The name of the budget that you want Amazon Web Services to notify
    #   you about. Budget names must be unique within an account.
    #   @return [String]
    #
    # @!attribute [rw] notification
    #   The notification that you want to create.
    #   @return [Types::Notification]
    #
    # @!attribute [rw] subscribers
    #   A list of subscribers that you want to associate with the
    #   notification. Each notification can have one SNS subscriber and up
    #   to 10 email subscribers.
    #   @return [Array<Types::Subscriber>]
    #
    class CreateNotificationRequest < Struct.new(
      :account_id,
      :budget_name,
      :notification,
      :subscribers)
      SENSITIVE = []
      include Aws::Structure
    end

    # Response of CreateNotification
    #
    class CreateNotificationResponse < Aws::EmptyStructure; end

    # Request of CreateSubscriber
    #
    # @!attribute [rw] account_id
    #   The `accountId` that is associated with the budget that you want to
    #   create a subscriber for.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   The name of the budget that you want to subscribe to. Budget names
    #   must be unique within an account.
    #   @return [String]
    #
    # @!attribute [rw] notification
    #   The notification that you want to create a subscriber for.
    #   @return [Types::Notification]
    #
    # @!attribute [rw] subscriber
    #   The subscriber that you want to associate with a budget
    #   notification.
    #   @return [Types::Subscriber]
    #
    class CreateSubscriberRequest < Struct.new(
      :account_id,
      :budget_name,
      :notification,
      :subscriber)
      SENSITIVE = []
      include Aws::Structure
    end

    # Response of CreateSubscriber
    #
    class CreateSubscriberResponse < Aws::EmptyStructure; end

    # You've exceeded the notification or subscriber limit.
    #
    # @!attribute [rw] message
    #   The error message the exception carries.
    #   @return [String]
    #
    class CreationLimitExceededException < Struct.new(
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Specifies all of the type-specific parameters.
    #
    # @!attribute [rw] iam_action_definition
    #   The Identity and Access Management (IAM) action definition details.
    #   @return [Types::IamActionDefinition]
    #
    # @!attribute [rw] scp_action_definition
    #   The service control policies (SCPs) action definition details.
    #   @return [Types::ScpActionDefinition]
    #
    # @!attribute [rw] ssm_action_definition
    #   The Amazon Web Services Systems Manager (SSM) action definition
    #   details.
    #   @return [Types::SsmActionDefinition]
    #
    class Definition < Struct.new(
      :iam_action_definition,
      :scp_action_definition,
      :ssm_action_definition)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] account_id
    #   The account ID of the user. It's a 12-digit number.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   A string that represents the budget name. The ":" and "\\"
    #   characters, and the "/action/" substring, aren't allowed.
    #   @return [String]
    #
    # @!attribute [rw] action_id
    #   A system-generated universally unique identifier (UUID) for the
    #   action.
    #   @return [String]
    #
    class DeleteBudgetActionRequest < Struct.new(
      :account_id,
      :budget_name,
      :action_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] account_id
    #   The account ID of the user. It's a 12-digit number.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   A string that represents the budget name. The ":" and "\\"
    #   characters, and the "/action/" substring, aren't allowed.
    #   @return [String]
    #
    # @!attribute [rw] action
    #   A budget action resource.
    #   @return [Types::Action]
    #
    class DeleteBudgetActionResponse < Struct.new(
      :account_id,
      :budget_name,
      :action)
      SENSITIVE = []
      include Aws::Structure
    end

    # Request of DeleteBudget
    #
    # @!attribute [rw] account_id
    #   The `accountId` that is associated with the budget that you want to
    #   delete.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   The name of the budget that you want to delete.
    #   @return [String]
    #
    class DeleteBudgetRequest < Struct.new(
      :account_id,
      :budget_name)
      SENSITIVE = []
      include Aws::Structure
    end

    # Response of DeleteBudget
    #
    class DeleteBudgetResponse < Aws::EmptyStructure; end

    # Request of DeleteNotification
    #
    # @!attribute [rw] account_id
    #   The `accountId` that is associated with the budget whose
    #   notification you want to delete.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   The name of the budget whose notification you want to delete.
    #   @return [String]
    #
    # @!attribute [rw] notification
    #   The notification that you want to delete.
    #   @return [Types::Notification]
    #
    class DeleteNotificationRequest < Struct.new(
      :account_id,
      :budget_name,
      :notification)
      SENSITIVE = []
      include Aws::Structure
    end

    # Response of DeleteNotification
    #
    class DeleteNotificationResponse < Aws::EmptyStructure; end

    # Request of DeleteSubscriber
    #
    # @!attribute [rw] account_id
    #   The `accountId` that is associated with the budget whose subscriber
    #   you want to delete.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   The name of the budget whose subscriber you want to delete.
    #   @return [String]
    #
    # @!attribute [rw] notification
    #   The notification whose subscriber you want to delete.
    #   @return [Types::Notification]
    #
    # @!attribute [rw] subscriber
    #   The subscriber that you want to delete.
    #   @return [Types::Subscriber]
    #
    class DeleteSubscriberRequest < Struct.new(
      :account_id,
      :budget_name,
      :notification,
      :subscriber)
      SENSITIVE = []
      include Aws::Structure
    end

    # Response of DeleteSubscriber
    #
    class DeleteSubscriberResponse < Aws::EmptyStructure; end

    # @!attribute [rw] account_id
    #   The account ID of the user. It's a 12-digit number.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   A string that represents the budget name. The ":" and "\\"
    #   characters, and the "/action/" substring, aren't allowed.
    #   @return [String]
    #
    # @!attribute [rw] action_id
    #   A system-generated universally unique identifier (UUID) for the
    #   action.
    #   @return [String]
    #
    # @!attribute [rw] time_period
    #   The period of time that's covered by a budget. The period has a
    #   start date and an end date. The start date must come before the end
    #   date. There are no restrictions on the end date.
    #   @return [Types::TimePeriod]
    #
    # @!attribute [rw] max_results
    #   An integer that represents how many entries a paginated response
    #   contains. The maximum is 100.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   A generic string.
    #   @return [String]
    #
    class DescribeBudgetActionHistoriesRequest < Struct.new(
      :account_id,
      :budget_name,
      :action_id,
      :time_period,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] action_histories
    #   The historical record of the budget action resource.
    #   @return [Array<Types::ActionHistory>]
    #
    # @!attribute [rw] next_token
    #   A generic string.
    #   @return [String]
    #
    class DescribeBudgetActionHistoriesResponse < Struct.new(
      :action_histories,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] account_id
    #   The account ID of the user. It's a 12-digit number.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   A string that represents the budget name. The ":" and "\\"
    #   characters, and the "/action/" substring, aren't allowed.
    #   @return [String]
    #
    # @!attribute [rw] action_id
    #   A system-generated universally unique identifier (UUID) for the
    #   action.
    #   @return [String]
    #
    class DescribeBudgetActionRequest < Struct.new(
      :account_id,
      :budget_name,
      :action_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] account_id
    #   The account ID of the user. It's a 12-digit number.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   A string that represents the budget name. The ":" and "\\"
    #   characters, and the "/action/" substring, aren't allowed.
    #   @return [String]
    #
    # @!attribute [rw] action
    #   A budget action resource.
    #   @return [Types::Action]
    #
    class DescribeBudgetActionResponse < Struct.new(
      :account_id,
      :budget_name,
      :action)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] account_id
    #   The account ID of the user. It's a 12-digit number.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   An integer that represents how many entries a paginated response
    #   contains. The maximum is 100.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   A generic string.
    #   @return [String]
    #
    class DescribeBudgetActionsForAccountRequest < Struct.new(
      :account_id,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] actions
    #   A list of the budget action resources information.
    #   @return [Array<Types::Action>]
    #
    # @!attribute [rw] next_token
    #   A generic string.
    #   @return [String]
    #
    class DescribeBudgetActionsForAccountResponse < Struct.new(
      :actions,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] account_id
    #   The account ID of the user. It's a 12-digit number.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   A string that represents the budget name. The ":" and "\\"
    #   characters, and the "/action/" substring, aren't allowed.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   An integer that represents how many entries a paginated response
    #   contains. The maximum is 100.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   A generic string.
    #   @return [String]
    #
    class DescribeBudgetActionsForBudgetRequest < Struct.new(
      :account_id,
      :budget_name,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] actions
    #   A list of the budget action resources information.
    #   @return [Array<Types::Action>]
    #
    # @!attribute [rw] next_token
    #   A generic string.
    #   @return [String]
    #
    class DescribeBudgetActionsForBudgetResponse < Struct.new(
      :actions,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] account_id
    #   The account ID of the user. It's a 12-digit number.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   An integer that represents how many budgets a paginated response
    #   contains. The default is 50.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   A generic string.
    #   @return [String]
    #
    class DescribeBudgetNotificationsForAccountRequest < Struct.new(
      :account_id,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] budget_notifications_for_account
    #   A list of budget names and associated notifications for an account.
    #   @return [Array<Types::BudgetNotificationsForAccount>]
    #
    # @!attribute [rw] next_token
    #   A generic string.
    #   @return [String]
    #
    class DescribeBudgetNotificationsForAccountResponse < Struct.new(
      :budget_notifications_for_account,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] account_id
    #   The account ID of the user. It's a 12-digit number.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   A string that represents the budget name. The ":" and "\\"
    #   characters, and the "/action/" substring, aren't allowed.
    #   @return [String]
    #
    # @!attribute [rw] time_period
    #   Retrieves how often the budget went into an `ALARM` state for the
    #   specified time period.
    #   @return [Types::TimePeriod]
    #
    # @!attribute [rw] max_results
    #   An integer that represents how many entries a paginated response
    #   contains. The maximum is 100.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   A generic string.
    #   @return [String]
    #
    class DescribeBudgetPerformanceHistoryRequest < Struct.new(
      :account_id,
      :budget_name,
      :time_period,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] budget_performance_history
    #   The history of how often the budget has gone into an `ALARM` state.
    #
    #   For `DAILY` budgets, the history saves the state of the budget for
    #   the last 60 days. For `MONTHLY` budgets, the history saves the state
    #   of the budget for the current month plus the last 12 months. For
    #   `QUARTERLY` budgets, the history saves the state of the budget for
    #   the last four quarters.
    #   @return [Types::BudgetPerformanceHistory]
    #
    # @!attribute [rw] next_token
    #   A generic string.
    #   @return [String]
    #
    class DescribeBudgetPerformanceHistoryResponse < Struct.new(
      :budget_performance_history,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Request of DescribeBudget
    #
    # @!attribute [rw] account_id
    #   The `accountId` that is associated with the budget that you want a
    #   description of.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   The name of the budget that you want a description of.
    #   @return [String]
    #
    # @!attribute [rw] show_filter_expression
    #   Specifies whether the response includes the filter expression
    #   associated with the budget. By showing the filter expression, you
    #   can see detailed filtering logic applied to the budget, such as
    #   Amazon Web Services services or tags that are being tracked.
    #   @return [Boolean]
    #
    class DescribeBudgetRequest < Struct.new(
      :account_id,
      :budget_name,
      :show_filter_expression)
      SENSITIVE = []
      include Aws::Structure
    end

    # Response of DescribeBudget
    #
    # @!attribute [rw] budget
    #   The description of the budget.
    #   @return [Types::Budget]
    #
    class DescribeBudgetResponse < Struct.new(
      :budget)
      SENSITIVE = []
      include Aws::Structure
    end

    # Request of DescribeBudgets
    #
    # @!attribute [rw] account_id
    #   The `accountId` that is associated with the budgets that you want to
    #   describe.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   An integer that represents how many budgets a paginated response
    #   contains. The default is 100.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The pagination token that you include in your request to indicate
    #   the next set of results that you want to retrieve.
    #   @return [String]
    #
    # @!attribute [rw] show_filter_expression
    #   Specifies whether the response includes the filter expression
    #   associated with the budgets. By showing the filter expression, you
    #   can see detailed filtering logic applied to the budgets, such as
    #   Amazon Web Services services or tags that are being tracked.
    #   @return [Boolean]
    #
    class DescribeBudgetsRequest < Struct.new(
      :account_id,
      :max_results,
      :next_token,
      :show_filter_expression)
      SENSITIVE = []
      include Aws::Structure
    end

    # Response of DescribeBudgets
    #
    # @!attribute [rw] budgets
    #   A list of budgets.
    #   @return [Array<Types::Budget>]
    #
    # @!attribute [rw] next_token
    #   The pagination token in the service response that indicates the next
    #   set of results that you can retrieve.
    #   @return [String]
    #
    class DescribeBudgetsResponse < Struct.new(
      :budgets,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Request of DescribeNotificationsForBudget
    #
    # @!attribute [rw] account_id
    #   The `accountId` that is associated with the budget whose
    #   notifications you want descriptions of.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   The name of the budget whose notifications you want descriptions of.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   An optional integer that represents how many entries a paginated
    #   response contains.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The pagination token that you include in your request to indicate
    #   the next set of results that you want to retrieve.
    #   @return [String]
    #
    class DescribeNotificationsForBudgetRequest < Struct.new(
      :account_id,
      :budget_name,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Response of GetNotificationsForBudget
    #
    # @!attribute [rw] notifications
    #   A list of notifications that are associated with a budget.
    #   @return [Array<Types::Notification>]
    #
    # @!attribute [rw] next_token
    #   The pagination token in the service response that indicates the next
    #   set of results that you can retrieve.
    #   @return [String]
    #
    class DescribeNotificationsForBudgetResponse < Struct.new(
      :notifications,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Request of DescribeSubscribersForNotification
    #
    # @!attribute [rw] account_id
    #   The `accountId` that is associated with the budget whose subscribers
    #   you want descriptions of.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   The name of the budget whose subscribers you want descriptions of.
    #   @return [String]
    #
    # @!attribute [rw] notification
    #   The notification whose subscribers you want to list.
    #   @return [Types::Notification]
    #
    # @!attribute [rw] max_results
    #   An optional integer that represents how many entries a paginated
    #   response contains.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The pagination token that you include in your request to indicate
    #   the next set of results that you want to retrieve.
    #   @return [String]
    #
    class DescribeSubscribersForNotificationRequest < Struct.new(
      :account_id,
      :budget_name,
      :notification,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Response of DescribeSubscribersForNotification
    #
    # @!attribute [rw] subscribers
    #   A list of subscribers that are associated with a notification.
    #   @return [Array<Types::Subscriber>]
    #
    # @!attribute [rw] next_token
    #   The pagination token in the service response that indicates the next
    #   set of results that you can retrieve.
    #   @return [String]
    #
    class DescribeSubscribersForNotificationResponse < Struct.new(
      :subscribers,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # The budget name already exists. Budget names must be unique within an
    # account.
    #
    # @!attribute [rw] message
    #   The error message the exception carries.
    #   @return [String]
    #
    class DuplicateRecordException < Struct.new(
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] account_id
    #   The account ID of the user. It's a 12-digit number.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   A string that represents the budget name. The ":" and "\\"
    #   characters, and the "/action/" substring, aren't allowed.
    #   @return [String]
    #
    # @!attribute [rw] action_id
    #   A system-generated universally unique identifier (UUID) for the
    #   action.
    #   @return [String]
    #
    # @!attribute [rw] execution_type
    #   The type of execution.
    #   @return [String]
    #
    class ExecuteBudgetActionRequest < Struct.new(
      :account_id,
      :budget_name,
      :action_id,
      :execution_type)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] account_id
    #   The account ID of the user. It's a 12-digit number.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   A string that represents the budget name. The ":" and "\\"
    #   characters, and the "/action/" substring, aren't allowed.
    #   @return [String]
    #
    # @!attribute [rw] action_id
    #   A system-generated universally unique identifier (UUID) for the
    #   action.
    #   @return [String]
    #
    # @!attribute [rw] execution_type
    #   The type of execution.
    #   @return [String]
    #
    class ExecuteBudgetActionResponse < Struct.new(
      :account_id,
      :budget_name,
      :action_id,
      :execution_type)
      SENSITIVE = []
      include Aws::Structure
    end

    # The pagination token expired.
    #
    # @!attribute [rw] message
    #   The error message the exception carries.
    #   @return [String]
    #
    class ExpiredNextTokenException < Struct.new(
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Use Expression to filter in various Budgets APIs.
    #
    # @!attribute [rw] or
    #   Return results that match either Dimension object.
    #   @return [Array<Types::Expression>]
    #
    # @!attribute [rw] and
    #   Return results that match both Dimension objects.
    #   @return [Array<Types::Expression>]
    #
    # @!attribute [rw] not
    #   Return results that don't match a Dimension object.
    #   @return [Types::Expression]
    #
    # @!attribute [rw] dimensions
    #   The specific Dimension to use for Expression.
    #   @return [Types::ExpressionDimensionValues]
    #
    # @!attribute [rw] tags
    #   The specific Tag to use for Expression.
    #   @return [Types::TagValues]
    #
    # @!attribute [rw] cost_categories
    #   The filter that's based on CostCategoryValues.
    #   @return [Types::CostCategoryValues]
    #
    class Expression < Struct.new(
      :or,
      :and,
      :not,
      :dimensions,
      :tags,
      :cost_categories)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the specifications for the filters to use for your request.
    #
    # @!attribute [rw] key
    #   The name of the dimension that you want to filter on.
    #   @return [String]
    #
    # @!attribute [rw] values
    #   The metadata values you can specify to filter upon, so that the
    #   results all match at least one of the specified values.
    #   @return [Array<String>]
    #
    # @!attribute [rw] match_options
    #   The match options that you can use to filter your results. You can
    #   specify only one of these values in the array.
    #   @return [Array<String>]
    #
    class ExpressionDimensionValues < Struct.new(
      :key,
      :values,
      :match_options)
      SENSITIVE = []
      include Aws::Structure
    end

    # Provides information about the current operational state of a billing
    # view resource, including its ability to access and update based on its
    # associated billing view.
    #
    # @!attribute [rw] status
    #   The current status of the billing view resource.
    #   @return [String]
    #
    # @!attribute [rw] status_reason
    #   The reason for the current status.
    #
    #   * `BILLING_VIEW_NO_ACCESS`: The billing view resource does not grant
    #     `billing:GetBillingViewData` permission to this account.
    #
    #   * `BILLING_VIEW_UNHEALTHY`: The billing view associated with the
    #     budget is unhealthy.
    #
    #   * `FILTER_INVALID`: The filter contains reference to an account you
    #     do not have access to.
    #   @return [String]
    #
    # @!attribute [rw] last_updated_time
    #   A generic time stamp. In Java, it's transformed to a `Date` object.
    #   @return [Time]
    #
    class HealthStatus < Struct.new(
      :status,
      :status_reason,
      :last_updated_time)
      SENSITIVE = []
      include Aws::Structure
    end

    # The parameters that define or describe the historical data that your
    # auto-adjusting budget is based on.
    #
    # @!attribute [rw] budget_adjustment_period
    #   The number of budget periods included in the moving-average
    #   calculation that determines your auto-adjusted budget amount. The
    #   maximum value depends on the `TimeUnit` granularity of the budget:
    #
    #   * For the `DAILY` granularity, the maximum value is `60`.
    #
    #   * For the `MONTHLY` granularity, the maximum value is `12`.
    #
    #   * For the `QUARTERLY` granularity, the maximum value is `4`.
    #
    #   * For the `ANNUALLY` granularity, the maximum value is `1`.
    #   @return [Integer]
    #
    # @!attribute [rw] look_back_available_periods
    #   The integer that describes how many budget periods in your
    #   `BudgetAdjustmentPeriod` are included in the calculation of your
    #   current `BudgetLimit`. If the first budget period in your
    #   `BudgetAdjustmentPeriod` has no cost data, then that budget period
    #   isn’t included in the average that determines your budget limit.
    #
    #   For example, if you set `BudgetAdjustmentPeriod` as `4` quarters,
    #   but your account had no cost data in the first quarter, then only
    #   the last three quarters are included in the calculation. In this
    #   scenario, `LookBackAvailablePeriods` returns `3`.
    #
    #   You can’t set your own `LookBackAvailablePeriods`. The value is
    #   automatically calculated from the `BudgetAdjustmentPeriod` and your
    #   historical cost data.
    #   @return [Integer]
    #
    class HistoricalOptions < Struct.new(
      :budget_adjustment_period,
      :look_back_available_periods)
      SENSITIVE = []
      include Aws::Structure
    end

    # The Identity and Access Management (IAM) action definition details.
    #
    # @!attribute [rw] policy_arn
    #   The Amazon Resource Name (ARN) of the policy to be attached.
    #   @return [String]
    #
    # @!attribute [rw] roles
    #   A list of roles to be attached. There must be at least one role.
    #   @return [Array<String>]
    #
    # @!attribute [rw] groups
    #   A list of groups to be attached. There must be at least one group.
    #   @return [Array<String>]
    #
    # @!attribute [rw] users
    #   A list of users to be attached. There must be at least one user.
    #   @return [Array<String>]
    #
    class IamActionDefinition < Struct.new(
      :policy_arn,
      :roles,
      :groups,
      :users)
      SENSITIVE = []
      include Aws::Structure
    end

    # An error on the server occurred during the processing of your request.
    # Try again later.
    #
    # @!attribute [rw] message
    #   The error message the exception carries.
    #   @return [String]
    #
    class InternalErrorException < Struct.new(
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # The pagination token is invalid.
    #
    # @!attribute [rw] message
    #   The error message the exception carries.
    #   @return [String]
    #
    class InvalidNextTokenException < Struct.new(
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # An error on the client occurred. Typically, the cause is an invalid
    # input value.
    #
    # @!attribute [rw] message
    #   The error message the exception carries.
    #   @return [String]
    #
    class InvalidParameterException < Struct.new(
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] resource_arn
    #   The unique identifier for the resource.
    #   @return [String]
    #
    class ListTagsForResourceRequest < Struct.new(
      :resource_arn)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] resource_tags
    #   The tags associated with the resource.
    #   @return [Array<Types::ResourceTag>]
    #
    class ListTagsForResourceResponse < Struct.new(
      :resource_tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # We can’t locate the resource that you specified.
    #
    # @!attribute [rw] message
    #   The error message the exception carries.
    #   @return [String]
    #
    class NotFoundException < Struct.new(
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # A notification that's associated with a budget. A budget can have up
    # to ten notifications.
    #
    # Each notification must have at least one subscriber. A notification
    # can have one SNS subscriber and up to 10 email subscribers, for a
    # total of 11 subscribers.
    #
    # For example, if you have a budget for 200 dollars and you want to be
    # notified when you go over 160 dollars, create a notification with the
    # following parameters:
    #
    # * A notificationType of `ACTUAL`
    #
    # * A `thresholdType` of `PERCENTAGE`
    #
    # * A `comparisonOperator` of `GREATER_THAN`
    #
    # * A notification `threshold` of `80`
    #
    # @!attribute [rw] notification_type
    #   Specifies whether the notification is for how much you have spent
    #   (`ACTUAL`) or for how much that you're forecasted to spend
    #   (`FORECASTED`).
    #   @return [String]
    #
    # @!attribute [rw] comparison_operator
    #   The comparison that's used for this notification.
    #   @return [String]
    #
    # @!attribute [rw] threshold
    #   The threshold that's associated with a notification. Thresholds are
    #   always a percentage, and many customers find value being alerted
    #   between 50% - 200% of the budgeted amount. The maximum limit for
    #   your threshold is 1,000,000% above the budgeted amount.
    #   @return [Float]
    #
    # @!attribute [rw] threshold_type
    #   The type of threshold for a notification. For `ABSOLUTE_VALUE`
    #   thresholds, Amazon Web Services notifies you when you go over or are
    #   forecasted to go over your total cost threshold. For `PERCENTAGE`
    #   thresholds, Amazon Web Services notifies you when you go over or are
    #   forecasted to go over a certain percentage of your forecasted spend.
    #   For example, if you have a budget for 200 dollars and you have a
    #   `PERCENTAGE` threshold of 80%, Amazon Web Services notifies you when
    #   you go over 160 dollars.
    #   @return [String]
    #
    # @!attribute [rw] notification_state
    #   Specifies whether this notification is in alarm. If a budget
    #   notification is in the `ALARM` state, you passed the set threshold
    #   for the budget.
    #   @return [String]
    #
    class Notification < Struct.new(
      :notification_type,
      :comparison_operator,
      :threshold,
      :threshold_type,
      :notification_state)
      SENSITIVE = []
      include Aws::Structure
    end

    # A notification with subscribers. A notification can have one SNS
    # subscriber and up to 10 email subscribers, for a total of 11
    # subscribers.
    #
    # @!attribute [rw] notification
    #   The notification that's associated with a budget.
    #   @return [Types::Notification]
    #
    # @!attribute [rw] subscribers
    #   A list of subscribers who are subscribed to this notification.
    #   @return [Array<Types::Subscriber>]
    #
    class NotificationWithSubscribers < Struct.new(
      :notification,
      :subscribers)
      SENSITIVE = []
      include Aws::Structure
    end

    # The request was received and recognized by the server, but the server
    # rejected that particular method for the requested resource.
    #
    # @!attribute [rw] message
    #   The error message the exception carries.
    #   @return [String]
    #
    class ResourceLockedException < Struct.new(
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # The tag structure that contains a tag key and value.
    #
    # @!attribute [rw] key
    #   The key that's associated with the tag.
    #   @return [String]
    #
    # @!attribute [rw] value
    #   The value that's associated with the tag.
    #   @return [String]
    #
    class ResourceTag < Struct.new(
      :key,
      :value)
      SENSITIVE = []
      include Aws::Structure
    end

    # The service control policies (SCP) action definition details.
    #
    # @!attribute [rw] policy_id
    #   The policy ID attached.
    #   @return [String]
    #
    # @!attribute [rw] target_ids
    #   A list of target IDs.
    #   @return [Array<String>]
    #
    class ScpActionDefinition < Struct.new(
      :policy_id,
      :target_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # You've reached the limit on the number of tags you can associate with
    # a resource.
    #
    # @!attribute [rw] message
    #   The error message the exception carries.
    #   @return [String]
    #
    class ServiceQuotaExceededException < Struct.new(
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # The amount of cost or usage that's measured for a budget.
    #
    # *Cost example:* A `Spend` for `3 USD` of costs has the following
    # parameters:
    #
    # * An `Amount` of `3`
    #
    # * A `Unit` of `USD`
    #
    # *Usage example:* A `Spend` for `3 GB` of S3 usage has the following
    # parameters:
    #
    # * An `Amount` of `3`
    #
    # * A `Unit` of `GB`
    #
    # @!attribute [rw] amount
    #   The cost or usage amount that's associated with a budget forecast,
    #   actual spend, or budget threshold.
    #   @return [String]
    #
    # @!attribute [rw] unit
    #   The unit of measurement that's used for the budget forecast, actual
    #   spend, or budget threshold.
    #   @return [String]
    #
    class Spend < Struct.new(
      :amount,
      :unit)
      SENSITIVE = []
      include Aws::Structure
    end

    # The Amazon Web Services Systems Manager (SSM) action definition
    # details.
    #
    # @!attribute [rw] action_sub_type
    #   The action subType.
    #   @return [String]
    #
    # @!attribute [rw] region
    #   The Region to run the SSM document.
    #   @return [String]
    #
    # @!attribute [rw] instance_ids
    #   The EC2 and RDS instance IDs.
    #   @return [Array<String>]
    #
    class SsmActionDefinition < Struct.new(
      :action_sub_type,
      :region,
      :instance_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # The subscriber to a budget notification. The subscriber consists of a
    # subscription type and either an Amazon SNS topic or an email address.
    #
    # For example, an email subscriber has the following parameters:
    #
    # * A `subscriptionType` of `EMAIL`
    #
    # * An `address` of `example@example.com`
    #
    # @!attribute [rw] subscription_type
    #   The type of notification that Amazon Web Services sends to a
    #   subscriber.
    #   @return [String]
    #
    # @!attribute [rw] address
    #   The address that Amazon Web Services sends budget notifications to,
    #   either an SNS topic or an email.
    #
    #   When you create a subscriber, the value of `Address` can't contain
    #   line breaks.
    #   @return [String]
    #
    class Subscriber < Struct.new(
      :subscription_type,
      :address)
      SENSITIVE = [:address]
      include Aws::Structure
    end

    # @!attribute [rw] resource_arn
    #   The unique identifier for the resource.
    #   @return [String]
    #
    # @!attribute [rw] resource_tags
    #   The tags associated with the resource.
    #   @return [Array<Types::ResourceTag>]
    #
    class TagResourceRequest < Struct.new(
      :resource_arn,
      :resource_tags)
      SENSITIVE = []
      include Aws::Structure
    end

    class TagResourceResponse < Aws::EmptyStructure; end

    # The values that are available for a tag.
    #
    # @!attribute [rw] key
    #   The key for the tag.
    #   @return [String]
    #
    # @!attribute [rw] values
    #   The specific value of the tag.
    #   @return [Array<String>]
    #
    # @!attribute [rw] match_options
    #   The match options that you can use to filter your results.
    #   @return [Array<String>]
    #
    class TagValues < Struct.new(
      :key,
      :values,
      :match_options)
      SENSITIVE = []
      include Aws::Structure
    end

    # The number of API requests has exceeded the maximum allowed API
    # request throttling limit for the account.
    #
    # @!attribute [rw] message
    #   The error message the exception carries.
    #   @return [String]
    #
    class ThrottlingException < Struct.new(
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # The period of time that's covered by a budget. The period has a start
    # date and an end date. The start date must come before the end date.
    # There are no restrictions on the end date.
    #
    # @!attribute [rw] start
    #   The start date for a budget. If you created your budget and didn't
    #   specify a start date, Amazon Web Services defaults to the start of
    #   your chosen time period (DAILY, MONTHLY, QUARTERLY, or ANNUALLY).
    #   For example, if you created your budget on January 24, 2018, chose
    #   `DAILY`, and didn't set a start date, Amazon Web Services set your
    #   start date to `01/24/18 00:00 UTC`. If you chose `MONTHLY`, Amazon
    #   Web Services set your start date to `01/01/18 00:00 UTC`. The
    #   defaults are the same for the Billing and Cost Management console
    #   and the API.
    #
    #   You can change your start date with the `UpdateBudget` operation.
    #   @return [Time]
    #
    # @!attribute [rw] end
    #   The end date for a budget. If you didn't specify an end date,
    #   Amazon Web Services set your end date to `06/15/87 00:00 UTC`. The
    #   defaults are the same for the Billing and Cost Management console
    #   and the API.
    #
    #   After the end date, Amazon Web Services deletes the budget and all
    #   the associated notifications and subscribers. You can change your
    #   end date with the `UpdateBudget` operation.
    #   @return [Time]
    #
    class TimePeriod < Struct.new(
      :start,
      :end)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] resource_arn
    #   The unique identifier for the resource.
    #   @return [String]
    #
    # @!attribute [rw] resource_tag_keys
    #   The key that's associated with the tag.
    #   @return [Array<String>]
    #
    class UntagResourceRequest < Struct.new(
      :resource_arn,
      :resource_tag_keys)
      SENSITIVE = []
      include Aws::Structure
    end

    class UntagResourceResponse < Aws::EmptyStructure; end

    # @!attribute [rw] account_id
    #   The account ID of the user. It's a 12-digit number.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   A string that represents the budget name. The ":" and "\\"
    #   characters, and the "/action/" substring, aren't allowed.
    #   @return [String]
    #
    # @!attribute [rw] action_id
    #   A system-generated universally unique identifier (UUID) for the
    #   action.
    #   @return [String]
    #
    # @!attribute [rw] notification_type
    #   The type of a notification. It must be ACTUAL or FORECASTED.
    #   @return [String]
    #
    # @!attribute [rw] action_threshold
    #   The trigger threshold of the action.
    #   @return [Types::ActionThreshold]
    #
    # @!attribute [rw] definition
    #   Specifies all of the type-specific parameters.
    #   @return [Types::Definition]
    #
    # @!attribute [rw] execution_role_arn
    #   The role passed for action execution and reversion. Roles and
    #   actions must be in the same account.
    #   @return [String]
    #
    # @!attribute [rw] approval_model
    #   This specifies if the action needs manual or automatic approval.
    #   @return [String]
    #
    # @!attribute [rw] subscribers
    #   A list of subscribers.
    #   @return [Array<Types::Subscriber>]
    #
    class UpdateBudgetActionRequest < Struct.new(
      :account_id,
      :budget_name,
      :action_id,
      :notification_type,
      :action_threshold,
      :definition,
      :execution_role_arn,
      :approval_model,
      :subscribers)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] account_id
    #   The account ID of the user. It's a 12-digit number.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   A string that represents the budget name. The ":" and "\\"
    #   characters, and the "/action/" substring, aren't allowed.
    #   @return [String]
    #
    # @!attribute [rw] old_action
    #   The previous action resource information.
    #   @return [Types::Action]
    #
    # @!attribute [rw] new_action
    #   The updated action resource information.
    #   @return [Types::Action]
    #
    class UpdateBudgetActionResponse < Struct.new(
      :account_id,
      :budget_name,
      :old_action,
      :new_action)
      SENSITIVE = []
      include Aws::Structure
    end

    # Request of UpdateBudget
    #
    # @!attribute [rw] account_id
    #   The `accountId` that is associated with the budget that you want to
    #   update.
    #   @return [String]
    #
    # @!attribute [rw] new_budget
    #   The budget that you want to update your budget to.
    #   @return [Types::Budget]
    #
    class UpdateBudgetRequest < Struct.new(
      :account_id,
      :new_budget)
      SENSITIVE = []
      include Aws::Structure
    end

    # Response of UpdateBudget
    #
    class UpdateBudgetResponse < Aws::EmptyStructure; end

    # Request of UpdateNotification
    #
    # @!attribute [rw] account_id
    #   The `accountId` that is associated with the budget whose
    #   notification you want to update.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   The name of the budget whose notification you want to update.
    #   @return [String]
    #
    # @!attribute [rw] old_notification
    #   The previous notification that is associated with a budget.
    #   @return [Types::Notification]
    #
    # @!attribute [rw] new_notification
    #   The updated notification to be associated with a budget.
    #   @return [Types::Notification]
    #
    class UpdateNotificationRequest < Struct.new(
      :account_id,
      :budget_name,
      :old_notification,
      :new_notification)
      SENSITIVE = []
      include Aws::Structure
    end

    # Response of UpdateNotification
    #
    class UpdateNotificationResponse < Aws::EmptyStructure; end

    # Request of UpdateSubscriber
    #
    # @!attribute [rw] account_id
    #   The `accountId` that is associated with the budget whose subscriber
    #   you want to update.
    #   @return [String]
    #
    # @!attribute [rw] budget_name
    #   The name of the budget whose subscriber you want to update.
    #   @return [String]
    #
    # @!attribute [rw] notification
    #   The notification whose subscriber you want to update.
    #   @return [Types::Notification]
    #
    # @!attribute [rw] old_subscriber
    #   The previous subscriber that is associated with a budget
    #   notification.
    #   @return [Types::Subscriber]
    #
    # @!attribute [rw] new_subscriber
    #   The updated subscriber that is associated with a budget
    #   notification.
    #   @return [Types::Subscriber]
    #
    class UpdateSubscriberRequest < Struct.new(
      :account_id,
      :budget_name,
      :notification,
      :old_subscriber,
      :new_subscriber)
      SENSITIVE = []
      include Aws::Structure
    end

    # Response of UpdateSubscriber
    #
    class UpdateSubscriberResponse < Aws::EmptyStructure; end

  end
end

