# frozen_string_literal: true

# WARNING ABOUT GENERATED CODE
#
# This file is generated. See the contributing guide for more information:
# https://github.com/aws/aws-sdk-ruby/blob/version-3/CONTRIBUTING.md
#
# WARNING ABOUT GENERATED CODE

require 'seahorse/client/plugins/content_length'
require 'aws-sdk-core/plugins/credentials_configuration'
require 'aws-sdk-core/plugins/logging'
require 'aws-sdk-core/plugins/param_converter'
require 'aws-sdk-core/plugins/param_validator'
require 'aws-sdk-core/plugins/user_agent'
require 'aws-sdk-core/plugins/helpful_socket_errors'
require 'aws-sdk-core/plugins/retry_errors'
require 'aws-sdk-core/plugins/global_configuration'
require 'aws-sdk-core/plugins/regional_endpoint'
require 'aws-sdk-core/plugins/endpoint_discovery'
require 'aws-sdk-core/plugins/endpoint_pattern'
require 'aws-sdk-core/plugins/response_paging'
require 'aws-sdk-core/plugins/stub_responses'
require 'aws-sdk-core/plugins/idempotency_token'
require 'aws-sdk-core/plugins/invocation_id'
require 'aws-sdk-core/plugins/jsonvalue_converter'
require 'aws-sdk-core/plugins/client_metrics_plugin'
require 'aws-sdk-core/plugins/client_metrics_send_plugin'
require 'aws-sdk-core/plugins/transfer_encoding'
require 'aws-sdk-core/plugins/http_checksum'
require 'aws-sdk-core/plugins/checksum_algorithm'
require 'aws-sdk-core/plugins/request_compression'
require 'aws-sdk-core/plugins/defaults_mode'
require 'aws-sdk-core/plugins/recursion_detection'
require 'aws-sdk-core/plugins/telemetry'
require 'aws-sdk-core/plugins/sign'
require 'aws-sdk-core/plugins/protocols/ec2'
require 'aws-sdk-ec2/plugins/copy_encrypted_snapshot'
require 'aws-sdk-ec2/plugins/region_validation'

module Aws::EC2
  # An API client for EC2.  To construct a client, you need to configure a `:region` and `:credentials`.
  #
  #     client = Aws::EC2::Client.new(
  #       region: region_name,
  #       credentials: credentials,
  #       # ...
  #     )
  #
  # For details on configuring region and credentials see
  # the [developer guide](/sdk-for-ruby/v3/developer-guide/setup-config.html).
  #
  # See {#initialize} for a full list of supported configuration options.
  class Client < Seahorse::Client::Base

    include Aws::ClientStubs

    @identifier = :ec2

    set_api(ClientApi::API)

    add_plugin(Seahorse::Client::Plugins::ContentLength)
    add_plugin(Aws::Plugins::CredentialsConfiguration)
    add_plugin(Aws::Plugins::Logging)
    add_plugin(Aws::Plugins::ParamConverter)
    add_plugin(Aws::Plugins::ParamValidator)
    add_plugin(Aws::Plugins::UserAgent)
    add_plugin(Aws::Plugins::HelpfulSocketErrors)
    add_plugin(Aws::Plugins::RetryErrors)
    add_plugin(Aws::Plugins::GlobalConfiguration)
    add_plugin(Aws::Plugins::RegionalEndpoint)
    add_plugin(Aws::Plugins::EndpointDiscovery)
    add_plugin(Aws::Plugins::EndpointPattern)
    add_plugin(Aws::Plugins::ResponsePaging)
    add_plugin(Aws::Plugins::StubResponses)
    add_plugin(Aws::Plugins::IdempotencyToken)
    add_plugin(Aws::Plugins::InvocationId)
    add_plugin(Aws::Plugins::JsonvalueConverter)
    add_plugin(Aws::Plugins::ClientMetricsPlugin)
    add_plugin(Aws::Plugins::ClientMetricsSendPlugin)
    add_plugin(Aws::Plugins::TransferEncoding)
    add_plugin(Aws::Plugins::HttpChecksum)
    add_plugin(Aws::Plugins::ChecksumAlgorithm)
    add_plugin(Aws::Plugins::RequestCompression)
    add_plugin(Aws::Plugins::DefaultsMode)
    add_plugin(Aws::Plugins::RecursionDetection)
    add_plugin(Aws::Plugins::Telemetry)
    add_plugin(Aws::Plugins::Sign)
    add_plugin(Aws::Plugins::Protocols::EC2)
    add_plugin(Aws::EC2::Plugins::CopyEncryptedSnapshot)
    add_plugin(Aws::EC2::Plugins::RegionValidation)
    add_plugin(Aws::EC2::Plugins::Endpoints)

    # @overload initialize(options)
    #   @param [Hash] options
    #
    #   @option options [Array<Seahorse::Client::Plugin>] :plugins ([]])
    #     A list of plugins to apply to the client. Each plugin is either a
    #     class name or an instance of a plugin class.
    #
    #   @option options [required, Aws::CredentialProvider] :credentials
    #     Your AWS credentials used for authentication. This can be any class that includes and implements
    #     `Aws::CredentialProvider`, or instance of any one of the following classes:
    #
    #     * `Aws::Credentials` - Used for configuring static, non-refreshing
    #       credentials.
    #
    #     * `Aws::SharedCredentials` - Used for loading static credentials from a
    #       shared file, such as `~/.aws/config`.
    #
    #     * `Aws::AssumeRoleCredentials` - Used when you need to assume a role.
    #
    #     * `Aws::AssumeRoleWebIdentityCredentials` - Used when you need to
    #       assume a role after providing credentials via the web.
    #
    #     * `Aws::SSOCredentials` - Used for loading credentials from AWS SSO using an
    #       access token generated from `aws login`.
    #
    #     * `Aws::ProcessCredentials` - Used for loading credentials from a
    #       process that outputs to stdout.
    #
    #     * `Aws::InstanceProfileCredentials` - Used for loading credentials
    #       from an EC2 IMDS on an EC2 instance.
    #
    #     * `Aws::ECSCredentials` - Used for loading credentials from
    #       instances running in ECS.
    #
    #     * `Aws::CognitoIdentityCredentials` - Used for loading credentials
    #       from the Cognito Identity service.
    #
    #     When `:credentials` are not configured directly, the following locations will be searched for credentials:
    #
    #     * `Aws.config[:credentials]`
    #
    #     * The `:access_key_id`, `:secret_access_key`, `:session_token`, and
    #       `:account_id` options.
    #
    #     * `ENV['AWS_ACCESS_KEY_ID']`, `ENV['AWS_SECRET_ACCESS_KEY']`,
    #       `ENV['AWS_SESSION_TOKEN']`, and `ENV['AWS_ACCOUNT_ID']`.
    #
    #     * `~/.aws/credentials`
    #
    #     * `~/.aws/config`
    #
    #     * EC2/ECS IMDS instance profile - When used by default, the timeouts are very aggressive.
    #       Construct and pass an instance of `Aws::InstanceProfileCredentials` or `Aws::ECSCredentials` to
    #       enable retries and extended timeouts. Instance profile credential fetching can be disabled by
    #       setting `ENV['AWS_EC2_METADATA_DISABLED']` to `true`.
    #
    #   @option options [required, String] :region
    #     The AWS region to connect to.  The configured `:region` is
    #     used to determine the service `:endpoint`. When not passed,
    #     a default `:region` is searched for in the following locations:
    #
    #     * `Aws.config[:region]`
    #     * `ENV['AWS_REGION']`
    #     * `ENV['AMAZON_REGION']`
    #     * `ENV['AWS_DEFAULT_REGION']`
    #     * `~/.aws/credentials`
    #     * `~/.aws/config`
    #
    #   @option options [String] :access_key_id
    #
    #   @option options [String] :account_id
    #
    #   @option options [Boolean] :active_endpoint_cache (false)
    #     When set to `true`, a thread polling for endpoints will be running in
    #     the background every 60 secs (default). Defaults to `false`.
    #
    #   @option options [Boolean] :adaptive_retry_wait_to_fill (true)
    #     Used only in `adaptive` retry mode.  When true, the request will sleep
    #     until there is sufficent client side capacity to retry the request.
    #     When false, the request will raise a `RetryCapacityNotAvailableError` and will
    #     not retry instead of sleeping.
    #
    #   @option options [Array<String>] :auth_scheme_preference
    #     A list of preferred authentication schemes to use when making a request. Supported values are:
    #     `sigv4`, `sigv4a`, `httpBearerAuth`, and `noAuth`. When set using `ENV['AWS_AUTH_SCHEME_PREFERENCE']` or in
    #     shared config as `auth_scheme_preference`, the value should be a comma-separated list.
    #
    #   @option options [Boolean] :client_side_monitoring (false)
    #     When `true`, client-side metrics will be collected for all API requests from
    #     this client.
    #
    #   @option options [String] :client_side_monitoring_client_id ("")
    #     Allows you to provide an identifier for this client which will be attached to
    #     all generated client side metrics. Defaults to an empty string.
    #
    #   @option options [String] :client_side_monitoring_host ("127.0.0.1")
    #     Allows you to specify the DNS hostname or IPv4 or IPv6 address that the client
    #     side monitoring agent is running on, where client metrics will be published via UDP.
    #
    #   @option options [Integer] :client_side_monitoring_port (31000)
    #     Required for publishing client metrics. The port that the client side monitoring
    #     agent is running on, where client metrics will be published via UDP.
    #
    #   @option options [Aws::ClientSideMonitoring::Publisher] :client_side_monitoring_publisher (Aws::ClientSideMonitoring::Publisher)
    #     Allows you to provide a custom client-side monitoring publisher class. By default,
    #     will use the Client Side Monitoring Agent Publisher.
    #
    #   @option options [Boolean] :convert_params (true)
    #     When `true`, an attempt is made to coerce request parameters into
    #     the required types.
    #
    #   @option options [Boolean] :correct_clock_skew (true)
    #     Used only in `standard` and adaptive retry modes. Specifies whether to apply
    #     a clock skew correction and retry requests with skewed client clocks.
    #
    #   @option options [String] :defaults_mode ("legacy")
    #     See {Aws::DefaultsModeConfiguration} for a list of the
    #     accepted modes and the configuration defaults that are included.
    #
    #   @option options [Boolean] :disable_host_prefix_injection (false)
    #     When `true`, the SDK will not prepend the modeled host prefix to the endpoint.
    #
    #   @option options [Boolean] :disable_request_compression (false)
    #     When set to 'true' the request body will not be compressed
    #     for supported operations.
    #
    #   @option options [String, URI::HTTPS, URI::HTTP] :endpoint
    #     Normally you should not configure the `:endpoint` option
    #     directly. This is normally constructed from the `:region`
    #     option. Configuring `:endpoint` is normally reserved for
    #     connecting to test or custom endpoints. The endpoint should
    #     be a URI formatted like:
    #
    #         'http://example.com'
    #         'https://example.com'
    #         'http://example.com:123'
    #
    #   @option options [Integer] :endpoint_cache_max_entries (1000)
    #     Used for the maximum size limit of the LRU cache storing endpoints data
    #     for endpoint discovery enabled operations. Defaults to 1000.
    #
    #   @option options [Integer] :endpoint_cache_max_threads (10)
    #     Used for the maximum threads in use for polling endpoints to be cached, defaults to 10.
    #
    #   @option options [Integer] :endpoint_cache_poll_interval (60)
    #     When :endpoint_discovery and :active_endpoint_cache is enabled,
    #     Use this option to config the time interval in seconds for making
    #     requests fetching endpoints information. Defaults to 60 sec.
    #
    #   @option options [Boolean] :endpoint_discovery (false)
    #     When set to `true`, endpoint discovery will be enabled for operations when available.
    #
    #   @option options [Boolean] :ignore_configured_endpoint_urls
    #     Setting to true disables use of endpoint URLs provided via environment
    #     variables and the shared configuration file.
    #
    #   @option options [Aws::Log::Formatter] :log_formatter (Aws::Log::Formatter.default)
    #     The log formatter.
    #
    #   @option options [Symbol] :log_level (:info)
    #     The log level to send messages to the `:logger` at.
    #
    #   @option options [Logger] :logger
    #     The Logger instance to send log messages to.  If this option
    #     is not set, logging will be disabled.
    #
    #   @option options [Integer] :max_attempts (3)
    #     An integer representing the maximum number attempts that will be made for
    #     a single request, including the initial attempt.  For example,
    #     setting this value to 5 will result in a request being retried up to
    #     4 times. Used in `standard` and `adaptive` retry modes.
    #
    #   @option options [String] :profile ("default")
    #     Used when loading credentials from the shared credentials file at `HOME/.aws/credentials`.
    #     When not specified, 'default' is used.
    #
    #   @option options [String] :request_checksum_calculation ("when_supported")
    #     Determines when a checksum will be calculated for request payloads. Values are:
    #
    #     * `when_supported` - (default) When set, a checksum will be
    #       calculated for all request payloads of operations modeled with the
    #       `httpChecksum` trait where `requestChecksumRequired` is `true` and/or a
    #       `requestAlgorithmMember` is modeled.
    #     * `when_required` - When set, a checksum will only be calculated for
    #       request payloads of operations modeled with the  `httpChecksum` trait where
    #       `requestChecksumRequired` is `true` or where a `requestAlgorithmMember`
    #       is modeled and supplied.
    #
    #   @option options [Integer] :request_min_compression_size_bytes (10240)
    #     The minimum size in bytes that triggers compression for request
    #     bodies. The value must be non-negative integer value between 0
    #     and 10485780 bytes inclusive.
    #
    #   @option options [String] :response_checksum_validation ("when_supported")
    #     Determines when checksum validation will be performed on response payloads. Values are:
    #
    #     * `when_supported` - (default) When set, checksum validation is performed on all
    #       response payloads of operations modeled with the `httpChecksum` trait where
    #       `responseAlgorithms` is modeled, except when no modeled checksum algorithms
    #       are supported.
    #     * `when_required` - When set, checksum validation is not performed on
    #       response payloads of operations unless the checksum algorithm is supported and
    #       the `requestValidationModeMember` member is set to `ENABLED`.
    #
    #   @option options [Proc] :retry_backoff
    #     A proc or lambda used for backoff. Defaults to 2**retries * retry_base_delay.
    #     This option is only used in the `legacy` retry mode.
    #
    #   @option options [Float] :retry_base_delay (0.3)
    #     The base delay in seconds used by the default backoff function. This option
    #     is only used in the `legacy` retry mode.
    #
    #   @option options [Symbol] :retry_jitter (:none)
    #     A delay randomiser function used by the default backoff function.
    #     Some predefined functions can be referenced by name - :none, :equal, :full,
    #     otherwise a Proc that takes and returns a number. This option is only used
    #     in the `legacy` retry mode.
    #
    #     @see https://www.awsarchitectureblog.com/2015/03/backoff.html
    #
    #   @option options [Integer] :retry_limit (3)
    #     The maximum number of times to retry failed requests.  Only
    #     ~ 500 level server errors and certain ~ 400 level client errors
    #     are retried.  Generally, these are throttling errors, data
    #     checksum errors, networking errors, timeout errors, auth errors,
    #     endpoint discovery, and errors from expired credentials.
    #     This option is only used in the `legacy` retry mode.
    #
    #   @option options [Integer] :retry_max_delay (0)
    #     The maximum number of seconds to delay between retries (0 for no limit)
    #     used by the default backoff function. This option is only used in the
    #     `legacy` retry mode.
    #
    #   @option options [String] :retry_mode ("legacy")
    #     Specifies which retry algorithm to use. Values are:
    #
    #     * `legacy` - The pre-existing retry behavior.  This is default value if
    #       no retry mode is provided.
    #
    #     * `standard` - A standardized set of retry rules across the AWS SDKs.
    #       This includes support for retry quotas, which limit the number of
    #       unsuccessful retries a client can make.
    #
    #     * `adaptive` - An experimental retry mode that includes all the
    #       functionality of `standard` mode along with automatic client side
    #       throttling.  This is a provisional mode that may change behavior
    #       in the future.
    #
    #   @option options [String] :sdk_ua_app_id
    #     A unique and opaque application ID that is appended to the
    #     User-Agent header as app/sdk_ua_app_id. It should have a
    #     maximum length of 50. This variable is sourced from environment
    #     variable AWS_SDK_UA_APP_ID or the shared config profile attribute sdk_ua_app_id.
    #
    #   @option options [String] :secret_access_key
    #
    #   @option options [String] :session_token
    #
    #   @option options [Array] :sigv4a_signing_region_set
    #     A list of regions that should be signed with SigV4a signing. When
    #     not passed, a default `:sigv4a_signing_region_set` is searched for
    #     in the following locations:
    #
    #     * `Aws.config[:sigv4a_signing_region_set]`
    #     * `ENV['AWS_SIGV4A_SIGNING_REGION_SET']`
    #     * `~/.aws/config`
    #
    #   @option options [Boolean] :stub_responses (false)
    #     Causes the client to return stubbed responses. By default
    #     fake responses are generated and returned. You can specify
    #     the response data to return or errors to raise by calling
    #     {ClientStubs#stub_responses}. See {ClientStubs} for more information.
    #
    #     ** Please note ** When response stubbing is enabled, no HTTP
    #     requests are made, and retries are disabled.
    #
    #   @option options [Aws::Telemetry::TelemetryProviderBase] :telemetry_provider (Aws::Telemetry::NoOpTelemetryProvider)
    #     Allows you to provide a telemetry provider, which is used to
    #     emit telemetry data. By default, uses `NoOpTelemetryProvider` which
    #     will not record or emit any telemetry data. The SDK supports the
    #     following telemetry providers:
    #
    #     * OpenTelemetry (OTel) - To use the OTel provider, install and require the
    #     `opentelemetry-sdk` gem and then, pass in an instance of a
    #     `Aws::Telemetry::OTelProvider` for telemetry provider.
    #
    #   @option options [Aws::TokenProvider] :token_provider
    #     Your Bearer token used for authentication. This can be any class that includes and implements
    #     `Aws::TokenProvider`, or instance of any one of the following classes:
    #
    #     * `Aws::StaticTokenProvider` - Used for configuring static, non-refreshing
    #       tokens.
    #
    #     * `Aws::SSOTokenProvider` - Used for loading tokens from AWS SSO using an
    #       access token generated from `aws login`.
    #
    #     When `:token_provider` is not configured directly, the `Aws::TokenProviderChain`
    #     will be used to search for tokens configured for your profile in shared configuration files.
    #
    #   @option options [Boolean] :use_dualstack_endpoint
    #     When set to `true`, dualstack enabled endpoints (with `.aws` TLD)
    #     will be used if available.
    #
    #   @option options [Boolean] :use_fips_endpoint
    #     When set to `true`, fips compatible endpoints will be used if available.
    #     When a `fips` region is used, the region is normalized and this config
    #     is set to `true`.
    #
    #   @option options [Boolean] :validate_params (true)
    #     When `true`, request parameters are validated before
    #     sending the request.
    #
    #   @option options [Aws::EC2::EndpointProvider] :endpoint_provider
    #     The endpoint provider used to resolve endpoints. Any object that responds to
    #     `#resolve_endpoint(parameters)` where `parameters` is a Struct similar to
    #     `Aws::EC2::EndpointParameters`.
    #
    #   @option options [Float] :http_continue_timeout (1)
    #     The number of seconds to wait for a 100-continue response before sending the
    #     request body.  This option has no effect unless the request has "Expect"
    #     header set to "100-continue".  Defaults to `nil` which  disables this
    #     behaviour.  This value can safely be set per request on the session.
    #
    #   @option options [Float] :http_idle_timeout (5)
    #     The number of seconds a connection is allowed to sit idle before it
    #     is considered stale.  Stale connections are closed and removed from the
    #     pool before making a request.
    #
    #   @option options [Float] :http_open_timeout (15)
    #     The default number of seconds to wait for response data.
    #     This value can safely be set per-request on the session.
    #
    #   @option options [URI::HTTP,String] :http_proxy
    #     A proxy to send requests through.  Formatted like 'http://proxy.com:123'.
    #
    #   @option options [Float] :http_read_timeout (60)
    #     The default number of seconds to wait for response data.
    #     This value can safely be set per-request on the session.
    #
    #   @option options [Boolean] :http_wire_trace (false)
    #     When `true`,  HTTP debug output will be sent to the `:logger`.
    #
    #   @option options [Proc] :on_chunk_received
    #     When a Proc object is provided, it will be used as callback when each chunk
    #     of the response body is received. It provides three arguments: the chunk,
    #     the number of bytes received, and the total number of
    #     bytes in the response (or nil if the server did not send a `content-length`).
    #
    #   @option options [Proc] :on_chunk_sent
    #     When a Proc object is provided, it will be used as callback when each chunk
    #     of the request body is sent. It provides three arguments: the chunk,
    #     the number of bytes read from the body, and the total number of
    #     bytes in the body.
    #
    #   @option options [Boolean] :raise_response_errors (true)
    #     When `true`, response errors are raised.
    #
    #   @option options [String] :ssl_ca_bundle
    #     Full path to the SSL certificate authority bundle file that should be used when
    #     verifying peer certificates.  If you do not pass `:ssl_ca_bundle` or
    #     `:ssl_ca_directory` the the system default will be used if available.
    #
    #   @option options [String] :ssl_ca_directory
    #     Full path of the directory that contains the unbundled SSL certificate
    #     authority files for verifying peer certificates.  If you do
    #     not pass `:ssl_ca_bundle` or `:ssl_ca_directory` the the system
    #     default will be used if available.
    #
    #   @option options [String] :ssl_ca_store
    #     Sets the X509::Store to verify peer certificate.
    #
    #   @option options [OpenSSL::X509::Certificate] :ssl_cert
    #     Sets a client certificate when creating http connections.
    #
    #   @option options [OpenSSL::PKey] :ssl_key
    #     Sets a client key when creating http connections.
    #
    #   @option options [Float] :ssl_timeout
    #     Sets the SSL timeout in seconds
    #
    #   @option options [Boolean] :ssl_verify_peer (true)
    #     When `true`, SSL peer certificates are verified when establishing a connection.
    #
    def initialize(*args)
      super
    end

    # @!group API Operations

    # Accepts an Elastic IP address transfer. For more information, see
    # [Accept a transferred Elastic IP address][1] in the *Amazon VPC User
    # Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#using-instance-addressing-eips-transfer-accept
    #
    # @option params [required, String] :address
    #   The Elastic IP address you are accepting for transfer.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   `tag`:&lt;key&gt; - The key/value combination of a tag assigned to the
    #   resource. Use the tag key in the filter name and the tag value as the
    #   filter value. For example, to find all resources that have a tag with
    #   the key `Owner` and the value `TeamA`, specify `tag:Owner` for the
    #   filter name and `TeamA` for the filter value.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AcceptAddressTransferResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AcceptAddressTransferResult#address_transfer #address_transfer} => Types::AddressTransfer
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.accept_address_transfer({
    #     address: "String", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.address_transfer.public_ip #=> String
    #   resp.address_transfer.allocation_id #=> String
    #   resp.address_transfer.transfer_account_id #=> String
    #   resp.address_transfer.transfer_offer_expiration_timestamp #=> Time
    #   resp.address_transfer.transfer_offer_accepted_timestamp #=> Time
    #   resp.address_transfer.address_transfer_status #=> String, one of "pending", "disabled", "accepted"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptAddressTransfer AWS API Documentation
    #
    # @overload accept_address_transfer(params = {})
    # @param [Hash] params ({})
    def accept_address_transfer(params = {}, options = {})
      req = build_request(:accept_address_transfer, params)
      req.send_request(options)
    end

    # Accepts a request to assign billing of the available capacity of a
    # shared Capacity Reservation to your account. For more information, see
    # [ Billing assignment for shared Amazon EC2 Capacity Reservations][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/assign-billing.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :capacity_reservation_id
    #   The ID of the Capacity Reservation for which to accept the request.
    #
    # @return [Types::AcceptCapacityReservationBillingOwnershipResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AcceptCapacityReservationBillingOwnershipResult#return #return} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.accept_capacity_reservation_billing_ownership({
    #     dry_run: false,
    #     capacity_reservation_id: "CapacityReservationId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptCapacityReservationBillingOwnership AWS API Documentation
    #
    # @overload accept_capacity_reservation_billing_ownership(params = {})
    # @param [Hash] params ({})
    def accept_capacity_reservation_billing_ownership(params = {}, options = {})
      req = build_request(:accept_capacity_reservation_billing_ownership, params)
      req.send_request(options)
    end

    # Accepts the Convertible Reserved Instance exchange quote described in
    # the GetReservedInstancesExchangeQuote call.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :reserved_instance_ids
    #   The IDs of the Convertible Reserved Instances to exchange for another
    #   Convertible Reserved Instance of the same or higher value.
    #
    # @option params [Array<Types::TargetConfigurationRequest>] :target_configurations
    #   The configuration of the target Convertible Reserved Instance to
    #   exchange for your current Convertible Reserved Instances.
    #
    # @return [Types::AcceptReservedInstancesExchangeQuoteResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AcceptReservedInstancesExchangeQuoteResult#exchange_id #exchange_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.accept_reserved_instances_exchange_quote({
    #     dry_run: false,
    #     reserved_instance_ids: ["ReservationId"], # required
    #     target_configurations: [
    #       {
    #         instance_count: 1,
    #         offering_id: "ReservedInstancesOfferingId", # required
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.exchange_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuote AWS API Documentation
    #
    # @overload accept_reserved_instances_exchange_quote(params = {})
    # @param [Hash] params ({})
    def accept_reserved_instances_exchange_quote(params = {}, options = {})
      req = build_request(:accept_reserved_instances_exchange_quote, params)
      req.send_request(options)
    end

    # Accepts a request to associate subnets with a transit gateway
    # multicast domain.
    #
    # @option params [String] :transit_gateway_multicast_domain_id
    #   The ID of the transit gateway multicast domain.
    #
    # @option params [String] :transit_gateway_attachment_id
    #   The ID of the transit gateway attachment.
    #
    # @option params [Array<String>] :subnet_ids
    #   The IDs of the subnets to associate with the transit gateway multicast
    #   domain.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AcceptTransitGatewayMulticastDomainAssociationsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AcceptTransitGatewayMulticastDomainAssociationsResult#associations #associations} => Types::TransitGatewayMulticastDomainAssociations
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.accept_transit_gateway_multicast_domain_associations({
    #     transit_gateway_multicast_domain_id: "TransitGatewayMulticastDomainId",
    #     transit_gateway_attachment_id: "TransitGatewayAttachmentId",
    #     subnet_ids: ["String"],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.associations.transit_gateway_multicast_domain_id #=> String
    #   resp.associations.transit_gateway_attachment_id #=> String
    #   resp.associations.resource_id #=> String
    #   resp.associations.resource_type #=> String, one of "vpc", "vpn", "direct-connect-gateway", "connect", "peering", "tgw-peering", "network-function"
    #   resp.associations.resource_owner_id #=> String
    #   resp.associations.subnets #=> Array
    #   resp.associations.subnets[0].subnet_id #=> String
    #   resp.associations.subnets[0].state #=> String, one of "pendingAcceptance", "associating", "associated", "disassociating", "disassociated", "rejected", "failed"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayMulticastDomainAssociations AWS API Documentation
    #
    # @overload accept_transit_gateway_multicast_domain_associations(params = {})
    # @param [Hash] params ({})
    def accept_transit_gateway_multicast_domain_associations(params = {}, options = {})
      req = build_request(:accept_transit_gateway_multicast_domain_associations, params)
      req.send_request(options)
    end

    # Accepts a transit gateway peering attachment request. The peering
    # attachment must be in the `pendingAcceptance` state.
    #
    # @option params [required, String] :transit_gateway_attachment_id
    #   The ID of the transit gateway attachment.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AcceptTransitGatewayPeeringAttachmentResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AcceptTransitGatewayPeeringAttachmentResult#transit_gateway_peering_attachment #transit_gateway_peering_attachment} => Types::TransitGatewayPeeringAttachment
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.accept_transit_gateway_peering_attachment({
    #     transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_peering_attachment.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_peering_attachment.accepter_transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_peering_attachment.requester_tgw_info.transit_gateway_id #=> String
    #   resp.transit_gateway_peering_attachment.requester_tgw_info.core_network_id #=> String
    #   resp.transit_gateway_peering_attachment.requester_tgw_info.owner_id #=> String
    #   resp.transit_gateway_peering_attachment.requester_tgw_info.region #=> String
    #   resp.transit_gateway_peering_attachment.accepter_tgw_info.transit_gateway_id #=> String
    #   resp.transit_gateway_peering_attachment.accepter_tgw_info.core_network_id #=> String
    #   resp.transit_gateway_peering_attachment.accepter_tgw_info.owner_id #=> String
    #   resp.transit_gateway_peering_attachment.accepter_tgw_info.region #=> String
    #   resp.transit_gateway_peering_attachment.options.dynamic_routing #=> String, one of "enable", "disable"
    #   resp.transit_gateway_peering_attachment.status.code #=> String
    #   resp.transit_gateway_peering_attachment.status.message #=> String
    #   resp.transit_gateway_peering_attachment.state #=> String, one of "initiating", "initiatingRequest", "pendingAcceptance", "rollingBack", "pending", "available", "modifying", "deleting", "deleted", "failed", "rejected", "rejecting", "failing"
    #   resp.transit_gateway_peering_attachment.creation_time #=> Time
    #   resp.transit_gateway_peering_attachment.tags #=> Array
    #   resp.transit_gateway_peering_attachment.tags[0].key #=> String
    #   resp.transit_gateway_peering_attachment.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayPeeringAttachment AWS API Documentation
    #
    # @overload accept_transit_gateway_peering_attachment(params = {})
    # @param [Hash] params ({})
    def accept_transit_gateway_peering_attachment(params = {}, options = {})
      req = build_request(:accept_transit_gateway_peering_attachment, params)
      req.send_request(options)
    end

    # Accepts a request to attach a VPC to a transit gateway.
    #
    # The VPC attachment must be in the `pendingAcceptance` state. Use
    # DescribeTransitGatewayVpcAttachments to view your pending VPC
    # attachment requests. Use RejectTransitGatewayVpcAttachment to reject a
    # VPC attachment request.
    #
    # @option params [required, String] :transit_gateway_attachment_id
    #   The ID of the attachment.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AcceptTransitGatewayVpcAttachmentResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AcceptTransitGatewayVpcAttachmentResult#transit_gateway_vpc_attachment #transit_gateway_vpc_attachment} => Types::TransitGatewayVpcAttachment
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.accept_transit_gateway_vpc_attachment({
    #     transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_vpc_attachment.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_vpc_attachment.transit_gateway_id #=> String
    #   resp.transit_gateway_vpc_attachment.vpc_id #=> String
    #   resp.transit_gateway_vpc_attachment.vpc_owner_id #=> String
    #   resp.transit_gateway_vpc_attachment.state #=> String, one of "initiating", "initiatingRequest", "pendingAcceptance", "rollingBack", "pending", "available", "modifying", "deleting", "deleted", "failed", "rejected", "rejecting", "failing"
    #   resp.transit_gateway_vpc_attachment.subnet_ids #=> Array
    #   resp.transit_gateway_vpc_attachment.subnet_ids[0] #=> String
    #   resp.transit_gateway_vpc_attachment.creation_time #=> Time
    #   resp.transit_gateway_vpc_attachment.options.dns_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachment.options.security_group_referencing_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachment.options.ipv_6_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachment.options.appliance_mode_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_vpc_attachment.tags #=> Array
    #   resp.transit_gateway_vpc_attachment.tags[0].key #=> String
    #   resp.transit_gateway_vpc_attachment.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayVpcAttachment AWS API Documentation
    #
    # @overload accept_transit_gateway_vpc_attachment(params = {})
    # @param [Hash] params ({})
    def accept_transit_gateway_vpc_attachment(params = {}, options = {})
      req = build_request(:accept_transit_gateway_vpc_attachment, params)
      req.send_request(options)
    end

    # Accepts connection requests to your VPC endpoint service.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :service_id
    #   The ID of the VPC endpoint service.
    #
    # @option params [required, Array<String>] :vpc_endpoint_ids
    #   The IDs of the interface VPC endpoints.
    #
    # @return [Types::AcceptVpcEndpointConnectionsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AcceptVpcEndpointConnectionsResult#unsuccessful #unsuccessful} => Array&lt;Types::UnsuccessfulItem&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.accept_vpc_endpoint_connections({
    #     dry_run: false,
    #     service_id: "VpcEndpointServiceId", # required
    #     vpc_endpoint_ids: ["VpcEndpointId"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.unsuccessful #=> Array
    #   resp.unsuccessful[0].error.code #=> String
    #   resp.unsuccessful[0].error.message #=> String
    #   resp.unsuccessful[0].resource_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnections AWS API Documentation
    #
    # @overload accept_vpc_endpoint_connections(params = {})
    # @param [Hash] params ({})
    def accept_vpc_endpoint_connections(params = {}, options = {})
      req = build_request(:accept_vpc_endpoint_connections, params)
      req.send_request(options)
    end

    # Accept a VPC peering connection request. To accept a request, the VPC
    # peering connection must be in the `pending-acceptance` state, and you
    # must be the owner of the peer VPC. Use DescribeVpcPeeringConnections
    # to view your outstanding VPC peering connection requests.
    #
    # For an inter-Region VPC peering connection request, you must accept
    # the VPC peering connection in the Region of the accepter VPC.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :vpc_peering_connection_id
    #   The ID of the VPC peering connection. You must specify this parameter
    #   in the request.
    #
    # @return [Types::AcceptVpcPeeringConnectionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AcceptVpcPeeringConnectionResult#vpc_peering_connection #vpc_peering_connection} => Types::VpcPeeringConnection
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.accept_vpc_peering_connection({
    #     dry_run: false,
    #     vpc_peering_connection_id: "VpcPeeringConnectionIdWithResolver", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.vpc_peering_connection.accepter_vpc_info.cidr_block #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.ipv_6_cidr_block_set #=> Array
    #   resp.vpc_peering_connection.accepter_vpc_info.ipv_6_cidr_block_set[0].ipv_6_cidr_block #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.cidr_block_set #=> Array
    #   resp.vpc_peering_connection.accepter_vpc_info.cidr_block_set[0].cidr_block #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.owner_id #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.peering_options.allow_dns_resolution_from_remote_vpc #=> Boolean
    #   resp.vpc_peering_connection.accepter_vpc_info.peering_options.allow_egress_from_local_classic_link_to_remote_vpc #=> Boolean
    #   resp.vpc_peering_connection.accepter_vpc_info.peering_options.allow_egress_from_local_vpc_to_remote_classic_link #=> Boolean
    #   resp.vpc_peering_connection.accepter_vpc_info.vpc_id #=> String
    #   resp.vpc_peering_connection.accepter_vpc_info.region #=> String
    #   resp.vpc_peering_connection.expiration_time #=> Time
    #   resp.vpc_peering_connection.requester_vpc_info.cidr_block #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.ipv_6_cidr_block_set #=> Array
    #   resp.vpc_peering_connection.requester_vpc_info.ipv_6_cidr_block_set[0].ipv_6_cidr_block #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.cidr_block_set #=> Array
    #   resp.vpc_peering_connection.requester_vpc_info.cidr_block_set[0].cidr_block #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.owner_id #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.peering_options.allow_dns_resolution_from_remote_vpc #=> Boolean
    #   resp.vpc_peering_connection.requester_vpc_info.peering_options.allow_egress_from_local_classic_link_to_remote_vpc #=> Boolean
    #   resp.vpc_peering_connection.requester_vpc_info.peering_options.allow_egress_from_local_vpc_to_remote_classic_link #=> Boolean
    #   resp.vpc_peering_connection.requester_vpc_info.vpc_id #=> String
    #   resp.vpc_peering_connection.requester_vpc_info.region #=> String
    #   resp.vpc_peering_connection.status.code #=> String, one of "initiating-request", "pending-acceptance", "active", "deleted", "rejected", "failed", "expired", "provisioning", "deleting"
    #   resp.vpc_peering_connection.status.message #=> String
    #   resp.vpc_peering_connection.tags #=> Array
    #   resp.vpc_peering_connection.tags[0].key #=> String
    #   resp.vpc_peering_connection.tags[0].value #=> String
    #   resp.vpc_peering_connection.vpc_peering_connection_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnection AWS API Documentation
    #
    # @overload accept_vpc_peering_connection(params = {})
    # @param [Hash] params ({})
    def accept_vpc_peering_connection(params = {}, options = {})
      req = build_request(:accept_vpc_peering_connection, params)
      req.send_request(options)
    end

    # Advertises an IPv4 or IPv6 address range that is provisioned for use
    # with your Amazon Web Services resources through bring your own IP
    # addresses (BYOIP).
    #
    # You can perform this operation at most once every 10 seconds, even if
    # you specify different address ranges each time.
    #
    # We recommend that you stop advertising the BYOIP CIDR from other
    # locations when you advertise it from Amazon Web Services. To minimize
    # down time, you can configure your Amazon Web Services resources to use
    # an address from a BYOIP CIDR before it is advertised, and then
    # simultaneously stop advertising it from the current location and start
    # advertising it through Amazon Web Services.
    #
    # It can take a few minutes before traffic to the specified addresses
    # starts routing to Amazon Web Services because of BGP propagation
    # delays.
    #
    # @option params [required, String] :cidr
    #   The address range, in CIDR notation. This must be the exact range that
    #   you provisioned. You can't advertise only a portion of the
    #   provisioned range.
    #
    # @option params [String] :asn
    #   The public 2-byte or 4-byte ASN that you want to advertise.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :network_border_group
    #   If you have [Local Zones][1] enabled, you can choose a network border
    #   group for Local Zones when you provision and advertise a BYOIPv4 CIDR.
    #   Choose the network border group carefully as the EIP and the Amazon
    #   Web Services resource it is associated with must reside in the same
    #   network border group.
    #
    #   You can provision BYOIP address ranges to and advertise them in the
    #   following Local Zone network border groups:
    #
    #   * us-east-1-dfw-2
    #
    #   * us-west-2-lax-1
    #
    #   * us-west-2-phx-2
    #
    #   <note markdown="1"> You cannot provision or advertise BYOIPv6 address ranges in Local
    #   Zones at this time.
    #
    #    </note>
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/local-zones/latest/ug/how-local-zones-work.html
    #
    # @return [Types::AdvertiseByoipCidrResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AdvertiseByoipCidrResult#byoip_cidr #byoip_cidr} => Types::ByoipCidr
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.advertise_byoip_cidr({
    #     cidr: "String", # required
    #     asn: "String",
    #     dry_run: false,
    #     network_border_group: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.byoip_cidr.cidr #=> String
    #   resp.byoip_cidr.description #=> String
    #   resp.byoip_cidr.asn_associations #=> Array
    #   resp.byoip_cidr.asn_associations[0].asn #=> String
    #   resp.byoip_cidr.asn_associations[0].cidr #=> String
    #   resp.byoip_cidr.asn_associations[0].status_message #=> String
    #   resp.byoip_cidr.asn_associations[0].state #=> String, one of "disassociated", "failed-disassociation", "failed-association", "pending-disassociation", "pending-association", "associated"
    #   resp.byoip_cidr.status_message #=> String
    #   resp.byoip_cidr.state #=> String, one of "advertised", "deprovisioned", "failed-deprovision", "failed-provision", "pending-deprovision", "pending-provision", "provisioned", "provisioned-not-publicly-advertisable"
    #   resp.byoip_cidr.network_border_group #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdvertiseByoipCidr AWS API Documentation
    #
    # @overload advertise_byoip_cidr(params = {})
    # @param [Hash] params ({})
    def advertise_byoip_cidr(params = {}, options = {})
      req = build_request(:advertise_byoip_cidr, params)
      req.send_request(options)
    end

    # Allocates an Elastic IP address to your Amazon Web Services account.
    # After you allocate the Elastic IP address you can associate it with an
    # instance or network interface. After you release an Elastic IP
    # address, it is released to the IP address pool and can be allocated to
    # a different Amazon Web Services account.
    #
    # You can allocate an Elastic IP address from an address pool owned by
    # Amazon Web Services or from an address pool created from a public IPv4
    # address range that you have brought to Amazon Web Services for use
    # with your Amazon Web Services resources using bring your own IP
    # addresses (BYOIP). For more information, see [Bring Your Own IP
    # Addresses (BYOIP)][1] in the *Amazon EC2 User Guide*.
    #
    # If you release an Elastic IP address, you might be able to recover it.
    # You cannot recover an Elastic IP address that you released after it is
    # allocated to another Amazon Web Services account. To attempt to
    # recover an Elastic IP address that you released, specify it in this
    # operation.
    #
    # For more information, see [Elastic IP Addresses][2] in the *Amazon EC2
    # User Guide*.
    #
    # You can allocate a carrier IP address which is a public IP address
    # from a telecommunication carrier, to a network interface which resides
    # in a subnet in a Wavelength Zone (for example an EC2 instance).
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html
    #
    # @option params [String] :domain
    #   The network (`vpc`).
    #
    # @option params [String] :address
    #   The Elastic IP address to recover or an IPv4 address from an address
    #   pool.
    #
    # @option params [String] :public_ipv_4_pool
    #   The ID of an address pool that you own. Use this parameter to let
    #   Amazon EC2 select an address from the address pool. To specify a
    #   specific address from the address pool, use the `Address` parameter
    #   instead.
    #
    # @option params [String] :network_border_group
    #   A unique set of Availability Zones, Local Zones, or Wavelength Zones
    #   from which Amazon Web Services advertises IP addresses. Use this
    #   parameter to limit the IP address to this location. IP addresses
    #   cannot move between network border groups.
    #
    # @option params [String] :customer_owned_ipv_4_pool
    #   The ID of a customer-owned address pool. Use this parameter to let
    #   Amazon EC2 select an address from the address pool. Alternatively,
    #   specify a specific address from the address pool.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the Elastic IP address.
    #
    # @option params [String] :ipam_pool_id
    #   The ID of an IPAM pool which has an Amazon-provided or BYOIP public
    #   IPv4 CIDR provisioned to it. For more information, see [Allocate
    #   sequential Elastic IP addresses from an IPAM pool][1] in the *Amazon
    #   VPC IPAM User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-eip-pool.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AllocateAddressResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AllocateAddressResult#allocation_id #allocation_id} => String
    #   * {Types::AllocateAddressResult#public_ipv_4_pool #public_ipv_4_pool} => String
    #   * {Types::AllocateAddressResult#network_border_group #network_border_group} => String
    #   * {Types::AllocateAddressResult#domain #domain} => String
    #   * {Types::AllocateAddressResult#customer_owned_ip #customer_owned_ip} => String
    #   * {Types::AllocateAddressResult#customer_owned_ipv_4_pool #customer_owned_ipv_4_pool} => String
    #   * {Types::AllocateAddressResult#carrier_ip #carrier_ip} => String
    #   * {Types::AllocateAddressResult#public_ip #public_ip} => String
    #
    #
    # @example Example: To allocate an Elastic IP address
    #
    #   # This example allocates an Elastic IP address.
    #
    #   resp = client.allocate_address({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     allocation_id: "eipalloc-64d5890a", 
    #     domain: "vpc", 
    #     network_border_group: "us-east-1", 
    #     public_ip: "203.0.113.0", 
    #     public_ipv_4_pool: "amazon", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.allocate_address({
    #     domain: "vpc", # accepts vpc, standard
    #     address: "PublicIpAddress",
    #     public_ipv_4_pool: "Ipv4PoolEc2Id",
    #     network_border_group: "String",
    #     customer_owned_ipv_4_pool: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     ipam_pool_id: "IpamPoolId",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.allocation_id #=> String
    #   resp.public_ipv_4_pool #=> String
    #   resp.network_border_group #=> String
    #   resp.domain #=> String, one of "vpc", "standard"
    #   resp.customer_owned_ip #=> String
    #   resp.customer_owned_ipv_4_pool #=> String
    #   resp.carrier_ip #=> String
    #   resp.public_ip #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddress AWS API Documentation
    #
    # @overload allocate_address(params = {})
    # @param [Hash] params ({})
    def allocate_address(params = {}, options = {})
      req = build_request(:allocate_address, params)
      req.send_request(options)
    end

    # Allocates a Dedicated Host to your account. At a minimum, specify the
    # supported instance type or instance family, the Availability Zone in
    # which to allocate the host, and the number of hosts to allocate.
    #
    # @option params [String] :instance_family
    #   Specifies the instance family to be supported by the Dedicated Hosts.
    #   If you specify an instance family, the Dedicated Hosts support
    #   multiple instance types within that instance family.
    #
    #   If you want the Dedicated Hosts to support a specific instance type
    #   only, omit this parameter and specify **InstanceType** instead. You
    #   cannot specify **InstanceFamily** and **InstanceType** in the same
    #   request.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the Dedicated Host during creation.
    #
    # @option params [String] :host_recovery
    #   Indicates whether to enable or disable host recovery for the Dedicated
    #   Host. Host recovery is disabled by default. For more information, see
    #   [ Host recovery][1] in the *Amazon EC2 User Guide*.
    #
    #   Default: `off`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html
    #
    # @option params [String] :outpost_arn
    #   The Amazon Resource Name (ARN) of the Amazon Web Services Outpost on
    #   which to allocate the Dedicated Host. If you specify **OutpostArn**,
    #   you can optionally specify **AssetIds**.
    #
    #   If you are allocating the Dedicated Host in a Region, omit this
    #   parameter.
    #
    # @option params [String] :host_maintenance
    #   Indicates whether to enable or disable host maintenance for the
    #   Dedicated Host. For more information, see [Host maintenance][1] in the
    #   *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-maintenance.html
    #
    # @option params [Array<String>] :asset_ids
    #   The IDs of the Outpost hardware assets on which to allocate the
    #   Dedicated Hosts. Targeting specific hardware assets on an Outpost can
    #   help to minimize latency between your workloads. This parameter is
    #   supported only if you specify **OutpostArn**. If you are allocating
    #   the Dedicated Hosts in a Region, omit this parameter.
    #
    #   * If you specify this parameter, you can omit **Quantity**. In this
    #     case, Amazon EC2 allocates a Dedicated Host on each specified
    #     hardware asset.
    #
    #   * If you specify both **AssetIds** and **Quantity**, then the value
    #     for **Quantity** must be equal to the number of asset IDs specified.
    #
    # @option params [String] :availability_zone_id
    #   The ID of the Availability Zone.
    #
    # @option params [String] :auto_placement
    #   Indicates whether the host accepts any untargeted instance launches
    #   that match its instance type configuration, or if it only accepts Host
    #   tenancy instance launches that specify its unique host ID. For more
    #   information, see [ Understanding auto-placement and affinity][1] in
    #   the *Amazon EC2 User Guide*.
    #
    #   Default: `off`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [String] :instance_type
    #   Specifies the instance type to be supported by the Dedicated Hosts. If
    #   you specify an instance type, the Dedicated Hosts support instances of
    #   the specified instance type only.
    #
    #   If you want the Dedicated Hosts to support multiple instance types in
    #   a specific instance family, omit this parameter and specify
    #   **InstanceFamily** instead. You cannot specify **InstanceType** and
    #   **InstanceFamily** in the same request.
    #
    # @option params [Integer] :quantity
    #   The number of Dedicated Hosts to allocate to your account with these
    #   parameters. If you are allocating the Dedicated Hosts on an Outpost,
    #   and you specify **AssetIds**, you can omit this parameter. In this
    #   case, Amazon EC2 allocates a Dedicated Host on each specified hardware
    #   asset. If you specify both **AssetIds** and **Quantity**, then the
    #   value that you specify for **Quantity** must be equal to the number of
    #   asset IDs specified.
    #
    # @option params [String] :availability_zone
    #   The Availability Zone in which to allocate the Dedicated Host.
    #
    # @return [Types::AllocateHostsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AllocateHostsResult#host_ids #host_ids} => Array&lt;String&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.allocate_hosts({
    #     instance_family: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     host_recovery: "on", # accepts on, off
    #     outpost_arn: "String",
    #     host_maintenance: "on", # accepts on, off
    #     asset_ids: ["AssetId"],
    #     availability_zone_id: "AvailabilityZoneId",
    #     auto_placement: "on", # accepts on, off
    #     client_token: "String",
    #     instance_type: "String",
    #     quantity: 1,
    #     availability_zone: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.host_ids #=> Array
    #   resp.host_ids[0] #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHosts AWS API Documentation
    #
    # @overload allocate_hosts(params = {})
    # @param [Hash] params ({})
    def allocate_hosts(params = {}, options = {})
      req = build_request(:allocate_hosts, params)
      req.send_request(options)
    end

    # Allocate a CIDR from an IPAM pool. The Region you use should be the
    # IPAM pool locale. The locale is the Amazon Web Services Region where
    # this IPAM pool is available for allocations.
    #
    # In IPAM, an allocation is a CIDR assignment from an IPAM pool to
    # another IPAM pool or to a resource. For more information, see
    # [Allocate CIDRs][1] in the *Amazon VPC IPAM User Guide*.
    #
    # <note markdown="1"> This action creates an allocation with strong consistency. The
    # returned CIDR will not overlap with any other allocations from the
    # same pool.
    #
    #  </note>
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/ipam/allocate-cidrs-ipam.html
    #
    # @option params [Boolean] :dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response. If
    #   you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :ipam_pool_id
    #   The ID of the IPAM pool from which you would like to allocate a CIDR.
    #
    # @option params [String] :cidr
    #   The CIDR you would like to allocate from the IPAM pool. Note the
    #   following:
    #
    #   * If there is no DefaultNetmaskLength allocation rule set on the pool,
    #     you must specify either the NetmaskLength or the CIDR.
    #
    #   * If the DefaultNetmaskLength allocation rule is set on the pool, you
    #     can specify either the NetmaskLength or the CIDR and the
    #     DefaultNetmaskLength allocation rule will be ignored.
    #
    #   Possible values: Any available IPv4 or IPv6 CIDR.
    #
    # @option params [Integer] :netmask_length
    #   The netmask length of the CIDR you would like to allocate from the
    #   IPAM pool. Note the following:
    #
    #   * If there is no DefaultNetmaskLength allocation rule set on the pool,
    #     you must specify either the NetmaskLength or the CIDR.
    #
    #   * If the DefaultNetmaskLength allocation rule is set on the pool, you
    #     can specify either the NetmaskLength or the CIDR and the
    #     DefaultNetmaskLength allocation rule will be ignored.
    #
    #   Possible netmask lengths for IPv4 addresses are 0 - 32. Possible
    #   netmask lengths for IPv6 addresses are 0 - 128.
    #
    # @option params [String] :client_token
    #   A unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [String] :description
    #   A description for the allocation.
    #
    # @option params [Boolean] :preview_next_cidr
    #   A preview of the next available CIDR in a pool.
    #
    # @option params [Array<String>] :allowed_cidrs
    #   Include a particular CIDR range that can be returned by the pool.
    #   Allowed CIDRs are only allowed if using netmask length for allocation.
    #
    # @option params [Array<String>] :disallowed_cidrs
    #   Exclude a particular CIDR range from being returned by the pool.
    #   Disallowed CIDRs are only allowed if using netmask length for
    #   allocation.
    #
    # @return [Types::AllocateIpamPoolCidrResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AllocateIpamPoolCidrResult#ipam_pool_allocation #ipam_pool_allocation} => Types::IpamPoolAllocation
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.allocate_ipam_pool_cidr({
    #     dry_run: false,
    #     ipam_pool_id: "IpamPoolId", # required
    #     cidr: "String",
    #     netmask_length: 1,
    #     client_token: "String",
    #     description: "String",
    #     preview_next_cidr: false,
    #     allowed_cidrs: ["String"],
    #     disallowed_cidrs: ["String"],
    #   })
    #
    # @example Response structure
    #
    #   resp.ipam_pool_allocation.cidr #=> String
    #   resp.ipam_pool_allocation.ipam_pool_allocation_id #=> String
    #   resp.ipam_pool_allocation.description #=> String
    #   resp.ipam_pool_allocation.resource_id #=> String
    #   resp.ipam_pool_allocation.resource_type #=> String, one of "ipam-pool", "vpc", "ec2-public-ipv4-pool", "custom", "subnet", "eip"
    #   resp.ipam_pool_allocation.resource_region #=> String
    #   resp.ipam_pool_allocation.resource_owner #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateIpamPoolCidr AWS API Documentation
    #
    # @overload allocate_ipam_pool_cidr(params = {})
    # @param [Hash] params ({})
    def allocate_ipam_pool_cidr(params = {}, options = {})
      req = build_request(:allocate_ipam_pool_cidr, params)
      req.send_request(options)
    end

    # Applies a security group to the association between the target network
    # and the Client VPN endpoint. This action replaces the existing
    # security groups with the specified security groups.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC in which the associated target network is located.
    #
    # @option params [required, Array<String>] :security_group_ids
    #   The IDs of the security groups to apply to the associated target
    #   network. Up to 5 security groups can be applied to an associated
    #   target network.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::ApplySecurityGroupsToClientVpnTargetNetworkResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ApplySecurityGroupsToClientVpnTargetNetworkResult#security_group_ids #security_group_ids} => Array&lt;String&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.apply_security_groups_to_client_vpn_target_network({
    #     client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #     vpc_id: "VpcId", # required
    #     security_group_ids: ["SecurityGroupId"], # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.security_group_ids #=> Array
    #   resp.security_group_ids[0] #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ApplySecurityGroupsToClientVpnTargetNetwork AWS API Documentation
    #
    # @overload apply_security_groups_to_client_vpn_target_network(params = {})
    # @param [Hash] params ({})
    def apply_security_groups_to_client_vpn_target_network(params = {}, options = {})
      req = build_request(:apply_security_groups_to_client_vpn_target_network, params)
      req.send_request(options)
    end

    # Assigns the specified IPv6 addresses to the specified network
    # interface. You can specify specific IPv6 addresses, or you can specify
    # the number of IPv6 addresses to be automatically assigned from the
    # subnet's IPv6 CIDR block range. You can assign as many IPv6 addresses
    # to a network interface as you can assign private IPv4 addresses, and
    # the limit varies by instance type.
    #
    # You must specify either the IPv6 addresses or the IPv6 address count
    # in the request.
    #
    # You can optionally use Prefix Delegation on the network interface. You
    # must specify either the IPV6 Prefix Delegation prefixes, or the IPv6
    # Prefix Delegation count. For information, see [ Assigning prefixes to
    # network interfaces][1] in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html
    #
    # @option params [Integer] :ipv_6_prefix_count
    #   The number of IPv6 prefixes that Amazon Web Services automatically
    #   assigns to the network interface. You cannot use this option if you
    #   use the `Ipv6Prefixes` option.
    #
    # @option params [Array<String>] :ipv_6_prefixes
    #   One or more IPv6 prefixes assigned to the network interface. You
    #   can't use this option if you use the `Ipv6PrefixCount` option.
    #
    # @option params [required, String] :network_interface_id
    #   The ID of the network interface.
    #
    # @option params [Array<String>] :ipv_6_addresses
    #   The IPv6 addresses to be assigned to the network interface. You can't
    #   use this option if you're specifying a number of IPv6 addresses.
    #
    # @option params [Integer] :ipv_6_address_count
    #   The number of additional IPv6 addresses to assign to the network
    #   interface. The specified number of IPv6 addresses are assigned in
    #   addition to the existing IPv6 addresses that are already assigned to
    #   the network interface. Amazon EC2 automatically selects the IPv6
    #   addresses from the subnet range. You can't use this option if
    #   specifying specific IPv6 addresses.
    #
    # @return [Types::AssignIpv6AddressesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssignIpv6AddressesResult#assigned_ipv_6_addresses #assigned_ipv_6_addresses} => Array&lt;String&gt;
    #   * {Types::AssignIpv6AddressesResult#assigned_ipv_6_prefixes #assigned_ipv_6_prefixes} => Array&lt;String&gt;
    #   * {Types::AssignIpv6AddressesResult#network_interface_id #network_interface_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.assign_ipv_6_addresses({
    #     ipv_6_prefix_count: 1,
    #     ipv_6_prefixes: ["String"],
    #     network_interface_id: "NetworkInterfaceId", # required
    #     ipv_6_addresses: ["String"],
    #     ipv_6_address_count: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.assigned_ipv_6_addresses #=> Array
    #   resp.assigned_ipv_6_addresses[0] #=> String
    #   resp.assigned_ipv_6_prefixes #=> Array
    #   resp.assigned_ipv_6_prefixes[0] #=> String
    #   resp.network_interface_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6Addresses AWS API Documentation
    #
    # @overload assign_ipv_6_addresses(params = {})
    # @param [Hash] params ({})
    def assign_ipv_6_addresses(params = {}, options = {})
      req = build_request(:assign_ipv_6_addresses, params)
      req.send_request(options)
    end

    # Assigns the specified secondary private IP addresses to the specified
    # network interface.
    #
    # You can specify specific secondary IP addresses, or you can specify
    # the number of secondary IP addresses to be automatically assigned from
    # the subnet's CIDR block range. The number of secondary IP addresses
    # that you can assign to an instance varies by instance type. For more
    # information about Elastic IP addresses, see [Elastic IP Addresses][1]
    # in the *Amazon EC2 User Guide*.
    #
    # When you move a secondary private IP address to another network
    # interface, any Elastic IP address that is associated with the IP
    # address is also moved.
    #
    # Remapping an IP address is an asynchronous operation. When you move an
    # IP address from one network interface to another, check
    # `network/interfaces/macs/mac/local-ipv4s` in the instance metadata to
    # confirm that the remapping is complete.
    #
    # You must specify either the IP addresses or the IP address count in
    # the request.
    #
    # You can optionally use Prefix Delegation on the network interface. You
    # must specify either the IPv4 Prefix Delegation prefixes, or the IPv4
    # Prefix Delegation count. For information, see [ Assigning prefixes to
    # network interfaces][2] in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-prefix-eni.html
    #
    # @option params [Array<String>] :ipv_4_prefixes
    #   One or more IPv4 prefixes assigned to the network interface. You
    #   can't use this option if you use the `Ipv4PrefixCount` option.
    #
    # @option params [Integer] :ipv_4_prefix_count
    #   The number of IPv4 prefixes that Amazon Web Services automatically
    #   assigns to the network interface. You can't use this option if you
    #   use the `Ipv4 Prefixes` option.
    #
    # @option params [required, String] :network_interface_id
    #   The ID of the network interface.
    #
    # @option params [Array<String>] :private_ip_addresses
    #   The IP addresses to be assigned as a secondary private IP address to
    #   the network interface. You can't specify this parameter when also
    #   specifying a number of secondary IP addresses.
    #
    #   If you don't specify an IP address, Amazon EC2 automatically selects
    #   an IP address within the subnet range.
    #
    # @option params [Integer] :secondary_private_ip_address_count
    #   The number of secondary IP addresses to assign to the network
    #   interface. You can't specify this parameter when also specifying
    #   private IP addresses.
    #
    # @option params [Boolean] :allow_reassignment
    #   Indicates whether to allow an IP address that is already assigned to
    #   another network interface or instance to be reassigned to the
    #   specified network interface.
    #
    # @return [Types::AssignPrivateIpAddressesResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssignPrivateIpAddressesResult#network_interface_id #network_interface_id} => String
    #   * {Types::AssignPrivateIpAddressesResult#assigned_private_ip_addresses #assigned_private_ip_addresses} => Array&lt;Types::AssignedPrivateIpAddress&gt;
    #   * {Types::AssignPrivateIpAddressesResult#assigned_ipv_4_prefixes #assigned_ipv_4_prefixes} => Array&lt;Types::Ipv4PrefixSpecification&gt;
    #
    #
    # @example Example: To assign a specific secondary private IP address to an interface
    #
    #   # This example assigns the specified secondary private IP address to the specified network interface.
    #
    #   resp = client.assign_private_ip_addresses({
    #     network_interface_id: "eni-e5aa89a3", 
    #     private_ip_addresses: [
    #       "10.0.0.82", 
    #     ], 
    #   })
    #
    # @example Example: To assign secondary private IP addresses that Amazon EC2 selects to an interface
    #
    #   # This example assigns two secondary private IP addresses to the specified network interface. Amazon EC2 automatically
    #   # assigns these IP addresses from the available IP addresses in the CIDR block range of the subnet the network interface
    #   # is associated with.
    #
    #   resp = client.assign_private_ip_addresses({
    #     network_interface_id: "eni-e5aa89a3", 
    #     secondary_private_ip_address_count: 2, 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.assign_private_ip_addresses({
    #     ipv_4_prefixes: ["String"],
    #     ipv_4_prefix_count: 1,
    #     network_interface_id: "NetworkInterfaceId", # required
    #     private_ip_addresses: ["String"],
    #     secondary_private_ip_address_count: 1,
    #     allow_reassignment: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.network_interface_id #=> String
    #   resp.assigned_private_ip_addresses #=> Array
    #   resp.assigned_private_ip_addresses[0].private_ip_address #=> String
    #   resp.assigned_ipv_4_prefixes #=> Array
    #   resp.assigned_ipv_4_prefixes[0].ipv_4_prefix #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddresses AWS API Documentation
    #
    # @overload assign_private_ip_addresses(params = {})
    # @param [Hash] params ({})
    def assign_private_ip_addresses(params = {}, options = {})
      req = build_request(:assign_private_ip_addresses, params)
      req.send_request(options)
    end

    # Assigns private IPv4 addresses to a private NAT gateway. For more
    # information, see [Work with NAT gateways][1] in the *Amazon VPC User
    # Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html
    #
    # @option params [required, String] :nat_gateway_id
    #   The ID of the NAT gateway.
    #
    # @option params [Array<String>] :private_ip_addresses
    #   The private IPv4 addresses you want to assign to the private NAT
    #   gateway.
    #
    # @option params [Integer] :private_ip_address_count
    #   The number of private IP addresses to assign to the NAT gateway. You
    #   can't specify this parameter when also specifying private IP
    #   addresses.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AssignPrivateNatGatewayAddressResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssignPrivateNatGatewayAddressResult#nat_gateway_id #nat_gateway_id} => String
    #   * {Types::AssignPrivateNatGatewayAddressResult#nat_gateway_addresses #nat_gateway_addresses} => Array&lt;Types::NatGatewayAddress&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.assign_private_nat_gateway_address({
    #     nat_gateway_id: "NatGatewayId", # required
    #     private_ip_addresses: ["String"],
    #     private_ip_address_count: 1,
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.nat_gateway_id #=> String
    #   resp.nat_gateway_addresses #=> Array
    #   resp.nat_gateway_addresses[0].allocation_id #=> String
    #   resp.nat_gateway_addresses[0].network_interface_id #=> String
    #   resp.nat_gateway_addresses[0].private_ip #=> String
    #   resp.nat_gateway_addresses[0].public_ip #=> String
    #   resp.nat_gateway_addresses[0].association_id #=> String
    #   resp.nat_gateway_addresses[0].is_primary #=> Boolean
    #   resp.nat_gateway_addresses[0].failure_message #=> String
    #   resp.nat_gateway_addresses[0].status #=> String, one of "assigning", "unassigning", "associating", "disassociating", "succeeded", "failed"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateNatGatewayAddress AWS API Documentation
    #
    # @overload assign_private_nat_gateway_address(params = {})
    # @param [Hash] params ({})
    def assign_private_nat_gateway_address(params = {}, options = {})
      req = build_request(:assign_private_nat_gateway_address, params)
      req.send_request(options)
    end

    # Associates an Elastic IP address, or carrier IP address (for instances
    # that are in subnets in Wavelength Zones) with an instance or a network
    # interface. Before you can use an Elastic IP address, you must allocate
    # it to your account.
    #
    # If the Elastic IP address is already associated with a different
    # instance, it is disassociated from that instance and associated with
    # the specified instance. If you associate an Elastic IP address with an
    # instance that has an existing Elastic IP address, the existing address
    # is disassociated from the instance, but remains allocated to your
    # account.
    #
    # \[Subnets in Wavelength Zones\] You can associate an IP address from
    # the telecommunication carrier to the instance or network interface.
    #
    # You cannot associate an Elastic IP address with an interface in a
    # different network border group.
    #
    # This is an idempotent operation. If you perform the operation more
    # than once, Amazon EC2 doesn't return an error, and you may be charged
    # for each time the Elastic IP address is remapped to the same instance.
    # For more information, see the *Elastic IP Addresses* section of
    # [Amazon EC2 Pricing][1].
    #
    #
    #
    # [1]: http://aws.amazon.com/ec2/pricing/
    #
    # @option params [String] :allocation_id
    #   The allocation ID. This is required.
    #
    # @option params [String] :instance_id
    #   The ID of the instance. The instance must have exactly one attached
    #   network interface. You can specify either the instance ID or the
    #   network interface ID, but not both.
    #
    # @option params [String] :public_ip
    #   Deprecated.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :network_interface_id
    #   The ID of the network interface. If the instance has more than one
    #   network interface, you must specify a network interface ID.
    #
    #   You can specify either the instance ID or the network interface ID,
    #   but not both.
    #
    # @option params [String] :private_ip_address
    #   The primary or secondary private IP address to associate with the
    #   Elastic IP address. If no private IP address is specified, the Elastic
    #   IP address is associated with the primary private IP address.
    #
    # @option params [Boolean] :allow_reassociation
    #   Reassociation is automatic, but you can specify false to ensure the
    #   operation fails if the Elastic IP address is already associated with
    #   another resource.
    #
    # @return [Types::AssociateAddressResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateAddressResult#association_id #association_id} => String
    #
    #
    # @example Example: To associate an Elastic IP address
    #
    #   # This example associates the specified Elastic IP address with the specified instance.
    #
    #   resp = client.associate_address({
    #     allocation_id: "eipalloc-64d5890a", 
    #     instance_id: "i-0b263919b6498b123", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     association_id: "eipassoc-2bebb745", 
    #   }
    #
    # @example Example: To associate an Elastic IP address with a network interface
    #
    #   # This example associates the specified Elastic IP address with the specified network interface.
    #
    #   resp = client.associate_address({
    #     allocation_id: "eipalloc-64d5890a", 
    #     network_interface_id: "eni-1a2b3c4d", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     association_id: "eipassoc-2bebb745", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_address({
    #     allocation_id: "AllocationId",
    #     instance_id: "InstanceId",
    #     public_ip: "EipAllocationPublicIp",
    #     dry_run: false,
    #     network_interface_id: "NetworkInterfaceId",
    #     private_ip_address: "String",
    #     allow_reassociation: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.association_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddress AWS API Documentation
    #
    # @overload associate_address(params = {})
    # @param [Hash] params ({})
    def associate_address(params = {}, options = {})
      req = build_request(:associate_address, params)
      req.send_request(options)
    end

    # Initiates a request to assign billing of the unused capacity of a
    # shared Capacity Reservation to a consumer account that is consolidated
    # under the same Amazon Web Services organizations payer account. For
    # more information, see [Billing assignment for shared Amazon EC2
    # Capacity Reservations][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/assign-billing.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :capacity_reservation_id
    #   The ID of the Capacity Reservation.
    #
    # @option params [required, String] :unused_reservation_billing_owner_id
    #   The ID of the consumer account to which to assign billing.
    #
    # @return [Types::AssociateCapacityReservationBillingOwnerResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateCapacityReservationBillingOwnerResult#return #return} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_capacity_reservation_billing_owner({
    #     dry_run: false,
    #     capacity_reservation_id: "CapacityReservationId", # required
    #     unused_reservation_billing_owner_id: "AccountID", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateCapacityReservationBillingOwner AWS API Documentation
    #
    # @overload associate_capacity_reservation_billing_owner(params = {})
    # @param [Hash] params ({})
    def associate_capacity_reservation_billing_owner(params = {}, options = {})
      req = build_request(:associate_capacity_reservation_billing_owner, params)
      req.send_request(options)
    end

    # Associates a target network with a Client VPN endpoint. A target
    # network is a subnet in a VPC. You can associate multiple subnets from
    # the same VPC with a Client VPN endpoint. You can associate only one
    # subnet in each Availability Zone. We recommend that you associate at
    # least two subnets to provide Availability Zone redundancy.
    #
    # If you specified a VPC when you created the Client VPN endpoint or if
    # you have previous subnet associations, the specified subnet must be in
    # the same VPC. To specify a subnet that's in a different VPC, you must
    # first modify the Client VPN endpoint (ModifyClientVpnEndpoint) and
    # change the VPC that's associated with it.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #
    # @option params [required, String] :subnet_id
    #   The ID of the subnet to associate with the Client VPN endpoint.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AssociateClientVpnTargetNetworkResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateClientVpnTargetNetworkResult#association_id #association_id} => String
    #   * {Types::AssociateClientVpnTargetNetworkResult#status #status} => Types::AssociationStatus
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_client_vpn_target_network({
    #     client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #     subnet_id: "SubnetId", # required
    #     client_token: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.association_id #=> String
    #   resp.status.code #=> String, one of "associating", "associated", "association-failed", "disassociating", "disassociated"
    #   resp.status.message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateClientVpnTargetNetwork AWS API Documentation
    #
    # @overload associate_client_vpn_target_network(params = {})
    # @param [Hash] params ({})
    def associate_client_vpn_target_network(params = {}, options = {})
      req = build_request(:associate_client_vpn_target_network, params)
      req.send_request(options)
    end

    # Associates a set of DHCP options (that you've previously created)
    # with the specified VPC, or associates no DHCP options with the VPC.
    #
    # After you associate the options with the VPC, any existing instances
    # and all new instances that you launch in that VPC use the options. You
    # don't need to restart or relaunch the instances. They automatically
    # pick up the changes within a few hours, depending on how frequently
    # the instance renews its DHCP lease. You can explicitly renew the lease
    # using the operating system on the instance.
    #
    # For more information, see [DHCP option sets][1] in the *Amazon VPC
    # User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html
    #
    # @option params [required, String] :dhcp_options_id
    #   The ID of the DHCP options set, or `default` to associate no DHCP
    #   options with the VPC.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To associate a DHCP options set with a VPC
    #
    #   # This example associates the specified DHCP options set with the specified VPC.
    #
    #   resp = client.associate_dhcp_options({
    #     dhcp_options_id: "dopt-d9070ebb", 
    #     vpc_id: "vpc-a01106c2", 
    #   })
    #
    # @example Example: To associate the default DHCP options set with a VPC
    #
    #   # This example associates the default DHCP options set with the specified VPC.
    #
    #   resp = client.associate_dhcp_options({
    #     dhcp_options_id: "default", 
    #     vpc_id: "vpc-a01106c2", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_dhcp_options({
    #     dhcp_options_id: "DefaultingDhcpOptionsId", # required
    #     vpc_id: "VpcId", # required
    #     dry_run: false,
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptions AWS API Documentation
    #
    # @overload associate_dhcp_options(params = {})
    # @param [Hash] params ({})
    def associate_dhcp_options(params = {}, options = {})
      req = build_request(:associate_dhcp_options, params)
      req.send_request(options)
    end

    # Associates an Identity and Access Management (IAM) role with an
    # Certificate Manager (ACM) certificate. This enables the certificate to
    # be used by the ACM for Nitro Enclaves application inside an enclave.
    # For more information, see [Certificate Manager for Nitro Enclaves][1]
    # in the *Amazon Web Services Nitro Enclaves User Guide*.
    #
    # When the IAM role is associated with the ACM certificate, the
    # certificate, certificate chain, and encrypted private key are placed
    # in an Amazon S3 location that only the associated IAM role can access.
    # The private key of the certificate is encrypted with an Amazon Web
    # Services managed key that has an attached attestation-based key
    # policy.
    #
    # To enable the IAM role to access the Amazon S3 object, you must grant
    # it permission to call `s3:GetObject` on the Amazon S3 bucket returned
    # by the command. To enable the IAM role to access the KMS key, you must
    # grant it permission to call `kms:Decrypt` on the KMS key returned by
    # the command. For more information, see [ Grant the role permission to
    # access the certificate and encryption key][2] in the *Amazon Web
    # Services Nitro Enclaves User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html
    # [2]: https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy
    #
    # @option params [required, String] :certificate_arn
    #   The ARN of the ACM certificate with which to associate the IAM role.
    #
    # @option params [required, String] :role_arn
    #   The ARN of the IAM role to associate with the ACM certificate. You can
    #   associate up to 16 IAM roles with an ACM certificate.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AssociateEnclaveCertificateIamRoleResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateEnclaveCertificateIamRoleResult#certificate_s3_bucket_name #certificate_s3_bucket_name} => String
    #   * {Types::AssociateEnclaveCertificateIamRoleResult#certificate_s3_object_key #certificate_s3_object_key} => String
    #   * {Types::AssociateEnclaveCertificateIamRoleResult#encryption_kms_key_id #encryption_kms_key_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_enclave_certificate_iam_role({
    #     certificate_arn: "CertificateId", # required
    #     role_arn: "RoleId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.certificate_s3_bucket_name #=> String
    #   resp.certificate_s3_object_key #=> String
    #   resp.encryption_kms_key_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateEnclaveCertificateIamRole AWS API Documentation
    #
    # @overload associate_enclave_certificate_iam_role(params = {})
    # @param [Hash] params ({})
    def associate_enclave_certificate_iam_role(params = {}, options = {})
      req = build_request(:associate_enclave_certificate_iam_role, params)
      req.send_request(options)
    end

    # Associates an IAM instance profile with a running or stopped instance.
    # You cannot associate more than one IAM instance profile with an
    # instance.
    #
    # @option params [required, Types::IamInstanceProfileSpecification] :iam_instance_profile
    #   The IAM instance profile.
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance.
    #
    # @return [Types::AssociateIamInstanceProfileResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateIamInstanceProfileResult#iam_instance_profile_association #iam_instance_profile_association} => Types::IamInstanceProfileAssociation
    #
    #
    # @example Example: To associate an IAM instance profile with an instance
    #
    #   # This example associates an IAM instance profile named admin-role with the specified instance.
    #
    #   resp = client.associate_iam_instance_profile({
    #     iam_instance_profile: {
    #       name: "admin-role", 
    #     }, 
    #     instance_id: "i-123456789abcde123", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     iam_instance_profile_association: {
    #       association_id: "iip-assoc-0e7736511a163c209", 
    #       iam_instance_profile: {
    #         arn: "arn:aws:iam::123456789012:instance-profile/admin-role", 
    #         id: "AIPAJBLK7RKJKWDXVHIEC", 
    #       }, 
    #       instance_id: "i-123456789abcde123", 
    #       state: "associating", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_iam_instance_profile({
    #     iam_instance_profile: { # required
    #       arn: "String",
    #       name: "String",
    #     },
    #     instance_id: "InstanceId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.iam_instance_profile_association.association_id #=> String
    #   resp.iam_instance_profile_association.instance_id #=> String
    #   resp.iam_instance_profile_association.iam_instance_profile.arn #=> String
    #   resp.iam_instance_profile_association.iam_instance_profile.id #=> String
    #   resp.iam_instance_profile_association.state #=> String, one of "associating", "associated", "disassociating", "disassociated"
    #   resp.iam_instance_profile_association.timestamp #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfile AWS API Documentation
    #
    # @overload associate_iam_instance_profile(params = {})
    # @param [Hash] params ({})
    def associate_iam_instance_profile(params = {}, options = {})
      req = build_request(:associate_iam_instance_profile, params)
      req.send_request(options)
    end

    # Associates one or more targets with an event window. Only one type of
    # target (instance IDs, Dedicated Host IDs, or tags) can be specified
    # with an event window.
    #
    # For more information, see [Define event windows for scheduled
    # events][1] in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :instance_event_window_id
    #   The ID of the event window.
    #
    # @option params [required, Types::InstanceEventWindowAssociationRequest] :association_target
    #   One or more targets associated with the specified event window.
    #
    # @return [Types::AssociateInstanceEventWindowResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateInstanceEventWindowResult#instance_event_window #instance_event_window} => Types::InstanceEventWindow
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_instance_event_window({
    #     dry_run: false,
    #     instance_event_window_id: "InstanceEventWindowId", # required
    #     association_target: { # required
    #       instance_ids: ["InstanceId"],
    #       instance_tags: [
    #         {
    #           key: "String",
    #           value: "String",
    #         },
    #       ],
    #       dedicated_host_ids: ["DedicatedHostId"],
    #     },
    #   })
    #
    # @example Response structure
    #
    #   resp.instance_event_window.instance_event_window_id #=> String
    #   resp.instance_event_window.time_ranges #=> Array
    #   resp.instance_event_window.time_ranges[0].start_week_day #=> String, one of "sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"
    #   resp.instance_event_window.time_ranges[0].start_hour #=> Integer
    #   resp.instance_event_window.time_ranges[0].end_week_day #=> String, one of "sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"
    #   resp.instance_event_window.time_ranges[0].end_hour #=> Integer
    #   resp.instance_event_window.name #=> String
    #   resp.instance_event_window.cron_expression #=> String
    #   resp.instance_event_window.association_target.instance_ids #=> Array
    #   resp.instance_event_window.association_target.instance_ids[0] #=> String
    #   resp.instance_event_window.association_target.tags #=> Array
    #   resp.instance_event_window.association_target.tags[0].key #=> String
    #   resp.instance_event_window.association_target.tags[0].value #=> String
    #   resp.instance_event_window.association_target.dedicated_host_ids #=> Array
    #   resp.instance_event_window.association_target.dedicated_host_ids[0] #=> String
    #   resp.instance_event_window.state #=> String, one of "creating", "deleting", "active", "deleted"
    #   resp.instance_event_window.tags #=> Array
    #   resp.instance_event_window.tags[0].key #=> String
    #   resp.instance_event_window.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateInstanceEventWindow AWS API Documentation
    #
    # @overload associate_instance_event_window(params = {})
    # @param [Hash] params ({})
    def associate_instance_event_window(params = {}, options = {})
      req = build_request(:associate_instance_event_window, params)
      req.send_request(options)
    end

    # Associates your Autonomous System Number (ASN) with a BYOIP CIDR that
    # you own in the same Amazon Web Services Region. For more information,
    # see [Tutorial: Bring your ASN to IPAM][1] in the *Amazon VPC IPAM
    # guide*.
    #
    # After the association succeeds, the ASN is eligible for advertisement.
    # You can view the association with [DescribeByoipCidrs][2]. You can
    # advertise the CIDR with [AdvertiseByoipCidr][3].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/ipam/tutorials-byoasn.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeByoipCidrs.html
    # [3]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AdvertiseByoipCidr.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :asn
    #   A public 2-byte or 4-byte ASN.
    #
    # @option params [required, String] :cidr
    #   The BYOIP CIDR you want to associate with an ASN.
    #
    # @return [Types::AssociateIpamByoasnResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateIpamByoasnResult#asn_association #asn_association} => Types::AsnAssociation
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_ipam_byoasn({
    #     dry_run: false,
    #     asn: "String", # required
    #     cidr: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.asn_association.asn #=> String
    #   resp.asn_association.cidr #=> String
    #   resp.asn_association.status_message #=> String
    #   resp.asn_association.state #=> String, one of "disassociated", "failed-disassociation", "failed-association", "pending-disassociation", "pending-association", "associated"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamByoasn AWS API Documentation
    #
    # @overload associate_ipam_byoasn(params = {})
    # @param [Hash] params ({})
    def associate_ipam_byoasn(params = {}, options = {})
      req = build_request(:associate_ipam_byoasn, params)
      req.send_request(options)
    end

    # Associates an IPAM resource discovery with an Amazon VPC IPAM. A
    # resource discovery is an IPAM component that enables IPAM to manage
    # and monitor resources that belong to the owning account.
    #
    # @option params [Boolean] :dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response. If
    #   you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :ipam_id
    #   An IPAM ID.
    #
    # @option params [required, String] :ipam_resource_discovery_id
    #   A resource discovery ID.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   Tag specifications.
    #
    # @option params [String] :client_token
    #   A client token.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    # @return [Types::AssociateIpamResourceDiscoveryResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateIpamResourceDiscoveryResult#ipam_resource_discovery_association #ipam_resource_discovery_association} => Types::IpamResourceDiscoveryAssociation
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_ipam_resource_discovery({
    #     dry_run: false,
    #     ipam_id: "IpamId", # required
    #     ipam_resource_discovery_id: "IpamResourceDiscoveryId", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.ipam_resource_discovery_association.owner_id #=> String
    #   resp.ipam_resource_discovery_association.ipam_resource_discovery_association_id #=> String
    #   resp.ipam_resource_discovery_association.ipam_resource_discovery_association_arn #=> String
    #   resp.ipam_resource_discovery_association.ipam_resource_discovery_id #=> String
    #   resp.ipam_resource_discovery_association.ipam_id #=> String
    #   resp.ipam_resource_discovery_association.ipam_arn #=> String
    #   resp.ipam_resource_discovery_association.ipam_region #=> String
    #   resp.ipam_resource_discovery_association.is_default #=> Boolean
    #   resp.ipam_resource_discovery_association.resource_discovery_status #=> String, one of "active", "not-found"
    #   resp.ipam_resource_discovery_association.state #=> String, one of "associate-in-progress", "associate-complete", "associate-failed", "disassociate-in-progress", "disassociate-complete", "disassociate-failed", "isolate-in-progress", "isolate-complete", "restore-in-progress"
    #   resp.ipam_resource_discovery_association.tags #=> Array
    #   resp.ipam_resource_discovery_association.tags[0].key #=> String
    #   resp.ipam_resource_discovery_association.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIpamResourceDiscovery AWS API Documentation
    #
    # @overload associate_ipam_resource_discovery(params = {})
    # @param [Hash] params ({})
    def associate_ipam_resource_discovery(params = {}, options = {})
      req = build_request(:associate_ipam_resource_discovery, params)
      req.send_request(options)
    end

    # Associates Elastic IP addresses (EIPs) and private IPv4 addresses with
    # a public NAT gateway. For more information, see [Work with NAT
    # gateways][1] in the *Amazon VPC User Guide*.
    #
    # By default, you can associate up to 2 Elastic IP addresses per public
    # NAT gateway. You can increase the limit by requesting a quota
    # adjustment. For more information, see [Elastic IP address quotas][2]
    # in the *Amazon VPC User Guide*.
    #
    # When you associate an EIP or secondary EIPs with a public NAT gateway,
    # the network border group of the EIPs must match the network border
    # group of the Availability Zone (AZ) that the public NAT gateway is in.
    # If it's not the same, the EIP will fail to associate. You can see the
    # network border group for the subnet's AZ by viewing the details of
    # the subnet. Similarly, you can view the network border group of an EIP
    # by viewing the details of the EIP address. For more information about
    # network border groups and EIPs, see [Allocate an Elastic IP
    # address][3] in the *Amazon VPC User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html
    # [2]: https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-eips
    # [3]: https://docs.aws.amazon.com/vpc/latest/userguide/WorkWithEIPs.html
    #
    # @option params [required, String] :nat_gateway_id
    #   The ID of the NAT gateway.
    #
    # @option params [required, Array<String>] :allocation_ids
    #   The allocation IDs of EIPs that you want to associate with your NAT
    #   gateway.
    #
    # @option params [Array<String>] :private_ip_addresses
    #   The private IPv4 addresses that you want to assign to the NAT gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AssociateNatGatewayAddressResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateNatGatewayAddressResult#nat_gateway_id #nat_gateway_id} => String
    #   * {Types::AssociateNatGatewayAddressResult#nat_gateway_addresses #nat_gateway_addresses} => Array&lt;Types::NatGatewayAddress&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_nat_gateway_address({
    #     nat_gateway_id: "NatGatewayId", # required
    #     allocation_ids: ["AllocationId"], # required
    #     private_ip_addresses: ["String"],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.nat_gateway_id #=> String
    #   resp.nat_gateway_addresses #=> Array
    #   resp.nat_gateway_addresses[0].allocation_id #=> String
    #   resp.nat_gateway_addresses[0].network_interface_id #=> String
    #   resp.nat_gateway_addresses[0].private_ip #=> String
    #   resp.nat_gateway_addresses[0].public_ip #=> String
    #   resp.nat_gateway_addresses[0].association_id #=> String
    #   resp.nat_gateway_addresses[0].is_primary #=> Boolean
    #   resp.nat_gateway_addresses[0].failure_message #=> String
    #   resp.nat_gateway_addresses[0].status #=> String, one of "assigning", "unassigning", "associating", "disassociating", "succeeded", "failed"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateNatGatewayAddress AWS API Documentation
    #
    # @overload associate_nat_gateway_address(params = {})
    # @param [Hash] params ({})
    def associate_nat_gateway_address(params = {}, options = {})
      req = build_request(:associate_nat_gateway_address, params)
      req.send_request(options)
    end

    # Associates a route server with a VPC to enable dynamic route updates.
    #
    # A route server association is the connection established between a
    # route server and a VPC.
    #
    # For more information see [Dynamic routing in your VPC with VPC Route
    # Server][1] in the *Amazon VPC User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/dynamic-routing-route-server.html
    #
    # @option params [required, String] :route_server_id
    #   The unique identifier for the route server to be associated.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC to associate with the route server.
    #
    # @option params [Boolean] :dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response. If
    #   you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AssociateRouteServerResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateRouteServerResult#route_server_association #route_server_association} => Types::RouteServerAssociation
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_route_server({
    #     route_server_id: "RouteServerId", # required
    #     vpc_id: "VpcId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.route_server_association.route_server_id #=> String
    #   resp.route_server_association.vpc_id #=> String
    #   resp.route_server_association.state #=> String, one of "associating", "associated", "disassociating"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteServer AWS API Documentation
    #
    # @overload associate_route_server(params = {})
    # @param [Hash] params ({})
    def associate_route_server(params = {}, options = {})
      req = build_request(:associate_route_server, params)
      req.send_request(options)
    end

    # Associates a subnet in your VPC or an internet gateway or virtual
    # private gateway attached to your VPC with a route table in your VPC.
    # This association causes traffic from the subnet or gateway to be
    # routed according to the routes in the route table. The action returns
    # an association ID, which you need in order to disassociate the route
    # table later. A route table can be associated with multiple subnets.
    #
    # For more information, see [Route tables][1] in the *Amazon VPC User
    # Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html
    #
    # @option params [String] :gateway_id
    #   The ID of the internet gateway or virtual private gateway.
    #
    # @option params [String] :public_ipv_4_pool
    #   The ID of a public IPv4 pool. A public IPv4 pool is a pool of IPv4
    #   addresses that you've brought to Amazon Web Services with BYOIP.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :subnet_id
    #   The ID of the subnet.
    #
    # @option params [required, String] :route_table_id
    #   The ID of the route table.
    #
    # @return [Types::AssociateRouteTableResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateRouteTableResult#association_id #association_id} => String
    #   * {Types::AssociateRouteTableResult#association_state #association_state} => Types::RouteTableAssociationState
    #
    #
    # @example Example: To associate a route table with a subnet
    #
    #   # This example associates the specified route table with the specified subnet.
    #
    #   resp = client.associate_route_table({
    #     route_table_id: "rtb-22574640", 
    #     subnet_id: "subnet-9d4a7b6", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     association_id: "rtbassoc-781d0d1a", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_route_table({
    #     gateway_id: "RouteGatewayId",
    #     public_ipv_4_pool: "Ipv4PoolEc2Id",
    #     dry_run: false,
    #     subnet_id: "SubnetId",
    #     route_table_id: "RouteTableId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.association_id #=> String
    #   resp.association_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failed"
    #   resp.association_state.status_message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTable AWS API Documentation
    #
    # @overload associate_route_table(params = {})
    # @param [Hash] params ({})
    def associate_route_table(params = {}, options = {})
      req = build_request(:associate_route_table, params)
      req.send_request(options)
    end

    # Associates a security group with another VPC in the same Region. This
    # enables you to use the same security group with network interfaces and
    # instances in the specified VPC.
    #
    # <note markdown="1"> * The VPC you want to associate the security group with must be in the
    #   same Region.
    #
    # * You can associate the security group with another VPC if your
    #   account owns the VPC or if the VPC was shared with you.
    #
    # * You must own the security group.
    #
    # * You cannot use this feature with default security groups.
    #
    # * You cannot use this feature with the default VPC.
    #
    #  </note>
    #
    # @option params [required, String] :group_id
    #   A security group ID.
    #
    # @option params [required, String] :vpc_id
    #   A VPC ID.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AssociateSecurityGroupVpcResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateSecurityGroupVpcResult#state #state} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_security_group_vpc({
    #     group_id: "SecurityGroupId", # required
    #     vpc_id: "VpcId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.state #=> String, one of "associating", "associated", "association-failed", "disassociating", "disassociated", "disassociation-failed"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSecurityGroupVpc AWS API Documentation
    #
    # @overload associate_security_group_vpc(params = {})
    # @param [Hash] params ({})
    def associate_security_group_vpc(params = {}, options = {})
      req = build_request(:associate_security_group_vpc, params)
      req.send_request(options)
    end

    # Associates a CIDR block with your subnet. You can only associate a
    # single IPv6 CIDR block with your subnet.
    #
    # @option params [String] :ipv_6_ipam_pool_id
    #   An IPv6 IPAM pool ID.
    #
    # @option params [Integer] :ipv_6_netmask_length
    #   An IPv6 netmask length.
    #
    # @option params [required, String] :subnet_id
    #   The ID of your subnet.
    #
    # @option params [String] :ipv_6_cidr_block
    #   The IPv6 CIDR block for your subnet.
    #
    # @return [Types::AssociateSubnetCidrBlockResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateSubnetCidrBlockResult#ipv_6_cidr_block_association #ipv_6_cidr_block_association} => Types::SubnetIpv6CidrBlockAssociation
    #   * {Types::AssociateSubnetCidrBlockResult#subnet_id #subnet_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_subnet_cidr_block({
    #     ipv_6_ipam_pool_id: "IpamPoolId",
    #     ipv_6_netmask_length: 1,
    #     subnet_id: "SubnetId", # required
    #     ipv_6_cidr_block: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.ipv_6_cidr_block_association.association_id #=> String
    #   resp.ipv_6_cidr_block_association.ipv_6_cidr_block #=> String
    #   resp.ipv_6_cidr_block_association.ipv_6_cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.ipv_6_cidr_block_association.ipv_6_cidr_block_state.status_message #=> String
    #   resp.ipv_6_cidr_block_association.ipv_6_address_attribute #=> String, one of "public", "private"
    #   resp.ipv_6_cidr_block_association.ip_source #=> String, one of "amazon", "byoip", "none"
    #   resp.subnet_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlock AWS API Documentation
    #
    # @overload associate_subnet_cidr_block(params = {})
    # @param [Hash] params ({})
    def associate_subnet_cidr_block(params = {}, options = {})
      req = build_request(:associate_subnet_cidr_block, params)
      req.send_request(options)
    end

    # Associates the specified subnets and transit gateway attachments with
    # the specified transit gateway multicast domain.
    #
    # The transit gateway attachment must be in the available state before
    # you can add a resource. Use [DescribeTransitGatewayAttachments][1] to
    # see the state of the attachment.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html
    #
    # @option params [required, String] :transit_gateway_multicast_domain_id
    #   The ID of the transit gateway multicast domain.
    #
    # @option params [required, String] :transit_gateway_attachment_id
    #   The ID of the transit gateway attachment to associate with the transit
    #   gateway multicast domain.
    #
    # @option params [required, Array<String>] :subnet_ids
    #   The IDs of the subnets to associate with the transit gateway multicast
    #   domain.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AssociateTransitGatewayMulticastDomainResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateTransitGatewayMulticastDomainResult#associations #associations} => Types::TransitGatewayMulticastDomainAssociations
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_transit_gateway_multicast_domain({
    #     transit_gateway_multicast_domain_id: "TransitGatewayMulticastDomainId", # required
    #     transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #     subnet_ids: ["SubnetId"], # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.associations.transit_gateway_multicast_domain_id #=> String
    #   resp.associations.transit_gateway_attachment_id #=> String
    #   resp.associations.resource_id #=> String
    #   resp.associations.resource_type #=> String, one of "vpc", "vpn", "direct-connect-gateway", "connect", "peering", "tgw-peering", "network-function"
    #   resp.associations.resource_owner_id #=> String
    #   resp.associations.subnets #=> Array
    #   resp.associations.subnets[0].subnet_id #=> String
    #   resp.associations.subnets[0].state #=> String, one of "pendingAcceptance", "associating", "associated", "disassociating", "disassociated", "rejected", "failed"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayMulticastDomain AWS API Documentation
    #
    # @overload associate_transit_gateway_multicast_domain(params = {})
    # @param [Hash] params ({})
    def associate_transit_gateway_multicast_domain(params = {}, options = {})
      req = build_request(:associate_transit_gateway_multicast_domain, params)
      req.send_request(options)
    end

    # Associates the specified transit gateway attachment with a transit
    # gateway policy table.
    #
    # @option params [required, String] :transit_gateway_policy_table_id
    #   The ID of the transit gateway policy table to associate with the
    #   transit gateway attachment.
    #
    # @option params [required, String] :transit_gateway_attachment_id
    #   The ID of the transit gateway attachment to associate with the policy
    #   table.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AssociateTransitGatewayPolicyTableResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateTransitGatewayPolicyTableResult#association #association} => Types::TransitGatewayPolicyTableAssociation
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_transit_gateway_policy_table({
    #     transit_gateway_policy_table_id: "TransitGatewayPolicyTableId", # required
    #     transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.association.transit_gateway_policy_table_id #=> String
    #   resp.association.transit_gateway_attachment_id #=> String
    #   resp.association.resource_id #=> String
    #   resp.association.resource_type #=> String, one of "vpc", "vpn", "direct-connect-gateway", "connect", "peering", "tgw-peering", "network-function"
    #   resp.association.state #=> String, one of "associating", "associated", "disassociating", "disassociated"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayPolicyTable AWS API Documentation
    #
    # @overload associate_transit_gateway_policy_table(params = {})
    # @param [Hash] params ({})
    def associate_transit_gateway_policy_table(params = {}, options = {})
      req = build_request(:associate_transit_gateway_policy_table, params)
      req.send_request(options)
    end

    # Associates the specified attachment with the specified transit gateway
    # route table. You can associate only one route table with an
    # attachment.
    #
    # @option params [required, String] :transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #
    # @option params [required, String] :transit_gateway_attachment_id
    #   The ID of the attachment.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AssociateTransitGatewayRouteTableResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateTransitGatewayRouteTableResult#association #association} => Types::TransitGatewayAssociation
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_transit_gateway_route_table({
    #     transit_gateway_route_table_id: "TransitGatewayRouteTableId", # required
    #     transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.association.transit_gateway_route_table_id #=> String
    #   resp.association.transit_gateway_attachment_id #=> String
    #   resp.association.resource_id #=> String
    #   resp.association.resource_type #=> String, one of "vpc", "vpn", "direct-connect-gateway", "connect", "peering", "tgw-peering", "network-function"
    #   resp.association.state #=> String, one of "associating", "associated", "disassociating", "disassociated"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayRouteTable AWS API Documentation
    #
    # @overload associate_transit_gateway_route_table(params = {})
    # @param [Hash] params ({})
    def associate_transit_gateway_route_table(params = {}, options = {})
      req = build_request(:associate_transit_gateway_route_table, params)
      req.send_request(options)
    end

    # Associates a branch network interface with a trunk network interface.
    #
    # Before you create the association, use [CreateNetworkInterface][1]
    # command and set the interface type to `trunk`. You must also create a
    # network interface for each branch network interface that you want to
    # associate with the trunk network interface.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html
    #
    # @option params [required, String] :branch_interface_id
    #   The ID of the branch network interface.
    #
    # @option params [required, String] :trunk_interface_id
    #   The ID of the trunk network interface.
    #
    # @option params [Integer] :vlan_id
    #   The ID of the VLAN. This applies to the VLAN protocol.
    #
    # @option params [Integer] :gre_key
    #   The application key. This applies to the GRE protocol.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AssociateTrunkInterfaceResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateTrunkInterfaceResult#interface_association #interface_association} => Types::TrunkInterfaceAssociation
    #   * {Types::AssociateTrunkInterfaceResult#client_token #client_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_trunk_interface({
    #     branch_interface_id: "NetworkInterfaceId", # required
    #     trunk_interface_id: "NetworkInterfaceId", # required
    #     vlan_id: 1,
    #     gre_key: 1,
    #     client_token: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.interface_association.association_id #=> String
    #   resp.interface_association.branch_interface_id #=> String
    #   resp.interface_association.trunk_interface_id #=> String
    #   resp.interface_association.interface_protocol #=> String, one of "VLAN", "GRE"
    #   resp.interface_association.vlan_id #=> Integer
    #   resp.interface_association.gre_key #=> Integer
    #   resp.interface_association.tags #=> Array
    #   resp.interface_association.tags[0].key #=> String
    #   resp.interface_association.tags[0].value #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTrunkInterface AWS API Documentation
    #
    # @overload associate_trunk_interface(params = {})
    # @param [Hash] params ({})
    def associate_trunk_interface(params = {}, options = {})
      req = build_request(:associate_trunk_interface, params)
      req.send_request(options)
    end

    # Associates a CIDR block with your VPC. You can associate a secondary
    # IPv4 CIDR block, an Amazon-provided IPv6 CIDR block, or an IPv6 CIDR
    # block from an IPv6 address pool that you provisioned through bring
    # your own IP addresses ([BYOIP][1]).
    #
    # You must specify one of the following in the request: an IPv4 CIDR
    # block, an IPv6 pool, or an Amazon-provided IPv6 CIDR block.
    #
    # For more information about associating CIDR blocks with your VPC and
    # applicable restrictions, see [IP addressing for your VPCs and
    # subnets][2] in the *Amazon VPC User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html
    # [2]: https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html
    #
    # @option params [String] :cidr_block
    #   An IPv4 CIDR block to associate with the VPC.
    #
    # @option params [String] :ipv_6_cidr_block_network_border_group
    #   The name of the location from which we advertise the IPV6 CIDR block.
    #   Use this parameter to limit the CIDR block to this location.
    #
    #   You must set `AmazonProvidedIpv6CidrBlock` to `true` to use this
    #   parameter.
    #
    #   You can have one IPv6 CIDR block association per network border group.
    #
    # @option params [String] :ipv_6_pool
    #   The ID of an IPv6 address pool from which to allocate the IPv6 CIDR
    #   block.
    #
    # @option params [String] :ipv_6_cidr_block
    #   An IPv6 CIDR block from the IPv6 address pool. You must also specify
    #   `Ipv6Pool` in the request.
    #
    #   To let Amazon choose the IPv6 CIDR block for you, omit this parameter.
    #
    # @option params [String] :ipv_4_ipam_pool_id
    #   Associate a CIDR allocated from an IPv4 IPAM pool to a VPC. For more
    #   information about Amazon VPC IP Address Manager (IPAM), see [What is
    #   IPAM?][1] in the *Amazon VPC IPAM User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html
    #
    # @option params [Integer] :ipv_4_netmask_length
    #   The netmask length of the IPv4 CIDR you would like to associate from
    #   an Amazon VPC IP Address Manager (IPAM) pool. For more information
    #   about IPAM, see [What is IPAM?][1] in the *Amazon VPC IPAM User
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html
    #
    # @option params [String] :ipv_6_ipam_pool_id
    #   Associates a CIDR allocated from an IPv6 IPAM pool to a VPC. For more
    #   information about Amazon VPC IP Address Manager (IPAM), see [What is
    #   IPAM?][1] in the *Amazon VPC IPAM User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html
    #
    # @option params [Integer] :ipv_6_netmask_length
    #   The netmask length of the IPv6 CIDR you would like to associate from
    #   an Amazon VPC IP Address Manager (IPAM) pool. For more information
    #   about IPAM, see [What is IPAM?][1] in the *Amazon VPC IPAM User
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/what-is-it-ipam.html
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @option params [Boolean] :amazon_provided_ipv_6_cidr_block
    #   Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length
    #   for the VPC. You cannot specify the range of IPv6 addresses or the
    #   size of the CIDR block.
    #
    # @return [Types::AssociateVpcCidrBlockResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AssociateVpcCidrBlockResult#ipv_6_cidr_block_association #ipv_6_cidr_block_association} => Types::VpcIpv6CidrBlockAssociation
    #   * {Types::AssociateVpcCidrBlockResult#cidr_block_association #cidr_block_association} => Types::VpcCidrBlockAssociation
    #   * {Types::AssociateVpcCidrBlockResult#vpc_id #vpc_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.associate_vpc_cidr_block({
    #     cidr_block: "String",
    #     ipv_6_cidr_block_network_border_group: "String",
    #     ipv_6_pool: "Ipv6PoolEc2Id",
    #     ipv_6_cidr_block: "String",
    #     ipv_4_ipam_pool_id: "IpamPoolId",
    #     ipv_4_netmask_length: 1,
    #     ipv_6_ipam_pool_id: "IpamPoolId",
    #     ipv_6_netmask_length: 1,
    #     vpc_id: "VpcId", # required
    #     amazon_provided_ipv_6_cidr_block: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.ipv_6_cidr_block_association.association_id #=> String
    #   resp.ipv_6_cidr_block_association.ipv_6_cidr_block #=> String
    #   resp.ipv_6_cidr_block_association.ipv_6_cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.ipv_6_cidr_block_association.ipv_6_cidr_block_state.status_message #=> String
    #   resp.ipv_6_cidr_block_association.network_border_group #=> String
    #   resp.ipv_6_cidr_block_association.ipv_6_pool #=> String
    #   resp.ipv_6_cidr_block_association.ipv_6_address_attribute #=> String, one of "public", "private"
    #   resp.ipv_6_cidr_block_association.ip_source #=> String, one of "amazon", "byoip", "none"
    #   resp.cidr_block_association.association_id #=> String
    #   resp.cidr_block_association.cidr_block #=> String
    #   resp.cidr_block_association.cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.cidr_block_association.cidr_block_state.status_message #=> String
    #   resp.vpc_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlock AWS API Documentation
    #
    # @overload associate_vpc_cidr_block(params = {})
    # @param [Hash] params ({})
    def associate_vpc_cidr_block(params = {}, options = {})
      req = build_request(:associate_vpc_cidr_block, params)
      req.send_request(options)
    end

    # <note markdown="1"> This action is deprecated.
    #
    #  </note>
    #
    # Links an EC2-Classic instance to a ClassicLink-enabled VPC through one
    # or more of the VPC security groups. You cannot link an EC2-Classic
    # instance to more than one VPC at a time. You can only link an instance
    # that's in the `running` state. An instance is automatically unlinked
    # from a VPC when it's stopped - you can link it to the VPC again when
    # you restart it.
    #
    # After you've linked an instance, you cannot change the VPC security
    # groups that are associated with it. To change the security groups, you
    # must first unlink the instance, and then link it again.
    #
    # Linking your instance to a VPC is sometimes referred to as *attaching*
    # your instance.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :instance_id
    #   The ID of the EC2-Classic instance.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the ClassicLink-enabled VPC.
    #
    # @option params [required, Array<String>] :groups
    #   The IDs of the security groups. You cannot specify security groups
    #   from a different VPC.
    #
    # @return [Types::AttachClassicLinkVpcResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AttachClassicLinkVpcResult#return #return} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.attach_classic_link_vpc({
    #     dry_run: false,
    #     instance_id: "InstanceId", # required
    #     vpc_id: "VpcId", # required
    #     groups: ["SecurityGroupId"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpc AWS API Documentation
    #
    # @overload attach_classic_link_vpc(params = {})
    # @param [Hash] params ({})
    def attach_classic_link_vpc(params = {}, options = {})
      req = build_request(:attach_classic_link_vpc, params)
      req.send_request(options)
    end

    # Attaches an internet gateway or a virtual private gateway to a VPC,
    # enabling connectivity between the internet and the VPC. For more
    # information, see [Internet gateways][1] in the *Amazon VPC User
    # Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :internet_gateway_id
    #   The ID of the internet gateway.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To attach an Internet gateway to a VPC
    #
    #   # This example attaches the specified Internet gateway to the specified VPC.
    #
    #   resp = client.attach_internet_gateway({
    #     internet_gateway_id: "igw-c0a643a9", 
    #     vpc_id: "vpc-a01106c2", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.attach_internet_gateway({
    #     dry_run: false,
    #     internet_gateway_id: "InternetGatewayId", # required
    #     vpc_id: "VpcId", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGateway AWS API Documentation
    #
    # @overload attach_internet_gateway(params = {})
    # @param [Hash] params ({})
    def attach_internet_gateway(params = {}, options = {})
      req = build_request(:attach_internet_gateway, params)
      req.send_request(options)
    end

    # Attaches a network interface to an instance.
    #
    # @option params [Integer] :network_card_index
    #   The index of the network card. Some instance types support multiple
    #   network cards. The primary network interface must be assigned to
    #   network card index 0. The default is network card index 0.
    #
    # @option params [Types::EnaSrdSpecification] :ena_srd_specification
    #   Configures ENA Express for the network interface that this action
    #   attaches to the instance.
    #
    # @option params [Integer] :ena_queue_count
    #   The number of ENA queues to be created with the instance.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :network_interface_id
    #   The ID of the network interface.
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance.
    #
    # @option params [required, Integer] :device_index
    #   The index of the device for the network interface attachment.
    #
    # @return [Types::AttachNetworkInterfaceResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AttachNetworkInterfaceResult#attachment_id #attachment_id} => String
    #   * {Types::AttachNetworkInterfaceResult#network_card_index #network_card_index} => Integer
    #
    #
    # @example Example: To attach a network interface to an instance
    #
    #   # This example attaches the specified network interface to the specified instance.
    #
    #   resp = client.attach_network_interface({
    #     device_index: 1, 
    #     instance_id: "i-1234567890abcdef0", 
    #     network_interface_id: "eni-e5aa89a3", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     attachment_id: "eni-attach-66c4350a", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.attach_network_interface({
    #     network_card_index: 1,
    #     ena_srd_specification: {
    #       ena_srd_enabled: false,
    #       ena_srd_udp_specification: {
    #         ena_srd_udp_enabled: false,
    #       },
    #     },
    #     ena_queue_count: 1,
    #     dry_run: false,
    #     network_interface_id: "NetworkInterfaceId", # required
    #     instance_id: "InstanceId", # required
    #     device_index: 1, # required
    #   })
    #
    # @example Response structure
    #
    #   resp.attachment_id #=> String
    #   resp.network_card_index #=> Integer
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterface AWS API Documentation
    #
    # @overload attach_network_interface(params = {})
    # @param [Hash] params ({})
    def attach_network_interface(params = {}, options = {})
      req = build_request(:attach_network_interface, params)
      req.send_request(options)
    end

    # Attaches the specified Amazon Web Services Verified Access trust
    # provider to the specified Amazon Web Services Verified Access
    # instance.
    #
    # @option params [required, String] :verified_access_instance_id
    #   The ID of the Verified Access instance.
    #
    # @option params [required, String] :verified_access_trust_provider_id
    #   The ID of the Verified Access trust provider.
    #
    # @option params [String] :client_token
    #   A unique, case-sensitive token that you provide to ensure idempotency
    #   of your modification request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AttachVerifiedAccessTrustProviderResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AttachVerifiedAccessTrustProviderResult#verified_access_trust_provider #verified_access_trust_provider} => Types::VerifiedAccessTrustProvider
    #   * {Types::AttachVerifiedAccessTrustProviderResult#verified_access_instance #verified_access_instance} => Types::VerifiedAccessInstance
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.attach_verified_access_trust_provider({
    #     verified_access_instance_id: "VerifiedAccessInstanceId", # required
    #     verified_access_trust_provider_id: "VerifiedAccessTrustProviderId", # required
    #     client_token: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.verified_access_trust_provider.verified_access_trust_provider_id #=> String
    #   resp.verified_access_trust_provider.description #=> String
    #   resp.verified_access_trust_provider.trust_provider_type #=> String, one of "user", "device"
    #   resp.verified_access_trust_provider.user_trust_provider_type #=> String, one of "iam-identity-center", "oidc"
    #   resp.verified_access_trust_provider.device_trust_provider_type #=> String, one of "jamf", "crowdstrike", "jumpcloud"
    #   resp.verified_access_trust_provider.oidc_options.issuer #=> String
    #   resp.verified_access_trust_provider.oidc_options.authorization_endpoint #=> String
    #   resp.verified_access_trust_provider.oidc_options.token_endpoint #=> String
    #   resp.verified_access_trust_provider.oidc_options.user_info_endpoint #=> String
    #   resp.verified_access_trust_provider.oidc_options.client_id #=> String
    #   resp.verified_access_trust_provider.oidc_options.client_secret #=> String
    #   resp.verified_access_trust_provider.oidc_options.scope #=> String
    #   resp.verified_access_trust_provider.device_options.tenant_id #=> String
    #   resp.verified_access_trust_provider.device_options.public_signing_key_url #=> String
    #   resp.verified_access_trust_provider.policy_reference_name #=> String
    #   resp.verified_access_trust_provider.creation_time #=> String
    #   resp.verified_access_trust_provider.last_updated_time #=> String
    #   resp.verified_access_trust_provider.tags #=> Array
    #   resp.verified_access_trust_provider.tags[0].key #=> String
    #   resp.verified_access_trust_provider.tags[0].value #=> String
    #   resp.verified_access_trust_provider.sse_specification.customer_managed_key_enabled #=> Boolean
    #   resp.verified_access_trust_provider.sse_specification.kms_key_arn #=> String
    #   resp.verified_access_trust_provider.native_application_oidc_options.public_signing_key_endpoint #=> String
    #   resp.verified_access_trust_provider.native_application_oidc_options.issuer #=> String
    #   resp.verified_access_trust_provider.native_application_oidc_options.authorization_endpoint #=> String
    #   resp.verified_access_trust_provider.native_application_oidc_options.token_endpoint #=> String
    #   resp.verified_access_trust_provider.native_application_oidc_options.user_info_endpoint #=> String
    #   resp.verified_access_trust_provider.native_application_oidc_options.client_id #=> String
    #   resp.verified_access_trust_provider.native_application_oidc_options.scope #=> String
    #   resp.verified_access_instance.verified_access_instance_id #=> String
    #   resp.verified_access_instance.description #=> String
    #   resp.verified_access_instance.verified_access_trust_providers #=> Array
    #   resp.verified_access_instance.verified_access_trust_providers[0].verified_access_trust_provider_id #=> String
    #   resp.verified_access_instance.verified_access_trust_providers[0].description #=> String
    #   resp.verified_access_instance.verified_access_trust_providers[0].trust_provider_type #=> String, one of "user", "device"
    #   resp.verified_access_instance.verified_access_trust_providers[0].user_trust_provider_type #=> String, one of "iam-identity-center", "oidc"
    #   resp.verified_access_instance.verified_access_trust_providers[0].device_trust_provider_type #=> String, one of "jamf", "crowdstrike", "jumpcloud"
    #   resp.verified_access_instance.creation_time #=> String
    #   resp.verified_access_instance.last_updated_time #=> String
    #   resp.verified_access_instance.tags #=> Array
    #   resp.verified_access_instance.tags[0].key #=> String
    #   resp.verified_access_instance.tags[0].value #=> String
    #   resp.verified_access_instance.fips_enabled #=> Boolean
    #   resp.verified_access_instance.cidr_endpoints_custom_sub_domain.sub_domain #=> String
    #   resp.verified_access_instance.cidr_endpoints_custom_sub_domain.nameservers #=> Array
    #   resp.verified_access_instance.cidr_endpoints_custom_sub_domain.nameservers[0] #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVerifiedAccessTrustProvider AWS API Documentation
    #
    # @overload attach_verified_access_trust_provider(params = {})
    # @param [Hash] params ({})
    def attach_verified_access_trust_provider(params = {}, options = {})
      req = build_request(:attach_verified_access_trust_provider, params)
      req.send_request(options)
    end

    # Attaches an Amazon EBS volume to a `running` or `stopped` instance,
    # and exposes it to the instance with the specified device name.
    #
    # <note markdown="1"> The maximum number of Amazon EBS volumes that you can attach to an
    # instance depends on the instance type. If you exceed the volume
    # attachment limit for an instance type, the attachment request fails
    # with the `AttachmentLimitExceeded` error. For more information, see
    # [Instance volume limits][1].
    #
    #  </note>
    #
    # After you attach an EBS volume, you must make it available for use.
    # For more information, see [Make an EBS volume available for use][2].
    #
    # If a volume has an Amazon Web Services Marketplace product code:
    #
    # * The volume can be attached only to a stopped instance.
    #
    # * Amazon Web Services Marketplace product codes are copied from the
    #   volume to the instance.
    #
    # * You must be subscribed to the product.
    #
    # * The instance type and operating system of the instance must support
    #   the product. For example, you can't detach a volume from a Windows
    #   instance and attach it to a Linux instance.
    #
    # For more information, see [Attach an Amazon EBS volume to an
    # instance][3] in the *Amazon EBS User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/volume_limits.html
    # [2]: https://docs.aws.amazon.com/ebs/latest/userguide/ebs-using-volumes.html
    # [3]: https://docs.aws.amazon.com/ebs/latest/userguide/ebs-attaching-volume.html
    #
    # @option params [required, String] :device
    #   The device name (for example, `/dev/sdh` or `xvdh`).
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance.
    #
    # @option params [required, String] :volume_id
    #   The ID of the EBS volume. The volume and instance must be within the
    #   same Availability Zone.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::VolumeAttachment] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::VolumeAttachment#delete_on_termination #delete_on_termination} => Boolean
    #   * {Types::VolumeAttachment#associated_resource #associated_resource} => String
    #   * {Types::VolumeAttachment#instance_owning_service #instance_owning_service} => String
    #   * {Types::VolumeAttachment#volume_id #volume_id} => String
    #   * {Types::VolumeAttachment#instance_id #instance_id} => String
    #   * {Types::VolumeAttachment#device #device} => String
    #   * {Types::VolumeAttachment#state #state} => String
    #   * {Types::VolumeAttachment#attach_time #attach_time} => Time
    #
    #
    # @example Example: To attach a volume to an instance
    #
    #   # This example attaches a volume (``vol-1234567890abcdef0``) to an instance (``i-01474ef662b89480``) as ``/dev/sdf``.
    #
    #   resp = client.attach_volume({
    #     device: "/dev/sdf", 
    #     instance_id: "i-01474ef662b89480", 
    #     volume_id: "vol-1234567890abcdef0", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     attach_time: Time.parse("2016-08-29T18:52:32.724Z"), 
    #     device: "/dev/sdf", 
    #     instance_id: "i-01474ef662b89480", 
    #     state: "attaching", 
    #     volume_id: "vol-1234567890abcdef0", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.attach_volume({
    #     device: "String", # required
    #     instance_id: "InstanceId", # required
    #     volume_id: "VolumeId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.delete_on_termination #=> Boolean
    #   resp.associated_resource #=> String
    #   resp.instance_owning_service #=> String
    #   resp.volume_id #=> String
    #   resp.instance_id #=> String
    #   resp.device #=> String
    #   resp.state #=> String, one of "attaching", "attached", "detaching", "detached", "busy"
    #   resp.attach_time #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolume AWS API Documentation
    #
    # @overload attach_volume(params = {})
    # @param [Hash] params ({})
    def attach_volume(params = {}, options = {})
      req = build_request(:attach_volume, params)
      req.send_request(options)
    end

    # Attaches an available virtual private gateway to a VPC. You can attach
    # one virtual private gateway to one VPC at a time.
    #
    # For more information, see [Amazon Web Services Site-to-Site VPN][1] in
    # the *Amazon Web Services Site-to-Site VPN User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @option params [required, String] :vpn_gateway_id
    #   The ID of the virtual private gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AttachVpnGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AttachVpnGatewayResult#vpc_attachment #vpc_attachment} => Types::VpcAttachment
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.attach_vpn_gateway({
    #     vpc_id: "VpcId", # required
    #     vpn_gateway_id: "VpnGatewayId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.vpc_attachment.vpc_id #=> String
    #   resp.vpc_attachment.state #=> String, one of "attaching", "attached", "detaching", "detached"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGateway AWS API Documentation
    #
    # @overload attach_vpn_gateway(params = {})
    # @param [Hash] params ({})
    def attach_vpn_gateway(params = {}, options = {})
      req = build_request(:attach_vpn_gateway, params)
      req.send_request(options)
    end

    # Adds an ingress authorization rule to a Client VPN endpoint. Ingress
    # authorization rules act as firewall rules that grant access to
    # networks. You must configure ingress authorization rules to enable
    # clients to access resources in Amazon Web Services or on-premises
    # networks.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #
    # @option params [required, String] :target_network_cidr
    #   The IPv4 address range, in CIDR notation, of the network for which
    #   access is being authorized.
    #
    # @option params [String] :access_group_id
    #   The ID of the group to grant access to, for example, the Active
    #   Directory group or identity provider (IdP) group. Required if
    #   `AuthorizeAllGroups` is `false` or not specified.
    #
    # @option params [Boolean] :authorize_all_groups
    #   Indicates whether to grant access to all clients. Specify `true` to
    #   grant all clients who successfully establish a VPN connection access
    #   to the network. Must be set to `true` if `AccessGroupId` is not
    #   specified.
    #
    # @option params [String] :description
    #   A brief description of the authorization rule.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AuthorizeClientVpnIngressResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AuthorizeClientVpnIngressResult#status #status} => Types::ClientVpnAuthorizationRuleStatus
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.authorize_client_vpn_ingress({
    #     client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #     target_network_cidr: "String", # required
    #     access_group_id: "String",
    #     authorize_all_groups: false,
    #     description: "String",
    #     client_token: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.status.code #=> String, one of "authorizing", "active", "failed", "revoking"
    #   resp.status.message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeClientVpnIngress AWS API Documentation
    #
    # @overload authorize_client_vpn_ingress(params = {})
    # @param [Hash] params ({})
    def authorize_client_vpn_ingress(params = {}, options = {})
      req = build_request(:authorize_client_vpn_ingress, params)
      req.send_request(options)
    end

    # Adds the specified outbound (egress) rules to a security group.
    #
    # An outbound rule permits instances to send traffic to the specified
    # IPv4 or IPv6 address ranges, the IP address ranges specified by a
    # prefix list, or the instances that are associated with a source
    # security group. For more information, see [Security group rules][1].
    #
    # You must specify exactly one of the following destinations: an IPv4 or
    # IPv6 address range, a prefix list, or a security group. You must
    # specify a protocol for each rule (for example, TCP). If the protocol
    # is TCP or UDP, you must also specify a port or port range. If the
    # protocol is ICMP or ICMPv6, you must also specify the ICMP type and
    # code.
    #
    # Rule changes are propagated to instances associated with the security
    # group as quickly as possible. However, a small delay might occur.
    #
    # For examples of rules that you can add to security groups for specific
    # access scenarios, see [Security group rules for different use
    # cases][2] in the *Amazon EC2 User Guide*.
    #
    # For information about security group quotas, see [Amazon VPC
    # quotas][3] in the *Amazon VPC User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/security-group-rules.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html
    # [3]: https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags applied to the security group rule.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :group_id
    #   The ID of the security group.
    #
    # @option params [String] :source_security_group_name
    #   Not supported. Use IP permissions instead.
    #
    # @option params [String] :source_security_group_owner_id
    #   Not supported. Use IP permissions instead.
    #
    # @option params [String] :ip_protocol
    #   Not supported. Use IP permissions instead.
    #
    # @option params [Integer] :from_port
    #   Not supported. Use IP permissions instead.
    #
    # @option params [Integer] :to_port
    #   Not supported. Use IP permissions instead.
    #
    # @option params [String] :cidr_ip
    #   Not supported. Use IP permissions instead.
    #
    # @option params [Array<Types::IpPermission>] :ip_permissions
    #   The permissions for the security group rules.
    #
    # @return [Types::AuthorizeSecurityGroupEgressResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AuthorizeSecurityGroupEgressResult#return #return} => Boolean
    #   * {Types::AuthorizeSecurityGroupEgressResult#security_group_rules #security_group_rules} => Array&lt;Types::SecurityGroupRule&gt;
    #
    #
    # @example Example: To add a rule that allows outbound traffic to a specific address range
    #
    #   # This example adds a rule that grants access to the specified address ranges on TCP port 80.
    #
    #   resp = client.authorize_security_group_egress({
    #     group_id: "sg-1a2b3c4d", 
    #     ip_permissions: [
    #       {
    #         from_port: 80, 
    #         ip_protocol: "tcp", 
    #         ip_ranges: [
    #           {
    #             cidr_ip: "10.0.0.0/16", 
    #           }, 
    #         ], 
    #         to_port: 80, 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Example: To add a rule that allows outbound traffic to a specific security group
    #
    #   # This example adds a rule that grants access to the specified security group on TCP port 80.
    #
    #   resp = client.authorize_security_group_egress({
    #     group_id: "sg-1a2b3c4d", 
    #     ip_permissions: [
    #       {
    #         from_port: 80, 
    #         ip_protocol: "tcp", 
    #         to_port: 80, 
    #         user_id_group_pairs: [
    #           {
    #             group_id: "sg-4b51a32f", 
    #           }, 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.authorize_security_group_egress({
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #     group_id: "SecurityGroupId", # required
    #     source_security_group_name: "String",
    #     source_security_group_owner_id: "String",
    #     ip_protocol: "String",
    #     from_port: 1,
    #     to_port: 1,
    #     cidr_ip: "String",
    #     ip_permissions: [
    #       {
    #         ip_protocol: "String",
    #         from_port: 1,
    #         to_port: 1,
    #         user_id_group_pairs: [
    #           {
    #             description: "String",
    #             user_id: "String",
    #             group_name: "String",
    #             group_id: "String",
    #             vpc_id: "String",
    #             vpc_peering_connection_id: "String",
    #             peering_status: "String",
    #           },
    #         ],
    #         ip_ranges: [
    #           {
    #             description: "String",
    #             cidr_ip: "String",
    #           },
    #         ],
    #         ipv_6_ranges: [
    #           {
    #             description: "String",
    #             cidr_ipv_6: "String",
    #           },
    #         ],
    #         prefix_list_ids: [
    #           {
    #             description: "String",
    #             prefix_list_id: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #   resp.security_group_rules #=> Array
    #   resp.security_group_rules[0].security_group_rule_id #=> String
    #   resp.security_group_rules[0].group_id #=> String
    #   resp.security_group_rules[0].group_owner_id #=> String
    #   resp.security_group_rules[0].is_egress #=> Boolean
    #   resp.security_group_rules[0].ip_protocol #=> String
    #   resp.security_group_rules[0].from_port #=> Integer
    #   resp.security_group_rules[0].to_port #=> Integer
    #   resp.security_group_rules[0].cidr_ipv_4 #=> String
    #   resp.security_group_rules[0].cidr_ipv_6 #=> String
    #   resp.security_group_rules[0].prefix_list_id #=> String
    #   resp.security_group_rules[0].referenced_group_info.group_id #=> String
    #   resp.security_group_rules[0].referenced_group_info.peering_status #=> String
    #   resp.security_group_rules[0].referenced_group_info.user_id #=> String
    #   resp.security_group_rules[0].referenced_group_info.vpc_id #=> String
    #   resp.security_group_rules[0].referenced_group_info.vpc_peering_connection_id #=> String
    #   resp.security_group_rules[0].description #=> String
    #   resp.security_group_rules[0].tags #=> Array
    #   resp.security_group_rules[0].tags[0].key #=> String
    #   resp.security_group_rules[0].tags[0].value #=> String
    #   resp.security_group_rules[0].security_group_rule_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgress AWS API Documentation
    #
    # @overload authorize_security_group_egress(params = {})
    # @param [Hash] params ({})
    def authorize_security_group_egress(params = {}, options = {})
      req = build_request(:authorize_security_group_egress, params)
      req.send_request(options)
    end

    # Adds the specified inbound (ingress) rules to a security group.
    #
    # An inbound rule permits instances to receive traffic from the
    # specified IPv4 or IPv6 address range, the IP address ranges that are
    # specified by a prefix list, or the instances that are associated with
    # a destination security group. For more information, see [Security
    # group rules][1].
    #
    # You must specify exactly one of the following sources: an IPv4 or IPv6
    # address range, a prefix list, or a security group. You must specify a
    # protocol for each rule (for example, TCP). If the protocol is TCP or
    # UDP, you must also specify a port or port range. If the protocol is
    # ICMP or ICMPv6, you must also specify the ICMP/ICMPv6 type and code.
    #
    # Rule changes are propagated to instances associated with the security
    # group as quickly as possible. However, a small delay might occur.
    #
    # For examples of rules that you can add to security groups for specific
    # access scenarios, see [Security group rules for different use
    # cases][2] in the *Amazon EC2 User Guide*.
    #
    # For more information about security group quotas, see [Amazon VPC
    # quotas][3] in the *Amazon VPC User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/security-group-rules.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules-reference.html
    # [3]: https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html
    #
    # @option params [String] :cidr_ip
    #   The IPv4 address range, in CIDR format.
    #
    #   <note markdown="1"> Amazon Web Services [canonicalizes][1] IPv4 and IPv6 CIDRs. For
    #   example, if you specify 100.68.0.18/18 for the CIDR block, Amazon Web
    #   Services canonicalizes the CIDR block to 100.68.0.0/18. Any subsequent
    #   DescribeSecurityGroups and DescribeSecurityGroupRules calls will
    #   return the canonicalized form of the CIDR block. Additionally, if you
    #   attempt to add another rule with the non-canonical form of the CIDR
    #   (such as 100.68.0.18/18) and there is already a rule for the
    #   canonicalized form of the CIDR block (such as 100.68.0.0/18), the API
    #   throws an duplicate rule error.
    #
    #    </note>
    #
    #   To specify an IPv6 address range, use IP permissions instead.
    #
    #   To specify multiple rules and descriptions for the rules, use IP
    #   permissions instead.
    #
    #
    #
    #   [1]: https://en.wikipedia.org/wiki/Canonicalization
    #
    # @option params [Integer] :from_port
    #   If the protocol is TCP or UDP, this is the start of the port range. If
    #   the protocol is ICMP, this is the ICMP type or -1 (all ICMP types).
    #
    #   To specify multiple rules and descriptions for the rules, use IP
    #   permissions instead.
    #
    # @option params [String] :group_id
    #   The ID of the security group.
    #
    # @option params [String] :group_name
    #   \[Default VPC\] The name of the security group. For security groups
    #   for a default VPC you can specify either the ID or the name of the
    #   security group. For security groups for a nondefault VPC, you must
    #   specify the ID of the security group.
    #
    # @option params [Array<Types::IpPermission>] :ip_permissions
    #   The permissions for the security group rules.
    #
    # @option params [String] :ip_protocol
    #   The IP protocol name (`tcp`, `udp`, `icmp`) or number (see [Protocol
    #   Numbers][1]). To specify all protocols, use `-1`.
    #
    #   To specify `icmpv6`, use IP permissions instead.
    #
    #   If you specify a protocol other than one of the supported values,
    #   traffic is allowed on all ports, regardless of any ports that you
    #   specify.
    #
    #   To specify multiple rules and descriptions for the rules, use IP
    #   permissions instead.
    #
    #
    #
    #   [1]: http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml
    #
    # @option params [String] :source_security_group_name
    #   \[Default VPC\] The name of the source security group.
    #
    #   The rule grants full ICMP, UDP, and TCP access. To create a rule with
    #   a specific protocol and port range, specify a set of IP permissions
    #   instead.
    #
    # @option params [String] :source_security_group_owner_id
    #   The Amazon Web Services account ID for the source security group, if
    #   the source security group is in a different account.
    #
    #   The rule grants full ICMP, UDP, and TCP access. To create a rule with
    #   a specific protocol and port range, use IP permissions instead.
    #
    # @option params [Integer] :to_port
    #   If the protocol is TCP or UDP, this is the end of the port range. If
    #   the protocol is ICMP, this is the ICMP code or -1 (all ICMP codes). If
    #   the start port is -1 (all ICMP types), then the end port must be -1
    #   (all ICMP codes).
    #
    #   To specify multiple rules and descriptions for the rules, use IP
    #   permissions instead.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags applied to the security group rule.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::AuthorizeSecurityGroupIngressResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AuthorizeSecurityGroupIngressResult#return #return} => Boolean
    #   * {Types::AuthorizeSecurityGroupIngressResult#security_group_rules #security_group_rules} => Array&lt;Types::SecurityGroupRule&gt;
    #
    #
    # @example Example: To add a rule that allows inbound SSH traffic from an IPv4 address range
    #
    #   # This example enables inbound traffic on TCP port 22 (SSH). The rule includes a description to help you identify it
    #   # later.
    #
    #   resp = client.authorize_security_group_ingress({
    #     group_id: "sg-903004f8", 
    #     ip_permissions: [
    #       {
    #         from_port: 22, 
    #         ip_protocol: "tcp", 
    #         ip_ranges: [
    #           {
    #             cidr_ip: "203.0.113.0/24", 
    #             description: "SSH access from the LA office", 
    #           }, 
    #         ], 
    #         to_port: 22, 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Example: To add a rule that allows inbound HTTP traffic from another security group
    #
    #   # This example enables inbound traffic on TCP port 80 from the specified security group. The group must be in the same VPC
    #   # or a peer VPC. Incoming traffic is allowed based on the private IP addresses of instances that are associated with the
    #   # specified security group.
    #
    #   resp = client.authorize_security_group_ingress({
    #     group_id: "sg-111aaa22", 
    #     ip_permissions: [
    #       {
    #         from_port: 80, 
    #         ip_protocol: "tcp", 
    #         to_port: 80, 
    #         user_id_group_pairs: [
    #           {
    #             description: "HTTP access from other instances", 
    #             group_id: "sg-1a2b3c4d", 
    #           }, 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Example: To add a rule that allows inbound RDP traffic from an IPv6 address range
    #
    #   # This example adds an inbound rule that allows RDP traffic from the specified IPv6 address range. The rule includes a
    #   # description to help you identify it later.
    #
    #   resp = client.authorize_security_group_ingress({
    #     group_id: "sg-123abc12 ", 
    #     ip_permissions: [
    #       {
    #         from_port: 3389, 
    #         ip_protocol: "tcp", 
    #         ipv_6_ranges: [
    #           {
    #             cidr_ipv_6: "2001:db8:1234:1a00::/64", 
    #             description: "RDP access from the NY office", 
    #           }, 
    #         ], 
    #         to_port: 3389, 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.authorize_security_group_ingress({
    #     cidr_ip: "String",
    #     from_port: 1,
    #     group_id: "SecurityGroupId",
    #     group_name: "SecurityGroupName",
    #     ip_permissions: [
    #       {
    #         ip_protocol: "String",
    #         from_port: 1,
    #         to_port: 1,
    #         user_id_group_pairs: [
    #           {
    #             description: "String",
    #             user_id: "String",
    #             group_name: "String",
    #             group_id: "String",
    #             vpc_id: "String",
    #             vpc_peering_connection_id: "String",
    #             peering_status: "String",
    #           },
    #         ],
    #         ip_ranges: [
    #           {
    #             description: "String",
    #             cidr_ip: "String",
    #           },
    #         ],
    #         ipv_6_ranges: [
    #           {
    #             description: "String",
    #             cidr_ipv_6: "String",
    #           },
    #         ],
    #         prefix_list_ids: [
    #           {
    #             description: "String",
    #             prefix_list_id: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     ip_protocol: "String",
    #     source_security_group_name: "String",
    #     source_security_group_owner_id: "String",
    #     to_port: 1,
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #   resp.security_group_rules #=> Array
    #   resp.security_group_rules[0].security_group_rule_id #=> String
    #   resp.security_group_rules[0].group_id #=> String
    #   resp.security_group_rules[0].group_owner_id #=> String
    #   resp.security_group_rules[0].is_egress #=> Boolean
    #   resp.security_group_rules[0].ip_protocol #=> String
    #   resp.security_group_rules[0].from_port #=> Integer
    #   resp.security_group_rules[0].to_port #=> Integer
    #   resp.security_group_rules[0].cidr_ipv_4 #=> String
    #   resp.security_group_rules[0].cidr_ipv_6 #=> String
    #   resp.security_group_rules[0].prefix_list_id #=> String
    #   resp.security_group_rules[0].referenced_group_info.group_id #=> String
    #   resp.security_group_rules[0].referenced_group_info.peering_status #=> String
    #   resp.security_group_rules[0].referenced_group_info.user_id #=> String
    #   resp.security_group_rules[0].referenced_group_info.vpc_id #=> String
    #   resp.security_group_rules[0].referenced_group_info.vpc_peering_connection_id #=> String
    #   resp.security_group_rules[0].description #=> String
    #   resp.security_group_rules[0].tags #=> Array
    #   resp.security_group_rules[0].tags[0].key #=> String
    #   resp.security_group_rules[0].tags[0].value #=> String
    #   resp.security_group_rules[0].security_group_rule_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngress AWS API Documentation
    #
    # @overload authorize_security_group_ingress(params = {})
    # @param [Hash] params ({})
    def authorize_security_group_ingress(params = {}, options = {})
      req = build_request(:authorize_security_group_ingress, params)
      req.send_request(options)
    end

    # Bundles an Amazon instance store-backed Windows instance.
    #
    # During bundling, only the root device volume (C:\\) is bundled. Data
    # on other instance store volumes is not preserved.
    #
    # <note markdown="1"> This action is not applicable for Linux/Unix instances or Windows
    # instances that are backed by Amazon EBS.
    #
    #  </note>
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance to bundle.
    #
    #   Default: None
    #
    # @option params [required, Types::Storage] :storage
    #   The bucket in which to store the AMI. You can specify a bucket that
    #   you already own or a new bucket that Amazon EC2 creates on your
    #   behalf. If you specify a bucket that belongs to someone else, Amazon
    #   EC2 returns an error.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::BundleInstanceResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::BundleInstanceResult#bundle_task #bundle_task} => Types::BundleTask
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.bundle_instance({
    #     instance_id: "InstanceId", # required
    #     storage: { # required
    #       s3: {
    #         aws_access_key_id: "String",
    #         bucket: "String",
    #         prefix: "String",
    #         upload_policy: "data",
    #         upload_policy_signature: "S3StorageUploadPolicySignature",
    #       },
    #     },
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.bundle_task.instance_id #=> String
    #   resp.bundle_task.bundle_id #=> String
    #   resp.bundle_task.state #=> String, one of "pending", "waiting-for-shutdown", "bundling", "storing", "cancelling", "complete", "failed"
    #   resp.bundle_task.start_time #=> Time
    #   resp.bundle_task.update_time #=> Time
    #   resp.bundle_task.storage.s3.aws_access_key_id #=> String
    #   resp.bundle_task.storage.s3.bucket #=> String
    #   resp.bundle_task.storage.s3.prefix #=> String
    #   resp.bundle_task.storage.s3.upload_policy #=> String
    #   resp.bundle_task.storage.s3.upload_policy_signature #=> String
    #   resp.bundle_task.progress #=> String
    #   resp.bundle_task.bundle_task_error.code #=> String
    #   resp.bundle_task.bundle_task_error.message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstance AWS API Documentation
    #
    # @overload bundle_instance(params = {})
    # @param [Hash] params ({})
    def bundle_instance(params = {}, options = {})
      req = build_request(:bundle_instance, params)
      req.send_request(options)
    end

    # Cancels a bundling operation for an instance store-backed Windows
    # instance.
    #
    # @option params [required, String] :bundle_id
    #   The ID of the bundle task.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CancelBundleTaskResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelBundleTaskResult#bundle_task #bundle_task} => Types::BundleTask
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_bundle_task({
    #     bundle_id: "BundleId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.bundle_task.instance_id #=> String
    #   resp.bundle_task.bundle_id #=> String
    #   resp.bundle_task.state #=> String, one of "pending", "waiting-for-shutdown", "bundling", "storing", "cancelling", "complete", "failed"
    #   resp.bundle_task.start_time #=> Time
    #   resp.bundle_task.update_time #=> Time
    #   resp.bundle_task.storage.s3.aws_access_key_id #=> String
    #   resp.bundle_task.storage.s3.bucket #=> String
    #   resp.bundle_task.storage.s3.prefix #=> String
    #   resp.bundle_task.storage.s3.upload_policy #=> String
    #   resp.bundle_task.storage.s3.upload_policy_signature #=> String
    #   resp.bundle_task.progress #=> String
    #   resp.bundle_task.bundle_task_error.code #=> String
    #   resp.bundle_task.bundle_task_error.message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTask AWS API Documentation
    #
    # @overload cancel_bundle_task(params = {})
    # @param [Hash] params ({})
    def cancel_bundle_task(params = {}, options = {})
      req = build_request(:cancel_bundle_task, params)
      req.send_request(options)
    end

    # Cancels the specified Capacity Reservation, releases the reserved
    # capacity, and changes the Capacity Reservation's state to
    # `cancelled`.
    #
    # You can cancel a Capacity Reservation that is in the following states:
    #
    # * `assessing`
    #
    # * `active` and there is no commitment duration or the commitment
    #   duration has elapsed. You can't cancel a future-dated Capacity
    #   Reservation during the commitment duration.
    #
    # <note markdown="1"> You can't modify or cancel a Capacity Block. For more information,
    # see [Capacity Blocks for ML][1].
    #
    #  </note>
    #
    # If a future-dated Capacity Reservation enters the `delayed` state, the
    # commitment duration is waived, and you can cancel it as soon as it
    # enters the `active` state.
    #
    # Instances running in the reserved capacity continue running until you
    # stop them. Stopped instances that target the Capacity Reservation can
    # no longer launch. Modify these instances to either target a different
    # Capacity Reservation, launch On-Demand Instance capacity, or run in
    # any open Capacity Reservation that has matching attributes and
    # sufficient capacity.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-blocks.html
    #
    # @option params [required, String] :capacity_reservation_id
    #   The ID of the Capacity Reservation to be cancelled.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CancelCapacityReservationResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelCapacityReservationResult#return #return} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_capacity_reservation({
    #     capacity_reservation_id: "CapacityReservationId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservation AWS API Documentation
    #
    # @overload cancel_capacity_reservation(params = {})
    # @param [Hash] params ({})
    def cancel_capacity_reservation(params = {}, options = {})
      req = build_request(:cancel_capacity_reservation, params)
      req.send_request(options)
    end

    # Cancels one or more Capacity Reservation Fleets. When you cancel a
    # Capacity Reservation Fleet, the following happens:
    #
    # * The Capacity Reservation Fleet's status changes to `cancelled`.
    #
    # * The individual Capacity Reservations in the Fleet are cancelled.
    #   Instances running in the Capacity Reservations at the time of
    #   cancelling the Fleet continue to run in shared capacity.
    #
    # * The Fleet stops creating new Capacity Reservations.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :capacity_reservation_fleet_ids
    #   The IDs of the Capacity Reservation Fleets to cancel.
    #
    # @return [Types::CancelCapacityReservationFleetsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelCapacityReservationFleetsResult#successful_fleet_cancellations #successful_fleet_cancellations} => Array&lt;Types::CapacityReservationFleetCancellationState&gt;
    #   * {Types::CancelCapacityReservationFleetsResult#failed_fleet_cancellations #failed_fleet_cancellations} => Array&lt;Types::FailedCapacityReservationFleetCancellationResult&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_capacity_reservation_fleets({
    #     dry_run: false,
    #     capacity_reservation_fleet_ids: ["CapacityReservationFleetId"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.successful_fleet_cancellations #=> Array
    #   resp.successful_fleet_cancellations[0].current_fleet_state #=> String, one of "submitted", "modifying", "active", "partially_fulfilled", "expiring", "expired", "cancelling", "cancelled", "failed"
    #   resp.successful_fleet_cancellations[0].previous_fleet_state #=> String, one of "submitted", "modifying", "active", "partially_fulfilled", "expiring", "expired", "cancelling", "cancelled", "failed"
    #   resp.successful_fleet_cancellations[0].capacity_reservation_fleet_id #=> String
    #   resp.failed_fleet_cancellations #=> Array
    #   resp.failed_fleet_cancellations[0].capacity_reservation_fleet_id #=> String
    #   resp.failed_fleet_cancellations[0].cancel_capacity_reservation_fleet_error.code #=> String
    #   resp.failed_fleet_cancellations[0].cancel_capacity_reservation_fleet_error.message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservationFleets AWS API Documentation
    #
    # @overload cancel_capacity_reservation_fleets(params = {})
    # @param [Hash] params ({})
    def cancel_capacity_reservation_fleets(params = {}, options = {})
      req = build_request(:cancel_capacity_reservation_fleets, params)
      req.send_request(options)
    end

    # Cancels an active conversion task. The task can be the import of an
    # instance or volume. The action removes all artifacts of the
    # conversion, including a partially uploaded volume or instance. If the
    # conversion is complete or is in the process of transferring the final
    # disk image, the command fails and returns an exception.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :conversion_task_id
    #   The ID of the conversion task.
    #
    # @option params [String] :reason_message
    #   The reason for canceling the conversion task.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_conversion_task({
    #     dry_run: false,
    #     conversion_task_id: "ConversionTaskId", # required
    #     reason_message: "String",
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionTask AWS API Documentation
    #
    # @overload cancel_conversion_task(params = {})
    # @param [Hash] params ({})
    def cancel_conversion_task(params = {}, options = {})
      req = build_request(:cancel_conversion_task, params)
      req.send_request(options)
    end

    # Cancels the generation of an account status report.
    #
    # You can only cancel a report while it has the `running` status.
    # Reports with other statuses (`complete`, `cancelled`, or `error`)
    # can't be canceled.
    #
    # For more information, see [Generating the account status report for
    # declarative policies][1] in the *Amazon Web Services Organizations
    # User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative_status-report.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :report_id
    #   The ID of the report.
    #
    # @return [Types::CancelDeclarativePoliciesReportResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelDeclarativePoliciesReportResult#return #return} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_declarative_policies_report({
    #     dry_run: false,
    #     report_id: "DeclarativePoliciesReportId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelDeclarativePoliciesReport AWS API Documentation
    #
    # @overload cancel_declarative_policies_report(params = {})
    # @param [Hash] params ({})
    def cancel_declarative_policies_report(params = {}, options = {})
      req = build_request(:cancel_declarative_policies_report, params)
      req.send_request(options)
    end

    # Cancels an active export task. The request removes all artifacts of
    # the export, including any partially-created Amazon S3 objects. If the
    # export task is complete or is in the process of transferring the final
    # disk image, the command fails and returns an error.
    #
    # @option params [required, String] :export_task_id
    #   The ID of the export task. This is the ID returned by the
    #   `CreateInstanceExportTask` and `ExportImage` operations.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_export_task({
    #     export_task_id: "ExportVmTaskId", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTask AWS API Documentation
    #
    # @overload cancel_export_task(params = {})
    # @param [Hash] params ({})
    def cancel_export_task(params = {}, options = {})
      req = build_request(:cancel_export_task, params)
      req.send_request(options)
    end

    # Removes your Amazon Web Services account from the launch permissions
    # for the specified AMI. For more information, see [Cancel having an AMI
    # shared with your Amazon Web Services account][1] in the *Amazon EC2
    # User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cancel-sharing-an-AMI.html
    #
    # @option params [required, String] :image_id
    #   The ID of the AMI that was shared with your Amazon Web Services
    #   account.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CancelImageLaunchPermissionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelImageLaunchPermissionResult#return #return} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_image_launch_permission({
    #     image_id: "ImageId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImageLaunchPermission AWS API Documentation
    #
    # @overload cancel_image_launch_permission(params = {})
    # @param [Hash] params ({})
    def cancel_image_launch_permission(params = {}, options = {})
      req = build_request(:cancel_image_launch_permission, params)
      req.send_request(options)
    end

    # Cancels an in-process import virtual machine or import snapshot task.
    #
    # @option params [String] :cancel_reason
    #   The reason for canceling the task.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :import_task_id
    #   The ID of the import image or import snapshot task to be canceled.
    #
    # @return [Types::CancelImportTaskResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelImportTaskResult#import_task_id #import_task_id} => String
    #   * {Types::CancelImportTaskResult#previous_state #previous_state} => String
    #   * {Types::CancelImportTaskResult#state #state} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_import_task({
    #     cancel_reason: "String",
    #     dry_run: false,
    #     import_task_id: "ImportTaskId",
    #   })
    #
    # @example Response structure
    #
    #   resp.import_task_id #=> String
    #   resp.previous_state #=> String
    #   resp.state #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTask AWS API Documentation
    #
    # @overload cancel_import_task(params = {})
    # @param [Hash] params ({})
    def cancel_import_task(params = {}, options = {})
      req = build_request(:cancel_import_task, params)
      req.send_request(options)
    end

    # Cancels the specified Reserved Instance listing in the Reserved
    # Instance Marketplace.
    #
    # For more information, see [Sell in the Reserved Instance
    # Marketplace][1] in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html
    #
    # @option params [required, String] :reserved_instances_listing_id
    #   The ID of the Reserved Instance listing.
    #
    # @return [Types::CancelReservedInstancesListingResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelReservedInstancesListingResult#reserved_instances_listings #reserved_instances_listings} => Array&lt;Types::ReservedInstancesListing&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_reserved_instances_listing({
    #     reserved_instances_listing_id: "ReservedInstancesListingId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.reserved_instances_listings #=> Array
    #   resp.reserved_instances_listings[0].client_token #=> String
    #   resp.reserved_instances_listings[0].create_date #=> Time
    #   resp.reserved_instances_listings[0].instance_counts #=> Array
    #   resp.reserved_instances_listings[0].instance_counts[0].instance_count #=> Integer
    #   resp.reserved_instances_listings[0].instance_counts[0].state #=> String, one of "available", "sold", "cancelled", "pending"
    #   resp.reserved_instances_listings[0].price_schedules #=> Array
    #   resp.reserved_instances_listings[0].price_schedules[0].active #=> Boolean
    #   resp.reserved_instances_listings[0].price_schedules[0].currency_code #=> String, one of "USD"
    #   resp.reserved_instances_listings[0].price_schedules[0].price #=> Float
    #   resp.reserved_instances_listings[0].price_schedules[0].term #=> Integer
    #   resp.reserved_instances_listings[0].reserved_instances_id #=> String
    #   resp.reserved_instances_listings[0].reserved_instances_listing_id #=> String
    #   resp.reserved_instances_listings[0].status #=> String, one of "active", "pending", "cancelled", "closed"
    #   resp.reserved_instances_listings[0].status_message #=> String
    #   resp.reserved_instances_listings[0].tags #=> Array
    #   resp.reserved_instances_listings[0].tags[0].key #=> String
    #   resp.reserved_instances_listings[0].tags[0].value #=> String
    #   resp.reserved_instances_listings[0].update_date #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListing AWS API Documentation
    #
    # @overload cancel_reserved_instances_listing(params = {})
    # @param [Hash] params ({})
    def cancel_reserved_instances_listing(params = {}, options = {})
      req = build_request(:cancel_reserved_instances_listing, params)
      req.send_request(options)
    end

    # Cancels the specified Spot Fleet requests.
    #
    # After you cancel a Spot Fleet request, the Spot Fleet launches no new
    # instances.
    #
    # You must also specify whether a canceled Spot Fleet request should
    # terminate its instances. If you choose to terminate the instances, the
    # Spot Fleet request enters the `cancelled_terminating` state.
    # Otherwise, the Spot Fleet request enters the `cancelled_running` state
    # and the instances continue to run until they are interrupted or you
    # terminate them manually.
    #
    # **Restrictions**
    #
    # * You can delete up to 100 fleets in a single request. If you exceed
    #   the specified number, no fleets are deleted.
    #
    # ^
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :spot_fleet_request_ids
    #   The IDs of the Spot Fleet requests.
    #
    #   Constraint: You can specify up to 100 IDs in a single request.
    #
    # @option params [required, Boolean] :terminate_instances
    #   Indicates whether to terminate the associated instances when the Spot
    #   Fleet request is canceled. The default is to terminate the instances.
    #
    #   To let the instances continue to run after the Spot Fleet request is
    #   canceled, specify `no-terminate-instances`.
    #
    # @return [Types::CancelSpotFleetRequestsResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelSpotFleetRequestsResponse#successful_fleet_requests #successful_fleet_requests} => Array&lt;Types::CancelSpotFleetRequestsSuccessItem&gt;
    #   * {Types::CancelSpotFleetRequestsResponse#unsuccessful_fleet_requests #unsuccessful_fleet_requests} => Array&lt;Types::CancelSpotFleetRequestsErrorItem&gt;
    #
    #
    # @example Example: To cancel a Spot fleet request
    #
    #   # This example cancels the specified Spot fleet request and terminates its associated Spot Instances.
    #
    #   resp = client.cancel_spot_fleet_requests({
    #     spot_fleet_request_ids: [
    #       "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE", 
    #     ], 
    #     terminate_instances: true, 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     successful_fleet_requests: [
    #       {
    #         current_spot_fleet_request_state: "cancelled_running", 
    #         previous_spot_fleet_request_state: "active", 
    #         spot_fleet_request_id: "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Example: To cancel a Spot fleet request without terminating its Spot Instances
    #
    #   # This example cancels the specified Spot fleet request without terminating its associated Spot Instances.
    #
    #   resp = client.cancel_spot_fleet_requests({
    #     spot_fleet_request_ids: [
    #       "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE", 
    #     ], 
    #     terminate_instances: false, 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     successful_fleet_requests: [
    #       {
    #         current_spot_fleet_request_state: "cancelled_terminating", 
    #         previous_spot_fleet_request_state: "active", 
    #         spot_fleet_request_id: "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_spot_fleet_requests({
    #     dry_run: false,
    #     spot_fleet_request_ids: ["SpotFleetRequestId"], # required
    #     terminate_instances: false, # required
    #   })
    #
    # @example Response structure
    #
    #   resp.successful_fleet_requests #=> Array
    #   resp.successful_fleet_requests[0].current_spot_fleet_request_state #=> String, one of "submitted", "active", "cancelled", "failed", "cancelled_running", "cancelled_terminating", "modifying"
    #   resp.successful_fleet_requests[0].previous_spot_fleet_request_state #=> String, one of "submitted", "active", "cancelled", "failed", "cancelled_running", "cancelled_terminating", "modifying"
    #   resp.successful_fleet_requests[0].spot_fleet_request_id #=> String
    #   resp.unsuccessful_fleet_requests #=> Array
    #   resp.unsuccessful_fleet_requests[0].error.code #=> String, one of "fleetRequestIdDoesNotExist", "fleetRequestIdMalformed", "fleetRequestNotInCancellableState", "unexpectedError"
    #   resp.unsuccessful_fleet_requests[0].error.message #=> String
    #   resp.unsuccessful_fleet_requests[0].spot_fleet_request_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequests AWS API Documentation
    #
    # @overload cancel_spot_fleet_requests(params = {})
    # @param [Hash] params ({})
    def cancel_spot_fleet_requests(params = {}, options = {})
      req = build_request(:cancel_spot_fleet_requests, params)
      req.send_request(options)
    end

    # Cancels one or more Spot Instance requests.
    #
    # Canceling a Spot Instance request does not terminate running Spot
    # Instances associated with the request.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :spot_instance_request_ids
    #   The IDs of the Spot Instance requests.
    #
    # @return [Types::CancelSpotInstanceRequestsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CancelSpotInstanceRequestsResult#cancelled_spot_instance_requests #cancelled_spot_instance_requests} => Array&lt;Types::CancelledSpotInstanceRequest&gt;
    #
    #
    # @example Example: To cancel Spot Instance requests
    #
    #   # This example cancels a Spot Instance request.
    #
    #   resp = client.cancel_spot_instance_requests({
    #     spot_instance_request_ids: [
    #       "sir-08b93456", 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     cancelled_spot_instance_requests: [
    #       {
    #         spot_instance_request_id: "sir-08b93456", 
    #         state: "cancelled", 
    #       }, 
    #     ], 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.cancel_spot_instance_requests({
    #     dry_run: false,
    #     spot_instance_request_ids: ["SpotInstanceRequestId"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.cancelled_spot_instance_requests #=> Array
    #   resp.cancelled_spot_instance_requests[0].spot_instance_request_id #=> String
    #   resp.cancelled_spot_instance_requests[0].state #=> String, one of "active", "open", "closed", "cancelled", "completed"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequests AWS API Documentation
    #
    # @overload cancel_spot_instance_requests(params = {})
    # @param [Hash] params ({})
    def cancel_spot_instance_requests(params = {}, options = {})
      req = build_request(:cancel_spot_instance_requests, params)
      req.send_request(options)
    end

    # Determines whether a product code is associated with an instance. This
    # action can only be used by the owner of the product code. It is useful
    # when a product code owner must verify whether another user's instance
    # is eligible for support.
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance.
    #
    # @option params [required, String] :product_code
    #   The product code. This must be a product code that you own.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the operation,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::ConfirmProductInstanceResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ConfirmProductInstanceResult#return #return} => Boolean
    #   * {Types::ConfirmProductInstanceResult#owner_id #owner_id} => String
    #
    #
    # @example Example: To confirm the product instance
    #
    #   # This example determines whether the specified product code is associated with the specified instance.
    #
    #   resp = client.confirm_product_instance({
    #     instance_id: "i-1234567890abcdef0", 
    #     product_code: "774F4FF8", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     owner_id: "123456789012", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.confirm_product_instance({
    #     instance_id: "InstanceId", # required
    #     product_code: "String", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #   resp.owner_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstance AWS API Documentation
    #
    # @overload confirm_product_instance(params = {})
    # @param [Hash] params ({})
    def confirm_product_instance(params = {}, options = {})
      req = build_request(:confirm_product_instance, params)
      req.send_request(options)
    end

    # Copies the specified Amazon FPGA Image (AFI) to the current Region.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :source_fpga_image_id
    #   The ID of the source AFI.
    #
    # @option params [String] :description
    #   The description for the new AFI.
    #
    # @option params [String] :name
    #   The name for the new AFI. The default is the name of the source AFI.
    #
    # @option params [required, String] :source_region
    #   The Region that contains the source AFI.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @return [Types::CopyFpgaImageResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CopyFpgaImageResult#fpga_image_id #fpga_image_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.copy_fpga_image({
    #     dry_run: false,
    #     source_fpga_image_id: "String", # required
    #     description: "String",
    #     name: "String",
    #     source_region: "String", # required
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.fpga_image_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImage AWS API Documentation
    #
    # @overload copy_fpga_image(params = {})
    # @param [Hash] params ({})
    def copy_fpga_image(params = {}, options = {})
      req = build_request(:copy_fpga_image, params)
      req.send_request(options)
    end

    # Initiates an AMI copy operation. You must specify the source AMI ID
    # and both the source and destination locations. The copy operation must
    # be initiated in the destination Region.
    #
    # **CopyImage supports the following source to destination copies:**
    #
    # * Region to Region
    #
    # * Region to Outpost
    #
    # * Parent Region to Local Zone
    #
    # * Local Zone to parent Region
    #
    # * Between Local Zones with the same parent Region (only supported for
    #   certain Local Zones)
    #
    # **CopyImage does not support the following source to destination
    # copies:**
    #
    # * Local Zone to non-parent Regions
    #
    # * Between Local Zones with different parent Regions
    #
    # * Local Zone to Outpost
    #
    # * Outpost to Local Zone
    #
    # * Outpost to Region
    #
    # * Between Outposts
    #
    # * Within same Outpost
    #
    # * Cross-partition copies (use [CreateStoreImageTask][1] instead)
    #
    # **Destination specification**
    #
    # * Region to Region: The destination Region is the Region in which you
    #   initiate the copy operation.
    #
    # * Region to Outpost: Specify the destination using the
    #   `DestinationOutpostArn` parameter (the ARN of the Outpost)
    #
    # * Region to Local Zone, and Local Zone to Local Zone copies: Specify
    #   the destination using the `DestinationAvailabilityZone` parameter
    #   (the name of the destination Local Zone) or
    #   `DestinationAvailabilityZoneId` parameter (the ID of the destination
    #   Local Zone).
    #
    # **Snapshot encryption**
    #
    # * Region to Outpost: Backing snapshots copied to an Outpost are
    #   encrypted by default using the default encryption key for the Region
    #   or the key that you specify. Outposts do not support unencrypted
    #   snapshots.
    #
    # * Region to Local Zone, and Local Zone to Local Zone: Not all Local
    #   Zones require encrypted snapshots. In Local Zones that require
    #   encrypted snapshots, backing snapshots are automatically encrypted
    #   during copy. In Local Zones where encryption is not required,
    #   snapshots retain their original encryption state (encrypted or
    #   unencrypted) by default.
    #
    # For more information, including the required permissions for copying
    # an AMI, see [Copy an Amazon EC2 AMI][2] in the *Amazon EC2 User
    # Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier you provide to ensure idempotency of
    #   the request. For more information, see [Ensuring idempotency in Amazon
    #   EC2 API requests][1] in the *Amazon EC2 API Reference*.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [String] :description
    #   A description for the new AMI.
    #
    # @option params [Boolean] :encrypted
    #   Specifies whether to encrypt the snapshots of the copied image.
    #
    #   You can encrypt a copy of an unencrypted snapshot, but you cannot
    #   create an unencrypted copy of an encrypted snapshot. The default KMS
    #   key for Amazon EBS is used unless you specify a non-default Key
    #   Management Service (KMS) KMS key using `KmsKeyId`. For more
    #   information, see [Use encryption with EBS-backed AMIs][1] in the
    #   *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AMIEncryption.html
    #
    # @option params [String] :kms_key_id
    #   The identifier of the symmetric Key Management Service (KMS) KMS key
    #   to use when creating encrypted volumes. If this parameter is not
    #   specified, your Amazon Web Services managed KMS key for Amazon EBS is
    #   used. If you specify a KMS key, you must also set the encrypted state
    #   to `true`.
    #
    #   You can specify a KMS key using any of the following:
    #
    #   * Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Key alias. For example, alias/ExampleAlias.
    #
    #   * Key ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Alias ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
    #
    #   Amazon Web Services authenticates the KMS key asynchronously.
    #   Therefore, if you specify an identifier that is not valid, the action
    #   can appear to complete, but eventually fails.
    #
    #   The specified KMS key must exist in the destination Region.
    #
    #   Amazon EBS does not support asymmetric KMS keys.
    #
    # @option params [required, String] :name
    #   The name of the new AMI.
    #
    # @option params [required, String] :source_image_id
    #   The ID of the AMI to copy.
    #
    # @option params [required, String] :source_region
    #   The name of the Region that contains the AMI to copy.
    #
    # @option params [String] :destination_outpost_arn
    #   The Amazon Resource Name (ARN) of the Outpost for the new AMI.
    #
    #   Only specify this parameter when copying an AMI from an Amazon Web
    #   Services Region to an Outpost. The AMI must be in the Region of the
    #   destination Outpost. You can't copy an AMI from an Outpost to a
    #   Region, from one Outpost to another, or within the same Outpost.
    #
    #   For more information, see [Copy AMIs from an Amazon Web Services
    #   Region to an Outpost][1] in the *Amazon EBS User Guide*.
    #
    #   Only one of `DestinationAvailabilityZone`,
    #   `DestinationAvailabilityZoneId`, or `DestinationOutpostArn` can be
    #   specified.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#copy-amis
    #
    # @option params [Boolean] :copy_image_tags
    #   Specifies whether to copy your user-defined AMI tags to the new AMI.
    #
    #   The following tags are not be copied:
    #
    #   * System tags (prefixed with `aws:`)
    #
    #   * For public and shared AMIs, user-defined tags that are attached by
    #     other Amazon Web Services accounts
    #
    #   Default: Your user-defined AMI tags are not copied.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the new AMI and new snapshots. You can tag the
    #   AMI, the snapshots, or both.
    #
    #   * To tag the new AMI, the value for `ResourceType` must be `image`.
    #
    #   * To tag the new snapshots, the value for `ResourceType` must be
    #     `snapshot`. The same tag is applied to all the new snapshots.
    #
    #   If you specify other values for `ResourceType`, the request fails.
    #
    #   To tag an AMI or snapshot after it has been created, see
    #   [CreateTags][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html
    #
    # @option params [Integer] :snapshot_copy_completion_duration_minutes
    #   Specify a completion duration, in 15 minute increments, to initiate a
    #   time-based AMI copy. The specified completion duration applies to each
    #   of the snapshots associated with the AMI. Each snapshot associated
    #   with the AMI will be completed within the specified completion
    #   duration, with copy throughput automatically adjusted for each
    #   snapshot based on its size to meet the timing target.
    #
    #   If you do not specify a value, the AMI copy operation is completed on
    #   a best-effort basis.
    #
    #   <note markdown="1"> This parameter is not supported when copying an AMI to or from a Local
    #   Zone, or to an Outpost.
    #
    #    </note>
    #
    #   For more information, see [Time-based copies for Amazon EBS snapshots
    #   and EBS-backed AMIs][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/time-based-copies.html
    #
    # @option params [String] :destination_availability_zone
    #   The Local Zone for the new AMI (for example, `cn-north-1-pkx-1a`).
    #
    #   Only one of `DestinationAvailabilityZone`,
    #   `DestinationAvailabilityZoneId`, or `DestinationOutpostArn` can be
    #   specified.
    #
    # @option params [String] :destination_availability_zone_id
    #   The ID of the Local Zone for the new AMI (for example,
    #   `cnn1-pkx1-az1`).
    #
    #   Only one of `DestinationAvailabilityZone`,
    #   `DestinationAvailabilityZoneId`, or `DestinationOutpostArn` can be
    #   specified.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CopyImageResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CopyImageResult#image_id #image_id} => String
    #
    #
    # @example Example: To copy an AMI to another region
    #
    #   # This example copies the specified AMI from the us-east-1 region to the current region.
    #
    #   resp = client.copy_image({
    #     description: "", 
    #     name: "My server", 
    #     source_image_id: "ami-5731123e", 
    #     source_region: "us-east-1", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     image_id: "ami-438bea42", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.copy_image({
    #     client_token: "String",
    #     description: "String",
    #     encrypted: false,
    #     kms_key_id: "KmsKeyId",
    #     name: "String", # required
    #     source_image_id: "String", # required
    #     source_region: "String", # required
    #     destination_outpost_arn: "String",
    #     copy_image_tags: false,
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     snapshot_copy_completion_duration_minutes: 1,
    #     destination_availability_zone: "String",
    #     destination_availability_zone_id: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.image_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImage AWS API Documentation
    #
    # @overload copy_image(params = {})
    # @param [Hash] params ({})
    def copy_image(params = {}, options = {})
      req = build_request(:copy_image, params)
      req.send_request(options)
    end

    # Creates an exact copy of an Amazon EBS snapshot.
    #
    # The location of the source snapshot determines whether you can copy it
    # or not, and the allowed destinations for the snapshot copy.
    #
    # * If the source snapshot is in a Region, you can copy it within that
    #   Region, to another Region, to an Outpost associated with that
    #   Region, or to a Local Zone in that Region.
    #
    # * If the source snapshot is in a Local Zone, you can copy it within
    #   that Local Zone, to another Local Zone in the same zone group, or to
    #   the parent Region of the Local Zone.
    #
    # * If the source snapshot is on an Outpost, you can't copy it.
    #
    # When copying snapshots to a Region, copies of encrypted EBS snapshots
    # remain encrypted. Copies of unencrypted snapshots remain unencrypted,
    # unless you enable encryption for the snapshot copy operation. By
    # default, encrypted snapshot copies use the default KMS key; however,
    # you can specify a different KMS key. To copy an encrypted snapshot
    # that has been shared from another account, you must have permissions
    # for the KMS key used to encrypt the snapshot.
    #
    # Snapshots copied to an Outpost are encrypted by default using the
    # default encryption key for the Region, or a different key that you
    # specify in the request using **KmsKeyId**. Outposts do not support
    # unencrypted snapshots. For more information, see [Amazon EBS local
    # snapshots on Outposts][1] in the *Amazon EBS User Guide*.
    #
    # <note markdown="1"> Snapshots copies have an arbitrary source volume ID. Do not use this
    # volume ID for any purpose.
    #
    #  </note>
    #
    # For more information, see [Copy an Amazon EBS snapshot][2] in the
    # *Amazon EBS User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#ami
    # [2]: https://docs.aws.amazon.com/ebs/latest/userguide/ebs-copy-snapshot.html
    #
    # @option params [String] :description
    #   A description for the EBS snapshot.
    #
    # @option params [String] :destination_outpost_arn
    #   The Amazon Resource Name (ARN) of the Outpost to which to copy the
    #   snapshot.
    #
    #   <note markdown="1"> Only supported when copying a snapshot to an Outpost.
    #
    #    </note>
    #
    #   For more information, see [ Copy snapshots from an Amazon Web Services
    #   Region to an Outpost][1] in the *Amazon EBS User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#copy-snapshots
    #
    # @option params [String] :destination_region
    #   The destination Region to use in the `PresignedUrl` parameter of a
    #   snapshot copy operation. This parameter is only valid for specifying
    #   the destination Region in a `PresignedUrl` parameter, where it is
    #   required.
    #
    #   The snapshot copy is sent to the regional endpoint that you sent the
    #   HTTP request to (for example, `ec2.us-east-1.amazonaws.com`). With the
    #   CLI, this is specified using the `--region` parameter or the default
    #   Region in your Amazon Web Services configuration file.
    #
    # @option params [Boolean] :encrypted
    #   To encrypt a copy of an unencrypted snapshot if encryption by default
    #   is not enabled, enable encryption using this parameter. Otherwise,
    #   omit this parameter. Encrypted snapshots are encrypted, even if you
    #   omit this parameter and encryption by default is not enabled. You
    #   cannot set this parameter to false. For more information, see [Amazon
    #   EBS encryption][1] in the *Amazon EBS User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html
    #
    # @option params [String] :kms_key_id
    #   The identifier of the KMS key to use for Amazon EBS encryption. If
    #   this parameter is not specified, your KMS key for Amazon EBS is used.
    #   If `KmsKeyId` is specified, the encrypted state must be `true`.
    #
    #   You can specify the KMS key using any of the following:
    #
    #   * Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Key alias. For example, alias/ExampleAlias.
    #
    #   * Key ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Alias ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
    #
    #   Amazon Web Services authenticates the KMS key asynchronously.
    #   Therefore, if you specify an ID, alias, or ARN that is not valid, the
    #   action can appear to complete, but eventually fails.
    #
    # @option params [String] :presigned_url
    #   When you copy an encrypted source snapshot using the Amazon EC2 Query
    #   API, you must supply a pre-signed URL. This parameter is optional for
    #   unencrypted snapshots. For more information, see [Query requests][1].
    #
    #   The `PresignedUrl` should use the snapshot source endpoint, the
    #   `CopySnapshot` action, and include the `SourceRegion`,
    #   `SourceSnapshotId`, and `DestinationRegion` parameters. The
    #   `PresignedUrl` must be signed using Amazon Web Services Signature
    #   Version 4. Because EBS snapshots are stored in Amazon S3, the signing
    #   algorithm for this parameter uses the same logic that is described in
    #   [ Authenticating Requests: Using Query Parameters (Amazon Web Services
    #   Signature Version 4)][2] in the *Amazon S3 API Reference*. An invalid
    #   or improperly signed `PresignedUrl` will cause the copy operation to
    #   fail asynchronously, and the snapshot will move to an `error` state.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html
    #   [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html
    #
    # @option params [required, String] :source_region
    #   The ID of the Region that contains the snapshot to be copied.
    #
    # @option params [required, String] :source_snapshot_id
    #   The ID of the EBS snapshot to copy.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the new snapshot.
    #
    # @option params [Integer] :completion_duration_minutes
    #   <note markdown="1"> Not supported when copying snapshots to or from Local Zones or
    #   Outposts.
    #
    #    </note>
    #
    #   Specify a completion duration, in 15 minute increments, to initiate a
    #   time-based snapshot copy. Time-based snapshot copy operations complete
    #   within the specified duration. For more information, see [ Time-based
    #   copies][1].
    #
    #   If you do not specify a value, the snapshot copy operation is
    #   completed on a best-effort basis.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/time-based-copies.html
    #
    # @option params [String] :destination_availability_zone
    #   The Local Zone, for example, `cn-north-1-pkx-1a` to which to copy the
    #   snapshot.
    #
    #   <note markdown="1"> Only supported when copying a snapshot to a Local Zone.
    #
    #    </note>
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CopySnapshotResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CopySnapshotResult#tags #tags} => Array&lt;Types::Tag&gt;
    #   * {Types::CopySnapshotResult#snapshot_id #snapshot_id} => String
    #
    #
    # @example Example: To copy a snapshot
    #
    #   # This example copies a snapshot with the snapshot ID of ``snap-066877671789bd71b`` from the ``us-west-2`` region to the
    #   # ``us-east-1`` region and adds a short description to identify the snapshot.
    #
    #   resp = client.copy_snapshot({
    #     description: "This is my copied snapshot.", 
    #     destination_region: "us-east-1", 
    #     source_region: "us-west-2", 
    #     source_snapshot_id: "snap-066877671789bd71b", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     snapshot_id: "snap-066877671789bd71b", 
    #   }
    #
    # @example Copy snapshot example
    #   source_snapshot_id = 'snapshot-id'
    #   source_region = 'us-east-1'
    #   target_region = 'us-west-2'
    #
    #   # You must configure your EC2 client for the destination region to copy
    #   ec2 = Aws::EC2::Client(region: target_region)
    #
    #   resp = ec2.copy_snapshot({
    #       source_region: source_region,
    #       source_snapshot_id: source_snapshot_id,
    #   })
    #
    #   snapshot_id = resp.snapshot_id
    #
    #   ec2.wait_until(:snapshot_completed, snapshot_ids: [snapshot_id])
    #
    # @example Copy an encrypted snapshot
    #   # same as above, expect you must pass `encrypted: true`
    #   resp = ec2.copy_snapshot({
    #       source_region: source_region,
    #       source_snapshot_id: source_snapshot_id,
    #       encrypted: true, # required for encrypted snapshots
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.copy_snapshot({
    #     description: "String",
    #     destination_outpost_arn: "String",
    #     destination_region: "String",
    #     encrypted: false,
    #     kms_key_id: "KmsKeyId",
    #     presigned_url: "CopySnapshotRequestPSU",
    #     source_region: "String", # required
    #     source_snapshot_id: "String", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     completion_duration_minutes: 1,
    #     destination_availability_zone: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.tags #=> Array
    #   resp.tags[0].key #=> String
    #   resp.tags[0].value #=> String
    #   resp.snapshot_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshot AWS API Documentation
    #
    # @overload copy_snapshot(params = {})
    # @param [Hash] params ({})
    def copy_snapshot(params = {}, options = {})
      req = build_request(:copy_snapshot, params)
      req.send_request(options)
    end

    # Creates a new Capacity Reservation with the specified attributes.
    # Capacity Reservations enable you to reserve capacity for your Amazon
    # EC2 instances in a specific Availability Zone for any duration.
    #
    # You can create a Capacity Reservation at any time, and you can choose
    # when it starts. You can create a Capacity Reservation for immediate
    # use or you can request a Capacity Reservation for a future date.
    #
    # For more information, see [ Reserve compute capacity with On-Demand
    # Capacity Reservations][1] in the *Amazon EC2 User Guide*.
    #
    # Your request to create a Capacity Reservation could fail if:
    #
    # * Amazon EC2 does not have sufficient capacity. In this case, try
    #   again at a later time, try in a different Availability Zone, or
    #   request a smaller Capacity Reservation. If your workload is flexible
    #   across instance types and sizes, try with different instance
    #   attributes.
    #
    # * The requested quantity exceeds your On-Demand Instance quota. In
    #   this case, increase your On-Demand Instance quota for the requested
    #   instance type and try again. For more information, see [ Amazon EC2
    #   Service Quotas][2] in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [required, String] :instance_type
    #   The instance type for which to reserve capacity.
    #
    #   <note markdown="1"> You can request future-dated Capacity Reservations for instance types
    #   in the C, M, R, I, T, and G instance families only.
    #
    #    </note>
    #
    #   For more information, see [Instance types][1] in the *Amazon EC2 User
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html
    #
    # @option params [required, String] :instance_platform
    #   The type of operating system for which to reserve capacity.
    #
    # @option params [String] :availability_zone
    #   The Availability Zone in which to create the Capacity Reservation.
    #
    # @option params [String] :availability_zone_id
    #   The ID of the Availability Zone in which to create the Capacity
    #   Reservation.
    #
    # @option params [String] :tenancy
    #   Indicates the tenancy of the Capacity Reservation. A Capacity
    #   Reservation can have one of the following tenancy settings:
    #
    #   * `default` - The Capacity Reservation is created on hardware that is
    #     shared with other Amazon Web Services accounts.
    #
    #   * `dedicated` - The Capacity Reservation is created on single-tenant
    #     hardware that is dedicated to a single Amazon Web Services account.
    #
    # @option params [required, Integer] :instance_count
    #   The number of instances for which to reserve capacity.
    #
    #   <note markdown="1"> You can request future-dated Capacity Reservations for an instance
    #   count with a minimum of 64 vCPUs. For example, if you request a
    #   future-dated Capacity Reservation for `m5.xlarge` instances, you must
    #   request at least 25 instances (*16 * m5.xlarge = 64 vCPUs*).
    #
    #    </note>
    #
    #   Valid range: 1 - 1000
    #
    # @option params [Boolean] :ebs_optimized
    #   Indicates whether the Capacity Reservation supports EBS-optimized
    #   instances. This optimization provides dedicated throughput to Amazon
    #   EBS and an optimized configuration stack to provide optimal I/O
    #   performance. This optimization isn't available with all instance
    #   types. Additional usage charges apply when using an EBS- optimized
    #   instance.
    #
    # @option params [Boolean] :ephemeral_storage
    #   *Deprecated.*
    #
    # @option params [Time,DateTime,Date,Integer,String] :end_date
    #   The date and time at which the Capacity Reservation expires. When a
    #   Capacity Reservation expires, the reserved capacity is released and
    #   you can no longer launch instances into it. The Capacity
    #   Reservation's state changes to `expired` when it reaches its end date
    #   and time.
    #
    #   You must provide an `EndDate` value if `EndDateType` is `limited`.
    #   Omit `EndDate` if `EndDateType` is `unlimited`.
    #
    #   If the `EndDateType` is `limited`, the Capacity Reservation is
    #   cancelled within an hour from the specified time. For example, if you
    #   specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to
    #   end between 13:30:55 and 14:30:55 on 5/31/2019.
    #
    #   If you are requesting a future-dated Capacity Reservation, you can't
    #   specify an end date and time that is within the commitment duration.
    #
    # @option params [String] :end_date_type
    #   Indicates the way in which the Capacity Reservation ends. A Capacity
    #   Reservation can have one of the following end types:
    #
    #   * `unlimited` - The Capacity Reservation remains active until you
    #     explicitly cancel it. Do not provide an `EndDate` if the
    #     `EndDateType` is `unlimited`.
    #
    #   * `limited` - The Capacity Reservation expires automatically at a
    #     specified date and time. You must provide an `EndDate` value if the
    #     `EndDateType` value is `limited`.
    #
    # @option params [String] :instance_match_criteria
    #   Indicates the type of instance launches that the Capacity Reservation
    #   accepts. The options include:
    #
    #   * `open` - The Capacity Reservation automatically matches all
    #     instances that have matching attributes (instance type, platform,
    #     and Availability Zone). Instances that have matching attributes run
    #     in the Capacity Reservation automatically without specifying any
    #     additional parameters.
    #
    #   * `targeted` - The Capacity Reservation only accepts instances that
    #     have matching attributes (instance type, platform, and Availability
    #     Zone), and explicitly target the Capacity Reservation. This ensures
    #     that only permitted instances can use the reserved capacity.
    #
    #   <note markdown="1"> If you are requesting a future-dated Capacity Reservation, you must
    #   specify `targeted`.
    #
    #    </note>
    #
    #   Default: `open`
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the Capacity Reservation during launch.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :outpost_arn
    #   <note markdown="1"> Not supported for future-dated Capacity Reservations.
    #
    #    </note>
    #
    #   The Amazon Resource Name (ARN) of the Outpost on which to create the
    #   Capacity Reservation.
    #
    # @option params [String] :placement_group_arn
    #   <note markdown="1"> Not supported for future-dated Capacity Reservations.
    #
    #    </note>
    #
    #   The Amazon Resource Name (ARN) of the cluster placement group in which
    #   to create the Capacity Reservation. For more information, see [
    #   Capacity Reservations for cluster placement groups][1] in the *Amazon
    #   EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html
    #
    # @option params [Time,DateTime,Date,Integer,String] :start_date
    #   <note markdown="1"> Required for future-dated Capacity Reservations only. To create a
    #   Capacity Reservation for immediate use, omit this parameter.
    #
    #    </note>
    #
    #   The date and time at which the future-dated Capacity Reservation
    #   should become available for use, in the ISO8601 format in the UTC time
    #   zone (`YYYY-MM-DDThh:mm:ss.sssZ`).
    #
    #   You can request a future-dated Capacity Reservation between 5 and 120
    #   days in advance.
    #
    # @option params [Integer] :commitment_duration
    #   <note markdown="1"> Required for future-dated Capacity Reservations only. To create a
    #   Capacity Reservation for immediate use, omit this parameter.
    #
    #    </note>
    #
    #   Specify a commitment duration, in seconds, for the future-dated
    #   Capacity Reservation.
    #
    #   The commitment duration is a minimum duration for which you commit to
    #   having the future-dated Capacity Reservation in the `active` state in
    #   your account after it has been delivered.
    #
    #   For more information, see [ Commitment duration][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-concepts.html#cr-commitment-duration
    #
    # @option params [String] :delivery_preference
    #   <note markdown="1"> Required for future-dated Capacity Reservations only. To create a
    #   Capacity Reservation for immediate use, omit this parameter.
    #
    #    </note>
    #
    #   Indicates that the requested capacity will be delivered in addition to
    #   any running instances or reserved capacity that you have in your
    #   account at the requested date and time.
    #
    #   The only supported value is `incremental`.
    #
    # @return [Types::CreateCapacityReservationResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateCapacityReservationResult#capacity_reservation #capacity_reservation} => Types::CapacityReservation
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_capacity_reservation({
    #     client_token: "String",
    #     instance_type: "String", # required
    #     instance_platform: "Linux/UNIX", # required, accepts Linux/UNIX, Red Hat Enterprise Linux, SUSE Linux, Windows, Windows with SQL Server, Windows with SQL Server Enterprise, Windows with SQL Server Standard, Windows with SQL Server Web, Linux with SQL Server Standard, Linux with SQL Server Web, Linux with SQL Server Enterprise, RHEL with SQL Server Standard, RHEL with SQL Server Enterprise, RHEL with SQL Server Web, RHEL with HA, RHEL with HA and SQL Server Standard, RHEL with HA and SQL Server Enterprise, Ubuntu Pro
    #     availability_zone: "AvailabilityZoneName",
    #     availability_zone_id: "AvailabilityZoneId",
    #     tenancy: "default", # accepts default, dedicated
    #     instance_count: 1, # required
    #     ebs_optimized: false,
    #     ephemeral_storage: false,
    #     end_date: Time.now,
    #     end_date_type: "unlimited", # accepts unlimited, limited
    #     instance_match_criteria: "open", # accepts open, targeted
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #     outpost_arn: "OutpostArn",
    #     placement_group_arn: "PlacementGroupArn",
    #     start_date: Time.now,
    #     commitment_duration: 1,
    #     delivery_preference: "fixed", # accepts fixed, incremental
    #   })
    #
    # @example Response structure
    #
    #   resp.capacity_reservation.capacity_reservation_id #=> String
    #   resp.capacity_reservation.owner_id #=> String
    #   resp.capacity_reservation.capacity_reservation_arn #=> String
    #   resp.capacity_reservation.availability_zone_id #=> String
    #   resp.capacity_reservation.instance_type #=> String
    #   resp.capacity_reservation.instance_platform #=> String, one of "Linux/UNIX", "Red Hat Enterprise Linux", "SUSE Linux", "Windows", "Windows with SQL Server", "Windows with SQL Server Enterprise", "Windows with SQL Server Standard", "Windows with SQL Server Web", "Linux with SQL Server Standard", "Linux with SQL Server Web", "Linux with SQL Server Enterprise", "RHEL with SQL Server Standard", "RHEL with SQL Server Enterprise", "RHEL with SQL Server Web", "RHEL with HA", "RHEL with HA and SQL Server Standard", "RHEL with HA and SQL Server Enterprise", "Ubuntu Pro"
    #   resp.capacity_reservation.availability_zone #=> String
    #   resp.capacity_reservation.tenancy #=> String, one of "default", "dedicated"
    #   resp.capacity_reservation.total_instance_count #=> Integer
    #   resp.capacity_reservation.available_instance_count #=> Integer
    #   resp.capacity_reservation.ebs_optimized #=> Boolean
    #   resp.capacity_reservation.ephemeral_storage #=> Boolean
    #   resp.capacity_reservation.state #=> String, one of "active", "expired", "cancelled", "pending", "failed", "scheduled", "payment-pending", "payment-failed", "assessing", "delayed", "unsupported", "unavailable"
    #   resp.capacity_reservation.start_date #=> Time
    #   resp.capacity_reservation.end_date #=> Time
    #   resp.capacity_reservation.end_date_type #=> String, one of "unlimited", "limited"
    #   resp.capacity_reservation.instance_match_criteria #=> String, one of "open", "targeted"
    #   resp.capacity_reservation.create_date #=> Time
    #   resp.capacity_reservation.tags #=> Array
    #   resp.capacity_reservation.tags[0].key #=> String
    #   resp.capacity_reservation.tags[0].value #=> String
    #   resp.capacity_reservation.outpost_arn #=> String
    #   resp.capacity_reservation.capacity_reservation_fleet_id #=> String
    #   resp.capacity_reservation.placement_group_arn #=> String
    #   resp.capacity_reservation.capacity_allocations #=> Array
    #   resp.capacity_reservation.capacity_allocations[0].allocation_type #=> String, one of "used", "future"
    #   resp.capacity_reservation.capacity_allocations[0].count #=> Integer
    #   resp.capacity_reservation.reservation_type #=> String, one of "default", "capacity-block"
    #   resp.capacity_reservation.unused_reservation_billing_owner_id #=> String
    #   resp.capacity_reservation.commitment_info.committed_instance_count #=> Integer
    #   resp.capacity_reservation.commitment_info.commitment_end_date #=> Time
    #   resp.capacity_reservation.delivery_preference #=> String, one of "fixed", "incremental"
    #   resp.capacity_reservation.capacity_block_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservation AWS API Documentation
    #
    # @overload create_capacity_reservation(params = {})
    # @param [Hash] params ({})
    def create_capacity_reservation(params = {}, options = {})
      req = build_request(:create_capacity_reservation, params)
      req.send_request(options)
    end

    # Create a new Capacity Reservation by splitting the capacity of the
    # source Capacity Reservation. The new Capacity Reservation will have
    # the same attributes as the source Capacity Reservation except for
    # tags. The source Capacity Reservation must be `active` and owned by
    # your Amazon Web Services account.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [required, String] :source_capacity_reservation_id
    #   The ID of the Capacity Reservation from which you want to split the
    #   capacity.
    #
    # @option params [required, Integer] :instance_count
    #   The number of instances to split from the source Capacity Reservation.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the new Capacity Reservation.
    #
    # @return [Types::CreateCapacityReservationBySplittingResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateCapacityReservationBySplittingResult#source_capacity_reservation #source_capacity_reservation} => Types::CapacityReservation
    #   * {Types::CreateCapacityReservationBySplittingResult#destination_capacity_reservation #destination_capacity_reservation} => Types::CapacityReservation
    #   * {Types::CreateCapacityReservationBySplittingResult#instance_count #instance_count} => Integer
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_capacity_reservation_by_splitting({
    #     dry_run: false,
    #     client_token: "String",
    #     source_capacity_reservation_id: "CapacityReservationId", # required
    #     instance_count: 1, # required
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.source_capacity_reservation.capacity_reservation_id #=> String
    #   resp.source_capacity_reservation.owner_id #=> String
    #   resp.source_capacity_reservation.capacity_reservation_arn #=> String
    #   resp.source_capacity_reservation.availability_zone_id #=> String
    #   resp.source_capacity_reservation.instance_type #=> String
    #   resp.source_capacity_reservation.instance_platform #=> String, one of "Linux/UNIX", "Red Hat Enterprise Linux", "SUSE Linux", "Windows", "Windows with SQL Server", "Windows with SQL Server Enterprise", "Windows with SQL Server Standard", "Windows with SQL Server Web", "Linux with SQL Server Standard", "Linux with SQL Server Web", "Linux with SQL Server Enterprise", "RHEL with SQL Server Standard", "RHEL with SQL Server Enterprise", "RHEL with SQL Server Web", "RHEL with HA", "RHEL with HA and SQL Server Standard", "RHEL with HA and SQL Server Enterprise", "Ubuntu Pro"
    #   resp.source_capacity_reservation.availability_zone #=> String
    #   resp.source_capacity_reservation.tenancy #=> String, one of "default", "dedicated"
    #   resp.source_capacity_reservation.total_instance_count #=> Integer
    #   resp.source_capacity_reservation.available_instance_count #=> Integer
    #   resp.source_capacity_reservation.ebs_optimized #=> Boolean
    #   resp.source_capacity_reservation.ephemeral_storage #=> Boolean
    #   resp.source_capacity_reservation.state #=> String, one of "active", "expired", "cancelled", "pending", "failed", "scheduled", "payment-pending", "payment-failed", "assessing", "delayed", "unsupported", "unavailable"
    #   resp.source_capacity_reservation.start_date #=> Time
    #   resp.source_capacity_reservation.end_date #=> Time
    #   resp.source_capacity_reservation.end_date_type #=> String, one of "unlimited", "limited"
    #   resp.source_capacity_reservation.instance_match_criteria #=> String, one of "open", "targeted"
    #   resp.source_capacity_reservation.create_date #=> Time
    #   resp.source_capacity_reservation.tags #=> Array
    #   resp.source_capacity_reservation.tags[0].key #=> String
    #   resp.source_capacity_reservation.tags[0].value #=> String
    #   resp.source_capacity_reservation.outpost_arn #=> String
    #   resp.source_capacity_reservation.capacity_reservation_fleet_id #=> String
    #   resp.source_capacity_reservation.placement_group_arn #=> String
    #   resp.source_capacity_reservation.capacity_allocations #=> Array
    #   resp.source_capacity_reservation.capacity_allocations[0].allocation_type #=> String, one of "used", "future"
    #   resp.source_capacity_reservation.capacity_allocations[0].count #=> Integer
    #   resp.source_capacity_reservation.reservation_type #=> String, one of "default", "capacity-block"
    #   resp.source_capacity_reservation.unused_reservation_billing_owner_id #=> String
    #   resp.source_capacity_reservation.commitment_info.committed_instance_count #=> Integer
    #   resp.source_capacity_reservation.commitment_info.commitment_end_date #=> Time
    #   resp.source_capacity_reservation.delivery_preference #=> String, one of "fixed", "incremental"
    #   resp.source_capacity_reservation.capacity_block_id #=> String
    #   resp.destination_capacity_reservation.capacity_reservation_id #=> String
    #   resp.destination_capacity_reservation.owner_id #=> String
    #   resp.destination_capacity_reservation.capacity_reservation_arn #=> String
    #   resp.destination_capacity_reservation.availability_zone_id #=> String
    #   resp.destination_capacity_reservation.instance_type #=> String
    #   resp.destination_capacity_reservation.instance_platform #=> String, one of "Linux/UNIX", "Red Hat Enterprise Linux", "SUSE Linux", "Windows", "Windows with SQL Server", "Windows with SQL Server Enterprise", "Windows with SQL Server Standard", "Windows with SQL Server Web", "Linux with SQL Server Standard", "Linux with SQL Server Web", "Linux with SQL Server Enterprise", "RHEL with SQL Server Standard", "RHEL with SQL Server Enterprise", "RHEL with SQL Server Web", "RHEL with HA", "RHEL with HA and SQL Server Standard", "RHEL with HA and SQL Server Enterprise", "Ubuntu Pro"
    #   resp.destination_capacity_reservation.availability_zone #=> String
    #   resp.destination_capacity_reservation.tenancy #=> String, one of "default", "dedicated"
    #   resp.destination_capacity_reservation.total_instance_count #=> Integer
    #   resp.destination_capacity_reservation.available_instance_count #=> Integer
    #   resp.destination_capacity_reservation.ebs_optimized #=> Boolean
    #   resp.destination_capacity_reservation.ephemeral_storage #=> Boolean
    #   resp.destination_capacity_reservation.state #=> String, one of "active", "expired", "cancelled", "pending", "failed", "scheduled", "payment-pending", "payment-failed", "assessing", "delayed", "unsupported", "unavailable"
    #   resp.destination_capacity_reservation.start_date #=> Time
    #   resp.destination_capacity_reservation.end_date #=> Time
    #   resp.destination_capacity_reservation.end_date_type #=> String, one of "unlimited", "limited"
    #   resp.destination_capacity_reservation.instance_match_criteria #=> String, one of "open", "targeted"
    #   resp.destination_capacity_reservation.create_date #=> Time
    #   resp.destination_capacity_reservation.tags #=> Array
    #   resp.destination_capacity_reservation.tags[0].key #=> String
    #   resp.destination_capacity_reservation.tags[0].value #=> String
    #   resp.destination_capacity_reservation.outpost_arn #=> String
    #   resp.destination_capacity_reservation.capacity_reservation_fleet_id #=> String
    #   resp.destination_capacity_reservation.placement_group_arn #=> String
    #   resp.destination_capacity_reservation.capacity_allocations #=> Array
    #   resp.destination_capacity_reservation.capacity_allocations[0].allocation_type #=> String, one of "used", "future"
    #   resp.destination_capacity_reservation.capacity_allocations[0].count #=> Integer
    #   resp.destination_capacity_reservation.reservation_type #=> String, one of "default", "capacity-block"
    #   resp.destination_capacity_reservation.unused_reservation_billing_owner_id #=> String
    #   resp.destination_capacity_reservation.commitment_info.committed_instance_count #=> Integer
    #   resp.destination_capacity_reservation.commitment_info.commitment_end_date #=> Time
    #   resp.destination_capacity_reservation.delivery_preference #=> String, one of "fixed", "incremental"
    #   resp.destination_capacity_reservation.capacity_block_id #=> String
    #   resp.instance_count #=> Integer
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationBySplitting AWS API Documentation
    #
    # @overload create_capacity_reservation_by_splitting(params = {})
    # @param [Hash] params ({})
    def create_capacity_reservation_by_splitting(params = {}, options = {})
      req = build_request(:create_capacity_reservation_by_splitting, params)
      req.send_request(options)
    end

    # Creates a Capacity Reservation Fleet. For more information, see
    # [Create a Capacity Reservation Fleet][1] in the *Amazon EC2 User
    # Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-cr-fleets.html#create-crfleet
    #
    # @option params [String] :allocation_strategy
    #   The strategy used by the Capacity Reservation Fleet to determine which
    #   of the specified instance types to use. Currently, only the
    #   `prioritized` allocation strategy is supported. For more information,
    #   see [ Allocation strategy][1] in the *Amazon EC2 User Guide*.
    #
    #   Valid values: `prioritized`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#allocation-strategy
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [required, Array<Types::ReservationFleetInstanceSpecification>] :instance_type_specifications
    #   Information about the instance types for which to reserve the
    #   capacity.
    #
    # @option params [String] :tenancy
    #   Indicates the tenancy of the Capacity Reservation Fleet. All Capacity
    #   Reservations in the Fleet inherit this tenancy. The Capacity
    #   Reservation Fleet can have one of the following tenancy settings:
    #
    #   * `default` - The Capacity Reservation Fleet is created on hardware
    #     that is shared with other Amazon Web Services accounts.
    #
    #   * `dedicated` - The Capacity Reservations are created on single-tenant
    #     hardware that is dedicated to a single Amazon Web Services account.
    #
    # @option params [required, Integer] :total_target_capacity
    #   The total number of capacity units to be reserved by the Capacity
    #   Reservation Fleet. This value, together with the instance type weights
    #   that you assign to each instance type used by the Fleet determine the
    #   number of instances for which the Fleet reserves capacity. Both values
    #   are based on units that make sense for your workload. For more
    #   information, see [Total target capacity][1] in the *Amazon EC2 User
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity
    #
    # @option params [Time,DateTime,Date,Integer,String] :end_date
    #   The date and time at which the Capacity Reservation Fleet expires.
    #   When the Capacity Reservation Fleet expires, its state changes to
    #   `expired` and all of the Capacity Reservations in the Fleet expire.
    #
    #   The Capacity Reservation Fleet expires within an hour after the
    #   specified time. For example, if you specify `5/31/2019`, `13:30:55`,
    #   the Capacity Reservation Fleet is guaranteed to expire between
    #   `13:30:55` and `14:30:55` on `5/31/2019`.
    #
    # @option params [String] :instance_match_criteria
    #   Indicates the type of instance launches that the Capacity Reservation
    #   Fleet accepts. All Capacity Reservations in the Fleet inherit this
    #   instance matching criteria.
    #
    #   Currently, Capacity Reservation Fleets support `open` instance
    #   matching criteria only. This means that instances that have matching
    #   attributes (instance type, platform, and Availability Zone) run in the
    #   Capacity Reservations automatically. Instances do not need to
    #   explicitly target a Capacity Reservation Fleet to use its reserved
    #   capacity.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the Capacity Reservation Fleet. The tags are
    #   automatically assigned to the Capacity Reservations in the Fleet.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateCapacityReservationFleetResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateCapacityReservationFleetResult#capacity_reservation_fleet_id #capacity_reservation_fleet_id} => String
    #   * {Types::CreateCapacityReservationFleetResult#state #state} => String
    #   * {Types::CreateCapacityReservationFleetResult#total_target_capacity #total_target_capacity} => Integer
    #   * {Types::CreateCapacityReservationFleetResult#total_fulfilled_capacity #total_fulfilled_capacity} => Float
    #   * {Types::CreateCapacityReservationFleetResult#instance_match_criteria #instance_match_criteria} => String
    #   * {Types::CreateCapacityReservationFleetResult#allocation_strategy #allocation_strategy} => String
    #   * {Types::CreateCapacityReservationFleetResult#create_time #create_time} => Time
    #   * {Types::CreateCapacityReservationFleetResult#end_date #end_date} => Time
    #   * {Types::CreateCapacityReservationFleetResult#tenancy #tenancy} => String
    #   * {Types::CreateCapacityReservationFleetResult#fleet_capacity_reservations #fleet_capacity_reservations} => Array&lt;Types::FleetCapacityReservation&gt;
    #   * {Types::CreateCapacityReservationFleetResult#tags #tags} => Array&lt;Types::Tag&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_capacity_reservation_fleet({
    #     allocation_strategy: "String",
    #     client_token: "String",
    #     instance_type_specifications: [ # required
    #       {
    #         instance_type: "a1.medium", # accepts a1.medium, a1.large, a1.xlarge, a1.2xlarge, a1.4xlarge, a1.metal, c1.medium, c1.xlarge, c3.large, c3.xlarge, c3.2xlarge, c3.4xlarge, c3.8xlarge, c4.large, c4.xlarge, c4.2xlarge, c4.4xlarge, c4.8xlarge, c5.large, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.12xlarge, c5.18xlarge, c5.24xlarge, c5.metal, c5a.large, c5a.xlarge, c5a.2xlarge, c5a.4xlarge, c5a.8xlarge, c5a.12xlarge, c5a.16xlarge, c5a.24xlarge, c5ad.large, c5ad.xlarge, c5ad.2xlarge, c5ad.4xlarge, c5ad.8xlarge, c5ad.12xlarge, c5ad.16xlarge, c5ad.24xlarge, c5d.large, c5d.xlarge, c5d.2xlarge, c5d.4xlarge, c5d.9xlarge, c5d.12xlarge, c5d.18xlarge, c5d.24xlarge, c5d.metal, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge, c5n.metal, c6g.medium, c6g.large, c6g.xlarge, c6g.2xlarge, c6g.4xlarge, c6g.8xlarge, c6g.12xlarge, c6g.16xlarge, c6g.metal, c6gd.medium, c6gd.large, c6gd.xlarge, c6gd.2xlarge, c6gd.4xlarge, c6gd.8xlarge, c6gd.12xlarge, c6gd.16xlarge, c6gd.metal, c6gn.medium, c6gn.large, c6gn.xlarge, c6gn.2xlarge, c6gn.4xlarge, c6gn.8xlarge, c6gn.12xlarge, c6gn.16xlarge, c6i.large, c6i.xlarge, c6i.2xlarge, c6i.4xlarge, c6i.8xlarge, c6i.12xlarge, c6i.16xlarge, c6i.24xlarge, c6i.32xlarge, c6i.metal, cc1.4xlarge, cc2.8xlarge, cg1.4xlarge, cr1.8xlarge, d2.xlarge, d2.2xlarge, d2.4xlarge, d2.8xlarge, d3.xlarge, d3.2xlarge, d3.4xlarge, d3.8xlarge, d3en.xlarge, d3en.2xlarge, d3en.4xlarge, d3en.6xlarge, d3en.8xlarge, d3en.12xlarge, dl1.24xlarge, f1.2xlarge, f1.4xlarge, f1.16xlarge, g2.2xlarge, g2.8xlarge, g3.4xlarge, g3.8xlarge, g3.16xlarge, g3s.xlarge, g4ad.xlarge, g4ad.2xlarge, g4ad.4xlarge, g4ad.8xlarge, g4ad.16xlarge, g4dn.xlarge, g4dn.2xlarge, g4dn.4xlarge, g4dn.8xlarge, g4dn.12xlarge, g4dn.16xlarge, g4dn.metal, g5.xlarge, g5.2xlarge, g5.4xlarge, g5.8xlarge, g5.12xlarge, g5.16xlarge, g5.24xlarge, g5.48xlarge, g5g.xlarge, g5g.2xlarge, g5g.4xlarge, g5g.8xlarge, g5g.16xlarge, g5g.metal, hi1.4xlarge, hpc6a.48xlarge, hs1.8xlarge, h1.2xlarge, h1.4xlarge, h1.8xlarge, h1.16xlarge, i2.xlarge, i2.2xlarge, i2.4xlarge, i2.8xlarge, i3.large, i3.xlarge, i3.2xlarge, i3.4xlarge, i3.8xlarge, i3.16xlarge, i3.metal, i3en.large, i3en.xlarge, i3en.2xlarge, i3en.3xlarge, i3en.6xlarge, i3en.12xlarge, i3en.24xlarge, i3en.metal, im4gn.large, im4gn.xlarge, im4gn.2xlarge, im4gn.4xlarge, im4gn.8xlarge, im4gn.16xlarge, inf1.xlarge, inf1.2xlarge, inf1.6xlarge, inf1.24xlarge, is4gen.medium, is4gen.large, is4gen.xlarge, is4gen.2xlarge, is4gen.4xlarge, is4gen.8xlarge, m1.small, m1.medium, m1.large, m1.xlarge, m2.xlarge, m2.2xlarge, m2.4xlarge, m3.medium, m3.large, m3.xlarge, m3.2xlarge, m4.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m4.10xlarge, m4.16xlarge, m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.8xlarge, m5.12xlarge, m5.16xlarge, m5.24xlarge, m5.metal, m5a.large, m5a.xlarge, m5a.2xlarge, m5a.4xlarge, m5a.8xlarge, m5a.12xlarge, m5a.16xlarge, m5a.24xlarge, m5ad.large, m5ad.xlarge, m5ad.2xlarge, m5ad.4xlarge, m5ad.8xlarge, m5ad.12xlarge, m5ad.16xlarge, m5ad.24xlarge, m5d.large, m5d.xlarge, m5d.2xlarge, m5d.4xlarge, m5d.8xlarge, m5d.12xlarge, m5d.16xlarge, m5d.24xlarge, m5d.metal, m5dn.large, m5dn.xlarge, m5dn.2xlarge, m5dn.4xlarge, m5dn.8xlarge, m5dn.12xlarge, m5dn.16xlarge, m5dn.24xlarge, m5dn.metal, m5n.large, m5n.xlarge, m5n.2xlarge, m5n.4xlarge, m5n.8xlarge, m5n.12xlarge, m5n.16xlarge, m5n.24xlarge, m5n.metal, m5zn.large, m5zn.xlarge, m5zn.2xlarge, m5zn.3xlarge, m5zn.6xlarge, m5zn.12xlarge, m5zn.metal, m6a.large, m6a.xlarge, m6a.2xlarge, m6a.4xlarge, m6a.8xlarge, m6a.12xlarge, m6a.16xlarge, m6a.24xlarge, m6a.32xlarge, m6a.48xlarge, m6g.metal, m6g.medium, m6g.large, m6g.xlarge, m6g.2xlarge, m6g.4xlarge, m6g.8xlarge, m6g.12xlarge, m6g.16xlarge, m6gd.metal, m6gd.medium, m6gd.large, m6gd.xlarge, m6gd.2xlarge, m6gd.4xlarge, m6gd.8xlarge, m6gd.12xlarge, m6gd.16xlarge, m6i.large, m6i.xlarge, m6i.2xlarge, m6i.4xlarge, m6i.8xlarge, m6i.12xlarge, m6i.16xlarge, m6i.24xlarge, m6i.32xlarge, m6i.metal, mac1.metal, p2.xlarge, p2.8xlarge, p2.16xlarge, p3.2xlarge, p3.8xlarge, p3.16xlarge, p3dn.24xlarge, p4d.24xlarge, r3.large, r3.xlarge, r3.2xlarge, r3.4xlarge, r3.8xlarge, r4.large, r4.xlarge, r4.2xlarge, r4.4xlarge, r4.8xlarge, r4.16xlarge, r5.large, r5.xlarge, r5.2xlarge, r5.4xlarge, r5.8xlarge, r5.12xlarge, r5.16xlarge, r5.24xlarge, r5.metal, r5a.large, r5a.xlarge, r5a.2xlarge, r5a.4xlarge, r5a.8xlarge, r5a.12xlarge, r5a.16xlarge, r5a.24xlarge, r5ad.large, r5ad.xlarge, r5ad.2xlarge, r5ad.4xlarge, r5ad.8xlarge, r5ad.12xlarge, r5ad.16xlarge, r5ad.24xlarge, r5b.large, r5b.xlarge, r5b.2xlarge, r5b.4xlarge, r5b.8xlarge, r5b.12xlarge, r5b.16xlarge, r5b.24xlarge, r5b.metal, r5d.large, r5d.xlarge, r5d.2xlarge, r5d.4xlarge, r5d.8xlarge, r5d.12xlarge, r5d.16xlarge, r5d.24xlarge, r5d.metal, r5dn.large, r5dn.xlarge, r5dn.2xlarge, r5dn.4xlarge, r5dn.8xlarge, r5dn.12xlarge, r5dn.16xlarge, r5dn.24xlarge, r5dn.metal, r5n.large, r5n.xlarge, r5n.2xlarge, r5n.4xlarge, r5n.8xlarge, r5n.12xlarge, r5n.16xlarge, r5n.24xlarge, r5n.metal, r6g.medium, r6g.large, r6g.xlarge, r6g.2xlarge, r6g.4xlarge, r6g.8xlarge, r6g.12xlarge, r6g.16xlarge, r6g.metal, r6gd.medium, r6gd.large, r6gd.xlarge, r6gd.2xlarge, r6gd.4xlarge, r6gd.8xlarge, r6gd.12xlarge, r6gd.16xlarge, r6gd.metal, r6i.large, r6i.xlarge, r6i.2xlarge, r6i.4xlarge, r6i.8xlarge, r6i.12xlarge, r6i.16xlarge, r6i.24xlarge, r6i.32xlarge, r6i.metal, t1.micro, t2.nano, t2.micro, t2.small, t2.medium, t2.large, t2.xlarge, t2.2xlarge, t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge, t3a.nano, t3a.micro, t3a.small, t3a.medium, t3a.large, t3a.xlarge, t3a.2xlarge, t4g.nano, t4g.micro, t4g.small, t4g.medium, t4g.large, t4g.xlarge, t4g.2xlarge, u-6tb1.56xlarge, u-6tb1.112xlarge, u-9tb1.112xlarge, u-12tb1.112xlarge, u-6tb1.metal, u-9tb1.metal, u-12tb1.metal, u-18tb1.metal, u-24tb1.metal, vt1.3xlarge, vt1.6xlarge, vt1.24xlarge, x1.16xlarge, x1.32xlarge, x1e.xlarge, x1e.2xlarge, x1e.4xlarge, x1e.8xlarge, x1e.16xlarge, x1e.32xlarge, x2iezn.2xlarge, x2iezn.4xlarge, x2iezn.6xlarge, x2iezn.8xlarge, x2iezn.12xlarge, x2iezn.metal, x2gd.medium, x2gd.large, x2gd.xlarge, x2gd.2xlarge, x2gd.4xlarge, x2gd.8xlarge, x2gd.12xlarge, x2gd.16xlarge, x2gd.metal, z1d.large, z1d.xlarge, z1d.2xlarge, z1d.3xlarge, z1d.6xlarge, z1d.12xlarge, z1d.metal, x2idn.16xlarge, x2idn.24xlarge, x2idn.32xlarge, x2iedn.xlarge, x2iedn.2xlarge, x2iedn.4xlarge, x2iedn.8xlarge, x2iedn.16xlarge, x2iedn.24xlarge, x2iedn.32xlarge, c6a.large, c6a.xlarge, c6a.2xlarge, c6a.4xlarge, c6a.8xlarge, c6a.12xlarge, c6a.16xlarge, c6a.24xlarge, c6a.32xlarge, c6a.48xlarge, c6a.metal, m6a.metal, i4i.large, i4i.xlarge, i4i.2xlarge, i4i.4xlarge, i4i.8xlarge, i4i.16xlarge, i4i.32xlarge, i4i.metal, x2idn.metal, x2iedn.metal, c7g.medium, c7g.large, c7g.xlarge, c7g.2xlarge, c7g.4xlarge, c7g.8xlarge, c7g.12xlarge, c7g.16xlarge, mac2.metal, c6id.large, c6id.xlarge, c6id.2xlarge, c6id.4xlarge, c6id.8xlarge, c6id.12xlarge, c6id.16xlarge, c6id.24xlarge, c6id.32xlarge, c6id.metal, m6id.large, m6id.xlarge, m6id.2xlarge, m6id.4xlarge, m6id.8xlarge, m6id.12xlarge, m6id.16xlarge, m6id.24xlarge, m6id.32xlarge, m6id.metal, r6id.large, r6id.xlarge, r6id.2xlarge, r6id.4xlarge, r6id.8xlarge, r6id.12xlarge, r6id.16xlarge, r6id.24xlarge, r6id.32xlarge, r6id.metal, r6a.large, r6a.xlarge, r6a.2xlarge, r6a.4xlarge, r6a.8xlarge, r6a.12xlarge, r6a.16xlarge, r6a.24xlarge, r6a.32xlarge, r6a.48xlarge, r6a.metal, p4de.24xlarge, u-3tb1.56xlarge, u-18tb1.112xlarge, u-24tb1.112xlarge, trn1.2xlarge, trn1.32xlarge, hpc6id.32xlarge, c6in.large, c6in.xlarge, c6in.2xlarge, c6in.4xlarge, c6in.8xlarge, c6in.12xlarge, c6in.16xlarge, c6in.24xlarge, c6in.32xlarge, m6in.large, m6in.xlarge, m6in.2xlarge, m6in.4xlarge, m6in.8xlarge, m6in.12xlarge, m6in.16xlarge, m6in.24xlarge, m6in.32xlarge, m6idn.large, m6idn.xlarge, m6idn.2xlarge, m6idn.4xlarge, m6idn.8xlarge, m6idn.12xlarge, m6idn.16xlarge, m6idn.24xlarge, m6idn.32xlarge, r6in.large, r6in.xlarge, r6in.2xlarge, r6in.4xlarge, r6in.8xlarge, r6in.12xlarge, r6in.16xlarge, r6in.24xlarge, r6in.32xlarge, r6idn.large, r6idn.xlarge, r6idn.2xlarge, r6idn.4xlarge, r6idn.8xlarge, r6idn.12xlarge, r6idn.16xlarge, r6idn.24xlarge, r6idn.32xlarge, c7g.metal, m7g.medium, m7g.large, m7g.xlarge, m7g.2xlarge, m7g.4xlarge, m7g.8xlarge, m7g.12xlarge, m7g.16xlarge, m7g.metal, r7g.medium, r7g.large, r7g.xlarge, r7g.2xlarge, r7g.4xlarge, r7g.8xlarge, r7g.12xlarge, r7g.16xlarge, r7g.metal, c6in.metal, m6in.metal, m6idn.metal, r6in.metal, r6idn.metal, inf2.xlarge, inf2.8xlarge, inf2.24xlarge, inf2.48xlarge, trn1n.32xlarge, i4g.large, i4g.xlarge, i4g.2xlarge, i4g.4xlarge, i4g.8xlarge, i4g.16xlarge, hpc7g.4xlarge, hpc7g.8xlarge, hpc7g.16xlarge, c7gn.medium, c7gn.large, c7gn.xlarge, c7gn.2xlarge, c7gn.4xlarge, c7gn.8xlarge, c7gn.12xlarge, c7gn.16xlarge, p5.48xlarge, m7i.large, m7i.xlarge, m7i.2xlarge, m7i.4xlarge, m7i.8xlarge, m7i.12xlarge, m7i.16xlarge, m7i.24xlarge, m7i.48xlarge, m7i-flex.large, m7i-flex.xlarge, m7i-flex.2xlarge, m7i-flex.4xlarge, m7i-flex.8xlarge, m7a.medium, m7a.large, m7a.xlarge, m7a.2xlarge, m7a.4xlarge, m7a.8xlarge, m7a.12xlarge, m7a.16xlarge, m7a.24xlarge, m7a.32xlarge, m7a.48xlarge, m7a.metal-48xl, hpc7a.12xlarge, hpc7a.24xlarge, hpc7a.48xlarge, hpc7a.96xlarge, c7gd.medium, c7gd.large, c7gd.xlarge, c7gd.2xlarge, c7gd.4xlarge, c7gd.8xlarge, c7gd.12xlarge, c7gd.16xlarge, m7gd.medium, m7gd.large, m7gd.xlarge, m7gd.2xlarge, m7gd.4xlarge, m7gd.8xlarge, m7gd.12xlarge, m7gd.16xlarge, r7gd.medium, r7gd.large, r7gd.xlarge, r7gd.2xlarge, r7gd.4xlarge, r7gd.8xlarge, r7gd.12xlarge, r7gd.16xlarge, r7a.medium, r7a.large, r7a.xlarge, r7a.2xlarge, r7a.4xlarge, r7a.8xlarge, r7a.12xlarge, r7a.16xlarge, r7a.24xlarge, r7a.32xlarge, r7a.48xlarge, c7i.large, c7i.xlarge, c7i.2xlarge, c7i.4xlarge, c7i.8xlarge, c7i.12xlarge, c7i.16xlarge, c7i.24xlarge, c7i.48xlarge, mac2-m2pro.metal, r7iz.large, r7iz.xlarge, r7iz.2xlarge, r7iz.4xlarge, r7iz.8xlarge, r7iz.12xlarge, r7iz.16xlarge, r7iz.32xlarge, c7a.medium, c7a.large, c7a.xlarge, c7a.2xlarge, c7a.4xlarge, c7a.8xlarge, c7a.12xlarge, c7a.16xlarge, c7a.24xlarge, c7a.32xlarge, c7a.48xlarge, c7a.metal-48xl, r7a.metal-48xl, r7i.large, r7i.xlarge, r7i.2xlarge, r7i.4xlarge, r7i.8xlarge, r7i.12xlarge, r7i.16xlarge, r7i.24xlarge, r7i.48xlarge, dl2q.24xlarge, mac2-m2.metal, i4i.12xlarge, i4i.24xlarge, c7i.metal-24xl, c7i.metal-48xl, m7i.metal-24xl, m7i.metal-48xl, r7i.metal-24xl, r7i.metal-48xl, r7iz.metal-16xl, r7iz.metal-32xl, c7gd.metal, m7gd.metal, r7gd.metal, g6.xlarge, g6.2xlarge, g6.4xlarge, g6.8xlarge, g6.12xlarge, g6.16xlarge, g6.24xlarge, g6.48xlarge, gr6.4xlarge, gr6.8xlarge, c7i-flex.large, c7i-flex.xlarge, c7i-flex.2xlarge, c7i-flex.4xlarge, c7i-flex.8xlarge, u7i-12tb.224xlarge, u7in-16tb.224xlarge, u7in-24tb.224xlarge, u7in-32tb.224xlarge, u7ib-12tb.224xlarge, c7gn.metal, r8g.medium, r8g.large, r8g.xlarge, r8g.2xlarge, r8g.4xlarge, r8g.8xlarge, r8g.12xlarge, r8g.16xlarge, r8g.24xlarge, r8g.48xlarge, r8g.metal-24xl, r8g.metal-48xl, mac2-m1ultra.metal, g6e.xlarge, g6e.2xlarge, g6e.4xlarge, g6e.8xlarge, g6e.12xlarge, g6e.16xlarge, g6e.24xlarge, g6e.48xlarge, c8g.medium, c8g.large, c8g.xlarge, c8g.2xlarge, c8g.4xlarge, c8g.8xlarge, c8g.12xlarge, c8g.16xlarge, c8g.24xlarge, c8g.48xlarge, c8g.metal-24xl, c8g.metal-48xl, m8g.medium, m8g.large, m8g.xlarge, m8g.2xlarge, m8g.4xlarge, m8g.8xlarge, m8g.12xlarge, m8g.16xlarge, m8g.24xlarge, m8g.48xlarge, m8g.metal-24xl, m8g.metal-48xl, x8g.medium, x8g.large, x8g.xlarge, x8g.2xlarge, x8g.4xlarge, x8g.8xlarge, x8g.12xlarge, x8g.16xlarge, x8g.24xlarge, x8g.48xlarge, x8g.metal-24xl, x8g.metal-48xl, i7ie.large, i7ie.xlarge, i7ie.2xlarge, i7ie.3xlarge, i7ie.6xlarge, i7ie.12xlarge, i7ie.18xlarge, i7ie.24xlarge, i7ie.48xlarge, i8g.large, i8g.xlarge, i8g.2xlarge, i8g.4xlarge, i8g.8xlarge, i8g.12xlarge, i8g.16xlarge, i8g.24xlarge, i8g.metal-24xl, u7i-6tb.112xlarge, u7i-8tb.112xlarge, u7inh-32tb.480xlarge, p5e.48xlarge, p5en.48xlarge, f2.12xlarge, f2.48xlarge, trn2.48xlarge, c7i-flex.12xlarge, c7i-flex.16xlarge, m7i-flex.12xlarge, m7i-flex.16xlarge, i7ie.metal-24xl, i7ie.metal-48xl, i8g.48xlarge, c8gd.medium, c8gd.large, c8gd.xlarge, c8gd.2xlarge, c8gd.4xlarge, c8gd.8xlarge, c8gd.12xlarge, c8gd.16xlarge, c8gd.24xlarge, c8gd.48xlarge, c8gd.metal-24xl, c8gd.metal-48xl, i7i.large, i7i.xlarge, i7i.2xlarge, i7i.4xlarge, i7i.8xlarge, i7i.12xlarge, i7i.16xlarge, i7i.24xlarge, i7i.48xlarge, i7i.metal-24xl, i7i.metal-48xl, p6-b200.48xlarge, m8gd.medium, m8gd.large, m8gd.xlarge, m8gd.2xlarge, m8gd.4xlarge, m8gd.8xlarge, m8gd.12xlarge, m8gd.16xlarge, m8gd.24xlarge, m8gd.48xlarge, m8gd.metal-24xl, m8gd.metal-48xl, r8gd.medium, r8gd.large, r8gd.xlarge, r8gd.2xlarge, r8gd.4xlarge, r8gd.8xlarge, r8gd.12xlarge, r8gd.16xlarge, r8gd.24xlarge, r8gd.48xlarge, r8gd.metal-24xl, r8gd.metal-48xl, c8gn.medium, c8gn.large, c8gn.xlarge, c8gn.2xlarge, c8gn.4xlarge, c8gn.8xlarge, c8gn.12xlarge, c8gn.16xlarge, c8gn.24xlarge, c8gn.48xlarge, c8gn.metal-24xl, c8gn.metal-48xl, f2.6xlarge, p6e-gb200.36xlarge
    #         instance_platform: "Linux/UNIX", # accepts Linux/UNIX, Red Hat Enterprise Linux, SUSE Linux, Windows, Windows with SQL Server, Windows with SQL Server Enterprise, Windows with SQL Server Standard, Windows with SQL Server Web, Linux with SQL Server Standard, Linux with SQL Server Web, Linux with SQL Server Enterprise, RHEL with SQL Server Standard, RHEL with SQL Server Enterprise, RHEL with SQL Server Web, RHEL with HA, RHEL with HA and SQL Server Standard, RHEL with HA and SQL Server Enterprise, Ubuntu Pro
    #         weight: 1.0,
    #         availability_zone: "String",
    #         availability_zone_id: "String",
    #         ebs_optimized: false,
    #         priority: 1,
    #       },
    #     ],
    #     tenancy: "default", # accepts default
    #     total_target_capacity: 1, # required
    #     end_date: Time.now,
    #     instance_match_criteria: "open", # accepts open
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.capacity_reservation_fleet_id #=> String
    #   resp.state #=> String, one of "submitted", "modifying", "active", "partially_fulfilled", "expiring", "expired", "cancelling", "cancelled", "failed"
    #   resp.total_target_capacity #=> Integer
    #   resp.total_fulfilled_capacity #=> Float
    #   resp.instance_match_criteria #=> String, one of "open"
    #   resp.allocation_strategy #=> String
    #   resp.create_time #=> Time
    #   resp.end_date #=> Time
    #   resp.tenancy #=> String, one of "default"
    #   resp.fleet_capacity_reservations #=> Array
    #   resp.fleet_capacity_reservations[0].capacity_reservation_id #=> String
    #   resp.fleet_capacity_reservations[0].availability_zone_id #=> String
    #   resp.fleet_capacity_reservations[0].instance_type #=> String, one of "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge", "a1.metal", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5a.large", "c5a.xlarge", "c5a.2xlarge", "c5a.4xlarge", "c5a.8xlarge", "c5a.12xlarge", "c5a.16xlarge", "c5a.24xlarge", "c5ad.large", "c5ad.xlarge", "c5ad.2xlarge", "c5ad.4xlarge", "c5ad.8xlarge", "c5ad.12xlarge", "c5ad.16xlarge", "c5ad.24xlarge", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.12xlarge", "c5d.18xlarge", "c5d.24xlarge", "c5d.metal", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "c5n.metal", "c6g.medium", "c6g.large", "c6g.xlarge", "c6g.2xlarge", "c6g.4xlarge", "c6g.8xlarge", "c6g.12xlarge", "c6g.16xlarge", "c6g.metal", "c6gd.medium", "c6gd.large", "c6gd.xlarge", "c6gd.2xlarge", "c6gd.4xlarge", "c6gd.8xlarge", "c6gd.12xlarge", "c6gd.16xlarge", "c6gd.metal", "c6gn.medium", "c6gn.large", "c6gn.xlarge", "c6gn.2xlarge", "c6gn.4xlarge", "c6gn.8xlarge", "c6gn.12xlarge", "c6gn.16xlarge", "c6i.large", "c6i.xlarge", "c6i.2xlarge", "c6i.4xlarge", "c6i.8xlarge", "c6i.12xlarge", "c6i.16xlarge", "c6i.24xlarge", "c6i.32xlarge", "c6i.metal", "cc1.4xlarge", "cc2.8xlarge", "cg1.4xlarge", "cr1.8xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "d3.xlarge", "d3.2xlarge", "d3.4xlarge", "d3.8xlarge", "d3en.xlarge", "d3en.2xlarge", "d3en.4xlarge", "d3en.6xlarge", "d3en.8xlarge", "d3en.12xlarge", "dl1.24xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "g4ad.xlarge", "g4ad.2xlarge", "g4ad.4xlarge", "g4ad.8xlarge", "g4ad.16xlarge", "g4dn.xlarge", "g4dn.2xlarge", "g4dn.4xlarge", "g4dn.8xlarge", "g4dn.12xlarge", "g4dn.16xlarge", "g4dn.metal", "g5.xlarge", "g5.2xlarge", "g5.4xlarge", "g5.8xlarge", "g5.12xlarge", "g5.16xlarge", "g5.24xlarge", "g5.48xlarge", "g5g.xlarge", "g5g.2xlarge", "g5g.4xlarge", "g5g.8xlarge", "g5g.16xlarge", "g5g.metal", "hi1.4xlarge", "hpc6a.48xlarge", "hs1.8xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "im4gn.large", "im4gn.xlarge", "im4gn.2xlarge", "im4gn.4xlarge", "im4gn.8xlarge", "im4gn.16xlarge", "inf1.xlarge", "inf1.2xlarge", "inf1.6xlarge", "inf1.24xlarge", "is4gen.medium", "is4gen.large", "is4gen.xlarge", "is4gen.2xlarge", "is4gen.4xlarge", "is4gen.8xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5dn.large", "m5dn.xlarge", "m5dn.2xlarge", "m5dn.4xlarge", "m5dn.8xlarge", "m5dn.12xlarge", "m5dn.16xlarge", "m5dn.24xlarge", "m5dn.metal", "m5n.large", "m5n.xlarge", "m5n.2xlarge", "m5n.4xlarge", "m5n.8xlarge", "m5n.12xlarge", "m5n.16xlarge", "m5n.24xlarge", "m5n.metal", "m5zn.large", "m5zn.xlarge", "m5zn.2xlarge", "m5zn.3xlarge", "m5zn.6xlarge", "m5zn.12xlarge", "m5zn.metal", "m6a.large", "m6a.xlarge", "m6a.2xlarge", "m6a.4xlarge", "m6a.8xlarge", "m6a.12xlarge", "m6a.16xlarge", "m6a.24xlarge", "m6a.32xlarge", "m6a.48xlarge", "m6g.metal", "m6g.medium", "m6g.large", "m6g.xlarge", "m6g.2xlarge", "m6g.4xlarge", "m6g.8xlarge", "m6g.12xlarge", "m6g.16xlarge", "m6gd.metal", "m6gd.medium", "m6gd.large", "m6gd.xlarge", "m6gd.2xlarge", "m6gd.4xlarge", "m6gd.8xlarge", "m6gd.12xlarge", "m6gd.16xlarge", "m6i.large", "m6i.xlarge", "m6i.2xlarge", "m6i.4xlarge", "m6i.8xlarge", "m6i.12xlarge", "m6i.16xlarge", "m6i.24xlarge", "m6i.32xlarge", "m6i.metal", "mac1.metal", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "p4d.24xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "r5b.large", "r5b.xlarge", "r5b.2xlarge", "r5b.4xlarge", "r5b.8xlarge", "r5b.12xlarge", "r5b.16xlarge", "r5b.24xlarge", "r5b.metal", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5dn.large", "r5dn.xlarge", "r5dn.2xlarge", "r5dn.4xlarge", "r5dn.8xlarge", "r5dn.12xlarge", "r5dn.16xlarge", "r5dn.24xlarge", "r5dn.metal", "r5n.large", "r5n.xlarge", "r5n.2xlarge", "r5n.4xlarge", "r5n.8xlarge", "r5n.12xlarge", "r5n.16xlarge", "r5n.24xlarge", "r5n.metal", "r6g.medium", "r6g.large", "r6g.xlarge", "r6g.2xlarge", "r6g.4xlarge", "r6g.8xlarge", "r6g.12xlarge", "r6g.16xlarge", "r6g.metal", "r6gd.medium", "r6gd.large", "r6gd.xlarge", "r6gd.2xlarge", "r6gd.4xlarge", "r6gd.8xlarge", "r6gd.12xlarge", "r6gd.16xlarge", "r6gd.metal", "r6i.large", "r6i.xlarge", "r6i.2xlarge", "r6i.4xlarge", "r6i.8xlarge", "r6i.12xlarge", "r6i.16xlarge", "r6i.24xlarge", "r6i.32xlarge", "r6i.metal", "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "t4g.nano", "t4g.micro", "t4g.small", "t4g.medium", "t4g.large", "t4g.xlarge", "t4g.2xlarge", "u-6tb1.56xlarge", "u-6tb1.112xlarge", "u-9tb1.112xlarge", "u-12tb1.112xlarge", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "u-18tb1.metal", "u-24tb1.metal", "vt1.3xlarge", "vt1.6xlarge", "vt1.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "x2iezn.2xlarge", "x2iezn.4xlarge", "x2iezn.6xlarge", "x2iezn.8xlarge", "x2iezn.12xlarge", "x2iezn.metal", "x2gd.medium", "x2gd.large", "x2gd.xlarge", "x2gd.2xlarge", "x2gd.4xlarge", "x2gd.8xlarge", "x2gd.12xlarge", "x2gd.16xlarge", "x2gd.metal", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "x2idn.16xlarge", "x2idn.24xlarge", "x2idn.32xlarge", "x2iedn.xlarge", "x2iedn.2xlarge", "x2iedn.4xlarge", "x2iedn.8xlarge", "x2iedn.16xlarge", "x2iedn.24xlarge", "x2iedn.32xlarge", "c6a.large", "c6a.xlarge", "c6a.2xlarge", "c6a.4xlarge", "c6a.8xlarge", "c6a.12xlarge", "c6a.16xlarge", "c6a.24xlarge", "c6a.32xlarge", "c6a.48xlarge", "c6a.metal", "m6a.metal", "i4i.large", "i4i.xlarge", "i4i.2xlarge", "i4i.4xlarge", "i4i.8xlarge", "i4i.16xlarge", "i4i.32xlarge", "i4i.metal", "x2idn.metal", "x2iedn.metal", "c7g.medium", "c7g.large", "c7g.xlarge", "c7g.2xlarge", "c7g.4xlarge", "c7g.8xlarge", "c7g.12xlarge", "c7g.16xlarge", "mac2.metal", "c6id.large", "c6id.xlarge", "c6id.2xlarge", "c6id.4xlarge", "c6id.8xlarge", "c6id.12xlarge", "c6id.16xlarge", "c6id.24xlarge", "c6id.32xlarge", "c6id.metal", "m6id.large", "m6id.xlarge", "m6id.2xlarge", "m6id.4xlarge", "m6id.8xlarge", "m6id.12xlarge", "m6id.16xlarge", "m6id.24xlarge", "m6id.32xlarge", "m6id.metal", "r6id.large", "r6id.xlarge", "r6id.2xlarge", "r6id.4xlarge", "r6id.8xlarge", "r6id.12xlarge", "r6id.16xlarge", "r6id.24xlarge", "r6id.32xlarge", "r6id.metal", "r6a.large", "r6a.xlarge", "r6a.2xlarge", "r6a.4xlarge", "r6a.8xlarge", "r6a.12xlarge", "r6a.16xlarge", "r6a.24xlarge", "r6a.32xlarge", "r6a.48xlarge", "r6a.metal", "p4de.24xlarge", "u-3tb1.56xlarge", "u-18tb1.112xlarge", "u-24tb1.112xlarge", "trn1.2xlarge", "trn1.32xlarge", "hpc6id.32xlarge", "c6in.large", "c6in.xlarge", "c6in.2xlarge", "c6in.4xlarge", "c6in.8xlarge", "c6in.12xlarge", "c6in.16xlarge", "c6in.24xlarge", "c6in.32xlarge", "m6in.large", "m6in.xlarge", "m6in.2xlarge", "m6in.4xlarge", "m6in.8xlarge", "m6in.12xlarge", "m6in.16xlarge", "m6in.24xlarge", "m6in.32xlarge", "m6idn.large", "m6idn.xlarge", "m6idn.2xlarge", "m6idn.4xlarge", "m6idn.8xlarge", "m6idn.12xlarge", "m6idn.16xlarge", "m6idn.24xlarge", "m6idn.32xlarge", "r6in.large", "r6in.xlarge", "r6in.2xlarge", "r6in.4xlarge", "r6in.8xlarge", "r6in.12xlarge", "r6in.16xlarge", "r6in.24xlarge", "r6in.32xlarge", "r6idn.large", "r6idn.xlarge", "r6idn.2xlarge", "r6idn.4xlarge", "r6idn.8xlarge", "r6idn.12xlarge", "r6idn.16xlarge", "r6idn.24xlarge", "r6idn.32xlarge", "c7g.metal", "m7g.medium", "m7g.large", "m7g.xlarge", "m7g.2xlarge", "m7g.4xlarge", "m7g.8xlarge", "m7g.12xlarge", "m7g.16xlarge", "m7g.metal", "r7g.medium", "r7g.large", "r7g.xlarge", "r7g.2xlarge", "r7g.4xlarge", "r7g.8xlarge", "r7g.12xlarge", "r7g.16xlarge", "r7g.metal", "c6in.metal", "m6in.metal", "m6idn.metal", "r6in.metal", "r6idn.metal", "inf2.xlarge", "inf2.8xlarge", "inf2.24xlarge", "inf2.48xlarge", "trn1n.32xlarge", "i4g.large", "i4g.xlarge", "i4g.2xlarge", "i4g.4xlarge", "i4g.8xlarge", "i4g.16xlarge", "hpc7g.4xlarge", "hpc7g.8xlarge", "hpc7g.16xlarge", "c7gn.medium", "c7gn.large", "c7gn.xlarge", "c7gn.2xlarge", "c7gn.4xlarge", "c7gn.8xlarge", "c7gn.12xlarge", "c7gn.16xlarge", "p5.48xlarge", "m7i.large", "m7i.xlarge", "m7i.2xlarge", "m7i.4xlarge", "m7i.8xlarge", "m7i.12xlarge", "m7i.16xlarge", "m7i.24xlarge", "m7i.48xlarge", "m7i-flex.large", "m7i-flex.xlarge", "m7i-flex.2xlarge", "m7i-flex.4xlarge", "m7i-flex.8xlarge", "m7a.medium", "m7a.large", "m7a.xlarge", "m7a.2xlarge", "m7a.4xlarge", "m7a.8xlarge", "m7a.12xlarge", "m7a.16xlarge", "m7a.24xlarge", "m7a.32xlarge", "m7a.48xlarge", "m7a.metal-48xl", "hpc7a.12xlarge", "hpc7a.24xlarge", "hpc7a.48xlarge", "hpc7a.96xlarge", "c7gd.medium", "c7gd.large", "c7gd.xlarge", "c7gd.2xlarge", "c7gd.4xlarge", "c7gd.8xlarge", "c7gd.12xlarge", "c7gd.16xlarge", "m7gd.medium", "m7gd.large", "m7gd.xlarge", "m7gd.2xlarge", "m7gd.4xlarge", "m7gd.8xlarge", "m7gd.12xlarge", "m7gd.16xlarge", "r7gd.medium", "r7gd.large", "r7gd.xlarge", "r7gd.2xlarge", "r7gd.4xlarge", "r7gd.8xlarge", "r7gd.12xlarge", "r7gd.16xlarge", "r7a.medium", "r7a.large", "r7a.xlarge", "r7a.2xlarge", "r7a.4xlarge", "r7a.8xlarge", "r7a.12xlarge", "r7a.16xlarge", "r7a.24xlarge", "r7a.32xlarge", "r7a.48xlarge", "c7i.large", "c7i.xlarge", "c7i.2xlarge", "c7i.4xlarge", "c7i.8xlarge", "c7i.12xlarge", "c7i.16xlarge", "c7i.24xlarge", "c7i.48xlarge", "mac2-m2pro.metal", "r7iz.large", "r7iz.xlarge", "r7iz.2xlarge", "r7iz.4xlarge", "r7iz.8xlarge", "r7iz.12xlarge", "r7iz.16xlarge", "r7iz.32xlarge", "c7a.medium", "c7a.large", "c7a.xlarge", "c7a.2xlarge", "c7a.4xlarge", "c7a.8xlarge", "c7a.12xlarge", "c7a.16xlarge", "c7a.24xlarge", "c7a.32xlarge", "c7a.48xlarge", "c7a.metal-48xl", "r7a.metal-48xl", "r7i.large", "r7i.xlarge", "r7i.2xlarge", "r7i.4xlarge", "r7i.8xlarge", "r7i.12xlarge", "r7i.16xlarge", "r7i.24xlarge", "r7i.48xlarge", "dl2q.24xlarge", "mac2-m2.metal", "i4i.12xlarge", "i4i.24xlarge", "c7i.metal-24xl", "c7i.metal-48xl", "m7i.metal-24xl", "m7i.metal-48xl", "r7i.metal-24xl", "r7i.metal-48xl", "r7iz.metal-16xl", "r7iz.metal-32xl", "c7gd.metal", "m7gd.metal", "r7gd.metal", "g6.xlarge", "g6.2xlarge", "g6.4xlarge", "g6.8xlarge", "g6.12xlarge", "g6.16xlarge", "g6.24xlarge", "g6.48xlarge", "gr6.4xlarge", "gr6.8xlarge", "c7i-flex.large", "c7i-flex.xlarge", "c7i-flex.2xlarge", "c7i-flex.4xlarge", "c7i-flex.8xlarge", "u7i-12tb.224xlarge", "u7in-16tb.224xlarge", "u7in-24tb.224xlarge", "u7in-32tb.224xlarge", "u7ib-12tb.224xlarge", "c7gn.metal", "r8g.medium", "r8g.large", "r8g.xlarge", "r8g.2xlarge", "r8g.4xlarge", "r8g.8xlarge", "r8g.12xlarge", "r8g.16xlarge", "r8g.24xlarge", "r8g.48xlarge", "r8g.metal-24xl", "r8g.metal-48xl", "mac2-m1ultra.metal", "g6e.xlarge", "g6e.2xlarge", "g6e.4xlarge", "g6e.8xlarge", "g6e.12xlarge", "g6e.16xlarge", "g6e.24xlarge", "g6e.48xlarge", "c8g.medium", "c8g.large", "c8g.xlarge", "c8g.2xlarge", "c8g.4xlarge", "c8g.8xlarge", "c8g.12xlarge", "c8g.16xlarge", "c8g.24xlarge", "c8g.48xlarge", "c8g.metal-24xl", "c8g.metal-48xl", "m8g.medium", "m8g.large", "m8g.xlarge", "m8g.2xlarge", "m8g.4xlarge", "m8g.8xlarge", "m8g.12xlarge", "m8g.16xlarge", "m8g.24xlarge", "m8g.48xlarge", "m8g.metal-24xl", "m8g.metal-48xl", "x8g.medium", "x8g.large", "x8g.xlarge", "x8g.2xlarge", "x8g.4xlarge", "x8g.8xlarge", "x8g.12xlarge", "x8g.16xlarge", "x8g.24xlarge", "x8g.48xlarge", "x8g.metal-24xl", "x8g.metal-48xl", "i7ie.large", "i7ie.xlarge", "i7ie.2xlarge", "i7ie.3xlarge", "i7ie.6xlarge", "i7ie.12xlarge", "i7ie.18xlarge", "i7ie.24xlarge", "i7ie.48xlarge", "i8g.large", "i8g.xlarge", "i8g.2xlarge", "i8g.4xlarge", "i8g.8xlarge", "i8g.12xlarge", "i8g.16xlarge", "i8g.24xlarge", "i8g.metal-24xl", "u7i-6tb.112xlarge", "u7i-8tb.112xlarge", "u7inh-32tb.480xlarge", "p5e.48xlarge", "p5en.48xlarge", "f2.12xlarge", "f2.48xlarge", "trn2.48xlarge", "c7i-flex.12xlarge", "c7i-flex.16xlarge", "m7i-flex.12xlarge", "m7i-flex.16xlarge", "i7ie.metal-24xl", "i7ie.metal-48xl", "i8g.48xlarge", "c8gd.medium", "c8gd.large", "c8gd.xlarge", "c8gd.2xlarge", "c8gd.4xlarge", "c8gd.8xlarge", "c8gd.12xlarge", "c8gd.16xlarge", "c8gd.24xlarge", "c8gd.48xlarge", "c8gd.metal-24xl", "c8gd.metal-48xl", "i7i.large", "i7i.xlarge", "i7i.2xlarge", "i7i.4xlarge", "i7i.8xlarge", "i7i.12xlarge", "i7i.16xlarge", "i7i.24xlarge", "i7i.48xlarge", "i7i.metal-24xl", "i7i.metal-48xl", "p6-b200.48xlarge", "m8gd.medium", "m8gd.large", "m8gd.xlarge", "m8gd.2xlarge", "m8gd.4xlarge", "m8gd.8xlarge", "m8gd.12xlarge", "m8gd.16xlarge", "m8gd.24xlarge", "m8gd.48xlarge", "m8gd.metal-24xl", "m8gd.metal-48xl", "r8gd.medium", "r8gd.large", "r8gd.xlarge", "r8gd.2xlarge", "r8gd.4xlarge", "r8gd.8xlarge", "r8gd.12xlarge", "r8gd.16xlarge", "r8gd.24xlarge", "r8gd.48xlarge", "r8gd.metal-24xl", "r8gd.metal-48xl", "c8gn.medium", "c8gn.large", "c8gn.xlarge", "c8gn.2xlarge", "c8gn.4xlarge", "c8gn.8xlarge", "c8gn.12xlarge", "c8gn.16xlarge", "c8gn.24xlarge", "c8gn.48xlarge", "c8gn.metal-24xl", "c8gn.metal-48xl", "f2.6xlarge", "p6e-gb200.36xlarge"
    #   resp.fleet_capacity_reservations[0].instance_platform #=> String, one of "Linux/UNIX", "Red Hat Enterprise Linux", "SUSE Linux", "Windows", "Windows with SQL Server", "Windows with SQL Server Enterprise", "Windows with SQL Server Standard", "Windows with SQL Server Web", "Linux with SQL Server Standard", "Linux with SQL Server Web", "Linux with SQL Server Enterprise", "RHEL with SQL Server Standard", "RHEL with SQL Server Enterprise", "RHEL with SQL Server Web", "RHEL with HA", "RHEL with HA and SQL Server Standard", "RHEL with HA and SQL Server Enterprise", "Ubuntu Pro"
    #   resp.fleet_capacity_reservations[0].availability_zone #=> String
    #   resp.fleet_capacity_reservations[0].total_instance_count #=> Integer
    #   resp.fleet_capacity_reservations[0].fulfilled_capacity #=> Float
    #   resp.fleet_capacity_reservations[0].ebs_optimized #=> Boolean
    #   resp.fleet_capacity_reservations[0].create_date #=> Time
    #   resp.fleet_capacity_reservations[0].weight #=> Float
    #   resp.fleet_capacity_reservations[0].priority #=> Integer
    #   resp.tags #=> Array
    #   resp.tags[0].key #=> String
    #   resp.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationFleet AWS API Documentation
    #
    # @overload create_capacity_reservation_fleet(params = {})
    # @param [Hash] params ({})
    def create_capacity_reservation_fleet(params = {}, options = {})
      req = build_request(:create_capacity_reservation_fleet, params)
      req.send_request(options)
    end

    # Creates a carrier gateway. For more information about carrier
    # gateways, see [Carrier gateways][1] in the *Amazon Web Services
    # Wavelength Developer Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#wavelength-carrier-gateway
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC to associate with the carrier gateway.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to associate with the carrier gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @return [Types::CreateCarrierGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateCarrierGatewayResult#carrier_gateway #carrier_gateway} => Types::CarrierGateway
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_carrier_gateway({
    #     vpc_id: "VpcId", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.carrier_gateway.carrier_gateway_id #=> String
    #   resp.carrier_gateway.vpc_id #=> String
    #   resp.carrier_gateway.state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.carrier_gateway.owner_id #=> String
    #   resp.carrier_gateway.tags #=> Array
    #   resp.carrier_gateway.tags[0].key #=> String
    #   resp.carrier_gateway.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCarrierGateway AWS API Documentation
    #
    # @overload create_carrier_gateway(params = {})
    # @param [Hash] params ({})
    def create_carrier_gateway(params = {}, options = {})
      req = build_request(:create_carrier_gateway, params)
      req.send_request(options)
    end

    # Creates a Client VPN endpoint. A Client VPN endpoint is the resource
    # you create and configure to enable and manage client VPN sessions. It
    # is the destination endpoint at which all client VPN sessions are
    # terminated.
    #
    # @option params [String] :client_cidr_block
    #   The IPv4 address range, in CIDR notation, from which to assign client
    #   IP addresses. The address range cannot overlap with the local CIDR of
    #   the VPC in which the associated subnet is located, or the routes that
    #   you add manually. The address range cannot be changed after the Client
    #   VPN endpoint has been created. Client CIDR range must have a size of
    #   at least /22 and must not be greater than /12.
    #
    # @option params [required, String] :server_certificate_arn
    #   The ARN of the server certificate. For more information, see the
    #   [Certificate Manager User Guide][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/acm/latest/userguide/
    #
    # @option params [required, Array<Types::ClientVpnAuthenticationRequest>] :authentication_options
    #   Information about the authentication method to be used to authenticate
    #   clients.
    #
    # @option params [required, Types::ConnectionLogOptions] :connection_log_options
    #   Information about the client connection logging options.
    #
    #   If you enable client connection logging, data about client connections
    #   is sent to a Cloudwatch Logs log stream. The following information is
    #   logged:
    #
    #   * Client connection requests
    #
    #   * Client connection results (successful and unsuccessful)
    #
    #   * Reasons for unsuccessful client connection requests
    #
    #   * Client connection termination time
    #
    # @option params [Array<String>] :dns_servers
    #   Information about the DNS servers to be used for DNS resolution. A
    #   Client VPN endpoint can have up to two DNS servers. If no DNS server
    #   is specified, the DNS address configured on the device is used for the
    #   DNS server.
    #
    # @option params [String] :transport_protocol
    #   The transport protocol to be used by the VPN session.
    #
    #   Default value: `udp`
    #
    # @option params [Integer] :vpn_port
    #   The port number to assign to the Client VPN endpoint for TCP and UDP
    #   traffic.
    #
    #   Valid Values: `443` \| `1194`
    #
    #   Default Value: `443`
    #
    # @option params [String] :description
    #   A brief description of the Client VPN endpoint.
    #
    # @option params [Boolean] :split_tunnel
    #   Indicates whether split-tunnel is enabled on the Client VPN endpoint.
    #
    #   By default, split-tunnel on a VPN endpoint is disabled.
    #
    #   For information about split-tunnel VPN endpoints, see [Split-tunnel
    #   Client VPN endpoint][1] in the *Client VPN Administrator Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the Client VPN endpoint during creation.
    #
    # @option params [Array<String>] :security_group_ids
    #   The IDs of one or more security groups to apply to the target network.
    #   You must also specify the ID of the VPC that contains the security
    #   groups.
    #
    # @option params [String] :vpc_id
    #   The ID of the VPC to associate with the Client VPN endpoint. If no
    #   security group IDs are specified in the request, the default security
    #   group for the VPC is applied.
    #
    # @option params [String] :self_service_portal
    #   Specify whether to enable the self-service portal for the Client VPN
    #   endpoint.
    #
    #   Default Value: `enabled`
    #
    # @option params [Types::ClientConnectOptions] :client_connect_options
    #   The options for managing connection authorization for new client
    #   connections.
    #
    # @option params [Integer] :session_timeout_hours
    #   The maximum VPN session duration time in hours.
    #
    #   Valid values: `8 | 10 | 12 | 24`
    #
    #   Default value: `24`
    #
    # @option params [Types::ClientLoginBannerOptions] :client_login_banner_options
    #   Options for enabling a customizable text banner that will be displayed
    #   on Amazon Web Services provided clients when a VPN session is
    #   established.
    #
    # @option params [Types::ClientRouteEnforcementOptions] :client_route_enforcement_options
    #   Client route enforcement is a feature of the Client VPN service that
    #   helps enforce administrator defined routes on devices connected
    #   through the VPN. T his feature helps improve your security posture by
    #   ensuring that network traffic originating from a connected client is
    #   not inadvertently sent outside the VPN tunnel.
    #
    #   Client route enforcement works by monitoring the route table of a
    #   connected device for routing policy changes to the VPN connection. If
    #   the feature detects any VPN routing policy modifications, it will
    #   automatically force an update to the route table, reverting it back to
    #   the expected route configurations.
    #
    # @option params [Boolean] :disconnect_on_session_timeout
    #   Indicates whether the client VPN session is disconnected after the
    #   maximum timeout specified in `SessionTimeoutHours` is reached. If
    #   `true`, users are prompted to reconnect client VPN. If `false`, client
    #   VPN attempts to reconnect automatically. The default value is `true`.
    #
    # @option params [String] :endpoint_ip_address_type
    #   The IP address type for the Client VPN endpoint. Valid values are
    #   `ipv4` (default) for IPv4 addressing only, `ipv6` for IPv6 addressing
    #   only, or `dual-stack` for both IPv4 and IPv6 addressing. When set to
    #   `dual-stack,` clients can connect to the endpoint using either IPv4 or
    #   IPv6 addresses..
    #
    # @option params [String] :traffic_ip_address_type
    #   The IP address type for traffic within the Client VPN tunnel. Valid
    #   values are `ipv4` (default) for IPv4 traffic only, `ipv6` for IPv6
    #   addressing only, or `dual-stack` for both IPv4 and IPv6 traffic. When
    #   set to `dual-stack`, clients can access both IPv4 and IPv6 resources
    #   through the VPN .
    #
    # @return [Types::CreateClientVpnEndpointResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateClientVpnEndpointResult#client_vpn_endpoint_id #client_vpn_endpoint_id} => String
    #   * {Types::CreateClientVpnEndpointResult#status #status} => Types::ClientVpnEndpointStatus
    #   * {Types::CreateClientVpnEndpointResult#dns_name #dns_name} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_client_vpn_endpoint({
    #     client_cidr_block: "String",
    #     server_certificate_arn: "String", # required
    #     authentication_options: [ # required
    #       {
    #         type: "certificate-authentication", # accepts certificate-authentication, directory-service-authentication, federated-authentication
    #         active_directory: {
    #           directory_id: "String",
    #         },
    #         mutual_authentication: {
    #           client_root_certificate_chain_arn: "String",
    #         },
    #         federated_authentication: {
    #           saml_provider_arn: "String",
    #           self_service_saml_provider_arn: "String",
    #         },
    #       },
    #     ],
    #     connection_log_options: { # required
    #       enabled: false,
    #       cloudwatch_log_group: "String",
    #       cloudwatch_log_stream: "String",
    #     },
    #     dns_servers: ["String"],
    #     transport_protocol: "tcp", # accepts tcp, udp
    #     vpn_port: 1,
    #     description: "String",
    #     split_tunnel: false,
    #     dry_run: false,
    #     client_token: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     security_group_ids: ["SecurityGroupId"],
    #     vpc_id: "VpcId",
    #     self_service_portal: "enabled", # accepts enabled, disabled
    #     client_connect_options: {
    #       enabled: false,
    #       lambda_function_arn: "String",
    #     },
    #     session_timeout_hours: 1,
    #     client_login_banner_options: {
    #       enabled: false,
    #       banner_text: "String",
    #     },
    #     client_route_enforcement_options: {
    #       enforced: false,
    #     },
    #     disconnect_on_session_timeout: false,
    #     endpoint_ip_address_type: "ipv4", # accepts ipv4, ipv6, dual-stack
    #     traffic_ip_address_type: "ipv4", # accepts ipv4, ipv6, dual-stack
    #   })
    #
    # @example Response structure
    #
    #   resp.client_vpn_endpoint_id #=> String
    #   resp.status.code #=> String, one of "pending-associate", "available", "deleting", "deleted"
    #   resp.status.message #=> String
    #   resp.dns_name #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpoint AWS API Documentation
    #
    # @overload create_client_vpn_endpoint(params = {})
    # @param [Hash] params ({})
    def create_client_vpn_endpoint(params = {}, options = {})
      req = build_request(:create_client_vpn_endpoint, params)
      req.send_request(options)
    end

    # Adds a route to a network to a Client VPN endpoint. Each Client VPN
    # endpoint has a route table that describes the available destination
    # network routes. Each route in the route table specifies the path for
    # traﬃc to speciﬁc resources or networks.
    #
    # @option params [required, String] :client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint to which to add the route.
    #
    # @option params [required, String] :destination_cidr_block
    #   The IPv4 address range, in CIDR notation, of the route destination.
    #   For example:
    #
    #   * To add a route for Internet access, enter `0.0.0.0/0`
    #
    #   * To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR
    #     range
    #
    #   * To add a route for an on-premises network, enter the Amazon Web
    #     Services Site-to-Site VPN connection's IPv4 CIDR range
    #
    #   * To add a route for the local network, enter the client CIDR range
    #
    # @option params [required, String] :target_vpc_subnet_id
    #   The ID of the subnet through which you want to route traffic. The
    #   specified subnet must be an existing target network of the Client VPN
    #   endpoint.
    #
    #   Alternatively, if you're adding a route for the local network,
    #   specify `local`.
    #
    # @option params [String] :description
    #   A brief description of the route.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateClientVpnRouteResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateClientVpnRouteResult#status #status} => Types::ClientVpnRouteStatus
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_client_vpn_route({
    #     client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #     destination_cidr_block: "String", # required
    #     target_vpc_subnet_id: "SubnetId", # required
    #     description: "String",
    #     client_token: "String",
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.status.code #=> String, one of "creating", "active", "failed", "deleting"
    #   resp.status.message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnRoute AWS API Documentation
    #
    # @overload create_client_vpn_route(params = {})
    # @param [Hash] params ({})
    def create_client_vpn_route(params = {}, options = {})
      req = build_request(:create_client_vpn_route, params)
      req.send_request(options)
    end

    # Creates a range of customer-owned IP addresses.
    #
    # @option params [required, String] :cidr
    #   A customer-owned IP address range to create.
    #
    # @option params [required, String] :coip_pool_id
    #   The ID of the address pool.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateCoipCidrResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateCoipCidrResult#coip_cidr #coip_cidr} => Types::CoipCidr
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_coip_cidr({
    #     cidr: "String", # required
    #     coip_pool_id: "Ipv4PoolCoipId", # required
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.coip_cidr.cidr #=> String
    #   resp.coip_cidr.coip_pool_id #=> String
    #   resp.coip_cidr.local_gateway_route_table_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipCidr AWS API Documentation
    #
    # @overload create_coip_cidr(params = {})
    # @param [Hash] params ({})
    def create_coip_cidr(params = {}, options = {})
      req = build_request(:create_coip_cidr, params)
      req.send_request(options)
    end

    # Creates a pool of customer-owned IP (CoIP) addresses.
    #
    # @option params [required, String] :local_gateway_route_table_id
    #   The ID of the local gateway route table.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the CoIP address pool.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateCoipPoolResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateCoipPoolResult#coip_pool #coip_pool} => Types::CoipPool
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_coip_pool({
    #     local_gateway_route_table_id: "LocalGatewayRoutetableId", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.coip_pool.pool_id #=> String
    #   resp.coip_pool.pool_cidrs #=> Array
    #   resp.coip_pool.pool_cidrs[0] #=> String
    #   resp.coip_pool.local_gateway_route_table_id #=> String
    #   resp.coip_pool.tags #=> Array
    #   resp.coip_pool.tags[0].key #=> String
    #   resp.coip_pool.tags[0].value #=> String
    #   resp.coip_pool.pool_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCoipPool AWS API Documentation
    #
    # @overload create_coip_pool(params = {})
    # @param [Hash] params ({})
    def create_coip_pool(params = {}, options = {})
      req = build_request(:create_coip_pool, params)
      req.send_request(options)
    end

    # Provides information to Amazon Web Services about your customer
    # gateway device. The customer gateway device is the appliance at your
    # end of the VPN connection. You must provide the IP address of the
    # customer gateway device’s external interface. The IP address must be
    # static and can be behind a device performing network address
    # translation (NAT).
    #
    # For devices that use Border Gateway Protocol (BGP), you can also
    # provide the device's BGP Autonomous System Number (ASN). You can use
    # an existing ASN assigned to your network. If you don't have an ASN
    # already, you can use a private ASN. For more information, see
    # [Customer gateway options for your Site-to-Site VPN connection][1] in
    # the *Amazon Web Services Site-to-Site VPN User Guide*.
    #
    # To create more than one customer gateway with the same VPN type, IP
    # address, and BGP ASN, specify a unique device name for each customer
    # gateway. An identical request returns information about the existing
    # customer gateway; it doesn't create a new customer gateway.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpn/latest/s2svpn/cgw-options.html
    #
    # @option params [Integer] :bgp_asn
    #   For customer gateway devices that support BGP, specify the device's
    #   ASN. You must specify either `BgpAsn` or `BgpAsnExtended` when
    #   creating the customer gateway. If the ASN is larger than
    #   `2,147,483,647`, you must use `BgpAsnExtended`.
    #
    #   Default: 65000
    #
    #   Valid values: `1` to `2,147,483,647`
    #
    # @option params [String] :public_ip
    #   *This member has been deprecated.* The Internet-routable IP address
    #   for the customer gateway's outside interface. The address must be
    #   static.
    #
    # @option params [String] :certificate_arn
    #   The Amazon Resource Name (ARN) for the customer gateway certificate.
    #
    # @option params [required, String] :type
    #   The type of VPN connection that this customer gateway supports
    #   (`ipsec.1`).
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the customer gateway.
    #
    # @option params [String] :device_name
    #   A name for the customer gateway device.
    #
    #   Length Constraints: Up to 255 characters.
    #
    # @option params [String] :ip_address
    #   The IP address for the customer gateway device's outside interface.
    #   The address must be static. If `OutsideIpAddressType` in your VPN
    #   connection options is set to `PrivateIpv4`, you can use an RFC6598 or
    #   RFC1918 private IPv4 address. If `OutsideIpAddressType` is set to
    #   `Ipv6`, you can use an IPv6 address.
    #
    # @option params [Integer] :bgp_asn_extended
    #   For customer gateway devices that support BGP, specify the device's
    #   ASN. You must specify either `BgpAsn` or `BgpAsnExtended` when
    #   creating the customer gateway. If the ASN is larger than
    #   `2,147,483,647`, you must use `BgpAsnExtended`.
    #
    #   Valid values: `2,147,483,648` to `4,294,967,295`
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateCustomerGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateCustomerGatewayResult#customer_gateway #customer_gateway} => Types::CustomerGateway
    #
    #
    # @example Example: To create a customer gateway
    #
    #   # This example creates a customer gateway with the specified IP address for its outside interface.
    #
    #   resp = client.create_customer_gateway({
    #     bgp_asn: 65534, 
    #     public_ip: "12.1.2.3", 
    #     type: "ipsec.1", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     customer_gateway: {
    #       bgp_asn: "65534", 
    #       customer_gateway_id: "cgw-0e11f167", 
    #       ip_address: "12.1.2.3", 
    #       state: "available", 
    #       type: "ipsec.1", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_customer_gateway({
    #     bgp_asn: 1,
    #     public_ip: "String",
    #     certificate_arn: "String",
    #     type: "ipsec.1", # required, accepts ipsec.1
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     device_name: "String",
    #     ip_address: "String",
    #     bgp_asn_extended: 1,
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.customer_gateway.certificate_arn #=> String
    #   resp.customer_gateway.device_name #=> String
    #   resp.customer_gateway.tags #=> Array
    #   resp.customer_gateway.tags[0].key #=> String
    #   resp.customer_gateway.tags[0].value #=> String
    #   resp.customer_gateway.bgp_asn_extended #=> String
    #   resp.customer_gateway.customer_gateway_id #=> String
    #   resp.customer_gateway.state #=> String
    #   resp.customer_gateway.type #=> String
    #   resp.customer_gateway.ip_address #=> String
    #   resp.customer_gateway.bgp_asn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGateway AWS API Documentation
    #
    # @overload create_customer_gateway(params = {})
    # @param [Hash] params ({})
    def create_customer_gateway(params = {}, options = {})
      req = build_request(:create_customer_gateway, params)
      req.send_request(options)
    end

    # Creates a default subnet with a size `/20` IPv4 CIDR block in the
    # specified Availability Zone in your default VPC. You can have only one
    # default subnet per Availability Zone. For more information, see
    # [Create a default subnet][1] in the *Amazon VPC User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/work-with-default-vpc.html#create-default-subnet
    #
    # @option params [String] :availability_zone
    #   The Availability Zone in which to create the default subnet.
    #
    #   Either `AvailabilityZone` or `AvailabilityZoneId` must be specified,
    #   but not both.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Boolean] :ipv_6_native
    #   Indicates whether to create an IPv6 only subnet. If you already have a
    #   default subnet for this Availability Zone, you must delete it before
    #   you can create an IPv6 only subnet.
    #
    # @option params [String] :availability_zone_id
    #   The ID of the Availability Zone.
    #
    #   Either `AvailabilityZone` or `AvailabilityZoneId` must be specified,
    #   but not both.
    #
    # @return [Types::CreateDefaultSubnetResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDefaultSubnetResult#subnet #subnet} => Types::Subnet
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_default_subnet({
    #     availability_zone: "AvailabilityZoneName",
    #     dry_run: false,
    #     ipv_6_native: false,
    #     availability_zone_id: "AvailabilityZoneId",
    #   })
    #
    # @example Response structure
    #
    #   resp.subnet.availability_zone_id #=> String
    #   resp.subnet.enable_lni_at_device_index #=> Integer
    #   resp.subnet.map_customer_owned_ip_on_launch #=> Boolean
    #   resp.subnet.customer_owned_ipv_4_pool #=> String
    #   resp.subnet.owner_id #=> String
    #   resp.subnet.assign_ipv_6_address_on_creation #=> Boolean
    #   resp.subnet.ipv_6_cidr_block_association_set #=> Array
    #   resp.subnet.ipv_6_cidr_block_association_set[0].association_id #=> String
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block #=> String
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.status_message #=> String
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ipv_6_address_attribute #=> String, one of "public", "private"
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ip_source #=> String, one of "amazon", "byoip", "none"
    #   resp.subnet.tags #=> Array
    #   resp.subnet.tags[0].key #=> String
    #   resp.subnet.tags[0].value #=> String
    #   resp.subnet.subnet_arn #=> String
    #   resp.subnet.outpost_arn #=> String
    #   resp.subnet.enable_dns_64 #=> Boolean
    #   resp.subnet.ipv_6_native #=> Boolean
    #   resp.subnet.private_dns_name_options_on_launch.hostname_type #=> String, one of "ip-name", "resource-name"
    #   resp.subnet.private_dns_name_options_on_launch.enable_resource_name_dns_a_record #=> Boolean
    #   resp.subnet.private_dns_name_options_on_launch.enable_resource_name_dns_aaaa_record #=> Boolean
    #   resp.subnet.block_public_access_states.internet_gateway_block_mode #=> String, one of "off", "block-bidirectional", "block-ingress"
    #   resp.subnet.type #=> String
    #   resp.subnet.subnet_id #=> String
    #   resp.subnet.state #=> String, one of "pending", "available", "unavailable", "failed", "failed-insufficient-capacity"
    #   resp.subnet.vpc_id #=> String
    #   resp.subnet.cidr_block #=> String
    #   resp.subnet.available_ip_address_count #=> Integer
    #   resp.subnet.availability_zone #=> String
    #   resp.subnet.default_for_az #=> Boolean
    #   resp.subnet.map_public_ip_on_launch #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnet AWS API Documentation
    #
    # @overload create_default_subnet(params = {})
    # @param [Hash] params ({})
    def create_default_subnet(params = {}, options = {})
      req = build_request(:create_default_subnet, params)
      req.send_request(options)
    end

    # Creates a default VPC with a size `/16` IPv4 CIDR block and a default
    # subnet in each Availability Zone. For more information about the
    # components of a default VPC, see [Default VPCs][1] in the *Amazon VPC
    # User Guide*. You cannot specify the components of the default VPC
    # yourself.
    #
    # If you deleted your previous default VPC, you can create a default
    # VPC. You cannot have more than one default VPC per Region.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateDefaultVpcResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDefaultVpcResult#vpc #vpc} => Types::Vpc
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_default_vpc({
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.vpc.owner_id #=> String
    #   resp.vpc.instance_tenancy #=> String, one of "default", "dedicated", "host"
    #   resp.vpc.ipv_6_cidr_block_association_set #=> Array
    #   resp.vpc.ipv_6_cidr_block_association_set[0].association_id #=> String
    #   resp.vpc.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block #=> String
    #   resp.vpc.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.vpc.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.status_message #=> String
    #   resp.vpc.ipv_6_cidr_block_association_set[0].network_border_group #=> String
    #   resp.vpc.ipv_6_cidr_block_association_set[0].ipv_6_pool #=> String
    #   resp.vpc.ipv_6_cidr_block_association_set[0].ipv_6_address_attribute #=> String, one of "public", "private"
    #   resp.vpc.ipv_6_cidr_block_association_set[0].ip_source #=> String, one of "amazon", "byoip", "none"
    #   resp.vpc.cidr_block_association_set #=> Array
    #   resp.vpc.cidr_block_association_set[0].association_id #=> String
    #   resp.vpc.cidr_block_association_set[0].cidr_block #=> String
    #   resp.vpc.cidr_block_association_set[0].cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.vpc.cidr_block_association_set[0].cidr_block_state.status_message #=> String
    #   resp.vpc.is_default #=> Boolean
    #   resp.vpc.encryption_control.vpc_id #=> String
    #   resp.vpc.encryption_control.vpc_encryption_control_id #=> String
    #   resp.vpc.encryption_control.mode #=> String, one of "monitor", "enforce"
    #   resp.vpc.encryption_control.state #=> String, one of "enforce-in-progress", "monitor-in-progress", "enforce-failed", "monitor-failed", "deleting", "deleted", "available", "creating", "delete-failed"
    #   resp.vpc.encryption_control.state_message #=> String
    #   resp.vpc.encryption_control.resource_exclusions.internet_gateway.state #=> String, one of "enabling", "enabled", "disabling", "disabled"
    #   resp.vpc.encryption_control.resource_exclusions.internet_gateway.state_message #=> String
    #   resp.vpc.encryption_control.resource_exclusions.egress_only_internet_gateway.state #=> String, one of "enabling", "enabled", "disabling", "disabled"
    #   resp.vpc.encryption_control.resource_exclusions.egress_only_internet_gateway.state_message #=> String
    #   resp.vpc.encryption_control.resource_exclusions.nat_gateway.state #=> String, one of "enabling", "enabled", "disabling", "disabled"
    #   resp.vpc.encryption_control.resource_exclusions.nat_gateway.state_message #=> String
    #   resp.vpc.encryption_control.resource_exclusions.virtual_private_gateway.state #=> String, one of "enabling", "enabled", "disabling", "disabled"
    #   resp.vpc.encryption_control.resource_exclusions.virtual_private_gateway.state_message #=> String
    #   resp.vpc.encryption_control.resource_exclusions.vpc_peering.state #=> String, one of "enabling", "enabled", "disabling", "disabled"
    #   resp.vpc.encryption_control.resource_exclusions.vpc_peering.state_message #=> String
    #   resp.vpc.encryption_control.tags #=> Array
    #   resp.vpc.encryption_control.tags[0].key #=> String
    #   resp.vpc.encryption_control.tags[0].value #=> String
    #   resp.vpc.tags #=> Array
    #   resp.vpc.tags[0].key #=> String
    #   resp.vpc.tags[0].value #=> String
    #   resp.vpc.block_public_access_states.internet_gateway_block_mode #=> String, one of "off", "block-bidirectional", "block-ingress"
    #   resp.vpc.vpc_id #=> String
    #   resp.vpc.state #=> String, one of "pending", "available"
    #   resp.vpc.cidr_block #=> String
    #   resp.vpc.dhcp_options_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpc AWS API Documentation
    #
    # @overload create_default_vpc(params = {})
    # @param [Hash] params ({})
    def create_default_vpc(params = {}, options = {})
      req = build_request(:create_default_vpc, params)
      req.send_request(options)
    end

    # Delegates ownership of the Amazon EBS root volume for an Apple silicon
    # Mac instance to an administrative user.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :instance_id
    #   The ID of the Amazon EC2 Mac instance.
    #
    # @option params [required, String] :mac_credentials
    #   Specifies the following credentials:
    #
    #   * **Internal disk administrative user**
    #
    #     * **Username** - Only the default administrative user
    #       (`aws-managed-user`) is supported and it is used by default. You
    #       can't specify a different administrative user.
    #
    #     * **Password** - If you did not change the default password for
    #       `aws-managed-user`, specify the default password, which is
    #       *blank*. Otherwise, specify your password.
    #   * **Amazon EBS root volume administrative user**
    #
    #     * **Username** - If you did not change the default administrative
    #       user, specify `ec2-user`. Otherwise, specify the username for your
    #       administrative user.
    #
    #     * **Password** - Specify the password for the administrative user.
    #
    #   The credentials must be specified in the following JSON format:
    #
    #   `{ "internalDiskPassword":"internal-disk-admin_password",
    #   "rootVolumeUsername":"root-volume-admin_username",
    #   "rootVolumepassword":"root-volume-admin_password" }`
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the volume ownership delegation task.
    #
    # @return [Types::CreateDelegateMacVolumeOwnershipTaskResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDelegateMacVolumeOwnershipTaskResult#mac_modification_task #mac_modification_task} => Types::MacModificationTask
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_delegate_mac_volume_ownership_task({
    #     client_token: "String",
    #     dry_run: false,
    #     instance_id: "InstanceId", # required
    #     mac_credentials: "SensitiveMacCredentials", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.mac_modification_task.instance_id #=> String
    #   resp.mac_modification_task.mac_modification_task_id #=> String
    #   resp.mac_modification_task.mac_system_integrity_protection_config.apple_internal #=> String, one of "enabled", "disabled"
    #   resp.mac_modification_task.mac_system_integrity_protection_config.base_system #=> String, one of "enabled", "disabled"
    #   resp.mac_modification_task.mac_system_integrity_protection_config.debugging_restrictions #=> String, one of "enabled", "disabled"
    #   resp.mac_modification_task.mac_system_integrity_protection_config.d_trace_restrictions #=> String, one of "enabled", "disabled"
    #   resp.mac_modification_task.mac_system_integrity_protection_config.filesystem_protections #=> String, one of "enabled", "disabled"
    #   resp.mac_modification_task.mac_system_integrity_protection_config.kext_signing #=> String, one of "enabled", "disabled"
    #   resp.mac_modification_task.mac_system_integrity_protection_config.nvram_protections #=> String, one of "enabled", "disabled"
    #   resp.mac_modification_task.mac_system_integrity_protection_config.status #=> String, one of "enabled", "disabled"
    #   resp.mac_modification_task.start_time #=> Time
    #   resp.mac_modification_task.tags #=> Array
    #   resp.mac_modification_task.tags[0].key #=> String
    #   resp.mac_modification_task.tags[0].value #=> String
    #   resp.mac_modification_task.task_state #=> String, one of "successful", "failed", "in-progress", "pending"
    #   resp.mac_modification_task.task_type #=> String, one of "sip-modification", "volume-ownership-delegation"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDelegateMacVolumeOwnershipTask AWS API Documentation
    #
    # @overload create_delegate_mac_volume_ownership_task(params = {})
    # @param [Hash] params ({})
    def create_delegate_mac_volume_ownership_task(params = {}, options = {})
      req = build_request(:create_delegate_mac_volume_ownership_task, params)
      req.send_request(options)
    end

    # Creates a custom set of DHCP options. After you create a DHCP option
    # set, you associate it with a VPC. After you associate a DHCP option
    # set with a VPC, all existing and newly launched instances in the VPC
    # use this set of DHCP options.
    #
    # The following are the individual DHCP options you can specify. For
    # more information, see [DHCP option sets][1] in the *Amazon VPC User
    # Guide*.
    #
    # * `domain-name` - If you're using AmazonProvidedDNS in `us-east-1`,
    #   specify `ec2.internal`. If you're using AmazonProvidedDNS in any
    #   other Region, specify `region.compute.internal`. Otherwise, specify
    #   a custom domain name. This value is used to complete unqualified DNS
    #   hostnames.
    #
    #   Some Linux operating systems accept multiple domain names separated
    #   by spaces. However, Windows and other Linux operating systems treat
    #   the value as a single domain, which results in unexpected behavior.
    #   If your DHCP option set is associated with a VPC that has instances
    #   running operating systems that treat the value as a single domain,
    #   specify only one domain name.
    #
    # * `domain-name-servers` - The IP addresses of up to four DNS servers,
    #   or AmazonProvidedDNS. To specify multiple domain name servers in a
    #   single parameter, separate the IP addresses using commas. To have
    #   your instances receive custom DNS hostnames as specified in
    #   `domain-name`, you must specify a custom DNS server.
    #
    # * `ntp-servers` - The IP addresses of up to eight Network Time
    #   Protocol (NTP) servers (four IPv4 addresses and four IPv6
    #   addresses).
    #
    # * `netbios-name-servers` - The IP addresses of up to four NetBIOS name
    #   servers.
    #
    # * `netbios-node-type` - The NetBIOS node type (1, 2, 4, or 8). We
    #   recommend that you specify 2. Broadcast and multicast are not
    #   supported. For more information about NetBIOS node types, see [RFC
    #   2132][2].
    #
    # * `ipv6-address-preferred-lease-time` - A value (in seconds, minutes,
    #   hours, or years) for how frequently a running instance with an IPv6
    #   assigned to it goes through DHCPv6 lease renewal. Acceptable values
    #   are between 140 and 2147483647 seconds (approximately 68 years). If
    #   no value is entered, the default lease time is 140 seconds. If you
    #   use long-term addressing for EC2 instances, you can increase the
    #   lease time and avoid frequent lease renewal requests. Lease renewal
    #   typically occurs when half of the lease time has elapsed.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html
    # [2]: https://www.ietf.org/rfc/rfc2132.txt
    #
    # @option params [required, Array<Types::NewDhcpConfiguration>] :dhcp_configurations
    #   A DHCP configuration option.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the DHCP option.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateDhcpOptionsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateDhcpOptionsResult#dhcp_options #dhcp_options} => Types::DhcpOptions
    #
    #
    # @example Example: To create a DHCP options set
    #
    #   # This example creates a DHCP options set.
    #
    #   resp = client.create_dhcp_options({
    #     dhcp_configurations: [
    #       {
    #         key: "domain-name-servers", 
    #         values: [
    #           "10.2.5.1", 
    #           "10.2.5.2", 
    #         ], 
    #       }, 
    #     ], 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     dhcp_options: {
    #       dhcp_configurations: [
    #         {
    #           key: "domain-name-servers", 
    #           values: [
    #             {
    #               value: "10.2.5.2", 
    #             }, 
    #             {
    #               value: "10.2.5.1", 
    #             }, 
    #           ], 
    #         }, 
    #       ], 
    #       dhcp_options_id: "dopt-d9070ebb", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_dhcp_options({
    #     dhcp_configurations: [ # required
    #       {
    #         key: "String",
    #         values: ["String"],
    #       },
    #     ],
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.dhcp_options.owner_id #=> String
    #   resp.dhcp_options.tags #=> Array
    #   resp.dhcp_options.tags[0].key #=> String
    #   resp.dhcp_options.tags[0].value #=> String
    #   resp.dhcp_options.dhcp_options_id #=> String
    #   resp.dhcp_options.dhcp_configurations #=> Array
    #   resp.dhcp_options.dhcp_configurations[0].key #=> String
    #   resp.dhcp_options.dhcp_configurations[0].values #=> Array
    #   resp.dhcp_options.dhcp_configurations[0].values[0] #=> <Hash,Array,String,Numeric,Boolean,IO,Set,nil>
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptions AWS API Documentation
    #
    # @overload create_dhcp_options(params = {})
    # @param [Hash] params ({})
    def create_dhcp_options(params = {}, options = {})
      req = build_request(:create_dhcp_options, params)
      req.send_request(options)
    end

    # \[IPv6 only\] Creates an egress-only internet gateway for your VPC. An
    # egress-only internet gateway is used to enable outbound communication
    # over IPv6 from instances in your VPC to the internet, and prevents
    # hosts outside of your VPC from initiating an IPv6 connection with your
    # instance.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC for which to create the egress-only internet
    #   gateway.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the egress-only internet gateway.
    #
    # @return [Types::CreateEgressOnlyInternetGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateEgressOnlyInternetGatewayResult#client_token #client_token} => String
    #   * {Types::CreateEgressOnlyInternetGatewayResult#egress_only_internet_gateway #egress_only_internet_gateway} => Types::EgressOnlyInternetGateway
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_egress_only_internet_gateway({
    #     client_token: "String",
    #     dry_run: false,
    #     vpc_id: "VpcId", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.client_token #=> String
    #   resp.egress_only_internet_gateway.attachments #=> Array
    #   resp.egress_only_internet_gateway.attachments[0].state #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.egress_only_internet_gateway.attachments[0].vpc_id #=> String
    #   resp.egress_only_internet_gateway.egress_only_internet_gateway_id #=> String
    #   resp.egress_only_internet_gateway.tags #=> Array
    #   resp.egress_only_internet_gateway.tags[0].key #=> String
    #   resp.egress_only_internet_gateway.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGateway AWS API Documentation
    #
    # @overload create_egress_only_internet_gateway(params = {})
    # @param [Hash] params ({})
    def create_egress_only_internet_gateway(params = {}, options = {})
      req = build_request(:create_egress_only_internet_gateway, params)
      req.send_request(options)
    end

    # Creates an EC2 Fleet that contains the configuration information for
    # On-Demand Instances and Spot Instances. Instances are launched
    # immediately if there is available capacity.
    #
    # A single EC2 Fleet can include multiple launch specifications that
    # vary by instance type, AMI, Availability Zone, or subnet.
    #
    # For more information, see [EC2 Fleet][1] in the *Amazon EC2 User
    # Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. If you do not specify a client token, a
    #   randomly generated token is used for the request to ensure
    #   idempotency.
    #
    #   For more information, see [Ensuring idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [Types::SpotOptionsRequest] :spot_options
    #   Describes the configuration of Spot Instances in an EC2 Fleet.
    #
    # @option params [Types::OnDemandOptionsRequest] :on_demand_options
    #   Describes the configuration of On-Demand Instances in an EC2 Fleet.
    #
    # @option params [String] :excess_capacity_termination_policy
    #   Indicates whether running instances should be terminated if the total
    #   target capacity of the EC2 Fleet is decreased below the current size
    #   of the EC2 Fleet.
    #
    #   Supported only for fleets of type `maintain`.
    #
    # @option params [required, Array<Types::FleetLaunchTemplateConfigRequest>] :launch_template_configs
    #   The configuration for the EC2 Fleet.
    #
    # @option params [required, Types::TargetCapacitySpecificationRequest] :target_capacity_specification
    #   The number of units to request.
    #
    # @option params [Boolean] :terminate_instances_with_expiration
    #   Indicates whether running instances should be terminated when the EC2
    #   Fleet expires.
    #
    # @option params [String] :type
    #   The fleet type. The default value is `maintain`.
    #
    #   * `maintain` - The EC2 Fleet places an asynchronous request for your
    #     desired capacity, and continues to maintain your desired Spot
    #     capacity by replenishing interrupted Spot Instances.
    #
    #   * `request` - The EC2 Fleet places an asynchronous one-time request
    #     for your desired capacity, but does submit Spot requests in
    #     alternative capacity pools if Spot capacity is unavailable, and does
    #     not maintain Spot capacity if Spot Instances are interrupted.
    #
    #   * `instant` - The EC2 Fleet places a synchronous one-time request for
    #     your desired capacity, and returns errors for any instances that
    #     could not be launched.
    #
    #   For more information, see [EC2 Fleet request types][1] in the *Amazon
    #   EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-request-type.html
    #
    # @option params [Time,DateTime,Date,Integer,String] :valid_from
    #   The start date and time of the request, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z). The default is to start fulfilling
    #   the request immediately.
    #
    # @option params [Time,DateTime,Date,Integer,String] :valid_until
    #   The end date and time of the request, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z). At this point, no new EC2 Fleet
    #   requests are placed or able to fulfill the request. If no value is
    #   specified, the request remains until you cancel it.
    #
    # @option params [Boolean] :replace_unhealthy_instances
    #   Indicates whether EC2 Fleet should replace unhealthy Spot Instances.
    #   Supported only for fleets of type `maintain`. For more information,
    #   see [EC2 Fleet health checks][1] in the *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The key-value pair for tagging the EC2 Fleet request on creation. For
    #   more information, see [Tag your resources][1].
    #
    #   If the fleet type is `instant`, specify a resource type of `fleet` to
    #   tag the fleet or `instance` to tag the instances at launch.
    #
    #   If the fleet type is `maintain` or `request`, specify a resource type
    #   of `fleet` to tag the fleet. You cannot specify a resource type of
    #   `instance`. To tag instances at launch, specify the tags in a [launch
    #   template][2].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources
    #   [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template
    #
    # @option params [String] :context
    #   Reserved.
    #
    # @return [Types::CreateFleetResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateFleetResult#fleet_id #fleet_id} => String
    #   * {Types::CreateFleetResult#errors #errors} => Array&lt;Types::CreateFleetError&gt;
    #   * {Types::CreateFleetResult#instances #instances} => Array&lt;Types::CreateFleetInstance&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_fleet({
    #     dry_run: false,
    #     client_token: "String",
    #     spot_options: {
    #       allocation_strategy: "lowest-price", # accepts lowest-price, diversified, capacity-optimized, capacity-optimized-prioritized, price-capacity-optimized
    #       maintenance_strategies: {
    #         capacity_rebalance: {
    #           replacement_strategy: "launch", # accepts launch, launch-before-terminate
    #           termination_delay: 1,
    #         },
    #       },
    #       instance_interruption_behavior: "hibernate", # accepts hibernate, stop, terminate
    #       instance_pools_to_use_count: 1,
    #       single_instance_type: false,
    #       single_availability_zone: false,
    #       min_target_capacity: 1,
    #       max_total_price: "String",
    #     },
    #     on_demand_options: {
    #       allocation_strategy: "lowest-price", # accepts lowest-price, prioritized
    #       capacity_reservation_options: {
    #         usage_strategy: "use-capacity-reservations-first", # accepts use-capacity-reservations-first
    #       },
    #       single_instance_type: false,
    #       single_availability_zone: false,
    #       min_target_capacity: 1,
    #       max_total_price: "String",
    #     },
    #     excess_capacity_termination_policy: "no-termination", # accepts no-termination, termination
    #     launch_template_configs: [ # required
    #       {
    #         launch_template_specification: {
    #           launch_template_id: "LaunchTemplateId",
    #           launch_template_name: "LaunchTemplateName",
    #           version: "String",
    #         },
    #         overrides: [
    #           {
    #             instance_type: "a1.medium", # accepts a1.medium, a1.large, a1.xlarge, a1.2xlarge, a1.4xlarge, a1.metal, c1.medium, c1.xlarge, c3.large, c3.xlarge, c3.2xlarge, c3.4xlarge, c3.8xlarge, c4.large, c4.xlarge, c4.2xlarge, c4.4xlarge, c4.8xlarge, c5.large, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.12xlarge, c5.18xlarge, c5.24xlarge, c5.metal, c5a.large, c5a.xlarge, c5a.2xlarge, c5a.4xlarge, c5a.8xlarge, c5a.12xlarge, c5a.16xlarge, c5a.24xlarge, c5ad.large, c5ad.xlarge, c5ad.2xlarge, c5ad.4xlarge, c5ad.8xlarge, c5ad.12xlarge, c5ad.16xlarge, c5ad.24xlarge, c5d.large, c5d.xlarge, c5d.2xlarge, c5d.4xlarge, c5d.9xlarge, c5d.12xlarge, c5d.18xlarge, c5d.24xlarge, c5d.metal, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge, c5n.metal, c6g.medium, c6g.large, c6g.xlarge, c6g.2xlarge, c6g.4xlarge, c6g.8xlarge, c6g.12xlarge, c6g.16xlarge, c6g.metal, c6gd.medium, c6gd.large, c6gd.xlarge, c6gd.2xlarge, c6gd.4xlarge, c6gd.8xlarge, c6gd.12xlarge, c6gd.16xlarge, c6gd.metal, c6gn.medium, c6gn.large, c6gn.xlarge, c6gn.2xlarge, c6gn.4xlarge, c6gn.8xlarge, c6gn.12xlarge, c6gn.16xlarge, c6i.large, c6i.xlarge, c6i.2xlarge, c6i.4xlarge, c6i.8xlarge, c6i.12xlarge, c6i.16xlarge, c6i.24xlarge, c6i.32xlarge, c6i.metal, cc1.4xlarge, cc2.8xlarge, cg1.4xlarge, cr1.8xlarge, d2.xlarge, d2.2xlarge, d2.4xlarge, d2.8xlarge, d3.xlarge, d3.2xlarge, d3.4xlarge, d3.8xlarge, d3en.xlarge, d3en.2xlarge, d3en.4xlarge, d3en.6xlarge, d3en.8xlarge, d3en.12xlarge, dl1.24xlarge, f1.2xlarge, f1.4xlarge, f1.16xlarge, g2.2xlarge, g2.8xlarge, g3.4xlarge, g3.8xlarge, g3.16xlarge, g3s.xlarge, g4ad.xlarge, g4ad.2xlarge, g4ad.4xlarge, g4ad.8xlarge, g4ad.16xlarge, g4dn.xlarge, g4dn.2xlarge, g4dn.4xlarge, g4dn.8xlarge, g4dn.12xlarge, g4dn.16xlarge, g4dn.metal, g5.xlarge, g5.2xlarge, g5.4xlarge, g5.8xlarge, g5.12xlarge, g5.16xlarge, g5.24xlarge, g5.48xlarge, g5g.xlarge, g5g.2xlarge, g5g.4xlarge, g5g.8xlarge, g5g.16xlarge, g5g.metal, hi1.4xlarge, hpc6a.48xlarge, hs1.8xlarge, h1.2xlarge, h1.4xlarge, h1.8xlarge, h1.16xlarge, i2.xlarge, i2.2xlarge, i2.4xlarge, i2.8xlarge, i3.large, i3.xlarge, i3.2xlarge, i3.4xlarge, i3.8xlarge, i3.16xlarge, i3.metal, i3en.large, i3en.xlarge, i3en.2xlarge, i3en.3xlarge, i3en.6xlarge, i3en.12xlarge, i3en.24xlarge, i3en.metal, im4gn.large, im4gn.xlarge, im4gn.2xlarge, im4gn.4xlarge, im4gn.8xlarge, im4gn.16xlarge, inf1.xlarge, inf1.2xlarge, inf1.6xlarge, inf1.24xlarge, is4gen.medium, is4gen.large, is4gen.xlarge, is4gen.2xlarge, is4gen.4xlarge, is4gen.8xlarge, m1.small, m1.medium, m1.large, m1.xlarge, m2.xlarge, m2.2xlarge, m2.4xlarge, m3.medium, m3.large, m3.xlarge, m3.2xlarge, m4.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m4.10xlarge, m4.16xlarge, m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.8xlarge, m5.12xlarge, m5.16xlarge, m5.24xlarge, m5.metal, m5a.large, m5a.xlarge, m5a.2xlarge, m5a.4xlarge, m5a.8xlarge, m5a.12xlarge, m5a.16xlarge, m5a.24xlarge, m5ad.large, m5ad.xlarge, m5ad.2xlarge, m5ad.4xlarge, m5ad.8xlarge, m5ad.12xlarge, m5ad.16xlarge, m5ad.24xlarge, m5d.large, m5d.xlarge, m5d.2xlarge, m5d.4xlarge, m5d.8xlarge, m5d.12xlarge, m5d.16xlarge, m5d.24xlarge, m5d.metal, m5dn.large, m5dn.xlarge, m5dn.2xlarge, m5dn.4xlarge, m5dn.8xlarge, m5dn.12xlarge, m5dn.16xlarge, m5dn.24xlarge, m5dn.metal, m5n.large, m5n.xlarge, m5n.2xlarge, m5n.4xlarge, m5n.8xlarge, m5n.12xlarge, m5n.16xlarge, m5n.24xlarge, m5n.metal, m5zn.large, m5zn.xlarge, m5zn.2xlarge, m5zn.3xlarge, m5zn.6xlarge, m5zn.12xlarge, m5zn.metal, m6a.large, m6a.xlarge, m6a.2xlarge, m6a.4xlarge, m6a.8xlarge, m6a.12xlarge, m6a.16xlarge, m6a.24xlarge, m6a.32xlarge, m6a.48xlarge, m6g.metal, m6g.medium, m6g.large, m6g.xlarge, m6g.2xlarge, m6g.4xlarge, m6g.8xlarge, m6g.12xlarge, m6g.16xlarge, m6gd.metal, m6gd.medium, m6gd.large, m6gd.xlarge, m6gd.2xlarge, m6gd.4xlarge, m6gd.8xlarge, m6gd.12xlarge, m6gd.16xlarge, m6i.large, m6i.xlarge, m6i.2xlarge, m6i.4xlarge, m6i.8xlarge, m6i.12xlarge, m6i.16xlarge, m6i.24xlarge, m6i.32xlarge, m6i.metal, mac1.metal, p2.xlarge, p2.8xlarge, p2.16xlarge, p3.2xlarge, p3.8xlarge, p3.16xlarge, p3dn.24xlarge, p4d.24xlarge, r3.large, r3.xlarge, r3.2xlarge, r3.4xlarge, r3.8xlarge, r4.large, r4.xlarge, r4.2xlarge, r4.4xlarge, r4.8xlarge, r4.16xlarge, r5.large, r5.xlarge, r5.2xlarge, r5.4xlarge, r5.8xlarge, r5.12xlarge, r5.16xlarge, r5.24xlarge, r5.metal, r5a.large, r5a.xlarge, r5a.2xlarge, r5a.4xlarge, r5a.8xlarge, r5a.12xlarge, r5a.16xlarge, r5a.24xlarge, r5ad.large, r5ad.xlarge, r5ad.2xlarge, r5ad.4xlarge, r5ad.8xlarge, r5ad.12xlarge, r5ad.16xlarge, r5ad.24xlarge, r5b.large, r5b.xlarge, r5b.2xlarge, r5b.4xlarge, r5b.8xlarge, r5b.12xlarge, r5b.16xlarge, r5b.24xlarge, r5b.metal, r5d.large, r5d.xlarge, r5d.2xlarge, r5d.4xlarge, r5d.8xlarge, r5d.12xlarge, r5d.16xlarge, r5d.24xlarge, r5d.metal, r5dn.large, r5dn.xlarge, r5dn.2xlarge, r5dn.4xlarge, r5dn.8xlarge, r5dn.12xlarge, r5dn.16xlarge, r5dn.24xlarge, r5dn.metal, r5n.large, r5n.xlarge, r5n.2xlarge, r5n.4xlarge, r5n.8xlarge, r5n.12xlarge, r5n.16xlarge, r5n.24xlarge, r5n.metal, r6g.medium, r6g.large, r6g.xlarge, r6g.2xlarge, r6g.4xlarge, r6g.8xlarge, r6g.12xlarge, r6g.16xlarge, r6g.metal, r6gd.medium, r6gd.large, r6gd.xlarge, r6gd.2xlarge, r6gd.4xlarge, r6gd.8xlarge, r6gd.12xlarge, r6gd.16xlarge, r6gd.metal, r6i.large, r6i.xlarge, r6i.2xlarge, r6i.4xlarge, r6i.8xlarge, r6i.12xlarge, r6i.16xlarge, r6i.24xlarge, r6i.32xlarge, r6i.metal, t1.micro, t2.nano, t2.micro, t2.small, t2.medium, t2.large, t2.xlarge, t2.2xlarge, t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge, t3a.nano, t3a.micro, t3a.small, t3a.medium, t3a.large, t3a.xlarge, t3a.2xlarge, t4g.nano, t4g.micro, t4g.small, t4g.medium, t4g.large, t4g.xlarge, t4g.2xlarge, u-6tb1.56xlarge, u-6tb1.112xlarge, u-9tb1.112xlarge, u-12tb1.112xlarge, u-6tb1.metal, u-9tb1.metal, u-12tb1.metal, u-18tb1.metal, u-24tb1.metal, vt1.3xlarge, vt1.6xlarge, vt1.24xlarge, x1.16xlarge, x1.32xlarge, x1e.xlarge, x1e.2xlarge, x1e.4xlarge, x1e.8xlarge, x1e.16xlarge, x1e.32xlarge, x2iezn.2xlarge, x2iezn.4xlarge, x2iezn.6xlarge, x2iezn.8xlarge, x2iezn.12xlarge, x2iezn.metal, x2gd.medium, x2gd.large, x2gd.xlarge, x2gd.2xlarge, x2gd.4xlarge, x2gd.8xlarge, x2gd.12xlarge, x2gd.16xlarge, x2gd.metal, z1d.large, z1d.xlarge, z1d.2xlarge, z1d.3xlarge, z1d.6xlarge, z1d.12xlarge, z1d.metal, x2idn.16xlarge, x2idn.24xlarge, x2idn.32xlarge, x2iedn.xlarge, x2iedn.2xlarge, x2iedn.4xlarge, x2iedn.8xlarge, x2iedn.16xlarge, x2iedn.24xlarge, x2iedn.32xlarge, c6a.large, c6a.xlarge, c6a.2xlarge, c6a.4xlarge, c6a.8xlarge, c6a.12xlarge, c6a.16xlarge, c6a.24xlarge, c6a.32xlarge, c6a.48xlarge, c6a.metal, m6a.metal, i4i.large, i4i.xlarge, i4i.2xlarge, i4i.4xlarge, i4i.8xlarge, i4i.16xlarge, i4i.32xlarge, i4i.metal, x2idn.metal, x2iedn.metal, c7g.medium, c7g.large, c7g.xlarge, c7g.2xlarge, c7g.4xlarge, c7g.8xlarge, c7g.12xlarge, c7g.16xlarge, mac2.metal, c6id.large, c6id.xlarge, c6id.2xlarge, c6id.4xlarge, c6id.8xlarge, c6id.12xlarge, c6id.16xlarge, c6id.24xlarge, c6id.32xlarge, c6id.metal, m6id.large, m6id.xlarge, m6id.2xlarge, m6id.4xlarge, m6id.8xlarge, m6id.12xlarge, m6id.16xlarge, m6id.24xlarge, m6id.32xlarge, m6id.metal, r6id.large, r6id.xlarge, r6id.2xlarge, r6id.4xlarge, r6id.8xlarge, r6id.12xlarge, r6id.16xlarge, r6id.24xlarge, r6id.32xlarge, r6id.metal, r6a.large, r6a.xlarge, r6a.2xlarge, r6a.4xlarge, r6a.8xlarge, r6a.12xlarge, r6a.16xlarge, r6a.24xlarge, r6a.32xlarge, r6a.48xlarge, r6a.metal, p4de.24xlarge, u-3tb1.56xlarge, u-18tb1.112xlarge, u-24tb1.112xlarge, trn1.2xlarge, trn1.32xlarge, hpc6id.32xlarge, c6in.large, c6in.xlarge, c6in.2xlarge, c6in.4xlarge, c6in.8xlarge, c6in.12xlarge, c6in.16xlarge, c6in.24xlarge, c6in.32xlarge, m6in.large, m6in.xlarge, m6in.2xlarge, m6in.4xlarge, m6in.8xlarge, m6in.12xlarge, m6in.16xlarge, m6in.24xlarge, m6in.32xlarge, m6idn.large, m6idn.xlarge, m6idn.2xlarge, m6idn.4xlarge, m6idn.8xlarge, m6idn.12xlarge, m6idn.16xlarge, m6idn.24xlarge, m6idn.32xlarge, r6in.large, r6in.xlarge, r6in.2xlarge, r6in.4xlarge, r6in.8xlarge, r6in.12xlarge, r6in.16xlarge, r6in.24xlarge, r6in.32xlarge, r6idn.large, r6idn.xlarge, r6idn.2xlarge, r6idn.4xlarge, r6idn.8xlarge, r6idn.12xlarge, r6idn.16xlarge, r6idn.24xlarge, r6idn.32xlarge, c7g.metal, m7g.medium, m7g.large, m7g.xlarge, m7g.2xlarge, m7g.4xlarge, m7g.8xlarge, m7g.12xlarge, m7g.16xlarge, m7g.metal, r7g.medium, r7g.large, r7g.xlarge, r7g.2xlarge, r7g.4xlarge, r7g.8xlarge, r7g.12xlarge, r7g.16xlarge, r7g.metal, c6in.metal, m6in.metal, m6idn.metal, r6in.metal, r6idn.metal, inf2.xlarge, inf2.8xlarge, inf2.24xlarge, inf2.48xlarge, trn1n.32xlarge, i4g.large, i4g.xlarge, i4g.2xlarge, i4g.4xlarge, i4g.8xlarge, i4g.16xlarge, hpc7g.4xlarge, hpc7g.8xlarge, hpc7g.16xlarge, c7gn.medium, c7gn.large, c7gn.xlarge, c7gn.2xlarge, c7gn.4xlarge, c7gn.8xlarge, c7gn.12xlarge, c7gn.16xlarge, p5.48xlarge, m7i.large, m7i.xlarge, m7i.2xlarge, m7i.4xlarge, m7i.8xlarge, m7i.12xlarge, m7i.16xlarge, m7i.24xlarge, m7i.48xlarge, m7i-flex.large, m7i-flex.xlarge, m7i-flex.2xlarge, m7i-flex.4xlarge, m7i-flex.8xlarge, m7a.medium, m7a.large, m7a.xlarge, m7a.2xlarge, m7a.4xlarge, m7a.8xlarge, m7a.12xlarge, m7a.16xlarge, m7a.24xlarge, m7a.32xlarge, m7a.48xlarge, m7a.metal-48xl, hpc7a.12xlarge, hpc7a.24xlarge, hpc7a.48xlarge, hpc7a.96xlarge, c7gd.medium, c7gd.large, c7gd.xlarge, c7gd.2xlarge, c7gd.4xlarge, c7gd.8xlarge, c7gd.12xlarge, c7gd.16xlarge, m7gd.medium, m7gd.large, m7gd.xlarge, m7gd.2xlarge, m7gd.4xlarge, m7gd.8xlarge, m7gd.12xlarge, m7gd.16xlarge, r7gd.medium, r7gd.large, r7gd.xlarge, r7gd.2xlarge, r7gd.4xlarge, r7gd.8xlarge, r7gd.12xlarge, r7gd.16xlarge, r7a.medium, r7a.large, r7a.xlarge, r7a.2xlarge, r7a.4xlarge, r7a.8xlarge, r7a.12xlarge, r7a.16xlarge, r7a.24xlarge, r7a.32xlarge, r7a.48xlarge, c7i.large, c7i.xlarge, c7i.2xlarge, c7i.4xlarge, c7i.8xlarge, c7i.12xlarge, c7i.16xlarge, c7i.24xlarge, c7i.48xlarge, mac2-m2pro.metal, r7iz.large, r7iz.xlarge, r7iz.2xlarge, r7iz.4xlarge, r7iz.8xlarge, r7iz.12xlarge, r7iz.16xlarge, r7iz.32xlarge, c7a.medium, c7a.large, c7a.xlarge, c7a.2xlarge, c7a.4xlarge, c7a.8xlarge, c7a.12xlarge, c7a.16xlarge, c7a.24xlarge, c7a.32xlarge, c7a.48xlarge, c7a.metal-48xl, r7a.metal-48xl, r7i.large, r7i.xlarge, r7i.2xlarge, r7i.4xlarge, r7i.8xlarge, r7i.12xlarge, r7i.16xlarge, r7i.24xlarge, r7i.48xlarge, dl2q.24xlarge, mac2-m2.metal, i4i.12xlarge, i4i.24xlarge, c7i.metal-24xl, c7i.metal-48xl, m7i.metal-24xl, m7i.metal-48xl, r7i.metal-24xl, r7i.metal-48xl, r7iz.metal-16xl, r7iz.metal-32xl, c7gd.metal, m7gd.metal, r7gd.metal, g6.xlarge, g6.2xlarge, g6.4xlarge, g6.8xlarge, g6.12xlarge, g6.16xlarge, g6.24xlarge, g6.48xlarge, gr6.4xlarge, gr6.8xlarge, c7i-flex.large, c7i-flex.xlarge, c7i-flex.2xlarge, c7i-flex.4xlarge, c7i-flex.8xlarge, u7i-12tb.224xlarge, u7in-16tb.224xlarge, u7in-24tb.224xlarge, u7in-32tb.224xlarge, u7ib-12tb.224xlarge, c7gn.metal, r8g.medium, r8g.large, r8g.xlarge, r8g.2xlarge, r8g.4xlarge, r8g.8xlarge, r8g.12xlarge, r8g.16xlarge, r8g.24xlarge, r8g.48xlarge, r8g.metal-24xl, r8g.metal-48xl, mac2-m1ultra.metal, g6e.xlarge, g6e.2xlarge, g6e.4xlarge, g6e.8xlarge, g6e.12xlarge, g6e.16xlarge, g6e.24xlarge, g6e.48xlarge, c8g.medium, c8g.large, c8g.xlarge, c8g.2xlarge, c8g.4xlarge, c8g.8xlarge, c8g.12xlarge, c8g.16xlarge, c8g.24xlarge, c8g.48xlarge, c8g.metal-24xl, c8g.metal-48xl, m8g.medium, m8g.large, m8g.xlarge, m8g.2xlarge, m8g.4xlarge, m8g.8xlarge, m8g.12xlarge, m8g.16xlarge, m8g.24xlarge, m8g.48xlarge, m8g.metal-24xl, m8g.metal-48xl, x8g.medium, x8g.large, x8g.xlarge, x8g.2xlarge, x8g.4xlarge, x8g.8xlarge, x8g.12xlarge, x8g.16xlarge, x8g.24xlarge, x8g.48xlarge, x8g.metal-24xl, x8g.metal-48xl, i7ie.large, i7ie.xlarge, i7ie.2xlarge, i7ie.3xlarge, i7ie.6xlarge, i7ie.12xlarge, i7ie.18xlarge, i7ie.24xlarge, i7ie.48xlarge, i8g.large, i8g.xlarge, i8g.2xlarge, i8g.4xlarge, i8g.8xlarge, i8g.12xlarge, i8g.16xlarge, i8g.24xlarge, i8g.metal-24xl, u7i-6tb.112xlarge, u7i-8tb.112xlarge, u7inh-32tb.480xlarge, p5e.48xlarge, p5en.48xlarge, f2.12xlarge, f2.48xlarge, trn2.48xlarge, c7i-flex.12xlarge, c7i-flex.16xlarge, m7i-flex.12xlarge, m7i-flex.16xlarge, i7ie.metal-24xl, i7ie.metal-48xl, i8g.48xlarge, c8gd.medium, c8gd.large, c8gd.xlarge, c8gd.2xlarge, c8gd.4xlarge, c8gd.8xlarge, c8gd.12xlarge, c8gd.16xlarge, c8gd.24xlarge, c8gd.48xlarge, c8gd.metal-24xl, c8gd.metal-48xl, i7i.large, i7i.xlarge, i7i.2xlarge, i7i.4xlarge, i7i.8xlarge, i7i.12xlarge, i7i.16xlarge, i7i.24xlarge, i7i.48xlarge, i7i.metal-24xl, i7i.metal-48xl, p6-b200.48xlarge, m8gd.medium, m8gd.large, m8gd.xlarge, m8gd.2xlarge, m8gd.4xlarge, m8gd.8xlarge, m8gd.12xlarge, m8gd.16xlarge, m8gd.24xlarge, m8gd.48xlarge, m8gd.metal-24xl, m8gd.metal-48xl, r8gd.medium, r8gd.large, r8gd.xlarge, r8gd.2xlarge, r8gd.4xlarge, r8gd.8xlarge, r8gd.12xlarge, r8gd.16xlarge, r8gd.24xlarge, r8gd.48xlarge, r8gd.metal-24xl, r8gd.metal-48xl, c8gn.medium, c8gn.large, c8gn.xlarge, c8gn.2xlarge, c8gn.4xlarge, c8gn.8xlarge, c8gn.12xlarge, c8gn.16xlarge, c8gn.24xlarge, c8gn.48xlarge, c8gn.metal-24xl, c8gn.metal-48xl, f2.6xlarge, p6e-gb200.36xlarge
    #             max_price: "String",
    #             subnet_id: "SubnetId",
    #             availability_zone: "AvailabilityZoneName",
    #             weighted_capacity: 1.0,
    #             priority: 1.0,
    #             placement: {
    #               availability_zone_id: "AvailabilityZoneId",
    #               affinity: "String",
    #               group_name: "PlacementGroupName",
    #               partition_number: 1,
    #               host_id: "String",
    #               tenancy: "default", # accepts default, dedicated, host
    #               spread_domain: "String",
    #               host_resource_group_arn: "String",
    #               group_id: "PlacementGroupId",
    #               availability_zone: "String",
    #             },
    #             block_device_mappings: [
    #               {
    #                 device_name: "String",
    #                 virtual_name: "String",
    #                 ebs: {
    #                   encrypted: false,
    #                   delete_on_termination: false,
    #                   iops: 1,
    #                   throughput: 1,
    #                   kms_key_id: "KmsKeyId",
    #                   snapshot_id: "SnapshotId",
    #                   volume_size: 1,
    #                   volume_type: "standard", # accepts standard, io1, io2, gp2, sc1, st1, gp3
    #                 },
    #                 no_device: "String",
    #               },
    #             ],
    #             instance_requirements: {
    #               v_cpu_count: { # required
    #                 min: 1, # required
    #                 max: 1,
    #               },
    #               memory_mi_b: { # required
    #                 min: 1, # required
    #                 max: 1,
    #               },
    #               cpu_manufacturers: ["intel"], # accepts intel, amd, amazon-web-services, apple
    #               memory_gi_b_per_v_cpu: {
    #                 min: 1.0,
    #                 max: 1.0,
    #               },
    #               excluded_instance_types: ["ExcludedInstanceType"],
    #               instance_generations: ["current"], # accepts current, previous
    #               spot_max_price_percentage_over_lowest_price: 1,
    #               on_demand_max_price_percentage_over_lowest_price: 1,
    #               bare_metal: "included", # accepts included, required, excluded
    #               burstable_performance: "included", # accepts included, required, excluded
    #               require_hibernate_support: false,
    #               network_interface_count: {
    #                 min: 1,
    #                 max: 1,
    #               },
    #               local_storage: "included", # accepts included, required, excluded
    #               local_storage_types: ["hdd"], # accepts hdd, ssd
    #               total_local_storage_gb: {
    #                 min: 1.0,
    #                 max: 1.0,
    #               },
    #               baseline_ebs_bandwidth_mbps: {
    #                 min: 1,
    #                 max: 1,
    #               },
    #               accelerator_types: ["gpu"], # accepts gpu, fpga, inference
    #               accelerator_count: {
    #                 min: 1,
    #                 max: 1,
    #               },
    #               accelerator_manufacturers: ["amazon-web-services"], # accepts amazon-web-services, amd, nvidia, xilinx, habana
    #               accelerator_names: ["a100"], # accepts a100, inferentia, k520, k80, m60, radeon-pro-v520, t4, vu9p, v100, a10g, h100, t4g
    #               accelerator_total_memory_mi_b: {
    #                 min: 1,
    #                 max: 1,
    #               },
    #               network_bandwidth_gbps: {
    #                 min: 1.0,
    #                 max: 1.0,
    #               },
    #               allowed_instance_types: ["AllowedInstanceType"],
    #               max_spot_price_as_percentage_of_optimal_on_demand_price: 1,
    #               baseline_performance_factors: {
    #                 cpu: {
    #                   references: [
    #                     {
    #                       instance_family: "String",
    #                     },
    #                   ],
    #                 },
    #               },
    #             },
    #             image_id: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     target_capacity_specification: { # required
    #       total_target_capacity: 1, # required
    #       on_demand_target_capacity: 1,
    #       spot_target_capacity: 1,
    #       default_target_capacity_type: "spot", # accepts spot, on-demand, capacity-block
    #       target_capacity_unit_type: "vcpu", # accepts vcpu, memory-mib, units
    #     },
    #     terminate_instances_with_expiration: false,
    #     type: "request", # accepts request, maintain, instant
    #     valid_from: Time.now,
    #     valid_until: Time.now,
    #     replace_unhealthy_instances: false,
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     context: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.fleet_id #=> String
    #   resp.errors #=> Array
    #   resp.errors[0].launch_template_and_overrides.launch_template_specification.launch_template_id #=> String
    #   resp.errors[0].launch_template_and_overrides.launch_template_specification.launch_template_name #=> String
    #   resp.errors[0].launch_template_and_overrides.launch_template_specification.version #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_type #=> String, one of "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge", "a1.metal", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5a.large", "c5a.xlarge", "c5a.2xlarge", "c5a.4xlarge", "c5a.8xlarge", "c5a.12xlarge", "c5a.16xlarge", "c5a.24xlarge", "c5ad.large", "c5ad.xlarge", "c5ad.2xlarge", "c5ad.4xlarge", "c5ad.8xlarge", "c5ad.12xlarge", "c5ad.16xlarge", "c5ad.24xlarge", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.12xlarge", "c5d.18xlarge", "c5d.24xlarge", "c5d.metal", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "c5n.metal", "c6g.medium", "c6g.large", "c6g.xlarge", "c6g.2xlarge", "c6g.4xlarge", "c6g.8xlarge", "c6g.12xlarge", "c6g.16xlarge", "c6g.metal", "c6gd.medium", "c6gd.large", "c6gd.xlarge", "c6gd.2xlarge", "c6gd.4xlarge", "c6gd.8xlarge", "c6gd.12xlarge", "c6gd.16xlarge", "c6gd.metal", "c6gn.medium", "c6gn.large", "c6gn.xlarge", "c6gn.2xlarge", "c6gn.4xlarge", "c6gn.8xlarge", "c6gn.12xlarge", "c6gn.16xlarge", "c6i.large", "c6i.xlarge", "c6i.2xlarge", "c6i.4xlarge", "c6i.8xlarge", "c6i.12xlarge", "c6i.16xlarge", "c6i.24xlarge", "c6i.32xlarge", "c6i.metal", "cc1.4xlarge", "cc2.8xlarge", "cg1.4xlarge", "cr1.8xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "d3.xlarge", "d3.2xlarge", "d3.4xlarge", "d3.8xlarge", "d3en.xlarge", "d3en.2xlarge", "d3en.4xlarge", "d3en.6xlarge", "d3en.8xlarge", "d3en.12xlarge", "dl1.24xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "g4ad.xlarge", "g4ad.2xlarge", "g4ad.4xlarge", "g4ad.8xlarge", "g4ad.16xlarge", "g4dn.xlarge", "g4dn.2xlarge", "g4dn.4xlarge", "g4dn.8xlarge", "g4dn.12xlarge", "g4dn.16xlarge", "g4dn.metal", "g5.xlarge", "g5.2xlarge", "g5.4xlarge", "g5.8xlarge", "g5.12xlarge", "g5.16xlarge", "g5.24xlarge", "g5.48xlarge", "g5g.xlarge", "g5g.2xlarge", "g5g.4xlarge", "g5g.8xlarge", "g5g.16xlarge", "g5g.metal", "hi1.4xlarge", "hpc6a.48xlarge", "hs1.8xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "im4gn.large", "im4gn.xlarge", "im4gn.2xlarge", "im4gn.4xlarge", "im4gn.8xlarge", "im4gn.16xlarge", "inf1.xlarge", "inf1.2xlarge", "inf1.6xlarge", "inf1.24xlarge", "is4gen.medium", "is4gen.large", "is4gen.xlarge", "is4gen.2xlarge", "is4gen.4xlarge", "is4gen.8xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5dn.large", "m5dn.xlarge", "m5dn.2xlarge", "m5dn.4xlarge", "m5dn.8xlarge", "m5dn.12xlarge", "m5dn.16xlarge", "m5dn.24xlarge", "m5dn.metal", "m5n.large", "m5n.xlarge", "m5n.2xlarge", "m5n.4xlarge", "m5n.8xlarge", "m5n.12xlarge", "m5n.16xlarge", "m5n.24xlarge", "m5n.metal", "m5zn.large", "m5zn.xlarge", "m5zn.2xlarge", "m5zn.3xlarge", "m5zn.6xlarge", "m5zn.12xlarge", "m5zn.metal", "m6a.large", "m6a.xlarge", "m6a.2xlarge", "m6a.4xlarge", "m6a.8xlarge", "m6a.12xlarge", "m6a.16xlarge", "m6a.24xlarge", "m6a.32xlarge", "m6a.48xlarge", "m6g.metal", "m6g.medium", "m6g.large", "m6g.xlarge", "m6g.2xlarge", "m6g.4xlarge", "m6g.8xlarge", "m6g.12xlarge", "m6g.16xlarge", "m6gd.metal", "m6gd.medium", "m6gd.large", "m6gd.xlarge", "m6gd.2xlarge", "m6gd.4xlarge", "m6gd.8xlarge", "m6gd.12xlarge", "m6gd.16xlarge", "m6i.large", "m6i.xlarge", "m6i.2xlarge", "m6i.4xlarge", "m6i.8xlarge", "m6i.12xlarge", "m6i.16xlarge", "m6i.24xlarge", "m6i.32xlarge", "m6i.metal", "mac1.metal", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "p4d.24xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "r5b.large", "r5b.xlarge", "r5b.2xlarge", "r5b.4xlarge", "r5b.8xlarge", "r5b.12xlarge", "r5b.16xlarge", "r5b.24xlarge", "r5b.metal", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5dn.large", "r5dn.xlarge", "r5dn.2xlarge", "r5dn.4xlarge", "r5dn.8xlarge", "r5dn.12xlarge", "r5dn.16xlarge", "r5dn.24xlarge", "r5dn.metal", "r5n.large", "r5n.xlarge", "r5n.2xlarge", "r5n.4xlarge", "r5n.8xlarge", "r5n.12xlarge", "r5n.16xlarge", "r5n.24xlarge", "r5n.metal", "r6g.medium", "r6g.large", "r6g.xlarge", "r6g.2xlarge", "r6g.4xlarge", "r6g.8xlarge", "r6g.12xlarge", "r6g.16xlarge", "r6g.metal", "r6gd.medium", "r6gd.large", "r6gd.xlarge", "r6gd.2xlarge", "r6gd.4xlarge", "r6gd.8xlarge", "r6gd.12xlarge", "r6gd.16xlarge", "r6gd.metal", "r6i.large", "r6i.xlarge", "r6i.2xlarge", "r6i.4xlarge", "r6i.8xlarge", "r6i.12xlarge", "r6i.16xlarge", "r6i.24xlarge", "r6i.32xlarge", "r6i.metal", "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "t4g.nano", "t4g.micro", "t4g.small", "t4g.medium", "t4g.large", "t4g.xlarge", "t4g.2xlarge", "u-6tb1.56xlarge", "u-6tb1.112xlarge", "u-9tb1.112xlarge", "u-12tb1.112xlarge", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "u-18tb1.metal", "u-24tb1.metal", "vt1.3xlarge", "vt1.6xlarge", "vt1.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "x2iezn.2xlarge", "x2iezn.4xlarge", "x2iezn.6xlarge", "x2iezn.8xlarge", "x2iezn.12xlarge", "x2iezn.metal", "x2gd.medium", "x2gd.large", "x2gd.xlarge", "x2gd.2xlarge", "x2gd.4xlarge", "x2gd.8xlarge", "x2gd.12xlarge", "x2gd.16xlarge", "x2gd.metal", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "x2idn.16xlarge", "x2idn.24xlarge", "x2idn.32xlarge", "x2iedn.xlarge", "x2iedn.2xlarge", "x2iedn.4xlarge", "x2iedn.8xlarge", "x2iedn.16xlarge", "x2iedn.24xlarge", "x2iedn.32xlarge", "c6a.large", "c6a.xlarge", "c6a.2xlarge", "c6a.4xlarge", "c6a.8xlarge", "c6a.12xlarge", "c6a.16xlarge", "c6a.24xlarge", "c6a.32xlarge", "c6a.48xlarge", "c6a.metal", "m6a.metal", "i4i.large", "i4i.xlarge", "i4i.2xlarge", "i4i.4xlarge", "i4i.8xlarge", "i4i.16xlarge", "i4i.32xlarge", "i4i.metal", "x2idn.metal", "x2iedn.metal", "c7g.medium", "c7g.large", "c7g.xlarge", "c7g.2xlarge", "c7g.4xlarge", "c7g.8xlarge", "c7g.12xlarge", "c7g.16xlarge", "mac2.metal", "c6id.large", "c6id.xlarge", "c6id.2xlarge", "c6id.4xlarge", "c6id.8xlarge", "c6id.12xlarge", "c6id.16xlarge", "c6id.24xlarge", "c6id.32xlarge", "c6id.metal", "m6id.large", "m6id.xlarge", "m6id.2xlarge", "m6id.4xlarge", "m6id.8xlarge", "m6id.12xlarge", "m6id.16xlarge", "m6id.24xlarge", "m6id.32xlarge", "m6id.metal", "r6id.large", "r6id.xlarge", "r6id.2xlarge", "r6id.4xlarge", "r6id.8xlarge", "r6id.12xlarge", "r6id.16xlarge", "r6id.24xlarge", "r6id.32xlarge", "r6id.metal", "r6a.large", "r6a.xlarge", "r6a.2xlarge", "r6a.4xlarge", "r6a.8xlarge", "r6a.12xlarge", "r6a.16xlarge", "r6a.24xlarge", "r6a.32xlarge", "r6a.48xlarge", "r6a.metal", "p4de.24xlarge", "u-3tb1.56xlarge", "u-18tb1.112xlarge", "u-24tb1.112xlarge", "trn1.2xlarge", "trn1.32xlarge", "hpc6id.32xlarge", "c6in.large", "c6in.xlarge", "c6in.2xlarge", "c6in.4xlarge", "c6in.8xlarge", "c6in.12xlarge", "c6in.16xlarge", "c6in.24xlarge", "c6in.32xlarge", "m6in.large", "m6in.xlarge", "m6in.2xlarge", "m6in.4xlarge", "m6in.8xlarge", "m6in.12xlarge", "m6in.16xlarge", "m6in.24xlarge", "m6in.32xlarge", "m6idn.large", "m6idn.xlarge", "m6idn.2xlarge", "m6idn.4xlarge", "m6idn.8xlarge", "m6idn.12xlarge", "m6idn.16xlarge", "m6idn.24xlarge", "m6idn.32xlarge", "r6in.large", "r6in.xlarge", "r6in.2xlarge", "r6in.4xlarge", "r6in.8xlarge", "r6in.12xlarge", "r6in.16xlarge", "r6in.24xlarge", "r6in.32xlarge", "r6idn.large", "r6idn.xlarge", "r6idn.2xlarge", "r6idn.4xlarge", "r6idn.8xlarge", "r6idn.12xlarge", "r6idn.16xlarge", "r6idn.24xlarge", "r6idn.32xlarge", "c7g.metal", "m7g.medium", "m7g.large", "m7g.xlarge", "m7g.2xlarge", "m7g.4xlarge", "m7g.8xlarge", "m7g.12xlarge", "m7g.16xlarge", "m7g.metal", "r7g.medium", "r7g.large", "r7g.xlarge", "r7g.2xlarge", "r7g.4xlarge", "r7g.8xlarge", "r7g.12xlarge", "r7g.16xlarge", "r7g.metal", "c6in.metal", "m6in.metal", "m6idn.metal", "r6in.metal", "r6idn.metal", "inf2.xlarge", "inf2.8xlarge", "inf2.24xlarge", "inf2.48xlarge", "trn1n.32xlarge", "i4g.large", "i4g.xlarge", "i4g.2xlarge", "i4g.4xlarge", "i4g.8xlarge", "i4g.16xlarge", "hpc7g.4xlarge", "hpc7g.8xlarge", "hpc7g.16xlarge", "c7gn.medium", "c7gn.large", "c7gn.xlarge", "c7gn.2xlarge", "c7gn.4xlarge", "c7gn.8xlarge", "c7gn.12xlarge", "c7gn.16xlarge", "p5.48xlarge", "m7i.large", "m7i.xlarge", "m7i.2xlarge", "m7i.4xlarge", "m7i.8xlarge", "m7i.12xlarge", "m7i.16xlarge", "m7i.24xlarge", "m7i.48xlarge", "m7i-flex.large", "m7i-flex.xlarge", "m7i-flex.2xlarge", "m7i-flex.4xlarge", "m7i-flex.8xlarge", "m7a.medium", "m7a.large", "m7a.xlarge", "m7a.2xlarge", "m7a.4xlarge", "m7a.8xlarge", "m7a.12xlarge", "m7a.16xlarge", "m7a.24xlarge", "m7a.32xlarge", "m7a.48xlarge", "m7a.metal-48xl", "hpc7a.12xlarge", "hpc7a.24xlarge", "hpc7a.48xlarge", "hpc7a.96xlarge", "c7gd.medium", "c7gd.large", "c7gd.xlarge", "c7gd.2xlarge", "c7gd.4xlarge", "c7gd.8xlarge", "c7gd.12xlarge", "c7gd.16xlarge", "m7gd.medium", "m7gd.large", "m7gd.xlarge", "m7gd.2xlarge", "m7gd.4xlarge", "m7gd.8xlarge", "m7gd.12xlarge", "m7gd.16xlarge", "r7gd.medium", "r7gd.large", "r7gd.xlarge", "r7gd.2xlarge", "r7gd.4xlarge", "r7gd.8xlarge", "r7gd.12xlarge", "r7gd.16xlarge", "r7a.medium", "r7a.large", "r7a.xlarge", "r7a.2xlarge", "r7a.4xlarge", "r7a.8xlarge", "r7a.12xlarge", "r7a.16xlarge", "r7a.24xlarge", "r7a.32xlarge", "r7a.48xlarge", "c7i.large", "c7i.xlarge", "c7i.2xlarge", "c7i.4xlarge", "c7i.8xlarge", "c7i.12xlarge", "c7i.16xlarge", "c7i.24xlarge", "c7i.48xlarge", "mac2-m2pro.metal", "r7iz.large", "r7iz.xlarge", "r7iz.2xlarge", "r7iz.4xlarge", "r7iz.8xlarge", "r7iz.12xlarge", "r7iz.16xlarge", "r7iz.32xlarge", "c7a.medium", "c7a.large", "c7a.xlarge", "c7a.2xlarge", "c7a.4xlarge", "c7a.8xlarge", "c7a.12xlarge", "c7a.16xlarge", "c7a.24xlarge", "c7a.32xlarge", "c7a.48xlarge", "c7a.metal-48xl", "r7a.metal-48xl", "r7i.large", "r7i.xlarge", "r7i.2xlarge", "r7i.4xlarge", "r7i.8xlarge", "r7i.12xlarge", "r7i.16xlarge", "r7i.24xlarge", "r7i.48xlarge", "dl2q.24xlarge", "mac2-m2.metal", "i4i.12xlarge", "i4i.24xlarge", "c7i.metal-24xl", "c7i.metal-48xl", "m7i.metal-24xl", "m7i.metal-48xl", "r7i.metal-24xl", "r7i.metal-48xl", "r7iz.metal-16xl", "r7iz.metal-32xl", "c7gd.metal", "m7gd.metal", "r7gd.metal", "g6.xlarge", "g6.2xlarge", "g6.4xlarge", "g6.8xlarge", "g6.12xlarge", "g6.16xlarge", "g6.24xlarge", "g6.48xlarge", "gr6.4xlarge", "gr6.8xlarge", "c7i-flex.large", "c7i-flex.xlarge", "c7i-flex.2xlarge", "c7i-flex.4xlarge", "c7i-flex.8xlarge", "u7i-12tb.224xlarge", "u7in-16tb.224xlarge", "u7in-24tb.224xlarge", "u7in-32tb.224xlarge", "u7ib-12tb.224xlarge", "c7gn.metal", "r8g.medium", "r8g.large", "r8g.xlarge", "r8g.2xlarge", "r8g.4xlarge", "r8g.8xlarge", "r8g.12xlarge", "r8g.16xlarge", "r8g.24xlarge", "r8g.48xlarge", "r8g.metal-24xl", "r8g.metal-48xl", "mac2-m1ultra.metal", "g6e.xlarge", "g6e.2xlarge", "g6e.4xlarge", "g6e.8xlarge", "g6e.12xlarge", "g6e.16xlarge", "g6e.24xlarge", "g6e.48xlarge", "c8g.medium", "c8g.large", "c8g.xlarge", "c8g.2xlarge", "c8g.4xlarge", "c8g.8xlarge", "c8g.12xlarge", "c8g.16xlarge", "c8g.24xlarge", "c8g.48xlarge", "c8g.metal-24xl", "c8g.metal-48xl", "m8g.medium", "m8g.large", "m8g.xlarge", "m8g.2xlarge", "m8g.4xlarge", "m8g.8xlarge", "m8g.12xlarge", "m8g.16xlarge", "m8g.24xlarge", "m8g.48xlarge", "m8g.metal-24xl", "m8g.metal-48xl", "x8g.medium", "x8g.large", "x8g.xlarge", "x8g.2xlarge", "x8g.4xlarge", "x8g.8xlarge", "x8g.12xlarge", "x8g.16xlarge", "x8g.24xlarge", "x8g.48xlarge", "x8g.metal-24xl", "x8g.metal-48xl", "i7ie.large", "i7ie.xlarge", "i7ie.2xlarge", "i7ie.3xlarge", "i7ie.6xlarge", "i7ie.12xlarge", "i7ie.18xlarge", "i7ie.24xlarge", "i7ie.48xlarge", "i8g.large", "i8g.xlarge", "i8g.2xlarge", "i8g.4xlarge", "i8g.8xlarge", "i8g.12xlarge", "i8g.16xlarge", "i8g.24xlarge", "i8g.metal-24xl", "u7i-6tb.112xlarge", "u7i-8tb.112xlarge", "u7inh-32tb.480xlarge", "p5e.48xlarge", "p5en.48xlarge", "f2.12xlarge", "f2.48xlarge", "trn2.48xlarge", "c7i-flex.12xlarge", "c7i-flex.16xlarge", "m7i-flex.12xlarge", "m7i-flex.16xlarge", "i7ie.metal-24xl", "i7ie.metal-48xl", "i8g.48xlarge", "c8gd.medium", "c8gd.large", "c8gd.xlarge", "c8gd.2xlarge", "c8gd.4xlarge", "c8gd.8xlarge", "c8gd.12xlarge", "c8gd.16xlarge", "c8gd.24xlarge", "c8gd.48xlarge", "c8gd.metal-24xl", "c8gd.metal-48xl", "i7i.large", "i7i.xlarge", "i7i.2xlarge", "i7i.4xlarge", "i7i.8xlarge", "i7i.12xlarge", "i7i.16xlarge", "i7i.24xlarge", "i7i.48xlarge", "i7i.metal-24xl", "i7i.metal-48xl", "p6-b200.48xlarge", "m8gd.medium", "m8gd.large", "m8gd.xlarge", "m8gd.2xlarge", "m8gd.4xlarge", "m8gd.8xlarge", "m8gd.12xlarge", "m8gd.16xlarge", "m8gd.24xlarge", "m8gd.48xlarge", "m8gd.metal-24xl", "m8gd.metal-48xl", "r8gd.medium", "r8gd.large", "r8gd.xlarge", "r8gd.2xlarge", "r8gd.4xlarge", "r8gd.8xlarge", "r8gd.12xlarge", "r8gd.16xlarge", "r8gd.24xlarge", "r8gd.48xlarge", "r8gd.metal-24xl", "r8gd.metal-48xl", "c8gn.medium", "c8gn.large", "c8gn.xlarge", "c8gn.2xlarge", "c8gn.4xlarge", "c8gn.8xlarge", "c8gn.12xlarge", "c8gn.16xlarge", "c8gn.24xlarge", "c8gn.48xlarge", "c8gn.metal-24xl", "c8gn.metal-48xl", "f2.6xlarge", "p6e-gb200.36xlarge"
    #   resp.errors[0].launch_template_and_overrides.overrides.max_price #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.subnet_id #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.availability_zone #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.weighted_capacity #=> Float
    #   resp.errors[0].launch_template_and_overrides.overrides.priority #=> Float
    #   resp.errors[0].launch_template_and_overrides.overrides.placement.group_name #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.v_cpu_count.min #=> Integer
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.v_cpu_count.max #=> Integer
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.memory_mi_b.min #=> Integer
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.memory_mi_b.max #=> Integer
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.cpu_manufacturers #=> Array
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.cpu_manufacturers[0] #=> String, one of "intel", "amd", "amazon-web-services", "apple"
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.memory_gi_b_per_v_cpu.min #=> Float
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.memory_gi_b_per_v_cpu.max #=> Float
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.excluded_instance_types #=> Array
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.excluded_instance_types[0] #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.instance_generations #=> Array
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.instance_generations[0] #=> String, one of "current", "previous"
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.spot_max_price_percentage_over_lowest_price #=> Integer
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.on_demand_max_price_percentage_over_lowest_price #=> Integer
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.bare_metal #=> String, one of "included", "required", "excluded"
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.burstable_performance #=> String, one of "included", "required", "excluded"
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.require_hibernate_support #=> Boolean
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.network_interface_count.min #=> Integer
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.network_interface_count.max #=> Integer
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.local_storage #=> String, one of "included", "required", "excluded"
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.local_storage_types #=> Array
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.local_storage_types[0] #=> String, one of "hdd", "ssd"
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.total_local_storage_gb.min #=> Float
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.total_local_storage_gb.max #=> Float
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.baseline_ebs_bandwidth_mbps.min #=> Integer
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.baseline_ebs_bandwidth_mbps.max #=> Integer
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.accelerator_types #=> Array
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.accelerator_types[0] #=> String, one of "gpu", "fpga", "inference"
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.accelerator_count.min #=> Integer
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.accelerator_count.max #=> Integer
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.accelerator_manufacturers #=> Array
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.accelerator_manufacturers[0] #=> String, one of "amazon-web-services", "amd", "nvidia", "xilinx", "habana"
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.accelerator_names #=> Array
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.accelerator_names[0] #=> String, one of "a100", "inferentia", "k520", "k80", "m60", "radeon-pro-v520", "t4", "vu9p", "v100", "a10g", "h100", "t4g"
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.accelerator_total_memory_mi_b.min #=> Integer
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.accelerator_total_memory_mi_b.max #=> Integer
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.network_bandwidth_gbps.min #=> Float
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.network_bandwidth_gbps.max #=> Float
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.allowed_instance_types #=> Array
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.allowed_instance_types[0] #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.max_spot_price_as_percentage_of_optimal_on_demand_price #=> Integer
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.baseline_performance_factors.cpu.references #=> Array
    #   resp.errors[0].launch_template_and_overrides.overrides.instance_requirements.baseline_performance_factors.cpu.references[0].instance_family #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.image_id #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.block_device_mappings #=> Array
    #   resp.errors[0].launch_template_and_overrides.overrides.block_device_mappings[0].device_name #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.block_device_mappings[0].virtual_name #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.block_device_mappings[0].ebs.encrypted #=> Boolean
    #   resp.errors[0].launch_template_and_overrides.overrides.block_device_mappings[0].ebs.delete_on_termination #=> Boolean
    #   resp.errors[0].launch_template_and_overrides.overrides.block_device_mappings[0].ebs.iops #=> Integer
    #   resp.errors[0].launch_template_and_overrides.overrides.block_device_mappings[0].ebs.throughput #=> Integer
    #   resp.errors[0].launch_template_and_overrides.overrides.block_device_mappings[0].ebs.kms_key_id #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.block_device_mappings[0].ebs.snapshot_id #=> String
    #   resp.errors[0].launch_template_and_overrides.overrides.block_device_mappings[0].ebs.volume_size #=> Integer
    #   resp.errors[0].launch_template_and_overrides.overrides.block_device_mappings[0].ebs.volume_type #=> String, one of "standard", "io1", "io2", "gp2", "sc1", "st1", "gp3"
    #   resp.errors[0].launch_template_and_overrides.overrides.block_device_mappings[0].no_device #=> String
    #   resp.errors[0].lifecycle #=> String, one of "spot", "on-demand"
    #   resp.errors[0].error_code #=> String
    #   resp.errors[0].error_message #=> String
    #   resp.instances #=> Array
    #   resp.instances[0].launch_template_and_overrides.launch_template_specification.launch_template_id #=> String
    #   resp.instances[0].launch_template_and_overrides.launch_template_specification.launch_template_name #=> String
    #   resp.instances[0].launch_template_and_overrides.launch_template_specification.version #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_type #=> String, one of "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge", "a1.metal", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5a.large", "c5a.xlarge", "c5a.2xlarge", "c5a.4xlarge", "c5a.8xlarge", "c5a.12xlarge", "c5a.16xlarge", "c5a.24xlarge", "c5ad.large", "c5ad.xlarge", "c5ad.2xlarge", "c5ad.4xlarge", "c5ad.8xlarge", "c5ad.12xlarge", "c5ad.16xlarge", "c5ad.24xlarge", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.12xlarge", "c5d.18xlarge", "c5d.24xlarge", "c5d.metal", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "c5n.metal", "c6g.medium", "c6g.large", "c6g.xlarge", "c6g.2xlarge", "c6g.4xlarge", "c6g.8xlarge", "c6g.12xlarge", "c6g.16xlarge", "c6g.metal", "c6gd.medium", "c6gd.large", "c6gd.xlarge", "c6gd.2xlarge", "c6gd.4xlarge", "c6gd.8xlarge", "c6gd.12xlarge", "c6gd.16xlarge", "c6gd.metal", "c6gn.medium", "c6gn.large", "c6gn.xlarge", "c6gn.2xlarge", "c6gn.4xlarge", "c6gn.8xlarge", "c6gn.12xlarge", "c6gn.16xlarge", "c6i.large", "c6i.xlarge", "c6i.2xlarge", "c6i.4xlarge", "c6i.8xlarge", "c6i.12xlarge", "c6i.16xlarge", "c6i.24xlarge", "c6i.32xlarge", "c6i.metal", "cc1.4xlarge", "cc2.8xlarge", "cg1.4xlarge", "cr1.8xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "d3.xlarge", "d3.2xlarge", "d3.4xlarge", "d3.8xlarge", "d3en.xlarge", "d3en.2xlarge", "d3en.4xlarge", "d3en.6xlarge", "d3en.8xlarge", "d3en.12xlarge", "dl1.24xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "g4ad.xlarge", "g4ad.2xlarge", "g4ad.4xlarge", "g4ad.8xlarge", "g4ad.16xlarge", "g4dn.xlarge", "g4dn.2xlarge", "g4dn.4xlarge", "g4dn.8xlarge", "g4dn.12xlarge", "g4dn.16xlarge", "g4dn.metal", "g5.xlarge", "g5.2xlarge", "g5.4xlarge", "g5.8xlarge", "g5.12xlarge", "g5.16xlarge", "g5.24xlarge", "g5.48xlarge", "g5g.xlarge", "g5g.2xlarge", "g5g.4xlarge", "g5g.8xlarge", "g5g.16xlarge", "g5g.metal", "hi1.4xlarge", "hpc6a.48xlarge", "hs1.8xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "im4gn.large", "im4gn.xlarge", "im4gn.2xlarge", "im4gn.4xlarge", "im4gn.8xlarge", "im4gn.16xlarge", "inf1.xlarge", "inf1.2xlarge", "inf1.6xlarge", "inf1.24xlarge", "is4gen.medium", "is4gen.large", "is4gen.xlarge", "is4gen.2xlarge", "is4gen.4xlarge", "is4gen.8xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5dn.large", "m5dn.xlarge", "m5dn.2xlarge", "m5dn.4xlarge", "m5dn.8xlarge", "m5dn.12xlarge", "m5dn.16xlarge", "m5dn.24xlarge", "m5dn.metal", "m5n.large", "m5n.xlarge", "m5n.2xlarge", "m5n.4xlarge", "m5n.8xlarge", "m5n.12xlarge", "m5n.16xlarge", "m5n.24xlarge", "m5n.metal", "m5zn.large", "m5zn.xlarge", "m5zn.2xlarge", "m5zn.3xlarge", "m5zn.6xlarge", "m5zn.12xlarge", "m5zn.metal", "m6a.large", "m6a.xlarge", "m6a.2xlarge", "m6a.4xlarge", "m6a.8xlarge", "m6a.12xlarge", "m6a.16xlarge", "m6a.24xlarge", "m6a.32xlarge", "m6a.48xlarge", "m6g.metal", "m6g.medium", "m6g.large", "m6g.xlarge", "m6g.2xlarge", "m6g.4xlarge", "m6g.8xlarge", "m6g.12xlarge", "m6g.16xlarge", "m6gd.metal", "m6gd.medium", "m6gd.large", "m6gd.xlarge", "m6gd.2xlarge", "m6gd.4xlarge", "m6gd.8xlarge", "m6gd.12xlarge", "m6gd.16xlarge", "m6i.large", "m6i.xlarge", "m6i.2xlarge", "m6i.4xlarge", "m6i.8xlarge", "m6i.12xlarge", "m6i.16xlarge", "m6i.24xlarge", "m6i.32xlarge", "m6i.metal", "mac1.metal", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "p4d.24xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "r5b.large", "r5b.xlarge", "r5b.2xlarge", "r5b.4xlarge", "r5b.8xlarge", "r5b.12xlarge", "r5b.16xlarge", "r5b.24xlarge", "r5b.metal", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5dn.large", "r5dn.xlarge", "r5dn.2xlarge", "r5dn.4xlarge", "r5dn.8xlarge", "r5dn.12xlarge", "r5dn.16xlarge", "r5dn.24xlarge", "r5dn.metal", "r5n.large", "r5n.xlarge", "r5n.2xlarge", "r5n.4xlarge", "r5n.8xlarge", "r5n.12xlarge", "r5n.16xlarge", "r5n.24xlarge", "r5n.metal", "r6g.medium", "r6g.large", "r6g.xlarge", "r6g.2xlarge", "r6g.4xlarge", "r6g.8xlarge", "r6g.12xlarge", "r6g.16xlarge", "r6g.metal", "r6gd.medium", "r6gd.large", "r6gd.xlarge", "r6gd.2xlarge", "r6gd.4xlarge", "r6gd.8xlarge", "r6gd.12xlarge", "r6gd.16xlarge", "r6gd.metal", "r6i.large", "r6i.xlarge", "r6i.2xlarge", "r6i.4xlarge", "r6i.8xlarge", "r6i.12xlarge", "r6i.16xlarge", "r6i.24xlarge", "r6i.32xlarge", "r6i.metal", "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "t4g.nano", "t4g.micro", "t4g.small", "t4g.medium", "t4g.large", "t4g.xlarge", "t4g.2xlarge", "u-6tb1.56xlarge", "u-6tb1.112xlarge", "u-9tb1.112xlarge", "u-12tb1.112xlarge", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "u-18tb1.metal", "u-24tb1.metal", "vt1.3xlarge", "vt1.6xlarge", "vt1.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "x2iezn.2xlarge", "x2iezn.4xlarge", "x2iezn.6xlarge", "x2iezn.8xlarge", "x2iezn.12xlarge", "x2iezn.metal", "x2gd.medium", "x2gd.large", "x2gd.xlarge", "x2gd.2xlarge", "x2gd.4xlarge", "x2gd.8xlarge", "x2gd.12xlarge", "x2gd.16xlarge", "x2gd.metal", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "x2idn.16xlarge", "x2idn.24xlarge", "x2idn.32xlarge", "x2iedn.xlarge", "x2iedn.2xlarge", "x2iedn.4xlarge", "x2iedn.8xlarge", "x2iedn.16xlarge", "x2iedn.24xlarge", "x2iedn.32xlarge", "c6a.large", "c6a.xlarge", "c6a.2xlarge", "c6a.4xlarge", "c6a.8xlarge", "c6a.12xlarge", "c6a.16xlarge", "c6a.24xlarge", "c6a.32xlarge", "c6a.48xlarge", "c6a.metal", "m6a.metal", "i4i.large", "i4i.xlarge", "i4i.2xlarge", "i4i.4xlarge", "i4i.8xlarge", "i4i.16xlarge", "i4i.32xlarge", "i4i.metal", "x2idn.metal", "x2iedn.metal", "c7g.medium", "c7g.large", "c7g.xlarge", "c7g.2xlarge", "c7g.4xlarge", "c7g.8xlarge", "c7g.12xlarge", "c7g.16xlarge", "mac2.metal", "c6id.large", "c6id.xlarge", "c6id.2xlarge", "c6id.4xlarge", "c6id.8xlarge", "c6id.12xlarge", "c6id.16xlarge", "c6id.24xlarge", "c6id.32xlarge", "c6id.metal", "m6id.large", "m6id.xlarge", "m6id.2xlarge", "m6id.4xlarge", "m6id.8xlarge", "m6id.12xlarge", "m6id.16xlarge", "m6id.24xlarge", "m6id.32xlarge", "m6id.metal", "r6id.large", "r6id.xlarge", "r6id.2xlarge", "r6id.4xlarge", "r6id.8xlarge", "r6id.12xlarge", "r6id.16xlarge", "r6id.24xlarge", "r6id.32xlarge", "r6id.metal", "r6a.large", "r6a.xlarge", "r6a.2xlarge", "r6a.4xlarge", "r6a.8xlarge", "r6a.12xlarge", "r6a.16xlarge", "r6a.24xlarge", "r6a.32xlarge", "r6a.48xlarge", "r6a.metal", "p4de.24xlarge", "u-3tb1.56xlarge", "u-18tb1.112xlarge", "u-24tb1.112xlarge", "trn1.2xlarge", "trn1.32xlarge", "hpc6id.32xlarge", "c6in.large", "c6in.xlarge", "c6in.2xlarge", "c6in.4xlarge", "c6in.8xlarge", "c6in.12xlarge", "c6in.16xlarge", "c6in.24xlarge", "c6in.32xlarge", "m6in.large", "m6in.xlarge", "m6in.2xlarge", "m6in.4xlarge", "m6in.8xlarge", "m6in.12xlarge", "m6in.16xlarge", "m6in.24xlarge", "m6in.32xlarge", "m6idn.large", "m6idn.xlarge", "m6idn.2xlarge", "m6idn.4xlarge", "m6idn.8xlarge", "m6idn.12xlarge", "m6idn.16xlarge", "m6idn.24xlarge", "m6idn.32xlarge", "r6in.large", "r6in.xlarge", "r6in.2xlarge", "r6in.4xlarge", "r6in.8xlarge", "r6in.12xlarge", "r6in.16xlarge", "r6in.24xlarge", "r6in.32xlarge", "r6idn.large", "r6idn.xlarge", "r6idn.2xlarge", "r6idn.4xlarge", "r6idn.8xlarge", "r6idn.12xlarge", "r6idn.16xlarge", "r6idn.24xlarge", "r6idn.32xlarge", "c7g.metal", "m7g.medium", "m7g.large", "m7g.xlarge", "m7g.2xlarge", "m7g.4xlarge", "m7g.8xlarge", "m7g.12xlarge", "m7g.16xlarge", "m7g.metal", "r7g.medium", "r7g.large", "r7g.xlarge", "r7g.2xlarge", "r7g.4xlarge", "r7g.8xlarge", "r7g.12xlarge", "r7g.16xlarge", "r7g.metal", "c6in.metal", "m6in.metal", "m6idn.metal", "r6in.metal", "r6idn.metal", "inf2.xlarge", "inf2.8xlarge", "inf2.24xlarge", "inf2.48xlarge", "trn1n.32xlarge", "i4g.large", "i4g.xlarge", "i4g.2xlarge", "i4g.4xlarge", "i4g.8xlarge", "i4g.16xlarge", "hpc7g.4xlarge", "hpc7g.8xlarge", "hpc7g.16xlarge", "c7gn.medium", "c7gn.large", "c7gn.xlarge", "c7gn.2xlarge", "c7gn.4xlarge", "c7gn.8xlarge", "c7gn.12xlarge", "c7gn.16xlarge", "p5.48xlarge", "m7i.large", "m7i.xlarge", "m7i.2xlarge", "m7i.4xlarge", "m7i.8xlarge", "m7i.12xlarge", "m7i.16xlarge", "m7i.24xlarge", "m7i.48xlarge", "m7i-flex.large", "m7i-flex.xlarge", "m7i-flex.2xlarge", "m7i-flex.4xlarge", "m7i-flex.8xlarge", "m7a.medium", "m7a.large", "m7a.xlarge", "m7a.2xlarge", "m7a.4xlarge", "m7a.8xlarge", "m7a.12xlarge", "m7a.16xlarge", "m7a.24xlarge", "m7a.32xlarge", "m7a.48xlarge", "m7a.metal-48xl", "hpc7a.12xlarge", "hpc7a.24xlarge", "hpc7a.48xlarge", "hpc7a.96xlarge", "c7gd.medium", "c7gd.large", "c7gd.xlarge", "c7gd.2xlarge", "c7gd.4xlarge", "c7gd.8xlarge", "c7gd.12xlarge", "c7gd.16xlarge", "m7gd.medium", "m7gd.large", "m7gd.xlarge", "m7gd.2xlarge", "m7gd.4xlarge", "m7gd.8xlarge", "m7gd.12xlarge", "m7gd.16xlarge", "r7gd.medium", "r7gd.large", "r7gd.xlarge", "r7gd.2xlarge", "r7gd.4xlarge", "r7gd.8xlarge", "r7gd.12xlarge", "r7gd.16xlarge", "r7a.medium", "r7a.large", "r7a.xlarge", "r7a.2xlarge", "r7a.4xlarge", "r7a.8xlarge", "r7a.12xlarge", "r7a.16xlarge", "r7a.24xlarge", "r7a.32xlarge", "r7a.48xlarge", "c7i.large", "c7i.xlarge", "c7i.2xlarge", "c7i.4xlarge", "c7i.8xlarge", "c7i.12xlarge", "c7i.16xlarge", "c7i.24xlarge", "c7i.48xlarge", "mac2-m2pro.metal", "r7iz.large", "r7iz.xlarge", "r7iz.2xlarge", "r7iz.4xlarge", "r7iz.8xlarge", "r7iz.12xlarge", "r7iz.16xlarge", "r7iz.32xlarge", "c7a.medium", "c7a.large", "c7a.xlarge", "c7a.2xlarge", "c7a.4xlarge", "c7a.8xlarge", "c7a.12xlarge", "c7a.16xlarge", "c7a.24xlarge", "c7a.32xlarge", "c7a.48xlarge", "c7a.metal-48xl", "r7a.metal-48xl", "r7i.large", "r7i.xlarge", "r7i.2xlarge", "r7i.4xlarge", "r7i.8xlarge", "r7i.12xlarge", "r7i.16xlarge", "r7i.24xlarge", "r7i.48xlarge", "dl2q.24xlarge", "mac2-m2.metal", "i4i.12xlarge", "i4i.24xlarge", "c7i.metal-24xl", "c7i.metal-48xl", "m7i.metal-24xl", "m7i.metal-48xl", "r7i.metal-24xl", "r7i.metal-48xl", "r7iz.metal-16xl", "r7iz.metal-32xl", "c7gd.metal", "m7gd.metal", "r7gd.metal", "g6.xlarge", "g6.2xlarge", "g6.4xlarge", "g6.8xlarge", "g6.12xlarge", "g6.16xlarge", "g6.24xlarge", "g6.48xlarge", "gr6.4xlarge", "gr6.8xlarge", "c7i-flex.large", "c7i-flex.xlarge", "c7i-flex.2xlarge", "c7i-flex.4xlarge", "c7i-flex.8xlarge", "u7i-12tb.224xlarge", "u7in-16tb.224xlarge", "u7in-24tb.224xlarge", "u7in-32tb.224xlarge", "u7ib-12tb.224xlarge", "c7gn.metal", "r8g.medium", "r8g.large", "r8g.xlarge", "r8g.2xlarge", "r8g.4xlarge", "r8g.8xlarge", "r8g.12xlarge", "r8g.16xlarge", "r8g.24xlarge", "r8g.48xlarge", "r8g.metal-24xl", "r8g.metal-48xl", "mac2-m1ultra.metal", "g6e.xlarge", "g6e.2xlarge", "g6e.4xlarge", "g6e.8xlarge", "g6e.12xlarge", "g6e.16xlarge", "g6e.24xlarge", "g6e.48xlarge", "c8g.medium", "c8g.large", "c8g.xlarge", "c8g.2xlarge", "c8g.4xlarge", "c8g.8xlarge", "c8g.12xlarge", "c8g.16xlarge", "c8g.24xlarge", "c8g.48xlarge", "c8g.metal-24xl", "c8g.metal-48xl", "m8g.medium", "m8g.large", "m8g.xlarge", "m8g.2xlarge", "m8g.4xlarge", "m8g.8xlarge", "m8g.12xlarge", "m8g.16xlarge", "m8g.24xlarge", "m8g.48xlarge", "m8g.metal-24xl", "m8g.metal-48xl", "x8g.medium", "x8g.large", "x8g.xlarge", "x8g.2xlarge", "x8g.4xlarge", "x8g.8xlarge", "x8g.12xlarge", "x8g.16xlarge", "x8g.24xlarge", "x8g.48xlarge", "x8g.metal-24xl", "x8g.metal-48xl", "i7ie.large", "i7ie.xlarge", "i7ie.2xlarge", "i7ie.3xlarge", "i7ie.6xlarge", "i7ie.12xlarge", "i7ie.18xlarge", "i7ie.24xlarge", "i7ie.48xlarge", "i8g.large", "i8g.xlarge", "i8g.2xlarge", "i8g.4xlarge", "i8g.8xlarge", "i8g.12xlarge", "i8g.16xlarge", "i8g.24xlarge", "i8g.metal-24xl", "u7i-6tb.112xlarge", "u7i-8tb.112xlarge", "u7inh-32tb.480xlarge", "p5e.48xlarge", "p5en.48xlarge", "f2.12xlarge", "f2.48xlarge", "trn2.48xlarge", "c7i-flex.12xlarge", "c7i-flex.16xlarge", "m7i-flex.12xlarge", "m7i-flex.16xlarge", "i7ie.metal-24xl", "i7ie.metal-48xl", "i8g.48xlarge", "c8gd.medium", "c8gd.large", "c8gd.xlarge", "c8gd.2xlarge", "c8gd.4xlarge", "c8gd.8xlarge", "c8gd.12xlarge", "c8gd.16xlarge", "c8gd.24xlarge", "c8gd.48xlarge", "c8gd.metal-24xl", "c8gd.metal-48xl", "i7i.large", "i7i.xlarge", "i7i.2xlarge", "i7i.4xlarge", "i7i.8xlarge", "i7i.12xlarge", "i7i.16xlarge", "i7i.24xlarge", "i7i.48xlarge", "i7i.metal-24xl", "i7i.metal-48xl", "p6-b200.48xlarge", "m8gd.medium", "m8gd.large", "m8gd.xlarge", "m8gd.2xlarge", "m8gd.4xlarge", "m8gd.8xlarge", "m8gd.12xlarge", "m8gd.16xlarge", "m8gd.24xlarge", "m8gd.48xlarge", "m8gd.metal-24xl", "m8gd.metal-48xl", "r8gd.medium", "r8gd.large", "r8gd.xlarge", "r8gd.2xlarge", "r8gd.4xlarge", "r8gd.8xlarge", "r8gd.12xlarge", "r8gd.16xlarge", "r8gd.24xlarge", "r8gd.48xlarge", "r8gd.metal-24xl", "r8gd.metal-48xl", "c8gn.medium", "c8gn.large", "c8gn.xlarge", "c8gn.2xlarge", "c8gn.4xlarge", "c8gn.8xlarge", "c8gn.12xlarge", "c8gn.16xlarge", "c8gn.24xlarge", "c8gn.48xlarge", "c8gn.metal-24xl", "c8gn.metal-48xl", "f2.6xlarge", "p6e-gb200.36xlarge"
    #   resp.instances[0].launch_template_and_overrides.overrides.max_price #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.subnet_id #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.availability_zone #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.weighted_capacity #=> Float
    #   resp.instances[0].launch_template_and_overrides.overrides.priority #=> Float
    #   resp.instances[0].launch_template_and_overrides.overrides.placement.group_name #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.v_cpu_count.min #=> Integer
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.v_cpu_count.max #=> Integer
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.memory_mi_b.min #=> Integer
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.memory_mi_b.max #=> Integer
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.cpu_manufacturers #=> Array
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.cpu_manufacturers[0] #=> String, one of "intel", "amd", "amazon-web-services", "apple"
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.memory_gi_b_per_v_cpu.min #=> Float
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.memory_gi_b_per_v_cpu.max #=> Float
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.excluded_instance_types #=> Array
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.excluded_instance_types[0] #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.instance_generations #=> Array
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.instance_generations[0] #=> String, one of "current", "previous"
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.spot_max_price_percentage_over_lowest_price #=> Integer
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.on_demand_max_price_percentage_over_lowest_price #=> Integer
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.bare_metal #=> String, one of "included", "required", "excluded"
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.burstable_performance #=> String, one of "included", "required", "excluded"
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.require_hibernate_support #=> Boolean
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.network_interface_count.min #=> Integer
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.network_interface_count.max #=> Integer
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.local_storage #=> String, one of "included", "required", "excluded"
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.local_storage_types #=> Array
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.local_storage_types[0] #=> String, one of "hdd", "ssd"
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.total_local_storage_gb.min #=> Float
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.total_local_storage_gb.max #=> Float
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.baseline_ebs_bandwidth_mbps.min #=> Integer
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.baseline_ebs_bandwidth_mbps.max #=> Integer
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.accelerator_types #=> Array
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.accelerator_types[0] #=> String, one of "gpu", "fpga", "inference"
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.accelerator_count.min #=> Integer
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.accelerator_count.max #=> Integer
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.accelerator_manufacturers #=> Array
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.accelerator_manufacturers[0] #=> String, one of "amazon-web-services", "amd", "nvidia", "xilinx", "habana"
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.accelerator_names #=> Array
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.accelerator_names[0] #=> String, one of "a100", "inferentia", "k520", "k80", "m60", "radeon-pro-v520", "t4", "vu9p", "v100", "a10g", "h100", "t4g"
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.accelerator_total_memory_mi_b.min #=> Integer
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.accelerator_total_memory_mi_b.max #=> Integer
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.network_bandwidth_gbps.min #=> Float
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.network_bandwidth_gbps.max #=> Float
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.allowed_instance_types #=> Array
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.allowed_instance_types[0] #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.max_spot_price_as_percentage_of_optimal_on_demand_price #=> Integer
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.baseline_performance_factors.cpu.references #=> Array
    #   resp.instances[0].launch_template_and_overrides.overrides.instance_requirements.baseline_performance_factors.cpu.references[0].instance_family #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.image_id #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.block_device_mappings #=> Array
    #   resp.instances[0].launch_template_and_overrides.overrides.block_device_mappings[0].device_name #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.block_device_mappings[0].virtual_name #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.block_device_mappings[0].ebs.encrypted #=> Boolean
    #   resp.instances[0].launch_template_and_overrides.overrides.block_device_mappings[0].ebs.delete_on_termination #=> Boolean
    #   resp.instances[0].launch_template_and_overrides.overrides.block_device_mappings[0].ebs.iops #=> Integer
    #   resp.instances[0].launch_template_and_overrides.overrides.block_device_mappings[0].ebs.throughput #=> Integer
    #   resp.instances[0].launch_template_and_overrides.overrides.block_device_mappings[0].ebs.kms_key_id #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.block_device_mappings[0].ebs.snapshot_id #=> String
    #   resp.instances[0].launch_template_and_overrides.overrides.block_device_mappings[0].ebs.volume_size #=> Integer
    #   resp.instances[0].launch_template_and_overrides.overrides.block_device_mappings[0].ebs.volume_type #=> String, one of "standard", "io1", "io2", "gp2", "sc1", "st1", "gp3"
    #   resp.instances[0].launch_template_and_overrides.overrides.block_device_mappings[0].no_device #=> String
    #   resp.instances[0].lifecycle #=> String, one of "spot", "on-demand"
    #   resp.instances[0].instance_ids #=> Array
    #   resp.instances[0].instance_ids[0] #=> String
    #   resp.instances[0].instance_type #=> String, one of "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge", "a1.metal", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5a.large", "c5a.xlarge", "c5a.2xlarge", "c5a.4xlarge", "c5a.8xlarge", "c5a.12xlarge", "c5a.16xlarge", "c5a.24xlarge", "c5ad.large", "c5ad.xlarge", "c5ad.2xlarge", "c5ad.4xlarge", "c5ad.8xlarge", "c5ad.12xlarge", "c5ad.16xlarge", "c5ad.24xlarge", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.12xlarge", "c5d.18xlarge", "c5d.24xlarge", "c5d.metal", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "c5n.metal", "c6g.medium", "c6g.large", "c6g.xlarge", "c6g.2xlarge", "c6g.4xlarge", "c6g.8xlarge", "c6g.12xlarge", "c6g.16xlarge", "c6g.metal", "c6gd.medium", "c6gd.large", "c6gd.xlarge", "c6gd.2xlarge", "c6gd.4xlarge", "c6gd.8xlarge", "c6gd.12xlarge", "c6gd.16xlarge", "c6gd.metal", "c6gn.medium", "c6gn.large", "c6gn.xlarge", "c6gn.2xlarge", "c6gn.4xlarge", "c6gn.8xlarge", "c6gn.12xlarge", "c6gn.16xlarge", "c6i.large", "c6i.xlarge", "c6i.2xlarge", "c6i.4xlarge", "c6i.8xlarge", "c6i.12xlarge", "c6i.16xlarge", "c6i.24xlarge", "c6i.32xlarge", "c6i.metal", "cc1.4xlarge", "cc2.8xlarge", "cg1.4xlarge", "cr1.8xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "d3.xlarge", "d3.2xlarge", "d3.4xlarge", "d3.8xlarge", "d3en.xlarge", "d3en.2xlarge", "d3en.4xlarge", "d3en.6xlarge", "d3en.8xlarge", "d3en.12xlarge", "dl1.24xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "g4ad.xlarge", "g4ad.2xlarge", "g4ad.4xlarge", "g4ad.8xlarge", "g4ad.16xlarge", "g4dn.xlarge", "g4dn.2xlarge", "g4dn.4xlarge", "g4dn.8xlarge", "g4dn.12xlarge", "g4dn.16xlarge", "g4dn.metal", "g5.xlarge", "g5.2xlarge", "g5.4xlarge", "g5.8xlarge", "g5.12xlarge", "g5.16xlarge", "g5.24xlarge", "g5.48xlarge", "g5g.xlarge", "g5g.2xlarge", "g5g.4xlarge", "g5g.8xlarge", "g5g.16xlarge", "g5g.metal", "hi1.4xlarge", "hpc6a.48xlarge", "hs1.8xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "im4gn.large", "im4gn.xlarge", "im4gn.2xlarge", "im4gn.4xlarge", "im4gn.8xlarge", "im4gn.16xlarge", "inf1.xlarge", "inf1.2xlarge", "inf1.6xlarge", "inf1.24xlarge", "is4gen.medium", "is4gen.large", "is4gen.xlarge", "is4gen.2xlarge", "is4gen.4xlarge", "is4gen.8xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5dn.large", "m5dn.xlarge", "m5dn.2xlarge", "m5dn.4xlarge", "m5dn.8xlarge", "m5dn.12xlarge", "m5dn.16xlarge", "m5dn.24xlarge", "m5dn.metal", "m5n.large", "m5n.xlarge", "m5n.2xlarge", "m5n.4xlarge", "m5n.8xlarge", "m5n.12xlarge", "m5n.16xlarge", "m5n.24xlarge", "m5n.metal", "m5zn.large", "m5zn.xlarge", "m5zn.2xlarge", "m5zn.3xlarge", "m5zn.6xlarge", "m5zn.12xlarge", "m5zn.metal", "m6a.large", "m6a.xlarge", "m6a.2xlarge", "m6a.4xlarge", "m6a.8xlarge", "m6a.12xlarge", "m6a.16xlarge", "m6a.24xlarge", "m6a.32xlarge", "m6a.48xlarge", "m6g.metal", "m6g.medium", "m6g.large", "m6g.xlarge", "m6g.2xlarge", "m6g.4xlarge", "m6g.8xlarge", "m6g.12xlarge", "m6g.16xlarge", "m6gd.metal", "m6gd.medium", "m6gd.large", "m6gd.xlarge", "m6gd.2xlarge", "m6gd.4xlarge", "m6gd.8xlarge", "m6gd.12xlarge", "m6gd.16xlarge", "m6i.large", "m6i.xlarge", "m6i.2xlarge", "m6i.4xlarge", "m6i.8xlarge", "m6i.12xlarge", "m6i.16xlarge", "m6i.24xlarge", "m6i.32xlarge", "m6i.metal", "mac1.metal", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "p4d.24xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "r5b.large", "r5b.xlarge", "r5b.2xlarge", "r5b.4xlarge", "r5b.8xlarge", "r5b.12xlarge", "r5b.16xlarge", "r5b.24xlarge", "r5b.metal", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5dn.large", "r5dn.xlarge", "r5dn.2xlarge", "r5dn.4xlarge", "r5dn.8xlarge", "r5dn.12xlarge", "r5dn.16xlarge", "r5dn.24xlarge", "r5dn.metal", "r5n.large", "r5n.xlarge", "r5n.2xlarge", "r5n.4xlarge", "r5n.8xlarge", "r5n.12xlarge", "r5n.16xlarge", "r5n.24xlarge", "r5n.metal", "r6g.medium", "r6g.large", "r6g.xlarge", "r6g.2xlarge", "r6g.4xlarge", "r6g.8xlarge", "r6g.12xlarge", "r6g.16xlarge", "r6g.metal", "r6gd.medium", "r6gd.large", "r6gd.xlarge", "r6gd.2xlarge", "r6gd.4xlarge", "r6gd.8xlarge", "r6gd.12xlarge", "r6gd.16xlarge", "r6gd.metal", "r6i.large", "r6i.xlarge", "r6i.2xlarge", "r6i.4xlarge", "r6i.8xlarge", "r6i.12xlarge", "r6i.16xlarge", "r6i.24xlarge", "r6i.32xlarge", "r6i.metal", "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "t4g.nano", "t4g.micro", "t4g.small", "t4g.medium", "t4g.large", "t4g.xlarge", "t4g.2xlarge", "u-6tb1.56xlarge", "u-6tb1.112xlarge", "u-9tb1.112xlarge", "u-12tb1.112xlarge", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "u-18tb1.metal", "u-24tb1.metal", "vt1.3xlarge", "vt1.6xlarge", "vt1.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "x2iezn.2xlarge", "x2iezn.4xlarge", "x2iezn.6xlarge", "x2iezn.8xlarge", "x2iezn.12xlarge", "x2iezn.metal", "x2gd.medium", "x2gd.large", "x2gd.xlarge", "x2gd.2xlarge", "x2gd.4xlarge", "x2gd.8xlarge", "x2gd.12xlarge", "x2gd.16xlarge", "x2gd.metal", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "x2idn.16xlarge", "x2idn.24xlarge", "x2idn.32xlarge", "x2iedn.xlarge", "x2iedn.2xlarge", "x2iedn.4xlarge", "x2iedn.8xlarge", "x2iedn.16xlarge", "x2iedn.24xlarge", "x2iedn.32xlarge", "c6a.large", "c6a.xlarge", "c6a.2xlarge", "c6a.4xlarge", "c6a.8xlarge", "c6a.12xlarge", "c6a.16xlarge", "c6a.24xlarge", "c6a.32xlarge", "c6a.48xlarge", "c6a.metal", "m6a.metal", "i4i.large", "i4i.xlarge", "i4i.2xlarge", "i4i.4xlarge", "i4i.8xlarge", "i4i.16xlarge", "i4i.32xlarge", "i4i.metal", "x2idn.metal", "x2iedn.metal", "c7g.medium", "c7g.large", "c7g.xlarge", "c7g.2xlarge", "c7g.4xlarge", "c7g.8xlarge", "c7g.12xlarge", "c7g.16xlarge", "mac2.metal", "c6id.large", "c6id.xlarge", "c6id.2xlarge", "c6id.4xlarge", "c6id.8xlarge", "c6id.12xlarge", "c6id.16xlarge", "c6id.24xlarge", "c6id.32xlarge", "c6id.metal", "m6id.large", "m6id.xlarge", "m6id.2xlarge", "m6id.4xlarge", "m6id.8xlarge", "m6id.12xlarge", "m6id.16xlarge", "m6id.24xlarge", "m6id.32xlarge", "m6id.metal", "r6id.large", "r6id.xlarge", "r6id.2xlarge", "r6id.4xlarge", "r6id.8xlarge", "r6id.12xlarge", "r6id.16xlarge", "r6id.24xlarge", "r6id.32xlarge", "r6id.metal", "r6a.large", "r6a.xlarge", "r6a.2xlarge", "r6a.4xlarge", "r6a.8xlarge", "r6a.12xlarge", "r6a.16xlarge", "r6a.24xlarge", "r6a.32xlarge", "r6a.48xlarge", "r6a.metal", "p4de.24xlarge", "u-3tb1.56xlarge", "u-18tb1.112xlarge", "u-24tb1.112xlarge", "trn1.2xlarge", "trn1.32xlarge", "hpc6id.32xlarge", "c6in.large", "c6in.xlarge", "c6in.2xlarge", "c6in.4xlarge", "c6in.8xlarge", "c6in.12xlarge", "c6in.16xlarge", "c6in.24xlarge", "c6in.32xlarge", "m6in.large", "m6in.xlarge", "m6in.2xlarge", "m6in.4xlarge", "m6in.8xlarge", "m6in.12xlarge", "m6in.16xlarge", "m6in.24xlarge", "m6in.32xlarge", "m6idn.large", "m6idn.xlarge", "m6idn.2xlarge", "m6idn.4xlarge", "m6idn.8xlarge", "m6idn.12xlarge", "m6idn.16xlarge", "m6idn.24xlarge", "m6idn.32xlarge", "r6in.large", "r6in.xlarge", "r6in.2xlarge", "r6in.4xlarge", "r6in.8xlarge", "r6in.12xlarge", "r6in.16xlarge", "r6in.24xlarge", "r6in.32xlarge", "r6idn.large", "r6idn.xlarge", "r6idn.2xlarge", "r6idn.4xlarge", "r6idn.8xlarge", "r6idn.12xlarge", "r6idn.16xlarge", "r6idn.24xlarge", "r6idn.32xlarge", "c7g.metal", "m7g.medium", "m7g.large", "m7g.xlarge", "m7g.2xlarge", "m7g.4xlarge", "m7g.8xlarge", "m7g.12xlarge", "m7g.16xlarge", "m7g.metal", "r7g.medium", "r7g.large", "r7g.xlarge", "r7g.2xlarge", "r7g.4xlarge", "r7g.8xlarge", "r7g.12xlarge", "r7g.16xlarge", "r7g.metal", "c6in.metal", "m6in.metal", "m6idn.metal", "r6in.metal", "r6idn.metal", "inf2.xlarge", "inf2.8xlarge", "inf2.24xlarge", "inf2.48xlarge", "trn1n.32xlarge", "i4g.large", "i4g.xlarge", "i4g.2xlarge", "i4g.4xlarge", "i4g.8xlarge", "i4g.16xlarge", "hpc7g.4xlarge", "hpc7g.8xlarge", "hpc7g.16xlarge", "c7gn.medium", "c7gn.large", "c7gn.xlarge", "c7gn.2xlarge", "c7gn.4xlarge", "c7gn.8xlarge", "c7gn.12xlarge", "c7gn.16xlarge", "p5.48xlarge", "m7i.large", "m7i.xlarge", "m7i.2xlarge", "m7i.4xlarge", "m7i.8xlarge", "m7i.12xlarge", "m7i.16xlarge", "m7i.24xlarge", "m7i.48xlarge", "m7i-flex.large", "m7i-flex.xlarge", "m7i-flex.2xlarge", "m7i-flex.4xlarge", "m7i-flex.8xlarge", "m7a.medium", "m7a.large", "m7a.xlarge", "m7a.2xlarge", "m7a.4xlarge", "m7a.8xlarge", "m7a.12xlarge", "m7a.16xlarge", "m7a.24xlarge", "m7a.32xlarge", "m7a.48xlarge", "m7a.metal-48xl", "hpc7a.12xlarge", "hpc7a.24xlarge", "hpc7a.48xlarge", "hpc7a.96xlarge", "c7gd.medium", "c7gd.large", "c7gd.xlarge", "c7gd.2xlarge", "c7gd.4xlarge", "c7gd.8xlarge", "c7gd.12xlarge", "c7gd.16xlarge", "m7gd.medium", "m7gd.large", "m7gd.xlarge", "m7gd.2xlarge", "m7gd.4xlarge", "m7gd.8xlarge", "m7gd.12xlarge", "m7gd.16xlarge", "r7gd.medium", "r7gd.large", "r7gd.xlarge", "r7gd.2xlarge", "r7gd.4xlarge", "r7gd.8xlarge", "r7gd.12xlarge", "r7gd.16xlarge", "r7a.medium", "r7a.large", "r7a.xlarge", "r7a.2xlarge", "r7a.4xlarge", "r7a.8xlarge", "r7a.12xlarge", "r7a.16xlarge", "r7a.24xlarge", "r7a.32xlarge", "r7a.48xlarge", "c7i.large", "c7i.xlarge", "c7i.2xlarge", "c7i.4xlarge", "c7i.8xlarge", "c7i.12xlarge", "c7i.16xlarge", "c7i.24xlarge", "c7i.48xlarge", "mac2-m2pro.metal", "r7iz.large", "r7iz.xlarge", "r7iz.2xlarge", "r7iz.4xlarge", "r7iz.8xlarge", "r7iz.12xlarge", "r7iz.16xlarge", "r7iz.32xlarge", "c7a.medium", "c7a.large", "c7a.xlarge", "c7a.2xlarge", "c7a.4xlarge", "c7a.8xlarge", "c7a.12xlarge", "c7a.16xlarge", "c7a.24xlarge", "c7a.32xlarge", "c7a.48xlarge", "c7a.metal-48xl", "r7a.metal-48xl", "r7i.large", "r7i.xlarge", "r7i.2xlarge", "r7i.4xlarge", "r7i.8xlarge", "r7i.12xlarge", "r7i.16xlarge", "r7i.24xlarge", "r7i.48xlarge", "dl2q.24xlarge", "mac2-m2.metal", "i4i.12xlarge", "i4i.24xlarge", "c7i.metal-24xl", "c7i.metal-48xl", "m7i.metal-24xl", "m7i.metal-48xl", "r7i.metal-24xl", "r7i.metal-48xl", "r7iz.metal-16xl", "r7iz.metal-32xl", "c7gd.metal", "m7gd.metal", "r7gd.metal", "g6.xlarge", "g6.2xlarge", "g6.4xlarge", "g6.8xlarge", "g6.12xlarge", "g6.16xlarge", "g6.24xlarge", "g6.48xlarge", "gr6.4xlarge", "gr6.8xlarge", "c7i-flex.large", "c7i-flex.xlarge", "c7i-flex.2xlarge", "c7i-flex.4xlarge", "c7i-flex.8xlarge", "u7i-12tb.224xlarge", "u7in-16tb.224xlarge", "u7in-24tb.224xlarge", "u7in-32tb.224xlarge", "u7ib-12tb.224xlarge", "c7gn.metal", "r8g.medium", "r8g.large", "r8g.xlarge", "r8g.2xlarge", "r8g.4xlarge", "r8g.8xlarge", "r8g.12xlarge", "r8g.16xlarge", "r8g.24xlarge", "r8g.48xlarge", "r8g.metal-24xl", "r8g.metal-48xl", "mac2-m1ultra.metal", "g6e.xlarge", "g6e.2xlarge", "g6e.4xlarge", "g6e.8xlarge", "g6e.12xlarge", "g6e.16xlarge", "g6e.24xlarge", "g6e.48xlarge", "c8g.medium", "c8g.large", "c8g.xlarge", "c8g.2xlarge", "c8g.4xlarge", "c8g.8xlarge", "c8g.12xlarge", "c8g.16xlarge", "c8g.24xlarge", "c8g.48xlarge", "c8g.metal-24xl", "c8g.metal-48xl", "m8g.medium", "m8g.large", "m8g.xlarge", "m8g.2xlarge", "m8g.4xlarge", "m8g.8xlarge", "m8g.12xlarge", "m8g.16xlarge", "m8g.24xlarge", "m8g.48xlarge", "m8g.metal-24xl", "m8g.metal-48xl", "x8g.medium", "x8g.large", "x8g.xlarge", "x8g.2xlarge", "x8g.4xlarge", "x8g.8xlarge", "x8g.12xlarge", "x8g.16xlarge", "x8g.24xlarge", "x8g.48xlarge", "x8g.metal-24xl", "x8g.metal-48xl", "i7ie.large", "i7ie.xlarge", "i7ie.2xlarge", "i7ie.3xlarge", "i7ie.6xlarge", "i7ie.12xlarge", "i7ie.18xlarge", "i7ie.24xlarge", "i7ie.48xlarge", "i8g.large", "i8g.xlarge", "i8g.2xlarge", "i8g.4xlarge", "i8g.8xlarge", "i8g.12xlarge", "i8g.16xlarge", "i8g.24xlarge", "i8g.metal-24xl", "u7i-6tb.112xlarge", "u7i-8tb.112xlarge", "u7inh-32tb.480xlarge", "p5e.48xlarge", "p5en.48xlarge", "f2.12xlarge", "f2.48xlarge", "trn2.48xlarge", "c7i-flex.12xlarge", "c7i-flex.16xlarge", "m7i-flex.12xlarge", "m7i-flex.16xlarge", "i7ie.metal-24xl", "i7ie.metal-48xl", "i8g.48xlarge", "c8gd.medium", "c8gd.large", "c8gd.xlarge", "c8gd.2xlarge", "c8gd.4xlarge", "c8gd.8xlarge", "c8gd.12xlarge", "c8gd.16xlarge", "c8gd.24xlarge", "c8gd.48xlarge", "c8gd.metal-24xl", "c8gd.metal-48xl", "i7i.large", "i7i.xlarge", "i7i.2xlarge", "i7i.4xlarge", "i7i.8xlarge", "i7i.12xlarge", "i7i.16xlarge", "i7i.24xlarge", "i7i.48xlarge", "i7i.metal-24xl", "i7i.metal-48xl", "p6-b200.48xlarge", "m8gd.medium", "m8gd.large", "m8gd.xlarge", "m8gd.2xlarge", "m8gd.4xlarge", "m8gd.8xlarge", "m8gd.12xlarge", "m8gd.16xlarge", "m8gd.24xlarge", "m8gd.48xlarge", "m8gd.metal-24xl", "m8gd.metal-48xl", "r8gd.medium", "r8gd.large", "r8gd.xlarge", "r8gd.2xlarge", "r8gd.4xlarge", "r8gd.8xlarge", "r8gd.12xlarge", "r8gd.16xlarge", "r8gd.24xlarge", "r8gd.48xlarge", "r8gd.metal-24xl", "r8gd.metal-48xl", "c8gn.medium", "c8gn.large", "c8gn.xlarge", "c8gn.2xlarge", "c8gn.4xlarge", "c8gn.8xlarge", "c8gn.12xlarge", "c8gn.16xlarge", "c8gn.24xlarge", "c8gn.48xlarge", "c8gn.metal-24xl", "c8gn.metal-48xl", "f2.6xlarge", "p6e-gb200.36xlarge"
    #   resp.instances[0].platform #=> String, one of "Windows"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleet AWS API Documentation
    #
    # @overload create_fleet(params = {})
    # @param [Hash] params ({})
    def create_fleet(params = {}, options = {})
      req = build_request(:create_fleet, params)
      req.send_request(options)
    end

    # Creates one or more flow logs to capture information about IP traffic
    # for a specific network interface, subnet, or VPC.
    #
    # Flow log data for a monitored network interface is recorded as flow
    # log records, which are log events consisting of fields that describe
    # the traffic flow. For more information, see [Flow log records][1] in
    # the *Amazon VPC User Guide*.
    #
    # When publishing to CloudWatch Logs, flow log records are published to
    # a log group, and each network interface has a unique log stream in the
    # log group. When publishing to Amazon S3, flow log records for all of
    # the monitored network interfaces are published to a single log file
    # object that is stored in the specified bucket.
    #
    # For more information, see [VPC Flow Logs][2] in the *Amazon VPC User
    # Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/flow-log-records.html
    # [2]: https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [String] :deliver_logs_permission_arn
    #   The ARN of the IAM role that allows Amazon EC2 to publish flow logs to
    #   the log destination.
    #
    #   This parameter is required if the destination type is
    #   `cloud-watch-logs`, or if the destination type is
    #   `kinesis-data-firehose` and the delivery stream and the resources to
    #   monitor are in different accounts.
    #
    # @option params [String] :deliver_cross_account_role
    #   The ARN of the IAM role that allows Amazon EC2 to publish flow logs
    #   across accounts.
    #
    # @option params [String] :log_group_name
    #   The name of a new or existing CloudWatch Logs log group where Amazon
    #   EC2 publishes your flow logs.
    #
    #   This parameter is valid only if the destination type is
    #   `cloud-watch-logs`.
    #
    # @option params [required, Array<String>] :resource_ids
    #   The IDs of the resources to monitor. For example, if the resource type
    #   is `VPC`, specify the IDs of the VPCs.
    #
    #   Constraints: Maximum of 25 for transit gateway resource types. Maximum
    #   of 1000 for the other resource types.
    #
    # @option params [required, String] :resource_type
    #   The type of resource to monitor.
    #
    # @option params [String] :traffic_type
    #   The type of traffic to monitor (accepted traffic, rejected traffic, or
    #   all traffic). This parameter is not supported for transit gateway
    #   resource types. It is required for the other resource types.
    #
    # @option params [String] :log_destination_type
    #   The type of destination for the flow log data.
    #
    #   Default: `cloud-watch-logs`
    #
    # @option params [String] :log_destination
    #   The destination for the flow log data. The meaning of this parameter
    #   depends on the destination type.
    #
    #   * If the destination type is `cloud-watch-logs`, specify the ARN of a
    #     CloudWatch Logs log group. For example:
    #
    #     arn:aws:logs:*region*:*account\_id*:log-group:*my\_group*
    #
    #     Alternatively, use the `LogGroupName` parameter.
    #
    #   * If the destination type is `s3`, specify the ARN of an S3 bucket.
    #     For example:
    #
    #     arn:aws:s3:::*my\_bucket*/*my\_subfolder*/
    #
    #     The subfolder is optional. Note that you can't use `AWSLogs` as a
    #     subfolder name.
    #
    #   * If the destination type is `kinesis-data-firehose`, specify the ARN
    #     of a Kinesis Data Firehose delivery stream. For example:
    #
    #     arn:aws:firehose:*region*:*account\_id*:deliverystream:*my\_stream*
    #
    # @option params [String] :log_format
    #   The fields to include in the flow log record. List the fields in the
    #   order in which they should appear. If you omit this parameter, the
    #   flow log is created using the default format. If you specify this
    #   parameter, you must include at least one field. For more information
    #   about the available fields, see [Flow log records][1] in the *Amazon
    #   VPC User Guide* or [Transit Gateway Flow Log records][2] in the
    #   *Amazon Web Services Transit Gateway Guide*.
    #
    #   Specify the fields using the `${field-id}` format, separated by
    #   spaces.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/userguide/flow-log-records.html
    #   [2]: https://docs.aws.amazon.com/vpc/latest/tgw/tgw-flow-logs.html#flow-log-records
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the flow logs.
    #
    # @option params [Integer] :max_aggregation_interval
    #   The maximum interval of time during which a flow of packets is
    #   captured and aggregated into a flow log record. The possible values
    #   are 60 seconds (1 minute) or 600 seconds (10 minutes). This parameter
    #   must be 60 seconds for transit gateway resource types.
    #
    #   When a network interface is attached to a [Nitro-based instance][1],
    #   the aggregation interval is always 60 seconds or less, regardless of
    #   the value that you specify.
    #
    #   Default: 600
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html
    #
    # @option params [Types::DestinationOptionsRequest] :destination_options
    #   The destination options.
    #
    # @return [Types::CreateFlowLogsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateFlowLogsResult#client_token #client_token} => String
    #   * {Types::CreateFlowLogsResult#flow_log_ids #flow_log_ids} => Array&lt;String&gt;
    #   * {Types::CreateFlowLogsResult#unsuccessful #unsuccessful} => Array&lt;Types::UnsuccessfulItem&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_flow_logs({
    #     dry_run: false,
    #     client_token: "String",
    #     deliver_logs_permission_arn: "String",
    #     deliver_cross_account_role: "String",
    #     log_group_name: "String",
    #     resource_ids: ["FlowLogResourceId"], # required
    #     resource_type: "VPC", # required, accepts VPC, Subnet, NetworkInterface, TransitGateway, TransitGatewayAttachment
    #     traffic_type: "ACCEPT", # accepts ACCEPT, REJECT, ALL
    #     log_destination_type: "cloud-watch-logs", # accepts cloud-watch-logs, s3, kinesis-data-firehose
    #     log_destination: "String",
    #     log_format: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     max_aggregation_interval: 1,
    #     destination_options: {
    #       file_format: "plain-text", # accepts plain-text, parquet
    #       hive_compatible_partitions: false,
    #       per_hour_partition: false,
    #     },
    #   })
    #
    # @example Response structure
    #
    #   resp.client_token #=> String
    #   resp.flow_log_ids #=> Array
    #   resp.flow_log_ids[0] #=> String
    #   resp.unsuccessful #=> Array
    #   resp.unsuccessful[0].error.code #=> String
    #   resp.unsuccessful[0].error.message #=> String
    #   resp.unsuccessful[0].resource_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogs AWS API Documentation
    #
    # @overload create_flow_logs(params = {})
    # @param [Hash] params ({})
    def create_flow_logs(params = {}, options = {})
      req = build_request(:create_flow_logs, params)
      req.send_request(options)
    end

    # Creates an Amazon FPGA Image (AFI) from the specified design
    # checkpoint (DCP).
    #
    # The create operation is asynchronous. To verify that the AFI is ready
    # for use, check the output logs.
    #
    # An AFI contains the FPGA bitstream that is ready to download to an
    # FPGA. You can securely deploy an AFI on multiple FPGA-accelerated
    # instances. For more information, see the [Amazon Web Services FPGA
    # Hardware Development Kit][1].
    #
    #
    #
    # [1]: https://github.com/aws/aws-fpga/
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Types::StorageLocation] :input_storage_location
    #   The location of the encrypted design checkpoint in Amazon S3. The
    #   input must be a tarball.
    #
    # @option params [Types::StorageLocation] :logs_storage_location
    #   The location in Amazon S3 for the output logs.
    #
    # @option params [String] :description
    #   A description for the AFI.
    #
    # @option params [String] :name
    #   A name for the AFI.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the FPGA image during creation.
    #
    # @return [Types::CreateFpgaImageResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateFpgaImageResult#fpga_image_id #fpga_image_id} => String
    #   * {Types::CreateFpgaImageResult#fpga_image_global_id #fpga_image_global_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_fpga_image({
    #     dry_run: false,
    #     input_storage_location: { # required
    #       bucket: "String",
    #       key: "String",
    #     },
    #     logs_storage_location: {
    #       bucket: "String",
    #       key: "String",
    #     },
    #     description: "String",
    #     name: "String",
    #     client_token: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.fpga_image_id #=> String
    #   resp.fpga_image_global_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImage AWS API Documentation
    #
    # @overload create_fpga_image(params = {})
    # @param [Hash] params ({})
    def create_fpga_image(params = {}, options = {})
      req = build_request(:create_fpga_image, params)
      req.send_request(options)
    end

    # Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance
    # that is either running or stopped.
    #
    # If you customized your instance with instance store volumes or Amazon
    # EBS volumes in addition to the root device volume, the new AMI
    # contains block device mapping information for those volumes. When you
    # launch an instance from this new AMI, the instance automatically
    # launches with those additional volumes.
    #
    # The location of the source instance determines where you can create
    # the snapshots of the AMI:
    #
    # * If the source instance is in a Region, you must create the snapshots
    #   in the same Region as the instance.
    #
    # * If the source instance is in a Local Zone, you can create the
    #   snapshots in the same Local Zone or in its parent Region.
    #
    # For more information, see [Create an Amazon EBS-backed AMI][1] in the
    # *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the AMI and snapshots on creation. You can tag
    #   the AMI, the snapshots, or both.
    #
    #   * To tag the AMI, the value for `ResourceType` must be `image`.
    #
    #   * To tag the snapshots that are created of the root volume and of
    #     other Amazon EBS volumes that are attached to the instance, the
    #     value for `ResourceType` must be `snapshot`. The same tag is applied
    #     to all of the snapshots that are created.
    #
    #   If you specify other values for `ResourceType`, the request fails.
    #
    #   To tag an AMI or snapshot after it has been created, see
    #   [CreateTags][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html
    #
    # @option params [String] :snapshot_location
    #   <note markdown="1"> Only supported for instances in Local Zones. If the source instance is
    #   not in a Local Zone, omit this parameter.
    #
    #    </note>
    #
    #   The Amazon S3 location where the snapshots will be stored.
    #
    #   * To create local snapshots in the same Local Zone as the source
    #     instance, specify `local`.
    #
    #   * To create regional snapshots in the parent Region of the Local Zone,
    #     specify `regional` or omit this parameter.
    #
    #   Default: `regional`
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance.
    #
    # @option params [required, String] :name
    #   A name for the new image.
    #
    #   Constraints: 3-128 alphanumeric characters, parentheses (()), square
    #   brackets (\[\]), spaces ( ), periods (.), slashes (/), dashes (-),
    #   single quotes ('), at-signs (@), or underscores(\_)
    #
    # @option params [String] :description
    #   A description for the new image.
    #
    # @option params [Boolean] :no_reboot
    #   Indicates whether or not the instance should be automatically rebooted
    #   before creating the image. Specify one of the following values:
    #
    #   * `true` - The instance is not rebooted before creating the image.
    #     This creates crash-consistent snapshots that include only the data
    #     that has been written to the volumes at the time the snapshots are
    #     created. Buffered data and data in memory that has not yet been
    #     written to the volumes is not included in the snapshots.
    #
    #   * `false` - The instance is rebooted before creating the image. This
    #     ensures that all buffered data and data in memory is written to the
    #     volumes before the snapshots are created.
    #
    #   Default: `false`
    #
    # @option params [Array<Types::BlockDeviceMapping>] :block_device_mappings
    #   The block device mappings.
    #
    #   When using the CreateImage action:
    #
    #   * You can't change the volume size using the VolumeSize parameter. If
    #     you want a different volume size, you must first change the volume
    #     size of the source instance.
    #
    #   * You can't modify the encryption status of existing volumes or
    #     snapshots. To create an AMI with volumes or snapshots that have a
    #     different encryption status (for example, where the source volume
    #     and snapshots are unencrypted, and you want to create an AMI with
    #     encrypted volumes or snapshots), copy the image instead.
    #
    #   * The only option that can be changed for existing mappings or
    #     snapshots is `DeleteOnTermination`.
    #
    # @return [Types::CreateImageResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateImageResult#image_id #image_id} => String
    #
    #
    # @example Example: To create an AMI from an Amazon EBS-backed instance
    #
    #   # This example creates an AMI from the specified instance and adds an EBS volume with the device name /dev/sdh and an
    #   # instance store volume with the device name /dev/sdc.
    #
    #   resp = client.create_image({
    #     block_device_mappings: [
    #       {
    #         device_name: "/dev/sdh", 
    #         ebs: {
    #           volume_size: 100, 
    #         }, 
    #       }, 
    #       {
    #         device_name: "/dev/sdc", 
    #         virtual_name: "ephemeral1", 
    #       }, 
    #     ], 
    #     description: "An AMI for my server", 
    #     instance_id: "i-1234567890abcdef0", 
    #     name: "My server", 
    #     no_reboot: true, 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     image_id: "ami-1a2b3c4d", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_image({
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     snapshot_location: "regional", # accepts regional, local
    #     dry_run: false,
    #     instance_id: "InstanceId", # required
    #     name: "String", # required
    #     description: "String",
    #     no_reboot: false,
    #     block_device_mappings: [
    #       {
    #         ebs: {
    #           delete_on_termination: false,
    #           iops: 1,
    #           snapshot_id: "SnapshotId",
    #           volume_size: 1,
    #           volume_type: "standard", # accepts standard, io1, io2, gp2, sc1, st1, gp3
    #           kms_key_id: "String",
    #           throughput: 1,
    #           outpost_arn: "String",
    #           availability_zone: "String",
    #           encrypted: false,
    #           volume_initialization_rate: 1,
    #           availability_zone_id: "String",
    #         },
    #         no_device: "String",
    #         device_name: "String",
    #         virtual_name: "String",
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.image_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImage AWS API Documentation
    #
    # @overload create_image(params = {})
    # @param [Hash] params ({})
    def create_image(params = {}, options = {})
      req = build_request(:create_image, params)
      req.send_request(options)
    end

    # Creates a report that shows how your image is used across other Amazon
    # Web Services accounts. The report provides visibility into which
    # accounts are using the specified image, and how many resources (EC2
    # instances or launch templates) are referencing it.
    #
    # For more information, see [View your AMI usage][1] in the *Amazon EC2
    # User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/your-ec2-ami-usage.html
    #
    # @option params [required, String] :image_id
    #   The ID of the image to report on.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<Types::ImageUsageResourceTypeRequest>] :resource_types
    #   The resource types to include in the report.
    #
    # @option params [Array<String>] :account_ids
    #   The Amazon Web Services account IDs to include in the report. To
    #   include all accounts, omit this parameter.
    #
    # @option params [String] :client_token
    #   A unique, case-sensitive identifier that you provide to ensure
    #   idempotency of the request.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the report on creation. The `ResourceType` must
    #   be set to `image-usage-report`; any other value will cause the report
    #   creation to fail.
    #
    #   To tag a report after it has been created, see [CreateTags][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html
    #
    # @return [Types::CreateImageUsageReportResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateImageUsageReportResult#report_id #report_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_image_usage_report({
    #     image_id: "ImageId", # required
    #     dry_run: false,
    #     resource_types: [ # required
    #       {
    #         resource_type: "ImageUsageResourceTypeName",
    #         resource_type_options: [
    #           {
    #             option_name: "String",
    #             option_values: ["ImageUsageResourceTypeOptionValue"],
    #           },
    #         ],
    #       },
    #     ],
    #     account_ids: ["String"],
    #     client_token: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.report_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImageUsageReport AWS API Documentation
    #
    # @overload create_image_usage_report(params = {})
    # @param [Hash] params ({})
    def create_image_usage_report(params = {}, options = {})
      req = build_request(:create_image_usage_report, params)
      req.send_request(options)
    end

    # Creates an EC2 Instance Connect Endpoint.
    #
    # An EC2 Instance Connect Endpoint allows you to connect to an instance,
    # without requiring the instance to have a public IPv4 or public IPv6
    # address. For more information, see [Connect to your instances using
    # EC2 Instance Connect Endpoint][1] in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Connect-using-EC2-Instance-Connect-Endpoint.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :subnet_id
    #   The ID of the subnet in which to create the EC2 Instance Connect
    #   Endpoint.
    #
    # @option params [Array<String>] :security_group_ids
    #   One or more security groups to associate with the endpoint. If you
    #   don't specify a security group, the default security group for your
    #   VPC will be associated with the endpoint.
    #
    # @option params [Boolean] :preserve_client_ip
    #   Indicates whether the client IP address is preserved as the source.
    #   The following are the possible values.
    #
    #   * `true` - Use the client IP address as the source.
    #
    #   * `false` - Use the network interface IP address as the source.
    #
    #   <note markdown="1"> `PreserveClientIp` is only supported on IPv4 EC2 Instance Connect
    #   Endpoints. To use `PreserveClientIp`, the value for `IpAddressType`
    #   must be `ipv4`.
    #
    #    </note>
    #
    #   Default: `false`
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the EC2 Instance Connect Endpoint during
    #   creation.
    #
    # @option params [String] :ip_address_type
    #   The IP address type of the endpoint.
    #
    #   If no value is specified, the default value is determined by the IP
    #   address type of the subnet:
    #
    #   * `dualstack` - If the subnet has both IPv4 and IPv6 CIDRs
    #
    #   * `ipv4` - If the subnet has only IPv4 CIDRs
    #
    #   * `ipv6` - If the subnet has only IPv6 CIDRs
    #
    #   <note markdown="1"> `PreserveClientIp` is only supported on IPv4 EC2 Instance Connect
    #   Endpoints. To use `PreserveClientIp`, the value for `IpAddressType`
    #   must be `ipv4`.
    #
    #    </note>
    #
    # @return [Types::CreateInstanceConnectEndpointResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateInstanceConnectEndpointResult#instance_connect_endpoint #instance_connect_endpoint} => Types::Ec2InstanceConnectEndpoint
    #   * {Types::CreateInstanceConnectEndpointResult#client_token #client_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_instance_connect_endpoint({
    #     dry_run: false,
    #     subnet_id: "SubnetId", # required
    #     security_group_ids: ["SecurityGroupId"],
    #     preserve_client_ip: false,
    #     client_token: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     ip_address_type: "ipv4", # accepts ipv4, dualstack, ipv6
    #   })
    #
    # @example Response structure
    #
    #   resp.instance_connect_endpoint.owner_id #=> String
    #   resp.instance_connect_endpoint.instance_connect_endpoint_id #=> String
    #   resp.instance_connect_endpoint.instance_connect_endpoint_arn #=> String
    #   resp.instance_connect_endpoint.state #=> String, one of "create-in-progress", "create-complete", "create-failed", "delete-in-progress", "delete-complete", "delete-failed", "update-in-progress", "update-complete", "update-failed"
    #   resp.instance_connect_endpoint.state_message #=> String
    #   resp.instance_connect_endpoint.dns_name #=> String
    #   resp.instance_connect_endpoint.fips_dns_name #=> String
    #   resp.instance_connect_endpoint.network_interface_ids #=> Array
    #   resp.instance_connect_endpoint.network_interface_ids[0] #=> String
    #   resp.instance_connect_endpoint.vpc_id #=> String
    #   resp.instance_connect_endpoint.availability_zone #=> String
    #   resp.instance_connect_endpoint.created_at #=> Time
    #   resp.instance_connect_endpoint.subnet_id #=> String
    #   resp.instance_connect_endpoint.preserve_client_ip #=> Boolean
    #   resp.instance_connect_endpoint.security_group_ids #=> Array
    #   resp.instance_connect_endpoint.security_group_ids[0] #=> String
    #   resp.instance_connect_endpoint.tags #=> Array
    #   resp.instance_connect_endpoint.tags[0].key #=> String
    #   resp.instance_connect_endpoint.tags[0].value #=> String
    #   resp.instance_connect_endpoint.ip_address_type #=> String, one of "ipv4", "dualstack", "ipv6"
    #   resp.instance_connect_endpoint.public_dns_names.ipv_4.dns_name #=> String
    #   resp.instance_connect_endpoint.public_dns_names.ipv_4.fips_dns_name #=> String
    #   resp.instance_connect_endpoint.public_dns_names.dualstack.dns_name #=> String
    #   resp.instance_connect_endpoint.public_dns_names.dualstack.fips_dns_name #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceConnectEndpoint AWS API Documentation
    #
    # @overload create_instance_connect_endpoint(params = {})
    # @param [Hash] params ({})
    def create_instance_connect_endpoint(params = {}, options = {})
      req = build_request(:create_instance_connect_endpoint, params)
      req.send_request(options)
    end

    # Creates an event window in which scheduled events for the associated
    # Amazon EC2 instances can run.
    #
    # You can define either a set of time ranges or a cron expression when
    # creating the event window, but not both. All event window times are in
    # UTC.
    #
    # You can create up to 200 event windows per Amazon Web Services Region.
    #
    # When you create the event window, targets (instance IDs, Dedicated
    # Host IDs, or tags) are not yet associated with it. To ensure that the
    # event window can be used, you must associate one or more targets with
    # it by using the AssociateInstanceEventWindow API.
    #
    # Event windows are applicable only for scheduled events that stop,
    # reboot, or terminate instances.
    #
    #  Event windows are *not* applicable for:
    #
    #  * Expedited scheduled events and network maintenance events.
    #
    # * Unscheduled maintenance such as AutoRecovery and unplanned reboots.
    #
    # For more information, see [Define event windows for scheduled
    # events][1] in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/event-windows.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :name
    #   The name of the event window.
    #
    # @option params [Array<Types::InstanceEventWindowTimeRangeRequest>] :time_ranges
    #   The time range for the event window. If you specify a time range, you
    #   can't specify a cron expression.
    #
    # @option params [String] :cron_expression
    #   The cron expression for the event window, for example, `* 0-4,20-23 *
    #   * 1,5`. If you specify a cron expression, you can't specify a time
    #   range.
    #
    #   Constraints:
    #
    #   * Only hour and day of the week values are supported.
    #
    #   * For day of the week values, you can specify either integers `0`
    #     through `6`, or alternative single values `SUN` through `SAT`.
    #
    #   * The minute, month, and year must be specified by `*`.
    #
    #   * The hour value must be one or a multiple range, for example, `0-4`
    #     or `0-4,20-23`.
    #
    #   * Each hour range must be &gt;= 2 hours, for example, `0-2` or
    #     `20-23`.
    #
    #   * The event window must be &gt;= 4 hours. The combined total time
    #     ranges in the event window must be &gt;= 4 hours.
    #
    #   For more information about cron expressions, see [cron][1] on the
    #   *Wikipedia website*.
    #
    #
    #
    #   [1]: https://en.wikipedia.org/wiki/Cron
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the event window.
    #
    # @return [Types::CreateInstanceEventWindowResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateInstanceEventWindowResult#instance_event_window #instance_event_window} => Types::InstanceEventWindow
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_instance_event_window({
    #     dry_run: false,
    #     name: "String",
    #     time_ranges: [
    #       {
    #         start_week_day: "sunday", # accepts sunday, monday, tuesday, wednesday, thursday, friday, saturday
    #         start_hour: 1,
    #         end_week_day: "sunday", # accepts sunday, monday, tuesday, wednesday, thursday, friday, saturday
    #         end_hour: 1,
    #       },
    #     ],
    #     cron_expression: "InstanceEventWindowCronExpression",
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.instance_event_window.instance_event_window_id #=> String
    #   resp.instance_event_window.time_ranges #=> Array
    #   resp.instance_event_window.time_ranges[0].start_week_day #=> String, one of "sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"
    #   resp.instance_event_window.time_ranges[0].start_hour #=> Integer
    #   resp.instance_event_window.time_ranges[0].end_week_day #=> String, one of "sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"
    #   resp.instance_event_window.time_ranges[0].end_hour #=> Integer
    #   resp.instance_event_window.name #=> String
    #   resp.instance_event_window.cron_expression #=> String
    #   resp.instance_event_window.association_target.instance_ids #=> Array
    #   resp.instance_event_window.association_target.instance_ids[0] #=> String
    #   resp.instance_event_window.association_target.tags #=> Array
    #   resp.instance_event_window.association_target.tags[0].key #=> String
    #   resp.instance_event_window.association_target.tags[0].value #=> String
    #   resp.instance_event_window.association_target.dedicated_host_ids #=> Array
    #   resp.instance_event_window.association_target.dedicated_host_ids[0] #=> String
    #   resp.instance_event_window.state #=> String, one of "creating", "deleting", "active", "deleted"
    #   resp.instance_event_window.tags #=> Array
    #   resp.instance_event_window.tags[0].key #=> String
    #   resp.instance_event_window.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceEventWindow AWS API Documentation
    #
    # @overload create_instance_event_window(params = {})
    # @param [Hash] params ({})
    def create_instance_event_window(params = {}, options = {})
      req = build_request(:create_instance_event_window, params)
      req.send_request(options)
    end

    # Exports a running or stopped instance to an Amazon S3 bucket.
    #
    # For information about the prerequisites for your Amazon S3 bucket,
    # supported operating systems, image formats, and known limitations for
    # the types of instances you can export, see [Exporting an instance as a
    # VM Using VM Import/Export][1] in the *VM Import/Export User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the export instance task during creation.
    #
    # @option params [String] :description
    #   A description for the conversion task or the resource being exported.
    #   The maximum length is 255 characters.
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance.
    #
    # @option params [required, String] :target_environment
    #   The target virtualization environment.
    #
    # @option params [required, Types::ExportToS3TaskSpecification] :export_to_s3_task
    #   The format and location for an export instance task.
    #
    # @return [Types::CreateInstanceExportTaskResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateInstanceExportTaskResult#export_task #export_task} => Types::ExportTask
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_instance_export_task({
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     description: "String",
    #     instance_id: "InstanceId", # required
    #     target_environment: "citrix", # required, accepts citrix, vmware, microsoft
    #     export_to_s3_task: { # required
    #       disk_image_format: "VMDK", # accepts VMDK, RAW, VHD
    #       container_format: "ova", # accepts ova
    #       s3_bucket: "String",
    #       s3_prefix: "String",
    #     },
    #   })
    #
    # @example Response structure
    #
    #   resp.export_task.description #=> String
    #   resp.export_task.export_task_id #=> String
    #   resp.export_task.export_to_s3_task.container_format #=> String, one of "ova"
    #   resp.export_task.export_to_s3_task.disk_image_format #=> String, one of "VMDK", "RAW", "VHD"
    #   resp.export_task.export_to_s3_task.s3_bucket #=> String
    #   resp.export_task.export_to_s3_task.s3_key #=> String
    #   resp.export_task.instance_export_details.instance_id #=> String
    #   resp.export_task.instance_export_details.target_environment #=> String, one of "citrix", "vmware", "microsoft"
    #   resp.export_task.state #=> String, one of "active", "cancelling", "cancelled", "completed"
    #   resp.export_task.status_message #=> String
    #   resp.export_task.tags #=> Array
    #   resp.export_task.tags[0].key #=> String
    #   resp.export_task.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTask AWS API Documentation
    #
    # @overload create_instance_export_task(params = {})
    # @param [Hash] params ({})
    def create_instance_export_task(params = {}, options = {})
      req = build_request(:create_instance_export_task, params)
      req.send_request(options)
    end

    # Creates an internet gateway for use with a VPC. After creating the
    # internet gateway, you attach it to a VPC using AttachInternetGateway.
    #
    # For more information, see [Internet gateways][1] in the *Amazon VPC
    # User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Internet_Gateway.html
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the internet gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateInternetGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateInternetGatewayResult#internet_gateway #internet_gateway} => Types::InternetGateway
    #
    #
    # @example Example: To create an Internet gateway
    #
    #   # This example creates an Internet gateway.
    #
    #   resp = client.create_internet_gateway({
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     internet_gateway: {
    #       attachments: [
    #       ], 
    #       internet_gateway_id: "igw-c0a643a9", 
    #       tags: [
    #       ], 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_internet_gateway({
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.internet_gateway.attachments #=> Array
    #   resp.internet_gateway.attachments[0].state #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.internet_gateway.attachments[0].vpc_id #=> String
    #   resp.internet_gateway.internet_gateway_id #=> String
    #   resp.internet_gateway.owner_id #=> String
    #   resp.internet_gateway.tags #=> Array
    #   resp.internet_gateway.tags[0].key #=> String
    #   resp.internet_gateway.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGateway AWS API Documentation
    #
    # @overload create_internet_gateway(params = {})
    # @param [Hash] params ({})
    def create_internet_gateway(params = {}, options = {})
      req = build_request(:create_internet_gateway, params)
      req.send_request(options)
    end

    # Create an IPAM. Amazon VPC IP Address Manager (IPAM) is a VPC feature
    # that you can use to automate your IP address management workflows
    # including assigning, tracking, troubleshooting, and auditing IP
    # addresses across Amazon Web Services Regions and accounts throughout
    # your Amazon Web Services Organization.
    #
    # For more information, see [Create an IPAM][1] in the *Amazon VPC IPAM
    # User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html
    #
    # @option params [Boolean] :dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response. If
    #   you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :description
    #   A description for the IPAM.
    #
    # @option params [Array<Types::AddIpamOperatingRegion>] :operating_regions
    #   The operating Regions for the IPAM. Operating Regions are Amazon Web
    #   Services Regions where the IPAM is allowed to manage IP address CIDRs.
    #   IPAM only discovers and monitors resources in the Amazon Web Services
    #   Regions you select as operating Regions.
    #
    #   For more information about operating Regions, see [Create an IPAM][1]
    #   in the *Amazon VPC IPAM User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The key/value combination of a tag assigned to the resource. Use the
    #   tag key in the filter name and the tag value as the filter value. For
    #   example, to find all resources that have a tag with the key `Owner`
    #   and the value `TeamA`, specify `tag:Owner` for the filter name and
    #   `TeamA` for the filter value.
    #
    # @option params [String] :client_token
    #   A unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [String] :tier
    #   IPAM is offered in a Free Tier and an Advanced Tier. For more
    #   information about the features available in each tier and the costs
    #   associated with the tiers, see [Amazon VPC pricing &gt; IPAM tab][1].
    #
    #
    #
    #   [1]: http://aws.amazon.com/vpc/pricing/
    #
    # @option params [Boolean] :enable_private_gua
    #   Enable this option to use your own GUA ranges as private IPv6
    #   addresses. This option is disabled by default.
    #
    # @option params [String] :metered_account
    #   A metered account is an Amazon Web Services account that is charged
    #   for active IP addresses managed in IPAM. For more information, see
    #   [Enable cost distribution][1] in the *Amazon VPC IPAM User Guide*.
    #
    #   Possible values:
    #
    #   * `ipam-owner` (default): The Amazon Web Services account which owns
    #     the IPAM is charged for all active IP addresses managed in IPAM.
    #
    #   * `resource-owner`: The Amazon Web Services account that owns the IP
    #     address is charged for the active IP address.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/ipam-enable-cost-distro.html
    #
    # @return [Types::CreateIpamResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateIpamResult#ipam #ipam} => Types::Ipam
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_ipam({
    #     dry_run: false,
    #     description: "String",
    #     operating_regions: [
    #       {
    #         region_name: "String",
    #       },
    #     ],
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     client_token: "String",
    #     tier: "free", # accepts free, advanced
    #     enable_private_gua: false,
    #     metered_account: "ipam-owner", # accepts ipam-owner, resource-owner
    #   })
    #
    # @example Response structure
    #
    #   resp.ipam.owner_id #=> String
    #   resp.ipam.ipam_id #=> String
    #   resp.ipam.ipam_arn #=> String
    #   resp.ipam.ipam_region #=> String
    #   resp.ipam.public_default_scope_id #=> String
    #   resp.ipam.private_default_scope_id #=> String
    #   resp.ipam.scope_count #=> Integer
    #   resp.ipam.description #=> String
    #   resp.ipam.operating_regions #=> Array
    #   resp.ipam.operating_regions[0].region_name #=> String
    #   resp.ipam.state #=> String, one of "create-in-progress", "create-complete", "create-failed", "modify-in-progress", "modify-complete", "modify-failed", "delete-in-progress", "delete-complete", "delete-failed", "isolate-in-progress", "isolate-complete", "restore-in-progress"
    #   resp.ipam.tags #=> Array
    #   resp.ipam.tags[0].key #=> String
    #   resp.ipam.tags[0].value #=> String
    #   resp.ipam.default_resource_discovery_id #=> String
    #   resp.ipam.default_resource_discovery_association_id #=> String
    #   resp.ipam.resource_discovery_association_count #=> Integer
    #   resp.ipam.state_message #=> String
    #   resp.ipam.tier #=> String, one of "free", "advanced"
    #   resp.ipam.enable_private_gua #=> Boolean
    #   resp.ipam.metered_account #=> String, one of "ipam-owner", "resource-owner"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpam AWS API Documentation
    #
    # @overload create_ipam(params = {})
    # @param [Hash] params ({})
    def create_ipam(params = {}, options = {})
      req = build_request(:create_ipam, params)
      req.send_request(options)
    end

    # Create a verification token. A verification token is an Amazon Web
    # Services-generated random value that you can use to prove ownership of
    # an external resource. For example, you can use a verification token to
    # validate that you control a public IP address range when you bring an
    # IP address range to Amazon Web Services (BYOIP).
    #
    # @option params [Boolean] :dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response. If
    #   you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :ipam_id
    #   The ID of the IPAM that will create the token.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   Token tags.
    #
    # @option params [String] :client_token
    #   A unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @return [Types::CreateIpamExternalResourceVerificationTokenResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateIpamExternalResourceVerificationTokenResult#ipam_external_resource_verification_token #ipam_external_resource_verification_token} => Types::IpamExternalResourceVerificationToken
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_ipam_external_resource_verification_token({
    #     dry_run: false,
    #     ipam_id: "IpamId", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.ipam_external_resource_verification_token.ipam_external_resource_verification_token_id #=> String
    #   resp.ipam_external_resource_verification_token.ipam_external_resource_verification_token_arn #=> String
    #   resp.ipam_external_resource_verification_token.ipam_id #=> String
    #   resp.ipam_external_resource_verification_token.ipam_arn #=> String
    #   resp.ipam_external_resource_verification_token.ipam_region #=> String
    #   resp.ipam_external_resource_verification_token.token_value #=> String
    #   resp.ipam_external_resource_verification_token.token_name #=> String
    #   resp.ipam_external_resource_verification_token.not_after #=> Time
    #   resp.ipam_external_resource_verification_token.status #=> String, one of "valid", "expired"
    #   resp.ipam_external_resource_verification_token.tags #=> Array
    #   resp.ipam_external_resource_verification_token.tags[0].key #=> String
    #   resp.ipam_external_resource_verification_token.tags[0].value #=> String
    #   resp.ipam_external_resource_verification_token.state #=> String, one of "create-in-progress", "create-complete", "create-failed", "delete-in-progress", "delete-complete", "delete-failed"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamExternalResourceVerificationToken AWS API Documentation
    #
    # @overload create_ipam_external_resource_verification_token(params = {})
    # @param [Hash] params ({})
    def create_ipam_external_resource_verification_token(params = {}, options = {})
      req = build_request(:create_ipam_external_resource_verification_token, params)
      req.send_request(options)
    end

    # Create an IP address pool for Amazon VPC IP Address Manager (IPAM). In
    # IPAM, a pool is a collection of contiguous IP addresses CIDRs. Pools
    # enable you to organize your IP addresses according to your routing and
    # security needs. For example, if you have separate routing and security
    # needs for development and production applications, you can create a
    # pool for each.
    #
    # For more information, see [Create a top-level pool][1] in the *Amazon
    # VPC IPAM User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/ipam/create-top-ipam.html
    #
    # @option params [Boolean] :dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response. If
    #   you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :ipam_scope_id
    #   The ID of the scope in which you would like to create the IPAM pool.
    #
    # @option params [String] :locale
    #   The locale for the pool should be one of the following:
    #
    #   * An Amazon Web Services Region where you want this IPAM pool to be
    #     available for allocations.
    #
    #   * The network border group for an Amazon Web Services Local Zone where
    #     you want this IPAM pool to be available for allocations ([supported
    #     Local Zones][1]). This option is only available for IPAM IPv4 pools
    #     in the public scope.
    #
    #   Possible values: Any Amazon Web Services Region or supported Amazon
    #   Web Services Local Zone. Default is `none` and means any locale.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#byoip-zone-avail
    #
    # @option params [String] :source_ipam_pool_id
    #   The ID of the source IPAM pool. Use this option to create a pool
    #   within an existing pool. Note that the CIDR you provision for the pool
    #   within the source pool must be available in the source pool's CIDR
    #   range.
    #
    # @option params [String] :description
    #   A description for the IPAM pool.
    #
    # @option params [required, String] :address_family
    #   The IP protocol assigned to this IPAM pool. You must choose either
    #   IPv4 or IPv6 protocol for a pool.
    #
    # @option params [Boolean] :auto_import
    #   If selected, IPAM will continuously look for resources within the CIDR
    #   range of this pool and automatically import them as allocations into
    #   your IPAM. The CIDRs that will be allocated for these resources must
    #   not already be allocated to other resources in order for the import to
    #   succeed. IPAM will import a CIDR regardless of its compliance with the
    #   pool's allocation rules, so a resource might be imported and
    #   subsequently marked as noncompliant. If IPAM discovers multiple CIDRs
    #   that overlap, IPAM will import the largest CIDR only. If IPAM
    #   discovers multiple CIDRs with matching CIDRs, IPAM will randomly
    #   import one of them only.
    #
    #   A locale must be set on the pool for this feature to work.
    #
    # @option params [Boolean] :publicly_advertisable
    #   Determines if the pool is publicly advertisable. The request can only
    #   contain `PubliclyAdvertisable` if `AddressFamily` is `ipv6` and
    #   `PublicIpSource` is `byoip`.
    #
    # @option params [Integer] :allocation_min_netmask_length
    #   The minimum netmask length required for CIDR allocations in this IPAM
    #   pool to be compliant. The minimum netmask length must be less than the
    #   maximum netmask length. Possible netmask lengths for IPv4 addresses
    #   are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.
    #
    # @option params [Integer] :allocation_max_netmask_length
    #   The maximum netmask length possible for CIDR allocations in this IPAM
    #   pool to be compliant. The maximum netmask length must be greater than
    #   the minimum netmask length. Possible netmask lengths for IPv4
    #   addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are
    #   0 - 128.
    #
    # @option params [Integer] :allocation_default_netmask_length
    #   The default netmask length for allocations added to this pool. If, for
    #   example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16
    #   here, new allocations will default to 10.0.0.0/16.
    #
    # @option params [Array<Types::RequestIpamResourceTag>] :allocation_resource_tags
    #   Tags that are required for resources that use CIDRs from this IPAM
    #   pool. Resources that do not have these tags will not be allowed to
    #   allocate space from the pool. If the resources have their tags changed
    #   after they have allocated space or if the allocation tagging
    #   requirements are changed on the pool, the resource may be marked as
    #   noncompliant.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The key/value combination of a tag assigned to the resource. Use the
    #   tag key in the filter name and the tag value as the filter value. For
    #   example, to find all resources that have a tag with the key `Owner`
    #   and the value `TeamA`, specify `tag:Owner` for the filter name and
    #   `TeamA` for the filter value.
    #
    # @option params [String] :client_token
    #   A unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [String] :aws_service
    #   Limits which service in Amazon Web Services that the pool can be used
    #   in. "ec2", for example, allows users to use space for Elastic IP
    #   addresses and VPCs.
    #
    # @option params [String] :public_ip_source
    #   The IP address source for pools in the public scope. Only used for
    #   provisioning IP address CIDRs to pools in the public scope. Default is
    #   `byoip`. For more information, see [Create IPv6 pools][1] in the
    #   *Amazon VPC IPAM User Guide*. By default, you can add only one
    #   Amazon-provided IPv6 CIDR block to a top-level IPv6 pool if
    #   PublicIpSource is `amazon`. For information on increasing the default
    #   limit, see [ Quotas for your IPAM][2] in the *Amazon VPC IPAM User
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/ipam/intro-create-ipv6-pools.html
    #   [2]: https://docs.aws.amazon.com/vpc/latest/ipam/quotas-ipam.html
    #
    # @option params [Types::IpamPoolSourceResourceRequest] :source_resource
    #   The resource used to provision CIDRs to a resource planning pool.
    #
    # @return [Types::CreateIpamPoolResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateIpamPoolResult#ipam_pool #ipam_pool} => Types::IpamPool
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_ipam_pool({
    #     dry_run: false,
    #     ipam_scope_id: "IpamScopeId", # required
    #     locale: "String",
    #     source_ipam_pool_id: "IpamPoolId",
    #     description: "String",
    #     address_family: "ipv4", # required, accepts ipv4, ipv6
    #     auto_import: false,
    #     publicly_advertisable: false,
    #     allocation_min_netmask_length: 1,
    #     allocation_max_netmask_length: 1,
    #     allocation_default_netmask_length: 1,
    #     allocation_resource_tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     client_token: "String",
    #     aws_service: "ec2", # accepts ec2
    #     public_ip_source: "amazon", # accepts amazon, byoip
    #     source_resource: {
    #       resource_id: "String",
    #       resource_type: "vpc", # accepts vpc
    #       resource_region: "String",
    #       resource_owner: "String",
    #     },
    #   })
    #
    # @example Response structure
    #
    #   resp.ipam_pool.owner_id #=> String
    #   resp.ipam_pool.ipam_pool_id #=> String
    #   resp.ipam_pool.source_ipam_pool_id #=> String
    #   resp.ipam_pool.ipam_pool_arn #=> String
    #   resp.ipam_pool.ipam_scope_arn #=> String
    #   resp.ipam_pool.ipam_scope_type #=> String, one of "public", "private"
    #   resp.ipam_pool.ipam_arn #=> String
    #   resp.ipam_pool.ipam_region #=> String
    #   resp.ipam_pool.locale #=> String
    #   resp.ipam_pool.pool_depth #=> Integer
    #   resp.ipam_pool.state #=> String, one of "create-in-progress", "create-complete", "create-failed", "modify-in-progress", "modify-complete", "modify-failed", "delete-in-progress", "delete-complete", "delete-failed", "isolate-in-progress", "isolate-complete", "restore-in-progress"
    #   resp.ipam_pool.state_message #=> String
    #   resp.ipam_pool.description #=> String
    #   resp.ipam_pool.auto_import #=> Boolean
    #   resp.ipam_pool.publicly_advertisable #=> Boolean
    #   resp.ipam_pool.address_family #=> String, one of "ipv4", "ipv6"
    #   resp.ipam_pool.allocation_min_netmask_length #=> Integer
    #   resp.ipam_pool.allocation_max_netmask_length #=> Integer
    #   resp.ipam_pool.allocation_default_netmask_length #=> Integer
    #   resp.ipam_pool.allocation_resource_tags #=> Array
    #   resp.ipam_pool.allocation_resource_tags[0].key #=> String
    #   resp.ipam_pool.allocation_resource_tags[0].value #=> String
    #   resp.ipam_pool.tags #=> Array
    #   resp.ipam_pool.tags[0].key #=> String
    #   resp.ipam_pool.tags[0].value #=> String
    #   resp.ipam_pool.aws_service #=> String, one of "ec2"
    #   resp.ipam_pool.public_ip_source #=> String, one of "amazon", "byoip"
    #   resp.ipam_pool.source_resource.resource_id #=> String
    #   resp.ipam_pool.source_resource.resource_type #=> String, one of "vpc"
    #   resp.ipam_pool.source_resource.resource_region #=> String
    #   resp.ipam_pool.source_resource.resource_owner #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamPool AWS API Documentation
    #
    # @overload create_ipam_pool(params = {})
    # @param [Hash] params ({})
    def create_ipam_pool(params = {}, options = {})
      req = build_request(:create_ipam_pool, params)
      req.send_request(options)
    end

    # Creates an IPAM resource discovery. A resource discovery is an IPAM
    # component that enables IPAM to manage and monitor resources that
    # belong to the owning account.
    #
    # @option params [Boolean] :dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response. If
    #   you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :description
    #   A description for the IPAM resource discovery.
    #
    # @option params [Array<Types::AddIpamOperatingRegion>] :operating_regions
    #   Operating Regions for the IPAM resource discovery. Operating Regions
    #   are Amazon Web Services Regions where the IPAM is allowed to manage IP
    #   address CIDRs. IPAM only discovers and monitors resources in the
    #   Amazon Web Services Regions you select as operating Regions.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   Tag specifications for the IPAM resource discovery.
    #
    # @option params [String] :client_token
    #   A client token for the IPAM resource discovery.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    # @return [Types::CreateIpamResourceDiscoveryResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateIpamResourceDiscoveryResult#ipam_resource_discovery #ipam_resource_discovery} => Types::IpamResourceDiscovery
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_ipam_resource_discovery({
    #     dry_run: false,
    #     description: "String",
    #     operating_regions: [
    #       {
    #         region_name: "String",
    #       },
    #     ],
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.ipam_resource_discovery.owner_id #=> String
    #   resp.ipam_resource_discovery.ipam_resource_discovery_id #=> String
    #   resp.ipam_resource_discovery.ipam_resource_discovery_arn #=> String
    #   resp.ipam_resource_discovery.ipam_resource_discovery_region #=> String
    #   resp.ipam_resource_discovery.description #=> String
    #   resp.ipam_resource_discovery.operating_regions #=> Array
    #   resp.ipam_resource_discovery.operating_regions[0].region_name #=> String
    #   resp.ipam_resource_discovery.is_default #=> Boolean
    #   resp.ipam_resource_discovery.state #=> String, one of "create-in-progress", "create-complete", "create-failed", "modify-in-progress", "modify-complete", "modify-failed", "delete-in-progress", "delete-complete", "delete-failed", "isolate-in-progress", "isolate-complete", "restore-in-progress"
    #   resp.ipam_resource_discovery.tags #=> Array
    #   resp.ipam_resource_discovery.tags[0].key #=> String
    #   resp.ipam_resource_discovery.tags[0].value #=> String
    #   resp.ipam_resource_discovery.organizational_unit_exclusions #=> Array
    #   resp.ipam_resource_discovery.organizational_unit_exclusions[0].organizations_entity_path #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamResourceDiscovery AWS API Documentation
    #
    # @overload create_ipam_resource_discovery(params = {})
    # @param [Hash] params ({})
    def create_ipam_resource_discovery(params = {}, options = {})
      req = build_request(:create_ipam_resource_discovery, params)
      req.send_request(options)
    end

    # Create an IPAM scope. In IPAM, a scope is the highest-level container
    # within IPAM. An IPAM contains two default scopes. Each scope
    # represents the IP space for a single network. The private scope is
    # intended for all private IP address space. The public scope is
    # intended for all public IP address space. Scopes enable you to reuse
    # IP addresses across multiple unconnected networks without causing IP
    # address overlap or conflict.
    #
    # For more information, see [Add a scope][1] in the *Amazon VPC IPAM
    # User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/ipam/add-scope-ipam.html
    #
    # @option params [Boolean] :dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response. If
    #   you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :ipam_id
    #   The ID of the IPAM for which you're creating this scope.
    #
    # @option params [String] :description
    #   A description for the scope you're creating.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The key/value combination of a tag assigned to the resource. Use the
    #   tag key in the filter name and the tag value as the filter value. For
    #   example, to find all resources that have a tag with the key `Owner`
    #   and the value `TeamA`, specify `tag:Owner` for the filter name and
    #   `TeamA` for the filter value.
    #
    # @option params [String] :client_token
    #   A unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @return [Types::CreateIpamScopeResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateIpamScopeResult#ipam_scope #ipam_scope} => Types::IpamScope
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_ipam_scope({
    #     dry_run: false,
    #     ipam_id: "IpamId", # required
    #     description: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.ipam_scope.owner_id #=> String
    #   resp.ipam_scope.ipam_scope_id #=> String
    #   resp.ipam_scope.ipam_scope_arn #=> String
    #   resp.ipam_scope.ipam_arn #=> String
    #   resp.ipam_scope.ipam_region #=> String
    #   resp.ipam_scope.ipam_scope_type #=> String, one of "public", "private"
    #   resp.ipam_scope.is_default #=> Boolean
    #   resp.ipam_scope.description #=> String
    #   resp.ipam_scope.pool_count #=> Integer
    #   resp.ipam_scope.state #=> String, one of "create-in-progress", "create-complete", "create-failed", "modify-in-progress", "modify-complete", "modify-failed", "delete-in-progress", "delete-complete", "delete-failed", "isolate-in-progress", "isolate-complete", "restore-in-progress"
    #   resp.ipam_scope.tags #=> Array
    #   resp.ipam_scope.tags[0].key #=> String
    #   resp.ipam_scope.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateIpamScope AWS API Documentation
    #
    # @overload create_ipam_scope(params = {})
    # @param [Hash] params ({})
    def create_ipam_scope(params = {}, options = {})
      req = build_request(:create_ipam_scope, params)
      req.send_request(options)
    end

    # Creates an ED25519 or 2048-bit RSA key pair with the specified name
    # and in the specified format. Amazon EC2 stores the public key and
    # displays the private key for you to save to a file. The private key is
    # returned as an unencrypted PEM encoded PKCS#1 private key or an
    # unencrypted PPK formatted private key for use with PuTTY. If a key
    # with the specified name already exists, Amazon EC2 returns an error.
    #
    # The key pair returned to you is available only in the Amazon Web
    # Services Region in which you create it. If you prefer, you can create
    # your own key pair using a third-party tool and upload it to any Region
    # using ImportKeyPair.
    #
    # You can have up to 5,000 key pairs per Amazon Web Services Region.
    #
    # For more information, see [Amazon EC2 key pairs][1] in the *Amazon EC2
    # User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html
    #
    # @option params [required, String] :key_name
    #   A unique name for the key pair.
    #
    #   Constraints: Up to 255 ASCII characters
    #
    # @option params [String] :key_type
    #   The type of key pair. Note that ED25519 keys are not supported for
    #   Windows instances.
    #
    #   Default: `rsa`
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the new key pair.
    #
    # @option params [String] :key_format
    #   The format of the key pair.
    #
    #   Default: `pem`
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::KeyPair] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::KeyPair#key_pair_id #key_pair_id} => String
    #   * {Types::KeyPair#tags #tags} => Array&lt;Types::Tag&gt;
    #   * {Types::KeyPair#key_name #key_name} => String
    #   * {Types::KeyPair#key_fingerprint #key_fingerprint} => String
    #   * {Types::KeyPair#key_material #key_material} => String
    #
    #
    # @example Example: To create a key pair
    #
    #   # This example creates a key pair named my-key-pair.
    #
    #   resp = client.create_key_pair({
    #     key_name: "my-key-pair", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_key_pair({
    #     key_name: "String", # required
    #     key_type: "rsa", # accepts rsa, ed25519
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     key_format: "pem", # accepts pem, ppk
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.key_pair_id #=> String
    #   resp.tags #=> Array
    #   resp.tags[0].key #=> String
    #   resp.tags[0].value #=> String
    #   resp.key_name #=> String
    #   resp.key_fingerprint #=> String
    #   resp.key_material #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPair AWS API Documentation
    #
    # @overload create_key_pair(params = {})
    # @param [Hash] params ({})
    def create_key_pair(params = {}, options = {})
      req = build_request(:create_key_pair, params)
      req.send_request(options)
    end

    # Creates a launch template.
    #
    # A launch template contains the parameters to launch an instance. When
    # you launch an instance using RunInstances, you can specify a launch
    # template instead of providing the launch parameters in the request.
    # For more information, see [Store instance launch parameters in Amazon
    # EC2 launch templates][1] in the *Amazon EC2 User Guide*.
    #
    # To clone an existing launch template as the basis for a new launch
    # template, use the Amazon EC2 console. The API, SDKs, and CLI do not
    # support cloning a template. For more information, see [Create a launch
    # template from an existing launch template][2] in the *Amazon EC2 User
    # Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#create-launch-template-from-existing-launch-template
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. If a client token isn't specified, a
    #   randomly generated token is used in the request to ensure idempotency.
    #
    #   For more information, see [Ensuring idempotency][1].
    #
    #   Constraint: Maximum 128 ASCII characters.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [required, String] :launch_template_name
    #   A name for the launch template.
    #
    # @option params [String] :version_description
    #   A description for the first version of the launch template.
    #
    # @option params [required, Types::RequestLaunchTemplateData] :launch_template_data
    #   The information for the launch template.
    #
    # @option params [Types::OperatorRequest] :operator
    #   Reserved for internal use.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the launch template on creation. To tag the
    #   launch template, the resource type must be `launch-template`.
    #
    #   To specify the tags for the resources that are created when an
    #   instance is launched, you must use the `TagSpecifications` parameter
    #   in the [launch template data][1] structure.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestLaunchTemplateData.html
    #
    # @return [Types::CreateLaunchTemplateResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateLaunchTemplateResult#launch_template #launch_template} => Types::LaunchTemplate
    #   * {Types::CreateLaunchTemplateResult#warning #warning} => Types::ValidationWarning
    #
    #
    # @example Example: To create a launch template
    #
    #   # This example creates a launch template that specifies the subnet in which to launch the instance, assigns a public IP
    #   # address and an IPv6 address to the instance, and creates a tag for the instance.
    #
    #   resp = client.create_launch_template({
    #     launch_template_data: {
    #       image_id: "ami-8c1be5f6", 
    #       instance_type: "t2.small", 
    #       network_interfaces: [
    #         {
    #           associate_public_ip_address: true, 
    #           device_index: 0, 
    #           ipv_6_address_count: 1, 
    #           subnet_id: "subnet-7b16de0c", 
    #         }, 
    #       ], 
    #       tag_specifications: [
    #         {
    #           resource_type: "instance", 
    #           tags: [
    #             {
    #               key: "Name", 
    #               value: "webserver", 
    #             }, 
    #           ], 
    #         }, 
    #       ], 
    #     }, 
    #     launch_template_name: "my-template", 
    #     version_description: "WebVersion1", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     launch_template: {
    #       create_time: Time.parse("2017-11-27T09:13:24.000Z"), 
    #       created_by: "arn:aws:iam::123456789012:root", 
    #       default_version_number: 1, 
    #       latest_version_number: 1, 
    #       launch_template_id: "lt-01238c059e3466abc", 
    #       launch_template_name: "my-template", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_launch_template({
    #     dry_run: false,
    #     client_token: "String",
    #     launch_template_name: "LaunchTemplateName", # required
    #     version_description: "VersionDescription",
    #     launch_template_data: { # required
    #       kernel_id: "KernelId",
    #       ebs_optimized: false,
    #       iam_instance_profile: {
    #         arn: "String",
    #         name: "String",
    #       },
    #       block_device_mappings: [
    #         {
    #           device_name: "String",
    #           virtual_name: "String",
    #           ebs: {
    #             encrypted: false,
    #             delete_on_termination: false,
    #             iops: 1,
    #             kms_key_id: "KmsKeyId",
    #             snapshot_id: "SnapshotId",
    #             volume_size: 1,
    #             volume_type: "standard", # accepts standard, io1, io2, gp2, sc1, st1, gp3
    #             throughput: 1,
    #             volume_initialization_rate: 1,
    #           },
    #           no_device: "String",
    #         },
    #       ],
    #       network_interfaces: [
    #         {
    #           associate_carrier_ip_address: false,
    #           associate_public_ip_address: false,
    #           delete_on_termination: false,
    #           description: "String",
    #           device_index: 1,
    #           groups: ["SecurityGroupId"],
    #           interface_type: "String",
    #           ipv_6_address_count: 1,
    #           ipv_6_addresses: [
    #             {
    #               ipv_6_address: "String",
    #             },
    #           ],
    #           network_interface_id: "NetworkInterfaceId",
    #           private_ip_address: "String",
    #           private_ip_addresses: [
    #             {
    #               primary: false,
    #               private_ip_address: "String",
    #             },
    #           ],
    #           secondary_private_ip_address_count: 1,
    #           subnet_id: "SubnetId",
    #           network_card_index: 1,
    #           ipv_4_prefixes: [
    #             {
    #               ipv_4_prefix: "String",
    #             },
    #           ],
    #           ipv_4_prefix_count: 1,
    #           ipv_6_prefixes: [
    #             {
    #               ipv_6_prefix: "String",
    #             },
    #           ],
    #           ipv_6_prefix_count: 1,
    #           primary_ipv_6: false,
    #           ena_srd_specification: {
    #             ena_srd_enabled: false,
    #             ena_srd_udp_specification: {
    #               ena_srd_udp_enabled: false,
    #             },
    #           },
    #           connection_tracking_specification: {
    #             tcp_established_timeout: 1,
    #             udp_stream_timeout: 1,
    #             udp_timeout: 1,
    #           },
    #           ena_queue_count: 1,
    #         },
    #       ],
    #       image_id: "ImageId",
    #       instance_type: "a1.medium", # accepts a1.medium, a1.large, a1.xlarge, a1.2xlarge, a1.4xlarge, a1.metal, c1.medium, c1.xlarge, c3.large, c3.xlarge, c3.2xlarge, c3.4xlarge, c3.8xlarge, c4.large, c4.xlarge, c4.2xlarge, c4.4xlarge, c4.8xlarge, c5.large, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.12xlarge, c5.18xlarge, c5.24xlarge, c5.metal, c5a.large, c5a.xlarge, c5a.2xlarge, c5a.4xlarge, c5a.8xlarge, c5a.12xlarge, c5a.16xlarge, c5a.24xlarge, c5ad.large, c5ad.xlarge, c5ad.2xlarge, c5ad.4xlarge, c5ad.8xlarge, c5ad.12xlarge, c5ad.16xlarge, c5ad.24xlarge, c5d.large, c5d.xlarge, c5d.2xlarge, c5d.4xlarge, c5d.9xlarge, c5d.12xlarge, c5d.18xlarge, c5d.24xlarge, c5d.metal, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge, c5n.metal, c6g.medium, c6g.large, c6g.xlarge, c6g.2xlarge, c6g.4xlarge, c6g.8xlarge, c6g.12xlarge, c6g.16xlarge, c6g.metal, c6gd.medium, c6gd.large, c6gd.xlarge, c6gd.2xlarge, c6gd.4xlarge, c6gd.8xlarge, c6gd.12xlarge, c6gd.16xlarge, c6gd.metal, c6gn.medium, c6gn.large, c6gn.xlarge, c6gn.2xlarge, c6gn.4xlarge, c6gn.8xlarge, c6gn.12xlarge, c6gn.16xlarge, c6i.large, c6i.xlarge, c6i.2xlarge, c6i.4xlarge, c6i.8xlarge, c6i.12xlarge, c6i.16xlarge, c6i.24xlarge, c6i.32xlarge, c6i.metal, cc1.4xlarge, cc2.8xlarge, cg1.4xlarge, cr1.8xlarge, d2.xlarge, d2.2xlarge, d2.4xlarge, d2.8xlarge, d3.xlarge, d3.2xlarge, d3.4xlarge, d3.8xlarge, d3en.xlarge, d3en.2xlarge, d3en.4xlarge, d3en.6xlarge, d3en.8xlarge, d3en.12xlarge, dl1.24xlarge, f1.2xlarge, f1.4xlarge, f1.16xlarge, g2.2xlarge, g2.8xlarge, g3.4xlarge, g3.8xlarge, g3.16xlarge, g3s.xlarge, g4ad.xlarge, g4ad.2xlarge, g4ad.4xlarge, g4ad.8xlarge, g4ad.16xlarge, g4dn.xlarge, g4dn.2xlarge, g4dn.4xlarge, g4dn.8xlarge, g4dn.12xlarge, g4dn.16xlarge, g4dn.metal, g5.xlarge, g5.2xlarge, g5.4xlarge, g5.8xlarge, g5.12xlarge, g5.16xlarge, g5.24xlarge, g5.48xlarge, g5g.xlarge, g5g.2xlarge, g5g.4xlarge, g5g.8xlarge, g5g.16xlarge, g5g.metal, hi1.4xlarge, hpc6a.48xlarge, hs1.8xlarge, h1.2xlarge, h1.4xlarge, h1.8xlarge, h1.16xlarge, i2.xlarge, i2.2xlarge, i2.4xlarge, i2.8xlarge, i3.large, i3.xlarge, i3.2xlarge, i3.4xlarge, i3.8xlarge, i3.16xlarge, i3.metal, i3en.large, i3en.xlarge, i3en.2xlarge, i3en.3xlarge, i3en.6xlarge, i3en.12xlarge, i3en.24xlarge, i3en.metal, im4gn.large, im4gn.xlarge, im4gn.2xlarge, im4gn.4xlarge, im4gn.8xlarge, im4gn.16xlarge, inf1.xlarge, inf1.2xlarge, inf1.6xlarge, inf1.24xlarge, is4gen.medium, is4gen.large, is4gen.xlarge, is4gen.2xlarge, is4gen.4xlarge, is4gen.8xlarge, m1.small, m1.medium, m1.large, m1.xlarge, m2.xlarge, m2.2xlarge, m2.4xlarge, m3.medium, m3.large, m3.xlarge, m3.2xlarge, m4.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m4.10xlarge, m4.16xlarge, m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.8xlarge, m5.12xlarge, m5.16xlarge, m5.24xlarge, m5.metal, m5a.large, m5a.xlarge, m5a.2xlarge, m5a.4xlarge, m5a.8xlarge, m5a.12xlarge, m5a.16xlarge, m5a.24xlarge, m5ad.large, m5ad.xlarge, m5ad.2xlarge, m5ad.4xlarge, m5ad.8xlarge, m5ad.12xlarge, m5ad.16xlarge, m5ad.24xlarge, m5d.large, m5d.xlarge, m5d.2xlarge, m5d.4xlarge, m5d.8xlarge, m5d.12xlarge, m5d.16xlarge, m5d.24xlarge, m5d.metal, m5dn.large, m5dn.xlarge, m5dn.2xlarge, m5dn.4xlarge, m5dn.8xlarge, m5dn.12xlarge, m5dn.16xlarge, m5dn.24xlarge, m5dn.metal, m5n.large, m5n.xlarge, m5n.2xlarge, m5n.4xlarge, m5n.8xlarge, m5n.12xlarge, m5n.16xlarge, m5n.24xlarge, m5n.metal, m5zn.large, m5zn.xlarge, m5zn.2xlarge, m5zn.3xlarge, m5zn.6xlarge, m5zn.12xlarge, m5zn.metal, m6a.large, m6a.xlarge, m6a.2xlarge, m6a.4xlarge, m6a.8xlarge, m6a.12xlarge, m6a.16xlarge, m6a.24xlarge, m6a.32xlarge, m6a.48xlarge, m6g.metal, m6g.medium, m6g.large, m6g.xlarge, m6g.2xlarge, m6g.4xlarge, m6g.8xlarge, m6g.12xlarge, m6g.16xlarge, m6gd.metal, m6gd.medium, m6gd.large, m6gd.xlarge, m6gd.2xlarge, m6gd.4xlarge, m6gd.8xlarge, m6gd.12xlarge, m6gd.16xlarge, m6i.large, m6i.xlarge, m6i.2xlarge, m6i.4xlarge, m6i.8xlarge, m6i.12xlarge, m6i.16xlarge, m6i.24xlarge, m6i.32xlarge, m6i.metal, mac1.metal, p2.xlarge, p2.8xlarge, p2.16xlarge, p3.2xlarge, p3.8xlarge, p3.16xlarge, p3dn.24xlarge, p4d.24xlarge, r3.large, r3.xlarge, r3.2xlarge, r3.4xlarge, r3.8xlarge, r4.large, r4.xlarge, r4.2xlarge, r4.4xlarge, r4.8xlarge, r4.16xlarge, r5.large, r5.xlarge, r5.2xlarge, r5.4xlarge, r5.8xlarge, r5.12xlarge, r5.16xlarge, r5.24xlarge, r5.metal, r5a.large, r5a.xlarge, r5a.2xlarge, r5a.4xlarge, r5a.8xlarge, r5a.12xlarge, r5a.16xlarge, r5a.24xlarge, r5ad.large, r5ad.xlarge, r5ad.2xlarge, r5ad.4xlarge, r5ad.8xlarge, r5ad.12xlarge, r5ad.16xlarge, r5ad.24xlarge, r5b.large, r5b.xlarge, r5b.2xlarge, r5b.4xlarge, r5b.8xlarge, r5b.12xlarge, r5b.16xlarge, r5b.24xlarge, r5b.metal, r5d.large, r5d.xlarge, r5d.2xlarge, r5d.4xlarge, r5d.8xlarge, r5d.12xlarge, r5d.16xlarge, r5d.24xlarge, r5d.metal, r5dn.large, r5dn.xlarge, r5dn.2xlarge, r5dn.4xlarge, r5dn.8xlarge, r5dn.12xlarge, r5dn.16xlarge, r5dn.24xlarge, r5dn.metal, r5n.large, r5n.xlarge, r5n.2xlarge, r5n.4xlarge, r5n.8xlarge, r5n.12xlarge, r5n.16xlarge, r5n.24xlarge, r5n.metal, r6g.medium, r6g.large, r6g.xlarge, r6g.2xlarge, r6g.4xlarge, r6g.8xlarge, r6g.12xlarge, r6g.16xlarge, r6g.metal, r6gd.medium, r6gd.large, r6gd.xlarge, r6gd.2xlarge, r6gd.4xlarge, r6gd.8xlarge, r6gd.12xlarge, r6gd.16xlarge, r6gd.metal, r6i.large, r6i.xlarge, r6i.2xlarge, r6i.4xlarge, r6i.8xlarge, r6i.12xlarge, r6i.16xlarge, r6i.24xlarge, r6i.32xlarge, r6i.metal, t1.micro, t2.nano, t2.micro, t2.small, t2.medium, t2.large, t2.xlarge, t2.2xlarge, t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge, t3a.nano, t3a.micro, t3a.small, t3a.medium, t3a.large, t3a.xlarge, t3a.2xlarge, t4g.nano, t4g.micro, t4g.small, t4g.medium, t4g.large, t4g.xlarge, t4g.2xlarge, u-6tb1.56xlarge, u-6tb1.112xlarge, u-9tb1.112xlarge, u-12tb1.112xlarge, u-6tb1.metal, u-9tb1.metal, u-12tb1.metal, u-18tb1.metal, u-24tb1.metal, vt1.3xlarge, vt1.6xlarge, vt1.24xlarge, x1.16xlarge, x1.32xlarge, x1e.xlarge, x1e.2xlarge, x1e.4xlarge, x1e.8xlarge, x1e.16xlarge, x1e.32xlarge, x2iezn.2xlarge, x2iezn.4xlarge, x2iezn.6xlarge, x2iezn.8xlarge, x2iezn.12xlarge, x2iezn.metal, x2gd.medium, x2gd.large, x2gd.xlarge, x2gd.2xlarge, x2gd.4xlarge, x2gd.8xlarge, x2gd.12xlarge, x2gd.16xlarge, x2gd.metal, z1d.large, z1d.xlarge, z1d.2xlarge, z1d.3xlarge, z1d.6xlarge, z1d.12xlarge, z1d.metal, x2idn.16xlarge, x2idn.24xlarge, x2idn.32xlarge, x2iedn.xlarge, x2iedn.2xlarge, x2iedn.4xlarge, x2iedn.8xlarge, x2iedn.16xlarge, x2iedn.24xlarge, x2iedn.32xlarge, c6a.large, c6a.xlarge, c6a.2xlarge, c6a.4xlarge, c6a.8xlarge, c6a.12xlarge, c6a.16xlarge, c6a.24xlarge, c6a.32xlarge, c6a.48xlarge, c6a.metal, m6a.metal, i4i.large, i4i.xlarge, i4i.2xlarge, i4i.4xlarge, i4i.8xlarge, i4i.16xlarge, i4i.32xlarge, i4i.metal, x2idn.metal, x2iedn.metal, c7g.medium, c7g.large, c7g.xlarge, c7g.2xlarge, c7g.4xlarge, c7g.8xlarge, c7g.12xlarge, c7g.16xlarge, mac2.metal, c6id.large, c6id.xlarge, c6id.2xlarge, c6id.4xlarge, c6id.8xlarge, c6id.12xlarge, c6id.16xlarge, c6id.24xlarge, c6id.32xlarge, c6id.metal, m6id.large, m6id.xlarge, m6id.2xlarge, m6id.4xlarge, m6id.8xlarge, m6id.12xlarge, m6id.16xlarge, m6id.24xlarge, m6id.32xlarge, m6id.metal, r6id.large, r6id.xlarge, r6id.2xlarge, r6id.4xlarge, r6id.8xlarge, r6id.12xlarge, r6id.16xlarge, r6id.24xlarge, r6id.32xlarge, r6id.metal, r6a.large, r6a.xlarge, r6a.2xlarge, r6a.4xlarge, r6a.8xlarge, r6a.12xlarge, r6a.16xlarge, r6a.24xlarge, r6a.32xlarge, r6a.48xlarge, r6a.metal, p4de.24xlarge, u-3tb1.56xlarge, u-18tb1.112xlarge, u-24tb1.112xlarge, trn1.2xlarge, trn1.32xlarge, hpc6id.32xlarge, c6in.large, c6in.xlarge, c6in.2xlarge, c6in.4xlarge, c6in.8xlarge, c6in.12xlarge, c6in.16xlarge, c6in.24xlarge, c6in.32xlarge, m6in.large, m6in.xlarge, m6in.2xlarge, m6in.4xlarge, m6in.8xlarge, m6in.12xlarge, m6in.16xlarge, m6in.24xlarge, m6in.32xlarge, m6idn.large, m6idn.xlarge, m6idn.2xlarge, m6idn.4xlarge, m6idn.8xlarge, m6idn.12xlarge, m6idn.16xlarge, m6idn.24xlarge, m6idn.32xlarge, r6in.large, r6in.xlarge, r6in.2xlarge, r6in.4xlarge, r6in.8xlarge, r6in.12xlarge, r6in.16xlarge, r6in.24xlarge, r6in.32xlarge, r6idn.large, r6idn.xlarge, r6idn.2xlarge, r6idn.4xlarge, r6idn.8xlarge, r6idn.12xlarge, r6idn.16xlarge, r6idn.24xlarge, r6idn.32xlarge, c7g.metal, m7g.medium, m7g.large, m7g.xlarge, m7g.2xlarge, m7g.4xlarge, m7g.8xlarge, m7g.12xlarge, m7g.16xlarge, m7g.metal, r7g.medium, r7g.large, r7g.xlarge, r7g.2xlarge, r7g.4xlarge, r7g.8xlarge, r7g.12xlarge, r7g.16xlarge, r7g.metal, c6in.metal, m6in.metal, m6idn.metal, r6in.metal, r6idn.metal, inf2.xlarge, inf2.8xlarge, inf2.24xlarge, inf2.48xlarge, trn1n.32xlarge, i4g.large, i4g.xlarge, i4g.2xlarge, i4g.4xlarge, i4g.8xlarge, i4g.16xlarge, hpc7g.4xlarge, hpc7g.8xlarge, hpc7g.16xlarge, c7gn.medium, c7gn.large, c7gn.xlarge, c7gn.2xlarge, c7gn.4xlarge, c7gn.8xlarge, c7gn.12xlarge, c7gn.16xlarge, p5.48xlarge, m7i.large, m7i.xlarge, m7i.2xlarge, m7i.4xlarge, m7i.8xlarge, m7i.12xlarge, m7i.16xlarge, m7i.24xlarge, m7i.48xlarge, m7i-flex.large, m7i-flex.xlarge, m7i-flex.2xlarge, m7i-flex.4xlarge, m7i-flex.8xlarge, m7a.medium, m7a.large, m7a.xlarge, m7a.2xlarge, m7a.4xlarge, m7a.8xlarge, m7a.12xlarge, m7a.16xlarge, m7a.24xlarge, m7a.32xlarge, m7a.48xlarge, m7a.metal-48xl, hpc7a.12xlarge, hpc7a.24xlarge, hpc7a.48xlarge, hpc7a.96xlarge, c7gd.medium, c7gd.large, c7gd.xlarge, c7gd.2xlarge, c7gd.4xlarge, c7gd.8xlarge, c7gd.12xlarge, c7gd.16xlarge, m7gd.medium, m7gd.large, m7gd.xlarge, m7gd.2xlarge, m7gd.4xlarge, m7gd.8xlarge, m7gd.12xlarge, m7gd.16xlarge, r7gd.medium, r7gd.large, r7gd.xlarge, r7gd.2xlarge, r7gd.4xlarge, r7gd.8xlarge, r7gd.12xlarge, r7gd.16xlarge, r7a.medium, r7a.large, r7a.xlarge, r7a.2xlarge, r7a.4xlarge, r7a.8xlarge, r7a.12xlarge, r7a.16xlarge, r7a.24xlarge, r7a.32xlarge, r7a.48xlarge, c7i.large, c7i.xlarge, c7i.2xlarge, c7i.4xlarge, c7i.8xlarge, c7i.12xlarge, c7i.16xlarge, c7i.24xlarge, c7i.48xlarge, mac2-m2pro.metal, r7iz.large, r7iz.xlarge, r7iz.2xlarge, r7iz.4xlarge, r7iz.8xlarge, r7iz.12xlarge, r7iz.16xlarge, r7iz.32xlarge, c7a.medium, c7a.large, c7a.xlarge, c7a.2xlarge, c7a.4xlarge, c7a.8xlarge, c7a.12xlarge, c7a.16xlarge, c7a.24xlarge, c7a.32xlarge, c7a.48xlarge, c7a.metal-48xl, r7a.metal-48xl, r7i.large, r7i.xlarge, r7i.2xlarge, r7i.4xlarge, r7i.8xlarge, r7i.12xlarge, r7i.16xlarge, r7i.24xlarge, r7i.48xlarge, dl2q.24xlarge, mac2-m2.metal, i4i.12xlarge, i4i.24xlarge, c7i.metal-24xl, c7i.metal-48xl, m7i.metal-24xl, m7i.metal-48xl, r7i.metal-24xl, r7i.metal-48xl, r7iz.metal-16xl, r7iz.metal-32xl, c7gd.metal, m7gd.metal, r7gd.metal, g6.xlarge, g6.2xlarge, g6.4xlarge, g6.8xlarge, g6.12xlarge, g6.16xlarge, g6.24xlarge, g6.48xlarge, gr6.4xlarge, gr6.8xlarge, c7i-flex.large, c7i-flex.xlarge, c7i-flex.2xlarge, c7i-flex.4xlarge, c7i-flex.8xlarge, u7i-12tb.224xlarge, u7in-16tb.224xlarge, u7in-24tb.224xlarge, u7in-32tb.224xlarge, u7ib-12tb.224xlarge, c7gn.metal, r8g.medium, r8g.large, r8g.xlarge, r8g.2xlarge, r8g.4xlarge, r8g.8xlarge, r8g.12xlarge, r8g.16xlarge, r8g.24xlarge, r8g.48xlarge, r8g.metal-24xl, r8g.metal-48xl, mac2-m1ultra.metal, g6e.xlarge, g6e.2xlarge, g6e.4xlarge, g6e.8xlarge, g6e.12xlarge, g6e.16xlarge, g6e.24xlarge, g6e.48xlarge, c8g.medium, c8g.large, c8g.xlarge, c8g.2xlarge, c8g.4xlarge, c8g.8xlarge, c8g.12xlarge, c8g.16xlarge, c8g.24xlarge, c8g.48xlarge, c8g.metal-24xl, c8g.metal-48xl, m8g.medium, m8g.large, m8g.xlarge, m8g.2xlarge, m8g.4xlarge, m8g.8xlarge, m8g.12xlarge, m8g.16xlarge, m8g.24xlarge, m8g.48xlarge, m8g.metal-24xl, m8g.metal-48xl, x8g.medium, x8g.large, x8g.xlarge, x8g.2xlarge, x8g.4xlarge, x8g.8xlarge, x8g.12xlarge, x8g.16xlarge, x8g.24xlarge, x8g.48xlarge, x8g.metal-24xl, x8g.metal-48xl, i7ie.large, i7ie.xlarge, i7ie.2xlarge, i7ie.3xlarge, i7ie.6xlarge, i7ie.12xlarge, i7ie.18xlarge, i7ie.24xlarge, i7ie.48xlarge, i8g.large, i8g.xlarge, i8g.2xlarge, i8g.4xlarge, i8g.8xlarge, i8g.12xlarge, i8g.16xlarge, i8g.24xlarge, i8g.metal-24xl, u7i-6tb.112xlarge, u7i-8tb.112xlarge, u7inh-32tb.480xlarge, p5e.48xlarge, p5en.48xlarge, f2.12xlarge, f2.48xlarge, trn2.48xlarge, c7i-flex.12xlarge, c7i-flex.16xlarge, m7i-flex.12xlarge, m7i-flex.16xlarge, i7ie.metal-24xl, i7ie.metal-48xl, i8g.48xlarge, c8gd.medium, c8gd.large, c8gd.xlarge, c8gd.2xlarge, c8gd.4xlarge, c8gd.8xlarge, c8gd.12xlarge, c8gd.16xlarge, c8gd.24xlarge, c8gd.48xlarge, c8gd.metal-24xl, c8gd.metal-48xl, i7i.large, i7i.xlarge, i7i.2xlarge, i7i.4xlarge, i7i.8xlarge, i7i.12xlarge, i7i.16xlarge, i7i.24xlarge, i7i.48xlarge, i7i.metal-24xl, i7i.metal-48xl, p6-b200.48xlarge, m8gd.medium, m8gd.large, m8gd.xlarge, m8gd.2xlarge, m8gd.4xlarge, m8gd.8xlarge, m8gd.12xlarge, m8gd.16xlarge, m8gd.24xlarge, m8gd.48xlarge, m8gd.metal-24xl, m8gd.metal-48xl, r8gd.medium, r8gd.large, r8gd.xlarge, r8gd.2xlarge, r8gd.4xlarge, r8gd.8xlarge, r8gd.12xlarge, r8gd.16xlarge, r8gd.24xlarge, r8gd.48xlarge, r8gd.metal-24xl, r8gd.metal-48xl, c8gn.medium, c8gn.large, c8gn.xlarge, c8gn.2xlarge, c8gn.4xlarge, c8gn.8xlarge, c8gn.12xlarge, c8gn.16xlarge, c8gn.24xlarge, c8gn.48xlarge, c8gn.metal-24xl, c8gn.metal-48xl, f2.6xlarge, p6e-gb200.36xlarge
    #       key_name: "KeyPairName",
    #       monitoring: {
    #         enabled: false,
    #       },
    #       placement: {
    #         availability_zone: "String",
    #         availability_zone_id: "AvailabilityZoneId",
    #         affinity: "String",
    #         group_name: "PlacementGroupName",
    #         host_id: "DedicatedHostId",
    #         tenancy: "default", # accepts default, dedicated, host
    #         spread_domain: "String",
    #         host_resource_group_arn: "String",
    #         partition_number: 1,
    #         group_id: "PlacementGroupId",
    #       },
    #       ram_disk_id: "RamdiskId",
    #       disable_api_termination: false,
    #       instance_initiated_shutdown_behavior: "stop", # accepts stop, terminate
    #       user_data: "SensitiveUserData",
    #       tag_specifications: [
    #         {
    #           resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #           tags: [
    #             {
    #               key: "String",
    #               value: "String",
    #             },
    #           ],
    #         },
    #       ],
    #       elastic_gpu_specifications: [
    #         {
    #           type: "String", # required
    #         },
    #       ],
    #       elastic_inference_accelerators: [
    #         {
    #           type: "String", # required
    #           count: 1,
    #         },
    #       ],
    #       security_group_ids: ["SecurityGroupId"],
    #       security_groups: ["SecurityGroupName"],
    #       instance_market_options: {
    #         market_type: "spot", # accepts spot, capacity-block
    #         spot_options: {
    #           max_price: "String",
    #           spot_instance_type: "one-time", # accepts one-time, persistent
    #           block_duration_minutes: 1,
    #           valid_until: Time.now,
    #           instance_interruption_behavior: "hibernate", # accepts hibernate, stop, terminate
    #         },
    #       },
    #       credit_specification: {
    #         cpu_credits: "String", # required
    #       },
    #       cpu_options: {
    #         core_count: 1,
    #         threads_per_core: 1,
    #         amd_sev_snp: "enabled", # accepts enabled, disabled
    #       },
    #       capacity_reservation_specification: {
    #         capacity_reservation_preference: "capacity-reservations-only", # accepts capacity-reservations-only, open, none
    #         capacity_reservation_target: {
    #           capacity_reservation_id: "CapacityReservationId",
    #           capacity_reservation_resource_group_arn: "String",
    #         },
    #       },
    #       license_specifications: [
    #         {
    #           license_configuration_arn: "String",
    #         },
    #       ],
    #       hibernation_options: {
    #         configured: false,
    #       },
    #       metadata_options: {
    #         http_tokens: "optional", # accepts optional, required
    #         http_put_response_hop_limit: 1,
    #         http_endpoint: "disabled", # accepts disabled, enabled
    #         http_protocol_ipv_6: "disabled", # accepts disabled, enabled
    #         instance_metadata_tags: "disabled", # accepts disabled, enabled
    #       },
    #       enclave_options: {
    #         enabled: false,
    #       },
    #       instance_requirements: {
    #         v_cpu_count: { # required
    #           min: 1, # required
    #           max: 1,
    #         },
    #         memory_mi_b: { # required
    #           min: 1, # required
    #           max: 1,
    #         },
    #         cpu_manufacturers: ["intel"], # accepts intel, amd, amazon-web-services, apple
    #         memory_gi_b_per_v_cpu: {
    #           min: 1.0,
    #           max: 1.0,
    #         },
    #         excluded_instance_types: ["ExcludedInstanceType"],
    #         instance_generations: ["current"], # accepts current, previous
    #         spot_max_price_percentage_over_lowest_price: 1,
    #         on_demand_max_price_percentage_over_lowest_price: 1,
    #         bare_metal: "included", # accepts included, required, excluded
    #         burstable_performance: "included", # accepts included, required, excluded
    #         require_hibernate_support: false,
    #         network_interface_count: {
    #           min: 1,
    #           max: 1,
    #         },
    #         local_storage: "included", # accepts included, required, excluded
    #         local_storage_types: ["hdd"], # accepts hdd, ssd
    #         total_local_storage_gb: {
    #           min: 1.0,
    #           max: 1.0,
    #         },
    #         baseline_ebs_bandwidth_mbps: {
    #           min: 1,
    #           max: 1,
    #         },
    #         accelerator_types: ["gpu"], # accepts gpu, fpga, inference
    #         accelerator_count: {
    #           min: 1,
    #           max: 1,
    #         },
    #         accelerator_manufacturers: ["amazon-web-services"], # accepts amazon-web-services, amd, nvidia, xilinx, habana
    #         accelerator_names: ["a100"], # accepts a100, inferentia, k520, k80, m60, radeon-pro-v520, t4, vu9p, v100, a10g, h100, t4g
    #         accelerator_total_memory_mi_b: {
    #           min: 1,
    #           max: 1,
    #         },
    #         network_bandwidth_gbps: {
    #           min: 1.0,
    #           max: 1.0,
    #         },
    #         allowed_instance_types: ["AllowedInstanceType"],
    #         max_spot_price_as_percentage_of_optimal_on_demand_price: 1,
    #         baseline_performance_factors: {
    #           cpu: {
    #             references: [
    #               {
    #                 instance_family: "String",
    #               },
    #             ],
    #           },
    #         },
    #       },
    #       private_dns_name_options: {
    #         hostname_type: "ip-name", # accepts ip-name, resource-name
    #         enable_resource_name_dns_a_record: false,
    #         enable_resource_name_dns_aaaa_record: false,
    #       },
    #       maintenance_options: {
    #         auto_recovery: "default", # accepts default, disabled
    #       },
    #       disable_api_stop: false,
    #       operator: {
    #         principal: "String",
    #       },
    #       network_performance_options: {
    #         bandwidth_weighting: "default", # accepts default, vpc-1, ebs-1
    #       },
    #     },
    #     operator: {
    #       principal: "String",
    #     },
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.launch_template.launch_template_id #=> String
    #   resp.launch_template.launch_template_name #=> String
    #   resp.launch_template.create_time #=> Time
    #   resp.launch_template.created_by #=> String
    #   resp.launch_template.default_version_number #=> Integer
    #   resp.launch_template.latest_version_number #=> Integer
    #   resp.launch_template.tags #=> Array
    #   resp.launch_template.tags[0].key #=> String
    #   resp.launch_template.tags[0].value #=> String
    #   resp.launch_template.operator.managed #=> Boolean
    #   resp.launch_template.operator.principal #=> String
    #   resp.warning.errors #=> Array
    #   resp.warning.errors[0].code #=> String
    #   resp.warning.errors[0].message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplate AWS API Documentation
    #
    # @overload create_launch_template(params = {})
    # @param [Hash] params ({})
    def create_launch_template(params = {}, options = {})
      req = build_request(:create_launch_template, params)
      req.send_request(options)
    end

    # Creates a new version of a launch template. You must specify an
    # existing launch template, either by name or ID. You can determine
    # whether the new version inherits parameters from a source version, and
    # add or overwrite parameters as needed.
    #
    # Launch template versions are numbered in the order in which they are
    # created. You can't specify, change, or replace the numbering of
    # launch template versions.
    #
    # Launch templates are immutable; after you create a launch template,
    # you can't modify it. Instead, you can create a new version of the
    # launch template that includes the changes that you require.
    #
    # For more information, see [Modify a launch template (manage launch
    # template versions)][1] in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-launch-template-versions.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. If a client token isn't specified, a
    #   randomly generated token is used in the request to ensure idempotency.
    #
    #   For more information, see [Ensuring idempotency][1].
    #
    #   Constraint: Maximum 128 ASCII characters.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [String] :launch_template_id
    #   The ID of the launch template.
    #
    #   You must specify either the launch template ID or the launch template
    #   name, but not both.
    #
    # @option params [String] :launch_template_name
    #   The name of the launch template.
    #
    #   You must specify either the launch template ID or the launch template
    #   name, but not both.
    #
    # @option params [String] :source_version
    #   The version of the launch template on which to base the new version.
    #   Snapshots applied to the block device mapping are ignored when
    #   creating a new version unless they are explicitly included.
    #
    #   If you specify this parameter, the new version inherits the launch
    #   parameters from the source version. If you specify additional launch
    #   parameters for the new version, they overwrite any corresponding
    #   launch parameters inherited from the source version.
    #
    #   If you omit this parameter, the new version contains only the launch
    #   parameters that you specify for the new version.
    #
    # @option params [String] :version_description
    #   A description for the version of the launch template.
    #
    # @option params [required, Types::RequestLaunchTemplateData] :launch_template_data
    #   The information for the launch template.
    #
    # @option params [Boolean] :resolve_alias
    #   If `true`, and if a Systems Manager parameter is specified for
    #   `ImageId`, the AMI ID is displayed in the response for `imageID`. For
    #   more information, see [Use a Systems Manager parameter instead of an
    #   AMI ID][1] in the *Amazon EC2 User Guide*.
    #
    #   Default: `false`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/create-launch-template.html#use-an-ssm-parameter-instead-of-an-ami-id
    #
    # @return [Types::CreateLaunchTemplateVersionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateLaunchTemplateVersionResult#launch_template_version #launch_template_version} => Types::LaunchTemplateVersion
    #   * {Types::CreateLaunchTemplateVersionResult#warning #warning} => Types::ValidationWarning
    #
    #
    # @example Example: To create a launch template version
    #
    #   # This example creates a new launch template version based on version 1 of the specified launch template and specifies a
    #   # different AMI ID.
    #
    #   resp = client.create_launch_template_version({
    #     launch_template_data: {
    #       image_id: "ami-c998b6b2", 
    #     }, 
    #     launch_template_id: "lt-0abcd290751193123", 
    #     source_version: "1", 
    #     version_description: "WebVersion2", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     launch_template_version: {
    #       create_time: Time.parse("2017-12-01T13:35:46.000Z"), 
    #       created_by: "arn:aws:iam::123456789012:root", 
    #       default_version: false, 
    #       launch_template_data: {
    #         image_id: "ami-c998b6b2", 
    #         instance_type: "t2.micro", 
    #         network_interfaces: [
    #           {
    #             associate_public_ip_address: true, 
    #             device_index: 0, 
    #             ipv_6_addresses: [
    #               {
    #                 ipv_6_address: "2001:db8:1234:1a00::123", 
    #               }, 
    #             ], 
    #             subnet_id: "subnet-7b16de0c", 
    #           }, 
    #         ], 
    #       }, 
    #       launch_template_id: "lt-0abcd290751193123", 
    #       launch_template_name: "my-template", 
    #       version_description: "WebVersion2", 
    #       version_number: 2, 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_launch_template_version({
    #     dry_run: false,
    #     client_token: "String",
    #     launch_template_id: "LaunchTemplateId",
    #     launch_template_name: "LaunchTemplateName",
    #     source_version: "String",
    #     version_description: "VersionDescription",
    #     launch_template_data: { # required
    #       kernel_id: "KernelId",
    #       ebs_optimized: false,
    #       iam_instance_profile: {
    #         arn: "String",
    #         name: "String",
    #       },
    #       block_device_mappings: [
    #         {
    #           device_name: "String",
    #           virtual_name: "String",
    #           ebs: {
    #             encrypted: false,
    #             delete_on_termination: false,
    #             iops: 1,
    #             kms_key_id: "KmsKeyId",
    #             snapshot_id: "SnapshotId",
    #             volume_size: 1,
    #             volume_type: "standard", # accepts standard, io1, io2, gp2, sc1, st1, gp3
    #             throughput: 1,
    #             volume_initialization_rate: 1,
    #           },
    #           no_device: "String",
    #         },
    #       ],
    #       network_interfaces: [
    #         {
    #           associate_carrier_ip_address: false,
    #           associate_public_ip_address: false,
    #           delete_on_termination: false,
    #           description: "String",
    #           device_index: 1,
    #           groups: ["SecurityGroupId"],
    #           interface_type: "String",
    #           ipv_6_address_count: 1,
    #           ipv_6_addresses: [
    #             {
    #               ipv_6_address: "String",
    #             },
    #           ],
    #           network_interface_id: "NetworkInterfaceId",
    #           private_ip_address: "String",
    #           private_ip_addresses: [
    #             {
    #               primary: false,
    #               private_ip_address: "String",
    #             },
    #           ],
    #           secondary_private_ip_address_count: 1,
    #           subnet_id: "SubnetId",
    #           network_card_index: 1,
    #           ipv_4_prefixes: [
    #             {
    #               ipv_4_prefix: "String",
    #             },
    #           ],
    #           ipv_4_prefix_count: 1,
    #           ipv_6_prefixes: [
    #             {
    #               ipv_6_prefix: "String",
    #             },
    #           ],
    #           ipv_6_prefix_count: 1,
    #           primary_ipv_6: false,
    #           ena_srd_specification: {
    #             ena_srd_enabled: false,
    #             ena_srd_udp_specification: {
    #               ena_srd_udp_enabled: false,
    #             },
    #           },
    #           connection_tracking_specification: {
    #             tcp_established_timeout: 1,
    #             udp_stream_timeout: 1,
    #             udp_timeout: 1,
    #           },
    #           ena_queue_count: 1,
    #         },
    #       ],
    #       image_id: "ImageId",
    #       instance_type: "a1.medium", # accepts a1.medium, a1.large, a1.xlarge, a1.2xlarge, a1.4xlarge, a1.metal, c1.medium, c1.xlarge, c3.large, c3.xlarge, c3.2xlarge, c3.4xlarge, c3.8xlarge, c4.large, c4.xlarge, c4.2xlarge, c4.4xlarge, c4.8xlarge, c5.large, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.12xlarge, c5.18xlarge, c5.24xlarge, c5.metal, c5a.large, c5a.xlarge, c5a.2xlarge, c5a.4xlarge, c5a.8xlarge, c5a.12xlarge, c5a.16xlarge, c5a.24xlarge, c5ad.large, c5ad.xlarge, c5ad.2xlarge, c5ad.4xlarge, c5ad.8xlarge, c5ad.12xlarge, c5ad.16xlarge, c5ad.24xlarge, c5d.large, c5d.xlarge, c5d.2xlarge, c5d.4xlarge, c5d.9xlarge, c5d.12xlarge, c5d.18xlarge, c5d.24xlarge, c5d.metal, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge, c5n.metal, c6g.medium, c6g.large, c6g.xlarge, c6g.2xlarge, c6g.4xlarge, c6g.8xlarge, c6g.12xlarge, c6g.16xlarge, c6g.metal, c6gd.medium, c6gd.large, c6gd.xlarge, c6gd.2xlarge, c6gd.4xlarge, c6gd.8xlarge, c6gd.12xlarge, c6gd.16xlarge, c6gd.metal, c6gn.medium, c6gn.large, c6gn.xlarge, c6gn.2xlarge, c6gn.4xlarge, c6gn.8xlarge, c6gn.12xlarge, c6gn.16xlarge, c6i.large, c6i.xlarge, c6i.2xlarge, c6i.4xlarge, c6i.8xlarge, c6i.12xlarge, c6i.16xlarge, c6i.24xlarge, c6i.32xlarge, c6i.metal, cc1.4xlarge, cc2.8xlarge, cg1.4xlarge, cr1.8xlarge, d2.xlarge, d2.2xlarge, d2.4xlarge, d2.8xlarge, d3.xlarge, d3.2xlarge, d3.4xlarge, d3.8xlarge, d3en.xlarge, d3en.2xlarge, d3en.4xlarge, d3en.6xlarge, d3en.8xlarge, d3en.12xlarge, dl1.24xlarge, f1.2xlarge, f1.4xlarge, f1.16xlarge, g2.2xlarge, g2.8xlarge, g3.4xlarge, g3.8xlarge, g3.16xlarge, g3s.xlarge, g4ad.xlarge, g4ad.2xlarge, g4ad.4xlarge, g4ad.8xlarge, g4ad.16xlarge, g4dn.xlarge, g4dn.2xlarge, g4dn.4xlarge, g4dn.8xlarge, g4dn.12xlarge, g4dn.16xlarge, g4dn.metal, g5.xlarge, g5.2xlarge, g5.4xlarge, g5.8xlarge, g5.12xlarge, g5.16xlarge, g5.24xlarge, g5.48xlarge, g5g.xlarge, g5g.2xlarge, g5g.4xlarge, g5g.8xlarge, g5g.16xlarge, g5g.metal, hi1.4xlarge, hpc6a.48xlarge, hs1.8xlarge, h1.2xlarge, h1.4xlarge, h1.8xlarge, h1.16xlarge, i2.xlarge, i2.2xlarge, i2.4xlarge, i2.8xlarge, i3.large, i3.xlarge, i3.2xlarge, i3.4xlarge, i3.8xlarge, i3.16xlarge, i3.metal, i3en.large, i3en.xlarge, i3en.2xlarge, i3en.3xlarge, i3en.6xlarge, i3en.12xlarge, i3en.24xlarge, i3en.metal, im4gn.large, im4gn.xlarge, im4gn.2xlarge, im4gn.4xlarge, im4gn.8xlarge, im4gn.16xlarge, inf1.xlarge, inf1.2xlarge, inf1.6xlarge, inf1.24xlarge, is4gen.medium, is4gen.large, is4gen.xlarge, is4gen.2xlarge, is4gen.4xlarge, is4gen.8xlarge, m1.small, m1.medium, m1.large, m1.xlarge, m2.xlarge, m2.2xlarge, m2.4xlarge, m3.medium, m3.large, m3.xlarge, m3.2xlarge, m4.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m4.10xlarge, m4.16xlarge, m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.8xlarge, m5.12xlarge, m5.16xlarge, m5.24xlarge, m5.metal, m5a.large, m5a.xlarge, m5a.2xlarge, m5a.4xlarge, m5a.8xlarge, m5a.12xlarge, m5a.16xlarge, m5a.24xlarge, m5ad.large, m5ad.xlarge, m5ad.2xlarge, m5ad.4xlarge, m5ad.8xlarge, m5ad.12xlarge, m5ad.16xlarge, m5ad.24xlarge, m5d.large, m5d.xlarge, m5d.2xlarge, m5d.4xlarge, m5d.8xlarge, m5d.12xlarge, m5d.16xlarge, m5d.24xlarge, m5d.metal, m5dn.large, m5dn.xlarge, m5dn.2xlarge, m5dn.4xlarge, m5dn.8xlarge, m5dn.12xlarge, m5dn.16xlarge, m5dn.24xlarge, m5dn.metal, m5n.large, m5n.xlarge, m5n.2xlarge, m5n.4xlarge, m5n.8xlarge, m5n.12xlarge, m5n.16xlarge, m5n.24xlarge, m5n.metal, m5zn.large, m5zn.xlarge, m5zn.2xlarge, m5zn.3xlarge, m5zn.6xlarge, m5zn.12xlarge, m5zn.metal, m6a.large, m6a.xlarge, m6a.2xlarge, m6a.4xlarge, m6a.8xlarge, m6a.12xlarge, m6a.16xlarge, m6a.24xlarge, m6a.32xlarge, m6a.48xlarge, m6g.metal, m6g.medium, m6g.large, m6g.xlarge, m6g.2xlarge, m6g.4xlarge, m6g.8xlarge, m6g.12xlarge, m6g.16xlarge, m6gd.metal, m6gd.medium, m6gd.large, m6gd.xlarge, m6gd.2xlarge, m6gd.4xlarge, m6gd.8xlarge, m6gd.12xlarge, m6gd.16xlarge, m6i.large, m6i.xlarge, m6i.2xlarge, m6i.4xlarge, m6i.8xlarge, m6i.12xlarge, m6i.16xlarge, m6i.24xlarge, m6i.32xlarge, m6i.metal, mac1.metal, p2.xlarge, p2.8xlarge, p2.16xlarge, p3.2xlarge, p3.8xlarge, p3.16xlarge, p3dn.24xlarge, p4d.24xlarge, r3.large, r3.xlarge, r3.2xlarge, r3.4xlarge, r3.8xlarge, r4.large, r4.xlarge, r4.2xlarge, r4.4xlarge, r4.8xlarge, r4.16xlarge, r5.large, r5.xlarge, r5.2xlarge, r5.4xlarge, r5.8xlarge, r5.12xlarge, r5.16xlarge, r5.24xlarge, r5.metal, r5a.large, r5a.xlarge, r5a.2xlarge, r5a.4xlarge, r5a.8xlarge, r5a.12xlarge, r5a.16xlarge, r5a.24xlarge, r5ad.large, r5ad.xlarge, r5ad.2xlarge, r5ad.4xlarge, r5ad.8xlarge, r5ad.12xlarge, r5ad.16xlarge, r5ad.24xlarge, r5b.large, r5b.xlarge, r5b.2xlarge, r5b.4xlarge, r5b.8xlarge, r5b.12xlarge, r5b.16xlarge, r5b.24xlarge, r5b.metal, r5d.large, r5d.xlarge, r5d.2xlarge, r5d.4xlarge, r5d.8xlarge, r5d.12xlarge, r5d.16xlarge, r5d.24xlarge, r5d.metal, r5dn.large, r5dn.xlarge, r5dn.2xlarge, r5dn.4xlarge, r5dn.8xlarge, r5dn.12xlarge, r5dn.16xlarge, r5dn.24xlarge, r5dn.metal, r5n.large, r5n.xlarge, r5n.2xlarge, r5n.4xlarge, r5n.8xlarge, r5n.12xlarge, r5n.16xlarge, r5n.24xlarge, r5n.metal, r6g.medium, r6g.large, r6g.xlarge, r6g.2xlarge, r6g.4xlarge, r6g.8xlarge, r6g.12xlarge, r6g.16xlarge, r6g.metal, r6gd.medium, r6gd.large, r6gd.xlarge, r6gd.2xlarge, r6gd.4xlarge, r6gd.8xlarge, r6gd.12xlarge, r6gd.16xlarge, r6gd.metal, r6i.large, r6i.xlarge, r6i.2xlarge, r6i.4xlarge, r6i.8xlarge, r6i.12xlarge, r6i.16xlarge, r6i.24xlarge, r6i.32xlarge, r6i.metal, t1.micro, t2.nano, t2.micro, t2.small, t2.medium, t2.large, t2.xlarge, t2.2xlarge, t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge, t3a.nano, t3a.micro, t3a.small, t3a.medium, t3a.large, t3a.xlarge, t3a.2xlarge, t4g.nano, t4g.micro, t4g.small, t4g.medium, t4g.large, t4g.xlarge, t4g.2xlarge, u-6tb1.56xlarge, u-6tb1.112xlarge, u-9tb1.112xlarge, u-12tb1.112xlarge, u-6tb1.metal, u-9tb1.metal, u-12tb1.metal, u-18tb1.metal, u-24tb1.metal, vt1.3xlarge, vt1.6xlarge, vt1.24xlarge, x1.16xlarge, x1.32xlarge, x1e.xlarge, x1e.2xlarge, x1e.4xlarge, x1e.8xlarge, x1e.16xlarge, x1e.32xlarge, x2iezn.2xlarge, x2iezn.4xlarge, x2iezn.6xlarge, x2iezn.8xlarge, x2iezn.12xlarge, x2iezn.metal, x2gd.medium, x2gd.large, x2gd.xlarge, x2gd.2xlarge, x2gd.4xlarge, x2gd.8xlarge, x2gd.12xlarge, x2gd.16xlarge, x2gd.metal, z1d.large, z1d.xlarge, z1d.2xlarge, z1d.3xlarge, z1d.6xlarge, z1d.12xlarge, z1d.metal, x2idn.16xlarge, x2idn.24xlarge, x2idn.32xlarge, x2iedn.xlarge, x2iedn.2xlarge, x2iedn.4xlarge, x2iedn.8xlarge, x2iedn.16xlarge, x2iedn.24xlarge, x2iedn.32xlarge, c6a.large, c6a.xlarge, c6a.2xlarge, c6a.4xlarge, c6a.8xlarge, c6a.12xlarge, c6a.16xlarge, c6a.24xlarge, c6a.32xlarge, c6a.48xlarge, c6a.metal, m6a.metal, i4i.large, i4i.xlarge, i4i.2xlarge, i4i.4xlarge, i4i.8xlarge, i4i.16xlarge, i4i.32xlarge, i4i.metal, x2idn.metal, x2iedn.metal, c7g.medium, c7g.large, c7g.xlarge, c7g.2xlarge, c7g.4xlarge, c7g.8xlarge, c7g.12xlarge, c7g.16xlarge, mac2.metal, c6id.large, c6id.xlarge, c6id.2xlarge, c6id.4xlarge, c6id.8xlarge, c6id.12xlarge, c6id.16xlarge, c6id.24xlarge, c6id.32xlarge, c6id.metal, m6id.large, m6id.xlarge, m6id.2xlarge, m6id.4xlarge, m6id.8xlarge, m6id.12xlarge, m6id.16xlarge, m6id.24xlarge, m6id.32xlarge, m6id.metal, r6id.large, r6id.xlarge, r6id.2xlarge, r6id.4xlarge, r6id.8xlarge, r6id.12xlarge, r6id.16xlarge, r6id.24xlarge, r6id.32xlarge, r6id.metal, r6a.large, r6a.xlarge, r6a.2xlarge, r6a.4xlarge, r6a.8xlarge, r6a.12xlarge, r6a.16xlarge, r6a.24xlarge, r6a.32xlarge, r6a.48xlarge, r6a.metal, p4de.24xlarge, u-3tb1.56xlarge, u-18tb1.112xlarge, u-24tb1.112xlarge, trn1.2xlarge, trn1.32xlarge, hpc6id.32xlarge, c6in.large, c6in.xlarge, c6in.2xlarge, c6in.4xlarge, c6in.8xlarge, c6in.12xlarge, c6in.16xlarge, c6in.24xlarge, c6in.32xlarge, m6in.large, m6in.xlarge, m6in.2xlarge, m6in.4xlarge, m6in.8xlarge, m6in.12xlarge, m6in.16xlarge, m6in.24xlarge, m6in.32xlarge, m6idn.large, m6idn.xlarge, m6idn.2xlarge, m6idn.4xlarge, m6idn.8xlarge, m6idn.12xlarge, m6idn.16xlarge, m6idn.24xlarge, m6idn.32xlarge, r6in.large, r6in.xlarge, r6in.2xlarge, r6in.4xlarge, r6in.8xlarge, r6in.12xlarge, r6in.16xlarge, r6in.24xlarge, r6in.32xlarge, r6idn.large, r6idn.xlarge, r6idn.2xlarge, r6idn.4xlarge, r6idn.8xlarge, r6idn.12xlarge, r6idn.16xlarge, r6idn.24xlarge, r6idn.32xlarge, c7g.metal, m7g.medium, m7g.large, m7g.xlarge, m7g.2xlarge, m7g.4xlarge, m7g.8xlarge, m7g.12xlarge, m7g.16xlarge, m7g.metal, r7g.medium, r7g.large, r7g.xlarge, r7g.2xlarge, r7g.4xlarge, r7g.8xlarge, r7g.12xlarge, r7g.16xlarge, r7g.metal, c6in.metal, m6in.metal, m6idn.metal, r6in.metal, r6idn.metal, inf2.xlarge, inf2.8xlarge, inf2.24xlarge, inf2.48xlarge, trn1n.32xlarge, i4g.large, i4g.xlarge, i4g.2xlarge, i4g.4xlarge, i4g.8xlarge, i4g.16xlarge, hpc7g.4xlarge, hpc7g.8xlarge, hpc7g.16xlarge, c7gn.medium, c7gn.large, c7gn.xlarge, c7gn.2xlarge, c7gn.4xlarge, c7gn.8xlarge, c7gn.12xlarge, c7gn.16xlarge, p5.48xlarge, m7i.large, m7i.xlarge, m7i.2xlarge, m7i.4xlarge, m7i.8xlarge, m7i.12xlarge, m7i.16xlarge, m7i.24xlarge, m7i.48xlarge, m7i-flex.large, m7i-flex.xlarge, m7i-flex.2xlarge, m7i-flex.4xlarge, m7i-flex.8xlarge, m7a.medium, m7a.large, m7a.xlarge, m7a.2xlarge, m7a.4xlarge, m7a.8xlarge, m7a.12xlarge, m7a.16xlarge, m7a.24xlarge, m7a.32xlarge, m7a.48xlarge, m7a.metal-48xl, hpc7a.12xlarge, hpc7a.24xlarge, hpc7a.48xlarge, hpc7a.96xlarge, c7gd.medium, c7gd.large, c7gd.xlarge, c7gd.2xlarge, c7gd.4xlarge, c7gd.8xlarge, c7gd.12xlarge, c7gd.16xlarge, m7gd.medium, m7gd.large, m7gd.xlarge, m7gd.2xlarge, m7gd.4xlarge, m7gd.8xlarge, m7gd.12xlarge, m7gd.16xlarge, r7gd.medium, r7gd.large, r7gd.xlarge, r7gd.2xlarge, r7gd.4xlarge, r7gd.8xlarge, r7gd.12xlarge, r7gd.16xlarge, r7a.medium, r7a.large, r7a.xlarge, r7a.2xlarge, r7a.4xlarge, r7a.8xlarge, r7a.12xlarge, r7a.16xlarge, r7a.24xlarge, r7a.32xlarge, r7a.48xlarge, c7i.large, c7i.xlarge, c7i.2xlarge, c7i.4xlarge, c7i.8xlarge, c7i.12xlarge, c7i.16xlarge, c7i.24xlarge, c7i.48xlarge, mac2-m2pro.metal, r7iz.large, r7iz.xlarge, r7iz.2xlarge, r7iz.4xlarge, r7iz.8xlarge, r7iz.12xlarge, r7iz.16xlarge, r7iz.32xlarge, c7a.medium, c7a.large, c7a.xlarge, c7a.2xlarge, c7a.4xlarge, c7a.8xlarge, c7a.12xlarge, c7a.16xlarge, c7a.24xlarge, c7a.32xlarge, c7a.48xlarge, c7a.metal-48xl, r7a.metal-48xl, r7i.large, r7i.xlarge, r7i.2xlarge, r7i.4xlarge, r7i.8xlarge, r7i.12xlarge, r7i.16xlarge, r7i.24xlarge, r7i.48xlarge, dl2q.24xlarge, mac2-m2.metal, i4i.12xlarge, i4i.24xlarge, c7i.metal-24xl, c7i.metal-48xl, m7i.metal-24xl, m7i.metal-48xl, r7i.metal-24xl, r7i.metal-48xl, r7iz.metal-16xl, r7iz.metal-32xl, c7gd.metal, m7gd.metal, r7gd.metal, g6.xlarge, g6.2xlarge, g6.4xlarge, g6.8xlarge, g6.12xlarge, g6.16xlarge, g6.24xlarge, g6.48xlarge, gr6.4xlarge, gr6.8xlarge, c7i-flex.large, c7i-flex.xlarge, c7i-flex.2xlarge, c7i-flex.4xlarge, c7i-flex.8xlarge, u7i-12tb.224xlarge, u7in-16tb.224xlarge, u7in-24tb.224xlarge, u7in-32tb.224xlarge, u7ib-12tb.224xlarge, c7gn.metal, r8g.medium, r8g.large, r8g.xlarge, r8g.2xlarge, r8g.4xlarge, r8g.8xlarge, r8g.12xlarge, r8g.16xlarge, r8g.24xlarge, r8g.48xlarge, r8g.metal-24xl, r8g.metal-48xl, mac2-m1ultra.metal, g6e.xlarge, g6e.2xlarge, g6e.4xlarge, g6e.8xlarge, g6e.12xlarge, g6e.16xlarge, g6e.24xlarge, g6e.48xlarge, c8g.medium, c8g.large, c8g.xlarge, c8g.2xlarge, c8g.4xlarge, c8g.8xlarge, c8g.12xlarge, c8g.16xlarge, c8g.24xlarge, c8g.48xlarge, c8g.metal-24xl, c8g.metal-48xl, m8g.medium, m8g.large, m8g.xlarge, m8g.2xlarge, m8g.4xlarge, m8g.8xlarge, m8g.12xlarge, m8g.16xlarge, m8g.24xlarge, m8g.48xlarge, m8g.metal-24xl, m8g.metal-48xl, x8g.medium, x8g.large, x8g.xlarge, x8g.2xlarge, x8g.4xlarge, x8g.8xlarge, x8g.12xlarge, x8g.16xlarge, x8g.24xlarge, x8g.48xlarge, x8g.metal-24xl, x8g.metal-48xl, i7ie.large, i7ie.xlarge, i7ie.2xlarge, i7ie.3xlarge, i7ie.6xlarge, i7ie.12xlarge, i7ie.18xlarge, i7ie.24xlarge, i7ie.48xlarge, i8g.large, i8g.xlarge, i8g.2xlarge, i8g.4xlarge, i8g.8xlarge, i8g.12xlarge, i8g.16xlarge, i8g.24xlarge, i8g.metal-24xl, u7i-6tb.112xlarge, u7i-8tb.112xlarge, u7inh-32tb.480xlarge, p5e.48xlarge, p5en.48xlarge, f2.12xlarge, f2.48xlarge, trn2.48xlarge, c7i-flex.12xlarge, c7i-flex.16xlarge, m7i-flex.12xlarge, m7i-flex.16xlarge, i7ie.metal-24xl, i7ie.metal-48xl, i8g.48xlarge, c8gd.medium, c8gd.large, c8gd.xlarge, c8gd.2xlarge, c8gd.4xlarge, c8gd.8xlarge, c8gd.12xlarge, c8gd.16xlarge, c8gd.24xlarge, c8gd.48xlarge, c8gd.metal-24xl, c8gd.metal-48xl, i7i.large, i7i.xlarge, i7i.2xlarge, i7i.4xlarge, i7i.8xlarge, i7i.12xlarge, i7i.16xlarge, i7i.24xlarge, i7i.48xlarge, i7i.metal-24xl, i7i.metal-48xl, p6-b200.48xlarge, m8gd.medium, m8gd.large, m8gd.xlarge, m8gd.2xlarge, m8gd.4xlarge, m8gd.8xlarge, m8gd.12xlarge, m8gd.16xlarge, m8gd.24xlarge, m8gd.48xlarge, m8gd.metal-24xl, m8gd.metal-48xl, r8gd.medium, r8gd.large, r8gd.xlarge, r8gd.2xlarge, r8gd.4xlarge, r8gd.8xlarge, r8gd.12xlarge, r8gd.16xlarge, r8gd.24xlarge, r8gd.48xlarge, r8gd.metal-24xl, r8gd.metal-48xl, c8gn.medium, c8gn.large, c8gn.xlarge, c8gn.2xlarge, c8gn.4xlarge, c8gn.8xlarge, c8gn.12xlarge, c8gn.16xlarge, c8gn.24xlarge, c8gn.48xlarge, c8gn.metal-24xl, c8gn.metal-48xl, f2.6xlarge, p6e-gb200.36xlarge
    #       key_name: "KeyPairName",
    #       monitoring: {
    #         enabled: false,
    #       },
    #       placement: {
    #         availability_zone: "String",
    #         availability_zone_id: "AvailabilityZoneId",
    #         affinity: "String",
    #         group_name: "PlacementGroupName",
    #         host_id: "DedicatedHostId",
    #         tenancy: "default", # accepts default, dedicated, host
    #         spread_domain: "String",
    #         host_resource_group_arn: "String",
    #         partition_number: 1,
    #         group_id: "PlacementGroupId",
    #       },
    #       ram_disk_id: "RamdiskId",
    #       disable_api_termination: false,
    #       instance_initiated_shutdown_behavior: "stop", # accepts stop, terminate
    #       user_data: "SensitiveUserData",
    #       tag_specifications: [
    #         {
    #           resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #           tags: [
    #             {
    #               key: "String",
    #               value: "String",
    #             },
    #           ],
    #         },
    #       ],
    #       elastic_gpu_specifications: [
    #         {
    #           type: "String", # required
    #         },
    #       ],
    #       elastic_inference_accelerators: [
    #         {
    #           type: "String", # required
    #           count: 1,
    #         },
    #       ],
    #       security_group_ids: ["SecurityGroupId"],
    #       security_groups: ["SecurityGroupName"],
    #       instance_market_options: {
    #         market_type: "spot", # accepts spot, capacity-block
    #         spot_options: {
    #           max_price: "String",
    #           spot_instance_type: "one-time", # accepts one-time, persistent
    #           block_duration_minutes: 1,
    #           valid_until: Time.now,
    #           instance_interruption_behavior: "hibernate", # accepts hibernate, stop, terminate
    #         },
    #       },
    #       credit_specification: {
    #         cpu_credits: "String", # required
    #       },
    #       cpu_options: {
    #         core_count: 1,
    #         threads_per_core: 1,
    #         amd_sev_snp: "enabled", # accepts enabled, disabled
    #       },
    #       capacity_reservation_specification: {
    #         capacity_reservation_preference: "capacity-reservations-only", # accepts capacity-reservations-only, open, none
    #         capacity_reservation_target: {
    #           capacity_reservation_id: "CapacityReservationId",
    #           capacity_reservation_resource_group_arn: "String",
    #         },
    #       },
    #       license_specifications: [
    #         {
    #           license_configuration_arn: "String",
    #         },
    #       ],
    #       hibernation_options: {
    #         configured: false,
    #       },
    #       metadata_options: {
    #         http_tokens: "optional", # accepts optional, required
    #         http_put_response_hop_limit: 1,
    #         http_endpoint: "disabled", # accepts disabled, enabled
    #         http_protocol_ipv_6: "disabled", # accepts disabled, enabled
    #         instance_metadata_tags: "disabled", # accepts disabled, enabled
    #       },
    #       enclave_options: {
    #         enabled: false,
    #       },
    #       instance_requirements: {
    #         v_cpu_count: { # required
    #           min: 1, # required
    #           max: 1,
    #         },
    #         memory_mi_b: { # required
    #           min: 1, # required
    #           max: 1,
    #         },
    #         cpu_manufacturers: ["intel"], # accepts intel, amd, amazon-web-services, apple
    #         memory_gi_b_per_v_cpu: {
    #           min: 1.0,
    #           max: 1.0,
    #         },
    #         excluded_instance_types: ["ExcludedInstanceType"],
    #         instance_generations: ["current"], # accepts current, previous
    #         spot_max_price_percentage_over_lowest_price: 1,
    #         on_demand_max_price_percentage_over_lowest_price: 1,
    #         bare_metal: "included", # accepts included, required, excluded
    #         burstable_performance: "included", # accepts included, required, excluded
    #         require_hibernate_support: false,
    #         network_interface_count: {
    #           min: 1,
    #           max: 1,
    #         },
    #         local_storage: "included", # accepts included, required, excluded
    #         local_storage_types: ["hdd"], # accepts hdd, ssd
    #         total_local_storage_gb: {
    #           min: 1.0,
    #           max: 1.0,
    #         },
    #         baseline_ebs_bandwidth_mbps: {
    #           min: 1,
    #           max: 1,
    #         },
    #         accelerator_types: ["gpu"], # accepts gpu, fpga, inference
    #         accelerator_count: {
    #           min: 1,
    #           max: 1,
    #         },
    #         accelerator_manufacturers: ["amazon-web-services"], # accepts amazon-web-services, amd, nvidia, xilinx, habana
    #         accelerator_names: ["a100"], # accepts a100, inferentia, k520, k80, m60, radeon-pro-v520, t4, vu9p, v100, a10g, h100, t4g
    #         accelerator_total_memory_mi_b: {
    #           min: 1,
    #           max: 1,
    #         },
    #         network_bandwidth_gbps: {
    #           min: 1.0,
    #           max: 1.0,
    #         },
    #         allowed_instance_types: ["AllowedInstanceType"],
    #         max_spot_price_as_percentage_of_optimal_on_demand_price: 1,
    #         baseline_performance_factors: {
    #           cpu: {
    #             references: [
    #               {
    #                 instance_family: "String",
    #               },
    #             ],
    #           },
    #         },
    #       },
    #       private_dns_name_options: {
    #         hostname_type: "ip-name", # accepts ip-name, resource-name
    #         enable_resource_name_dns_a_record: false,
    #         enable_resource_name_dns_aaaa_record: false,
    #       },
    #       maintenance_options: {
    #         auto_recovery: "default", # accepts default, disabled
    #       },
    #       disable_api_stop: false,
    #       operator: {
    #         principal: "String",
    #       },
    #       network_performance_options: {
    #         bandwidth_weighting: "default", # accepts default, vpc-1, ebs-1
    #       },
    #     },
    #     resolve_alias: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.launch_template_version.launch_template_id #=> String
    #   resp.launch_template_version.launch_template_name #=> String
    #   resp.launch_template_version.version_number #=> Integer
    #   resp.launch_template_version.version_description #=> String
    #   resp.launch_template_version.create_time #=> Time
    #   resp.launch_template_version.created_by #=> String
    #   resp.launch_template_version.default_version #=> Boolean
    #   resp.launch_template_version.launch_template_data.kernel_id #=> String
    #   resp.launch_template_version.launch_template_data.ebs_optimized #=> Boolean
    #   resp.launch_template_version.launch_template_data.iam_instance_profile.arn #=> String
    #   resp.launch_template_version.launch_template_data.iam_instance_profile.name #=> String
    #   resp.launch_template_version.launch_template_data.block_device_mappings #=> Array
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].device_name #=> String
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].virtual_name #=> String
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.encrypted #=> Boolean
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.delete_on_termination #=> Boolean
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.iops #=> Integer
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.kms_key_id #=> String
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.snapshot_id #=> String
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.volume_size #=> Integer
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.volume_type #=> String, one of "standard", "io1", "io2", "gp2", "sc1", "st1", "gp3"
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.throughput #=> Integer
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].ebs.volume_initialization_rate #=> Integer
    #   resp.launch_template_version.launch_template_data.block_device_mappings[0].no_device #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces #=> Array
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].associate_carrier_ip_address #=> Boolean
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].associate_public_ip_address #=> Boolean
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].delete_on_termination #=> Boolean
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].description #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].device_index #=> Integer
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].groups #=> Array
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].groups[0] #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].interface_type #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].ipv_6_address_count #=> Integer
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].ipv_6_addresses #=> Array
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].ipv_6_addresses[0].ipv_6_address #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].ipv_6_addresses[0].is_primary_ipv_6 #=> Boolean
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].network_interface_id #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].private_ip_address #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].private_ip_addresses #=> Array
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].private_ip_addresses[0].primary #=> Boolean
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].private_ip_addresses[0].private_ip_address #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].secondary_private_ip_address_count #=> Integer
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].subnet_id #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].network_card_index #=> Integer
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].ipv_4_prefixes #=> Array
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].ipv_4_prefixes[0].ipv_4_prefix #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].ipv_4_prefix_count #=> Integer
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].ipv_6_prefixes #=> Array
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].ipv_6_prefixes[0].ipv_6_prefix #=> String
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].ipv_6_prefix_count #=> Integer
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].primary_ipv_6 #=> Boolean
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].ena_srd_specification.ena_srd_enabled #=> Boolean
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].ena_srd_specification.ena_srd_udp_specification.ena_srd_udp_enabled #=> Boolean
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].connection_tracking_specification.tcp_established_timeout #=> Integer
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].connection_tracking_specification.udp_timeout #=> Integer
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].connection_tracking_specification.udp_stream_timeout #=> Integer
    #   resp.launch_template_version.launch_template_data.network_interfaces[0].ena_queue_count #=> Integer
    #   resp.launch_template_version.launch_template_data.image_id #=> String
    #   resp.launch_template_version.launch_template_data.instance_type #=> String, one of "a1.medium", "a1.large", "a1.xlarge", "a1.2xlarge", "a1.4xlarge", "a1.metal", "c1.medium", "c1.xlarge", "c3.large", "c3.xlarge", "c3.2xlarge", "c3.4xlarge", "c3.8xlarge", "c4.large", "c4.xlarge", "c4.2xlarge", "c4.4xlarge", "c4.8xlarge", "c5.large", "c5.xlarge", "c5.2xlarge", "c5.4xlarge", "c5.9xlarge", "c5.12xlarge", "c5.18xlarge", "c5.24xlarge", "c5.metal", "c5a.large", "c5a.xlarge", "c5a.2xlarge", "c5a.4xlarge", "c5a.8xlarge", "c5a.12xlarge", "c5a.16xlarge", "c5a.24xlarge", "c5ad.large", "c5ad.xlarge", "c5ad.2xlarge", "c5ad.4xlarge", "c5ad.8xlarge", "c5ad.12xlarge", "c5ad.16xlarge", "c5ad.24xlarge", "c5d.large", "c5d.xlarge", "c5d.2xlarge", "c5d.4xlarge", "c5d.9xlarge", "c5d.12xlarge", "c5d.18xlarge", "c5d.24xlarge", "c5d.metal", "c5n.large", "c5n.xlarge", "c5n.2xlarge", "c5n.4xlarge", "c5n.9xlarge", "c5n.18xlarge", "c5n.metal", "c6g.medium", "c6g.large", "c6g.xlarge", "c6g.2xlarge", "c6g.4xlarge", "c6g.8xlarge", "c6g.12xlarge", "c6g.16xlarge", "c6g.metal", "c6gd.medium", "c6gd.large", "c6gd.xlarge", "c6gd.2xlarge", "c6gd.4xlarge", "c6gd.8xlarge", "c6gd.12xlarge", "c6gd.16xlarge", "c6gd.metal", "c6gn.medium", "c6gn.large", "c6gn.xlarge", "c6gn.2xlarge", "c6gn.4xlarge", "c6gn.8xlarge", "c6gn.12xlarge", "c6gn.16xlarge", "c6i.large", "c6i.xlarge", "c6i.2xlarge", "c6i.4xlarge", "c6i.8xlarge", "c6i.12xlarge", "c6i.16xlarge", "c6i.24xlarge", "c6i.32xlarge", "c6i.metal", "cc1.4xlarge", "cc2.8xlarge", "cg1.4xlarge", "cr1.8xlarge", "d2.xlarge", "d2.2xlarge", "d2.4xlarge", "d2.8xlarge", "d3.xlarge", "d3.2xlarge", "d3.4xlarge", "d3.8xlarge", "d3en.xlarge", "d3en.2xlarge", "d3en.4xlarge", "d3en.6xlarge", "d3en.8xlarge", "d3en.12xlarge", "dl1.24xlarge", "f1.2xlarge", "f1.4xlarge", "f1.16xlarge", "g2.2xlarge", "g2.8xlarge", "g3.4xlarge", "g3.8xlarge", "g3.16xlarge", "g3s.xlarge", "g4ad.xlarge", "g4ad.2xlarge", "g4ad.4xlarge", "g4ad.8xlarge", "g4ad.16xlarge", "g4dn.xlarge", "g4dn.2xlarge", "g4dn.4xlarge", "g4dn.8xlarge", "g4dn.12xlarge", "g4dn.16xlarge", "g4dn.metal", "g5.xlarge", "g5.2xlarge", "g5.4xlarge", "g5.8xlarge", "g5.12xlarge", "g5.16xlarge", "g5.24xlarge", "g5.48xlarge", "g5g.xlarge", "g5g.2xlarge", "g5g.4xlarge", "g5g.8xlarge", "g5g.16xlarge", "g5g.metal", "hi1.4xlarge", "hpc6a.48xlarge", "hs1.8xlarge", "h1.2xlarge", "h1.4xlarge", "h1.8xlarge", "h1.16xlarge", "i2.xlarge", "i2.2xlarge", "i2.4xlarge", "i2.8xlarge", "i3.large", "i3.xlarge", "i3.2xlarge", "i3.4xlarge", "i3.8xlarge", "i3.16xlarge", "i3.metal", "i3en.large", "i3en.xlarge", "i3en.2xlarge", "i3en.3xlarge", "i3en.6xlarge", "i3en.12xlarge", "i3en.24xlarge", "i3en.metal", "im4gn.large", "im4gn.xlarge", "im4gn.2xlarge", "im4gn.4xlarge", "im4gn.8xlarge", "im4gn.16xlarge", "inf1.xlarge", "inf1.2xlarge", "inf1.6xlarge", "inf1.24xlarge", "is4gen.medium", "is4gen.large", "is4gen.xlarge", "is4gen.2xlarge", "is4gen.4xlarge", "is4gen.8xlarge", "m1.small", "m1.medium", "m1.large", "m1.xlarge", "m2.xlarge", "m2.2xlarge", "m2.4xlarge", "m3.medium", "m3.large", "m3.xlarge", "m3.2xlarge", "m4.large", "m4.xlarge", "m4.2xlarge", "m4.4xlarge", "m4.10xlarge", "m4.16xlarge", "m5.large", "m5.xlarge", "m5.2xlarge", "m5.4xlarge", "m5.8xlarge", "m5.12xlarge", "m5.16xlarge", "m5.24xlarge", "m5.metal", "m5a.large", "m5a.xlarge", "m5a.2xlarge", "m5a.4xlarge", "m5a.8xlarge", "m5a.12xlarge", "m5a.16xlarge", "m5a.24xlarge", "m5ad.large", "m5ad.xlarge", "m5ad.2xlarge", "m5ad.4xlarge", "m5ad.8xlarge", "m5ad.12xlarge", "m5ad.16xlarge", "m5ad.24xlarge", "m5d.large", "m5d.xlarge", "m5d.2xlarge", "m5d.4xlarge", "m5d.8xlarge", "m5d.12xlarge", "m5d.16xlarge", "m5d.24xlarge", "m5d.metal", "m5dn.large", "m5dn.xlarge", "m5dn.2xlarge", "m5dn.4xlarge", "m5dn.8xlarge", "m5dn.12xlarge", "m5dn.16xlarge", "m5dn.24xlarge", "m5dn.metal", "m5n.large", "m5n.xlarge", "m5n.2xlarge", "m5n.4xlarge", "m5n.8xlarge", "m5n.12xlarge", "m5n.16xlarge", "m5n.24xlarge", "m5n.metal", "m5zn.large", "m5zn.xlarge", "m5zn.2xlarge", "m5zn.3xlarge", "m5zn.6xlarge", "m5zn.12xlarge", "m5zn.metal", "m6a.large", "m6a.xlarge", "m6a.2xlarge", "m6a.4xlarge", "m6a.8xlarge", "m6a.12xlarge", "m6a.16xlarge", "m6a.24xlarge", "m6a.32xlarge", "m6a.48xlarge", "m6g.metal", "m6g.medium", "m6g.large", "m6g.xlarge", "m6g.2xlarge", "m6g.4xlarge", "m6g.8xlarge", "m6g.12xlarge", "m6g.16xlarge", "m6gd.metal", "m6gd.medium", "m6gd.large", "m6gd.xlarge", "m6gd.2xlarge", "m6gd.4xlarge", "m6gd.8xlarge", "m6gd.12xlarge", "m6gd.16xlarge", "m6i.large", "m6i.xlarge", "m6i.2xlarge", "m6i.4xlarge", "m6i.8xlarge", "m6i.12xlarge", "m6i.16xlarge", "m6i.24xlarge", "m6i.32xlarge", "m6i.metal", "mac1.metal", "p2.xlarge", "p2.8xlarge", "p2.16xlarge", "p3.2xlarge", "p3.8xlarge", "p3.16xlarge", "p3dn.24xlarge", "p4d.24xlarge", "r3.large", "r3.xlarge", "r3.2xlarge", "r3.4xlarge", "r3.8xlarge", "r4.large", "r4.xlarge", "r4.2xlarge", "r4.4xlarge", "r4.8xlarge", "r4.16xlarge", "r5.large", "r5.xlarge", "r5.2xlarge", "r5.4xlarge", "r5.8xlarge", "r5.12xlarge", "r5.16xlarge", "r5.24xlarge", "r5.metal", "r5a.large", "r5a.xlarge", "r5a.2xlarge", "r5a.4xlarge", "r5a.8xlarge", "r5a.12xlarge", "r5a.16xlarge", "r5a.24xlarge", "r5ad.large", "r5ad.xlarge", "r5ad.2xlarge", "r5ad.4xlarge", "r5ad.8xlarge", "r5ad.12xlarge", "r5ad.16xlarge", "r5ad.24xlarge", "r5b.large", "r5b.xlarge", "r5b.2xlarge", "r5b.4xlarge", "r5b.8xlarge", "r5b.12xlarge", "r5b.16xlarge", "r5b.24xlarge", "r5b.metal", "r5d.large", "r5d.xlarge", "r5d.2xlarge", "r5d.4xlarge", "r5d.8xlarge", "r5d.12xlarge", "r5d.16xlarge", "r5d.24xlarge", "r5d.metal", "r5dn.large", "r5dn.xlarge", "r5dn.2xlarge", "r5dn.4xlarge", "r5dn.8xlarge", "r5dn.12xlarge", "r5dn.16xlarge", "r5dn.24xlarge", "r5dn.metal", "r5n.large", "r5n.xlarge", "r5n.2xlarge", "r5n.4xlarge", "r5n.8xlarge", "r5n.12xlarge", "r5n.16xlarge", "r5n.24xlarge", "r5n.metal", "r6g.medium", "r6g.large", "r6g.xlarge", "r6g.2xlarge", "r6g.4xlarge", "r6g.8xlarge", "r6g.12xlarge", "r6g.16xlarge", "r6g.metal", "r6gd.medium", "r6gd.large", "r6gd.xlarge", "r6gd.2xlarge", "r6gd.4xlarge", "r6gd.8xlarge", "r6gd.12xlarge", "r6gd.16xlarge", "r6gd.metal", "r6i.large", "r6i.xlarge", "r6i.2xlarge", "r6i.4xlarge", "r6i.8xlarge", "r6i.12xlarge", "r6i.16xlarge", "r6i.24xlarge", "r6i.32xlarge", "r6i.metal", "t1.micro", "t2.nano", "t2.micro", "t2.small", "t2.medium", "t2.large", "t2.xlarge", "t2.2xlarge", "t3.nano", "t3.micro", "t3.small", "t3.medium", "t3.large", "t3.xlarge", "t3.2xlarge", "t3a.nano", "t3a.micro", "t3a.small", "t3a.medium", "t3a.large", "t3a.xlarge", "t3a.2xlarge", "t4g.nano", "t4g.micro", "t4g.small", "t4g.medium", "t4g.large", "t4g.xlarge", "t4g.2xlarge", "u-6tb1.56xlarge", "u-6tb1.112xlarge", "u-9tb1.112xlarge", "u-12tb1.112xlarge", "u-6tb1.metal", "u-9tb1.metal", "u-12tb1.metal", "u-18tb1.metal", "u-24tb1.metal", "vt1.3xlarge", "vt1.6xlarge", "vt1.24xlarge", "x1.16xlarge", "x1.32xlarge", "x1e.xlarge", "x1e.2xlarge", "x1e.4xlarge", "x1e.8xlarge", "x1e.16xlarge", "x1e.32xlarge", "x2iezn.2xlarge", "x2iezn.4xlarge", "x2iezn.6xlarge", "x2iezn.8xlarge", "x2iezn.12xlarge", "x2iezn.metal", "x2gd.medium", "x2gd.large", "x2gd.xlarge", "x2gd.2xlarge", "x2gd.4xlarge", "x2gd.8xlarge", "x2gd.12xlarge", "x2gd.16xlarge", "x2gd.metal", "z1d.large", "z1d.xlarge", "z1d.2xlarge", "z1d.3xlarge", "z1d.6xlarge", "z1d.12xlarge", "z1d.metal", "x2idn.16xlarge", "x2idn.24xlarge", "x2idn.32xlarge", "x2iedn.xlarge", "x2iedn.2xlarge", "x2iedn.4xlarge", "x2iedn.8xlarge", "x2iedn.16xlarge", "x2iedn.24xlarge", "x2iedn.32xlarge", "c6a.large", "c6a.xlarge", "c6a.2xlarge", "c6a.4xlarge", "c6a.8xlarge", "c6a.12xlarge", "c6a.16xlarge", "c6a.24xlarge", "c6a.32xlarge", "c6a.48xlarge", "c6a.metal", "m6a.metal", "i4i.large", "i4i.xlarge", "i4i.2xlarge", "i4i.4xlarge", "i4i.8xlarge", "i4i.16xlarge", "i4i.32xlarge", "i4i.metal", "x2idn.metal", "x2iedn.metal", "c7g.medium", "c7g.large", "c7g.xlarge", "c7g.2xlarge", "c7g.4xlarge", "c7g.8xlarge", "c7g.12xlarge", "c7g.16xlarge", "mac2.metal", "c6id.large", "c6id.xlarge", "c6id.2xlarge", "c6id.4xlarge", "c6id.8xlarge", "c6id.12xlarge", "c6id.16xlarge", "c6id.24xlarge", "c6id.32xlarge", "c6id.metal", "m6id.large", "m6id.xlarge", "m6id.2xlarge", "m6id.4xlarge", "m6id.8xlarge", "m6id.12xlarge", "m6id.16xlarge", "m6id.24xlarge", "m6id.32xlarge", "m6id.metal", "r6id.large", "r6id.xlarge", "r6id.2xlarge", "r6id.4xlarge", "r6id.8xlarge", "r6id.12xlarge", "r6id.16xlarge", "r6id.24xlarge", "r6id.32xlarge", "r6id.metal", "r6a.large", "r6a.xlarge", "r6a.2xlarge", "r6a.4xlarge", "r6a.8xlarge", "r6a.12xlarge", "r6a.16xlarge", "r6a.24xlarge", "r6a.32xlarge", "r6a.48xlarge", "r6a.metal", "p4de.24xlarge", "u-3tb1.56xlarge", "u-18tb1.112xlarge", "u-24tb1.112xlarge", "trn1.2xlarge", "trn1.32xlarge", "hpc6id.32xlarge", "c6in.large", "c6in.xlarge", "c6in.2xlarge", "c6in.4xlarge", "c6in.8xlarge", "c6in.12xlarge", "c6in.16xlarge", "c6in.24xlarge", "c6in.32xlarge", "m6in.large", "m6in.xlarge", "m6in.2xlarge", "m6in.4xlarge", "m6in.8xlarge", "m6in.12xlarge", "m6in.16xlarge", "m6in.24xlarge", "m6in.32xlarge", "m6idn.large", "m6idn.xlarge", "m6idn.2xlarge", "m6idn.4xlarge", "m6idn.8xlarge", "m6idn.12xlarge", "m6idn.16xlarge", "m6idn.24xlarge", "m6idn.32xlarge", "r6in.large", "r6in.xlarge", "r6in.2xlarge", "r6in.4xlarge", "r6in.8xlarge", "r6in.12xlarge", "r6in.16xlarge", "r6in.24xlarge", "r6in.32xlarge", "r6idn.large", "r6idn.xlarge", "r6idn.2xlarge", "r6idn.4xlarge", "r6idn.8xlarge", "r6idn.12xlarge", "r6idn.16xlarge", "r6idn.24xlarge", "r6idn.32xlarge", "c7g.metal", "m7g.medium", "m7g.large", "m7g.xlarge", "m7g.2xlarge", "m7g.4xlarge", "m7g.8xlarge", "m7g.12xlarge", "m7g.16xlarge", "m7g.metal", "r7g.medium", "r7g.large", "r7g.xlarge", "r7g.2xlarge", "r7g.4xlarge", "r7g.8xlarge", "r7g.12xlarge", "r7g.16xlarge", "r7g.metal", "c6in.metal", "m6in.metal", "m6idn.metal", "r6in.metal", "r6idn.metal", "inf2.xlarge", "inf2.8xlarge", "inf2.24xlarge", "inf2.48xlarge", "trn1n.32xlarge", "i4g.large", "i4g.xlarge", "i4g.2xlarge", "i4g.4xlarge", "i4g.8xlarge", "i4g.16xlarge", "hpc7g.4xlarge", "hpc7g.8xlarge", "hpc7g.16xlarge", "c7gn.medium", "c7gn.large", "c7gn.xlarge", "c7gn.2xlarge", "c7gn.4xlarge", "c7gn.8xlarge", "c7gn.12xlarge", "c7gn.16xlarge", "p5.48xlarge", "m7i.large", "m7i.xlarge", "m7i.2xlarge", "m7i.4xlarge", "m7i.8xlarge", "m7i.12xlarge", "m7i.16xlarge", "m7i.24xlarge", "m7i.48xlarge", "m7i-flex.large", "m7i-flex.xlarge", "m7i-flex.2xlarge", "m7i-flex.4xlarge", "m7i-flex.8xlarge", "m7a.medium", "m7a.large", "m7a.xlarge", "m7a.2xlarge", "m7a.4xlarge", "m7a.8xlarge", "m7a.12xlarge", "m7a.16xlarge", "m7a.24xlarge", "m7a.32xlarge", "m7a.48xlarge", "m7a.metal-48xl", "hpc7a.12xlarge", "hpc7a.24xlarge", "hpc7a.48xlarge", "hpc7a.96xlarge", "c7gd.medium", "c7gd.large", "c7gd.xlarge", "c7gd.2xlarge", "c7gd.4xlarge", "c7gd.8xlarge", "c7gd.12xlarge", "c7gd.16xlarge", "m7gd.medium", "m7gd.large", "m7gd.xlarge", "m7gd.2xlarge", "m7gd.4xlarge", "m7gd.8xlarge", "m7gd.12xlarge", "m7gd.16xlarge", "r7gd.medium", "r7gd.large", "r7gd.xlarge", "r7gd.2xlarge", "r7gd.4xlarge", "r7gd.8xlarge", "r7gd.12xlarge", "r7gd.16xlarge", "r7a.medium", "r7a.large", "r7a.xlarge", "r7a.2xlarge", "r7a.4xlarge", "r7a.8xlarge", "r7a.12xlarge", "r7a.16xlarge", "r7a.24xlarge", "r7a.32xlarge", "r7a.48xlarge", "c7i.large", "c7i.xlarge", "c7i.2xlarge", "c7i.4xlarge", "c7i.8xlarge", "c7i.12xlarge", "c7i.16xlarge", "c7i.24xlarge", "c7i.48xlarge", "mac2-m2pro.metal", "r7iz.large", "r7iz.xlarge", "r7iz.2xlarge", "r7iz.4xlarge", "r7iz.8xlarge", "r7iz.12xlarge", "r7iz.16xlarge", "r7iz.32xlarge", "c7a.medium", "c7a.large", "c7a.xlarge", "c7a.2xlarge", "c7a.4xlarge", "c7a.8xlarge", "c7a.12xlarge", "c7a.16xlarge", "c7a.24xlarge", "c7a.32xlarge", "c7a.48xlarge", "c7a.metal-48xl", "r7a.metal-48xl", "r7i.large", "r7i.xlarge", "r7i.2xlarge", "r7i.4xlarge", "r7i.8xlarge", "r7i.12xlarge", "r7i.16xlarge", "r7i.24xlarge", "r7i.48xlarge", "dl2q.24xlarge", "mac2-m2.metal", "i4i.12xlarge", "i4i.24xlarge", "c7i.metal-24xl", "c7i.metal-48xl", "m7i.metal-24xl", "m7i.metal-48xl", "r7i.metal-24xl", "r7i.metal-48xl", "r7iz.metal-16xl", "r7iz.metal-32xl", "c7gd.metal", "m7gd.metal", "r7gd.metal", "g6.xlarge", "g6.2xlarge", "g6.4xlarge", "g6.8xlarge", "g6.12xlarge", "g6.16xlarge", "g6.24xlarge", "g6.48xlarge", "gr6.4xlarge", "gr6.8xlarge", "c7i-flex.large", "c7i-flex.xlarge", "c7i-flex.2xlarge", "c7i-flex.4xlarge", "c7i-flex.8xlarge", "u7i-12tb.224xlarge", "u7in-16tb.224xlarge", "u7in-24tb.224xlarge", "u7in-32tb.224xlarge", "u7ib-12tb.224xlarge", "c7gn.metal", "r8g.medium", "r8g.large", "r8g.xlarge", "r8g.2xlarge", "r8g.4xlarge", "r8g.8xlarge", "r8g.12xlarge", "r8g.16xlarge", "r8g.24xlarge", "r8g.48xlarge", "r8g.metal-24xl", "r8g.metal-48xl", "mac2-m1ultra.metal", "g6e.xlarge", "g6e.2xlarge", "g6e.4xlarge", "g6e.8xlarge", "g6e.12xlarge", "g6e.16xlarge", "g6e.24xlarge", "g6e.48xlarge", "c8g.medium", "c8g.large", "c8g.xlarge", "c8g.2xlarge", "c8g.4xlarge", "c8g.8xlarge", "c8g.12xlarge", "c8g.16xlarge", "c8g.24xlarge", "c8g.48xlarge", "c8g.metal-24xl", "c8g.metal-48xl", "m8g.medium", "m8g.large", "m8g.xlarge", "m8g.2xlarge", "m8g.4xlarge", "m8g.8xlarge", "m8g.12xlarge", "m8g.16xlarge", "m8g.24xlarge", "m8g.48xlarge", "m8g.metal-24xl", "m8g.metal-48xl", "x8g.medium", "x8g.large", "x8g.xlarge", "x8g.2xlarge", "x8g.4xlarge", "x8g.8xlarge", "x8g.12xlarge", "x8g.16xlarge", "x8g.24xlarge", "x8g.48xlarge", "x8g.metal-24xl", "x8g.metal-48xl", "i7ie.large", "i7ie.xlarge", "i7ie.2xlarge", "i7ie.3xlarge", "i7ie.6xlarge", "i7ie.12xlarge", "i7ie.18xlarge", "i7ie.24xlarge", "i7ie.48xlarge", "i8g.large", "i8g.xlarge", "i8g.2xlarge", "i8g.4xlarge", "i8g.8xlarge", "i8g.12xlarge", "i8g.16xlarge", "i8g.24xlarge", "i8g.metal-24xl", "u7i-6tb.112xlarge", "u7i-8tb.112xlarge", "u7inh-32tb.480xlarge", "p5e.48xlarge", "p5en.48xlarge", "f2.12xlarge", "f2.48xlarge", "trn2.48xlarge", "c7i-flex.12xlarge", "c7i-flex.16xlarge", "m7i-flex.12xlarge", "m7i-flex.16xlarge", "i7ie.metal-24xl", "i7ie.metal-48xl", "i8g.48xlarge", "c8gd.medium", "c8gd.large", "c8gd.xlarge", "c8gd.2xlarge", "c8gd.4xlarge", "c8gd.8xlarge", "c8gd.12xlarge", "c8gd.16xlarge", "c8gd.24xlarge", "c8gd.48xlarge", "c8gd.metal-24xl", "c8gd.metal-48xl", "i7i.large", "i7i.xlarge", "i7i.2xlarge", "i7i.4xlarge", "i7i.8xlarge", "i7i.12xlarge", "i7i.16xlarge", "i7i.24xlarge", "i7i.48xlarge", "i7i.metal-24xl", "i7i.metal-48xl", "p6-b200.48xlarge", "m8gd.medium", "m8gd.large", "m8gd.xlarge", "m8gd.2xlarge", "m8gd.4xlarge", "m8gd.8xlarge", "m8gd.12xlarge", "m8gd.16xlarge", "m8gd.24xlarge", "m8gd.48xlarge", "m8gd.metal-24xl", "m8gd.metal-48xl", "r8gd.medium", "r8gd.large", "r8gd.xlarge", "r8gd.2xlarge", "r8gd.4xlarge", "r8gd.8xlarge", "r8gd.12xlarge", "r8gd.16xlarge", "r8gd.24xlarge", "r8gd.48xlarge", "r8gd.metal-24xl", "r8gd.metal-48xl", "c8gn.medium", "c8gn.large", "c8gn.xlarge", "c8gn.2xlarge", "c8gn.4xlarge", "c8gn.8xlarge", "c8gn.12xlarge", "c8gn.16xlarge", "c8gn.24xlarge", "c8gn.48xlarge", "c8gn.metal-24xl", "c8gn.metal-48xl", "f2.6xlarge", "p6e-gb200.36xlarge"
    #   resp.launch_template_version.launch_template_data.key_name #=> String
    #   resp.launch_template_version.launch_template_data.monitoring.enabled #=> Boolean
    #   resp.launch_template_version.launch_template_data.placement.availability_zone #=> String
    #   resp.launch_template_version.launch_template_data.placement.availability_zone_id #=> String
    #   resp.launch_template_version.launch_template_data.placement.affinity #=> String
    #   resp.launch_template_version.launch_template_data.placement.group_name #=> String
    #   resp.launch_template_version.launch_template_data.placement.host_id #=> String
    #   resp.launch_template_version.launch_template_data.placement.tenancy #=> String, one of "default", "dedicated", "host"
    #   resp.launch_template_version.launch_template_data.placement.spread_domain #=> String
    #   resp.launch_template_version.launch_template_data.placement.host_resource_group_arn #=> String
    #   resp.launch_template_version.launch_template_data.placement.partition_number #=> Integer
    #   resp.launch_template_version.launch_template_data.placement.group_id #=> String
    #   resp.launch_template_version.launch_template_data.ram_disk_id #=> String
    #   resp.launch_template_version.launch_template_data.disable_api_termination #=> Boolean
    #   resp.launch_template_version.launch_template_data.instance_initiated_shutdown_behavior #=> String, one of "stop", "terminate"
    #   resp.launch_template_version.launch_template_data.user_data #=> String
    #   resp.launch_template_version.launch_template_data.tag_specifications #=> Array
    #   resp.launch_template_version.launch_template_data.tag_specifications[0].resource_type #=> String, one of "capacity-reservation", "client-vpn-endpoint", "customer-gateway", "carrier-gateway", "coip-pool", "declarative-policies-report", "dedicated-host", "dhcp-options", "egress-only-internet-gateway", "elastic-ip", "elastic-gpu", "export-image-task", "export-instance-task", "fleet", "fpga-image", "host-reservation", "image", "image-usage-report", "import-image-task", "import-snapshot-task", "instance", "instance-event-window", "internet-gateway", "ipam", "ipam-pool", "ipam-scope", "ipv4pool-ec2", "ipv6pool-ec2", "key-pair", "launch-template", "local-gateway", "local-gateway-route-table", "local-gateway-virtual-interface", "local-gateway-virtual-interface-group", "local-gateway-route-table-vpc-association", "local-gateway-route-table-virtual-interface-group-association", "natgateway", "network-acl", "network-interface", "network-insights-analysis", "network-insights-path", "network-insights-access-scope", "network-insights-access-scope-analysis", "outpost-lag", "placement-group", "prefix-list", "replace-root-volume-task", "reserved-instances", "route-table", "security-group", "security-group-rule", "service-link-virtual-interface", "snapshot", "spot-fleet-request", "spot-instances-request", "subnet", "subnet-cidr-reservation", "traffic-mirror-filter", "traffic-mirror-session", "traffic-mirror-target", "transit-gateway", "transit-gateway-attachment", "transit-gateway-connect-peer", "transit-gateway-multicast-domain", "transit-gateway-policy-table", "transit-gateway-route-table", "transit-gateway-route-table-announcement", "volume", "vpc", "vpc-endpoint", "vpc-endpoint-connection", "vpc-endpoint-service", "vpc-endpoint-service-permission", "vpc-peering-connection", "vpn-connection", "vpn-gateway", "vpc-flow-log", "capacity-reservation-fleet", "traffic-mirror-filter-rule", "vpc-endpoint-connection-device-type", "verified-access-instance", "verified-access-group", "verified-access-endpoint", "verified-access-policy", "verified-access-trust-provider", "vpn-connection-device-type", "vpc-block-public-access-exclusion", "route-server", "route-server-endpoint", "route-server-peer", "ipam-resource-discovery", "ipam-resource-discovery-association", "instance-connect-endpoint", "verified-access-endpoint-target", "ipam-external-resource-verification-token", "capacity-block", "mac-modification-task"
    #   resp.launch_template_version.launch_template_data.tag_specifications[0].tags #=> Array
    #   resp.launch_template_version.launch_template_data.tag_specifications[0].tags[0].key #=> String
    #   resp.launch_template_version.launch_template_data.tag_specifications[0].tags[0].value #=> String
    #   resp.launch_template_version.launch_template_data.elastic_gpu_specifications #=> Array
    #   resp.launch_template_version.launch_template_data.elastic_gpu_specifications[0].type #=> String
    #   resp.launch_template_version.launch_template_data.elastic_inference_accelerators #=> Array
    #   resp.launch_template_version.launch_template_data.elastic_inference_accelerators[0].type #=> String
    #   resp.launch_template_version.launch_template_data.elastic_inference_accelerators[0].count #=> Integer
    #   resp.launch_template_version.launch_template_data.security_group_ids #=> Array
    #   resp.launch_template_version.launch_template_data.security_group_ids[0] #=> String
    #   resp.launch_template_version.launch_template_data.security_groups #=> Array
    #   resp.launch_template_version.launch_template_data.security_groups[0] #=> String
    #   resp.launch_template_version.launch_template_data.instance_market_options.market_type #=> String, one of "spot", "capacity-block"
    #   resp.launch_template_version.launch_template_data.instance_market_options.spot_options.max_price #=> String
    #   resp.launch_template_version.launch_template_data.instance_market_options.spot_options.spot_instance_type #=> String, one of "one-time", "persistent"
    #   resp.launch_template_version.launch_template_data.instance_market_options.spot_options.block_duration_minutes #=> Integer
    #   resp.launch_template_version.launch_template_data.instance_market_options.spot_options.valid_until #=> Time
    #   resp.launch_template_version.launch_template_data.instance_market_options.spot_options.instance_interruption_behavior #=> String, one of "hibernate", "stop", "terminate"
    #   resp.launch_template_version.launch_template_data.credit_specification.cpu_credits #=> String
    #   resp.launch_template_version.launch_template_data.cpu_options.core_count #=> Integer
    #   resp.launch_template_version.launch_template_data.cpu_options.threads_per_core #=> Integer
    #   resp.launch_template_version.launch_template_data.cpu_options.amd_sev_snp #=> String, one of "enabled", "disabled"
    #   resp.launch_template_version.launch_template_data.capacity_reservation_specification.capacity_reservation_preference #=> String, one of "capacity-reservations-only", "open", "none"
    #   resp.launch_template_version.launch_template_data.capacity_reservation_specification.capacity_reservation_target.capacity_reservation_id #=> String
    #   resp.launch_template_version.launch_template_data.capacity_reservation_specification.capacity_reservation_target.capacity_reservation_resource_group_arn #=> String
    #   resp.launch_template_version.launch_template_data.license_specifications #=> Array
    #   resp.launch_template_version.launch_template_data.license_specifications[0].license_configuration_arn #=> String
    #   resp.launch_template_version.launch_template_data.hibernation_options.configured #=> Boolean
    #   resp.launch_template_version.launch_template_data.metadata_options.state #=> String, one of "pending", "applied"
    #   resp.launch_template_version.launch_template_data.metadata_options.http_tokens #=> String, one of "optional", "required"
    #   resp.launch_template_version.launch_template_data.metadata_options.http_put_response_hop_limit #=> Integer
    #   resp.launch_template_version.launch_template_data.metadata_options.http_endpoint #=> String, one of "disabled", "enabled"
    #   resp.launch_template_version.launch_template_data.metadata_options.http_protocol_ipv_6 #=> String, one of "disabled", "enabled"
    #   resp.launch_template_version.launch_template_data.metadata_options.instance_metadata_tags #=> String, one of "disabled", "enabled"
    #   resp.launch_template_version.launch_template_data.enclave_options.enabled #=> Boolean
    #   resp.launch_template_version.launch_template_data.instance_requirements.v_cpu_count.min #=> Integer
    #   resp.launch_template_version.launch_template_data.instance_requirements.v_cpu_count.max #=> Integer
    #   resp.launch_template_version.launch_template_data.instance_requirements.memory_mi_b.min #=> Integer
    #   resp.launch_template_version.launch_template_data.instance_requirements.memory_mi_b.max #=> Integer
    #   resp.launch_template_version.launch_template_data.instance_requirements.cpu_manufacturers #=> Array
    #   resp.launch_template_version.launch_template_data.instance_requirements.cpu_manufacturers[0] #=> String, one of "intel", "amd", "amazon-web-services", "apple"
    #   resp.launch_template_version.launch_template_data.instance_requirements.memory_gi_b_per_v_cpu.min #=> Float
    #   resp.launch_template_version.launch_template_data.instance_requirements.memory_gi_b_per_v_cpu.max #=> Float
    #   resp.launch_template_version.launch_template_data.instance_requirements.excluded_instance_types #=> Array
    #   resp.launch_template_version.launch_template_data.instance_requirements.excluded_instance_types[0] #=> String
    #   resp.launch_template_version.launch_template_data.instance_requirements.instance_generations #=> Array
    #   resp.launch_template_version.launch_template_data.instance_requirements.instance_generations[0] #=> String, one of "current", "previous"
    #   resp.launch_template_version.launch_template_data.instance_requirements.spot_max_price_percentage_over_lowest_price #=> Integer
    #   resp.launch_template_version.launch_template_data.instance_requirements.on_demand_max_price_percentage_over_lowest_price #=> Integer
    #   resp.launch_template_version.launch_template_data.instance_requirements.bare_metal #=> String, one of "included", "required", "excluded"
    #   resp.launch_template_version.launch_template_data.instance_requirements.burstable_performance #=> String, one of "included", "required", "excluded"
    #   resp.launch_template_version.launch_template_data.instance_requirements.require_hibernate_support #=> Boolean
    #   resp.launch_template_version.launch_template_data.instance_requirements.network_interface_count.min #=> Integer
    #   resp.launch_template_version.launch_template_data.instance_requirements.network_interface_count.max #=> Integer
    #   resp.launch_template_version.launch_template_data.instance_requirements.local_storage #=> String, one of "included", "required", "excluded"
    #   resp.launch_template_version.launch_template_data.instance_requirements.local_storage_types #=> Array
    #   resp.launch_template_version.launch_template_data.instance_requirements.local_storage_types[0] #=> String, one of "hdd", "ssd"
    #   resp.launch_template_version.launch_template_data.instance_requirements.total_local_storage_gb.min #=> Float
    #   resp.launch_template_version.launch_template_data.instance_requirements.total_local_storage_gb.max #=> Float
    #   resp.launch_template_version.launch_template_data.instance_requirements.baseline_ebs_bandwidth_mbps.min #=> Integer
    #   resp.launch_template_version.launch_template_data.instance_requirements.baseline_ebs_bandwidth_mbps.max #=> Integer
    #   resp.launch_template_version.launch_template_data.instance_requirements.accelerator_types #=> Array
    #   resp.launch_template_version.launch_template_data.instance_requirements.accelerator_types[0] #=> String, one of "gpu", "fpga", "inference"
    #   resp.launch_template_version.launch_template_data.instance_requirements.accelerator_count.min #=> Integer
    #   resp.launch_template_version.launch_template_data.instance_requirements.accelerator_count.max #=> Integer
    #   resp.launch_template_version.launch_template_data.instance_requirements.accelerator_manufacturers #=> Array
    #   resp.launch_template_version.launch_template_data.instance_requirements.accelerator_manufacturers[0] #=> String, one of "amazon-web-services", "amd", "nvidia", "xilinx", "habana"
    #   resp.launch_template_version.launch_template_data.instance_requirements.accelerator_names #=> Array
    #   resp.launch_template_version.launch_template_data.instance_requirements.accelerator_names[0] #=> String, one of "a100", "inferentia", "k520", "k80", "m60", "radeon-pro-v520", "t4", "vu9p", "v100", "a10g", "h100", "t4g"
    #   resp.launch_template_version.launch_template_data.instance_requirements.accelerator_total_memory_mi_b.min #=> Integer
    #   resp.launch_template_version.launch_template_data.instance_requirements.accelerator_total_memory_mi_b.max #=> Integer
    #   resp.launch_template_version.launch_template_data.instance_requirements.network_bandwidth_gbps.min #=> Float
    #   resp.launch_template_version.launch_template_data.instance_requirements.network_bandwidth_gbps.max #=> Float
    #   resp.launch_template_version.launch_template_data.instance_requirements.allowed_instance_types #=> Array
    #   resp.launch_template_version.launch_template_data.instance_requirements.allowed_instance_types[0] #=> String
    #   resp.launch_template_version.launch_template_data.instance_requirements.max_spot_price_as_percentage_of_optimal_on_demand_price #=> Integer
    #   resp.launch_template_version.launch_template_data.instance_requirements.baseline_performance_factors.cpu.references #=> Array
    #   resp.launch_template_version.launch_template_data.instance_requirements.baseline_performance_factors.cpu.references[0].instance_family #=> String
    #   resp.launch_template_version.launch_template_data.private_dns_name_options.hostname_type #=> String, one of "ip-name", "resource-name"
    #   resp.launch_template_version.launch_template_data.private_dns_name_options.enable_resource_name_dns_a_record #=> Boolean
    #   resp.launch_template_version.launch_template_data.private_dns_name_options.enable_resource_name_dns_aaaa_record #=> Boolean
    #   resp.launch_template_version.launch_template_data.maintenance_options.auto_recovery #=> String, one of "default", "disabled"
    #   resp.launch_template_version.launch_template_data.disable_api_stop #=> Boolean
    #   resp.launch_template_version.launch_template_data.operator.managed #=> Boolean
    #   resp.launch_template_version.launch_template_data.operator.principal #=> String
    #   resp.launch_template_version.launch_template_data.network_performance_options.bandwidth_weighting #=> String, one of "default", "vpc-1", "ebs-1"
    #   resp.launch_template_version.operator.managed #=> Boolean
    #   resp.launch_template_version.operator.principal #=> String
    #   resp.warning.errors #=> Array
    #   resp.warning.errors[0].code #=> String
    #   resp.warning.errors[0].message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateVersion AWS API Documentation
    #
    # @overload create_launch_template_version(params = {})
    # @param [Hash] params ({})
    def create_launch_template_version(params = {}, options = {})
      req = build_request(:create_launch_template_version, params)
      req.send_request(options)
    end

    # Creates a static route for the specified local gateway route table.
    # You must specify one of the following targets:
    #
    # * `LocalGatewayVirtualInterfaceGroupId`
    #
    # * `NetworkInterfaceId`
    #
    # @option params [String] :destination_cidr_block
    #   The CIDR range used for destination matches. Routing decisions are
    #   based on the most specific match.
    #
    # @option params [required, String] :local_gateway_route_table_id
    #   The ID of the local gateway route table.
    #
    # @option params [String] :local_gateway_virtual_interface_group_id
    #   The ID of the virtual interface group.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :network_interface_id
    #   The ID of the network interface.
    #
    # @option params [String] :destination_prefix_list_id
    #   The ID of the prefix list. Use a prefix list in place of
    #   `DestinationCidrBlock`. You cannot use `DestinationPrefixListId` and
    #   `DestinationCidrBlock` in the same request.
    #
    # @return [Types::CreateLocalGatewayRouteResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateLocalGatewayRouteResult#route #route} => Types::LocalGatewayRoute
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_local_gateway_route({
    #     destination_cidr_block: "String",
    #     local_gateway_route_table_id: "LocalGatewayRoutetableId", # required
    #     local_gateway_virtual_interface_group_id: "LocalGatewayVirtualInterfaceGroupId",
    #     dry_run: false,
    #     network_interface_id: "NetworkInterfaceId",
    #     destination_prefix_list_id: "PrefixListResourceId",
    #   })
    #
    # @example Response structure
    #
    #   resp.route.destination_cidr_block #=> String
    #   resp.route.local_gateway_virtual_interface_group_id #=> String
    #   resp.route.type #=> String, one of "static", "propagated"
    #   resp.route.state #=> String, one of "pending", "active", "blackhole", "deleting", "deleted"
    #   resp.route.local_gateway_route_table_id #=> String
    #   resp.route.local_gateway_route_table_arn #=> String
    #   resp.route.owner_id #=> String
    #   resp.route.subnet_id #=> String
    #   resp.route.coip_pool_id #=> String
    #   resp.route.network_interface_id #=> String
    #   resp.route.destination_prefix_list_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRoute AWS API Documentation
    #
    # @overload create_local_gateway_route(params = {})
    # @param [Hash] params ({})
    def create_local_gateway_route(params = {}, options = {})
      req = build_request(:create_local_gateway_route, params)
      req.send_request(options)
    end

    # Creates a local gateway route table.
    #
    # @option params [required, String] :local_gateway_id
    #   The ID of the local gateway.
    #
    # @option params [String] :mode
    #   The mode of the local gateway route table.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags assigned to the local gateway route table.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateLocalGatewayRouteTableResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateLocalGatewayRouteTableResult#local_gateway_route_table #local_gateway_route_table} => Types::LocalGatewayRouteTable
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_local_gateway_route_table({
    #     local_gateway_id: "LocalGatewayId", # required
    #     mode: "direct-vpc-routing", # accepts direct-vpc-routing, coip
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.local_gateway_route_table.local_gateway_route_table_id #=> String
    #   resp.local_gateway_route_table.local_gateway_route_table_arn #=> String
    #   resp.local_gateway_route_table.local_gateway_id #=> String
    #   resp.local_gateway_route_table.outpost_arn #=> String
    #   resp.local_gateway_route_table.owner_id #=> String
    #   resp.local_gateway_route_table.state #=> String
    #   resp.local_gateway_route_table.tags #=> Array
    #   resp.local_gateway_route_table.tags[0].key #=> String
    #   resp.local_gateway_route_table.tags[0].value #=> String
    #   resp.local_gateway_route_table.mode #=> String, one of "direct-vpc-routing", "coip"
    #   resp.local_gateway_route_table.state_reason.code #=> String
    #   resp.local_gateway_route_table.state_reason.message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTable AWS API Documentation
    #
    # @overload create_local_gateway_route_table(params = {})
    # @param [Hash] params ({})
    def create_local_gateway_route_table(params = {}, options = {})
      req = build_request(:create_local_gateway_route_table, params)
      req.send_request(options)
    end

    # Creates a local gateway route table virtual interface group
    # association.
    #
    # @option params [required, String] :local_gateway_route_table_id
    #   The ID of the local gateway route table.
    #
    # @option params [required, String] :local_gateway_virtual_interface_group_id
    #   The ID of the local gateway route table virtual interface group
    #   association.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags assigned to the local gateway route table virtual interface
    #   group association.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult#local_gateway_route_table_virtual_interface_group_association #local_gateway_route_table_virtual_interface_group_association} => Types::LocalGatewayRouteTableVirtualInterfaceGroupAssociation
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_local_gateway_route_table_virtual_interface_group_association({
    #     local_gateway_route_table_id: "LocalGatewayRoutetableId", # required
    #     local_gateway_virtual_interface_group_id: "LocalGatewayVirtualInterfaceGroupId", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.local_gateway_route_table_virtual_interface_group_association.local_gateway_route_table_virtual_interface_group_association_id #=> String
    #   resp.local_gateway_route_table_virtual_interface_group_association.local_gateway_virtual_interface_group_id #=> String
    #   resp.local_gateway_route_table_virtual_interface_group_association.local_gateway_id #=> String
    #   resp.local_gateway_route_table_virtual_interface_group_association.local_gateway_route_table_id #=> String
    #   resp.local_gateway_route_table_virtual_interface_group_association.local_gateway_route_table_arn #=> String
    #   resp.local_gateway_route_table_virtual_interface_group_association.owner_id #=> String
    #   resp.local_gateway_route_table_virtual_interface_group_association.state #=> String
    #   resp.local_gateway_route_table_virtual_interface_group_association.tags #=> Array
    #   resp.local_gateway_route_table_virtual_interface_group_association.tags[0].key #=> String
    #   resp.local_gateway_route_table_virtual_interface_group_association.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation AWS API Documentation
    #
    # @overload create_local_gateway_route_table_virtual_interface_group_association(params = {})
    # @param [Hash] params ({})
    def create_local_gateway_route_table_virtual_interface_group_association(params = {}, options = {})
      req = build_request(:create_local_gateway_route_table_virtual_interface_group_association, params)
      req.send_request(options)
    end

    # Associates the specified VPC with the specified local gateway route
    # table.
    #
    # @option params [required, String] :local_gateway_route_table_id
    #   The ID of the local gateway route table.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the local gateway route table VPC association.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateLocalGatewayRouteTableVpcAssociationResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateLocalGatewayRouteTableVpcAssociationResult#local_gateway_route_table_vpc_association #local_gateway_route_table_vpc_association} => Types::LocalGatewayRouteTableVpcAssociation
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_local_gateway_route_table_vpc_association({
    #     local_gateway_route_table_id: "LocalGatewayRoutetableId", # required
    #     vpc_id: "VpcId", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.local_gateway_route_table_vpc_association.local_gateway_route_table_vpc_association_id #=> String
    #   resp.local_gateway_route_table_vpc_association.local_gateway_route_table_id #=> String
    #   resp.local_gateway_route_table_vpc_association.local_gateway_route_table_arn #=> String
    #   resp.local_gateway_route_table_vpc_association.local_gateway_id #=> String
    #   resp.local_gateway_route_table_vpc_association.vpc_id #=> String
    #   resp.local_gateway_route_table_vpc_association.owner_id #=> String
    #   resp.local_gateway_route_table_vpc_association.state #=> String
    #   resp.local_gateway_route_table_vpc_association.tags #=> Array
    #   resp.local_gateway_route_table_vpc_association.tags[0].key #=> String
    #   resp.local_gateway_route_table_vpc_association.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVpcAssociation AWS API Documentation
    #
    # @overload create_local_gateway_route_table_vpc_association(params = {})
    # @param [Hash] params ({})
    def create_local_gateway_route_table_vpc_association(params = {}, options = {})
      req = build_request(:create_local_gateway_route_table_vpc_association, params)
      req.send_request(options)
    end

    # Create a virtual interface for a local gateway.
    #
    # @option params [required, String] :local_gateway_virtual_interface_group_id
    #   The ID of the local gateway virtual interface group.
    #
    # @option params [required, String] :outpost_lag_id
    #   References the Link Aggregation Group (LAG) that connects the Outpost
    #   to on-premises network devices.
    #
    # @option params [required, Integer] :vlan
    #   The virtual local area network (VLAN) used for the local gateway
    #   virtual interface.
    #
    # @option params [required, String] :local_address
    #   The IP address assigned to the local gateway virtual interface on the
    #   Outpost side. Only IPv4 is supported.
    #
    # @option params [required, String] :peer_address
    #   The peer IP address for the local gateway virtual interface. Only IPv4
    #   is supported.
    #
    # @option params [Integer] :peer_bgp_asn
    #   The Autonomous System Number (ASN) of the Border Gateway Protocol
    #   (BGP) peer.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to a resource when the local gateway virtual
    #   interface is being created.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Integer] :peer_bgp_asn_extended
    #   The extended 32-bit ASN of the BGP peer for use with larger ASN
    #   values.
    #
    # @return [Types::CreateLocalGatewayVirtualInterfaceResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateLocalGatewayVirtualInterfaceResult#local_gateway_virtual_interface #local_gateway_virtual_interface} => Types::LocalGatewayVirtualInterface
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_local_gateway_virtual_interface({
    #     local_gateway_virtual_interface_group_id: "LocalGatewayVirtualInterfaceGroupId", # required
    #     outpost_lag_id: "OutpostLagId", # required
    #     vlan: 1, # required
    #     local_address: "String", # required
    #     peer_address: "String", # required
    #     peer_bgp_asn: 1,
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #     peer_bgp_asn_extended: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.local_gateway_virtual_interface.local_gateway_virtual_interface_id #=> String
    #   resp.local_gateway_virtual_interface.local_gateway_id #=> String
    #   resp.local_gateway_virtual_interface.local_gateway_virtual_interface_group_id #=> String
    #   resp.local_gateway_virtual_interface.local_gateway_virtual_interface_arn #=> String
    #   resp.local_gateway_virtual_interface.outpost_lag_id #=> String
    #   resp.local_gateway_virtual_interface.vlan #=> Integer
    #   resp.local_gateway_virtual_interface.local_address #=> String
    #   resp.local_gateway_virtual_interface.peer_address #=> String
    #   resp.local_gateway_virtual_interface.local_bgp_asn #=> Integer
    #   resp.local_gateway_virtual_interface.peer_bgp_asn #=> Integer
    #   resp.local_gateway_virtual_interface.peer_bgp_asn_extended #=> Integer
    #   resp.local_gateway_virtual_interface.owner_id #=> String
    #   resp.local_gateway_virtual_interface.tags #=> Array
    #   resp.local_gateway_virtual_interface.tags[0].key #=> String
    #   resp.local_gateway_virtual_interface.tags[0].value #=> String
    #   resp.local_gateway_virtual_interface.configuration_state #=> String, one of "pending", "available", "deleting", "deleted"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayVirtualInterface AWS API Documentation
    #
    # @overload create_local_gateway_virtual_interface(params = {})
    # @param [Hash] params ({})
    def create_local_gateway_virtual_interface(params = {}, options = {})
      req = build_request(:create_local_gateway_virtual_interface, params)
      req.send_request(options)
    end

    # Create a local gateway virtual interface group.
    #
    # @option params [required, String] :local_gateway_id
    #   The ID of the local gateway.
    #
    # @option params [Integer] :local_bgp_asn
    #   The Autonomous System Number(ASN) for the local Border Gateway
    #   Protocol (BGP).
    #
    # @option params [Integer] :local_bgp_asn_extended
    #   The extended 32-bit ASN for the local BGP configuration.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the local gateway virtual interface group when
    #   the resource is being created.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateLocalGatewayVirtualInterfaceGroupResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateLocalGatewayVirtualInterfaceGroupResult#local_gateway_virtual_interface_group #local_gateway_virtual_interface_group} => Types::LocalGatewayVirtualInterfaceGroup
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_local_gateway_virtual_interface_group({
    #     local_gateway_id: "LocalGatewayId", # required
    #     local_bgp_asn: 1,
    #     local_bgp_asn_extended: 1,
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.local_gateway_virtual_interface_group.local_gateway_virtual_interface_group_id #=> String
    #   resp.local_gateway_virtual_interface_group.local_gateway_virtual_interface_ids #=> Array
    #   resp.local_gateway_virtual_interface_group.local_gateway_virtual_interface_ids[0] #=> String
    #   resp.local_gateway_virtual_interface_group.local_gateway_id #=> String
    #   resp.local_gateway_virtual_interface_group.owner_id #=> String
    #   resp.local_gateway_virtual_interface_group.local_bgp_asn #=> Integer
    #   resp.local_gateway_virtual_interface_group.local_bgp_asn_extended #=> Integer
    #   resp.local_gateway_virtual_interface_group.local_gateway_virtual_interface_group_arn #=> String
    #   resp.local_gateway_virtual_interface_group.tags #=> Array
    #   resp.local_gateway_virtual_interface_group.tags[0].key #=> String
    #   resp.local_gateway_virtual_interface_group.tags[0].value #=> String
    #   resp.local_gateway_virtual_interface_group.configuration_state #=> String, one of "pending", "incomplete", "available", "deleting", "deleted"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayVirtualInterfaceGroup AWS API Documentation
    #
    # @overload create_local_gateway_virtual_interface_group(params = {})
    # @param [Hash] params ({})
    def create_local_gateway_virtual_interface_group(params = {}, options = {})
      req = build_request(:create_local_gateway_virtual_interface_group, params)
      req.send_request(options)
    end

    # Creates a System Integrity Protection (SIP) modification task to
    # configure the SIP settings for an x86 Mac instance or Apple silicon
    # Mac instance. For more information, see [ Configure SIP for Amazon EC2
    # instances][1] in the *Amazon EC2 User Guide*.
    #
    # When you configure the SIP settings for your instance, you can either
    # enable or disable all SIP settings, or you can specify a custom SIP
    # configuration that selectively enables or disables specific SIP
    # settings.
    #
    # <note markdown="1"> If you implement a custom configuration, [ connect to the instance and
    # verify the settings][2] to ensure that your requirements are properly
    # implemented and functioning as intended.
    #
    #  SIP configurations might change with macOS updates. We recommend that
    # you review custom SIP settings after any macOS version upgrade to
    # ensure continued compatibility and proper functionality of your
    # security configurations.
    #
    #  </note>
    #
    # To enable or disable all SIP settings, use the
    # **MacSystemIntegrityProtectionStatus** parameter only. For example, to
    # enable all SIP settings, specify the following:
    #
    # * `MacSystemIntegrityProtectionStatus=enabled`
    #
    # ^
    #
    # To specify a custom configuration that selectively enables or disables
    # specific SIP settings, use the **MacSystemIntegrityProtectionStatus**
    # parameter to enable or disable all SIP settings, and then use the
    # **MacSystemIntegrityProtectionConfiguration** parameter to specify
    # exceptions. In this case, the exceptions you specify for
    # **MacSystemIntegrityProtectionConfiguration** override the value you
    # specify for **MacSystemIntegrityProtectionStatus**. For example, to
    # enable all SIP settings, except `NvramProtections`, specify the
    # following:
    #
    # * `MacSystemIntegrityProtectionStatus=enabled`
    #
    # * `MacSystemIntegrityProtectionConfigurationRequest
    #   "NvramProtections=disabled"`
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/mac-sip-settings.html#mac-sip-configure
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/mac-sip-settings.html#mac-sip-check-settings
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :instance_id
    #   The ID of the Amazon EC2 Mac instance.
    #
    # @option params [String] :mac_credentials
    #   **\[Apple silicon Mac instances only\]** Specifies the following
    #   credentials:
    #
    #   * **Internal disk administrative user**
    #
    #     * **Username** - Only the default administrative user
    #       (`aws-managed-user`) is supported and it is used by default. You
    #       can't specify a different administrative user.
    #
    #     * **Password** - If you did not change the default password for
    #       `aws-managed-user`, specify the default password, which is
    #       *blank*. Otherwise, specify your password.
    #   * **Amazon EBS root volume administrative user**
    #
    #     * **Username** - If you did not change the default administrative
    #       user, specify `ec2-user`. Otherwise, specify the username for your
    #       administrative user.
    #
    #     * **Password** - Specify the password for the administrative user.
    #
    #   The credentials must be specified in the following JSON format:
    #
    #   `{ "internalDiskPassword":"internal-disk-admin_password",
    #   "rootVolumeUsername":"root-volume-admin_username",
    #   "rootVolumepassword":"root-volume-admin_password" }`
    #
    # @option params [Types::MacSystemIntegrityProtectionConfigurationRequest] :mac_system_integrity_protection_configuration
    #   Specifies the overrides to selectively enable or disable individual
    #   SIP settings. The individual settings you specify here override the
    #   overall SIP status you specify for
    #   **MacSystemIntegrityProtectionStatus**.
    #
    # @option params [required, String] :mac_system_integrity_protection_status
    #   Specifies the overall SIP status for the instance. To enable all SIP
    #   settings, specify `enabled`. To disable all SIP settings, specify
    #   `disabled`.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   Specifies tags to apply to the SIP modification task.
    #
    # @return [Types::CreateMacSystemIntegrityProtectionModificationTaskResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateMacSystemIntegrityProtectionModificationTaskResult#mac_modification_task #mac_modification_task} => Types::MacModificationTask
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_mac_system_integrity_protection_modification_task({
    #     client_token: "String",
    #     dry_run: false,
    #     instance_id: "InstanceId", # required
    #     mac_credentials: "SensitiveMacCredentials",
    #     mac_system_integrity_protection_configuration: {
    #       apple_internal: "enabled", # accepts enabled, disabled
    #       base_system: "enabled", # accepts enabled, disabled
    #       debugging_restrictions: "enabled", # accepts enabled, disabled
    #       d_trace_restrictions: "enabled", # accepts enabled, disabled
    #       filesystem_protections: "enabled", # accepts enabled, disabled
    #       kext_signing: "enabled", # accepts enabled, disabled
    #       nvram_protections: "enabled", # accepts enabled, disabled
    #     },
    #     mac_system_integrity_protection_status: "enabled", # required, accepts enabled, disabled
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.mac_modification_task.instance_id #=> String
    #   resp.mac_modification_task.mac_modification_task_id #=> String
    #   resp.mac_modification_task.mac_system_integrity_protection_config.apple_internal #=> String, one of "enabled", "disabled"
    #   resp.mac_modification_task.mac_system_integrity_protection_config.base_system #=> String, one of "enabled", "disabled"
    #   resp.mac_modification_task.mac_system_integrity_protection_config.debugging_restrictions #=> String, one of "enabled", "disabled"
    #   resp.mac_modification_task.mac_system_integrity_protection_config.d_trace_restrictions #=> String, one of "enabled", "disabled"
    #   resp.mac_modification_task.mac_system_integrity_protection_config.filesystem_protections #=> String, one of "enabled", "disabled"
    #   resp.mac_modification_task.mac_system_integrity_protection_config.kext_signing #=> String, one of "enabled", "disabled"
    #   resp.mac_modification_task.mac_system_integrity_protection_config.nvram_protections #=> String, one of "enabled", "disabled"
    #   resp.mac_modification_task.mac_system_integrity_protection_config.status #=> String, one of "enabled", "disabled"
    #   resp.mac_modification_task.start_time #=> Time
    #   resp.mac_modification_task.tags #=> Array
    #   resp.mac_modification_task.tags[0].key #=> String
    #   resp.mac_modification_task.tags[0].value #=> String
    #   resp.mac_modification_task.task_state #=> String, one of "successful", "failed", "in-progress", "pending"
    #   resp.mac_modification_task.task_type #=> String, one of "sip-modification", "volume-ownership-delegation"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateMacSystemIntegrityProtectionModificationTask AWS API Documentation
    #
    # @overload create_mac_system_integrity_protection_modification_task(params = {})
    # @param [Hash] params ({})
    def create_mac_system_integrity_protection_modification_task(params = {}, options = {})
      req = build_request(:create_mac_system_integrity_protection_modification_task, params)
      req.send_request(options)
    end

    # Creates a managed prefix list. You can specify entries for the prefix
    # list. Each entry consists of a CIDR block and an optional description.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :prefix_list_name
    #   A name for the prefix list.
    #
    #   Constraints: Up to 255 characters in length. The name cannot start
    #   with `com.amazonaws`.
    #
    # @option params [Array<Types::AddPrefixListEntry>] :entries
    #   One or more entries for the prefix list.
    #
    # @option params [required, Integer] :max_entries
    #   The maximum number of entries for the prefix list.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the prefix list during creation.
    #
    # @option params [required, String] :address_family
    #   The IP address type.
    #
    #   Valid Values: `IPv4` \| `IPv6`
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   Constraints: Up to 255 UTF-8 characters in length.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @return [Types::CreateManagedPrefixListResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateManagedPrefixListResult#prefix_list #prefix_list} => Types::ManagedPrefixList
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_managed_prefix_list({
    #     dry_run: false,
    #     prefix_list_name: "String", # required
    #     entries: [
    #       {
    #         cidr: "String", # required
    #         description: "String",
    #       },
    #     ],
    #     max_entries: 1, # required
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     address_family: "String", # required
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.prefix_list.prefix_list_id #=> String
    #   resp.prefix_list.address_family #=> String
    #   resp.prefix_list.state #=> String, one of "create-in-progress", "create-complete", "create-failed", "modify-in-progress", "modify-complete", "modify-failed", "restore-in-progress", "restore-complete", "restore-failed", "delete-in-progress", "delete-complete", "delete-failed"
    #   resp.prefix_list.state_message #=> String
    #   resp.prefix_list.prefix_list_arn #=> String
    #   resp.prefix_list.prefix_list_name #=> String
    #   resp.prefix_list.max_entries #=> Integer
    #   resp.prefix_list.version #=> Integer
    #   resp.prefix_list.tags #=> Array
    #   resp.prefix_list.tags[0].key #=> String
    #   resp.prefix_list.tags[0].value #=> String
    #   resp.prefix_list.owner_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateManagedPrefixList AWS API Documentation
    #
    # @overload create_managed_prefix_list(params = {})
    # @param [Hash] params ({})
    def create_managed_prefix_list(params = {}, options = {})
      req = build_request(:create_managed_prefix_list, params)
      req.send_request(options)
    end

    # Creates a NAT gateway in the specified subnet. This action creates a
    # network interface in the specified subnet with a private IP address
    # from the IP address range of the subnet. You can create either a
    # public NAT gateway or a private NAT gateway.
    #
    # With a public NAT gateway, internet-bound traffic from a private
    # subnet can be routed to the NAT gateway, so that instances in a
    # private subnet can connect to the internet.
    #
    # With a private NAT gateway, private communication is routed across
    # VPCs and on-premises networks through a transit gateway or virtual
    # private gateway. Common use cases include running large workloads
    # behind a small pool of allowlisted IPv4 addresses, preserving private
    # IPv4 addresses, and communicating between overlapping networks.
    #
    # For more information, see [NAT gateways][1] in the *Amazon VPC User
    # Guide*.
    #
    # When you create a public NAT gateway and assign it an EIP or secondary
    # EIPs, the network border group of the EIPs must match the network
    # border group of the Availability Zone (AZ) that the public NAT gateway
    # is in. If it's not the same, the NAT gateway will fail to launch. You
    # can see the network border group for the subnet's AZ by viewing the
    # details of the subnet. Similarly, you can view the network border
    # group of an EIP by viewing the details of the EIP address. For more
    # information about network border groups and EIPs, see [Allocate an
    # Elastic IP address][2] in the *Amazon VPC User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html
    # [2]: https://docs.aws.amazon.com/vpc/latest/userguide/WorkWithEIPs.html
    #
    # @option params [String] :allocation_id
    #   \[Public NAT gateways only\] The allocation ID of an Elastic IP
    #   address to associate with the NAT gateway. You cannot specify an
    #   Elastic IP address with a private NAT gateway. If the Elastic IP
    #   address is associated with another resource, you must first
    #   disassociate it.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   Constraint: Maximum 64 ASCII characters.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :subnet_id
    #   The ID of the subnet in which to create the NAT gateway.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the NAT gateway.
    #
    # @option params [String] :connectivity_type
    #   Indicates whether the NAT gateway supports public or private
    #   connectivity. The default is public connectivity.
    #
    # @option params [String] :private_ip_address
    #   The private IPv4 address to assign to the NAT gateway. If you don't
    #   provide an address, a private IPv4 address will be automatically
    #   assigned.
    #
    # @option params [Array<String>] :secondary_allocation_ids
    #   Secondary EIP allocation IDs. For more information, see [Create a NAT
    #   gateway][1] in the *Amazon VPC User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html
    #
    # @option params [Array<String>] :secondary_private_ip_addresses
    #   Secondary private IPv4 addresses. For more information about secondary
    #   addresses, see [Create a NAT gateway][1] in the *Amazon VPC User
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html
    #
    # @option params [Integer] :secondary_private_ip_address_count
    #   \[Private NAT gateway only\] The number of secondary private IPv4
    #   addresses you want to assign to the NAT gateway. For more information
    #   about secondary addresses, see [Create a NAT gateway][1] in the
    #   *Amazon VPC User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html
    #
    # @return [Types::CreateNatGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateNatGatewayResult#client_token #client_token} => String
    #   * {Types::CreateNatGatewayResult#nat_gateway #nat_gateway} => Types::NatGateway
    #
    #
    # @example Example: To create a NAT gateway
    #
    #   # This example creates a NAT gateway in subnet subnet-1a2b3c4d and associates an Elastic IP address with the allocation ID
    #   # eipalloc-37fc1a52 with the NAT gateway.
    #
    #   resp = client.create_nat_gateway({
    #     allocation_id: "eipalloc-37fc1a52", 
    #     subnet_id: "subnet-1a2b3c4d", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     nat_gateway: {
    #       create_time: Time.parse("2015-12-17T12:45:26.732Z"), 
    #       nat_gateway_addresses: [
    #         {
    #           allocation_id: "eipalloc-37fc1a52", 
    #         }, 
    #       ], 
    #       nat_gateway_id: "nat-08d48af2a8e83edfd", 
    #       state: "pending", 
    #       subnet_id: "subnet-1a2b3c4d", 
    #       vpc_id: "vpc-1122aabb", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_nat_gateway({
    #     allocation_id: "AllocationId",
    #     client_token: "String",
    #     dry_run: false,
    #     subnet_id: "SubnetId", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     connectivity_type: "private", # accepts private, public
    #     private_ip_address: "String",
    #     secondary_allocation_ids: ["AllocationId"],
    #     secondary_private_ip_addresses: ["String"],
    #     secondary_private_ip_address_count: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.client_token #=> String
    #   resp.nat_gateway.create_time #=> Time
    #   resp.nat_gateway.delete_time #=> Time
    #   resp.nat_gateway.failure_code #=> String
    #   resp.nat_gateway.failure_message #=> String
    #   resp.nat_gateway.nat_gateway_addresses #=> Array
    #   resp.nat_gateway.nat_gateway_addresses[0].allocation_id #=> String
    #   resp.nat_gateway.nat_gateway_addresses[0].network_interface_id #=> String
    #   resp.nat_gateway.nat_gateway_addresses[0].private_ip #=> String
    #   resp.nat_gateway.nat_gateway_addresses[0].public_ip #=> String
    #   resp.nat_gateway.nat_gateway_addresses[0].association_id #=> String
    #   resp.nat_gateway.nat_gateway_addresses[0].is_primary #=> Boolean
    #   resp.nat_gateway.nat_gateway_addresses[0].failure_message #=> String
    #   resp.nat_gateway.nat_gateway_addresses[0].status #=> String, one of "assigning", "unassigning", "associating", "disassociating", "succeeded", "failed"
    #   resp.nat_gateway.nat_gateway_id #=> String
    #   resp.nat_gateway.provisioned_bandwidth.provision_time #=> Time
    #   resp.nat_gateway.provisioned_bandwidth.provisioned #=> String
    #   resp.nat_gateway.provisioned_bandwidth.request_time #=> Time
    #   resp.nat_gateway.provisioned_bandwidth.requested #=> String
    #   resp.nat_gateway.provisioned_bandwidth.status #=> String
    #   resp.nat_gateway.state #=> String, one of "pending", "failed", "available", "deleting", "deleted"
    #   resp.nat_gateway.subnet_id #=> String
    #   resp.nat_gateway.vpc_id #=> String
    #   resp.nat_gateway.tags #=> Array
    #   resp.nat_gateway.tags[0].key #=> String
    #   resp.nat_gateway.tags[0].value #=> String
    #   resp.nat_gateway.connectivity_type #=> String, one of "private", "public"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGateway AWS API Documentation
    #
    # @overload create_nat_gateway(params = {})
    # @param [Hash] params ({})
    def create_nat_gateway(params = {}, options = {})
      req = build_request(:create_nat_gateway, params)
      req.send_request(options)
    end

    # Creates a network ACL in a VPC. Network ACLs provide an optional layer
    # of security (in addition to security groups) for the instances in your
    # VPC.
    #
    # For more information, see [Network ACLs][1] in the *Amazon VPC User
    # Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the network ACL.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @return [Types::CreateNetworkAclResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateNetworkAclResult#network_acl #network_acl} => Types::NetworkAcl
    #   * {Types::CreateNetworkAclResult#client_token #client_token} => String
    #
    #
    # @example Example: To create a network ACL
    #
    #   # This example creates a network ACL for the specified VPC.
    #
    #   resp = client.create_network_acl({
    #     vpc_id: "vpc-a01106c2", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     network_acl: {
    #       associations: [
    #       ], 
    #       entries: [
    #         {
    #           cidr_block: "0.0.0.0/0", 
    #           egress: true, 
    #           protocol: "-1", 
    #           rule_action: "deny", 
    #           rule_number: 32767, 
    #         }, 
    #         {
    #           cidr_block: "0.0.0.0/0", 
    #           egress: false, 
    #           protocol: "-1", 
    #           rule_action: "deny", 
    #           rule_number: 32767, 
    #         }, 
    #       ], 
    #       is_default: false, 
    #       network_acl_id: "acl-5fb85d36", 
    #       tags: [
    #       ], 
    #       vpc_id: "vpc-a01106c2", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_network_acl({
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     client_token: "String",
    #     dry_run: false,
    #     vpc_id: "VpcId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.network_acl.associations #=> Array
    #   resp.network_acl.associations[0].network_acl_association_id #=> String
    #   resp.network_acl.associations[0].network_acl_id #=> String
    #   resp.network_acl.associations[0].subnet_id #=> String
    #   resp.network_acl.entries #=> Array
    #   resp.network_acl.entries[0].cidr_block #=> String
    #   resp.network_acl.entries[0].egress #=> Boolean
    #   resp.network_acl.entries[0].icmp_type_code.code #=> Integer
    #   resp.network_acl.entries[0].icmp_type_code.type #=> Integer
    #   resp.network_acl.entries[0].ipv_6_cidr_block #=> String
    #   resp.network_acl.entries[0].port_range.from #=> Integer
    #   resp.network_acl.entries[0].port_range.to #=> Integer
    #   resp.network_acl.entries[0].protocol #=> String
    #   resp.network_acl.entries[0].rule_action #=> String, one of "allow", "deny"
    #   resp.network_acl.entries[0].rule_number #=> Integer
    #   resp.network_acl.is_default #=> Boolean
    #   resp.network_acl.network_acl_id #=> String
    #   resp.network_acl.tags #=> Array
    #   resp.network_acl.tags[0].key #=> String
    #   resp.network_acl.tags[0].value #=> String
    #   resp.network_acl.vpc_id #=> String
    #   resp.network_acl.owner_id #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAcl AWS API Documentation
    #
    # @overload create_network_acl(params = {})
    # @param [Hash] params ({})
    def create_network_acl(params = {}, options = {})
      req = build_request(:create_network_acl, params)
      req.send_request(options)
    end

    # Creates an entry (a rule) in a network ACL with the specified rule
    # number. Each network ACL has a set of numbered ingress rules and a
    # separate set of numbered egress rules. When determining whether a
    # packet should be allowed in or out of a subnet associated with the
    # ACL, we process the entries in the ACL according to the rule numbers,
    # in ascending order. Each network ACL has a set of ingress rules and a
    # separate set of egress rules.
    #
    # We recommend that you leave room between the rule numbers (for
    # example, 100, 110, 120, ...), and not number them one right after the
    # other (for example, 101, 102, 103, ...). This makes it easier to add a
    # rule between existing ones without having to renumber the rules.
    #
    # After you add an entry, you can't modify it; you must either replace
    # it, or create an entry and delete the old one.
    #
    # For more information about network ACLs, see [Network ACLs][1] in the
    # *Amazon VPC User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/vpc-network-acls.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :network_acl_id
    #   The ID of the network ACL.
    #
    # @option params [required, Integer] :rule_number
    #   The rule number for the entry (for example, 100). ACL entries are
    #   processed in ascending order by rule number.
    #
    #   Constraints: Positive integer from 1 to 32766. The range 32767 to
    #   65535 is reserved for internal use.
    #
    # @option params [required, String] :protocol
    #   The protocol number. A value of "-1" means all protocols. If you
    #   specify "-1" or a protocol number other than "6" (TCP), "17"
    #   (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless of
    #   any ports or ICMP types or codes that you specify. If you specify
    #   protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for
    #   all ICMP types and codes allowed, regardless of any that you specify.
    #   If you specify protocol "58" (ICMPv6) and specify an IPv6 CIDR
    #   block, you must specify an ICMP type and code.
    #
    # @option params [required, String] :rule_action
    #   Indicates whether to allow or deny the traffic that matches the rule.
    #
    # @option params [required, Boolean] :egress
    #   Indicates whether this is an egress rule (rule is applied to traffic
    #   leaving the subnet).
    #
    # @option params [String] :cidr_block
    #   The IPv4 network range to allow or deny, in CIDR notation (for example
    #   `172.16.0.0/24`). We modify the specified CIDR block to its canonical
    #   form; for example, if you specify `100.68.0.18/18`, we modify it to
    #   `100.68.0.0/18`.
    #
    # @option params [String] :ipv_6_cidr_block
    #   The IPv6 network range to allow or deny, in CIDR notation (for example
    #   `2001:db8:1234:1a00::/64`).
    #
    # @option params [Types::IcmpTypeCode] :icmp_type_code
    #   ICMP protocol: The ICMP or ICMPv6 type and code. Required if
    #   specifying protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR
    #   block.
    #
    # @option params [Types::PortRange] :port_range
    #   TCP or UDP protocols: The range of ports the rule applies to. Required
    #   if specifying protocol 6 (TCP) or 17 (UDP).
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To create a network ACL entry
    #
    #   # This example creates an entry for the specified network ACL. The rule allows ingress traffic from anywhere (0.0.0.0/0)
    #   # on UDP port 53 (DNS) into any associated subnet.
    #
    #   resp = client.create_network_acl_entry({
    #     cidr_block: "0.0.0.0/0", 
    #     egress: false, 
    #     network_acl_id: "acl-5fb85d36", 
    #     port_range: {
    #       from: 53, 
    #       to: 53, 
    #     }, 
    #     protocol: "17", 
    #     rule_action: "allow", 
    #     rule_number: 100, 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_network_acl_entry({
    #     dry_run: false,
    #     network_acl_id: "NetworkAclId", # required
    #     rule_number: 1, # required
    #     protocol: "String", # required
    #     rule_action: "allow", # required, accepts allow, deny
    #     egress: false, # required
    #     cidr_block: "String",
    #     ipv_6_cidr_block: "String",
    #     icmp_type_code: {
    #       code: 1,
    #       type: 1,
    #     },
    #     port_range: {
    #       from: 1,
    #       to: 1,
    #     },
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntry AWS API Documentation
    #
    # @overload create_network_acl_entry(params = {})
    # @param [Hash] params ({})
    def create_network_acl_entry(params = {}, options = {})
      req = build_request(:create_network_acl_entry, params)
      req.send_request(options)
    end

    # Creates a Network Access Scope.
    #
    # Amazon Web Services Network Access Analyzer enables cloud networking
    # and cloud operations teams to verify that their networks on Amazon Web
    # Services conform to their network security and governance objectives.
    # For more information, see the [Amazon Web Services Network Access
    # Analyzer Guide][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/network-access-analyzer/
    #
    # @option params [Array<Types::AccessScopePathRequest>] :match_paths
    #   The paths to match.
    #
    # @option params [Array<Types::AccessScopePathRequest>] :exclude_paths
    #   The paths to exclude.
    #
    # @option params [required, String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateNetworkInsightsAccessScopeResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateNetworkInsightsAccessScopeResult#network_insights_access_scope #network_insights_access_scope} => Types::NetworkInsightsAccessScope
    #   * {Types::CreateNetworkInsightsAccessScopeResult#network_insights_access_scope_content #network_insights_access_scope_content} => Types::NetworkInsightsAccessScopeContent
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_network_insights_access_scope({
    #     match_paths: [
    #       {
    #         source: {
    #           packet_header_statement: {
    #             source_addresses: ["String"],
    #             destination_addresses: ["String"],
    #             source_ports: ["String"],
    #             destination_ports: ["String"],
    #             source_prefix_lists: ["String"],
    #             destination_prefix_lists: ["String"],
    #             protocols: ["tcp"], # accepts tcp, udp
    #           },
    #           resource_statement: {
    #             resources: ["String"],
    #             resource_types: ["String"],
    #           },
    #         },
    #         destination: {
    #           packet_header_statement: {
    #             source_addresses: ["String"],
    #             destination_addresses: ["String"],
    #             source_ports: ["String"],
    #             destination_ports: ["String"],
    #             source_prefix_lists: ["String"],
    #             destination_prefix_lists: ["String"],
    #             protocols: ["tcp"], # accepts tcp, udp
    #           },
    #           resource_statement: {
    #             resources: ["String"],
    #             resource_types: ["String"],
    #           },
    #         },
    #         through_resources: [
    #           {
    #             resource_statement: {
    #               resources: ["String"],
    #               resource_types: ["String"],
    #             },
    #           },
    #         ],
    #       },
    #     ],
    #     exclude_paths: [
    #       {
    #         source: {
    #           packet_header_statement: {
    #             source_addresses: ["String"],
    #             destination_addresses: ["String"],
    #             source_ports: ["String"],
    #             destination_ports: ["String"],
    #             source_prefix_lists: ["String"],
    #             destination_prefix_lists: ["String"],
    #             protocols: ["tcp"], # accepts tcp, udp
    #           },
    #           resource_statement: {
    #             resources: ["String"],
    #             resource_types: ["String"],
    #           },
    #         },
    #         destination: {
    #           packet_header_statement: {
    #             source_addresses: ["String"],
    #             destination_addresses: ["String"],
    #             source_ports: ["String"],
    #             destination_ports: ["String"],
    #             source_prefix_lists: ["String"],
    #             destination_prefix_lists: ["String"],
    #             protocols: ["tcp"], # accepts tcp, udp
    #           },
    #           resource_statement: {
    #             resources: ["String"],
    #             resource_types: ["String"],
    #           },
    #         },
    #         through_resources: [
    #           {
    #             resource_statement: {
    #               resources: ["String"],
    #               resource_types: ["String"],
    #             },
    #           },
    #         ],
    #       },
    #     ],
    #     client_token: "String", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.network_insights_access_scope.network_insights_access_scope_id #=> String
    #   resp.network_insights_access_scope.network_insights_access_scope_arn #=> String
    #   resp.network_insights_access_scope.created_date #=> Time
    #   resp.network_insights_access_scope.updated_date #=> Time
    #   resp.network_insights_access_scope.tags #=> Array
    #   resp.network_insights_access_scope.tags[0].key #=> String
    #   resp.network_insights_access_scope.tags[0].value #=> String
    #   resp.network_insights_access_scope_content.network_insights_access_scope_id #=> String
    #   resp.network_insights_access_scope_content.match_paths #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].source.packet_header_statement.source_addresses #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].source.packet_header_statement.source_addresses[0] #=> String
    #   resp.network_insights_access_scope_content.match_paths[0].source.packet_header_statement.destination_addresses #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].source.packet_header_statement.destination_addresses[0] #=> String
    #   resp.network_insights_access_scope_content.match_paths[0].source.packet_header_statement.source_ports #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].source.packet_header_statement.source_ports[0] #=> String
    #   resp.network_insights_access_scope_content.match_paths[0].source.packet_header_statement.destination_ports #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].source.packet_header_statement.destination_ports[0] #=> String
    #   resp.network_insights_access_scope_content.match_paths[0].source.packet_header_statement.source_prefix_lists #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].source.packet_header_statement.source_prefix_lists[0] #=> String
    #   resp.network_insights_access_scope_content.match_paths[0].source.packet_header_statement.destination_prefix_lists #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].source.packet_header_statement.destination_prefix_lists[0] #=> String
    #   resp.network_insights_access_scope_content.match_paths[0].source.packet_header_statement.protocols #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].source.packet_header_statement.protocols[0] #=> String, one of "tcp", "udp"
    #   resp.network_insights_access_scope_content.match_paths[0].source.resource_statement.resources #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].source.resource_statement.resources[0] #=> String
    #   resp.network_insights_access_scope_content.match_paths[0].source.resource_statement.resource_types #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].source.resource_statement.resource_types[0] #=> String
    #   resp.network_insights_access_scope_content.match_paths[0].destination.packet_header_statement.source_addresses #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].destination.packet_header_statement.source_addresses[0] #=> String
    #   resp.network_insights_access_scope_content.match_paths[0].destination.packet_header_statement.destination_addresses #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].destination.packet_header_statement.destination_addresses[0] #=> String
    #   resp.network_insights_access_scope_content.match_paths[0].destination.packet_header_statement.source_ports #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].destination.packet_header_statement.source_ports[0] #=> String
    #   resp.network_insights_access_scope_content.match_paths[0].destination.packet_header_statement.destination_ports #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].destination.packet_header_statement.destination_ports[0] #=> String
    #   resp.network_insights_access_scope_content.match_paths[0].destination.packet_header_statement.source_prefix_lists #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].destination.packet_header_statement.source_prefix_lists[0] #=> String
    #   resp.network_insights_access_scope_content.match_paths[0].destination.packet_header_statement.destination_prefix_lists #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].destination.packet_header_statement.destination_prefix_lists[0] #=> String
    #   resp.network_insights_access_scope_content.match_paths[0].destination.packet_header_statement.protocols #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].destination.packet_header_statement.protocols[0] #=> String, one of "tcp", "udp"
    #   resp.network_insights_access_scope_content.match_paths[0].destination.resource_statement.resources #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].destination.resource_statement.resources[0] #=> String
    #   resp.network_insights_access_scope_content.match_paths[0].destination.resource_statement.resource_types #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].destination.resource_statement.resource_types[0] #=> String
    #   resp.network_insights_access_scope_content.match_paths[0].through_resources #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].through_resources[0].resource_statement.resources #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].through_resources[0].resource_statement.resources[0] #=> String
    #   resp.network_insights_access_scope_content.match_paths[0].through_resources[0].resource_statement.resource_types #=> Array
    #   resp.network_insights_access_scope_content.match_paths[0].through_resources[0].resource_statement.resource_types[0] #=> String
    #   resp.network_insights_access_scope_content.exclude_paths #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].source.packet_header_statement.source_addresses #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].source.packet_header_statement.source_addresses[0] #=> String
    #   resp.network_insights_access_scope_content.exclude_paths[0].source.packet_header_statement.destination_addresses #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].source.packet_header_statement.destination_addresses[0] #=> String
    #   resp.network_insights_access_scope_content.exclude_paths[0].source.packet_header_statement.source_ports #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].source.packet_header_statement.source_ports[0] #=> String
    #   resp.network_insights_access_scope_content.exclude_paths[0].source.packet_header_statement.destination_ports #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].source.packet_header_statement.destination_ports[0] #=> String
    #   resp.network_insights_access_scope_content.exclude_paths[0].source.packet_header_statement.source_prefix_lists #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].source.packet_header_statement.source_prefix_lists[0] #=> String
    #   resp.network_insights_access_scope_content.exclude_paths[0].source.packet_header_statement.destination_prefix_lists #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].source.packet_header_statement.destination_prefix_lists[0] #=> String
    #   resp.network_insights_access_scope_content.exclude_paths[0].source.packet_header_statement.protocols #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].source.packet_header_statement.protocols[0] #=> String, one of "tcp", "udp"
    #   resp.network_insights_access_scope_content.exclude_paths[0].source.resource_statement.resources #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].source.resource_statement.resources[0] #=> String
    #   resp.network_insights_access_scope_content.exclude_paths[0].source.resource_statement.resource_types #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].source.resource_statement.resource_types[0] #=> String
    #   resp.network_insights_access_scope_content.exclude_paths[0].destination.packet_header_statement.source_addresses #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].destination.packet_header_statement.source_addresses[0] #=> String
    #   resp.network_insights_access_scope_content.exclude_paths[0].destination.packet_header_statement.destination_addresses #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].destination.packet_header_statement.destination_addresses[0] #=> String
    #   resp.network_insights_access_scope_content.exclude_paths[0].destination.packet_header_statement.source_ports #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].destination.packet_header_statement.source_ports[0] #=> String
    #   resp.network_insights_access_scope_content.exclude_paths[0].destination.packet_header_statement.destination_ports #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].destination.packet_header_statement.destination_ports[0] #=> String
    #   resp.network_insights_access_scope_content.exclude_paths[0].destination.packet_header_statement.source_prefix_lists #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].destination.packet_header_statement.source_prefix_lists[0] #=> String
    #   resp.network_insights_access_scope_content.exclude_paths[0].destination.packet_header_statement.destination_prefix_lists #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].destination.packet_header_statement.destination_prefix_lists[0] #=> String
    #   resp.network_insights_access_scope_content.exclude_paths[0].destination.packet_header_statement.protocols #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].destination.packet_header_statement.protocols[0] #=> String, one of "tcp", "udp"
    #   resp.network_insights_access_scope_content.exclude_paths[0].destination.resource_statement.resources #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].destination.resource_statement.resources[0] #=> String
    #   resp.network_insights_access_scope_content.exclude_paths[0].destination.resource_statement.resource_types #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].destination.resource_statement.resource_types[0] #=> String
    #   resp.network_insights_access_scope_content.exclude_paths[0].through_resources #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].through_resources[0].resource_statement.resources #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].through_resources[0].resource_statement.resources[0] #=> String
    #   resp.network_insights_access_scope_content.exclude_paths[0].through_resources[0].resource_statement.resource_types #=> Array
    #   resp.network_insights_access_scope_content.exclude_paths[0].through_resources[0].resource_statement.resource_types[0] #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsAccessScope AWS API Documentation
    #
    # @overload create_network_insights_access_scope(params = {})
    # @param [Hash] params ({})
    def create_network_insights_access_scope(params = {}, options = {})
      req = build_request(:create_network_insights_access_scope, params)
      req.send_request(options)
    end

    # Creates a path to analyze for reachability.
    #
    # Reachability Analyzer enables you to analyze and debug network
    # reachability between two resources in your virtual private cloud
    # (VPC). For more information, see the [Reachability Analyzer Guide][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/reachability/
    #
    # @option params [String] :source_ip
    #   The IP address of the source.
    #
    # @option params [String] :destination_ip
    #   The IP address of the destination.
    #
    # @option params [required, String] :source
    #   The ID or ARN of the source. If the resource is in another account,
    #   you must specify an ARN.
    #
    # @option params [String] :destination
    #   The ID or ARN of the destination. If the resource is in another
    #   account, you must specify an ARN.
    #
    # @option params [required, String] :protocol
    #   The protocol.
    #
    # @option params [Integer] :destination_port
    #   The destination port.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to add to the path.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [Types::PathRequestFilter] :filter_at_source
    #   Scopes the analysis to network paths that match specific filters at
    #   the source. If you specify this parameter, you can't specify the
    #   parameters for the source IP address or the destination port.
    #
    # @option params [Types::PathRequestFilter] :filter_at_destination
    #   Scopes the analysis to network paths that match specific filters at
    #   the destination. If you specify this parameter, you can't specify the
    #   parameter for the destination IP address.
    #
    # @return [Types::CreateNetworkInsightsPathResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateNetworkInsightsPathResult#network_insights_path #network_insights_path} => Types::NetworkInsightsPath
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_network_insights_path({
    #     source_ip: "IpAddress",
    #     destination_ip: "IpAddress",
    #     source: "NetworkInsightsResourceId", # required
    #     destination: "NetworkInsightsResourceId",
    #     protocol: "tcp", # required, accepts tcp, udp
    #     destination_port: 1,
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #     client_token: "String", # required
    #     filter_at_source: {
    #       source_address: "IpAddress",
    #       source_port_range: {
    #         from_port: 1,
    #         to_port: 1,
    #       },
    #       destination_address: "IpAddress",
    #       destination_port_range: {
    #         from_port: 1,
    #         to_port: 1,
    #       },
    #     },
    #     filter_at_destination: {
    #       source_address: "IpAddress",
    #       source_port_range: {
    #         from_port: 1,
    #         to_port: 1,
    #       },
    #       destination_address: "IpAddress",
    #       destination_port_range: {
    #         from_port: 1,
    #         to_port: 1,
    #       },
    #     },
    #   })
    #
    # @example Response structure
    #
    #   resp.network_insights_path.network_insights_path_id #=> String
    #   resp.network_insights_path.network_insights_path_arn #=> String
    #   resp.network_insights_path.created_date #=> Time
    #   resp.network_insights_path.source #=> String
    #   resp.network_insights_path.destination #=> String
    #   resp.network_insights_path.source_arn #=> String
    #   resp.network_insights_path.destination_arn #=> String
    #   resp.network_insights_path.source_ip #=> String
    #   resp.network_insights_path.destination_ip #=> String
    #   resp.network_insights_path.protocol #=> String, one of "tcp", "udp"
    #   resp.network_insights_path.destination_port #=> Integer
    #   resp.network_insights_path.tags #=> Array
    #   resp.network_insights_path.tags[0].key #=> String
    #   resp.network_insights_path.tags[0].value #=> String
    #   resp.network_insights_path.filter_at_source.source_address #=> String
    #   resp.network_insights_path.filter_at_source.source_port_range.from_port #=> Integer
    #   resp.network_insights_path.filter_at_source.source_port_range.to_port #=> Integer
    #   resp.network_insights_path.filter_at_source.destination_address #=> String
    #   resp.network_insights_path.filter_at_source.destination_port_range.from_port #=> Integer
    #   resp.network_insights_path.filter_at_source.destination_port_range.to_port #=> Integer
    #   resp.network_insights_path.filter_at_destination.source_address #=> String
    #   resp.network_insights_path.filter_at_destination.source_port_range.from_port #=> Integer
    #   resp.network_insights_path.filter_at_destination.source_port_range.to_port #=> Integer
    #   resp.network_insights_path.filter_at_destination.destination_address #=> String
    #   resp.network_insights_path.filter_at_destination.destination_port_range.from_port #=> Integer
    #   resp.network_insights_path.filter_at_destination.destination_port_range.to_port #=> Integer
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsPath AWS API Documentation
    #
    # @overload create_network_insights_path(params = {})
    # @param [Hash] params ({})
    def create_network_insights_path(params = {}, options = {})
      req = build_request(:create_network_insights_path, params)
      req.send_request(options)
    end

    # Creates a network interface in the specified subnet.
    #
    # The number of IP addresses you can assign to a network interface
    # varies by instance type.
    #
    # For more information about network interfaces, see [Elastic network
    # interfaces][1] in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html
    #
    # @option params [Array<Types::Ipv4PrefixSpecificationRequest>] :ipv_4_prefixes
    #   The IPv4 prefixes assigned to the network interface.
    #
    #   You can't specify IPv4 prefixes if you've specified one of the
    #   following: a count of IPv4 prefixes, specific private IPv4 addresses,
    #   or a count of private IPv4 addresses.
    #
    # @option params [Integer] :ipv_4_prefix_count
    #   The number of IPv4 prefixes that Amazon Web Services automatically
    #   assigns to the network interface.
    #
    #   You can't specify a count of IPv4 prefixes if you've specified one
    #   of the following: specific IPv4 prefixes, specific private IPv4
    #   addresses, or a count of private IPv4 addresses.
    #
    # @option params [Array<Types::Ipv6PrefixSpecificationRequest>] :ipv_6_prefixes
    #   The IPv6 prefixes assigned to the network interface.
    #
    #   You can't specify IPv6 prefixes if you've specified one of the
    #   following: a count of IPv6 prefixes, specific IPv6 addresses, or a
    #   count of IPv6 addresses.
    #
    # @option params [Integer] :ipv_6_prefix_count
    #   The number of IPv6 prefixes that Amazon Web Services automatically
    #   assigns to the network interface.
    #
    #   You can't specify a count of IPv6 prefixes if you've specified one
    #   of the following: specific IPv6 prefixes, specific IPv6 addresses, or
    #   a count of IPv6 addresses.
    #
    # @option params [String] :interface_type
    #   The type of network interface. The default is `interface`.
    #
    #   If you specify `efa-only`, do not assign any IP addresses to the
    #   network interface. EFA-only network interfaces do not support IP
    #   addresses.
    #
    #   The only supported values are `interface`, `efa`, `efa-only`, and
    #   `trunk`.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the new network interface.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [Boolean] :enable_primary_ipv_6
    #   If you’re creating a network interface in a dual-stack or IPv6-only
    #   subnet, you have the option to assign a primary IPv6 IP address. A
    #   primary IPv6 address is an IPv6 GUA address associated with an ENI
    #   that you have enabled to use a primary IPv6 address. Use this option
    #   if the instance that this ENI will be attached to relies on its IPv6
    #   address not changing. Amazon Web Services will automatically assign an
    #   IPv6 address associated with the ENI attached to your instance to be
    #   the primary IPv6 address. Once you enable an IPv6 GUA address to be a
    #   primary IPv6, you cannot disable it. When you enable an IPv6 GUA
    #   address to be a primary IPv6, the first IPv6 GUA will be made the
    #   primary IPv6 address until the instance is terminated or the network
    #   interface is detached. If you have multiple IPv6 addresses associated
    #   with an ENI attached to your instance and you enable a primary IPv6
    #   address, the first IPv6 GUA address associated with the ENI becomes
    #   the primary IPv6 address.
    #
    # @option params [Types::ConnectionTrackingSpecificationRequest] :connection_tracking_specification
    #   A connection tracking specification for the network interface.
    #
    # @option params [Types::OperatorRequest] :operator
    #   Reserved for internal use.
    #
    # @option params [required, String] :subnet_id
    #   The ID of the subnet to associate with the network interface.
    #
    # @option params [String] :description
    #   A description for the network interface.
    #
    # @option params [String] :private_ip_address
    #   The primary private IPv4 address of the network interface. If you
    #   don't specify an IPv4 address, Amazon EC2 selects one for you from
    #   the subnet's IPv4 CIDR range. If you specify an IP address, you
    #   cannot indicate any IP addresses specified in `privateIpAddresses` as
    #   primary (only one IP address can be designated as primary).
    #
    # @option params [Array<String>] :groups
    #   The IDs of the security groups.
    #
    # @option params [Array<Types::PrivateIpAddressSpecification>] :private_ip_addresses
    #   The private IPv4 addresses.
    #
    #   You can't specify private IPv4 addresses if you've specified one of
    #   the following: a count of private IPv4 addresses, specific IPv4
    #   prefixes, or a count of IPv4 prefixes.
    #
    # @option params [Integer] :secondary_private_ip_address_count
    #   The number of secondary private IPv4 addresses to assign to a network
    #   interface. When you specify a number of secondary IPv4 addresses,
    #   Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR
    #   range. You can't specify this option and specify more than one
    #   private IP address using `privateIpAddresses`.
    #
    #   You can't specify a count of private IPv4 addresses if you've
    #   specified one of the following: specific private IPv4 addresses,
    #   specific IPv4 prefixes, or a count of IPv4 prefixes.
    #
    # @option params [Array<Types::InstanceIpv6Address>] :ipv_6_addresses
    #   The IPv6 addresses from the IPv6 CIDR block range of your subnet.
    #
    #   You can't specify IPv6 addresses using this parameter if you've
    #   specified one of the following: a count of IPv6 addresses, specific
    #   IPv6 prefixes, or a count of IPv6 prefixes.
    #
    # @option params [Integer] :ipv_6_address_count
    #   The number of IPv6 addresses to assign to a network interface. Amazon
    #   EC2 automatically selects the IPv6 addresses from the subnet range.
    #
    #   You can't specify a count of IPv6 addresses using this parameter if
    #   you've specified one of the following: specific IPv6 addresses,
    #   specific IPv6 prefixes, or a count of IPv6 prefixes.
    #
    #   If your subnet has the `AssignIpv6AddressOnCreation` attribute set,
    #   you can override that setting by specifying 0 as the IPv6 address
    #   count.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateNetworkInterfaceResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateNetworkInterfaceResult#network_interface #network_interface} => Types::NetworkInterface
    #   * {Types::CreateNetworkInterfaceResult#client_token #client_token} => String
    #
    #
    # @example Example: To create a network interface
    #
    #   # This example creates a network interface for the specified subnet.
    #
    #   resp = client.create_network_interface({
    #     description: "my network interface", 
    #     groups: [
    #       "sg-903004f8", 
    #     ], 
    #     private_ip_address: "10.0.2.17", 
    #     subnet_id: "subnet-9d4a7b6c", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     network_interface: {
    #       availability_zone: "us-east-1d", 
    #       description: "my network interface", 
    #       groups: [
    #         {
    #           group_id: "sg-903004f8", 
    #           group_name: "default", 
    #         }, 
    #       ], 
    #       mac_address: "02:1a:80:41:52:9c", 
    #       network_interface_id: "eni-e5aa89a3", 
    #       owner_id: "123456789012", 
    #       private_ip_address: "10.0.2.17", 
    #       private_ip_addresses: [
    #         {
    #           primary: true, 
    #           private_ip_address: "10.0.2.17", 
    #         }, 
    #       ], 
    #       requester_managed: false, 
    #       source_dest_check: true, 
    #       status: "pending", 
    #       subnet_id: "subnet-9d4a7b6c", 
    #       tag_set: [
    #       ], 
    #       vpc_id: "vpc-a01106c2", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_network_interface({
    #     ipv_4_prefixes: [
    #       {
    #         ipv_4_prefix: "String",
    #       },
    #     ],
    #     ipv_4_prefix_count: 1,
    #     ipv_6_prefixes: [
    #       {
    #         ipv_6_prefix: "String",
    #       },
    #     ],
    #     ipv_6_prefix_count: 1,
    #     interface_type: "efa", # accepts efa, efa-only, branch, trunk
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     client_token: "String",
    #     enable_primary_ipv_6: false,
    #     connection_tracking_specification: {
    #       tcp_established_timeout: 1,
    #       udp_stream_timeout: 1,
    #       udp_timeout: 1,
    #     },
    #     operator: {
    #       principal: "String",
    #     },
    #     subnet_id: "SubnetId", # required
    #     description: "String",
    #     private_ip_address: "String",
    #     groups: ["SecurityGroupId"],
    #     private_ip_addresses: [
    #       {
    #         primary: false,
    #         private_ip_address: "String",
    #       },
    #     ],
    #     secondary_private_ip_address_count: 1,
    #     ipv_6_addresses: [
    #       {
    #         ipv_6_address: "String",
    #         is_primary_ipv_6: false,
    #       },
    #     ],
    #     ipv_6_address_count: 1,
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.network_interface.association.allocation_id #=> String
    #   resp.network_interface.association.association_id #=> String
    #   resp.network_interface.association.ip_owner_id #=> String
    #   resp.network_interface.association.public_dns_name #=> String
    #   resp.network_interface.association.public_ip #=> String
    #   resp.network_interface.association.customer_owned_ip #=> String
    #   resp.network_interface.association.carrier_ip #=> String
    #   resp.network_interface.attachment.attach_time #=> Time
    #   resp.network_interface.attachment.attachment_id #=> String
    #   resp.network_interface.attachment.delete_on_termination #=> Boolean
    #   resp.network_interface.attachment.device_index #=> Integer
    #   resp.network_interface.attachment.network_card_index #=> Integer
    #   resp.network_interface.attachment.instance_id #=> String
    #   resp.network_interface.attachment.instance_owner_id #=> String
    #   resp.network_interface.attachment.status #=> String, one of "attaching", "attached", "detaching", "detached"
    #   resp.network_interface.attachment.ena_srd_specification.ena_srd_enabled #=> Boolean
    #   resp.network_interface.attachment.ena_srd_specification.ena_srd_udp_specification.ena_srd_udp_enabled #=> Boolean
    #   resp.network_interface.attachment.ena_queue_count #=> Integer
    #   resp.network_interface.availability_zone #=> String
    #   resp.network_interface.connection_tracking_configuration.tcp_established_timeout #=> Integer
    #   resp.network_interface.connection_tracking_configuration.udp_stream_timeout #=> Integer
    #   resp.network_interface.connection_tracking_configuration.udp_timeout #=> Integer
    #   resp.network_interface.description #=> String
    #   resp.network_interface.groups #=> Array
    #   resp.network_interface.groups[0].group_id #=> String
    #   resp.network_interface.groups[0].group_name #=> String
    #   resp.network_interface.interface_type #=> String, one of "interface", "natGateway", "efa", "efa-only", "trunk", "load_balancer", "network_load_balancer", "vpc_endpoint", "branch", "transit_gateway", "lambda", "quicksight", "global_accelerator_managed", "api_gateway_managed", "gateway_load_balancer", "gateway_load_balancer_endpoint", "iot_rules_managed", "aws_codestar_connections_managed"
    #   resp.network_interface.ipv_6_addresses #=> Array
    #   resp.network_interface.ipv_6_addresses[0].ipv_6_address #=> String
    #   resp.network_interface.ipv_6_addresses[0].public_ipv_6_dns_name #=> String
    #   resp.network_interface.ipv_6_addresses[0].is_primary_ipv_6 #=> Boolean
    #   resp.network_interface.mac_address #=> String
    #   resp.network_interface.network_interface_id #=> String
    #   resp.network_interface.outpost_arn #=> String
    #   resp.network_interface.owner_id #=> String
    #   resp.network_interface.private_dns_name #=> String
    #   resp.network_interface.public_dns_name #=> String
    #   resp.network_interface.public_ip_dns_name_options.dns_hostname_type #=> String
    #   resp.network_interface.public_ip_dns_name_options.public_ipv_4_dns_name #=> String
    #   resp.network_interface.public_ip_dns_name_options.public_ipv_6_dns_name #=> String
    #   resp.network_interface.public_ip_dns_name_options.public_dual_stack_dns_name #=> String
    #   resp.network_interface.private_ip_address #=> String
    #   resp.network_interface.private_ip_addresses #=> Array
    #   resp.network_interface.private_ip_addresses[0].association.allocation_id #=> String
    #   resp.network_interface.private_ip_addresses[0].association.association_id #=> String
    #   resp.network_interface.private_ip_addresses[0].association.ip_owner_id #=> String
    #   resp.network_interface.private_ip_addresses[0].association.public_dns_name #=> String
    #   resp.network_interface.private_ip_addresses[0].association.public_ip #=> String
    #   resp.network_interface.private_ip_addresses[0].association.customer_owned_ip #=> String
    #   resp.network_interface.private_ip_addresses[0].association.carrier_ip #=> String
    #   resp.network_interface.private_ip_addresses[0].primary #=> Boolean
    #   resp.network_interface.private_ip_addresses[0].private_dns_name #=> String
    #   resp.network_interface.private_ip_addresses[0].private_ip_address #=> String
    #   resp.network_interface.ipv_4_prefixes #=> Array
    #   resp.network_interface.ipv_4_prefixes[0].ipv_4_prefix #=> String
    #   resp.network_interface.ipv_6_prefixes #=> Array
    #   resp.network_interface.ipv_6_prefixes[0].ipv_6_prefix #=> String
    #   resp.network_interface.requester_id #=> String
    #   resp.network_interface.requester_managed #=> Boolean
    #   resp.network_interface.source_dest_check #=> Boolean
    #   resp.network_interface.status #=> String, one of "available", "associated", "attaching", "in-use", "detaching"
    #   resp.network_interface.subnet_id #=> String
    #   resp.network_interface.tag_set #=> Array
    #   resp.network_interface.tag_set[0].key #=> String
    #   resp.network_interface.tag_set[0].value #=> String
    #   resp.network_interface.vpc_id #=> String
    #   resp.network_interface.deny_all_igw_traffic #=> Boolean
    #   resp.network_interface.ipv_6_native #=> Boolean
    #   resp.network_interface.ipv_6_address #=> String
    #   resp.network_interface.operator.managed #=> Boolean
    #   resp.network_interface.operator.principal #=> String
    #   resp.network_interface.associated_subnets #=> Array
    #   resp.network_interface.associated_subnets[0] #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterface AWS API Documentation
    #
    # @overload create_network_interface(params = {})
    # @param [Hash] params ({})
    def create_network_interface(params = {}, options = {})
      req = build_request(:create_network_interface, params)
      req.send_request(options)
    end

    # Grants an Amazon Web Services-authorized account permission to attach
    # the specified network interface to an instance in their account.
    #
    # You can grant permission to a single Amazon Web Services account only,
    # and only one account at a time.
    #
    # @option params [required, String] :network_interface_id
    #   The ID of the network interface.
    #
    # @option params [String] :aws_account_id
    #   The Amazon Web Services account ID.
    #
    # @option params [String] :aws_service
    #   The Amazon Web Services service. Currently not supported.
    #
    # @option params [required, String] :permission
    #   The type of permission to grant.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateNetworkInterfacePermissionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateNetworkInterfacePermissionResult#interface_permission #interface_permission} => Types::NetworkInterfacePermission
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_network_interface_permission({
    #     network_interface_id: "NetworkInterfaceId", # required
    #     aws_account_id: "String",
    #     aws_service: "String",
    #     permission: "INSTANCE-ATTACH", # required, accepts INSTANCE-ATTACH, EIP-ASSOCIATE
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.interface_permission.network_interface_permission_id #=> String
    #   resp.interface_permission.network_interface_id #=> String
    #   resp.interface_permission.aws_account_id #=> String
    #   resp.interface_permission.aws_service #=> String
    #   resp.interface_permission.permission #=> String, one of "INSTANCE-ATTACH", "EIP-ASSOCIATE"
    #   resp.interface_permission.permission_state.state #=> String, one of "pending", "granted", "revoking", "revoked"
    #   resp.interface_permission.permission_state.status_message #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermission AWS API Documentation
    #
    # @overload create_network_interface_permission(params = {})
    # @param [Hash] params ({})
    def create_network_interface_permission(params = {}, options = {})
      req = build_request(:create_network_interface_permission, params)
      req.send_request(options)
    end

    # Creates a placement group in which to launch instances. The strategy
    # of the placement group determines how the instances are organized
    # within the group.
    #
    # A `cluster` placement group is a logical grouping of instances within
    # a single Availability Zone that benefit from low network latency, high
    # network throughput. A `spread` placement group places instances on
    # distinct hardware. A `partition` placement group places groups of
    # instances in different partitions, where instances in one partition do
    # not share the same hardware with instances in another partition.
    #
    # For more information, see [Placement groups][1] in the *Amazon EC2
    # User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html
    #
    # @option params [Integer] :partition_count
    #   The number of partitions. Valid only when **Strategy** is set to
    #   `partition`.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the new placement group.
    #
    # @option params [String] :spread_level
    #   Determines how placement groups spread instances.
    #
    #   * Host – You can use `host` only with Outpost placement groups.
    #
    #   * Rack – No usage restrictions.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the operation,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :group_name
    #   A name for the placement group. Must be unique within the scope of
    #   your account for the Region.
    #
    #   Constraints: Up to 255 ASCII characters
    #
    # @option params [String] :strategy
    #   The placement strategy.
    #
    # @return [Types::CreatePlacementGroupResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreatePlacementGroupResult#placement_group #placement_group} => Types::PlacementGroup
    #
    #
    # @example Example: To create a placement group
    #
    #   # This example creates a placement group with the specified name.
    #
    #   resp = client.create_placement_group({
    #     group_name: "my-cluster", 
    #     strategy: "cluster", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_placement_group({
    #     partition_count: 1,
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     spread_level: "host", # accepts host, rack
    #     dry_run: false,
    #     group_name: "String",
    #     strategy: "cluster", # accepts cluster, spread, partition
    #   })
    #
    # @example Response structure
    #
    #   resp.placement_group.group_name #=> String
    #   resp.placement_group.state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.placement_group.strategy #=> String, one of "cluster", "spread", "partition"
    #   resp.placement_group.partition_count #=> Integer
    #   resp.placement_group.group_id #=> String
    #   resp.placement_group.tags #=> Array
    #   resp.placement_group.tags[0].key #=> String
    #   resp.placement_group.tags[0].value #=> String
    #   resp.placement_group.group_arn #=> String
    #   resp.placement_group.spread_level #=> String, one of "host", "rack"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroup AWS API Documentation
    #
    # @overload create_placement_group(params = {})
    # @param [Hash] params ({})
    def create_placement_group(params = {}, options = {})
      req = build_request(:create_placement_group, params)
      req.send_request(options)
    end

    # Creates a public IPv4 address pool. A public IPv4 pool is an EC2 IP
    # address pool required for the public IPv4 CIDRs that you own and bring
    # to Amazon Web Services to manage with IPAM. IPv6 addresses you bring
    # to Amazon Web Services, however, use IPAM pools only. To monitor the
    # status of pool creation, use [DescribePublicIpv4Pools][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribePublicIpv4Pools.html
    #
    # @option params [Boolean] :dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response. If
    #   you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The key/value combination of a tag assigned to the resource. Use the
    #   tag key in the filter name and the tag value as the filter value. For
    #   example, to find all resources that have a tag with the key `Owner`
    #   and the value `TeamA`, specify `tag:Owner` for the filter name and
    #   `TeamA` for the filter value.
    #
    # @option params [String] :network_border_group
    #   The Availability Zone (AZ) or Local Zone (LZ) network border group
    #   that the resource that the IP address is assigned to is in. Defaults
    #   to an AZ network border group. For more information on available Local
    #   Zones, see [Local Zone availability][1] in the *Amazon EC2 User
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#byoip-zone-avail
    #
    # @return [Types::CreatePublicIpv4PoolResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreatePublicIpv4PoolResult#pool_id #pool_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_public_ipv_4_pool({
    #     dry_run: false,
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     network_border_group: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.pool_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePublicIpv4Pool AWS API Documentation
    #
    # @overload create_public_ipv_4_pool(params = {})
    # @param [Hash] params ({})
    def create_public_ipv_4_pool(params = {}, options = {})
      req = build_request(:create_public_ipv_4_pool, params)
      req.send_request(options)
    end

    # Replaces the EBS-backed root volume for a `running` instance with a
    # new volume that is restored to the original root volume's launch
    # state, that is restored to a specific snapshot taken from the original
    # root volume, or that is restored from an AMI that has the same key
    # characteristics as that of the instance.
    #
    # For more information, see [Replace a root volume][1] in the *Amazon
    # EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/replace-root.html
    #
    # @option params [required, String] :instance_id
    #   The ID of the instance for which to replace the root volume.
    #
    # @option params [String] :snapshot_id
    #   The ID of the snapshot from which to restore the replacement root
    #   volume. The specified snapshot must be a snapshot that you previously
    #   created from the original root volume.
    #
    #   If you want to restore the replacement root volume to the initial
    #   launch state, or if you want to restore the replacement root volume
    #   from an AMI, omit this parameter.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. If you do not specify a client token, a
    #   randomly generated token is used for the request to ensure
    #   idempotency. For more information, see [Ensuring idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the root volume replacement task.
    #
    # @option params [String] :image_id
    #   The ID of the AMI to use to restore the root volume. The specified AMI
    #   must have the same product code, billing information, architecture
    #   type, and virtualization type as that of the instance.
    #
    #   If you want to restore the replacement volume from a specific
    #   snapshot, or if you want to restore it to its launch state, omit this
    #   parameter.
    #
    # @option params [Boolean] :delete_replaced_root_volume
    #   Indicates whether to automatically delete the original root volume
    #   after the root volume replacement task completes. To delete the
    #   original root volume, specify `true`. If you choose to keep the
    #   original root volume after the replacement task completes, you must
    #   manually delete it when you no longer need it.
    #
    # @option params [Integer] :volume_initialization_rate
    #   Specifies the Amazon EBS Provisioned Rate for Volume Initialization
    #   (volume initialization rate), in MiB/s, at which to download the
    #   snapshot blocks from Amazon S3 to the replacement root volume. This is
    #   also known as *volume initialization*. Specifying a volume
    #   initialization rate ensures that the volume is initialized at a
    #   predictable and consistent rate after creation.
    #
    #   Omit this parameter if:
    #
    #   * You want to create the volume using fast snapshot restore. You must
    #     specify a snapshot that is enabled for fast snapshot restore. In
    #     this case, the volume is fully initialized at creation.
    #
    #     <note markdown="1"> If you specify a snapshot that is enabled for fast snapshot restore
    #     and a volume initialization rate, the volume will be initialized at
    #     the specified rate instead of fast snapshot restore.
    #
    #      </note>
    #
    #   * You want to create a volume that is initialized at the default rate.
    #
    #   For more information, see [ Initialize Amazon EBS volumes][1] in the
    #   *Amazon EC2 User Guide*.
    #
    #   Valid range: 100 - 300 MiB/s
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/initalize-volume.html
    #
    # @return [Types::CreateReplaceRootVolumeTaskResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateReplaceRootVolumeTaskResult#replace_root_volume_task #replace_root_volume_task} => Types::ReplaceRootVolumeTask
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_replace_root_volume_task({
    #     instance_id: "InstanceId", # required
    #     snapshot_id: "SnapshotId",
    #     client_token: "String",
    #     dry_run: false,
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     image_id: "ImageId",
    #     delete_replaced_root_volume: false,
    #     volume_initialization_rate: 1,
    #   })
    #
    # @example Response structure
    #
    #   resp.replace_root_volume_task.replace_root_volume_task_id #=> String
    #   resp.replace_root_volume_task.instance_id #=> String
    #   resp.replace_root_volume_task.task_state #=> String, one of "pending", "in-progress", "failing", "succeeded", "failed", "failed-detached"
    #   resp.replace_root_volume_task.start_time #=> String
    #   resp.replace_root_volume_task.complete_time #=> String
    #   resp.replace_root_volume_task.tags #=> Array
    #   resp.replace_root_volume_task.tags[0].key #=> String
    #   resp.replace_root_volume_task.tags[0].value #=> String
    #   resp.replace_root_volume_task.image_id #=> String
    #   resp.replace_root_volume_task.snapshot_id #=> String
    #   resp.replace_root_volume_task.delete_replaced_root_volume #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReplaceRootVolumeTask AWS API Documentation
    #
    # @overload create_replace_root_volume_task(params = {})
    # @param [Hash] params ({})
    def create_replace_root_volume_task(params = {}, options = {})
      req = build_request(:create_replace_root_volume_task, params)
      req.send_request(options)
    end

    # Creates a listing for Amazon EC2 Standard Reserved Instances to be
    # sold in the Reserved Instance Marketplace. You can submit one Standard
    # Reserved Instance listing at a time. To get a list of your Standard
    # Reserved Instances, you can use the DescribeReservedInstances
    # operation.
    #
    # <note markdown="1"> Only Standard Reserved Instances can be sold in the Reserved Instance
    # Marketplace. Convertible Reserved Instances cannot be sold.
    #
    #  </note>
    #
    # The Reserved Instance Marketplace matches sellers who want to resell
    # Standard Reserved Instance capacity that they no longer need with
    # buyers who want to purchase additional capacity. Reserved Instances
    # bought and sold through the Reserved Instance Marketplace work like
    # any other Reserved Instances.
    #
    # To sell your Standard Reserved Instances, you must first register as a
    # seller in the Reserved Instance Marketplace. After completing the
    # registration process, you can create a Reserved Instance Marketplace
    # listing of some or all of your Standard Reserved Instances, and
    # specify the upfront price to receive for them. Your Standard Reserved
    # Instance listings then become available for purchase. To view the
    # details of your Standard Reserved Instance listing, you can use the
    # DescribeReservedInstancesListings operation.
    #
    # For more information, see [Sell in the Reserved Instance
    # Marketplace][1] in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html
    #
    # @option params [required, String] :reserved_instances_id
    #   The ID of the active Standard Reserved Instance.
    #
    # @option params [required, Integer] :instance_count
    #   The number of instances that are a part of a Reserved Instance account
    #   to be listed in the Reserved Instance Marketplace. This number should
    #   be less than or equal to the instance count associated with the
    #   Reserved Instance ID specified in this call.
    #
    # @option params [required, Array<Types::PriceScheduleSpecification>] :price_schedules
    #   A list specifying the price of the Standard Reserved Instance for each
    #   month remaining in the Reserved Instance term.
    #
    # @option params [required, String] :client_token
    #   Unique, case-sensitive identifier you provide to ensure idempotency of
    #   your listings. This helps avoid duplicate listings. For more
    #   information, see [Ensuring Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #
    # @return [Types::CreateReservedInstancesListingResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateReservedInstancesListingResult#reserved_instances_listings #reserved_instances_listings} => Array&lt;Types::ReservedInstancesListing&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_reserved_instances_listing({
    #     reserved_instances_id: "ReservationId", # required
    #     instance_count: 1, # required
    #     price_schedules: [ # required
    #       {
    #         term: 1,
    #         price: 1.0,
    #         currency_code: "USD", # accepts USD
    #       },
    #     ],
    #     client_token: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.reserved_instances_listings #=> Array
    #   resp.reserved_instances_listings[0].client_token #=> String
    #   resp.reserved_instances_listings[0].create_date #=> Time
    #   resp.reserved_instances_listings[0].instance_counts #=> Array
    #   resp.reserved_instances_listings[0].instance_counts[0].instance_count #=> Integer
    #   resp.reserved_instances_listings[0].instance_counts[0].state #=> String, one of "available", "sold", "cancelled", "pending"
    #   resp.reserved_instances_listings[0].price_schedules #=> Array
    #   resp.reserved_instances_listings[0].price_schedules[0].active #=> Boolean
    #   resp.reserved_instances_listings[0].price_schedules[0].currency_code #=> String, one of "USD"
    #   resp.reserved_instances_listings[0].price_schedules[0].price #=> Float
    #   resp.reserved_instances_listings[0].price_schedules[0].term #=> Integer
    #   resp.reserved_instances_listings[0].reserved_instances_id #=> String
    #   resp.reserved_instances_listings[0].reserved_instances_listing_id #=> String
    #   resp.reserved_instances_listings[0].status #=> String, one of "active", "pending", "cancelled", "closed"
    #   resp.reserved_instances_listings[0].status_message #=> String
    #   resp.reserved_instances_listings[0].tags #=> Array
    #   resp.reserved_instances_listings[0].tags[0].key #=> String
    #   resp.reserved_instances_listings[0].tags[0].value #=> String
    #   resp.reserved_instances_listings[0].update_date #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListing AWS API Documentation
    #
    # @overload create_reserved_instances_listing(params = {})
    # @param [Hash] params ({})
    def create_reserved_instances_listing(params = {}, options = {})
      req = build_request(:create_reserved_instances_listing, params)
      req.send_request(options)
    end

    # Starts a task that restores an AMI from an Amazon S3 object that was
    # previously created by using [CreateStoreImageTask][1].
    #
    # To use this API, you must have the required permissions. For more
    # information, see [Permissions for storing and restoring AMIs using
    # S3][2] in the *Amazon EC2 User Guide*.
    #
    # For more information, see [Store and restore an AMI using S3][3] in
    # the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-ami-store-restore.html#ami-s3-permissions
    # [3]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html
    #
    # @option params [required, String] :bucket
    #   The name of the Amazon S3 bucket that contains the stored AMI object.
    #
    # @option params [required, String] :object_key
    #   The name of the stored AMI object in the bucket.
    #
    # @option params [String] :name
    #   The name for the restored AMI. The name must be unique for AMIs in the
    #   Region for this account. If you do not provide a name, the new AMI
    #   gets the same name as the original AMI.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the AMI and snapshots on restoration. You can tag
    #   the AMI, the snapshots, or both.
    #
    #   * To tag the AMI, the value for `ResourceType` must be `image`.
    #
    #   * To tag the snapshots, the value for `ResourceType` must be
    #     `snapshot`. The same tag is applied to all of the snapshots that are
    #     created.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateRestoreImageTaskResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateRestoreImageTaskResult#image_id #image_id} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_restore_image_task({
    #     bucket: "String", # required
    #     object_key: "String", # required
    #     name: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.image_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRestoreImageTask AWS API Documentation
    #
    # @overload create_restore_image_task(params = {})
    # @param [Hash] params ({})
    def create_restore_image_task(params = {}, options = {})
      req = build_request(:create_restore_image_task, params)
      req.send_request(options)
    end

    # Creates a route in a route table within a VPC.
    #
    # You must specify either a destination CIDR block or a prefix list ID.
    # You must also specify exactly one of the resources from the parameter
    # list.
    #
    # When determining how to route traffic, we use the route with the most
    # specific match. For example, traffic is destined for the IPv4 address
    # `192.0.2.3`, and the route table includes the following two IPv4
    # routes:
    #
    # * `192.0.2.0/24` (goes to some target A)
    #
    # * `192.0.2.0/28` (goes to some target B)
    #
    # Both routes apply to the traffic destined for `192.0.2.3`. However,
    # the second route in the list covers a smaller number of IP addresses
    # and is therefore more specific, so we use that route to determine
    # where to target the traffic.
    #
    # For more information about route tables, see [Route tables][1] in the
    # *Amazon VPC User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html
    #
    # @option params [String] :destination_prefix_list_id
    #   The ID of a prefix list used for the destination match.
    #
    # @option params [String] :vpc_endpoint_id
    #   The ID of a VPC endpoint. Supported for Gateway Load Balancer
    #   endpoints only.
    #
    # @option params [String] :transit_gateway_id
    #   The ID of a transit gateway.
    #
    # @option params [String] :local_gateway_id
    #   The ID of the local gateway.
    #
    # @option params [String] :carrier_gateway_id
    #   The ID of the carrier gateway.
    #
    #   You can only use this option when the VPC contains a subnet which is
    #   associated with a Wavelength Zone.
    #
    # @option params [String] :core_network_arn
    #   The Amazon Resource Name (ARN) of the core network.
    #
    # @option params [String] :odb_network_arn
    #   The Amazon Resource Name (ARN) of the ODB network.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :route_table_id
    #   The ID of the route table for the route.
    #
    # @option params [String] :destination_cidr_block
    #   The IPv4 CIDR address block used for the destination match. Routing
    #   decisions are based on the most specific match. We modify the
    #   specified CIDR block to its canonical form; for example, if you
    #   specify `100.68.0.18/18`, we modify it to `100.68.0.0/18`.
    #
    # @option params [String] :gateway_id
    #   The ID of an internet gateway or virtual private gateway attached to
    #   your VPC.
    #
    # @option params [String] :destination_ipv_6_cidr_block
    #   The IPv6 CIDR block used for the destination match. Routing decisions
    #   are based on the most specific match.
    #
    # @option params [String] :egress_only_internet_gateway_id
    #   \[IPv6 traffic only\] The ID of an egress-only internet gateway.
    #
    # @option params [String] :instance_id
    #   The ID of a NAT instance in your VPC. The operation fails if you
    #   specify an instance ID unless exactly one network interface is
    #   attached.
    #
    # @option params [String] :network_interface_id
    #   The ID of a network interface.
    #
    # @option params [String] :vpc_peering_connection_id
    #   The ID of a VPC peering connection.
    #
    # @option params [String] :nat_gateway_id
    #   \[IPv4 traffic only\] The ID of a NAT gateway.
    #
    # @return [Types::CreateRouteResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateRouteResult#return #return} => Boolean
    #
    #
    # @example Example: To create a route
    #
    #   # This example creates a route for the specified route table. The route matches all traffic (0.0.0.0/0) and routes it to
    #   # the specified Internet gateway.
    #
    #   resp = client.create_route({
    #     destination_cidr_block: "0.0.0.0/0", 
    #     gateway_id: "igw-c0a643a9", 
    #     route_table_id: "rtb-22574640", 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_route({
    #     destination_prefix_list_id: "PrefixListResourceId",
    #     vpc_endpoint_id: "VpcEndpointId",
    #     transit_gateway_id: "TransitGatewayId",
    #     local_gateway_id: "LocalGatewayId",
    #     carrier_gateway_id: "CarrierGatewayId",
    #     core_network_arn: "CoreNetworkArn",
    #     odb_network_arn: "OdbNetworkArn",
    #     dry_run: false,
    #     route_table_id: "RouteTableId", # required
    #     destination_cidr_block: "String",
    #     gateway_id: "RouteGatewayId",
    #     destination_ipv_6_cidr_block: "String",
    #     egress_only_internet_gateway_id: "EgressOnlyInternetGatewayId",
    #     instance_id: "InstanceId",
    #     network_interface_id: "NetworkInterfaceId",
    #     vpc_peering_connection_id: "VpcPeeringConnectionId",
    #     nat_gateway_id: "NatGatewayId",
    #   })
    #
    # @example Response structure
    #
    #   resp.return #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRoute AWS API Documentation
    #
    # @overload create_route(params = {})
    # @param [Hash] params ({})
    def create_route(params = {}, options = {})
      req = build_request(:create_route, params)
      req.send_request(options)
    end

    # Creates a new route server to manage dynamic routing in a VPC.
    #
    # Amazon VPC Route Server simplifies routing for traffic between
    # workloads that are deployed within a VPC and its internet gateways.
    # With this feature, VPC Route Server dynamically updates VPC and
    # internet gateway route tables with your preferred IPv4 or IPv6 routes
    # to achieve routing fault tolerance for those workloads. This enables
    # you to automatically reroute traffic within a VPC, which increases the
    # manageability of VPC routing and interoperability with third-party
    # workloads.
    #
    # Route server supports the follow route table types:
    #
    # * VPC route tables not associated with subnets
    #
    # * Subnet route tables
    #
    # * Internet gateway route tables
    #
    # Route server does not support route tables associated with virtual
    # private gateways. To propagate routes into a transit gateway route
    # table, use [Transit Gateway Connect][1].
    #
    # For more information see [Dynamic routing in your VPC with VPC Route
    # Server][2] in the *Amazon VPC User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html
    # [2]: https://docs.aws.amazon.com/vpc/latest/userguide/dynamic-routing-route-server.html
    #
    # @option params [required, Integer] :amazon_side_asn
    #   The private Autonomous System Number (ASN) for the Amazon side of the
    #   BGP session. Valid values are from 1 to 4294967295. We recommend using
    #   a private ASN in the 64512–65534 (16-bit ASN) or 4200000000–4294967294
    #   (32-bit ASN) range.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier to ensure idempotency of the
    #   request.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    # @option params [Boolean] :dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response. If
    #   you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :persist_routes
    #   Indicates whether routes should be persisted after all BGP sessions
    #   are terminated.
    #
    # @option params [Integer] :persist_routes_duration
    #   The number of minutes a route server will wait after BGP is
    #   re-established to unpersist the routes in the FIB and RIB. Value must
    #   be in the range of 1-5. Required if PersistRoutes is `enabled`.
    #
    #   If you set the duration to 1 minute, then when your network appliance
    #   re-establishes BGP with route server, it has 1 minute to relearn it's
    #   adjacent network and advertise those routes to route server before
    #   route server resumes normal functionality. In most cases, 1 minute is
    #   probably sufficient. If, however, you have concerns that your BGP
    #   network may not be capable of fully re-establishing and re-learning
    #   everything in 1 minute, you can increase the duration up to 5 minutes.
    #
    # @option params [Boolean] :sns_notifications_enabled
    #   Indicates whether SNS notifications should be enabled for route server
    #   events. Enabling SNS notifications persists BGP status changes to an
    #   SNS topic provisioned by Amazon Web Services.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the route server during creation.
    #
    # @return [Types::CreateRouteServerResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateRouteServerResult#route_server #route_server} => Types::RouteServer
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_route_server({
    #     amazon_side_asn: 1, # required
    #     client_token: "String",
    #     dry_run: false,
    #     persist_routes: "enable", # accepts enable, disable, reset
    #     persist_routes_duration: 1,
    #     sns_notifications_enabled: false,
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.route_server.route_server_id #=> String
    #   resp.route_server.amazon_side_asn #=> Integer
    #   resp.route_server.state #=> String, one of "pending", "available", "modifying", "deleting", "deleted"
    #   resp.route_server.tags #=> Array
    #   resp.route_server.tags[0].key #=> String
    #   resp.route_server.tags[0].value #=> String
    #   resp.route_server.persist_routes_state #=> String, one of "enabling", "enabled", "resetting", "disabling", "disabled", "modifying"
    #   resp.route_server.persist_routes_duration #=> Integer
    #   resp.route_server.sns_notifications_enabled #=> Boolean
    #   resp.route_server.sns_topic_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteServer AWS API Documentation
    #
    # @overload create_route_server(params = {})
    # @param [Hash] params ({})
    def create_route_server(params = {}, options = {})
      req = build_request(:create_route_server, params)
      req.send_request(options)
    end

    # Creates a new endpoint for a route server in a specified subnet.
    #
    # A route server endpoint is an Amazon Web Services-managed component
    # inside a subnet that facilitates [BGP (Border Gateway Protocol)][1]
    # connections between your route server and your BGP peers.
    #
    # For more information see [Dynamic routing in your VPC with VPC Route
    # Server][2] in the *Amazon VPC User Guide*.
    #
    #
    #
    # [1]: https://en.wikipedia.org/wiki/Border_Gateway_Protocol
    # [2]: https://docs.aws.amazon.com/vpc/latest/userguide/dynamic-routing-route-server.html
    #
    # @option params [required, String] :route_server_id
    #   The ID of the route server for which to create an endpoint.
    #
    # @option params [required, String] :subnet_id
    #   The ID of the subnet in which to create the route server endpoint.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier to ensure idempotency of the
    #   request.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    # @option params [Boolean] :dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response. If
    #   you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the route server endpoint during creation.
    #
    # @return [Types::CreateRouteServerEndpointResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateRouteServerEndpointResult#route_server_endpoint #route_server_endpoint} => Types::RouteServerEndpoint
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_route_server_endpoint({
    #     route_server_id: "RouteServerId", # required
    #     subnet_id: "SubnetId", # required
    #     client_token: "String",
    #     dry_run: false,
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.route_server_endpoint.route_server_id #=> String
    #   resp.route_server_endpoint.route_server_endpoint_id #=> String
    #   resp.route_server_endpoint.vpc_id #=> String
    #   resp.route_server_endpoint.subnet_id #=> String
    #   resp.route_server_endpoint.eni_id #=> String
    #   resp.route_server_endpoint.eni_address #=> String
    #   resp.route_server_endpoint.state #=> String, one of "pending", "available", "deleting", "deleted", "failing", "failed", "delete-failed"
    #   resp.route_server_endpoint.failure_reason #=> String
    #   resp.route_server_endpoint.tags #=> Array
    #   resp.route_server_endpoint.tags[0].key #=> String
    #   resp.route_server_endpoint.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteServerEndpoint AWS API Documentation
    #
    # @overload create_route_server_endpoint(params = {})
    # @param [Hash] params ({})
    def create_route_server_endpoint(params = {}, options = {})
      req = build_request(:create_route_server_endpoint, params)
      req.send_request(options)
    end

    # Creates a new BGP peer for a specified route server endpoint.
    #
    # A route server peer is a session between a route server endpoint and
    # the device deployed in Amazon Web Services (such as a firewall
    # appliance or other network security function running on an EC2
    # instance). The device must meet these requirements:
    #
    # * Have an elastic network interface in the VPC
    #
    # * Support BGP (Border Gateway Protocol)
    #
    # * Can initiate BGP sessions
    #
    # For more information see [Dynamic routing in your VPC with VPC Route
    # Server][1] in the *Amazon VPC User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/dynamic-routing-route-server.html
    #
    # @option params [required, String] :route_server_endpoint_id
    #   The ID of the route server endpoint for which to create a peer.
    #
    # @option params [required, String] :peer_address
    #   The IPv4 address of the peer device.
    #
    # @option params [required, Types::RouteServerBgpOptionsRequest] :bgp_options
    #   The BGP options for the peer, including ASN (Autonomous System Number)
    #   and BFD (Bidrectional Forwarding Detection) settings.
    #
    # @option params [Boolean] :dry_run
    #   A check for whether you have the required permissions for the action
    #   without actually making the request and provides an error response. If
    #   you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the route server peer during creation.
    #
    # @return [Types::CreateRouteServerPeerResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateRouteServerPeerResult#route_server_peer #route_server_peer} => Types::RouteServerPeer
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_route_server_peer({
    #     route_server_endpoint_id: "RouteServerEndpointId", # required
    #     peer_address: "String", # required
    #     bgp_options: { # required
    #       peer_asn: 1, # required
    #       peer_liveness_detection: "bfd", # accepts bfd, bgp-keepalive
    #     },
    #     dry_run: false,
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.route_server_peer.route_server_peer_id #=> String
    #   resp.route_server_peer.route_server_endpoint_id #=> String
    #   resp.route_server_peer.route_server_id #=> String
    #   resp.route_server_peer.vpc_id #=> String
    #   resp.route_server_peer.subnet_id #=> String
    #   resp.route_server_peer.state #=> String, one of "pending", "available", "deleting", "deleted", "failing", "failed"
    #   resp.route_server_peer.failure_reason #=> String
    #   resp.route_server_peer.endpoint_eni_id #=> String
    #   resp.route_server_peer.endpoint_eni_address #=> String
    #   resp.route_server_peer.peer_address #=> String
    #   resp.route_server_peer.bgp_options.peer_asn #=> Integer
    #   resp.route_server_peer.bgp_options.peer_liveness_detection #=> String, one of "bfd", "bgp-keepalive"
    #   resp.route_server_peer.bgp_status.status #=> String, one of "up", "down"
    #   resp.route_server_peer.bfd_status.status #=> String, one of "up", "down"
    #   resp.route_server_peer.tags #=> Array
    #   resp.route_server_peer.tags[0].key #=> String
    #   resp.route_server_peer.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteServerPeer AWS API Documentation
    #
    # @overload create_route_server_peer(params = {})
    # @param [Hash] params ({})
    def create_route_server_peer(params = {}, options = {})
      req = build_request(:create_route_server_peer, params)
      req.send_request(options)
    end

    # Creates a route table for the specified VPC. After you create a route
    # table, you can add routes and associate the table with a subnet.
    #
    # For more information, see [Route tables][1] in the *Amazon VPC User
    # Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the route table.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @return [Types::CreateRouteTableResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateRouteTableResult#route_table #route_table} => Types::RouteTable
    #   * {Types::CreateRouteTableResult#client_token #client_token} => String
    #
    #
    # @example Example: To create a route table
    #
    #   # This example creates a route table for the specified VPC.
    #
    #   resp = client.create_route_table({
    #     vpc_id: "vpc-a01106c2", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     route_table: {
    #       associations: [
    #       ], 
    #       propagating_vgws: [
    #       ], 
    #       route_table_id: "rtb-22574640", 
    #       routes: [
    #         {
    #           destination_cidr_block: "10.0.0.0/16", 
    #           gateway_id: "local", 
    #           state: "active", 
    #         }, 
    #       ], 
    #       tags: [
    #       ], 
    #       vpc_id: "vpc-a01106c2", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_route_table({
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     client_token: "String",
    #     dry_run: false,
    #     vpc_id: "VpcId", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.route_table.associations #=> Array
    #   resp.route_table.associations[0].main #=> Boolean
    #   resp.route_table.associations[0].route_table_association_id #=> String
    #   resp.route_table.associations[0].route_table_id #=> String
    #   resp.route_table.associations[0].subnet_id #=> String
    #   resp.route_table.associations[0].gateway_id #=> String
    #   resp.route_table.associations[0].public_ipv_4_pool #=> String
    #   resp.route_table.associations[0].association_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failed"
    #   resp.route_table.associations[0].association_state.status_message #=> String
    #   resp.route_table.propagating_vgws #=> Array
    #   resp.route_table.propagating_vgws[0].gateway_id #=> String
    #   resp.route_table.route_table_id #=> String
    #   resp.route_table.routes #=> Array
    #   resp.route_table.routes[0].destination_cidr_block #=> String
    #   resp.route_table.routes[0].destination_ipv_6_cidr_block #=> String
    #   resp.route_table.routes[0].destination_prefix_list_id #=> String
    #   resp.route_table.routes[0].egress_only_internet_gateway_id #=> String
    #   resp.route_table.routes[0].gateway_id #=> String
    #   resp.route_table.routes[0].instance_id #=> String
    #   resp.route_table.routes[0].instance_owner_id #=> String
    #   resp.route_table.routes[0].nat_gateway_id #=> String
    #   resp.route_table.routes[0].transit_gateway_id #=> String
    #   resp.route_table.routes[0].local_gateway_id #=> String
    #   resp.route_table.routes[0].carrier_gateway_id #=> String
    #   resp.route_table.routes[0].network_interface_id #=> String
    #   resp.route_table.routes[0].origin #=> String, one of "CreateRouteTable", "CreateRoute", "EnableVgwRoutePropagation", "Advertisement"
    #   resp.route_table.routes[0].state #=> String, one of "active", "blackhole", "filtered"
    #   resp.route_table.routes[0].vpc_peering_connection_id #=> String
    #   resp.route_table.routes[0].core_network_arn #=> String
    #   resp.route_table.routes[0].odb_network_arn #=> String
    #   resp.route_table.routes[0].ip_address #=> String
    #   resp.route_table.tags #=> Array
    #   resp.route_table.tags[0].key #=> String
    #   resp.route_table.tags[0].value #=> String
    #   resp.route_table.vpc_id #=> String
    #   resp.route_table.owner_id #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTable AWS API Documentation
    #
    # @overload create_route_table(params = {})
    # @param [Hash] params ({})
    def create_route_table(params = {}, options = {})
      req = build_request(:create_route_table, params)
      req.send_request(options)
    end

    # Creates a security group.
    #
    # A security group acts as a virtual firewall for your instance to
    # control inbound and outbound traffic. For more information, see
    # [Amazon EC2 security groups][1] in the *Amazon EC2 User Guide* and
    # [Security groups for your VPC][2] in the *Amazon VPC User Guide*.
    #
    # When you create a security group, you specify a friendly name of your
    # choice. You can't have two security groups for the same VPC with the
    # same name.
    #
    # You have a default security group for use in your VPC. If you don't
    # specify a security group when you launch an instance, the instance is
    # launched into the appropriate default security group. A default
    # security group includes a default rule that grants instances
    # unrestricted network access to each other.
    #
    # You can add or remove rules from your security groups using
    # AuthorizeSecurityGroupIngress, AuthorizeSecurityGroupEgress,
    # RevokeSecurityGroupIngress, and RevokeSecurityGroupEgress.
    #
    # For more information about VPC security group limits, see [Amazon VPC
    # Limits][3].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html
    # [2]: https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html
    # [3]: https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html
    #
    # @option params [required, String] :description
    #   A description for the security group.
    #
    #   Constraints: Up to 255 characters in length
    #
    #   Valid characters: a-z, A-Z, 0-9, spaces, and
    #   .\_-:/()#,@\[\]+=&amp;;\{}!$*
    #
    # @option params [required, String] :group_name
    #   The name of the security group. Names are case-insensitive and must be
    #   unique within the VPC.
    #
    #   Constraints: Up to 255 characters in length. Can't start with `sg-`.
    #
    #   Valid characters: a-z, A-Z, 0-9, spaces, and
    #   .\_-:/()#,@\[\]+=&amp;;\{}!$*
    #
    # @option params [String] :vpc_id
    #   The ID of the VPC. Required for a nondefault VPC.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the security group.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateSecurityGroupResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateSecurityGroupResult#group_id #group_id} => String
    #   * {Types::CreateSecurityGroupResult#tags #tags} => Array&lt;Types::Tag&gt;
    #   * {Types::CreateSecurityGroupResult#security_group_arn #security_group_arn} => String
    #
    #
    # @example Example: To create a security group for a VPC
    #
    #   # This example creates a security group for the specified VPC.
    #
    #   resp = client.create_security_group({
    #     description: "My security group", 
    #     group_name: "my-security-group", 
    #     vpc_id: "vpc-1a2b3c4d", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     group_id: "sg-903004f8", 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_security_group({
    #     description: "String", # required
    #     group_name: "String", # required
    #     vpc_id: "VpcId",
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.group_id #=> String
    #   resp.tags #=> Array
    #   resp.tags[0].key #=> String
    #   resp.tags[0].value #=> String
    #   resp.security_group_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroup AWS API Documentation
    #
    # @overload create_security_group(params = {})
    # @param [Hash] params ({})
    def create_security_group(params = {}, options = {})
      req = build_request(:create_security_group, params)
      req.send_request(options)
    end

    # Creates a snapshot of an EBS volume and stores it in Amazon S3. You
    # can use snapshots for backups, to make copies of EBS volumes, and to
    # save data before shutting down an instance.
    #
    # The location of the source EBS volume determines where you can create
    # the snapshot.
    #
    # * If the source volume is in a Region, you must create the snapshot in
    #   the same Region as the volume.
    #
    # * If the source volume is in a Local Zone, you can create the snapshot
    #   in the same Local Zone or in its parent Amazon Web Services Region.
    #
    # * If the source volume is on an Outpost, you can create the snapshot
    #   on the same Outpost or in its parent Amazon Web Services Region.
    #
    # When a snapshot is created, any Amazon Web Services Marketplace
    # product codes that are associated with the source volume are
    # propagated to the snapshot.
    #
    # You can take a snapshot of an attached volume that is in use. However,
    # snapshots only capture data that has been written to your Amazon EBS
    # volume at the time the snapshot command is issued; this might exclude
    # any data that has been cached by any applications or the operating
    # system. If you can pause any file systems on the volume long enough to
    # take a snapshot, your snapshot should be complete. However, if you
    # cannot pause all file writes to the volume, you should unmount the
    # volume from within the instance, issue the snapshot command, and then
    # remount the volume to ensure a consistent and complete snapshot. You
    # may remount and use your volume while the snapshot status is
    # `pending`.
    #
    # When you create a snapshot for an EBS volume that serves as a root
    # device, we recommend that you stop the instance before taking the
    # snapshot.
    #
    # Snapshots that are taken from encrypted volumes are automatically
    # encrypted. Volumes that are created from encrypted snapshots are also
    # automatically encrypted. Your encrypted volumes and any associated
    # snapshots always remain protected. For more information, see [Amazon
    # EBS encryption][1] in the *Amazon EBS User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html
    #
    # @option params [String] :description
    #   A description for the snapshot.
    #
    # @option params [String] :outpost_arn
    #   <note markdown="1"> Only supported for volumes on Outposts. If the source volume is not on
    #   an Outpost, omit this parameter.
    #
    #    </note>
    #
    #   * To create the snapshot on the same Outpost as the source volume,
    #     specify the ARN of that Outpost. The snapshot must be created on the
    #     same Outpost as the volume.
    #
    #   * To create the snapshot in the parent Region of the Outpost, omit
    #     this parameter.
    #
    #   For more information, see [Create local snapshots from volumes on an
    #   Outpost][1] in the *Amazon EBS User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot
    #
    # @option params [required, String] :volume_id
    #   The ID of the Amazon EBS volume.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the snapshot during creation.
    #
    # @option params [String] :location
    #   <note markdown="1"> Only supported for volumes in Local Zones. If the source volume is not
    #   in a Local Zone, omit this parameter.
    #
    #    </note>
    #
    #   * To create a local snapshot in the same Local Zone as the source
    #     volume, specify `local`.
    #
    #   * To create a regional snapshot in the parent Region of the Local
    #     Zone, specify `regional` or omit this parameter.
    #
    #   Default value: `regional`
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::Snapshot] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::Snapshot#owner_alias #owner_alias} => String
    #   * {Types::Snapshot#outpost_arn #outpost_arn} => String
    #   * {Types::Snapshot#tags #tags} => Array&lt;Types::Tag&gt;
    #   * {Types::Snapshot#storage_tier #storage_tier} => String
    #   * {Types::Snapshot#restore_expiry_time #restore_expiry_time} => Time
    #   * {Types::Snapshot#sse_type #sse_type} => String
    #   * {Types::Snapshot#availability_zone #availability_zone} => String
    #   * {Types::Snapshot#transfer_type #transfer_type} => String
    #   * {Types::Snapshot#completion_duration_minutes #completion_duration_minutes} => Integer
    #   * {Types::Snapshot#completion_time #completion_time} => Time
    #   * {Types::Snapshot#full_snapshot_size_in_bytes #full_snapshot_size_in_bytes} => Integer
    #   * {Types::Snapshot#snapshot_id #snapshot_id} => String
    #   * {Types::Snapshot#volume_id #volume_id} => String
    #   * {Types::Snapshot#state #state} => String
    #   * {Types::Snapshot#state_message #state_message} => String
    #   * {Types::Snapshot#start_time #start_time} => Time
    #   * {Types::Snapshot#progress #progress} => String
    #   * {Types::Snapshot#owner_id #owner_id} => String
    #   * {Types::Snapshot#description #description} => String
    #   * {Types::Snapshot#volume_size #volume_size} => Integer
    #   * {Types::Snapshot#encrypted #encrypted} => Boolean
    #   * {Types::Snapshot#kms_key_id #kms_key_id} => String
    #   * {Types::Snapshot#data_encryption_key_id #data_encryption_key_id} => String
    #
    #
    # @example Example: To create a snapshot
    #
    #   # This example creates a snapshot of the volume with a volume ID of ``vol-1234567890abcdef0`` and a short description to
    #   # identify the snapshot.
    #
    #   resp = client.create_snapshot({
    #     description: "This is my root volume snapshot.", 
    #     volume_id: "vol-1234567890abcdef0", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     description: "This is my root volume snapshot.", 
    #     owner_id: "012345678910", 
    #     snapshot_id: "snap-066877671789bd71b", 
    #     start_time: Time.parse("2014-02-28T21:06:01.000Z"), 
    #     state: "pending", 
    #     tags: [
    #     ], 
    #     volume_id: "vol-1234567890abcdef0", 
    #     volume_size: 8, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_snapshot({
    #     description: "String",
    #     outpost_arn: "String",
    #     volume_id: "VolumeId", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     location: "regional", # accepts regional, local
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.owner_alias #=> String
    #   resp.outpost_arn #=> String
    #   resp.tags #=> Array
    #   resp.tags[0].key #=> String
    #   resp.tags[0].value #=> String
    #   resp.storage_tier #=> String, one of "archive", "standard"
    #   resp.restore_expiry_time #=> Time
    #   resp.sse_type #=> String, one of "sse-ebs", "sse-kms", "none"
    #   resp.availability_zone #=> String
    #   resp.transfer_type #=> String, one of "time-based", "standard"
    #   resp.completion_duration_minutes #=> Integer
    #   resp.completion_time #=> Time
    #   resp.full_snapshot_size_in_bytes #=> Integer
    #   resp.snapshot_id #=> String
    #   resp.volume_id #=> String
    #   resp.state #=> String, one of "pending", "completed", "error", "recoverable", "recovering"
    #   resp.state_message #=> String
    #   resp.start_time #=> Time
    #   resp.progress #=> String
    #   resp.owner_id #=> String
    #   resp.description #=> String
    #   resp.volume_size #=> Integer
    #   resp.encrypted #=> Boolean
    #   resp.kms_key_id #=> String
    #   resp.data_encryption_key_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshot AWS API Documentation
    #
    # @overload create_snapshot(params = {})
    # @param [Hash] params ({})
    def create_snapshot(params = {}, options = {})
      req = build_request(:create_snapshot, params)
      req.send_request(options)
    end

    # Creates crash-consistent snapshots of multiple EBS volumes attached to
    # an Amazon EC2 instance. Volumes are chosen by specifying an instance.
    # Each volume attached to the specified instance will produce one
    # snapshot that is crash-consistent across the instance. You can include
    # all of the volumes currently attached to the instance, or you can
    # exclude the root volume or specific data (non-root) volumes from the
    # multi-volume snapshot set.
    #
    # The location of the source instance determines where you can create
    # the snapshots.
    #
    # * If the source instance is in a Region, you must create the snapshots
    #   in the same Region as the instance.
    #
    # * If the source instance is in a Local Zone, you can create the
    #   snapshots in the same Local Zone or in its parent Amazon Web
    #   Services Region.
    #
    # * If the source instance is on an Outpost, you can create the
    #   snapshots on the same Outpost or in its parent Amazon Web Services
    #   Region.
    #
    # @option params [String] :description
    #   A description propagated to every snapshot specified by the instance.
    #
    # @option params [required, Types::InstanceSpecification] :instance_specification
    #   The instance to specify which volumes should be included in the
    #   snapshots.
    #
    # @option params [String] :outpost_arn
    #   <note markdown="1"> Only supported for instances on Outposts. If the source instance is
    #   not on an Outpost, omit this parameter.
    #
    #    </note>
    #
    #   * To create the snapshots on the same Outpost as the source instance,
    #     specify the ARN of that Outpost. The snapshots must be created on
    #     the same Outpost as the instance.
    #
    #   * To create the snapshots in the parent Region of the Outpost, omit
    #     this parameter.
    #
    #   For more information, see [ Create local snapshots from volumes on an
    #   Outpost][1] in the *Amazon EBS User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   Tags to apply to every snapshot specified by the instance.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :copy_tags_from_source
    #   Copies the tags from the specified volume to corresponding snapshot.
    #
    # @option params [String] :location
    #   <note markdown="1"> Only supported for instances in Local Zones. If the source instance is
    #   not in a Local Zone, omit this parameter.
    #
    #    </note>
    #
    #   * To create local snapshots in the same Local Zone as the source
    #     instance, specify `local`.
    #
    #   * To create regional snapshots in the parent Region of the Local Zone,
    #     specify `regional` or omit this parameter.
    #
    #   Default value: `regional`
    #
    # @return [Types::CreateSnapshotsResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateSnapshotsResult#snapshots #snapshots} => Array&lt;Types::SnapshotInfo&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_snapshots({
    #     description: "String",
    #     instance_specification: { # required
    #       instance_id: "InstanceIdWithVolumeResolver", # required
    #       exclude_boot_volume: false,
    #       exclude_data_volume_ids: ["VolumeId"],
    #     },
    #     outpost_arn: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #     copy_tags_from_source: "volume", # accepts volume
    #     location: "regional", # accepts regional, local
    #   })
    #
    # @example Response structure
    #
    #   resp.snapshots #=> Array
    #   resp.snapshots[0].description #=> String
    #   resp.snapshots[0].tags #=> Array
    #   resp.snapshots[0].tags[0].key #=> String
    #   resp.snapshots[0].tags[0].value #=> String
    #   resp.snapshots[0].encrypted #=> Boolean
    #   resp.snapshots[0].volume_id #=> String
    #   resp.snapshots[0].state #=> String, one of "pending", "completed", "error", "recoverable", "recovering"
    #   resp.snapshots[0].volume_size #=> Integer
    #   resp.snapshots[0].start_time #=> Time
    #   resp.snapshots[0].progress #=> String
    #   resp.snapshots[0].owner_id #=> String
    #   resp.snapshots[0].snapshot_id #=> String
    #   resp.snapshots[0].outpost_arn #=> String
    #   resp.snapshots[0].sse_type #=> String, one of "sse-ebs", "sse-kms", "none"
    #   resp.snapshots[0].availability_zone #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshots AWS API Documentation
    #
    # @overload create_snapshots(params = {})
    # @param [Hash] params ({})
    def create_snapshots(params = {}, options = {})
      req = build_request(:create_snapshots, params)
      req.send_request(options)
    end

    # Creates a data feed for Spot Instances, enabling you to view Spot
    # Instance usage logs. You can create one data feed per Amazon Web
    # Services account. For more information, see [Spot Instance data
    # feed][1] in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, String] :bucket
    #   The name of the Amazon S3 bucket in which to store the Spot Instance
    #   data feed. For more information about bucket names, see [Bucket naming
    #   rules][1] in the *Amazon S3 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html
    #
    # @option params [String] :prefix
    #   The prefix for the data feed file names.
    #
    # @return [Types::CreateSpotDatafeedSubscriptionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateSpotDatafeedSubscriptionResult#spot_datafeed_subscription #spot_datafeed_subscription} => Types::SpotDatafeedSubscription
    #
    #
    # @example Example: To create a Spot Instance datafeed
    #
    #   # This example creates a Spot Instance data feed for your AWS account.
    #
    #   resp = client.create_spot_datafeed_subscription({
    #     bucket: "my-s3-bucket", 
    #     prefix: "spotdata", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     spot_datafeed_subscription: {
    #       bucket: "my-s3-bucket", 
    #       owner_id: "123456789012", 
    #       prefix: "spotdata", 
    #       state: "Active", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_spot_datafeed_subscription({
    #     dry_run: false,
    #     bucket: "String", # required
    #     prefix: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.spot_datafeed_subscription.bucket #=> String
    #   resp.spot_datafeed_subscription.fault.code #=> String
    #   resp.spot_datafeed_subscription.fault.message #=> String
    #   resp.spot_datafeed_subscription.owner_id #=> String
    #   resp.spot_datafeed_subscription.prefix #=> String
    #   resp.spot_datafeed_subscription.state #=> String, one of "Active", "Inactive"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscription AWS API Documentation
    #
    # @overload create_spot_datafeed_subscription(params = {})
    # @param [Hash] params ({})
    def create_spot_datafeed_subscription(params = {}, options = {})
      req = build_request(:create_spot_datafeed_subscription, params)
      req.send_request(options)
    end

    # Stores an AMI as a single object in an Amazon S3 bucket.
    #
    # To use this API, you must have the required permissions. For more
    # information, see [Permissions for storing and restoring AMIs using
    # S3][1] in the *Amazon EC2 User Guide*.
    #
    # For more information, see [Store and restore an AMI using S3][2] in
    # the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-ami-store-restore.html#ami-s3-permissions
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-store-restore.html
    #
    # @option params [required, String] :image_id
    #   The ID of the AMI.
    #
    # @option params [required, String] :bucket
    #   The name of the Amazon S3 bucket in which the AMI object will be
    #   stored. The bucket must be in the Region in which the request is being
    #   made. The AMI object appears in the bucket only after the upload task
    #   has completed.
    #
    # @option params [Array<Types::S3ObjectTag>] :s3_object_tags
    #   The tags to apply to the AMI object that will be stored in the Amazon
    #   S3 bucket.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateStoreImageTaskResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateStoreImageTaskResult#object_key #object_key} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_store_image_task({
    #     image_id: "ImageId", # required
    #     bucket: "String", # required
    #     s3_object_tags: [
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.object_key #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateStoreImageTask AWS API Documentation
    #
    # @overload create_store_image_task(params = {})
    # @param [Hash] params ({})
    def create_store_image_task(params = {}, options = {})
      req = build_request(:create_store_image_task, params)
      req.send_request(options)
    end

    # Creates a subnet in the specified VPC. For an IPv4 only subnet,
    # specify an IPv4 CIDR block. If the VPC has an IPv6 CIDR block, you can
    # create an IPv6 only subnet or a dual stack subnet instead. For an IPv6
    # only subnet, specify an IPv6 CIDR block. For a dual stack subnet,
    # specify both an IPv4 CIDR block and an IPv6 CIDR block.
    #
    # A subnet CIDR block must not overlap the CIDR block of an existing
    # subnet in the VPC. After you create a subnet, you can't change its
    # CIDR block.
    #
    # The allowed size for an IPv4 subnet is between a /28 netmask (16 IP
    # addresses) and a /16 netmask (65,536 IP addresses). Amazon Web
    # Services reserves both the first four and the last IPv4 address in
    # each subnet's CIDR block. They're not available for your use.
    #
    # If you've associated an IPv6 CIDR block with your VPC, you can
    # associate an IPv6 CIDR block with a subnet when you create it.
    #
    # If you add more than one subnet to a VPC, they're set up in a star
    # topology with a logical router in the middle.
    #
    # When you stop an instance in a subnet, it retains its private IPv4
    # address. It's therefore possible to have a subnet with no running
    # instances (they're all stopped), but no remaining IP addresses
    # available.
    #
    # For more information, see [Subnets][1] in the *Amazon VPC User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/configure-subnets.html
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the subnet.
    #
    # @option params [String] :availability_zone
    #   The Availability Zone or Local Zone for the subnet.
    #
    #   Default: Amazon Web Services selects one for you. If you create more
    #   than one subnet in your VPC, we do not necessarily select a different
    #   zone for each subnet.
    #
    #   To create a subnet in a Local Zone, set this value to the Local Zone
    #   ID, for example `us-west-2-lax-1a`. For information about the Regions
    #   that support Local Zones, see [Available Local Zones][1].
    #
    #   To create a subnet in an Outpost, set this value to the Availability
    #   Zone for the Outpost and specify the Outpost ARN.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/local-zones/latest/ug/available-local-zones.html
    #
    # @option params [String] :availability_zone_id
    #   The AZ ID or the Local Zone ID of the subnet.
    #
    # @option params [String] :cidr_block
    #   The IPv4 network range for the subnet, in CIDR notation. For example,
    #   `10.0.0.0/24`. We modify the specified CIDR block to its canonical
    #   form; for example, if you specify `100.68.0.18/18`, we modify it to
    #   `100.68.0.0/18`.
    #
    #   This parameter is not supported for an IPv6 only subnet.
    #
    # @option params [String] :ipv_6_cidr_block
    #   The IPv6 network range for the subnet, in CIDR notation. This
    #   parameter is required for an IPv6 only subnet.
    #
    # @option params [String] :outpost_arn
    #   The Amazon Resource Name (ARN) of the Outpost. If you specify an
    #   Outpost ARN, you must also specify the Availability Zone of the
    #   Outpost subnet.
    #
    # @option params [required, String] :vpc_id
    #   The ID of the VPC.
    #
    # @option params [Boolean] :ipv_6_native
    #   Indicates whether to create an IPv6 only subnet.
    #
    # @option params [String] :ipv_4_ipam_pool_id
    #   An IPv4 IPAM pool ID for the subnet.
    #
    # @option params [Integer] :ipv_4_netmask_length
    #   An IPv4 netmask length for the subnet.
    #
    # @option params [String] :ipv_6_ipam_pool_id
    #   An IPv6 IPAM pool ID for the subnet.
    #
    # @option params [Integer] :ipv_6_netmask_length
    #   An IPv6 netmask length for the subnet.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateSubnetResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateSubnetResult#subnet #subnet} => Types::Subnet
    #
    #
    # @example Example: To create a subnet
    #
    #   # This example creates a subnet in the specified VPC with the specified CIDR block. We recommend that you let us select an
    #   # Availability Zone for you.
    #
    #   resp = client.create_subnet({
    #     cidr_block: "10.0.1.0/24", 
    #     vpc_id: "vpc-a01106c2", 
    #   })
    #
    #   resp.to_h outputs the following:
    #   {
    #     subnet: {
    #       availability_zone: "us-west-2c", 
    #       available_ip_address_count: 251, 
    #       cidr_block: "10.0.1.0/24", 
    #       state: "pending", 
    #       subnet_id: "subnet-9d4a7b6c", 
    #       vpc_id: "vpc-a01106c2", 
    #     }, 
    #   }
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_subnet({
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     availability_zone: "String",
    #     availability_zone_id: "String",
    #     cidr_block: "String",
    #     ipv_6_cidr_block: "String",
    #     outpost_arn: "String",
    #     vpc_id: "VpcId", # required
    #     ipv_6_native: false,
    #     ipv_4_ipam_pool_id: "IpamPoolId",
    #     ipv_4_netmask_length: 1,
    #     ipv_6_ipam_pool_id: "IpamPoolId",
    #     ipv_6_netmask_length: 1,
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.subnet.availability_zone_id #=> String
    #   resp.subnet.enable_lni_at_device_index #=> Integer
    #   resp.subnet.map_customer_owned_ip_on_launch #=> Boolean
    #   resp.subnet.customer_owned_ipv_4_pool #=> String
    #   resp.subnet.owner_id #=> String
    #   resp.subnet.assign_ipv_6_address_on_creation #=> Boolean
    #   resp.subnet.ipv_6_cidr_block_association_set #=> Array
    #   resp.subnet.ipv_6_cidr_block_association_set[0].association_id #=> String
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block #=> String
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.state #=> String, one of "associating", "associated", "disassociating", "disassociated", "failing", "failed"
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ipv_6_cidr_block_state.status_message #=> String
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ipv_6_address_attribute #=> String, one of "public", "private"
    #   resp.subnet.ipv_6_cidr_block_association_set[0].ip_source #=> String, one of "amazon", "byoip", "none"
    #   resp.subnet.tags #=> Array
    #   resp.subnet.tags[0].key #=> String
    #   resp.subnet.tags[0].value #=> String
    #   resp.subnet.subnet_arn #=> String
    #   resp.subnet.outpost_arn #=> String
    #   resp.subnet.enable_dns_64 #=> Boolean
    #   resp.subnet.ipv_6_native #=> Boolean
    #   resp.subnet.private_dns_name_options_on_launch.hostname_type #=> String, one of "ip-name", "resource-name"
    #   resp.subnet.private_dns_name_options_on_launch.enable_resource_name_dns_a_record #=> Boolean
    #   resp.subnet.private_dns_name_options_on_launch.enable_resource_name_dns_aaaa_record #=> Boolean
    #   resp.subnet.block_public_access_states.internet_gateway_block_mode #=> String, one of "off", "block-bidirectional", "block-ingress"
    #   resp.subnet.type #=> String
    #   resp.subnet.subnet_id #=> String
    #   resp.subnet.state #=> String, one of "pending", "available", "unavailable", "failed", "failed-insufficient-capacity"
    #   resp.subnet.vpc_id #=> String
    #   resp.subnet.cidr_block #=> String
    #   resp.subnet.available_ip_address_count #=> Integer
    #   resp.subnet.availability_zone #=> String
    #   resp.subnet.default_for_az #=> Boolean
    #   resp.subnet.map_public_ip_on_launch #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnet AWS API Documentation
    #
    # @overload create_subnet(params = {})
    # @param [Hash] params ({})
    def create_subnet(params = {}, options = {})
      req = build_request(:create_subnet, params)
      req.send_request(options)
    end

    # Creates a subnet CIDR reservation. For more information, see [Subnet
    # CIDR reservations][1] in the *Amazon VPC User Guide* and [Manage
    # prefixes for your network interfaces][2] in the *Amazon EC2 User
    # Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/userguide/subnet-cidr-reservation.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/work-with-prefixes.html
    #
    # @option params [required, String] :subnet_id
    #   The ID of the subnet.
    #
    # @option params [required, String] :cidr
    #   The IPv4 or IPV6 CIDR range to reserve.
    #
    # @option params [required, String] :reservation_type
    #   The type of reservation. The reservation type determines how the
    #   reserved IP addresses are assigned to resources.
    #
    #   * `prefix` - Amazon Web Services assigns the reserved IP addresses to
    #     network interfaces.
    #
    #   * `explicit` - You assign the reserved IP addresses to network
    #     interfaces.
    #
    # @option params [String] :description
    #   The description to assign to the subnet CIDR reservation.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the subnet CIDR reservation.
    #
    # @return [Types::CreateSubnetCidrReservationResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateSubnetCidrReservationResult#subnet_cidr_reservation #subnet_cidr_reservation} => Types::SubnetCidrReservation
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_subnet_cidr_reservation({
    #     subnet_id: "SubnetId", # required
    #     cidr: "String", # required
    #     reservation_type: "prefix", # required, accepts prefix, explicit
    #     description: "String",
    #     dry_run: false,
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.subnet_cidr_reservation.subnet_cidr_reservation_id #=> String
    #   resp.subnet_cidr_reservation.subnet_id #=> String
    #   resp.subnet_cidr_reservation.cidr #=> String
    #   resp.subnet_cidr_reservation.reservation_type #=> String, one of "prefix", "explicit"
    #   resp.subnet_cidr_reservation.owner_id #=> String
    #   resp.subnet_cidr_reservation.description #=> String
    #   resp.subnet_cidr_reservation.tags #=> Array
    #   resp.subnet_cidr_reservation.tags[0].key #=> String
    #   resp.subnet_cidr_reservation.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnetCidrReservation AWS API Documentation
    #
    # @overload create_subnet_cidr_reservation(params = {})
    # @param [Hash] params ({})
    def create_subnet_cidr_reservation(params = {}, options = {})
      req = build_request(:create_subnet_cidr_reservation, params)
      req.send_request(options)
    end

    # Adds or overwrites only the specified tags for the specified Amazon
    # EC2 resource or resources. When you specify an existing tag key, the
    # value is overwritten with the new value. Each resource can have a
    # maximum of 50 tags. Each tag consists of a key and optional value. Tag
    # keys must be unique per resource.
    #
    # For more information about tags, see [Tag your Amazon EC2
    # resources][1] in the *Amazon Elastic Compute Cloud User Guide*. For
    # more information about creating IAM policies that control users'
    # access to resources based on tags, see [Supported resource-level
    # permissions for Amazon EC2 API actions][2] in the *Amazon Elastic
    # Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [required, Array<String>] :resources
    #   The IDs of the resources, separated by spaces.
    #
    #   Constraints: Up to 1000 resource IDs. We recommend breaking up this
    #   request into smaller batches.
    #
    # @option params [required, Array<Types::Tag>] :tags
    #   The tags. The `value` parameter is required, but if you don't want
    #   the tag to have a value, specify the parameter with no value, and we
    #   set the value to an empty string.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    #
    # @example Example: To add a tag to a resource
    #
    #   # This example adds the tag Stack=production to the specified image, or overwrites an existing tag for the AMI where the
    #   # tag key is Stack.
    #
    #   resp = client.create_tags({
    #     resources: [
    #       "ami-78a54011", 
    #     ], 
    #     tags: [
    #       {
    #         key: "Stack", 
    #         value: "production", 
    #       }, 
    #     ], 
    #   })
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_tags({
    #     dry_run: false,
    #     resources: ["TaggableResourceId"], # required
    #     tags: [ # required
    #       {
    #         key: "String",
    #         value: "String",
    #       },
    #     ],
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTags AWS API Documentation
    #
    # @overload create_tags(params = {})
    # @param [Hash] params ({})
    def create_tags(params = {}, options = {})
      req = build_request(:create_tags, params)
      req.send_request(options)
    end

    # Creates a Traffic Mirror filter.
    #
    # A Traffic Mirror filter is a set of rules that defines the traffic to
    # mirror.
    #
    # By default, no traffic is mirrored. To mirror traffic, use
    # [CreateTrafficMirrorFilterRule][1] to add Traffic Mirror rules to the
    # filter. The rules you add define what traffic gets mirrored. You can
    # also use [ModifyTrafficMirrorFilterNetworkServices][2] to mirror
    # supported network services.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html
    #
    # @option params [String] :description
    #   The description of the Traffic Mirror filter.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to a Traffic Mirror filter.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @return [Types::CreateTrafficMirrorFilterResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTrafficMirrorFilterResult#traffic_mirror_filter #traffic_mirror_filter} => Types::TrafficMirrorFilter
    #   * {Types::CreateTrafficMirrorFilterResult#client_token #client_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_traffic_mirror_filter({
    #     description: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_filter.traffic_mirror_filter_id #=> String
    #   resp.traffic_mirror_filter.ingress_filter_rules #=> Array
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].traffic_mirror_filter_rule_id #=> String
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].traffic_mirror_filter_id #=> String
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].traffic_direction #=> String, one of "ingress", "egress"
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].rule_number #=> Integer
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].rule_action #=> String, one of "accept", "reject"
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].protocol #=> Integer
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].destination_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].destination_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].source_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].source_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].destination_cidr_block #=> String
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].source_cidr_block #=> String
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].description #=> String
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].tags #=> Array
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].tags[0].key #=> String
    #   resp.traffic_mirror_filter.ingress_filter_rules[0].tags[0].value #=> String
    #   resp.traffic_mirror_filter.egress_filter_rules #=> Array
    #   resp.traffic_mirror_filter.egress_filter_rules[0].traffic_mirror_filter_rule_id #=> String
    #   resp.traffic_mirror_filter.egress_filter_rules[0].traffic_mirror_filter_id #=> String
    #   resp.traffic_mirror_filter.egress_filter_rules[0].traffic_direction #=> String, one of "ingress", "egress"
    #   resp.traffic_mirror_filter.egress_filter_rules[0].rule_number #=> Integer
    #   resp.traffic_mirror_filter.egress_filter_rules[0].rule_action #=> String, one of "accept", "reject"
    #   resp.traffic_mirror_filter.egress_filter_rules[0].protocol #=> Integer
    #   resp.traffic_mirror_filter.egress_filter_rules[0].destination_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filter.egress_filter_rules[0].destination_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filter.egress_filter_rules[0].source_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filter.egress_filter_rules[0].source_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filter.egress_filter_rules[0].destination_cidr_block #=> String
    #   resp.traffic_mirror_filter.egress_filter_rules[0].source_cidr_block #=> String
    #   resp.traffic_mirror_filter.egress_filter_rules[0].description #=> String
    #   resp.traffic_mirror_filter.egress_filter_rules[0].tags #=> Array
    #   resp.traffic_mirror_filter.egress_filter_rules[0].tags[0].key #=> String
    #   resp.traffic_mirror_filter.egress_filter_rules[0].tags[0].value #=> String
    #   resp.traffic_mirror_filter.network_services #=> Array
    #   resp.traffic_mirror_filter.network_services[0] #=> String, one of "amazon-dns"
    #   resp.traffic_mirror_filter.description #=> String
    #   resp.traffic_mirror_filter.tags #=> Array
    #   resp.traffic_mirror_filter.tags[0].key #=> String
    #   resp.traffic_mirror_filter.tags[0].value #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilter AWS API Documentation
    #
    # @overload create_traffic_mirror_filter(params = {})
    # @param [Hash] params ({})
    def create_traffic_mirror_filter(params = {}, options = {})
      req = build_request(:create_traffic_mirror_filter, params)
      req.send_request(options)
    end

    # Creates a Traffic Mirror filter rule.
    #
    # A Traffic Mirror rule defines the Traffic Mirror source traffic to
    # mirror.
    #
    # You need the Traffic Mirror filter ID when you create the rule.
    #
    # @option params [required, String] :traffic_mirror_filter_id
    #   The ID of the filter that this rule is associated with.
    #
    # @option params [required, String] :traffic_direction
    #   The type of traffic.
    #
    # @option params [required, Integer] :rule_number
    #   The number of the Traffic Mirror rule. This number must be unique for
    #   each Traffic Mirror rule in a given direction. The rules are processed
    #   in ascending order by rule number.
    #
    # @option params [required, String] :rule_action
    #   The action to take on the filtered traffic.
    #
    # @option params [Types::TrafficMirrorPortRangeRequest] :destination_port_range
    #   The destination port range.
    #
    # @option params [Types::TrafficMirrorPortRangeRequest] :source_port_range
    #   The source port range.
    #
    # @option params [Integer] :protocol
    #   The protocol, for example UDP, to assign to the Traffic Mirror rule.
    #
    #   For information about the protocol value, see [Protocol Numbers][1] on
    #   the Internet Assigned Numbers Authority (IANA) website.
    #
    #
    #
    #   [1]: https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml
    #
    # @option params [required, String] :destination_cidr_block
    #   The destination CIDR block to assign to the Traffic Mirror rule.
    #
    # @option params [required, String] :source_cidr_block
    #   The source CIDR block to assign to the Traffic Mirror rule.
    #
    # @option params [String] :description
    #   The description of the Traffic Mirror rule.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   Traffic Mirroring tags specifications.
    #
    # @return [Types::CreateTrafficMirrorFilterRuleResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTrafficMirrorFilterRuleResult#traffic_mirror_filter_rule #traffic_mirror_filter_rule} => Types::TrafficMirrorFilterRule
    #   * {Types::CreateTrafficMirrorFilterRuleResult#client_token #client_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_traffic_mirror_filter_rule({
    #     traffic_mirror_filter_id: "TrafficMirrorFilterId", # required
    #     traffic_direction: "ingress", # required, accepts ingress, egress
    #     rule_number: 1, # required
    #     rule_action: "accept", # required, accepts accept, reject
    #     destination_port_range: {
    #       from_port: 1,
    #       to_port: 1,
    #     },
    #     source_port_range: {
    #       from_port: 1,
    #       to_port: 1,
    #     },
    #     protocol: 1,
    #     destination_cidr_block: "String", # required
    #     source_cidr_block: "String", # required
    #     description: "String",
    #     dry_run: false,
    #     client_token: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_filter_rule.traffic_mirror_filter_rule_id #=> String
    #   resp.traffic_mirror_filter_rule.traffic_mirror_filter_id #=> String
    #   resp.traffic_mirror_filter_rule.traffic_direction #=> String, one of "ingress", "egress"
    #   resp.traffic_mirror_filter_rule.rule_number #=> Integer
    #   resp.traffic_mirror_filter_rule.rule_action #=> String, one of "accept", "reject"
    #   resp.traffic_mirror_filter_rule.protocol #=> Integer
    #   resp.traffic_mirror_filter_rule.destination_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filter_rule.destination_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filter_rule.source_port_range.from_port #=> Integer
    #   resp.traffic_mirror_filter_rule.source_port_range.to_port #=> Integer
    #   resp.traffic_mirror_filter_rule.destination_cidr_block #=> String
    #   resp.traffic_mirror_filter_rule.source_cidr_block #=> String
    #   resp.traffic_mirror_filter_rule.description #=> String
    #   resp.traffic_mirror_filter_rule.tags #=> Array
    #   resp.traffic_mirror_filter_rule.tags[0].key #=> String
    #   resp.traffic_mirror_filter_rule.tags[0].value #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRule AWS API Documentation
    #
    # @overload create_traffic_mirror_filter_rule(params = {})
    # @param [Hash] params ({})
    def create_traffic_mirror_filter_rule(params = {}, options = {})
      req = build_request(:create_traffic_mirror_filter_rule, params)
      req.send_request(options)
    end

    # Creates a Traffic Mirror session.
    #
    # A Traffic Mirror session actively copies packets from a Traffic Mirror
    # source to a Traffic Mirror target. Create a filter, and then assign it
    # to the session to define a subset of the traffic to mirror, for
    # example all TCP traffic.
    #
    # The Traffic Mirror source and the Traffic Mirror target (monitoring
    # appliances) can be in the same VPC, or in a different VPC connected
    # via VPC peering or a transit gateway.
    #
    # By default, no traffic is mirrored. Use [CreateTrafficMirrorFilter][1]
    # to create filter rules that specify the traffic to mirror.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.html
    #
    # @option params [required, String] :network_interface_id
    #   The ID of the source network interface.
    #
    # @option params [required, String] :traffic_mirror_target_id
    #   The ID of the Traffic Mirror target.
    #
    # @option params [required, String] :traffic_mirror_filter_id
    #   The ID of the Traffic Mirror filter.
    #
    # @option params [Integer] :packet_length
    #   The number of bytes in each packet to mirror. These are bytes after
    #   the VXLAN header. Do not specify this parameter when you want to
    #   mirror the entire packet. To mirror a subset of the packet, set this
    #   to the length (in bytes) that you want to mirror. For example, if you
    #   set this value to 100, then the first 100 bytes that meet the filter
    #   criteria are copied to the target.
    #
    #   If you do not want to mirror the entire packet, use the `PacketLength`
    #   parameter to specify the number of bytes in each packet to mirror.
    #
    #   For sessions with Network Load Balancer (NLB) Traffic Mirror targets
    #   the default `PacketLength` will be set to 8500. Valid values are
    #   1-8500. Setting a `PacketLength` greater than 8500 will result in an
    #   error response.
    #
    # @option params [required, Integer] :session_number
    #   The session number determines the order in which sessions are
    #   evaluated when an interface is used by multiple sessions. The first
    #   session with a matching filter is the one that mirrors the packets.
    #
    #   Valid values are 1-32766.
    #
    # @option params [Integer] :virtual_network_id
    #   The VXLAN ID for the Traffic Mirror session. For more information
    #   about the VXLAN protocol, see [RFC 7348][1]. If you do not specify a
    #   `VirtualNetworkId`, an account-wide unique ID is chosen at random.
    #
    #
    #
    #   [1]: https://datatracker.ietf.org/doc/html/rfc7348
    #
    # @option params [String] :description
    #   The description of the Traffic Mirror session.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to a Traffic Mirror session.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @return [Types::CreateTrafficMirrorSessionResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTrafficMirrorSessionResult#traffic_mirror_session #traffic_mirror_session} => Types::TrafficMirrorSession
    #   * {Types::CreateTrafficMirrorSessionResult#client_token #client_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_traffic_mirror_session({
    #     network_interface_id: "NetworkInterfaceId", # required
    #     traffic_mirror_target_id: "TrafficMirrorTargetId", # required
    #     traffic_mirror_filter_id: "TrafficMirrorFilterId", # required
    #     packet_length: 1,
    #     session_number: 1, # required
    #     virtual_network_id: 1,
    #     description: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #     client_token: "String",
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_session.traffic_mirror_session_id #=> String
    #   resp.traffic_mirror_session.traffic_mirror_target_id #=> String
    #   resp.traffic_mirror_session.traffic_mirror_filter_id #=> String
    #   resp.traffic_mirror_session.network_interface_id #=> String
    #   resp.traffic_mirror_session.owner_id #=> String
    #   resp.traffic_mirror_session.packet_length #=> Integer
    #   resp.traffic_mirror_session.session_number #=> Integer
    #   resp.traffic_mirror_session.virtual_network_id #=> Integer
    #   resp.traffic_mirror_session.description #=> String
    #   resp.traffic_mirror_session.tags #=> Array
    #   resp.traffic_mirror_session.tags[0].key #=> String
    #   resp.traffic_mirror_session.tags[0].value #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSession AWS API Documentation
    #
    # @overload create_traffic_mirror_session(params = {})
    # @param [Hash] params ({})
    def create_traffic_mirror_session(params = {}, options = {})
      req = build_request(:create_traffic_mirror_session, params)
      req.send_request(options)
    end

    # Creates a target for your Traffic Mirror session.
    #
    # A Traffic Mirror target is the destination for mirrored traffic. The
    # Traffic Mirror source and the Traffic Mirror target (monitoring
    # appliances) can be in the same VPC, or in different VPCs connected via
    # VPC peering or a transit gateway.
    #
    # A Traffic Mirror target can be a network interface, a Network Load
    # Balancer, or a Gateway Load Balancer endpoint.
    #
    # To use the target in a Traffic Mirror session, use
    # [CreateTrafficMirrorSession][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm
    #
    # @option params [String] :network_interface_id
    #   The network interface ID that is associated with the target.
    #
    # @option params [String] :network_load_balancer_arn
    #   The Amazon Resource Name (ARN) of the Network Load Balancer that is
    #   associated with the target.
    #
    # @option params [String] :description
    #   The description of the Traffic Mirror target.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to assign to the Traffic Mirror target.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @option params [String] :client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to ensure
    #   idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.**
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
    #
    # @option params [String] :gateway_load_balancer_endpoint_id
    #   The ID of the Gateway Load Balancer endpoint.
    #
    # @return [Types::CreateTrafficMirrorTargetResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTrafficMirrorTargetResult#traffic_mirror_target #traffic_mirror_target} => Types::TrafficMirrorTarget
    #   * {Types::CreateTrafficMirrorTargetResult#client_token #client_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_traffic_mirror_target({
    #     network_interface_id: "NetworkInterfaceId",
    #     network_load_balancer_arn: "String",
    #     description: "String",
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #     client_token: "String",
    #     gateway_load_balancer_endpoint_id: "VpcEndpointId",
    #   })
    #
    # @example Response structure
    #
    #   resp.traffic_mirror_target.traffic_mirror_target_id #=> String
    #   resp.traffic_mirror_target.network_interface_id #=> String
    #   resp.traffic_mirror_target.network_load_balancer_arn #=> String
    #   resp.traffic_mirror_target.type #=> String, one of "network-interface", "network-load-balancer", "gateway-load-balancer-endpoint"
    #   resp.traffic_mirror_target.description #=> String
    #   resp.traffic_mirror_target.owner_id #=> String
    #   resp.traffic_mirror_target.tags #=> Array
    #   resp.traffic_mirror_target.tags[0].key #=> String
    #   resp.traffic_mirror_target.tags[0].value #=> String
    #   resp.traffic_mirror_target.gateway_load_balancer_endpoint_id #=> String
    #   resp.client_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorTarget AWS API Documentation
    #
    # @overload create_traffic_mirror_target(params = {})
    # @param [Hash] params ({})
    def create_traffic_mirror_target(params = {}, options = {})
      req = build_request(:create_traffic_mirror_target, params)
      req.send_request(options)
    end

    # Creates a transit gateway.
    #
    # You can use a transit gateway to interconnect your virtual private
    # clouds (VPC) and on-premises networks. After the transit gateway
    # enters the `available` state, you can attach your VPCs and VPN
    # connections to the transit gateway.
    #
    # To attach your VPCs, use CreateTransitGatewayVpcAttachment.
    #
    # To attach a VPN connection, use CreateCustomerGateway to create a
    # customer gateway and specify the ID of the customer gateway and the ID
    # of the transit gateway in a call to CreateVpnConnection.
    #
    # When you create a transit gateway, we create a default transit gateway
    # route table and use it as the default association route table and the
    # default propagation route table. You can use
    # CreateTransitGatewayRouteTable to create additional transit gateway
    # route tables. If you disable automatic route propagation, we do not
    # create a default transit gateway route table. You can use
    # EnableTransitGatewayRouteTablePropagation to propagate routes from a
    # resource attachment to a transit gateway route table. If you disable
    # automatic associations, you can use AssociateTransitGatewayRouteTable
    # to associate a resource attachment with a transit gateway route table.
    #
    # @option params [String] :description
    #   A description of the transit gateway.
    #
    # @option params [Types::TransitGatewayRequestOptions] :options
    #   The transit gateway options.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the transit gateway.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateTransitGatewayResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTransitGatewayResult#transit_gateway #transit_gateway} => Types::TransitGateway
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_transit_gateway({
    #     description: "String",
    #     options: {
    #       amazon_side_asn: 1,
    #       auto_accept_shared_attachments: "enable", # accepts enable, disable
    #       default_route_table_association: "enable", # accepts enable, disable
    #       default_route_table_propagation: "enable", # accepts enable, disable
    #       vpn_ecmp_support: "enable", # accepts enable, disable
    #       dns_support: "enable", # accepts enable, disable
    #       security_group_referencing_support: "enable", # accepts enable, disable
    #       multicast_support: "enable", # accepts enable, disable
    #       transit_gateway_cidr_blocks: ["String"],
    #     },
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway.transit_gateway_id #=> String
    #   resp.transit_gateway.transit_gateway_arn #=> String
    #   resp.transit_gateway.state #=> String, one of "pending", "available", "modifying", "deleting", "deleted"
    #   resp.transit_gateway.owner_id #=> String
    #   resp.transit_gateway.description #=> String
    #   resp.transit_gateway.creation_time #=> Time
    #   resp.transit_gateway.options.amazon_side_asn #=> Integer
    #   resp.transit_gateway.options.transit_gateway_cidr_blocks #=> Array
    #   resp.transit_gateway.options.transit_gateway_cidr_blocks[0] #=> String
    #   resp.transit_gateway.options.auto_accept_shared_attachments #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.default_route_table_association #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.association_default_route_table_id #=> String
    #   resp.transit_gateway.options.default_route_table_propagation #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.propagation_default_route_table_id #=> String
    #   resp.transit_gateway.options.vpn_ecmp_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.dns_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.security_group_referencing_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway.options.multicast_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway.tags #=> Array
    #   resp.transit_gateway.tags[0].key #=> String
    #   resp.transit_gateway.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGateway AWS API Documentation
    #
    # @overload create_transit_gateway(params = {})
    # @param [Hash] params ({})
    def create_transit_gateway(params = {}, options = {})
      req = build_request(:create_transit_gateway, params)
      req.send_request(options)
    end

    # Creates a Connect attachment from a specified transit gateway
    # attachment. A Connect attachment is a GRE-based tunnel attachment that
    # you can use to establish a connection between a transit gateway and an
    # appliance.
    #
    # A Connect attachment uses an existing VPC or Amazon Web Services
    # Direct Connect attachment as the underlying transport mechanism.
    #
    # @option params [required, String] :transport_transit_gateway_attachment_id
    #   The ID of the transit gateway attachment. You can specify a VPC
    #   attachment or Amazon Web Services Direct Connect attachment.
    #
    # @option params [required, Types::CreateTransitGatewayConnectRequestOptions] :options
    #   The Connect attachment options.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the Connect attachment.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateTransitGatewayConnectResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTransitGatewayConnectResult#transit_gateway_connect #transit_gateway_connect} => Types::TransitGatewayConnect
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_transit_gateway_connect({
    #     transport_transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #     options: { # required
    #       protocol: "gre", # required, accepts gre
    #     },
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_connect.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_connect.transport_transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_connect.transit_gateway_id #=> String
    #   resp.transit_gateway_connect.state #=> String, one of "initiating", "initiatingRequest", "pendingAcceptance", "rollingBack", "pending", "available", "modifying", "deleting", "deleted", "failed", "rejected", "rejecting", "failing"
    #   resp.transit_gateway_connect.creation_time #=> Time
    #   resp.transit_gateway_connect.options.protocol #=> String, one of "gre"
    #   resp.transit_gateway_connect.tags #=> Array
    #   resp.transit_gateway_connect.tags[0].key #=> String
    #   resp.transit_gateway_connect.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnect AWS API Documentation
    #
    # @overload create_transit_gateway_connect(params = {})
    # @param [Hash] params ({})
    def create_transit_gateway_connect(params = {}, options = {})
      req = build_request(:create_transit_gateway_connect, params)
      req.send_request(options)
    end

    # Creates a Connect peer for a specified transit gateway Connect
    # attachment between a transit gateway and an appliance.
    #
    # The peer address and transit gateway address must be the same IP
    # address family (IPv4 or IPv6).
    #
    # For more information, see [Connect peers][1] in the *Amazon Web
    # Services Transit Gateways Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpc/latest/tgw/tgw-connect.html#tgw-connect-peer
    #
    # @option params [required, String] :transit_gateway_attachment_id
    #   The ID of the Connect attachment.
    #
    # @option params [String] :transit_gateway_address
    #   The peer IP address (GRE outer IP address) on the transit gateway side
    #   of the Connect peer, which must be specified from a transit gateway
    #   CIDR block. If not specified, Amazon automatically assigns the first
    #   available IP address from the transit gateway CIDR block.
    #
    # @option params [required, String] :peer_address
    #   The peer IP address (GRE outer IP address) on the appliance side of
    #   the Connect peer.
    #
    # @option params [Types::TransitGatewayConnectRequestBgpOptions] :bgp_options
    #   The BGP options for the Connect peer.
    #
    # @option params [required, Array<String>] :inside_cidr_blocks
    #   The range of inside IP addresses that are used for BGP peering. You
    #   must specify a size /29 IPv4 CIDR block from the `169.254.0.0/16`
    #   range. The first address from the range must be configured on the
    #   appliance as the BGP IP address. You can also optionally specify a
    #   size /125 IPv6 CIDR block from the `fd00::/8` range.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the Connect peer.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateTransitGatewayConnectPeerResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTransitGatewayConnectPeerResult#transit_gateway_connect_peer #transit_gateway_connect_peer} => Types::TransitGatewayConnectPeer
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_transit_gateway_connect_peer({
    #     transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #     transit_gateway_address: "String",
    #     peer_address: "String", # required
    #     bgp_options: {
    #       peer_asn: 1,
    #     },
    #     inside_cidr_blocks: ["String"], # required
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_connect_peer.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_connect_peer.transit_gateway_connect_peer_id #=> String
    #   resp.transit_gateway_connect_peer.state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.transit_gateway_connect_peer.creation_time #=> Time
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.transit_gateway_address #=> String
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.peer_address #=> String
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.inside_cidr_blocks #=> Array
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.inside_cidr_blocks[0] #=> String
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.protocol #=> String, one of "gre"
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.bgp_configurations #=> Array
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.bgp_configurations[0].transit_gateway_asn #=> Integer
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.bgp_configurations[0].peer_asn #=> Integer
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.bgp_configurations[0].transit_gateway_address #=> String
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.bgp_configurations[0].peer_address #=> String
    #   resp.transit_gateway_connect_peer.connect_peer_configuration.bgp_configurations[0].bgp_status #=> String, one of "up", "down"
    #   resp.transit_gateway_connect_peer.tags #=> Array
    #   resp.transit_gateway_connect_peer.tags[0].key #=> String
    #   resp.transit_gateway_connect_peer.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectPeer AWS API Documentation
    #
    # @overload create_transit_gateway_connect_peer(params = {})
    # @param [Hash] params ({})
    def create_transit_gateway_connect_peer(params = {}, options = {})
      req = build_request(:create_transit_gateway_connect_peer, params)
      req.send_request(options)
    end

    # Creates a multicast domain using the specified transit gateway.
    #
    # The transit gateway must be in the available state before you create a
    # domain. Use [DescribeTransitGateways][1] to see the state of transit
    # gateway.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html
    #
    # @option params [required, String] :transit_gateway_id
    #   The ID of the transit gateway.
    #
    # @option params [Types::CreateTransitGatewayMulticastDomainRequestOptions] :options
    #   The options for the transit gateway multicast domain.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags for the transit gateway multicast domain.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateTransitGatewayMulticastDomainResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTransitGatewayMulticastDomainResult#transit_gateway_multicast_domain #transit_gateway_multicast_domain} => Types::TransitGatewayMulticastDomain
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_transit_gateway_multicast_domain({
    #     transit_gateway_id: "TransitGatewayId", # required
    #     options: {
    #       igmpv_2_support: "enable", # accepts enable, disable
    #       static_sources_support: "enable", # accepts enable, disable
    #       auto_accept_shared_associations: "enable", # accepts enable, disable
    #     },
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_multicast_domain.transit_gateway_multicast_domain_id #=> String
    #   resp.transit_gateway_multicast_domain.transit_gateway_id #=> String
    #   resp.transit_gateway_multicast_domain.transit_gateway_multicast_domain_arn #=> String
    #   resp.transit_gateway_multicast_domain.owner_id #=> String
    #   resp.transit_gateway_multicast_domain.options.igmpv_2_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_multicast_domain.options.static_sources_support #=> String, one of "enable", "disable"
    #   resp.transit_gateway_multicast_domain.options.auto_accept_shared_associations #=> String, one of "enable", "disable"
    #   resp.transit_gateway_multicast_domain.state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.transit_gateway_multicast_domain.creation_time #=> Time
    #   resp.transit_gateway_multicast_domain.tags #=> Array
    #   resp.transit_gateway_multicast_domain.tags[0].key #=> String
    #   resp.transit_gateway_multicast_domain.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomain AWS API Documentation
    #
    # @overload create_transit_gateway_multicast_domain(params = {})
    # @param [Hash] params ({})
    def create_transit_gateway_multicast_domain(params = {}, options = {})
      req = build_request(:create_transit_gateway_multicast_domain, params)
      req.send_request(options)
    end

    # Requests a transit gateway peering attachment between the specified
    # transit gateway (requester) and a peer transit gateway (accepter). The
    # peer transit gateway can be in your account or a different Amazon Web
    # Services account.
    #
    # After you create the peering attachment, the owner of the accepter
    # transit gateway must accept the attachment request.
    #
    # @option params [required, String] :transit_gateway_id
    #   The ID of the transit gateway.
    #
    # @option params [required, String] :peer_transit_gateway_id
    #   The ID of the peer transit gateway with which to create the peering
    #   attachment.
    #
    # @option params [required, String] :peer_account_id
    #   The ID of the Amazon Web Services account that owns the peer transit
    #   gateway.
    #
    # @option params [required, String] :peer_region
    #   The Region where the peer transit gateway is located.
    #
    # @option params [Types::CreateTransitGatewayPeeringAttachmentRequestOptions] :options
    #   Requests a transit gateway peering attachment.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags to apply to the transit gateway peering attachment.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateTransitGatewayPeeringAttachmentResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTransitGatewayPeeringAttachmentResult#transit_gateway_peering_attachment #transit_gateway_peering_attachment} => Types::TransitGatewayPeeringAttachment
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_transit_gateway_peering_attachment({
    #     transit_gateway_id: "TransitGatewayId", # required
    #     peer_transit_gateway_id: "TransitAssociationGatewayId", # required
    #     peer_account_id: "String", # required
    #     peer_region: "String", # required
    #     options: {
    #       dynamic_routing: "enable", # accepts enable, disable
    #     },
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_peering_attachment.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_peering_attachment.accepter_transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_peering_attachment.requester_tgw_info.transit_gateway_id #=> String
    #   resp.transit_gateway_peering_attachment.requester_tgw_info.core_network_id #=> String
    #   resp.transit_gateway_peering_attachment.requester_tgw_info.owner_id #=> String
    #   resp.transit_gateway_peering_attachment.requester_tgw_info.region #=> String
    #   resp.transit_gateway_peering_attachment.accepter_tgw_info.transit_gateway_id #=> String
    #   resp.transit_gateway_peering_attachment.accepter_tgw_info.core_network_id #=> String
    #   resp.transit_gateway_peering_attachment.accepter_tgw_info.owner_id #=> String
    #   resp.transit_gateway_peering_attachment.accepter_tgw_info.region #=> String
    #   resp.transit_gateway_peering_attachment.options.dynamic_routing #=> String, one of "enable", "disable"
    #   resp.transit_gateway_peering_attachment.status.code #=> String
    #   resp.transit_gateway_peering_attachment.status.message #=> String
    #   resp.transit_gateway_peering_attachment.state #=> String, one of "initiating", "initiatingRequest", "pendingAcceptance", "rollingBack", "pending", "available", "modifying", "deleting", "deleted", "failed", "rejected", "rejecting", "failing"
    #   resp.transit_gateway_peering_attachment.creation_time #=> Time
    #   resp.transit_gateway_peering_attachment.tags #=> Array
    #   resp.transit_gateway_peering_attachment.tags[0].key #=> String
    #   resp.transit_gateway_peering_attachment.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPeeringAttachment AWS API Documentation
    #
    # @overload create_transit_gateway_peering_attachment(params = {})
    # @param [Hash] params ({})
    def create_transit_gateway_peering_attachment(params = {}, options = {})
      req = build_request(:create_transit_gateway_peering_attachment, params)
      req.send_request(options)
    end

    # Creates a transit gateway policy table.
    #
    # @option params [required, String] :transit_gateway_id
    #   The ID of the transit gateway used for the policy table.
    #
    # @option params [Array<Types::TagSpecification>] :tag_specifications
    #   The tags specification for the transit gateway policy table created
    #   during the request.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateTransitGatewayPolicyTableResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTransitGatewayPolicyTableResult#transit_gateway_policy_table #transit_gateway_policy_table} => Types::TransitGatewayPolicyTable
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_transit_gateway_policy_table({
    #     transit_gateway_id: "TransitGatewayId", # required
    #     tag_specifications: [
    #       {
    #         resource_type: "capacity-reservation", # accepts capacity-reservation, client-vpn-endpoint, customer-gateway, carrier-gateway, coip-pool, declarative-policies-report, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, image-usage-report, import-image-task, import-snapshot-task, instance, instance-event-window, internet-gateway, ipam, ipam-pool, ipam-scope, ipv4pool-ec2, ipv6pool-ec2, key-pair, launch-template, local-gateway, local-gateway-route-table, local-gateway-virtual-interface, local-gateway-virtual-interface-group, local-gateway-route-table-vpc-association, local-gateway-route-table-virtual-interface-group-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, network-insights-access-scope, network-insights-access-scope-analysis, outpost-lag, placement-group, prefix-list, replace-root-volume-task, reserved-instances, route-table, security-group, security-group-rule, service-link-virtual-interface, snapshot, spot-fleet-request, spot-instances-request, subnet, subnet-cidr-reservation, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-policy-table, transit-gateway-route-table, transit-gateway-route-table-announcement, volume, vpc, vpc-endpoint, vpc-endpoint-connection, vpc-endpoint-service, vpc-endpoint-service-permission, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log, capacity-reservation-fleet, traffic-mirror-filter-rule, vpc-endpoint-connection-device-type, verified-access-instance, verified-access-group, verified-access-endpoint, verified-access-policy, verified-access-trust-provider, vpn-connection-device-type, vpc-block-public-access-exclusion, route-server, route-server-endpoint, route-server-peer, ipam-resource-discovery, ipam-resource-discovery-association, instance-connect-endpoint, verified-access-endpoint-target, ipam-external-resource-verification-token, capacity-block, mac-modification-task
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       },
    #     ],
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_policy_table.transit_gateway_policy_table_id #=> String
    #   resp.transit_gateway_policy_table.transit_gateway_id #=> String
    #   resp.transit_gateway_policy_table.state #=> String, one of "pending", "available", "deleting", "deleted"
    #   resp.transit_gateway_policy_table.creation_time #=> Time
    #   resp.transit_gateway_policy_table.tags #=> Array
    #   resp.transit_gateway_policy_table.tags[0].key #=> String
    #   resp.transit_gateway_policy_table.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPolicyTable AWS API Documentation
    #
    # @overload create_transit_gateway_policy_table(params = {})
    # @param [Hash] params ({})
    def create_transit_gateway_policy_table(params = {}, options = {})
      req = build_request(:create_transit_gateway_policy_table, params)
      req.send_request(options)
    end

    # Creates a reference (route) to a prefix list in a specified transit
    # gateway route table.
    #
    # @option params [required, String] :transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #
    # @option params [required, String] :prefix_list_id
    #   The ID of the prefix list that is used for destination matches.
    #
    # @option params [String] :transit_gateway_attachment_id
    #   The ID of the attachment to which traffic is routed.
    #
    # @option params [Boolean] :blackhole
    #   Indicates whether to drop traffic that matches this route.
    #
    # @option params [Boolean] :dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #
    # @return [Types::CreateTransitGatewayPrefixListReferenceResult] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateTransitGatewayPrefixListReferenceResult#transit_gateway_prefix_list_reference #transit_gateway_prefix_list_reference} => Types::TransitGatewayPrefixListReference
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_transit_gateway_prefix_list_reference({
    #     transit_gateway_route_table_id: "TransitGatewayRouteTableId", # required
    #     prefix_list_id: "PrefixListResourceId", # required
    #     transit_gateway_attachment_id: "TransitGatewayAttachmentId",
    #     blackhole: false,
    #     dry_run: false,
    #   })
    #
    # @example Response structure
    #
    #   resp.transit_gateway_prefix_list_reference.transit_gateway_route_table_id #=> String
    #   resp.transit_gateway_prefix_list_reference.prefix_list_id #=> String
    #   resp.transit_gateway_prefix_list_reference.prefix_list_owner_id #=> String
    #   resp.transit_gateway_prefix_list_reference.state #=> String, one of "pending", "available", "modifying", "deleting"
    #   resp.transit_gateway_prefix_list_reference.blackhole #=> Boolean
    #   resp.transit_gateway_prefix_list_reference.transit_gateway_attachment.transit_gateway_attachment_id #=> String
    #   resp.transit_gateway_prefix_list_reference.transit_gateway_attachment.resource_type #=> String, one of "vpc", "vpn", "direct-connect-gateway", "connect", "peering", "tgw-peering", "network-function"
    #   resp.transit_gateway_prefix_list_reference.transit_gateway_attachment.resource_id #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPrefixListReference AWS API Documentation
    #
    # @overload create_transit_gateway_prefix_list_reference(params = {})
    # @param [Hash] params ({})
    def create_transit_gateway_prefix_list_reference(params = {}, options = {})
      req = build_request(:create_transit_gateway_prefix_list_reference, params)
      req.send_request(options)
    end

    # Creates a static route for the specified transit gateway route table.
    #
    # @option params [required, String] :destination_cidr_block
    #   The CIDR range used for destination matches. Routing decisions are
    #   based on the most specific match.
    #
    # @option params [required, String] :transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #
    # @option params [String] :transit_gateway_attachment_id
    #   The ID o