# frozen_string_literal: true

# WARNING ABOUT GENERATED CODE
#
# This file is generated. See the contributing guide for more information:
# https://github.com/aws/aws-sdk-ruby/blob/version-3/CONTRIBUTING.md
#
# WARNING ABOUT GENERATED CODE

module Aws::ElasticLoadBalancing
  module Types

    # Information about the `AccessLog` attribute.
    #
    # @!attribute [rw] enabled
    #   Specifies whether access logs are enabled for the load balancer.
    #   @return [Boolean]
    #
    # @!attribute [rw] s3_bucket_name
    #   The name of the Amazon S3 bucket where the access logs are stored.
    #   @return [String]
    #
    # @!attribute [rw] emit_interval
    #   The interval for publishing the access logs. You can specify an
    #   interval of either 5 minutes or 60 minutes.
    #
    #   Default: 60 minutes
    #   @return [Integer]
    #
    # @!attribute [rw] s3_bucket_prefix
    #   The logical hierarchy you created for your Amazon S3 bucket, for
    #   example `my-bucket-prefix/prod`. If the prefix is not provided, the
    #   log is placed at the root level of the bucket.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/AccessLog AWS API Documentation
    #
    class AccessLog < Struct.new(
      :enabled,
      :s3_bucket_name,
      :emit_interval,
      :s3_bucket_prefix)
      SENSITIVE = []
      include Aws::Structure
    end

    # The specified load balancer does not exist.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/AccessPointNotFoundException AWS API Documentation
    #
    class AccessPointNotFoundException < Aws::EmptyStructure; end

    # Contains the parameters for EnableAvailabilityZonesForLoadBalancer.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] availability_zones
    #   The Availability Zones. These must be in the same region as the load
    #   balancer.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/AddAvailabilityZonesInput AWS API Documentation
    #
    class AddAvailabilityZonesInput < Struct.new(
      :load_balancer_name,
      :availability_zones)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of EnableAvailabilityZonesForLoadBalancer.
    #
    # @!attribute [rw] availability_zones
    #   The updated list of Availability Zones for the load balancer.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/AddAvailabilityZonesOutput AWS API Documentation
    #
    class AddAvailabilityZonesOutput < Struct.new(
      :availability_zones)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for AddTags.
    #
    # @!attribute [rw] load_balancer_names
    #   The name of the load balancer. You can specify one load balancer
    #   only.
    #   @return [Array<String>]
    #
    # @!attribute [rw] tags
    #   The tags.
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/AddTagsInput AWS API Documentation
    #
    class AddTagsInput < Struct.new(
      :load_balancer_names,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of AddTags.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/AddTagsOutput AWS API Documentation
    #
    class AddTagsOutput < Aws::EmptyStructure; end

    # Information about additional load balancer attributes.
    #
    # @!attribute [rw] key
    #   The name of the attribute.
    #
    #   The following attribute is supported.
    #
    #   * `elb.http.desyncmitigationmode` - Determines how the load balancer
    #     handles requests that might pose a security risk to your
    #     application. The possible values are `monitor`, `defensive`, and
    #     `strictest`. The default is `defensive`.
    #
    #   ^
    #   @return [String]
    #
    # @!attribute [rw] value
    #   This value of the attribute.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/AdditionalAttribute AWS API Documentation
    #
    class AdditionalAttribute < Struct.new(
      :key,
      :value)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about a policy for application-controlled session
    # stickiness.
    #
    # @!attribute [rw] policy_name
    #   The mnemonic name for the policy being created. The name must be
    #   unique within a set of policies for this load balancer.
    #   @return [String]
    #
    # @!attribute [rw] cookie_name
    #   The name of the application cookie used for stickiness.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/AppCookieStickinessPolicy AWS API Documentation
    #
    class AppCookieStickinessPolicy < Struct.new(
      :policy_name,
      :cookie_name)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for ApplySecurityGroupsToLoadBalancer.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] security_groups
    #   The IDs of the security groups to associate with the load balancer.
    #   Note that you cannot specify the name of the security group.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/ApplySecurityGroupsToLoadBalancerInput AWS API Documentation
    #
    class ApplySecurityGroupsToLoadBalancerInput < Struct.new(
      :load_balancer_name,
      :security_groups)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of ApplySecurityGroupsToLoadBalancer.
    #
    # @!attribute [rw] security_groups
    #   The IDs of the security groups associated with the load balancer.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/ApplySecurityGroupsToLoadBalancerOutput AWS API Documentation
    #
    class ApplySecurityGroupsToLoadBalancerOutput < Struct.new(
      :security_groups)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for AttachLoaBalancerToSubnets.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] subnets
    #   The IDs of the subnets to add. You can add only one subnet per
    #   Availability Zone.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/AttachLoadBalancerToSubnetsInput AWS API Documentation
    #
    class AttachLoadBalancerToSubnetsInput < Struct.new(
      :load_balancer_name,
      :subnets)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of AttachLoadBalancerToSubnets.
    #
    # @!attribute [rw] subnets
    #   The IDs of the subnets attached to the load balancer.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/AttachLoadBalancerToSubnetsOutput AWS API Documentation
    #
    class AttachLoadBalancerToSubnetsOutput < Struct.new(
      :subnets)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about the configuration of an EC2 instance.
    #
    # @!attribute [rw] instance_port
    #   The port on which the EC2 instance is listening.
    #   @return [Integer]
    #
    # @!attribute [rw] policy_names
    #   The names of the policies enabled for the EC2 instance.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/BackendServerDescription AWS API Documentation
    #
    class BackendServerDescription < Struct.new(
      :instance_port,
      :policy_names)
      SENSITIVE = []
      include Aws::Structure
    end

    # The specified ARN does not refer to a valid SSL certificate in AWS
    # Identity and Access Management (IAM) or AWS Certificate Manager (ACM).
    # Note that if you recently uploaded the certificate to IAM, this error
    # might indicate that the certificate is not fully available yet.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/CertificateNotFoundException AWS API Documentation
    #
    class CertificateNotFoundException < Aws::EmptyStructure; end

    # Contains the parameters for ConfigureHealthCheck.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] health_check
    #   The configuration information.
    #   @return [Types::HealthCheck]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/ConfigureHealthCheckInput AWS API Documentation
    #
    class ConfigureHealthCheckInput < Struct.new(
      :load_balancer_name,
      :health_check)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of ConfigureHealthCheck.
    #
    # @!attribute [rw] health_check
    #   The updated health check.
    #   @return [Types::HealthCheck]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/ConfigureHealthCheckOutput AWS API Documentation
    #
    class ConfigureHealthCheckOutput < Struct.new(
      :health_check)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about the `ConnectionDraining` attribute.
    #
    # @!attribute [rw] enabled
    #   Specifies whether connection draining is enabled for the load
    #   balancer.
    #   @return [Boolean]
    #
    # @!attribute [rw] timeout
    #   The maximum time, in seconds, to keep the existing connections open
    #   before deregistering the instances.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/ConnectionDraining AWS API Documentation
    #
    class ConnectionDraining < Struct.new(
      :enabled,
      :timeout)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about the `ConnectionSettings` attribute.
    #
    # @!attribute [rw] idle_timeout
    #   The time, in seconds, that the connection is allowed to be idle (no
    #   data has been sent over the connection) before it is closed by the
    #   load balancer.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/ConnectionSettings AWS API Documentation
    #
    class ConnectionSettings < Struct.new(
      :idle_timeout)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CreateLoadBalancer.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #
    #   This name must be unique within your set of load balancers for the
    #   region, must have a maximum of 32 characters, must contain only
    #   alphanumeric characters or hyphens, and cannot begin or end with a
    #   hyphen.
    #   @return [String]
    #
    # @!attribute [rw] listeners
    #   The listeners.
    #
    #   For more information, see [Listeners for Your Classic Load
    #   Balancer][1] in the *Classic Load Balancers Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html
    #   @return [Array<Types::Listener>]
    #
    # @!attribute [rw] availability_zones
    #   One or more Availability Zones from the same region as the load
    #   balancer.
    #
    #   You must specify at least one Availability Zone.
    #
    #   You can add more Availability Zones after you create the load
    #   balancer using EnableAvailabilityZonesForLoadBalancer.
    #   @return [Array<String>]
    #
    # @!attribute [rw] subnets
    #   The IDs of the subnets in your VPC to attach to the load balancer.
    #   Specify one subnet per Availability Zone specified in
    #   `AvailabilityZones`.
    #   @return [Array<String>]
    #
    # @!attribute [rw] security_groups
    #   The IDs of the security groups to assign to the load balancer.
    #   @return [Array<String>]
    #
    # @!attribute [rw] scheme
    #   The type of a load balancer. Valid only for load balancers in a VPC.
    #
    #   By default, Elastic Load Balancing creates an Internet-facing load
    #   balancer with a DNS name that resolves to public IP addresses. For
    #   more information about Internet-facing and Internal load balancers,
    #   see [Load Balancer Scheme][1] in the *Elastic Load Balancing User
    #   Guide*.
    #
    #   Specify `internal` to create a load balancer with a DNS name that
    #   resolves to private IP addresses.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/how-elastic-load-balancing-works.html#load-balancer-scheme
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   A list of tags to assign to the load balancer.
    #
    #   For more information about tagging your load balancer, see [Tag Your
    #   Classic Load Balancer][1] in the *Classic Load Balancers Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/CreateAccessPointInput AWS API Documentation
    #
    class CreateAccessPointInput < Struct.new(
      :load_balancer_name,
      :listeners,
      :availability_zones,
      :subnets,
      :security_groups,
      :scheme,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output for CreateLoadBalancer.
    #
    # @!attribute [rw] dns_name
    #   The DNS name of the load balancer.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/CreateAccessPointOutput AWS API Documentation
    #
    class CreateAccessPointOutput < Struct.new(
      :dns_name)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CreateAppCookieStickinessPolicy.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] policy_name
    #   The name of the policy being created. Policy names must consist of
    #   alphanumeric characters and dashes (-). This name must be unique
    #   within the set of policies for this load balancer.
    #   @return [String]
    #
    # @!attribute [rw] cookie_name
    #   The name of the application cookie used for stickiness.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/CreateAppCookieStickinessPolicyInput AWS API Documentation
    #
    class CreateAppCookieStickinessPolicyInput < Struct.new(
      :load_balancer_name,
      :policy_name,
      :cookie_name)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output for CreateAppCookieStickinessPolicy.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/CreateAppCookieStickinessPolicyOutput AWS API Documentation
    #
    class CreateAppCookieStickinessPolicyOutput < Aws::EmptyStructure; end

    # Contains the parameters for CreateLBCookieStickinessPolicy.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] policy_name
    #   The name of the policy being created. Policy names must consist of
    #   alphanumeric characters and dashes (-). This name must be unique
    #   within the set of policies for this load balancer.
    #   @return [String]
    #
    # @!attribute [rw] cookie_expiration_period
    #   The time period, in seconds, after which the cookie should be
    #   considered stale. If you do not specify this parameter, the default
    #   value is 0, which indicates that the sticky session should last for
    #   the duration of the browser session.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/CreateLBCookieStickinessPolicyInput AWS API Documentation
    #
    class CreateLBCookieStickinessPolicyInput < Struct.new(
      :load_balancer_name,
      :policy_name,
      :cookie_expiration_period)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output for CreateLBCookieStickinessPolicy.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/CreateLBCookieStickinessPolicyOutput AWS API Documentation
    #
    class CreateLBCookieStickinessPolicyOutput < Aws::EmptyStructure; end

    # Contains the parameters for CreateLoadBalancerListeners.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] listeners
    #   The listeners.
    #   @return [Array<Types::Listener>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/CreateLoadBalancerListenerInput AWS API Documentation
    #
    class CreateLoadBalancerListenerInput < Struct.new(
      :load_balancer_name,
      :listeners)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CreateLoadBalancerListener.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/CreateLoadBalancerListenerOutput AWS API Documentation
    #
    class CreateLoadBalancerListenerOutput < Aws::EmptyStructure; end

    # Contains the parameters for CreateLoadBalancerPolicy.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] policy_name
    #   The name of the load balancer policy to be created. This name must
    #   be unique within the set of policies for this load balancer.
    #   @return [String]
    #
    # @!attribute [rw] policy_type_name
    #   The name of the base policy type. To get the list of policy types,
    #   use DescribeLoadBalancerPolicyTypes.
    #   @return [String]
    #
    # @!attribute [rw] policy_attributes
    #   The policy attributes.
    #   @return [Array<Types::PolicyAttribute>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/CreateLoadBalancerPolicyInput AWS API Documentation
    #
    class CreateLoadBalancerPolicyInput < Struct.new(
      :load_balancer_name,
      :policy_name,
      :policy_type_name,
      :policy_attributes)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CreateLoadBalancerPolicy.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/CreateLoadBalancerPolicyOutput AWS API Documentation
    #
    class CreateLoadBalancerPolicyOutput < Aws::EmptyStructure; end

    # Information about the `CrossZoneLoadBalancing` attribute.
    #
    # @!attribute [rw] enabled
    #   Specifies whether cross-zone load balancing is enabled for the load
    #   balancer.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/CrossZoneLoadBalancing AWS API Documentation
    #
    class CrossZoneLoadBalancing < Struct.new(
      :enabled)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DeleteLoadBalancer.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DeleteAccessPointInput AWS API Documentation
    #
    class DeleteAccessPointInput < Struct.new(
      :load_balancer_name)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DeleteLoadBalancer.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DeleteAccessPointOutput AWS API Documentation
    #
    class DeleteAccessPointOutput < Aws::EmptyStructure; end

    # Contains the parameters for DeleteLoadBalancerListeners.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] load_balancer_ports
    #   The client port numbers of the listeners.
    #   @return [Array<Integer>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DeleteLoadBalancerListenerInput AWS API Documentation
    #
    class DeleteLoadBalancerListenerInput < Struct.new(
      :load_balancer_name,
      :load_balancer_ports)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DeleteLoadBalancerListeners.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DeleteLoadBalancerListenerOutput AWS API Documentation
    #
    class DeleteLoadBalancerListenerOutput < Aws::EmptyStructure; end

    # Contains the parameters for DeleteLoadBalancerPolicy.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] policy_name
    #   The name of the policy.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DeleteLoadBalancerPolicyInput AWS API Documentation
    #
    class DeleteLoadBalancerPolicyInput < Struct.new(
      :load_balancer_name,
      :policy_name)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DeleteLoadBalancerPolicy.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DeleteLoadBalancerPolicyOutput AWS API Documentation
    #
    class DeleteLoadBalancerPolicyOutput < Aws::EmptyStructure; end

    # A request made by Elastic Load Balancing to another service exceeds
    # the maximum request rate permitted for your account.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DependencyThrottleException AWS API Documentation
    #
    class DependencyThrottleException < Aws::EmptyStructure; end

    # Contains the parameters for DeregisterInstancesFromLoadBalancer.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] instances
    #   The IDs of the instances.
    #   @return [Array<Types::Instance>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DeregisterEndPointsInput AWS API Documentation
    #
    class DeregisterEndPointsInput < Struct.new(
      :load_balancer_name,
      :instances)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DeregisterInstancesFromLoadBalancer.
    #
    # @!attribute [rw] instances
    #   The remaining instances registered with the load balancer.
    #   @return [Array<Types::Instance>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DeregisterEndPointsOutput AWS API Documentation
    #
    class DeregisterEndPointsOutput < Struct.new(
      :instances)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeLoadBalancers.
    #
    # @!attribute [rw] load_balancer_names
    #   The names of the load balancers.
    #   @return [Array<String>]
    #
    # @!attribute [rw] marker
    #   The marker for the next set of results. (You received this marker
    #   from a previous call.)
    #   @return [String]
    #
    # @!attribute [rw] page_size
    #   The maximum number of results to return with this call (a number
    #   from 1 to 400). The default is 400.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DescribeAccessPointsInput AWS API Documentation
    #
    class DescribeAccessPointsInput < Struct.new(
      :load_balancer_names,
      :marker,
      :page_size)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeLoadBalancers.
    #
    # @!attribute [rw] load_balancer_descriptions
    #   Information about the load balancers.
    #   @return [Array<Types::LoadBalancerDescription>]
    #
    # @!attribute [rw] next_marker
    #   The marker to use when requesting the next set of results. If there
    #   are no additional results, the string is empty.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DescribeAccessPointsOutput AWS API Documentation
    #
    class DescribeAccessPointsOutput < Struct.new(
      :load_balancer_descriptions,
      :next_marker)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] marker
    #   The marker for the next set of results. (You received this marker
    #   from a previous call.)
    #   @return [String]
    #
    # @!attribute [rw] page_size
    #   The maximum number of results to return with this call.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DescribeAccountLimitsInput AWS API Documentation
    #
    class DescribeAccountLimitsInput < Struct.new(
      :marker,
      :page_size)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] limits
    #   Information about the limits.
    #   @return [Array<Types::Limit>]
    #
    # @!attribute [rw] next_marker
    #   The marker to use when requesting the next set of results. If there
    #   are no additional results, the string is empty.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DescribeAccountLimitsOutput AWS API Documentation
    #
    class DescribeAccountLimitsOutput < Struct.new(
      :limits,
      :next_marker)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeInstanceHealth.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] instances
    #   The IDs of the instances.
    #   @return [Array<Types::Instance>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DescribeEndPointStateInput AWS API Documentation
    #
    class DescribeEndPointStateInput < Struct.new(
      :load_balancer_name,
      :instances)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output for DescribeInstanceHealth.
    #
    # @!attribute [rw] instance_states
    #   Information about the health of the instances.
    #   @return [Array<Types::InstanceState>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DescribeEndPointStateOutput AWS API Documentation
    #
    class DescribeEndPointStateOutput < Struct.new(
      :instance_states)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeLoadBalancerAttributes.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DescribeLoadBalancerAttributesInput AWS API Documentation
    #
    class DescribeLoadBalancerAttributesInput < Struct.new(
      :load_balancer_name)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeLoadBalancerAttributes.
    #
    # @!attribute [rw] load_balancer_attributes
    #   Information about the load balancer attributes.
    #   @return [Types::LoadBalancerAttributes]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DescribeLoadBalancerAttributesOutput AWS API Documentation
    #
    class DescribeLoadBalancerAttributesOutput < Struct.new(
      :load_balancer_attributes)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeLoadBalancerPolicies.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] policy_names
    #   The names of the policies.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DescribeLoadBalancerPoliciesInput AWS API Documentation
    #
    class DescribeLoadBalancerPoliciesInput < Struct.new(
      :load_balancer_name,
      :policy_names)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeLoadBalancerPolicies.
    #
    # @!attribute [rw] policy_descriptions
    #   Information about the policies.
    #   @return [Array<Types::PolicyDescription>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DescribeLoadBalancerPoliciesOutput AWS API Documentation
    #
    class DescribeLoadBalancerPoliciesOutput < Struct.new(
      :policy_descriptions)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeLoadBalancerPolicyTypes.
    #
    # @!attribute [rw] policy_type_names
    #   The names of the policy types. If no names are specified, describes
    #   all policy types defined by Elastic Load Balancing.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DescribeLoadBalancerPolicyTypesInput AWS API Documentation
    #
    class DescribeLoadBalancerPolicyTypesInput < Struct.new(
      :policy_type_names)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeLoadBalancerPolicyTypes.
    #
    # @!attribute [rw] policy_type_descriptions
    #   Information about the policy types.
    #   @return [Array<Types::PolicyTypeDescription>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DescribeLoadBalancerPolicyTypesOutput AWS API Documentation
    #
    class DescribeLoadBalancerPolicyTypesOutput < Struct.new(
      :policy_type_descriptions)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeTags.
    #
    # @!attribute [rw] load_balancer_names
    #   The names of the load balancers.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DescribeTagsInput AWS API Documentation
    #
    class DescribeTagsInput < Struct.new(
      :load_balancer_names)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output for DescribeTags.
    #
    # @!attribute [rw] tag_descriptions
    #   Information about the tags.
    #   @return [Array<Types::TagDescription>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DescribeTagsOutput AWS API Documentation
    #
    class DescribeTagsOutput < Struct.new(
      :tag_descriptions)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DetachLoadBalancerFromSubnets.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] subnets
    #   The IDs of the subnets.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DetachLoadBalancerFromSubnetsInput AWS API Documentation
    #
    class DetachLoadBalancerFromSubnetsInput < Struct.new(
      :load_balancer_name,
      :subnets)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DetachLoadBalancerFromSubnets.
    #
    # @!attribute [rw] subnets
    #   The IDs of the remaining subnets for the load balancer.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DetachLoadBalancerFromSubnetsOutput AWS API Documentation
    #
    class DetachLoadBalancerFromSubnetsOutput < Struct.new(
      :subnets)
      SENSITIVE = []
      include Aws::Structure
    end

    # The specified load balancer name already exists for this account.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DuplicateAccessPointNameException AWS API Documentation
    #
    class DuplicateAccessPointNameException < Aws::EmptyStructure; end

    # A listener already exists for the specified load balancer name and
    # port, but with a different instance port, protocol, or SSL
    # certificate.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DuplicateListenerException AWS API Documentation
    #
    class DuplicateListenerException < Aws::EmptyStructure; end

    # A policy with the specified name already exists for this load
    # balancer.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DuplicatePolicyNameException AWS API Documentation
    #
    class DuplicatePolicyNameException < Aws::EmptyStructure; end

    # A tag key was specified more than once.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DuplicateTagKeysException AWS API Documentation
    #
    class DuplicateTagKeysException < Aws::EmptyStructure; end

    # Information about a health check.
    #
    # @!attribute [rw] target
    #   The instance being checked. The protocol is either TCP, HTTP, HTTPS,
    #   or SSL. The range of valid ports is one (1) through 65535.
    #
    #   TCP is the default, specified as a TCP: port pair, for example
    #   "TCP:5000". In this case, a health check simply attempts to open a
    #   TCP connection to the instance on the specified port. Failure to
    #   connect within the configured timeout is considered unhealthy.
    #
    #   SSL is also specified as SSL: port pair, for example, SSL:5000.
    #
    #   For HTTP/HTTPS, you must include a ping path in the string. HTTP is
    #   specified as a HTTP:port;/;PathToPing; grouping, for example
    #   "HTTP:80/weather/us/wa/seattle". In this case, a HTTP GET request
    #   is issued to the instance on the given port and path. Any answer
    #   other than "200 OK" within the timeout period is considered
    #   unhealthy.
    #
    #   The total length of the HTTP ping target must be 1024 16-bit Unicode
    #   characters or less.
    #   @return [String]
    #
    # @!attribute [rw] interval
    #   The approximate interval, in seconds, between health checks of an
    #   individual instance.
    #   @return [Integer]
    #
    # @!attribute [rw] timeout
    #   The amount of time, in seconds, during which no response means a
    #   failed health check.
    #
    #   This value must be less than the `Interval` value.
    #   @return [Integer]
    #
    # @!attribute [rw] unhealthy_threshold
    #   The number of consecutive health check failures required before
    #   moving the instance to the `Unhealthy` state.
    #   @return [Integer]
    #
    # @!attribute [rw] healthy_threshold
    #   The number of consecutive health checks successes required before
    #   moving the instance to the `Healthy` state.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/HealthCheck AWS API Documentation
    #
    class HealthCheck < Struct.new(
      :target,
      :interval,
      :timeout,
      :unhealthy_threshold,
      :healthy_threshold)
      SENSITIVE = []
      include Aws::Structure
    end

    # The ID of an EC2 instance.
    #
    # @!attribute [rw] instance_id
    #   The instance ID.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/Instance AWS API Documentation
    #
    class Instance < Struct.new(
      :instance_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about the state of an EC2 instance.
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The current state of the instance.
    #
    #   Valid values: `InService` \| `OutOfService` \| `Unknown`
    #   @return [String]
    #
    # @!attribute [rw] reason_code
    #   Information about the cause of `OutOfService` instances.
    #   Specifically, whether the cause is Elastic Load Balancing or the
    #   instance.
    #
    #   Valid values: `ELB` \| `Instance` \| `N/A`
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A description of the instance state. This string can contain one or
    #   more of the following messages.
    #
    #   * `N/A`
    #
    #   * `A transient error occurred. Please try again later.`
    #
    #   * `Instance has failed at least the UnhealthyThreshold number of
    #     health checks consecutively.`
    #
    #   * `Instance has not passed the configured HealthyThreshold number of
    #     health checks consecutively.`
    #
    #   * `Instance registration is still in progress.`
    #
    #   * `Instance is in the EC2 Availability Zone for which LoadBalancer
    #     is not configured to route traffic to.`
    #
    #   * `Instance is not currently registered with the LoadBalancer.`
    #
    #   * `Instance deregistration currently in progress.`
    #
    #   * `Disable Availability Zone is currently in progress.`
    #
    #   * `Instance is in pending state.`
    #
    #   * `Instance is in stopped state.`
    #
    #   * `Instance is in terminated state.`
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/InstanceState AWS API Documentation
    #
    class InstanceState < Struct.new(
      :instance_id,
      :state,
      :reason_code,
      :description)
      SENSITIVE = []
      include Aws::Structure
    end

    # The requested configuration change is not valid.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/InvalidConfigurationRequestException AWS API Documentation
    #
    class InvalidConfigurationRequestException < Aws::EmptyStructure; end

    # The specified endpoint is not valid.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/InvalidEndPointException AWS API Documentation
    #
    class InvalidEndPointException < Aws::EmptyStructure; end

    # The specified value for the schema is not valid. You can only specify
    # a scheme for load balancers in a VPC.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/InvalidSchemeException AWS API Documentation
    #
    class InvalidSchemeException < Aws::EmptyStructure; end

    # One or more of the specified security groups do not exist.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/InvalidSecurityGroupException AWS API Documentation
    #
    class InvalidSecurityGroupException < Aws::EmptyStructure; end

    # The specified VPC has no associated Internet gateway.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/InvalidSubnetException AWS API Documentation
    #
    class InvalidSubnetException < Aws::EmptyStructure; end

    # Information about a policy for duration-based session stickiness.
    #
    # @!attribute [rw] policy_name
    #   The name of the policy. This name must be unique within the set of
    #   policies for this load balancer.
    #   @return [String]
    #
    # @!attribute [rw] cookie_expiration_period
    #   The time period, in seconds, after which the cookie should be
    #   considered stale. If this parameter is not specified, the stickiness
    #   session lasts for the duration of the browser session.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/LBCookieStickinessPolicy AWS API Documentation
    #
    class LBCookieStickinessPolicy < Struct.new(
      :policy_name,
      :cookie_expiration_period)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about an Elastic Load Balancing resource limit for your
    # AWS account.
    #
    # @!attribute [rw] name
    #   The name of the limit. The possible values are:
    #
    #   * classic-listeners
    #
    #   * classic-load-balancers
    #
    #   * classic-registered-instances
    #   @return [String]
    #
    # @!attribute [rw] max
    #   The maximum value of the limit.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/Limit AWS API Documentation
    #
    class Limit < Struct.new(
      :name,
      :max)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about a listener.
    #
    # For information about the protocols and the ports supported by Elastic
    # Load Balancing, see [Listeners for Your Classic Load Balancer][1] in
    # the *Classic Load Balancers Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html
    #
    # @!attribute [rw] protocol
    #   The load balancer transport protocol to use for routing: HTTP,
    #   HTTPS, TCP, or SSL.
    #   @return [String]
    #
    # @!attribute [rw] load_balancer_port
    #   The port on which the load balancer is listening. On EC2-VPC, you
    #   can specify any port from the range 1-65535. On EC2-Classic, you can
    #   specify any port from the following list: 25, 80, 443, 465, 587,
    #   1024-65535.
    #   @return [Integer]
    #
    # @!attribute [rw] instance_protocol
    #   The protocol to use for routing traffic to instances: HTTP, HTTPS,
    #   TCP, or SSL.
    #
    #   If the front-end protocol is TCP or SSL, the back-end protocol must
    #   be TCP or SSL. If the front-end protocol is HTTP or HTTPS, the
    #   back-end protocol must be HTTP or HTTPS.
    #
    #   If there is another listener with the same `InstancePort` whose
    #   `InstanceProtocol` is secure, (HTTPS or SSL), the listener's
    #   `InstanceProtocol` must also be secure.
    #
    #   If there is another listener with the same `InstancePort` whose
    #   `InstanceProtocol` is HTTP or TCP, the listener's
    #   `InstanceProtocol` must be HTTP or TCP.
    #   @return [String]
    #
    # @!attribute [rw] instance_port
    #   The port on which the instance is listening.
    #   @return [Integer]
    #
    # @!attribute [rw] ssl_certificate_id
    #   The Amazon Resource Name (ARN) of the server certificate.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/Listener AWS API Documentation
    #
    class Listener < Struct.new(
      :protocol,
      :load_balancer_port,
      :instance_protocol,
      :instance_port,
      :ssl_certificate_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # The policies enabled for a listener.
    #
    # @!attribute [rw] listener
    #   The listener.
    #   @return [Types::Listener]
    #
    # @!attribute [rw] policy_names
    #   The policies. If there are no policies enabled, the list is empty.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/ListenerDescription AWS API Documentation
    #
    class ListenerDescription < Struct.new(
      :listener,
      :policy_names)
      SENSITIVE = []
      include Aws::Structure
    end

    # The load balancer does not have a listener configured at the specified
    # port.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/ListenerNotFoundException AWS API Documentation
    #
    class ListenerNotFoundException < Aws::EmptyStructure; end

    # The specified load balancer attribute does not exist.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/LoadBalancerAttributeNotFoundException AWS API Documentation
    #
    class LoadBalancerAttributeNotFoundException < Aws::EmptyStructure; end

    # The attributes for a load balancer.
    #
    # @!attribute [rw] cross_zone_load_balancing
    #   If enabled, the load balancer routes the request traffic evenly
    #   across all instances regardless of the Availability Zones.
    #
    #   For more information, see [Configure Cross-Zone Load Balancing][1]
    #   in the *Classic Load Balancers Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html
    #   @return [Types::CrossZoneLoadBalancing]
    #
    # @!attribute [rw] access_log
    #   If enabled, the load balancer captures detailed information of all
    #   requests and delivers the information to the Amazon S3 bucket that
    #   you specify.
    #
    #   For more information, see [Enable Access Logs][1] in the *Classic
    #   Load Balancers Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-access-logs.html
    #   @return [Types::AccessLog]
    #
    # @!attribute [rw] connection_draining
    #   If enabled, the load balancer allows existing requests to complete
    #   before the load balancer shifts traffic away from a deregistered or
    #   unhealthy instance.
    #
    #   For more information, see [Configure Connection Draining][1] in the
    #   *Classic Load Balancers Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html
    #   @return [Types::ConnectionDraining]
    #
    # @!attribute [rw] connection_settings
    #   If enabled, the load balancer allows the connections to remain idle
    #   (no data is sent over the connection) for the specified duration.
    #
    #   By default, Elastic Load Balancing maintains a 60-second idle
    #   connection timeout for both front-end and back-end connections of
    #   your load balancer. For more information, see [Configure Idle
    #   Connection Timeout][1] in the *Classic Load Balancers Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html
    #   @return [Types::ConnectionSettings]
    #
    # @!attribute [rw] additional_attributes
    #   Any additional attributes.
    #   @return [Array<Types::AdditionalAttribute>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/LoadBalancerAttributes AWS API Documentation
    #
    class LoadBalancerAttributes < Struct.new(
      :cross_zone_load_balancing,
      :access_log,
      :connection_draining,
      :connection_settings,
      :additional_attributes)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about a load balancer.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] dns_name
    #   The DNS name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] canonical_hosted_zone_name
    #   The DNS name of the load balancer.
    #
    #   For more information, see [Configure a Custom Domain Name][1] in the
    #   *Classic Load Balancers Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/using-domain-names-with-elb.html
    #   @return [String]
    #
    # @!attribute [rw] canonical_hosted_zone_name_id
    #   The ID of the Amazon Route 53 hosted zone for the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] listener_descriptions
    #   The listeners for the load balancer.
    #   @return [Array<Types::ListenerDescription>]
    #
    # @!attribute [rw] policies
    #   The policies defined for the load balancer.
    #   @return [Types::Policies]
    #
    # @!attribute [rw] backend_server_descriptions
    #   Information about your EC2 instances.
    #   @return [Array<Types::BackendServerDescription>]
    #
    # @!attribute [rw] availability_zones
    #   The Availability Zones for the load balancer.
    #   @return [Array<String>]
    #
    # @!attribute [rw] subnets
    #   The IDs of the subnets for the load balancer.
    #   @return [Array<String>]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC for the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] instances
    #   The IDs of the instances for the load balancer.
    #   @return [Array<Types::Instance>]
    #
    # @!attribute [rw] health_check
    #   Information about the health checks conducted on the load balancer.
    #   @return [Types::HealthCheck]
    #
    # @!attribute [rw] source_security_group
    #   The security group for the load balancer, which you can use as part
    #   of your inbound rules for your registered instances. To only allow
    #   traffic from load balancers, add a security group rule that
    #   specifies this source security group as the inbound source.
    #   @return [Types::SourceSecurityGroup]
    #
    # @!attribute [rw] security_groups
    #   The security groups for the load balancer. Valid only for load
    #   balancers in a VPC.
    #   @return [Array<String>]
    #
    # @!attribute [rw] created_time
    #   The date and time the load balancer was created.
    #   @return [Time]
    #
    # @!attribute [rw] scheme
    #   The type of load balancer. Valid only for load balancers in a VPC.
    #
    #   If `Scheme` is `internet-facing`, the load balancer has a public DNS
    #   name that resolves to a public IP address.
    #
    #   If `Scheme` is `internal`, the load balancer has a public DNS name
    #   that resolves to a private IP address.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/LoadBalancerDescription AWS API Documentation
    #
    class LoadBalancerDescription < Struct.new(
      :load_balancer_name,
      :dns_name,
      :canonical_hosted_zone_name,
      :canonical_hosted_zone_name_id,
      :listener_descriptions,
      :policies,
      :backend_server_descriptions,
      :availability_zones,
      :subnets,
      :vpc_id,
      :instances,
      :health_check,
      :source_security_group,
      :security_groups,
      :created_time,
      :scheme)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for ModifyLoadBalancerAttributes.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] load_balancer_attributes
    #   The attributes for the load balancer.
    #   @return [Types::LoadBalancerAttributes]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/ModifyLoadBalancerAttributesInput AWS API Documentation
    #
    class ModifyLoadBalancerAttributesInput < Struct.new(
      :load_balancer_name,
      :load_balancer_attributes)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of ModifyLoadBalancerAttributes.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] load_balancer_attributes
    #   Information about the load balancer attributes.
    #   @return [Types::LoadBalancerAttributes]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/ModifyLoadBalancerAttributesOutput AWS API Documentation
    #
    class ModifyLoadBalancerAttributesOutput < Struct.new(
      :load_balancer_name,
      :load_balancer_attributes)
      SENSITIVE = []
      include Aws::Structure
    end

    # This operation is not allowed.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/OperationNotPermittedException AWS API Documentation
    #
    class OperationNotPermittedException < Aws::EmptyStructure; end

    # The policies for a load balancer.
    #
    # @!attribute [rw] app_cookie_stickiness_policies
    #   The stickiness policies created using
    #   CreateAppCookieStickinessPolicy.
    #   @return [Array<Types::AppCookieStickinessPolicy>]
    #
    # @!attribute [rw] lb_cookie_stickiness_policies
    #   The stickiness policies created using
    #   CreateLBCookieStickinessPolicy.
    #   @return [Array<Types::LBCookieStickinessPolicy>]
    #
    # @!attribute [rw] other_policies
    #   The policies other than the stickiness policies.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/Policies AWS API Documentation
    #
    class Policies < Struct.new(
      :app_cookie_stickiness_policies,
      :lb_cookie_stickiness_policies,
      :other_policies)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about a policy attribute.
    #
    # @!attribute [rw] attribute_name
    #   The name of the attribute.
    #   @return [String]
    #
    # @!attribute [rw] attribute_value
    #   The value of the attribute.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/PolicyAttribute AWS API Documentation
    #
    class PolicyAttribute < Struct.new(
      :attribute_name,
      :attribute_value)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about a policy attribute.
    #
    # @!attribute [rw] attribute_name
    #   The name of the attribute.
    #   @return [String]
    #
    # @!attribute [rw] attribute_value
    #   The value of the attribute.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/PolicyAttributeDescription AWS API Documentation
    #
    class PolicyAttributeDescription < Struct.new(
      :attribute_name,
      :attribute_value)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about a policy attribute type.
    #
    # @!attribute [rw] attribute_name
    #   The name of the attribute.
    #   @return [String]
    #
    # @!attribute [rw] attribute_type
    #   The type of the attribute. For example, `Boolean` or `Integer`.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A description of the attribute.
    #   @return [String]
    #
    # @!attribute [rw] default_value
    #   The default value of the attribute, if applicable.
    #   @return [String]
    #
    # @!attribute [rw] cardinality
    #   The cardinality of the attribute.
    #
    #   Valid values:
    #
    #   * ONE(1) : Single value required
    #
    #   * ZERO\_OR\_ONE(0..1) : Up to one value is allowed
    #
    #   * ZERO\_OR\_MORE(0..*) : Optional. Multiple values are allowed
    #
    #   * ONE\_OR\_MORE(1..*0) : Required. Multiple values are allowed
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/PolicyAttributeTypeDescription AWS API Documentation
    #
    class PolicyAttributeTypeDescription < Struct.new(
      :attribute_name,
      :attribute_type,
      :description,
      :default_value,
      :cardinality)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about a policy.
    #
    # @!attribute [rw] policy_name
    #   The name of the policy.
    #   @return [String]
    #
    # @!attribute [rw] policy_type_name
    #   The name of the policy type.
    #   @return [String]
    #
    # @!attribute [rw] policy_attribute_descriptions
    #   The policy attributes.
    #   @return [Array<Types::PolicyAttributeDescription>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/PolicyDescription AWS API Documentation
    #
    class PolicyDescription < Struct.new(
      :policy_name,
      :policy_type_name,
      :policy_attribute_descriptions)
      SENSITIVE = []
      include Aws::Structure
    end

    # One or more of the specified policies do not exist.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/PolicyNotFoundException AWS API Documentation
    #
    class PolicyNotFoundException < Aws::EmptyStructure; end

    # Information about a policy type.
    #
    # @!attribute [rw] policy_type_name
    #   The name of the policy type.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A description of the policy type.
    #   @return [String]
    #
    # @!attribute [rw] policy_attribute_type_descriptions
    #   The description of the policy attributes associated with the
    #   policies defined by Elastic Load Balancing.
    #   @return [Array<Types::PolicyAttributeTypeDescription>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/PolicyTypeDescription AWS API Documentation
    #
    class PolicyTypeDescription < Struct.new(
      :policy_type_name,
      :description,
      :policy_attribute_type_descriptions)
      SENSITIVE = []
      include Aws::Structure
    end

    # One or more of the specified policy types do not exist.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/PolicyTypeNotFoundException AWS API Documentation
    #
    class PolicyTypeNotFoundException < Aws::EmptyStructure; end

    # Contains the parameters for RegisterInstancesWithLoadBalancer.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] instances
    #   The IDs of the instances.
    #   @return [Array<Types::Instance>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/RegisterEndPointsInput AWS API Documentation
    #
    class RegisterEndPointsInput < Struct.new(
      :load_balancer_name,
      :instances)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of RegisterInstancesWithLoadBalancer.
    #
    # @!attribute [rw] instances
    #   The updated list of instances for the load balancer.
    #   @return [Array<Types::Instance>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/RegisterEndPointsOutput AWS API Documentation
    #
    class RegisterEndPointsOutput < Struct.new(
      :instances)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DisableAvailabilityZonesForLoadBalancer.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] availability_zones
    #   The Availability Zones.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/RemoveAvailabilityZonesInput AWS API Documentation
    #
    class RemoveAvailabilityZonesInput < Struct.new(
      :load_balancer_name,
      :availability_zones)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output for DisableAvailabilityZonesForLoadBalancer.
    #
    # @!attribute [rw] availability_zones
    #   The remaining Availability Zones for the load balancer.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/RemoveAvailabilityZonesOutput AWS API Documentation
    #
    class RemoveAvailabilityZonesOutput < Struct.new(
      :availability_zones)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for RemoveTags.
    #
    # @!attribute [rw] load_balancer_names
    #   The name of the load balancer. You can specify a maximum of one load
    #   balancer name.
    #   @return [Array<String>]
    #
    # @!attribute [rw] tags
    #   The list of tag keys to remove.
    #   @return [Array<Types::TagKeyOnly>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/RemoveTagsInput AWS API Documentation
    #
    class RemoveTagsInput < Struct.new(
      :load_balancer_names,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of RemoveTags.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/RemoveTagsOutput AWS API Documentation
    #
    class RemoveTagsOutput < Aws::EmptyStructure; end

    # Contains the parameters for SetLoadBalancerListenerSSLCertificate.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] load_balancer_port
    #   The port that uses the specified SSL certificate.
    #   @return [Integer]
    #
    # @!attribute [rw] ssl_certificate_id
    #   The Amazon Resource Name (ARN) of the SSL certificate.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/SetLoadBalancerListenerSSLCertificateInput AWS API Documentation
    #
    class SetLoadBalancerListenerSSLCertificateInput < Struct.new(
      :load_balancer_name,
      :load_balancer_port,
      :ssl_certificate_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of SetLoadBalancerListenerSSLCertificate.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/SetLoadBalancerListenerSSLCertificateOutput AWS API Documentation
    #
    class SetLoadBalancerListenerSSLCertificateOutput < Aws::EmptyStructure; end

    # Contains the parameters for SetLoadBalancerPoliciesForBackendServer.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] instance_port
    #   The port number associated with the EC2 instance.
    #   @return [Integer]
    #
    # @!attribute [rw] policy_names
    #   The names of the policies. If the list is empty, then all current
    #   polices are removed from the EC2 instance.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/SetLoadBalancerPoliciesForBackendServerInput AWS API Documentation
    #
    class SetLoadBalancerPoliciesForBackendServerInput < Struct.new(
      :load_balancer_name,
      :instance_port,
      :policy_names)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of SetLoadBalancerPoliciesForBackendServer.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/SetLoadBalancerPoliciesForBackendServerOutput AWS API Documentation
    #
    class SetLoadBalancerPoliciesForBackendServerOutput < Aws::EmptyStructure; end

    # Contains the parameters for SetLoadBalancePoliciesOfListener.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] load_balancer_port
    #   The external port of the load balancer.
    #   @return [Integer]
    #
    # @!attribute [rw] policy_names
    #   The names of the policies. This list must include all policies to be
    #   enabled. If you omit a policy that is currently enabled, it is
    #   disabled. If the list is empty, all current policies are disabled.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/SetLoadBalancerPoliciesOfListenerInput AWS API Documentation
    #
    class SetLoadBalancerPoliciesOfListenerInput < Struct.new(
      :load_balancer_name,
      :load_balancer_port,
      :policy_names)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of SetLoadBalancePoliciesOfListener.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/SetLoadBalancerPoliciesOfListenerOutput AWS API Documentation
    #
    class SetLoadBalancerPoliciesOfListenerOutput < Aws::EmptyStructure; end

    # Information about a source security group.
    #
    # @!attribute [rw] owner_alias
    #   The owner of the security group.
    #   @return [String]
    #
    # @!attribute [rw] group_name
    #   The name of the security group.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/SourceSecurityGroup AWS API Documentation
    #
    class SourceSecurityGroup < Struct.new(
      :owner_alias,
      :group_name)
      SENSITIVE = []
      include Aws::Structure
    end

    # One or more of the specified subnets do not exist.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/SubnetNotFoundException AWS API Documentation
    #
    class SubnetNotFoundException < Aws::EmptyStructure; end

    # Information about a tag.
    #
    # @!attribute [rw] key
    #   The key of the tag.
    #   @return [String]
    #
    # @!attribute [rw] value
    #   The value of the tag.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/Tag AWS API Documentation
    #
    class Tag < Struct.new(
      :key,
      :value)
      SENSITIVE = []
      include Aws::Structure
    end

    # The tags associated with a load balancer.
    #
    # @!attribute [rw] load_balancer_name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   The tags.
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/TagDescription AWS API Documentation
    #
    class TagDescription < Struct.new(
      :load_balancer_name,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # The key of a tag.
    #
    # @!attribute [rw] key
    #   The name of the key.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/TagKeyOnly AWS API Documentation
    #
    class TagKeyOnly < Struct.new(
      :key)
      SENSITIVE = []
      include Aws::Structure
    end

    # The quota for the number of load balancers has been reached.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/TooManyAccessPointsException AWS API Documentation
    #
    class TooManyAccessPointsException < Aws::EmptyStructure; end

    # The quota for the number of policies for this load balancer has been
    # reached.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/TooManyPoliciesException AWS API Documentation
    #
    class TooManyPoliciesException < Aws::EmptyStructure; end

    # The quota for the number of tags that can be assigned to a load
    # balancer has been reached.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/TooManyTagsException AWS API Documentation
    #
    class TooManyTagsException < Aws::EmptyStructure; end

    # The specified protocol or signature version is not supported.
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/UnsupportedProtocolException AWS API Documentation
    #
    class UnsupportedProtocolException < Aws::EmptyStructure; end

  end
end

