# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2020_06_01
  #
  # A service client - single point of access to the REST API.
  #
  class ComputeManagementClient < MsRestAzure::AzureServiceClient
    include MsRestAzure
    include MsRestAzure::Serialization

    # @return [String] the base URI of the service.
    attr_accessor :base_url

    # @return Credentials needed for the client to connect to Azure.
    attr_reader :credentials

    # @return [String] Subscription credentials which uniquely identify
    # Microsoft Azure subscription. The subscription ID forms part of the URI
    # for every service call.
    attr_accessor :subscription_id

    # @return [String] Client Api Version.
    attr_reader :api_version

    # @return [String] The preferred language for the response.
    attr_accessor :accept_language

    # @return [Integer] The retry timeout in seconds for Long Running
    # Operations. Default value is 30.
    attr_accessor :long_running_operation_retry_timeout

    # @return [Boolean] Whether a unique x-ms-client-request-id should be
    # generated. When set to true a unique x-ms-client-request-id value is
    # generated and included in each request. Default is true.
    attr_accessor :generate_client_request_id

    # @return [Operations] operations
    attr_reader :operations

    # @return [AvailabilitySets] availability_sets
    attr_reader :availability_sets

    # @return [ProximityPlacementGroups] proximity_placement_groups
    attr_reader :proximity_placement_groups

    # @return [DedicatedHostGroups] dedicated_host_groups
    attr_reader :dedicated_host_groups

    # @return [DedicatedHosts] dedicated_hosts
    attr_reader :dedicated_hosts

    # @return [SshPublicKeys] ssh_public_keys
    attr_reader :ssh_public_keys

    # @return [VirtualMachineExtensionImages] virtual_machine_extension_images
    attr_reader :virtual_machine_extension_images

    # @return [VirtualMachineExtensions] virtual_machine_extensions
    attr_reader :virtual_machine_extensions

    # @return [VirtualMachineImages] virtual_machine_images
    attr_reader :virtual_machine_images

    # @return [UsageOperations] usage_operations
    attr_reader :usage_operations

    # @return [VirtualMachines] virtual_machines
    attr_reader :virtual_machines

    # @return [VirtualMachineSizes] virtual_machine_sizes
    attr_reader :virtual_machine_sizes

    # @return [Images] images
    attr_reader :images

    # @return [VirtualMachineScaleSets] virtual_machine_scale_sets
    attr_reader :virtual_machine_scale_sets

    # @return [VirtualMachineScaleSetExtensions]
    # virtual_machine_scale_set_extensions
    attr_reader :virtual_machine_scale_set_extensions

    # @return [VirtualMachineScaleSetRollingUpgrades]
    # virtual_machine_scale_set_rolling_upgrades
    attr_reader :virtual_machine_scale_set_rolling_upgrades

    # @return [VirtualMachineScaleSetVMExtensions]
    # virtual_machine_scale_set_vmextensions
    attr_reader :virtual_machine_scale_set_vmextensions

    # @return [VirtualMachineScaleSetVMs] virtual_machine_scale_set_vms
    attr_reader :virtual_machine_scale_set_vms

    # @return [LogAnalytics] log_analytics
    attr_reader :log_analytics

    # @return [VirtualMachineRunCommands] virtual_machine_run_commands
    attr_reader :virtual_machine_run_commands

    # @return [VirtualMachineScaleSetVMRunCommands]
    # virtual_machine_scale_set_vmrun_commands
    attr_reader :virtual_machine_scale_set_vmrun_commands

    #
    # Creates initializes a new instance of the ComputeManagementClient class.
    # @param credentials [MsRest::ServiceClientCredentials] credentials to authorize HTTP requests made by the service client.
    # @param base_url [String] the base URI of the service.
    # @param options [Array] filters to be applied to the HTTP requests.
    #
    def initialize(credentials = nil, base_url = nil, options = nil)
      super(credentials, options)
      @base_url = base_url || 'https://management.azure.com'

      fail ArgumentError, 'invalid type of credentials input parameter' unless credentials.is_a?(MsRest::ServiceClientCredentials) unless credentials.nil?
      @credentials = credentials

      @operations = Operations.new(self)
      @availability_sets = AvailabilitySets.new(self)
      @proximity_placement_groups = ProximityPlacementGroups.new(self)
      @dedicated_host_groups = DedicatedHostGroups.new(self)
      @dedicated_hosts = DedicatedHosts.new(self)
      @ssh_public_keys = SshPublicKeys.new(self)
      @virtual_machine_extension_images = VirtualMachineExtensionImages.new(self)
      @virtual_machine_extensions = VirtualMachineExtensions.new(self)
      @virtual_machine_images = VirtualMachineImages.new(self)
      @usage_operations = UsageOperations.new(self)
      @virtual_machines = VirtualMachines.new(self)
      @virtual_machine_sizes = VirtualMachineSizes.new(self)
      @images = Images.new(self)
      @virtual_machine_scale_sets = VirtualMachineScaleSets.new(self)
      @virtual_machine_scale_set_extensions = VirtualMachineScaleSetExtensions.new(self)
      @virtual_machine_scale_set_rolling_upgrades = VirtualMachineScaleSetRollingUpgrades.new(self)
      @virtual_machine_scale_set_vmextensions = VirtualMachineScaleSetVMExtensions.new(self)
      @virtual_machine_scale_set_vms = VirtualMachineScaleSetVMs.new(self)
      @log_analytics = LogAnalytics.new(self)
      @virtual_machine_run_commands = VirtualMachineRunCommands.new(self)
      @virtual_machine_scale_set_vmrun_commands = VirtualMachineScaleSetVMRunCommands.new(self)
      @api_version = '2020-06-01'
      @accept_language = 'en-US'
      @long_running_operation_retry_timeout = 30
      @generate_client_request_id = true
      add_telemetry
    end

    #
    # Makes a request and returns the body of the response.
    # @param method [Symbol] with any of the following values :get, :put, :post, :patch, :delete.
    # @param path [String] the path, relative to {base_url}.
    # @param options [Hash{String=>String}] specifying any request options like :body.
    # @return [Hash{String=>String}] containing the body of the response.
    # Example:
    #
    #  request_content = "{'location':'westus','tags':{'tag1':'val1','tag2':'val2'}}"
    #  path = "/path"
    #  options = {
    #    body: request_content,
    #    query_params: {'api-version' => '2016-02-01'}
    #  }
    #  result = @client.make_request(:put, path, options)
    #
    def make_request(method, path, options = {})
      result = make_request_with_http_info(method, path, options)
      result.body unless result.nil?
    end

    #
    # Makes a request and returns the operation response.
    # @param method [Symbol] with any of the following values :get, :put, :post, :patch, :delete.
    # @param path [String] the path, relative to {base_url}.
    # @param options [Hash{String=>String}] specifying any request options like :body.
    # @return [MsRestAzure::AzureOperationResponse] Operation response containing the request, response and status.
    #
    def make_request_with_http_info(method, path, options = {})
      result = make_request_async(method, path, options).value!
      result.body = result.response.body.to_s.empty? ? nil : JSON.load(result.response.body)
      result
    end

    #
    # Makes a request asynchronously.
    # @param method [Symbol] with any of the following values :get, :put, :post, :patch, :delete.
    # @param path [String] the path, relative to {base_url}.
    # @param options [Hash{String=>String}] specifying any request options like :body.
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def make_request_async(method, path, options = {})
      fail ArgumentError, 'method is nil' if method.nil?
      fail ArgumentError, 'path is nil' if path.nil?

      request_url = options[:base_url] || @base_url
      if(!options[:headers].nil? && !options[:headers]['Content-Type'].nil?)
        @request_headers['Content-Type'] = options[:headers]['Content-Type']
      end

      request_headers = @request_headers
      request_headers.merge!({'accept-language' => @accept_language}) unless @accept_language.nil?
      options.merge!({headers: request_headers.merge(options[:headers] || {})})
      options.merge!({credentials: @credentials}) unless @credentials.nil?

      super(request_url, method, path, options)
    end


    private
    #
    # Adds telemetry information.
    #
    def add_telemetry
        sdk_information = 'azure_mgmt_compute'
        sdk_information = "#{sdk_information}/0.22.0"
        add_user_agent_information(sdk_information)
    end
  end
end
