# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2020_06_01
  module Models
    #
    # Describes a virtual machine scale set data disk.
    #
    class VirtualMachineScaleSetDataDisk

      include MsRestAzure

      # @return [String] The disk name.
      attr_accessor :name

      # @return [Integer] Specifies the logical unit number of the data disk.
      # This value is used to identify data disks within the VM and therefore
      # must be unique for each data disk attached to a VM.
      attr_accessor :lun

      # @return [CachingTypes] Specifies the caching requirements. <br><br>
      # Possible values are: <br><br> **None** <br><br> **ReadOnly** <br><br>
      # **ReadWrite** <br><br> Default: **None for Standard storage. ReadOnly
      # for Premium storage**. Possible values include: 'None', 'ReadOnly',
      # 'ReadWrite'
      attr_accessor :caching

      # @return [Boolean] Specifies whether writeAccelerator should be enabled
      # or disabled on the disk.
      attr_accessor :write_accelerator_enabled

      # @return [DiskCreateOptionTypes] The create option. Possible values
      # include: 'FromImage', 'Empty', 'Attach'
      attr_accessor :create_option

      # @return [Integer] Specifies the size of an empty data disk in
      # gigabytes. This element can be used to overwrite the size of the disk
      # in a virtual machine image. <br><br> This value cannot be larger than
      # 1023 GB
      attr_accessor :disk_size_gb

      # @return [VirtualMachineScaleSetManagedDiskParameters] The managed disk
      # parameters.
      attr_accessor :managed_disk

      # @return [Integer] Specifies the Read-Write IOPS for the managed disk.
      # Should be used only when StorageAccountType is UltraSSD_LRS. If not
      # specified, a default value would be assigned based on diskSizeGB.
      attr_accessor :disk_iopsread_write

      # @return [Integer] Specifies the bandwidth in MB per second for the
      # managed disk. Should be used only when StorageAccountType is
      # UltraSSD_LRS. If not specified, a default value would be assigned based
      # on diskSizeGB.
      attr_accessor :disk_mbps_read_write


      #
      # Mapper for VirtualMachineScaleSetDataDisk class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'VirtualMachineScaleSetDataDisk',
          type: {
            name: 'Composite',
            class_name: 'VirtualMachineScaleSetDataDisk',
            model_properties: {
              name: {
                client_side_validation: true,
                required: false,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              lun: {
                client_side_validation: true,
                required: true,
                serialized_name: 'lun',
                type: {
                  name: 'Number'
                }
              },
              caching: {
                client_side_validation: true,
                required: false,
                serialized_name: 'caching',
                type: {
                  name: 'Enum',
                  module: 'CachingTypes'
                }
              },
              write_accelerator_enabled: {
                client_side_validation: true,
                required: false,
                serialized_name: 'writeAcceleratorEnabled',
                type: {
                  name: 'Boolean'
                }
              },
              create_option: {
                client_side_validation: true,
                required: true,
                serialized_name: 'createOption',
                type: {
                  name: 'String'
                }
              },
              disk_size_gb: {
                client_side_validation: true,
                required: false,
                serialized_name: 'diskSizeGB',
                type: {
                  name: 'Number'
                }
              },
              managed_disk: {
                client_side_validation: true,
                required: false,
                serialized_name: 'managedDisk',
                type: {
                  name: 'Composite',
                  class_name: 'VirtualMachineScaleSetManagedDiskParameters'
                }
              },
              disk_iopsread_write: {
                client_side_validation: true,
                required: false,
                serialized_name: 'diskIOPSReadWrite',
                type: {
                  name: 'Number'
                }
              },
              disk_mbps_read_write: {
                client_side_validation: true,
                required: false,
                serialized_name: 'diskMBpsReadWrite',
                type: {
                  name: 'Number'
                }
              }
            }
          }
        }
      end
    end
  end
end
