# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2020_06_30
  module Models
    #
    # Disk resource.
    #
    class Disk < Resource

      include MsRestAzure

      # @return [String] A relative URI containing the ID of the VM that has
      # the disk attached.
      attr_accessor :managed_by

      # @return [Array<String>] List of relative URIs containing the IDs of the
      # VMs that have the disk attached. maxShares should be set to a value
      # greater than one for disks to allow attaching them to multiple VMs.
      attr_accessor :managed_by_extended

      # @return [DiskSku]
      attr_accessor :sku

      # @return [Array<String>] The Logical zone list for Disk.
      attr_accessor :zones

      # @return [DateTime] The time when the disk was created.
      attr_accessor :time_created

      # @return [OperatingSystemTypes] The Operating System type. Possible
      # values include: 'Windows', 'Linux'
      attr_accessor :os_type

      # @return [HyperVGeneration] The hypervisor generation of the Virtual
      # Machine. Applicable to OS disks only. Possible values include: 'V1',
      # 'V2'
      attr_accessor :hyper_vgeneration

      # @return [CreationData] Disk source information. CreationData
      # information cannot be changed after the disk has been created.
      attr_accessor :creation_data

      # @return [Integer] If creationData.createOption is Empty, this field is
      # mandatory and it indicates the size of the disk to create. If this
      # field is present for updates or creation with other options, it
      # indicates a resize. Resizes are only allowed if the disk is not
      # attached to a running VM, and can only increase the disk's size.
      attr_accessor :disk_size_gb

      # @return [Integer] The size of the disk in bytes. This field is read
      # only.
      attr_accessor :disk_size_bytes

      # @return [String] Unique Guid identifying the resource.
      attr_accessor :unique_id

      # @return [EncryptionSettingsCollection] Encryption settings collection
      # used for Azure Disk Encryption, can contain multiple encryption
      # settings per disk or snapshot.
      attr_accessor :encryption_settings_collection

      # @return [String] The disk provisioning state.
      attr_accessor :provisioning_state

      # @return [Integer] The number of IOPS allowed for this disk; only
      # settable for UltraSSD disks. One operation can transfer between 4k and
      # 256k bytes.
      attr_accessor :disk_iopsread_write

      # @return [Integer] The bandwidth allowed for this disk; only settable
      # for UltraSSD disks. MBps means millions of bytes per second - MB here
      # uses the ISO notation, of powers of 10.
      attr_accessor :disk_mbps_read_write

      # @return [Integer] The total number of IOPS that will be allowed across
      # all VMs mounting the shared disk as ReadOnly. One operation can
      # transfer between 4k and 256k bytes.
      attr_accessor :disk_iopsread_only

      # @return [Integer] The total throughput (MBps) that will be allowed
      # across all VMs mounting the shared disk as ReadOnly. MBps means
      # millions of bytes per second - MB here uses the ISO notation, of powers
      # of 10.
      attr_accessor :disk_mbps_read_only

      # @return [DiskState] The state of the disk. Possible values include:
      # 'Unattached', 'Attached', 'Reserved', 'ActiveSAS', 'ReadyToUpload',
      # 'ActiveUpload'
      attr_accessor :disk_state

      # @return [Encryption] Encryption property can be used to encrypt data at
      # rest with customer managed keys or platform managed keys.
      attr_accessor :encryption

      # @return [Integer] The maximum number of VMs that can attach to the disk
      # at the same time. Value greater than one indicates a disk that can be
      # mounted on multiple VMs at the same time.
      attr_accessor :max_shares

      # @return [Array<ShareInfoElement>] Details of the list of all VMs that
      # have the disk attached. maxShares should be set to a value greater than
      # one for disks to allow attaching them to multiple VMs.
      attr_accessor :share_info

      # @return [NetworkAccessPolicy] Possible values include: 'AllowAll',
      # 'AllowPrivate', 'DenyAll'
      attr_accessor :network_access_policy

      # @return [String] ARM id of the DiskAccess resource for using private
      # endpoints on disks.
      attr_accessor :disk_access_id

      # @return [String] Performance tier of the disk (e.g, P4, S10) as
      # described here:
      # https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does
      # not apply to Ultra disks.
      attr_accessor :tier


      #
      # Mapper for Disk class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'Disk',
          type: {
            name: 'Composite',
            class_name: 'Disk',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              location: {
                client_side_validation: true,
                required: true,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              tags: {
                client_side_validation: true,
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              managed_by: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'managedBy',
                type: {
                  name: 'String'
                }
              },
              managed_by_extended: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'managedByExtended',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              sku: {
                client_side_validation: true,
                required: false,
                serialized_name: 'sku',
                type: {
                  name: 'Composite',
                  class_name: 'DiskSku'
                }
              },
              zones: {
                client_side_validation: true,
                required: false,
                serialized_name: 'zones',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              time_created: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.timeCreated',
                type: {
                  name: 'DateTime'
                }
              },
              os_type: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.osType',
                type: {
                  name: 'Enum',
                  module: 'OperatingSystemTypes'
                }
              },
              hyper_vgeneration: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.hyperVGeneration',
                type: {
                  name: 'String'
                }
              },
              creation_data: {
                client_side_validation: true,
                required: true,
                serialized_name: 'properties.creationData',
                type: {
                  name: 'Composite',
                  class_name: 'CreationData'
                }
              },
              disk_size_gb: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.diskSizeGB',
                type: {
                  name: 'Number'
                }
              },
              disk_size_bytes: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.diskSizeBytes',
                type: {
                  name: 'Number'
                }
              },
              unique_id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.uniqueId',
                type: {
                  name: 'String'
                }
              },
              encryption_settings_collection: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.encryptionSettingsCollection',
                type: {
                  name: 'Composite',
                  class_name: 'EncryptionSettingsCollection'
                }
              },
              provisioning_state: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.provisioningState',
                type: {
                  name: 'String'
                }
              },
              disk_iopsread_write: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.diskIOPSReadWrite',
                type: {
                  name: 'Number'
                }
              },
              disk_mbps_read_write: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.diskMBpsReadWrite',
                type: {
                  name: 'Number'
                }
              },
              disk_iopsread_only: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.diskIOPSReadOnly',
                type: {
                  name: 'Number'
                }
              },
              disk_mbps_read_only: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.diskMBpsReadOnly',
                type: {
                  name: 'Number'
                }
              },
              disk_state: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.diskState',
                type: {
                  name: 'String'
                }
              },
              encryption: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.encryption',
                type: {
                  name: 'Composite',
                  class_name: 'Encryption'
                }
              },
              max_shares: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.maxShares',
                type: {
                  name: 'Number'
                }
              },
              share_info: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.shareInfo',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'ShareInfoElementElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'ShareInfoElement'
                      }
                  }
                }
              },
              network_access_policy: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.networkAccessPolicy',
                type: {
                  name: 'String'
                }
              },
              disk_access_id: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.diskAccessId',
                type: {
                  name: 'String'
                }
              },
              tier: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.tier',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
