# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2020_09_30
  #
  # The Disk Resource Provider Client.
  #
  class DiskRestorePointOperations
    include MsRestAzure

    #
    # Creates and initializes a new instance of the DiskRestorePointOperations class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [ComputeManagementClient] reference to the ComputeManagementClient
    attr_reader :client

    #
    # Get disk restorePoint resource
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param restore_point_collection_name [String] The name of the restore point
    # collection that the disk restore point belongs. Supported characters for the
    # name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
    # @param vm_restore_point_name [String] The name of the vm restore point that
    # the disk disk restore point belongs. Supported characters for the name are
    # a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
    # @param disk_restore_point_name [String] The name of the disk restore point
    # created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
    # maximum name length is 80 characters.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DiskRestorePoint] operation results.
    #
    def get(resource_group_name, restore_point_collection_name, vm_restore_point_name, disk_restore_point_name, custom_headers:nil)
      response = get_async(resource_group_name, restore_point_collection_name, vm_restore_point_name, disk_restore_point_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get disk restorePoint resource
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param restore_point_collection_name [String] The name of the restore point
    # collection that the disk restore point belongs. Supported characters for the
    # name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
    # @param vm_restore_point_name [String] The name of the vm restore point that
    # the disk disk restore point belongs. Supported characters for the name are
    # a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
    # @param disk_restore_point_name [String] The name of the disk restore point
    # created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
    # maximum name length is 80 characters.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, restore_point_collection_name, vm_restore_point_name, disk_restore_point_name, custom_headers:nil)
      get_async(resource_group_name, restore_point_collection_name, vm_restore_point_name, disk_restore_point_name, custom_headers:custom_headers).value!
    end

    #
    # Get disk restorePoint resource
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param restore_point_collection_name [String] The name of the restore point
    # collection that the disk restore point belongs. Supported characters for the
    # name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
    # @param vm_restore_point_name [String] The name of the vm restore point that
    # the disk disk restore point belongs. Supported characters for the name are
    # a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
    # @param disk_restore_point_name [String] The name of the disk restore point
    # created. Supported characters for the name are a-z, A-Z, 0-9 and _. The
    # maximum name length is 80 characters.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, restore_point_collection_name, vm_restore_point_name, disk_restore_point_name, custom_headers:nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'restore_point_collection_name is nil' if restore_point_collection_name.nil?
      fail ArgumentError, 'vm_restore_point_name is nil' if vm_restore_point_name.nil?
      fail ArgumentError, 'disk_restore_point_name is nil' if disk_restore_point_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/restorePointCollections/{restorePointCollectionName}/restorePoints/{vmRestorePointName}/diskRestorePoints/{diskRestorePointName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'restorePointCollectionName' => restore_point_collection_name,'vmRestorePointName' => vm_restore_point_name,'diskRestorePointName' => disk_restore_point_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_09_30::Models::DiskRestorePoint.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists diskRestorePoints under a vmRestorePoint.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param restore_point_collection_name [String] The name of the restore point
    # collection that the disk restore point belongs. Supported characters for the
    # name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
    # @param vm_restore_point_name [String] The name of the vm restore point that
    # the disk disk restore point belongs. Supported characters for the name are
    # a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<DiskRestorePoint>] operation results.
    #
    def list_by_restore_point(resource_group_name, restore_point_collection_name, vm_restore_point_name, custom_headers:nil)
      first_page = list_by_restore_point_as_lazy(resource_group_name, restore_point_collection_name, vm_restore_point_name, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Lists diskRestorePoints under a vmRestorePoint.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param restore_point_collection_name [String] The name of the restore point
    # collection that the disk restore point belongs. Supported characters for the
    # name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
    # @param vm_restore_point_name [String] The name of the vm restore point that
    # the disk disk restore point belongs. Supported characters for the name are
    # a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_restore_point_with_http_info(resource_group_name, restore_point_collection_name, vm_restore_point_name, custom_headers:nil)
      list_by_restore_point_async(resource_group_name, restore_point_collection_name, vm_restore_point_name, custom_headers:custom_headers).value!
    end

    #
    # Lists diskRestorePoints under a vmRestorePoint.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param restore_point_collection_name [String] The name of the restore point
    # collection that the disk restore point belongs. Supported characters for the
    # name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
    # @param vm_restore_point_name [String] The name of the vm restore point that
    # the disk disk restore point belongs. Supported characters for the name are
    # a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_restore_point_async(resource_group_name, restore_point_collection_name, vm_restore_point_name, custom_headers:nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'restore_point_collection_name is nil' if restore_point_collection_name.nil?
      fail ArgumentError, 'vm_restore_point_name is nil' if vm_restore_point_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/restorePointCollections/{restorePointCollectionName}/restorePoints/{vmRestorePointName}/diskRestorePoints'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'restorePointCollectionName' => restore_point_collection_name,'vmRestorePointName' => vm_restore_point_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_09_30::Models::DiskRestorePointList.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists diskRestorePoints under a vmRestorePoint.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DiskRestorePointList] operation results.
    #
    def list_by_restore_point_next(next_page_link, custom_headers:nil)
      response = list_by_restore_point_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists diskRestorePoints under a vmRestorePoint.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_restore_point_next_with_http_info(next_page_link, custom_headers:nil)
      list_by_restore_point_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Lists diskRestorePoints under a vmRestorePoint.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_restore_point_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_09_30::Models::DiskRestorePointList.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists diskRestorePoints under a vmRestorePoint.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param restore_point_collection_name [String] The name of the restore point
    # collection that the disk restore point belongs. Supported characters for the
    # name are a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
    # @param vm_restore_point_name [String] The name of the vm restore point that
    # the disk disk restore point belongs. Supported characters for the name are
    # a-z, A-Z, 0-9 and _. The maximum name length is 80 characters.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DiskRestorePointList] which provide lazy access to pages of the
    # response.
    #
    def list_by_restore_point_as_lazy(resource_group_name, restore_point_collection_name, vm_restore_point_name, custom_headers:nil)
      response = list_by_restore_point_async(resource_group_name, restore_point_collection_name, vm_restore_point_name, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_restore_point_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

  end
end
