# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2020_12_01
  module Models
    #
    # Describes a virtual machine scale set virtual machine profile.
    #
    class VirtualMachineScaleSetVMProfile

      include MsRestAzure

      # @return [VirtualMachineScaleSetOSProfile] Specifies the operating
      # system settings for the virtual machines in the scale set.
      attr_accessor :os_profile

      # @return [VirtualMachineScaleSetStorageProfile] Specifies the storage
      # settings for the virtual machine disks.
      attr_accessor :storage_profile

      # @return [VirtualMachineScaleSetNetworkProfile] Specifies properties of
      # the network interfaces of the virtual machines in the scale set.
      attr_accessor :network_profile

      # @return [SecurityProfile] Specifies the Security related profile
      # settings for the virtual machines in the scale set.
      attr_accessor :security_profile

      # @return [DiagnosticsProfile] Specifies the boot diagnostic settings
      # state. <br><br>Minimum api-version: 2015-06-15.
      attr_accessor :diagnostics_profile

      # @return [VirtualMachineScaleSetExtensionProfile] Specifies a collection
      # of settings for extensions installed on virtual machines in the scale
      # set.
      attr_accessor :extension_profile

      # @return [String] Specifies that the image or disk that is being used
      # was licensed on-premises. <br><br> Possible values for Windows Server
      # operating system are: <br><br> Windows_Client <br><br> Windows_Server
      # <br><br> Possible values for Linux Server operating system are:
      # <br><br> RHEL_BYOS (for RHEL) <br><br> SLES_BYOS (for SUSE) <br><br>
      # For more information, see [Azure Hybrid Use Benefit for Windows
      # Server](https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing)
      # <br><br> [Azure Hybrid Use Benefit for Linux
      # Server](https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux)
      # <br><br> Minimum api-version: 2015-06-15
      attr_accessor :license_type

      # @return [VirtualMachinePriorityTypes] Specifies the priority for the
      # virtual machines in the scale set. <br><br>Minimum api-version:
      # 2017-10-30-preview. Possible values include: 'Regular', 'Low', 'Spot'
      attr_accessor :priority

      # @return [VirtualMachineEvictionPolicyTypes] Specifies the eviction
      # policy for the Azure Spot virtual machine and Azure Spot scale set.
      # <br><br>For Azure Spot virtual machines, both 'Deallocate' and 'Delete'
      # are supported and the minimum api-version is 2019-03-01. <br><br>For
      # Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported and
      # the minimum api-version is 2017-10-30-preview. Possible values include:
      # 'Deallocate', 'Delete'
      attr_accessor :eviction_policy

      # @return [BillingProfile] Specifies the billing related details of a
      # Azure Spot VMSS. <br><br>Minimum api-version: 2019-03-01.
      attr_accessor :billing_profile

      # @return [ScheduledEventsProfile] Specifies Scheduled Event related
      # configurations.
      attr_accessor :scheduled_events_profile


      #
      # Mapper for VirtualMachineScaleSetVMProfile class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'VirtualMachineScaleSetVMProfile',
          type: {
            name: 'Composite',
            class_name: 'VirtualMachineScaleSetVMProfile',
            model_properties: {
              os_profile: {
                client_side_validation: true,
                required: false,
                serialized_name: 'osProfile',
                type: {
                  name: 'Composite',
                  class_name: 'VirtualMachineScaleSetOSProfile'
                }
              },
              storage_profile: {
                client_side_validation: true,
                required: false,
                serialized_name: 'storageProfile',
                type: {
                  name: 'Composite',
                  class_name: 'VirtualMachineScaleSetStorageProfile'
                }
              },
              network_profile: {
                client_side_validation: true,
                required: false,
                serialized_name: 'networkProfile',
                type: {
                  name: 'Composite',
                  class_name: 'VirtualMachineScaleSetNetworkProfile'
                }
              },
              security_profile: {
                client_side_validation: true,
                required: false,
                serialized_name: 'securityProfile',
                type: {
                  name: 'Composite',
                  class_name: 'SecurityProfile'
                }
              },
              diagnostics_profile: {
                client_side_validation: true,
                required: false,
                serialized_name: 'diagnosticsProfile',
                type: {
                  name: 'Composite',
                  class_name: 'DiagnosticsProfile'
                }
              },
              extension_profile: {
                client_side_validation: true,
                required: false,
                serialized_name: 'extensionProfile',
                type: {
                  name: 'Composite',
                  class_name: 'VirtualMachineScaleSetExtensionProfile'
                }
              },
              license_type: {
                client_side_validation: true,
                required: false,
                serialized_name: 'licenseType',
                type: {
                  name: 'String'
                }
              },
              priority: {
                client_side_validation: true,
                required: false,
                serialized_name: 'priority',
                type: {
                  name: 'String'
                }
              },
              eviction_policy: {
                client_side_validation: true,
                required: false,
                serialized_name: 'evictionPolicy',
                type: {
                  name: 'String'
                }
              },
              billing_profile: {
                client_side_validation: true,
                required: false,
                serialized_name: 'billingProfile',
                type: {
                  name: 'Composite',
                  class_name: 'BillingProfile'
                }
              },
              scheduled_events_profile: {
                client_side_validation: true,
                required: false,
                serialized_name: 'scheduledEventsProfile',
                type: {
                  name: 'Composite',
                  class_name: 'ScheduledEventsProfile'
                }
              }
            }
          }
        }
      end
    end
  end
end
