# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2020_12_01
  #
  # Compute Client
  #
  class VirtualMachineScaleSets
    include MsRestAzure

    #
    # Creates and initializes a new instance of the VirtualMachineScaleSets class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [ComputeManagementClient] reference to the ComputeManagementClient
    attr_reader :client

    #
    # Gets all the VM scale sets under the specified subscription for the specified
    # location.
    #
    # @param location [String] The location for which VM scale sets under the
    # subscription are queried.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<VirtualMachineScaleSet>] operation results.
    #
    def list_by_location(location, custom_headers:nil)
      first_page = list_by_location_as_lazy(location, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Gets all the VM scale sets under the specified subscription for the specified
    # location.
    #
    # @param location [String] The location for which VM scale sets under the
    # subscription are queried.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_location_with_http_info(location, custom_headers:nil)
      list_by_location_async(location, custom_headers:custom_headers).value!
    end

    #
    # Gets all the VM scale sets under the specified subscription for the specified
    # location.
    #
    # @param location [String] The location for which VM scale sets under the
    # subscription are queried.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_location_async(location, custom_headers:nil)
      fail ArgumentError, 'location is nil' if location.nil?
      fail ArgumentError, "'location' should satisfy the constraint - 'Pattern': '^[-\w\._]+$'" if !location.nil? && location.match(Regexp.new('^^[-\w\._]+$$')).nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/virtualMachineScaleSets'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'location' => location,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create or update a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set to create or
    # update.
    # @param parameters [VirtualMachineScaleSet] The scale set object.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSet] operation results.
    #
    def create_or_update(resource_group_name, vm_scale_set_name, parameters, custom_headers:nil)
      response = create_or_update_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set to create or
    # update.
    # @param parameters [VirtualMachineScaleSet] The scale set object.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_create_or_update_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSet.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Update a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set to create or
    # update.
    # @param parameters [VirtualMachineScaleSetUpdate] The scale set object.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSet] operation results.
    #
    def update(resource_group_name, vm_scale_set_name, parameters, custom_headers:nil)
      response = update_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set to create or
    # update.
    # @param parameters [VirtualMachineScaleSetUpdate] The scale set object.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def update_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_update_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSet.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Deletes a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param force_deletion [Boolean] Optional parameter to force delete a VM scale
    # set. (Feature in Preview)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(resource_group_name, vm_scale_set_name, force_deletion:nil, custom_headers:nil)
      response = delete_async(resource_group_name, vm_scale_set_name, force_deletion:force_deletion, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param force_deletion [Boolean] Optional parameter to force delete a VM scale
    # set. (Feature in Preview)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, vm_scale_set_name, force_deletion:nil, custom_headers:nil)
      # Send request
      promise = begin_delete_async(resource_group_name, vm_scale_set_name, force_deletion:force_deletion, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Display information about a virtual machine scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSet] operation results.
    #
    def get(resource_group_name, vm_scale_set_name, custom_headers:nil)
      response = get_async(resource_group_name, vm_scale_set_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Display information about a virtual machine scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, vm_scale_set_name, custom_headers:nil)
      get_async(resource_group_name, vm_scale_set_name, custom_headers:custom_headers).value!
    end

    #
    # Display information about a virtual machine scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, vm_scale_set_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSet.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deallocates specific virtual machines in a VM scale set. Shuts down the
    # virtual machines and releases the compute resources. You are not billed for
    # the compute resources that this virtual machine scale set deallocates.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def deallocate(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      response = deallocate_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def deallocate_async(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      # Send request
      promise = begin_deallocate_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Deletes virtual machines in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceRequiredIDs] A list
    # of virtual machine instance IDs from the VM scale set.
    # @param force_deletion [Boolean] Optional parameter to force delete virtual
    # machines from the VM scale set. (Feature in Preview)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete_instances(resource_group_name, vm_scale_set_name, vm_instance_ids, force_deletion:nil, custom_headers:nil)
      response = delete_instances_async(resource_group_name, vm_scale_set_name, vm_instance_ids, force_deletion:force_deletion, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceRequiredIDs] A list
    # of virtual machine instance IDs from the VM scale set.
    # @param force_deletion [Boolean] Optional parameter to force delete virtual
    # machines from the VM scale set. (Feature in Preview)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_instances_async(resource_group_name, vm_scale_set_name, vm_instance_ids, force_deletion:nil, custom_headers:nil)
      # Send request
      promise = begin_delete_instances_async(resource_group_name, vm_scale_set_name, vm_instance_ids, force_deletion:force_deletion, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets the status of a VM scale set instance.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSetInstanceView] operation results.
    #
    def get_instance_view(resource_group_name, vm_scale_set_name, custom_headers:nil)
      response = get_instance_view_async(resource_group_name, vm_scale_set_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the status of a VM scale set instance.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_instance_view_with_http_info(resource_group_name, vm_scale_set_name, custom_headers:nil)
      get_instance_view_async(resource_group_name, vm_scale_set_name, custom_headers:custom_headers).value!
    end

    #
    # Gets the status of a VM scale set instance.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_instance_view_async(resource_group_name, vm_scale_set_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/instanceView'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetInstanceView.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a list of all VM scale sets under a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<VirtualMachineScaleSet>] operation results.
    #
    def list(resource_group_name, custom_headers:nil)
      first_page = list_as_lazy(resource_group_name, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Gets a list of all VM scale sets under a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(resource_group_name, custom_headers:nil)
      list_async(resource_group_name, custom_headers:custom_headers).value!
    end

    #
    # Gets a list of all VM scale sets under a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(resource_group_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a list of all VM Scale Sets in the subscription, regardless of the
    # associated resource group. Use nextLink property in the response to get the
    # next page of VM Scale Sets. Do this till nextLink is null to fetch all the VM
    # Scale Sets.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<VirtualMachineScaleSet>] operation results.
    #
    def list_all(custom_headers:nil)
      first_page = list_all_as_lazy(custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Gets a list of all VM Scale Sets in the subscription, regardless of the
    # associated resource group. Use nextLink property in the response to get the
    # next page of VM Scale Sets. Do this till nextLink is null to fetch all the VM
    # Scale Sets.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_all_with_http_info(custom_headers:nil)
      list_all_async(custom_headers:custom_headers).value!
    end

    #
    # Gets a list of all VM Scale Sets in the subscription, regardless of the
    # associated resource group. Use nextLink property in the response to get the
    # next page of VM Scale Sets. Do this till nextLink is null to fetch all the VM
    # Scale Sets.
    #
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_all_async(custom_headers:nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Compute/virtualMachineScaleSets'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetListWithLinkResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a list of SKUs available for your VM scale set, including the minimum
    # and maximum VM instances allowed for each SKU.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<VirtualMachineScaleSetSku>] operation results.
    #
    def list_skus(resource_group_name, vm_scale_set_name, custom_headers:nil)
      first_page = list_skus_as_lazy(resource_group_name, vm_scale_set_name, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Gets a list of SKUs available for your VM scale set, including the minimum
    # and maximum VM instances allowed for each SKU.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_skus_with_http_info(resource_group_name, vm_scale_set_name, custom_headers:nil)
      list_skus_async(resource_group_name, vm_scale_set_name, custom_headers:custom_headers).value!
    end

    #
    # Gets a list of SKUs available for your VM scale set, including the minimum
    # and maximum VM instances allowed for each SKU.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_skus_async(resource_group_name, vm_scale_set_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/skus'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetListSkusResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets list of OS upgrades on a VM scale set instance.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<UpgradeOperationHistoricalStatusInfo>] operation results.
    #
    def get_osupgrade_history(resource_group_name, vm_scale_set_name, custom_headers:nil)
      first_page = get_osupgrade_history_as_lazy(resource_group_name, vm_scale_set_name, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Gets list of OS upgrades on a VM scale set instance.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_osupgrade_history_with_http_info(resource_group_name, vm_scale_set_name, custom_headers:nil)
      get_osupgrade_history_async(resource_group_name, vm_scale_set_name, custom_headers:custom_headers).value!
    end

    #
    # Gets list of OS upgrades on a VM scale set instance.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_osupgrade_history_async(resource_group_name, vm_scale_set_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/osUpgradeHistory'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetListOSUpgradeHistory.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Power off (stop) one or more virtual machines in a VM scale set. Note that
    # resources are still attached and you are getting charged for the resources.
    # Instead, use deallocate to release resources and avoid charges.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param skip_shutdown [Boolean] The parameter to request non-graceful VM
    # shutdown. True value for this flag indicates non-graceful shutdown whereas
    # false indicates otherwise. Default value for this flag is false if not
    # specified
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def power_off(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, skip_shutdown:false, custom_headers:nil)
      response = power_off_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, skip_shutdown:skip_shutdown, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param skip_shutdown [Boolean] The parameter to request non-graceful VM
    # shutdown. True value for this flag indicates non-graceful shutdown whereas
    # false indicates otherwise. Default value for this flag is false if not
    # specified
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def power_off_async(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, skip_shutdown:false, custom_headers:nil)
      # Send request
      promise = begin_power_off_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, skip_shutdown:skip_shutdown, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Restarts one or more virtual machines in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def restart(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      response = restart_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def restart_async(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      # Send request
      promise = begin_restart_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Starts one or more virtual machines in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def start(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      response = start_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def start_async(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      # Send request
      promise = begin_start_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Shuts down all the virtual machines in the virtual machine scale set, moves
    # them to a new node, and powers them back on.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def redeploy(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      response = redeploy_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def redeploy_async(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      # Send request
      promise = begin_redeploy_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Perform maintenance on one or more virtual machines in a VM scale set.
    # Operation on instances which are not eligible for perform maintenance will be
    # failed. Please refer to best practices for more details:
    # https://docs.microsoft.com/en-us/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-maintenance-notifications
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def perform_maintenance(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      response = perform_maintenance_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def perform_maintenance_async(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      # Send request
      promise = begin_perform_maintenance_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Upgrades one or more virtual machines to the latest SKU set in the VM scale
    # set model.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceRequiredIDs] A list
    # of virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def update_instances(resource_group_name, vm_scale_set_name, vm_instance_ids, custom_headers:nil)
      response = update_instances_async(resource_group_name, vm_scale_set_name, vm_instance_ids, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceRequiredIDs] A list
    # of virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def update_instances_async(resource_group_name, vm_scale_set_name, vm_instance_ids, custom_headers:nil)
      # Send request
      promise = begin_update_instances_async(resource_group_name, vm_scale_set_name, vm_instance_ids, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Reimages (upgrade the operating system) one or more virtual machines in a VM
    # scale set which don't have a ephemeral OS disk, for virtual machines who have
    # a ephemeral OS disk the virtual machine is reset to initial state.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_scale_set_reimage_input [VirtualMachineScaleSetReimageParameters]
    # Parameters for Reimaging VM ScaleSet.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def reimage(resource_group_name, vm_scale_set_name, vm_scale_set_reimage_input:nil, custom_headers:nil)
      response = reimage_async(resource_group_name, vm_scale_set_name, vm_scale_set_reimage_input:vm_scale_set_reimage_input, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_scale_set_reimage_input [VirtualMachineScaleSetReimageParameters]
    # Parameters for Reimaging VM ScaleSet.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def reimage_async(resource_group_name, vm_scale_set_name, vm_scale_set_reimage_input:nil, custom_headers:nil)
      # Send request
      promise = begin_reimage_async(resource_group_name, vm_scale_set_name, vm_scale_set_reimage_input:vm_scale_set_reimage_input, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Reimages all the disks ( including data disks ) in the virtual machines in a
    # VM scale set. This operation is only supported for managed disks.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def reimage_all(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      response = reimage_all_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def reimage_all_async(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      # Send request
      promise = begin_reimage_all_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Manual platform update domain walk to update virtual machines in a service
    # fabric virtual machine scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param platform_update_domain [Integer] The platform update domain for which
    # a manual recovery walk is requested
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RecoveryWalkResponse] operation results.
    #
    def force_recovery_service_fabric_platform_update_domain_walk(resource_group_name, vm_scale_set_name, platform_update_domain, custom_headers:nil)
      response = force_recovery_service_fabric_platform_update_domain_walk_async(resource_group_name, vm_scale_set_name, platform_update_domain, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Manual platform update domain walk to update virtual machines in a service
    # fabric virtual machine scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param platform_update_domain [Integer] The platform update domain for which
    # a manual recovery walk is requested
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def force_recovery_service_fabric_platform_update_domain_walk_with_http_info(resource_group_name, vm_scale_set_name, platform_update_domain, custom_headers:nil)
      force_recovery_service_fabric_platform_update_domain_walk_async(resource_group_name, vm_scale_set_name, platform_update_domain, custom_headers:custom_headers).value!
    end

    #
    # Manual platform update domain walk to update virtual machines in a service
    # fabric virtual machine scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param platform_update_domain [Integer] The platform update domain for which
    # a manual recovery walk is requested
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def force_recovery_service_fabric_platform_update_domain_walk_async(resource_group_name, vm_scale_set_name, platform_update_domain, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'platform_update_domain is nil' if platform_update_domain.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/forceRecoveryServiceFabricPlatformUpdateDomainWalk'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version,'platformUpdateDomain' => platform_update_domain},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::RecoveryWalkResponse.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Converts SinglePlacementGroup property to false for a existing virtual
    # machine scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the virtual machine scale set
    # to create or update.
    # @param parameters [VMScaleSetConvertToSinglePlacementGroupInput] The input
    # object for ConvertToSinglePlacementGroup API.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def convert_to_single_placement_group(resource_group_name, vm_scale_set_name, parameters, custom_headers:nil)
      response = convert_to_single_placement_group_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:custom_headers).value!
      nil
    end

    #
    # Converts SinglePlacementGroup property to false for a existing virtual
    # machine scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the virtual machine scale set
    # to create or update.
    # @param parameters [VMScaleSetConvertToSinglePlacementGroupInput] The input
    # object for ConvertToSinglePlacementGroup API.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def convert_to_single_placement_group_with_http_info(resource_group_name, vm_scale_set_name, parameters, custom_headers:nil)
      convert_to_single_placement_group_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Converts SinglePlacementGroup property to false for a existing virtual
    # machine scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the virtual machine scale set
    # to create or update.
    # @param parameters [VMScaleSetConvertToSinglePlacementGroupInput] The input
    # object for ConvertToSinglePlacementGroup API.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def convert_to_single_placement_group_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VMScaleSetConvertToSinglePlacementGroupInput.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/convertToSinglePlacementGroup'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Changes ServiceState property for a given service
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the virtual machine scale set
    # to create or update.
    # @param parameters [OrchestrationServiceStateInput] The input object for
    # SetOrchestrationServiceState API.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def set_orchestration_service_state(resource_group_name, vm_scale_set_name, parameters, custom_headers:nil)
      response = set_orchestration_service_state_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the virtual machine scale set
    # to create or update.
    # @param parameters [OrchestrationServiceStateInput] The input object for
    # SetOrchestrationServiceState API.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def set_orchestration_service_state_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_set_orchestration_service_state_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Create or update a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set to create or
    # update.
    # @param parameters [VirtualMachineScaleSet] The scale set object.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSet] operation results.
    #
    def begin_create_or_update(resource_group_name, vm_scale_set_name, parameters, custom_headers:nil)
      response = begin_create_or_update_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create or update a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set to create or
    # update.
    # @param parameters [VirtualMachineScaleSet] The scale set object.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_with_http_info(resource_group_name, vm_scale_set_name, parameters, custom_headers:nil)
      begin_create_or_update_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Create or update a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set to create or
    # update.
    # @param parameters [VirtualMachineScaleSet] The scale set object.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSet.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSet.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSet.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Update a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set to create or
    # update.
    # @param parameters [VirtualMachineScaleSetUpdate] The scale set object.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSet] operation results.
    #
    def begin_update(resource_group_name, vm_scale_set_name, parameters, custom_headers:nil)
      response = begin_update_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set to create or
    # update.
    # @param parameters [VirtualMachineScaleSetUpdate] The scale set object.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_update_with_http_info(resource_group_name, vm_scale_set_name, parameters, custom_headers:nil)
      begin_update_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Update a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set to create or
    # update.
    # @param parameters [VirtualMachineScaleSetUpdate] The scale set object.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_update_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetUpdate.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSet.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param force_deletion [Boolean] Optional parameter to force delete a VM scale
    # set. (Feature in Preview)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(resource_group_name, vm_scale_set_name, force_deletion:nil, custom_headers:nil)
      response = begin_delete_async(resource_group_name, vm_scale_set_name, force_deletion:force_deletion, custom_headers:custom_headers).value!
      nil
    end

    #
    # Deletes a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param force_deletion [Boolean] Optional parameter to force delete a VM scale
    # set. (Feature in Preview)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, vm_scale_set_name, force_deletion:nil, custom_headers:nil)
      begin_delete_async(resource_group_name, vm_scale_set_name, force_deletion:force_deletion, custom_headers:custom_headers).value!
    end

    #
    # Deletes a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param force_deletion [Boolean] Optional parameter to force delete a VM scale
    # set. (Feature in Preview)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, vm_scale_set_name, force_deletion:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'forceDeletion' => force_deletion,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Deallocates specific virtual machines in a VM scale set. Shuts down the
    # virtual machines and releases the compute resources. You are not billed for
    # the compute resources that this virtual machine scale set deallocates.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_deallocate(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      response = begin_deallocate_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers).value!
      nil
    end

    #
    # Deallocates specific virtual machines in a VM scale set. Shuts down the
    # virtual machines and releases the compute resources. You are not billed for
    # the compute resources that this virtual machine scale set deallocates.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_deallocate_with_http_info(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      begin_deallocate_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers).value!
    end

    #
    # Deallocates specific virtual machines in a VM scale set. Shuts down the
    # virtual machines and releases the compute resources. You are not billed for
    # the compute resources that this virtual machine scale set deallocates.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_deallocate_async(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetVMInstanceIDs.mapper()
      request_content = @client.serialize(request_mapper,  vm_instance_ids)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/deallocate'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Deletes virtual machines in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceRequiredIDs] A list
    # of virtual machine instance IDs from the VM scale set.
    # @param force_deletion [Boolean] Optional parameter to force delete virtual
    # machines from the VM scale set. (Feature in Preview)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete_instances(resource_group_name, vm_scale_set_name, vm_instance_ids, force_deletion:nil, custom_headers:nil)
      response = begin_delete_instances_async(resource_group_name, vm_scale_set_name, vm_instance_ids, force_deletion:force_deletion, custom_headers:custom_headers).value!
      nil
    end

    #
    # Deletes virtual machines in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceRequiredIDs] A list
    # of virtual machine instance IDs from the VM scale set.
    # @param force_deletion [Boolean] Optional parameter to force delete virtual
    # machines from the VM scale set. (Feature in Preview)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_instances_with_http_info(resource_group_name, vm_scale_set_name, vm_instance_ids, force_deletion:nil, custom_headers:nil)
      begin_delete_instances_async(resource_group_name, vm_scale_set_name, vm_instance_ids, force_deletion:force_deletion, custom_headers:custom_headers).value!
    end

    #
    # Deletes virtual machines in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceRequiredIDs] A list
    # of virtual machine instance IDs from the VM scale set.
    # @param force_deletion [Boolean] Optional parameter to force delete virtual
    # machines from the VM scale set. (Feature in Preview)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_instances_async(resource_group_name, vm_scale_set_name, vm_instance_ids, force_deletion:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, 'vm_instance_ids is nil' if vm_instance_ids.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetVMInstanceRequiredIDs.mapper()
      request_content = @client.serialize(request_mapper,  vm_instance_ids)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/delete'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'forceDeletion' => force_deletion,'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Power off (stop) one or more virtual machines in a VM scale set. Note that
    # resources are still attached and you are getting charged for the resources.
    # Instead, use deallocate to release resources and avoid charges.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param skip_shutdown [Boolean] The parameter to request non-graceful VM
    # shutdown. True value for this flag indicates non-graceful shutdown whereas
    # false indicates otherwise. Default value for this flag is false if not
    # specified
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_power_off(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, skip_shutdown:false, custom_headers:nil)
      response = begin_power_off_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, skip_shutdown:skip_shutdown, custom_headers:custom_headers).value!
      nil
    end

    #
    # Power off (stop) one or more virtual machines in a VM scale set. Note that
    # resources are still attached and you are getting charged for the resources.
    # Instead, use deallocate to release resources and avoid charges.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param skip_shutdown [Boolean] The parameter to request non-graceful VM
    # shutdown. True value for this flag indicates non-graceful shutdown whereas
    # false indicates otherwise. Default value for this flag is false if not
    # specified
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_power_off_with_http_info(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, skip_shutdown:false, custom_headers:nil)
      begin_power_off_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, skip_shutdown:skip_shutdown, custom_headers:custom_headers).value!
    end

    #
    # Power off (stop) one or more virtual machines in a VM scale set. Note that
    # resources are still attached and you are getting charged for the resources.
    # Instead, use deallocate to release resources and avoid charges.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param skip_shutdown [Boolean] The parameter to request non-graceful VM
    # shutdown. True value for this flag indicates non-graceful shutdown whereas
    # false indicates otherwise. Default value for this flag is false if not
    # specified
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_power_off_async(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, skip_shutdown:false, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetVMInstanceIDs.mapper()
      request_content = @client.serialize(request_mapper,  vm_instance_ids)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/poweroff'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'skipShutdown' => skip_shutdown,'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Restarts one or more virtual machines in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_restart(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      response = begin_restart_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers).value!
      nil
    end

    #
    # Restarts one or more virtual machines in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_restart_with_http_info(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      begin_restart_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers).value!
    end

    #
    # Restarts one or more virtual machines in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_restart_async(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetVMInstanceIDs.mapper()
      request_content = @client.serialize(request_mapper,  vm_instance_ids)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/restart'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Starts one or more virtual machines in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_start(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      response = begin_start_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers).value!
      nil
    end

    #
    # Starts one or more virtual machines in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_start_with_http_info(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      begin_start_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers).value!
    end

    #
    # Starts one or more virtual machines in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_start_async(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetVMInstanceIDs.mapper()
      request_content = @client.serialize(request_mapper,  vm_instance_ids)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/start'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Shuts down all the virtual machines in the virtual machine scale set, moves
    # them to a new node, and powers them back on.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_redeploy(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      response = begin_redeploy_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers).value!
      nil
    end

    #
    # Shuts down all the virtual machines in the virtual machine scale set, moves
    # them to a new node, and powers them back on.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_redeploy_with_http_info(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      begin_redeploy_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers).value!
    end

    #
    # Shuts down all the virtual machines in the virtual machine scale set, moves
    # them to a new node, and powers them back on.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_redeploy_async(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetVMInstanceIDs.mapper()
      request_content = @client.serialize(request_mapper,  vm_instance_ids)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/redeploy'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Perform maintenance on one or more virtual machines in a VM scale set.
    # Operation on instances which are not eligible for perform maintenance will be
    # failed. Please refer to best practices for more details:
    # https://docs.microsoft.com/en-us/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-maintenance-notifications
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_perform_maintenance(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      response = begin_perform_maintenance_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers).value!
      nil
    end

    #
    # Perform maintenance on one or more virtual machines in a VM scale set.
    # Operation on instances which are not eligible for perform maintenance will be
    # failed. Please refer to best practices for more details:
    # https://docs.microsoft.com/en-us/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-maintenance-notifications
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_perform_maintenance_with_http_info(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      begin_perform_maintenance_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers).value!
    end

    #
    # Perform maintenance on one or more virtual machines in a VM scale set.
    # Operation on instances which are not eligible for perform maintenance will be
    # failed. Please refer to best practices for more details:
    # https://docs.microsoft.com/en-us/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-maintenance-notifications
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_perform_maintenance_async(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetVMInstanceIDs.mapper()
      request_content = @client.serialize(request_mapper,  vm_instance_ids)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/performMaintenance'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Upgrades one or more virtual machines to the latest SKU set in the VM scale
    # set model.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceRequiredIDs] A list
    # of virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_update_instances(resource_group_name, vm_scale_set_name, vm_instance_ids, custom_headers:nil)
      response = begin_update_instances_async(resource_group_name, vm_scale_set_name, vm_instance_ids, custom_headers:custom_headers).value!
      nil
    end

    #
    # Upgrades one or more virtual machines to the latest SKU set in the VM scale
    # set model.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceRequiredIDs] A list
    # of virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_update_instances_with_http_info(resource_group_name, vm_scale_set_name, vm_instance_ids, custom_headers:nil)
      begin_update_instances_async(resource_group_name, vm_scale_set_name, vm_instance_ids, custom_headers:custom_headers).value!
    end

    #
    # Upgrades one or more virtual machines to the latest SKU set in the VM scale
    # set model.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceRequiredIDs] A list
    # of virtual machine instance IDs from the VM scale set.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_update_instances_async(resource_group_name, vm_scale_set_name, vm_instance_ids, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, 'vm_instance_ids is nil' if vm_instance_ids.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetVMInstanceRequiredIDs.mapper()
      request_content = @client.serialize(request_mapper,  vm_instance_ids)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/manualupgrade'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Reimages (upgrade the operating system) one or more virtual machines in a VM
    # scale set which don't have a ephemeral OS disk, for virtual machines who have
    # a ephemeral OS disk the virtual machine is reset to initial state.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_scale_set_reimage_input [VirtualMachineScaleSetReimageParameters]
    # Parameters for Reimaging VM ScaleSet.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_reimage(resource_group_name, vm_scale_set_name, vm_scale_set_reimage_input:nil, custom_headers:nil)
      response = begin_reimage_async(resource_group_name, vm_scale_set_name, vm_scale_set_reimage_input:vm_scale_set_reimage_input, custom_headers:custom_headers).value!
      nil
    end

    #
    # Reimages (upgrade the operating system) one or more virtual machines in a VM
    # scale set which don't have a ephemeral OS disk, for virtual machines who have
    # a ephemeral OS disk the virtual machine is reset to initial state.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_scale_set_reimage_input [VirtualMachineScaleSetReimageParameters]
    # Parameters for Reimaging VM ScaleSet.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_reimage_with_http_info(resource_group_name, vm_scale_set_name, vm_scale_set_reimage_input:nil, custom_headers:nil)
      begin_reimage_async(resource_group_name, vm_scale_set_name, vm_scale_set_reimage_input:vm_scale_set_reimage_input, custom_headers:custom_headers).value!
    end

    #
    # Reimages (upgrade the operating system) one or more virtual machines in a VM
    # scale set which don't have a ephemeral OS disk, for virtual machines who have
    # a ephemeral OS disk the virtual machine is reset to initial state.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_scale_set_reimage_input [VirtualMachineScaleSetReimageParameters]
    # Parameters for Reimaging VM ScaleSet.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_reimage_async(resource_group_name, vm_scale_set_name, vm_scale_set_reimage_input:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetReimageParameters.mapper()
      request_content = @client.serialize(request_mapper,  vm_scale_set_reimage_input)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/reimage'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Reimages all the disks ( including data disks ) in the virtual machines in a
    # VM scale set. This operation is only supported for managed disks.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_reimage_all(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      response = begin_reimage_all_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers).value!
      nil
    end

    #
    # Reimages all the disks ( including data disks ) in the virtual machines in a
    # VM scale set. This operation is only supported for managed disks.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_reimage_all_with_http_info(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      begin_reimage_all_async(resource_group_name, vm_scale_set_name, vm_instance_ids:vm_instance_ids, custom_headers:custom_headers).value!
    end

    #
    # Reimages all the disks ( including data disks ) in the virtual machines in a
    # VM scale set. This operation is only supported for managed disks.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param vm_instance_ids [VirtualMachineScaleSetVMInstanceIDs] A list of
    # virtual machine instance IDs from the VM scale set.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_reimage_all_async(resource_group_name, vm_scale_set_name, vm_instance_ids:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetVMInstanceIDs.mapper()
      request_content = @client.serialize(request_mapper,  vm_instance_ids)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/reimageall'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Changes ServiceState property for a given service
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the virtual machine scale set
    # to create or update.
    # @param parameters [OrchestrationServiceStateInput] The input object for
    # SetOrchestrationServiceState API.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_set_orchestration_service_state(resource_group_name, vm_scale_set_name, parameters, custom_headers:nil)
      response = begin_set_orchestration_service_state_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:custom_headers).value!
      nil
    end

    #
    # Changes ServiceState property for a given service
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the virtual machine scale set
    # to create or update.
    # @param parameters [OrchestrationServiceStateInput] The input object for
    # SetOrchestrationServiceState API.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_set_orchestration_service_state_with_http_info(resource_group_name, vm_scale_set_name, parameters, custom_headers:nil)
      begin_set_orchestration_service_state_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Changes ServiceState property for a given service
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the virtual machine scale set
    # to create or update.
    # @param parameters [OrchestrationServiceStateInput] The input object for
    # SetOrchestrationServiceState API.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_set_orchestration_service_state_async(resource_group_name, vm_scale_set_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::OrchestrationServiceStateInput.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/setOrchestrationServiceState'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets all the VM scale sets under the specified subscription for the specified
    # location.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSetListResult] operation results.
    #
    def list_by_location_next(next_page_link, custom_headers:nil)
      response = list_by_location_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets all the VM scale sets under the specified subscription for the specified
    # location.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_location_next_with_http_info(next_page_link, custom_headers:nil)
      list_by_location_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Gets all the VM scale sets under the specified subscription for the specified
    # location.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_location_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a list of all VM scale sets under a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSetListResult] operation results.
    #
    def list_next(next_page_link, custom_headers:nil)
      response = list_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a list of all VM scale sets under a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers:nil)
      list_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Gets a list of all VM scale sets under a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a list of all VM Scale Sets in the subscription, regardless of the
    # associated resource group. Use nextLink property in the response to get the
    # next page of VM Scale Sets. Do this till nextLink is null to fetch all the VM
    # Scale Sets.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSetListWithLinkResult] operation results.
    #
    def list_all_next(next_page_link, custom_headers:nil)
      response = list_all_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a list of all VM Scale Sets in the subscription, regardless of the
    # associated resource group. Use nextLink property in the response to get the
    # next page of VM Scale Sets. Do this till nextLink is null to fetch all the VM
    # Scale Sets.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_all_next_with_http_info(next_page_link, custom_headers:nil)
      list_all_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Gets a list of all VM Scale Sets in the subscription, regardless of the
    # associated resource group. Use nextLink property in the response to get the
    # next page of VM Scale Sets. Do this till nextLink is null to fetch all the VM
    # Scale Sets.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_all_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetListWithLinkResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a list of SKUs available for your VM scale set, including the minimum
    # and maximum VM instances allowed for each SKU.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSetListSkusResult] operation results.
    #
    def list_skus_next(next_page_link, custom_headers:nil)
      response = list_skus_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a list of SKUs available for your VM scale set, including the minimum
    # and maximum VM instances allowed for each SKU.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_skus_next_with_http_info(next_page_link, custom_headers:nil)
      list_skus_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Gets a list of SKUs available for your VM scale set, including the minimum
    # and maximum VM instances allowed for each SKU.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_skus_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetListSkusResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets list of OS upgrades on a VM scale set instance.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSetListOSUpgradeHistory] operation results.
    #
    def get_osupgrade_history_next(next_page_link, custom_headers:nil)
      response = get_osupgrade_history_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets list of OS upgrades on a VM scale set instance.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_osupgrade_history_next_with_http_info(next_page_link, custom_headers:nil)
      get_osupgrade_history_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Gets list of OS upgrades on a VM scale set instance.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_osupgrade_history_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_12_01::Models::VirtualMachineScaleSetListOSUpgradeHistory.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all the VM scale sets under the specified subscription for the specified
    # location.
    #
    # @param location [String] The location for which VM scale sets under the
    # subscription are queried.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSetListResult] which provide lazy access to pages
    # of the response.
    #
    def list_by_location_as_lazy(location, custom_headers:nil)
      response = list_by_location_async(location, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_location_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

    #
    # Gets a list of all VM scale sets under a resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSetListResult] which provide lazy access to pages
    # of the response.
    #
    def list_as_lazy(resource_group_name, custom_headers:nil)
      response = list_async(resource_group_name, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

    #
    # Gets a list of all VM Scale Sets in the subscription, regardless of the
    # associated resource group. Use nextLink property in the response to get the
    # next page of VM Scale Sets. Do this till nextLink is null to fetch all the VM
    # Scale Sets.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSetListWithLinkResult] which provide lazy access
    # to pages of the response.
    #
    def list_all_as_lazy(custom_headers:nil)
      response = list_all_async(custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_all_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

    #
    # Gets a list of SKUs available for your VM scale set, including the minimum
    # and maximum VM instances allowed for each SKU.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSetListSkusResult] which provide lazy access to
    # pages of the response.
    #
    def list_skus_as_lazy(resource_group_name, vm_scale_set_name, custom_headers:nil)
      response = list_skus_async(resource_group_name, vm_scale_set_name, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_skus_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

    #
    # Gets list of OS upgrades on a VM scale set instance.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSetListOSUpgradeHistory] which provide lazy
    # access to pages of the response.
    #
    def get_osupgrade_history_as_lazy(resource_group_name, vm_scale_set_name, custom_headers:nil)
      response = get_osupgrade_history_async(resource_group_name, vm_scale_set_name, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          get_osupgrade_history_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

  end
end
