# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Network::Mgmt::V2019_12_01
  module Models
    #
    # Private endpoint resource.
    #
    class PrivateEndpoint < Resource

      include MsRestAzure

      # @return [Subnet] The ID of the subnet from which the private IP will be
      # allocated.
      attr_accessor :subnet

      # @return [Array<NetworkInterface>] An array of references to the network
      # interfaces created for this private endpoint.
      attr_accessor :network_interfaces

      # @return [ProvisioningState] The provisioning state of the private
      # endpoint resource. Possible values include: 'Succeeded', 'Updating',
      # 'Deleting', 'Failed'
      attr_accessor :provisioning_state

      # @return [Array<PrivateLinkServiceConnection>] A grouping of information
      # about the connection to the remote resource.
      attr_accessor :private_link_service_connections

      # @return [Array<PrivateLinkServiceConnection>] A grouping of information
      # about the connection to the remote resource. Used when the network
      # admin does not have access to approve connections to the remote
      # resource.
      attr_accessor :manual_private_link_service_connections

      # @return [String] A unique read-only string that changes whenever the
      # resource is updated.
      attr_accessor :etag


      #
      # Mapper for PrivateEndpoint class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'PrivateEndpoint',
          type: {
            name: 'Composite',
            class_name: 'PrivateEndpoint',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              location: {
                client_side_validation: true,
                required: false,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              tags: {
                client_side_validation: true,
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              subnet: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.subnet',
                type: {
                  name: 'Composite',
                  class_name: 'Subnet'
                }
              },
              network_interfaces: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.networkInterfaces',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'NetworkInterfaceElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'NetworkInterface'
                      }
                  }
                }
              },
              provisioning_state: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.provisioningState',
                type: {
                  name: 'String'
                }
              },
              private_link_service_connections: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.privateLinkServiceConnections',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'PrivateLinkServiceConnectionElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'PrivateLinkServiceConnection'
                      }
                  }
                }
              },
              manual_private_link_service_connections: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.manualPrivateLinkServiceConnections',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'PrivateLinkServiceConnectionElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'PrivateLinkServiceConnection'
                      }
                  }
                }
              },
              etag: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'etag',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
