# frozen_string_literal: true

# WARNING ABOUT GENERATED CODE
#
# This file is generated. See the contributing guide for more information:
# https://github.com/aws/aws-sdk-ruby/blob/version-3/CONTRIBUTING.md
#
# WARNING ABOUT GENERATED CODE

require 'seahorse/client/plugins/content_length'
require 'aws-sdk-core/plugins/credentials_configuration'
require 'aws-sdk-core/plugins/logging'
require 'aws-sdk-core/plugins/param_converter'
require 'aws-sdk-core/plugins/param_validator'
require 'aws-sdk-core/plugins/user_agent'
require 'aws-sdk-core/plugins/helpful_socket_errors'
require 'aws-sdk-core/plugins/retry_errors'
require 'aws-sdk-core/plugins/global_configuration'
require 'aws-sdk-core/plugins/regional_endpoint'
require 'aws-sdk-core/plugins/endpoint_discovery'
require 'aws-sdk-core/plugins/endpoint_pattern'
require 'aws-sdk-core/plugins/response_paging'
require 'aws-sdk-core/plugins/stub_responses'
require 'aws-sdk-core/plugins/idempotency_token'
require 'aws-sdk-core/plugins/invocation_id'
require 'aws-sdk-core/plugins/jsonvalue_converter'
require 'aws-sdk-core/plugins/client_metrics_plugin'
require 'aws-sdk-core/plugins/client_metrics_send_plugin'
require 'aws-sdk-core/plugins/transfer_encoding'
require 'aws-sdk-core/plugins/http_checksum'
require 'aws-sdk-core/plugins/checksum_algorithm'
require 'aws-sdk-core/plugins/request_compression'
require 'aws-sdk-core/plugins/defaults_mode'
require 'aws-sdk-core/plugins/recursion_detection'
require 'aws-sdk-core/plugins/telemetry'
require 'aws-sdk-core/plugins/sign'
require 'aws-sdk-core/plugins/protocols/json_rpc'

module Aws::CloudHSM
  # An API client for CloudHSM.  To construct a client, you need to configure a `:region` and `:credentials`.
  #
  #     client = Aws::CloudHSM::Client.new(
  #       region: region_name,
  #       credentials: credentials,
  #       # ...
  #     )
  #
  # For details on configuring region and credentials see
  # the [developer guide](/sdk-for-ruby/v3/developer-guide/setup-config.html).
  #
  # See {#initialize} for a full list of supported configuration options.
  class Client < Seahorse::Client::Base

    include Aws::ClientStubs

    @identifier = :cloudhsm

    set_api(ClientApi::API)

    add_plugin(Seahorse::Client::Plugins::ContentLength)
    add_plugin(Aws::Plugins::CredentialsConfiguration)
    add_plugin(Aws::Plugins::Logging)
    add_plugin(Aws::Plugins::ParamConverter)
    add_plugin(Aws::Plugins::ParamValidator)
    add_plugin(Aws::Plugins::UserAgent)
    add_plugin(Aws::Plugins::HelpfulSocketErrors)
    add_plugin(Aws::Plugins::RetryErrors)
    add_plugin(Aws::Plugins::GlobalConfiguration)
    add_plugin(Aws::Plugins::RegionalEndpoint)
    add_plugin(Aws::Plugins::EndpointDiscovery)
    add_plugin(Aws::Plugins::EndpointPattern)
    add_plugin(Aws::Plugins::ResponsePaging)
    add_plugin(Aws::Plugins::StubResponses)
    add_plugin(Aws::Plugins::IdempotencyToken)
    add_plugin(Aws::Plugins::InvocationId)
    add_plugin(Aws::Plugins::JsonvalueConverter)
    add_plugin(Aws::Plugins::ClientMetricsPlugin)
    add_plugin(Aws::Plugins::ClientMetricsSendPlugin)
    add_plugin(Aws::Plugins::TransferEncoding)
    add_plugin(Aws::Plugins::HttpChecksum)
    add_plugin(Aws::Plugins::ChecksumAlgorithm)
    add_plugin(Aws::Plugins::RequestCompression)
    add_plugin(Aws::Plugins::DefaultsMode)
    add_plugin(Aws::Plugins::RecursionDetection)
    add_plugin(Aws::Plugins::Telemetry)
    add_plugin(Aws::Plugins::Sign)
    add_plugin(Aws::Plugins::Protocols::JsonRpc)
    add_plugin(Aws::CloudHSM::Plugins::Endpoints)

    # @overload initialize(options)
    #   @param [Hash] options
    #
    #   @option options [Array<Seahorse::Client::Plugin>] :plugins ([]])
    #     A list of plugins to apply to the client. Each plugin is either a
    #     class name or an instance of a plugin class.
    #
    #   @option options [required, Aws::CredentialProvider] :credentials
    #     Your AWS credentials. This can be an instance of any one of the
    #     following classes:
    #
    #     * `Aws::Credentials` - Used for configuring static, non-refreshing
    #       credentials.
    #
    #     * `Aws::SharedCredentials` - Used for loading static credentials from a
    #       shared file, such as `~/.aws/config`.
    #
    #     * `Aws::AssumeRoleCredentials` - Used when you need to assume a role.
    #
    #     * `Aws::AssumeRoleWebIdentityCredentials` - Used when you need to
    #       assume a role after providing credentials via the web.
    #
    #     * `Aws::SSOCredentials` - Used for loading credentials from AWS SSO using an
    #       access token generated from `aws login`.
    #
    #     * `Aws::ProcessCredentials` - Used for loading credentials from a
    #       process that outputs to stdout.
    #
    #     * `Aws::InstanceProfileCredentials` - Used for loading credentials
    #       from an EC2 IMDS on an EC2 instance.
    #
    #     * `Aws::ECSCredentials` - Used for loading credentials from
    #       instances running in ECS.
    #
    #     * `Aws::CognitoIdentityCredentials` - Used for loading credentials
    #       from the Cognito Identity service.
    #
    #     When `:credentials` are not configured directly, the following
    #     locations will be searched for credentials:
    #
    #     * `Aws.config[:credentials]`
    #     * The `:access_key_id`, `:secret_access_key`, `:session_token`, and
    #       `:account_id` options.
    #     * ENV['AWS_ACCESS_KEY_ID'], ENV['AWS_SECRET_ACCESS_KEY'],
    #       ENV['AWS_SESSION_TOKEN'], and ENV['AWS_ACCOUNT_ID']
    #     * `~/.aws/credentials`
    #     * `~/.aws/config`
    #     * EC2/ECS IMDS instance profile - When used by default, the timeouts
    #       are very aggressive. Construct and pass an instance of
    #       `Aws::InstanceProfileCredentials` or `Aws::ECSCredentials` to
    #       enable retries and extended timeouts. Instance profile credential
    #       fetching can be disabled by setting ENV['AWS_EC2_METADATA_DISABLED']
    #       to true.
    #
    #   @option options [required, String] :region
    #     The AWS region to connect to.  The configured `:region` is
    #     used to determine the service `:endpoint`. When not passed,
    #     a default `:region` is searched for in the following locations:
    #
    #     * `Aws.config[:region]`
    #     * `ENV['AWS_REGION']`
    #     * `ENV['AMAZON_REGION']`
    #     * `ENV['AWS_DEFAULT_REGION']`
    #     * `~/.aws/credentials`
    #     * `~/.aws/config`
    #
    #   @option options [String] :access_key_id
    #
    #   @option options [String] :account_id
    #
    #   @option options [Boolean] :active_endpoint_cache (false)
    #     When set to `true`, a thread polling for endpoints will be running in
    #     the background every 60 secs (default). Defaults to `false`.
    #
    #   @option options [Boolean] :adaptive_retry_wait_to_fill (true)
    #     Used only in `adaptive` retry mode.  When true, the request will sleep
    #     until there is sufficent client side capacity to retry the request.
    #     When false, the request will raise a `RetryCapacityNotAvailableError` and will
    #     not retry instead of sleeping.
    #
    #   @option options [Boolean] :client_side_monitoring (false)
    #     When `true`, client-side metrics will be collected for all API requests from
    #     this client.
    #
    #   @option options [String] :client_side_monitoring_client_id ("")
    #     Allows you to provide an identifier for this client which will be attached to
    #     all generated client side metrics. Defaults to an empty string.
    #
    #   @option options [String] :client_side_monitoring_host ("127.0.0.1")
    #     Allows you to specify the DNS hostname or IPv4 or IPv6 address that the client
    #     side monitoring agent is running on, where client metrics will be published via UDP.
    #
    #   @option options [Integer] :client_side_monitoring_port (31000)
    #     Required for publishing client metrics. The port that the client side monitoring
    #     agent is running on, where client metrics will be published via UDP.
    #
    #   @option options [Aws::ClientSideMonitoring::Publisher] :client_side_monitoring_publisher (Aws::ClientSideMonitoring::Publisher)
    #     Allows you to provide a custom client-side monitoring publisher class. By default,
    #     will use the Client Side Monitoring Agent Publisher.
    #
    #   @option options [Boolean] :convert_params (true)
    #     When `true`, an attempt is made to coerce request parameters into
    #     the required types.
    #
    #   @option options [Boolean] :correct_clock_skew (true)
    #     Used only in `standard` and adaptive retry modes. Specifies whether to apply
    #     a clock skew correction and retry requests with skewed client clocks.
    #
    #   @option options [String] :defaults_mode ("legacy")
    #     See {Aws::DefaultsModeConfiguration} for a list of the
    #     accepted modes and the configuration defaults that are included.
    #
    #   @option options [Boolean] :disable_host_prefix_injection (false)
    #     When `true`, the SDK will not prepend the modeled host prefix to the endpoint.
    #
    #   @option options [Boolean] :disable_request_compression (false)
    #     When set to 'true' the request body will not be compressed
    #     for supported operations.
    #
    #   @option options [String, URI::HTTPS, URI::HTTP] :endpoint
    #     Normally you should not configure the `:endpoint` option
    #     directly. This is normally constructed from the `:region`
    #     option. Configuring `:endpoint` is normally reserved for
    #     connecting to test or custom endpoints. The endpoint should
    #     be a URI formatted like:
    #
    #         'http://example.com'
    #         'https://example.com'
    #         'http://example.com:123'
    #
    #   @option options [Integer] :endpoint_cache_max_entries (1000)
    #     Used for the maximum size limit of the LRU cache storing endpoints data
    #     for endpoint discovery enabled operations. Defaults to 1000.
    #
    #   @option options [Integer] :endpoint_cache_max_threads (10)
    #     Used for the maximum threads in use for polling endpoints to be cached, defaults to 10.
    #
    #   @option options [Integer] :endpoint_cache_poll_interval (60)
    #     When :endpoint_discovery and :active_endpoint_cache is enabled,
    #     Use this option to config the time interval in seconds for making
    #     requests fetching endpoints information. Defaults to 60 sec.
    #
    #   @option options [Boolean] :endpoint_discovery (false)
    #     When set to `true`, endpoint discovery will be enabled for operations when available.
    #
    #   @option options [Boolean] :ignore_configured_endpoint_urls
    #     Setting to true disables use of endpoint URLs provided via environment
    #     variables and the shared configuration file.
    #
    #   @option options [Aws::Log::Formatter] :log_formatter (Aws::Log::Formatter.default)
    #     The log formatter.
    #
    #   @option options [Symbol] :log_level (:info)
    #     The log level to send messages to the `:logger` at.
    #
    #   @option options [Logger] :logger
    #     The Logger instance to send log messages to.  If this option
    #     is not set, logging will be disabled.
    #
    #   @option options [Integer] :max_attempts (3)
    #     An integer representing the maximum number attempts that will be made for
    #     a single request, including the initial attempt.  For example,
    #     setting this value to 5 will result in a request being retried up to
    #     4 times. Used in `standard` and `adaptive` retry modes.
    #
    #   @option options [String] :profile ("default")
    #     Used when loading credentials from the shared credentials file
    #     at HOME/.aws/credentials.  When not specified, 'default' is used.
    #
    #   @option options [String] :request_checksum_calculation ("when_supported")
    #     Determines when a checksum will be calculated for request payloads. Values are:
    #
    #     * `when_supported` - (default) When set, a checksum will be
    #       calculated for all request payloads of operations modeled with the
    #       `httpChecksum` trait where `requestChecksumRequired` is `true` and/or a
    #       `requestAlgorithmMember` is modeled.
    #     * `when_required` - When set, a checksum will only be calculated for
    #       request payloads of operations modeled with the  `httpChecksum` trait where
    #       `requestChecksumRequired` is `true` or where a `requestAlgorithmMember`
    #       is modeled and supplied.
    #
    #   @option options [Integer] :request_min_compression_size_bytes (10240)
    #     The minimum size in bytes that triggers compression for request
    #     bodies. The value must be non-negative integer value between 0
    #     and 10485780 bytes inclusive.
    #
    #   @option options [String] :response_checksum_validation ("when_supported")
    #     Determines when checksum validation will be performed on response payloads. Values are:
    #
    #     * `when_supported` - (default) When set, checksum validation is performed on all
    #       response payloads of operations modeled with the `httpChecksum` trait where
    #       `responseAlgorithms` is modeled, except when no modeled checksum algorithms
    #       are supported.
    #     * `when_required` - When set, checksum validation is not performed on
    #       response payloads of operations unless the checksum algorithm is supported and
    #       the `requestValidationModeMember` member is set to `ENABLED`.
    #
    #   @option options [Proc] :retry_backoff
    #     A proc or lambda used for backoff. Defaults to 2**retries * retry_base_delay.
    #     This option is only used in the `legacy` retry mode.
    #
    #   @option options [Float] :retry_base_delay (0.3)
    #     The base delay in seconds used by the default backoff function. This option
    #     is only used in the `legacy` retry mode.
    #
    #   @option options [Symbol] :retry_jitter (:none)
    #     A delay randomiser function used by the default backoff function.
    #     Some predefined functions can be referenced by name - :none, :equal, :full,
    #     otherwise a Proc that takes and returns a number. This option is only used
    #     in the `legacy` retry mode.
    #
    #     @see https://www.awsarchitectureblog.com/2015/03/backoff.html
    #
    #   @option options [Integer] :retry_limit (3)
    #     The maximum number of times to retry failed requests.  Only
    #     ~ 500 level server errors and certain ~ 400 level client errors
    #     are retried.  Generally, these are throttling errors, data
    #     checksum errors, networking errors, timeout errors, auth errors,
    #     endpoint discovery, and errors from expired credentials.
    #     This option is only used in the `legacy` retry mode.
    #
    #   @option options [Integer] :retry_max_delay (0)
    #     The maximum number of seconds to delay between retries (0 for no limit)
    #     used by the default backoff function. This option is only used in the
    #     `legacy` retry mode.
    #
    #   @option options [String] :retry_mode ("legacy")
    #     Specifies which retry algorithm to use. Values are:
    #
    #     * `legacy` - The pre-existing retry behavior.  This is default value if
    #       no retry mode is provided.
    #
    #     * `standard` - A standardized set of retry rules across the AWS SDKs.
    #       This includes support for retry quotas, which limit the number of
    #       unsuccessful retries a client can make.
    #
    #     * `adaptive` - An experimental retry mode that includes all the
    #       functionality of `standard` mode along with automatic client side
    #       throttling.  This is a provisional mode that may change behavior
    #       in the future.
    #
    #   @option options [String] :sdk_ua_app_id
    #     A unique and opaque application ID that is appended to the
    #     User-Agent header as app/sdk_ua_app_id. It should have a
    #     maximum length of 50. This variable is sourced from environment
    #     variable AWS_SDK_UA_APP_ID or the shared config profile attribute sdk_ua_app_id.
    #
    #   @option options [String] :secret_access_key
    #
    #   @option options [String] :session_token
    #
    #   @option options [Array] :sigv4a_signing_region_set
    #     A list of regions that should be signed with SigV4a signing. When
    #     not passed, a default `:sigv4a_signing_region_set` is searched for
    #     in the following locations:
    #
    #     * `Aws.config[:sigv4a_signing_region_set]`
    #     * `ENV['AWS_SIGV4A_SIGNING_REGION_SET']`
    #     * `~/.aws/config`
    #
    #   @option options [Boolean] :simple_json (false)
    #     Disables request parameter conversion, validation, and formatting.
    #     Also disables response data type conversions. The request parameters
    #     hash must be formatted exactly as the API expects.This option is useful
    #     when you want to ensure the highest level of performance by avoiding
    #     overhead of walking request parameters and response data structures.
    #
    #   @option options [Boolean] :stub_responses (false)
    #     Causes the client to return stubbed responses. By default
    #     fake responses are generated and returned. You can specify
    #     the response data to return or errors to raise by calling
    #     {ClientStubs#stub_responses}. See {ClientStubs} for more information.
    #
    #     ** Please note ** When response stubbing is enabled, no HTTP
    #     requests are made, and retries are disabled.
    #
    #   @option options [Aws::Telemetry::TelemetryProviderBase] :telemetry_provider (Aws::Telemetry::NoOpTelemetryProvider)
    #     Allows you to provide a telemetry provider, which is used to
    #     emit telemetry data. By default, uses `NoOpTelemetryProvider` which
    #     will not record or emit any telemetry data. The SDK supports the
    #     following telemetry providers:
    #
    #     * OpenTelemetry (OTel) - To use the OTel provider, install and require the
    #     `opentelemetry-sdk` gem and then, pass in an instance of a
    #     `Aws::Telemetry::OTelProvider` for telemetry provider.
    #
    #   @option options [Aws::TokenProvider] :token_provider
    #     A Bearer Token Provider. This can be an instance of any one of the
    #     following classes:
    #
    #     * `Aws::StaticTokenProvider` - Used for configuring static, non-refreshing
    #       tokens.
    #
    #     * `Aws::SSOTokenProvider` - Used for loading tokens from AWS SSO using an
    #       access token generated from `aws login`.
    #
    #     When `:token_provider` is not configured directly, the `Aws::TokenProviderChain`
    #     will be used to search for tokens configured for your profile in shared configuration files.
    #
    #   @option options [Boolean] :use_dualstack_endpoint
    #     When set to `true`, dualstack enabled endpoints (with `.aws` TLD)
    #     will be used if available.
    #
    #   @option options [Boolean] :use_fips_endpoint
    #     When set to `true`, fips compatible endpoints will be used if available.
    #     When a `fips` region is used, the region is normalized and this config
    #     is set to `true`.
    #
    #   @option options [Boolean] :validate_params (true)
    #     When `true`, request parameters are validated before
    #     sending the request.
    #
    #   @option options [Aws::CloudHSM::EndpointProvider] :endpoint_provider
    #     The endpoint provider used to resolve endpoints. Any object that responds to
    #     `#resolve_endpoint(parameters)` where `parameters` is a Struct similar to
    #     `Aws::CloudHSM::EndpointParameters`.
    #
    #   @option options [Float] :http_continue_timeout (1)
    #     The number of seconds to wait for a 100-continue response before sending the
    #     request body.  This option has no effect unless the request has "Expect"
    #     header set to "100-continue".  Defaults to `nil` which  disables this
    #     behaviour.  This value can safely be set per request on the session.
    #
    #   @option options [Float] :http_idle_timeout (5)
    #     The number of seconds a connection is allowed to sit idle before it
    #     is considered stale.  Stale connections are closed and removed from the
    #     pool before making a request.
    #
    #   @option options [Float] :http_open_timeout (15)
    #     The default number of seconds to wait for response data.
    #     This value can safely be set per-request on the session.
    #
    #   @option options [URI::HTTP,String] :http_proxy
    #     A proxy to send requests through.  Formatted like 'http://proxy.com:123'.
    #
    #   @option options [Float] :http_read_timeout (60)
    #     The default number of seconds to wait for response data.
    #     This value can safely be set per-request on the session.
    #
    #   @option options [Boolean] :http_wire_trace (false)
    #     When `true`,  HTTP debug output will be sent to the `:logger`.
    #
    #   @option options [Proc] :on_chunk_received
    #     When a Proc object is provided, it will be used as callback when each chunk
    #     of the response body is received. It provides three arguments: the chunk,
    #     the number of bytes received, and the total number of
    #     bytes in the response (or nil if the server did not send a `content-length`).
    #
    #   @option options [Proc] :on_chunk_sent
    #     When a Proc object is provided, it will be used as callback when each chunk
    #     of the request body is sent. It provides three arguments: the chunk,
    #     the number of bytes read from the body, and the total number of
    #     bytes in the body.
    #
    #   @option options [Boolean] :raise_response_errors (true)
    #     When `true`, response errors are raised.
    #
    #   @option options [String] :ssl_ca_bundle
    #     Full path to the SSL certificate authority bundle file that should be used when
    #     verifying peer certificates.  If you do not pass `:ssl_ca_bundle` or
    #     `:ssl_ca_directory` the the system default will be used if available.
    #
    #   @option options [String] :ssl_ca_directory
    #     Full path of the directory that contains the unbundled SSL certificate
    #     authority files for verifying peer certificates.  If you do
    #     not pass `:ssl_ca_bundle` or `:ssl_ca_directory` the the system
    #     default will be used if available.
    #
    #   @option options [String] :ssl_ca_store
    #     Sets the X509::Store to verify peer certificate.
    #
    #   @option options [OpenSSL::X509::Certificate] :ssl_cert
    #     Sets a client certificate when creating http connections.
    #
    #   @option options [OpenSSL::PKey] :ssl_key
    #     Sets a client key when creating http connections.
    #
    #   @option options [Float] :ssl_timeout
    #     Sets the SSL timeout in seconds
    #
    #   @option options [Boolean] :ssl_verify_peer (true)
    #     When `true`, SSL peer certificates are verified when establishing a connection.
    #
    def initialize(*args)
      super
    end

    # @!group API Operations

    # This is documentation for **AWS CloudHSM Classic**. For more
    # information, see [AWS CloudHSM Classic FAQs][1], the [AWS CloudHSM
    # Classic User Guide][2], and the [AWS CloudHSM Classic API
    # Reference][3].
    #
    # **For information about the current version of AWS CloudHSM**, see
    # [AWS CloudHSM][4], the [AWS CloudHSM User Guide][5], and the [AWS
    # CloudHSM API Reference][6].
    #
    # Adds or overwrites one or more tags for the specified AWS CloudHSM
    # resource.
    #
    # Each tag consists of a key and a value. Tag keys must be unique to
    # each resource.
    #
    #
    #
    # [1]: http://aws.amazon.com/cloudhsm/faqs-classic/
    # [2]: https://docs.aws.amazon.com/cloudhsm/classic/userguide/
    # [3]: https://docs.aws.amazon.com/cloudhsm/classic/APIReference/
    # [4]: http://aws.amazon.com/cloudhsm/
    # [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/
    # [6]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/
    #
    # @option params [required, String] :resource_arn
    #   The Amazon Resource Name (ARN) of the AWS CloudHSM resource to tag.
    #
    # @option params [required, Array<Types::Tag>] :tag_list
    #   One or more tags.
    #
    # @return [Types::AddTagsToResourceResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::AddTagsToResourceResponse#status #status} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.add_tags_to_resource({
    #     resource_arn: "String", # required
    #     tag_list: [ # required
    #       {
    #         key: "TagKey", # required
    #         value: "TagValue", # required
    #       },
    #     ],
    #   })
    #
    # @example Response structure
    #
    #   resp.status #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/AddTagsToResource AWS API Documentation
    #
    # @overload add_tags_to_resource(params = {})
    # @param [Hash] params ({})
    def add_tags_to_resource(params = {}, options = {})
      req = build_request(:add_tags_to_resource, params)
      req.send_request(options)
    end

    # This is documentation for **AWS CloudHSM Classic**. For more
    # information, see [AWS CloudHSM Classic FAQs][1], the [AWS CloudHSM
    # Classic User Guide][2], and the [AWS CloudHSM Classic API
    # Reference][3].
    #
    # **For information about the current version of AWS CloudHSM**, see
    # [AWS CloudHSM][4], the [AWS CloudHSM User Guide][5], and the [AWS
    # CloudHSM API Reference][6].
    #
    # Creates a high-availability partition group. A high-availability
    # partition group is a group of partitions that spans multiple physical
    # HSMs.
    #
    #
    #
    # [1]: http://aws.amazon.com/cloudhsm/faqs-classic/
    # [2]: https://docs.aws.amazon.com/cloudhsm/classic/userguide/
    # [3]: https://docs.aws.amazon.com/cloudhsm/classic/APIReference/
    # [4]: http://aws.amazon.com/cloudhsm/
    # [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/
    # [6]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/
    #
    # @option params [required, String] :label
    #   The label of the new high-availability partition group.
    #
    # @return [Types::CreateHapgResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateHapgResponse#hapg_arn #hapg_arn} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_hapg({
    #     label: "Label", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.hapg_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateHapg AWS API Documentation
    #
    # @overload create_hapg(params = {})
    # @param [Hash] params ({})
    def create_hapg(params = {}, options = {})
      req = build_request(:create_hapg, params)
      req.send_request(options)
    end

    # This is documentation for **AWS CloudHSM Classic**. For more
    # information, see [AWS CloudHSM Classic FAQs][1], the [AWS CloudHSM
    # Classic User Guide][2], and the [AWS CloudHSM Classic API
    # Reference][3].
    #
    # **For information about the current version of AWS CloudHSM**, see
    # [AWS CloudHSM][4], the [AWS CloudHSM User Guide][5], and the [AWS
    # CloudHSM API Reference][6].
    #
    # Creates an uninitialized HSM instance.
    #
    # There is an upfront fee charged for each HSM instance that you create
    # with the `CreateHsm` operation. If you accidentally provision an HSM
    # and want to request a refund, delete the instance using the DeleteHsm
    # operation, go to the [AWS Support Center][7], create a new case, and
    # select **Account and Billing Support**.
    #
    # It can take up to 20 minutes to create and provision an HSM. You can
    # monitor the status of the HSM with the DescribeHsm operation. The HSM
    # is ready to be initialized when the status changes to `RUNNING`.
    #
    #
    #
    # [1]: http://aws.amazon.com/cloudhsm/faqs-classic/
    # [2]: https://docs.aws.amazon.com/cloudhsm/classic/userguide/
    # [3]: https://docs.aws.amazon.com/cloudhsm/classic/APIReference/
    # [4]: http://aws.amazon.com/cloudhsm/
    # [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/
    # [6]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/
    # [7]: https://console.aws.amazon.com/support/home
    #
    # @option params [required, String] :subnet_id
    #   The identifier of the subnet in your VPC in which to place the HSM.
    #
    # @option params [required, String] :ssh_key
    #   The SSH public key to install on the HSM.
    #
    # @option params [String] :eni_ip
    #   The IP address to assign to the HSM's ENI.
    #
    #   If an IP address is not specified, an IP address will be randomly
    #   chosen from the CIDR range of the subnet.
    #
    # @option params [required, String] :iam_role_arn
    #   The ARN of an IAM role to enable the AWS CloudHSM service to allocate
    #   an ENI on your behalf.
    #
    # @option params [String] :external_id
    #   The external ID from `IamRoleArn`, if present.
    #
    # @option params [required, String] :subscription_type
    #   Specifies the type of subscription for the HSM.
    #
    #   * **PRODUCTION** - The HSM is being used in a production environment.
    #
    #   * **TRIAL** - The HSM is being used in a product trial.
    #
    # @option params [String] :client_token
    #   A user-defined token to ensure idempotence. Subsequent calls to this
    #   operation with the same token will be ignored.
    #
    # @option params [String] :syslog_ip
    #   The IP address for the syslog monitoring server. The AWS CloudHSM
    #   service only supports one syslog monitoring server.
    #
    # @return [Types::CreateHsmResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateHsmResponse#hsm_arn #hsm_arn} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_hsm({
    #     subnet_id: "SubnetId", # required
    #     ssh_key: "SshKey", # required
    #     eni_ip: "IpAddress",
    #     iam_role_arn: "IamRoleArn", # required
    #     external_id: "ExternalId",
    #     subscription_type: "PRODUCTION", # required, accepts PRODUCTION
    #     client_token: "ClientToken",
    #     syslog_ip: "IpAddress",
    #   })
    #
    # @example Response structure
    #
    #   resp.hsm_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateHsm AWS API Documentation
    #
    # @overload create_hsm(params = {})
    # @param [Hash] params ({})
    def create_hsm(params = {}, options = {})
      req = build_request(:create_hsm, params)
      req.send_request(options)
    end

    # This is documentation for **AWS CloudHSM Classic**. For more
    # information, see [AWS CloudHSM Classic FAQs][1], the [AWS CloudHSM
    # Classic User Guide][2], and the [AWS CloudHSM Classic API
    # Reference][3].
    #
    # **For information about the current version of AWS CloudHSM**, see
    # [AWS CloudHSM][4], the [AWS CloudHSM User Guide][5], and the [AWS
    # CloudHSM API Reference][6].
    #
    # Creates an HSM client.
    #
    #
    #
    # [1]: http://aws.amazon.com/cloudhsm/faqs-classic/
    # [2]: https://docs.aws.amazon.com/cloudhsm/classic/userguide/
    # [3]: https://docs.aws.amazon.com/cloudhsm/classic/APIReference/
    # [4]: http://aws.amazon.com/cloudhsm/
    # [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/
    # [6]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/
    #
    # @option params [String] :label
    #   The label for the client.
    #
    # @option params [required, String] :certificate
    #   The contents of a Base64-Encoded X.509 v3 certificate to be installed
    #   on the HSMs used by this client.
    #
    # @return [Types::CreateLunaClientResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::CreateLunaClientResponse#client_arn #client_arn} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_luna_client({
    #     label: "ClientLabel",
    #     certificate: "Certificate", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.client_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/CreateLunaClient AWS API Documentation
    #
    # @overload create_luna_client(params = {})
    # @param [Hash] params ({})
    def create_luna_client(params = {}, options = {})
      req = build_request(:create_luna_client, params)
      req.send_request(options)
    end

    # This is documentation for **AWS CloudHSM Classic**. For more
    # information, see [AWS CloudHSM Classic FAQs][1], the [AWS CloudHSM
    # Classic User Guide][2], and the [AWS CloudHSM Classic API
    # Reference][3].
    #
    # **For information about the current version of AWS CloudHSM**, see
    # [AWS CloudHSM][4], the [AWS CloudHSM User Guide][5], and the [AWS
    # CloudHSM API Reference][6].
    #
    # Deletes a high-availability partition group.
    #
    #
    #
    # [1]: http://aws.amazon.com/cloudhsm/faqs-classic/
    # [2]: https://docs.aws.amazon.com/cloudhsm/classic/userguide/
    # [3]: https://docs.aws.amazon.com/cloudhsm/classic/APIReference/
    # [4]: http://aws.amazon.com/cloudhsm/
    # [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/
    # [6]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/
    #
    # @option params [required, String] :hapg_arn
    #   The ARN of the high-availability partition group to delete.
    #
    # @return [Types::DeleteHapgResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteHapgResponse#status #status} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_hapg({
    #     hapg_arn: "HapgArn", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.status #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteHapg AWS API Documentation
    #
    # @overload delete_hapg(params = {})
    # @param [Hash] params ({})
    def delete_hapg(params = {}, options = {})
      req = build_request(:delete_hapg, params)
      req.send_request(options)
    end

    # This is documentation for **AWS CloudHSM Classic**. For more
    # information, see [AWS CloudHSM Classic FAQs][1], the [AWS CloudHSM
    # Classic User Guide][2], and the [AWS CloudHSM Classic API
    # Reference][3].
    #
    # **For information about the current version of AWS CloudHSM**, see
    # [AWS CloudHSM][4], the [AWS CloudHSM User Guide][5], and the [AWS
    # CloudHSM API Reference][6].
    #
    # Deletes an HSM. After completion, this operation cannot be undone and
    # your key material cannot be recovered.
    #
    #
    #
    # [1]: http://aws.amazon.com/cloudhsm/faqs-classic/
    # [2]: https://docs.aws.amazon.com/cloudhsm/classic/userguide/
    # [3]: https://docs.aws.amazon.com/cloudhsm/classic/APIReference/
    # [4]: http://aws.amazon.com/cloudhsm/
    # [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/
    # [6]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/
    #
    # @option params [required, String] :hsm_arn
    #   The ARN of the HSM to delete.
    #
    # @return [Types::DeleteHsmResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteHsmResponse#status #status} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_hsm({
    #     hsm_arn: "HsmArn", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.status #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteHsm AWS API Documentation
    #
    # @overload delete_hsm(params = {})
    # @param [Hash] params ({})
    def delete_hsm(params = {}, options = {})
      req = build_request(:delete_hsm, params)
      req.send_request(options)
    end

    # This is documentation for **AWS CloudHSM Classic**. For more
    # information, see [AWS CloudHSM Classic FAQs][1], the [AWS CloudHSM
    # Classic User Guide][2], and the [AWS CloudHSM Classic API
    # Reference][3].
    #
    # **For information about the current version of AWS CloudHSM**, see
    # [AWS CloudHSM][4], the [AWS CloudHSM User Guide][5], and the [AWS
    # CloudHSM API Reference][6].
    #
    # Deletes a client.
    #
    #
    #
    # [1]: http://aws.amazon.com/cloudhsm/faqs-classic/
    # [2]: https://docs.aws.amazon.com/cloudhsm/classic/userguide/
    # [3]: https://docs.aws.amazon.com/cloudhsm/classic/APIReference/
    # [4]: http://aws.amazon.com/cloudhsm/
    # [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/
    # [6]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/
    #
    # @option params [required, String] :client_arn
    #   The ARN of the client to delete.
    #
    # @return [Types::DeleteLunaClientResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DeleteLunaClientResponse#status #status} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_luna_client({
    #     client_arn: "ClientArn", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.status #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DeleteLunaClient AWS API Documentation
    #
    # @overload delete_luna_client(params = {})
    # @param [Hash] params ({})
    def delete_luna_client(params = {}, options = {})
      req = build_request(:delete_luna_client, params)
      req.send_request(options)
    end

    # This is documentation for **AWS CloudHSM Classic**. For more
    # information, see [AWS CloudHSM Classic FAQs][1], the [AWS CloudHSM
    # Classic User Guide][2], and the [AWS CloudHSM Classic API
    # Reference][3].
    #
    # **For information about the current version of AWS CloudHSM**, see
    # [AWS CloudHSM][4], the [AWS CloudHSM User Guide][5], and the [AWS
    # CloudHSM API Reference][6].
    #
    # Retrieves information about a high-availability partition group.
    #
    #
    #
    # [1]: http://aws.amazon.com/cloudhsm/faqs-classic/
    # [2]: https://docs.aws.amazon.com/cloudhsm/classic/userguide/
    # [3]: https://docs.aws.amazon.com/cloudhsm/classic/APIReference/
    # [4]: http://aws.amazon.com/cloudhsm/
    # [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/
    # [6]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/
    #
    # @option params [required, String] :hapg_arn
    #   The ARN of the high-availability partition group to describe.
    #
    # @return [Types::DescribeHapgResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeHapgResponse#hapg_arn #hapg_arn} => String
    #   * {Types::DescribeHapgResponse#hapg_serial #hapg_serial} => String
    #   * {Types::DescribeHapgResponse#hsms_last_action_failed #hsms_last_action_failed} => Array&lt;String&gt;
    #   * {Types::DescribeHapgResponse#hsms_pending_deletion #hsms_pending_deletion} => Array&lt;String&gt;
    #   * {Types::DescribeHapgResponse#hsms_pending_registration #hsms_pending_registration} => Array&lt;String&gt;
    #   * {Types::DescribeHapgResponse#label #label} => String
    #   * {Types::DescribeHapgResponse#last_modified_timestamp #last_modified_timestamp} => String
    #   * {Types::DescribeHapgResponse#partition_serial_list #partition_serial_list} => Array&lt;String&gt;
    #   * {Types::DescribeHapgResponse#state #state} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_hapg({
    #     hapg_arn: "HapgArn", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.hapg_arn #=> String
    #   resp.hapg_serial #=> String
    #   resp.hsms_last_action_failed #=> Array
    #   resp.hsms_last_action_failed[0] #=> String
    #   resp.hsms_pending_deletion #=> Array
    #   resp.hsms_pending_deletion[0] #=> String
    #   resp.hsms_pending_registration #=> Array
    #   resp.hsms_pending_registration[0] #=> String
    #   resp.label #=> String
    #   resp.last_modified_timestamp #=> String
    #   resp.partition_serial_list #=> Array
    #   resp.partition_serial_list[0] #=> String
    #   resp.state #=> String, one of "READY", "UPDATING", "DEGRADED"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeHapg AWS API Documentation
    #
    # @overload describe_hapg(params = {})
    # @param [Hash] params ({})
    def describe_hapg(params = {}, options = {})
      req = build_request(:describe_hapg, params)
      req.send_request(options)
    end

    # This is documentation for **AWS CloudHSM Classic**. For more
    # information, see [AWS CloudHSM Classic FAQs][1], the [AWS CloudHSM
    # Classic User Guide][2], and the [AWS CloudHSM Classic API
    # Reference][3].
    #
    # **For information about the current version of AWS CloudHSM**, see
    # [AWS CloudHSM][4], the [AWS CloudHSM User Guide][5], and the [AWS
    # CloudHSM API Reference][6].
    #
    # Retrieves information about an HSM. You can identify the HSM by its
    # ARN or its serial number.
    #
    #
    #
    # [1]: http://aws.amazon.com/cloudhsm/faqs-classic/
    # [2]: https://docs.aws.amazon.com/cloudhsm/classic/userguide/
    # [3]: https://docs.aws.amazon.com/cloudhsm/classic/APIReference/
    # [4]: http://aws.amazon.com/cloudhsm/
    # [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/
    # [6]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/
    #
    # @option params [String] :hsm_arn
    #   The ARN of the HSM. Either the `HsmArn` or the `SerialNumber`
    #   parameter must be specified.
    #
    # @option params [String] :hsm_serial_number
    #   The serial number of the HSM. Either the `HsmArn` or the
    #   `HsmSerialNumber` parameter must be specified.
    #
    # @return [Types::DescribeHsmResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeHsmResponse#hsm_arn #hsm_arn} => String
    #   * {Types::DescribeHsmResponse#status #status} => String
    #   * {Types::DescribeHsmResponse#status_details #status_details} => String
    #   * {Types::DescribeHsmResponse#availability_zone #availability_zone} => String
    #   * {Types::DescribeHsmResponse#eni_id #eni_id} => String
    #   * {Types::DescribeHsmResponse#eni_ip #eni_ip} => String
    #   * {Types::DescribeHsmResponse#subscription_type #subscription_type} => String
    #   * {Types::DescribeHsmResponse#subscription_start_date #subscription_start_date} => String
    #   * {Types::DescribeHsmResponse#subscription_end_date #subscription_end_date} => String
    #   * {Types::DescribeHsmResponse#vpc_id #vpc_id} => String
    #   * {Types::DescribeHsmResponse#subnet_id #subnet_id} => String
    #   * {Types::DescribeHsmResponse#iam_role_arn #iam_role_arn} => String
    #   * {Types::DescribeHsmResponse#serial_number #serial_number} => String
    #   * {Types::DescribeHsmResponse#vendor_name #vendor_name} => String
    #   * {Types::DescribeHsmResponse#hsm_type #hsm_type} => String
    #   * {Types::DescribeHsmResponse#software_version #software_version} => String
    #   * {Types::DescribeHsmResponse#ssh_public_key #ssh_public_key} => String
    #   * {Types::DescribeHsmResponse#ssh_key_last_updated #ssh_key_last_updated} => String
    #   * {Types::DescribeHsmResponse#server_cert_uri #server_cert_uri} => String
    #   * {Types::DescribeHsmResponse#server_cert_last_updated #server_cert_last_updated} => String
    #   * {Types::DescribeHsmResponse#partitions #partitions} => Array&lt;String&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_hsm({
    #     hsm_arn: "HsmArn",
    #     hsm_serial_number: "HsmSerialNumber",
    #   })
    #
    # @example Response structure
    #
    #   resp.hsm_arn #=> String
    #   resp.status #=> String, one of "PENDING", "RUNNING", "UPDATING", "SUSPENDED", "TERMINATING", "TERMINATED", "DEGRADED"
    #   resp.status_details #=> String
    #   resp.availability_zone #=> String
    #   resp.eni_id #=> String
    #   resp.eni_ip #=> String
    #   resp.subscription_type #=> String, one of "PRODUCTION"
    #   resp.subscription_start_date #=> String
    #   resp.subscription_end_date #=> String
    #   resp.vpc_id #=> String
    #   resp.subnet_id #=> String
    #   resp.iam_role_arn #=> String
    #   resp.serial_number #=> String
    #   resp.vendor_name #=> String
    #   resp.hsm_type #=> String
    #   resp.software_version #=> String
    #   resp.ssh_public_key #=> String
    #   resp.ssh_key_last_updated #=> String
    #   resp.server_cert_uri #=> String
    #   resp.server_cert_last_updated #=> String
    #   resp.partitions #=> Array
    #   resp.partitions[0] #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeHsm AWS API Documentation
    #
    # @overload describe_hsm(params = {})
    # @param [Hash] params ({})
    def describe_hsm(params = {}, options = {})
      req = build_request(:describe_hsm, params)
      req.send_request(options)
    end

    # This is documentation for **AWS CloudHSM Classic**. For more
    # information, see [AWS CloudHSM Classic FAQs][1], the [AWS CloudHSM
    # Classic User Guide][2], and the [AWS CloudHSM Classic API
    # Reference][3].
    #
    # **For information about the current version of AWS CloudHSM**, see
    # [AWS CloudHSM][4], the [AWS CloudHSM User Guide][5], and the [AWS
    # CloudHSM API Reference][6].
    #
    # Retrieves information about an HSM client.
    #
    #
    #
    # [1]: http://aws.amazon.com/cloudhsm/faqs-classic/
    # [2]: https://docs.aws.amazon.com/cloudhsm/classic/userguide/
    # [3]: https://docs.aws.amazon.com/cloudhsm/classic/APIReference/
    # [4]: http://aws.amazon.com/cloudhsm/
    # [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/
    # [6]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/
    #
    # @option params [String] :client_arn
    #   The ARN of the client.
    #
    # @option params [String] :certificate_fingerprint
    #   The certificate fingerprint.
    #
    # @return [Types::DescribeLunaClientResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeLunaClientResponse#client_arn #client_arn} => String
    #   * {Types::DescribeLunaClientResponse#certificate #certificate} => String
    #   * {Types::DescribeLunaClientResponse#certificate_fingerprint #certificate_fingerprint} => String
    #   * {Types::DescribeLunaClientResponse#last_modified_timestamp #last_modified_timestamp} => String
    #   * {Types::DescribeLunaClientResponse#label #label} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_luna_client({
    #     client_arn: "ClientArn",
    #     certificate_fingerprint: "CertificateFingerprint",
    #   })
    #
    # @example Response structure
    #
    #   resp.client_arn #=> String
    #   resp.certificate #=> String
    #   resp.certificate_fingerprint #=> String
    #   resp.last_modified_timestamp #=> String
    #   resp.label #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/DescribeLunaClient AWS API Documentation
    #
    # @overload describe_luna_client(params = {})
    # @param [Hash] params ({})
    def describe_luna_client(params = {}, options = {})
      req = build_request(:describe_luna_client, params)
      req.send_request(options)
    end

    # This is documentation for **AWS CloudHSM Classic**. For more
    # information, see [AWS CloudHSM Classic FAQs][1], the [AWS CloudHSM
    # Classic User Guide][2], and the [AWS CloudHSM Classic API
    # Reference][3].
    #
    # **For information about the current version of AWS CloudHSM**, see
    # [AWS CloudHSM][4], the [AWS CloudHSM User Guide][5], and the [AWS
    # CloudHSM API Reference][6].
    #
    # Gets the configuration files necessary to connect to all high
    # availability partition groups the client is associated with.
    #
    #
    #
    # [1]: http://aws.amazon.com/cloudhsm/faqs-classic/
    # [2]: https://docs.aws.amazon.com/cloudhsm/classic/userguide/
    # [3]: https://docs.aws.amazon.com/cloudhsm/classic/APIReference/
    # [4]: http://aws.amazon.com/cloudhsm/
    # [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/
    # [6]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/
    #
    # @option params [required, String] :client_arn
    #   The ARN of the client.
    #
    # @option params [required, String] :client_version
    #   The client version.
    #
    # @option params [required, Array<String>] :hapg_list
    #   A list of ARNs that identify the high-availability partition groups
    #   that are associated with the client.
    #
    # @return [Types::GetConfigResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::GetConfigResponse#config_type #config_type} => String
    #   * {Types::GetConfigResponse#config_file #config_file} => String
    #   * {Types::GetConfigResponse#config_cred #config_cred} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.get_config({
    #     client_arn: "ClientArn", # required
    #     client_version: "5.1", # required, accepts 5.1, 5.3
    #     hapg_list: ["HapgArn"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.config_type #=> String
    #   resp.config_file #=> String
    #   resp.config_cred #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/GetConfig AWS API Documentation
    #
    # @overload get_config(params = {})
    # @param [Hash] params ({})
    def get_config(params = {}, options = {})
      req = build_request(:get_config, params)
      req.send_request(options)
    end

    # This is documentation for **AWS CloudHSM Classic**. For more
    # information, see [AWS CloudHSM Classic FAQs][1], the [AWS CloudHSM
    # Classic User Guide][2], and the [AWS CloudHSM Classic API
    # Reference][3].
    #
    # **For information about the current version of AWS CloudHSM**, see
    # [AWS CloudHSM][4], the [AWS CloudHSM User Guide][5], and the [AWS
    # CloudHSM API Reference][6].
    #
    # Lists the Availability Zones that have available AWS CloudHSM
    # capacity.
    #
    #
    #
    # [1]: http://aws.amazon.com/cloudhsm/faqs-classic/
    # [2]: https://docs.aws.amazon.com/cloudhsm/classic/userguide/
    # [3]: https://docs.aws.amazon.com/cloudhsm/classic/APIReference/
    # [4]: http://aws.amazon.com/cloudhsm/
    # [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/
    # [6]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/
    #
    # @return [Types::ListAvailableZonesResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ListAvailableZonesResponse#az_list #az_list} => Array&lt;String&gt;
    #
    # @example Response structure
    #
    #   resp.az_list #=> Array
    #   resp.az_list[0] #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListAvailableZones AWS API Documentation
    #
    # @overload list_available_zones(params = {})
    # @param [Hash] params ({})
    def list_available_zones(params = {}, options = {})
      req = build_request(:list_available_zones, params)
      req.send_request(options)
    end

    # This is documentation for **AWS CloudHSM Classic**. For more
    # information, see [AWS CloudHSM Classic FAQs][1], the [AWS CloudHSM
    # Classic User Guide][2], and the [AWS CloudHSM Classic API
    # Reference][3].
    #
    # **For information about the current version of AWS CloudHSM**, see
    # [AWS CloudHSM][4], the [AWS CloudHSM User Guide][5], and the [AWS
    # CloudHSM API Reference][6].
    #
    # Lists the high-availability partition groups for the account.
    #
    # This operation supports pagination with the use of the `NextToken`
    # member. If more results are available, the `NextToken` member of the
    # response contains a token that you pass in the next call to
    # `ListHapgs` to retrieve the next set of items.
    #
    #
    #
    # [1]: http://aws.amazon.com/cloudhsm/faqs-classic/
    # [2]: https://docs.aws.amazon.com/cloudhsm/classic/userguide/
    # [3]: https://docs.aws.amazon.com/cloudhsm/classic/APIReference/
    # [4]: http://aws.amazon.com/cloudhsm/
    # [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/
    # [6]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/
    #
    # @option params [String] :next_token
    #   The `NextToken` value from a previous call to `ListHapgs`. Pass null
    #   if this is the first call.
    #
    # @return [Types::ListHapgsResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ListHapgsResponse#hapg_list #hapg_list} => Array&lt;String&gt;
    #   * {Types::ListHapgsResponse#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.list_hapgs({
    #     next_token: "PaginationToken",
    #   })
    #
    # @example Response structure
    #
    #   resp.hapg_list #=> Array
    #   resp.hapg_list[0] #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListHapgs AWS API Documentation
    #
    # @overload list_hapgs(params = {})
    # @param [Hash] params ({})
    def list_hapgs(params = {}, options = {})
      req = build_request(:list_hapgs, params)
      req.send_request(options)
    end

    # This is documentation for **AWS CloudHSM Classic**. For more
    # information, see [AWS CloudHSM Classic FAQs][1], the [AWS CloudHSM
    # Classic User Guide][2], and the [AWS CloudHSM Classic API
    # Reference][3].
    #
    # **For information about the current version of AWS CloudHSM**, see
    # [AWS CloudHSM][4], the [AWS CloudHSM User Guide][5], and the [AWS
    # CloudHSM API Reference][6].
    #
    # Retrieves the identifiers of all of the HSMs provisioned for the
    # current customer.
    #
    # This operation supports pagination with the use of the `NextToken`
    # member. If more results are available, the `NextToken` member of the
    # response contains a token that you pass in the next call to `ListHsms`
    # to retrieve the next set of items.
    #
    #
    #
    # [1]: http://aws.amazon.com/cloudhsm/faqs-classic/
    # [2]: https://docs.aws.amazon.com/cloudhsm/classic/userguide/
    # [3]: https://docs.aws.amazon.com/cloudhsm/classic/APIReference/
    # [4]: http://aws.amazon.com/cloudhsm/
    # [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/
    # [6]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/
    #
    # @option params [String] :next_token
    #   The `NextToken` value from a previous call to `ListHsms`. Pass null if
    #   this is the first call.
    #
    # @return [Types::ListHsmsResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ListHsmsResponse#hsm_list #hsm_list} => Array&lt;String&gt;
    #   * {Types::ListHsmsResponse#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.list_hsms({
    #     next_token: "PaginationToken",
    #   })
    #
    # @example Response structure
    #
    #   resp.hsm_list #=> Array
    #   resp.hsm_list[0] #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListHsms AWS API Documentation
    #
    # @overload list_hsms(params = {})
    # @param [Hash] params ({})
    def list_hsms(params = {}, options = {})
      req = build_request(:list_hsms, params)
      req.send_request(options)
    end

    # This is documentation for **AWS CloudHSM Classic**. For more
    # information, see [AWS CloudHSM Classic FAQs][1], the [AWS CloudHSM
    # Classic User Guide][2], and the [AWS CloudHSM Classic API
    # Reference][3].
    #
    # **For information about the current version of AWS CloudHSM**, see
    # [AWS CloudHSM][4], the [AWS CloudHSM User Guide][5], and the [AWS
    # CloudHSM API Reference][6].
    #
    # Lists all of the clients.
    #
    # This operation supports pagination with the use of the `NextToken`
    # member. If more results are available, the `NextToken` member of the
    # response contains a token that you pass in the next call to
    # `ListLunaClients` to retrieve the next set of items.
    #
    #
    #
    # [1]: http://aws.amazon.com/cloudhsm/faqs-classic/
    # [2]: https://docs.aws.amazon.com/cloudhsm/classic/userguide/
    # [3]: https://docs.aws.amazon.com/cloudhsm/classic/APIReference/
    # [4]: http://aws.amazon.com/cloudhsm/
    # [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/
    # [6]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/
    #
    # @option params [String] :next_token
    #   The `NextToken` value from a previous call to `ListLunaClients`. Pass
    #   null if this is the first call.
    #
    # @return [Types::ListLunaClientsResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ListLunaClientsResponse#client_list #client_list} => Array&lt;String&gt;
    #   * {Types::ListLunaClientsResponse#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.list_luna_clients({
    #     next_token: "PaginationToken",
    #   })
    #
    # @example Response structure
    #
    #   resp.client_list #=> Array
    #   resp.client_list[0] #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListLunaClients AWS API Documentation
    #
    # @overload list_luna_clients(params = {})
    # @param [Hash] params ({})
    def list_luna_clients(params = {}, options = {})
      req = build_request(:list_luna_clients, params)
      req.send_request(options)
    end

    # This is documentation for **AWS CloudHSM Classic**. For more
    # information, see [AWS CloudHSM Classic FAQs][1], the [AWS CloudHSM
    # Classic User Guide][2], and the [AWS CloudHSM Classic API
    # Reference][3].
    #
    # **For information about the current version of AWS CloudHSM**, see
    # [AWS CloudHSM][4], the [AWS CloudHSM User Guide][5], and the [AWS
    # CloudHSM API Reference][6].
    #
    # Returns a list of all tags for the specified AWS CloudHSM resource.
    #
    #
    #
    # [1]: http://aws.amazon.com/cloudhsm/faqs-classic/
    # [2]: https://docs.aws.amazon.com/cloudhsm/classic/userguide/
    # [3]: https://docs.aws.amazon.com/cloudhsm/classic/APIReference/
    # [4]: http://aws.amazon.com/cloudhsm/
    # [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/
    # [6]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/
    #
    # @option params [required, String] :resource_arn
    #   The Amazon Resource Name (ARN) of the AWS CloudHSM resource.
    #
    # @return [Types::ListTagsForResourceResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ListTagsForResourceResponse#tag_list #tag_list} => Array&lt;Types::Tag&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.list_tags_for_resource({
    #     resource_arn: "String", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.tag_list #=> Array
    #   resp.tag_list[0].key #=> String
    #   resp.tag_list[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ListTagsForResource AWS API Documentation
    #
    # @overload list_tags_for_resource(params = {})
    # @param [Hash] params ({})
    def list_tags_for_resource(params = {}, options = {})
      req = build_request(:list_tags_for_resource, params)
      req.send_request(options)
    end

    # This is documentation for **AWS CloudHSM Classic**. For more
    # information, see [AWS CloudHSM Classic FAQs][1], the [AWS CloudHSM
    # Classic User Guide][2], and the [AWS CloudHSM Classic API
    # Reference][3].
    #
    # **For information about the current version of AWS CloudHSM**, see
    # [AWS CloudHSM][4], the [AWS CloudHSM User Guide][5], and the [AWS
    # CloudHSM API Reference][6].
    #
    # Modifies an existing high-availability partition group.
    #
    #
    #
    # [1]: http://aws.amazon.com/cloudhsm/faqs-classic/
    # [2]: https://docs.aws.amazon.com/cloudhsm/classic/userguide/
    # [3]: https://docs.aws.amazon.com/cloudhsm/classic/APIReference/
    # [4]: http://aws.amazon.com/cloudhsm/
    # [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/
    # [6]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/
    #
    # @option params [required, String] :hapg_arn
    #   The ARN of the high-availability partition group to modify.
    #
    # @option params [String] :label
    #   The new label for the high-availability partition group.
    #
    # @option params [Array<String>] :partition_serial_list
    #   The list of partition serial numbers to make members of the
    #   high-availability partition group.
    #
    # @return [Types::ModifyHapgResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ModifyHapgResponse#hapg_arn #hapg_arn} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.modify_hapg({
    #     hapg_arn: "HapgArn", # required
    #     label: "Label",
    #     partition_serial_list: ["PartitionSerial"],
    #   })
    #
    # @example Response structure
    #
    #   resp.hapg_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyHapg AWS API Documentation
    #
    # @overload modify_hapg(params = {})
    # @param [Hash] params ({})
    def modify_hapg(params = {}, options = {})
      req = build_request(:modify_hapg, params)
      req.send_request(options)
    end

    # This is documentation for **AWS CloudHSM Classic**. For more
    # information, see [AWS CloudHSM Classic FAQs][1], the [AWS CloudHSM
    # Classic User Guide][2], and the [AWS CloudHSM Classic API
    # Reference][3].
    #
    # **For information about the current version of AWS CloudHSM**, see
    # [AWS CloudHSM][4], the [AWS CloudHSM User Guide][5], and the [AWS
    # CloudHSM API Reference][6].
    #
    # Modifies an HSM.
    #
    # This operation can result in the HSM being offline for up to 15
    # minutes while the AWS CloudHSM service is reconfigured. If you are
    # modifying a production HSM, you should ensure that your AWS CloudHSM
    # service is configured for high availability, and consider executing
    # this operation during a maintenance window.
    #
    #
    #
    # [1]: http://aws.amazon.com/cloudhsm/faqs-classic/
    # [2]: https://docs.aws.amazon.com/cloudhsm/classic/userguide/
    # [3]: https://docs.aws.amazon.com/cloudhsm/classic/APIReference/
    # [4]: http://aws.amazon.com/cloudhsm/
    # [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/
    # [6]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/
    #
    # @option params [required, String] :hsm_arn
    #   The ARN of the HSM to modify.
    #
    # @option params [String] :subnet_id
    #   The new identifier of the subnet that the HSM is in. The new subnet
    #   must be in the same Availability Zone as the current subnet.
    #
    # @option params [String] :eni_ip
    #   The new IP address for the elastic network interface (ENI) attached to
    #   the HSM.
    #
    #   If the HSM is moved to a different subnet, and an IP address is not
    #   specified, an IP address will be randomly chosen from the CIDR range
    #   of the new subnet.
    #
    # @option params [String] :iam_role_arn
    #   The new IAM role ARN.
    #
    # @option params [String] :external_id
    #   The new external ID.
    #
    # @option params [String] :syslog_ip
    #   The new IP address for the syslog monitoring server. The AWS CloudHSM
    #   service only supports one syslog monitoring server.
    #
    # @return [Types::ModifyHsmResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ModifyHsmResponse#hsm_arn #hsm_arn} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.modify_hsm({
    #     hsm_arn: "HsmArn", # required
    #     subnet_id: "SubnetId",
    #     eni_ip: "IpAddress",
    #     iam_role_arn: "IamRoleArn",
    #     external_id: "ExternalId",
    #     syslog_ip: "IpAddress",
    #   })
    #
    # @example Response structure
    #
    #   resp.hsm_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyHsm AWS API Documentation
    #
    # @overload modify_hsm(params = {})
    # @param [Hash] params ({})
    def modify_hsm(params = {}, options = {})
      req = build_request(:modify_hsm, params)
      req.send_request(options)
    end

    # This is documentation for **AWS CloudHSM Classic**. For more
    # information, see [AWS CloudHSM Classic FAQs][1], the [AWS CloudHSM
    # Classic User Guide][2], and the [AWS CloudHSM Classic API
    # Reference][3].
    #
    # **For information about the current version of AWS CloudHSM**, see
    # [AWS CloudHSM][4], the [AWS CloudHSM User Guide][5], and the [AWS
    # CloudHSM API Reference][6].
    #
    # Modifies the certificate used by the client.
    #
    # This action can potentially start a workflow to install the new
    # certificate on the client's HSMs.
    #
    #
    #
    # [1]: http://aws.amazon.com/cloudhsm/faqs-classic/
    # [2]: https://docs.aws.amazon.com/cloudhsm/classic/userguide/
    # [3]: https://docs.aws.amazon.com/cloudhsm/classic/APIReference/
    # [4]: http://aws.amazon.com/cloudhsm/
    # [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/
    # [6]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/
    #
    # @option params [required, String] :client_arn
    #   The ARN of the client.
    #
    # @option params [required, String] :certificate
    #   The new certificate for the client.
    #
    # @return [Types::ModifyLunaClientResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ModifyLunaClientResponse#client_arn #client_arn} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.modify_luna_client({
    #     client_arn: "ClientArn", # required
    #     certificate: "Certificate", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.client_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyLunaClient AWS API Documentation
    #
    # @overload modify_luna_client(params = {})
    # @param [Hash] params ({})
    def modify_luna_client(params = {}, options = {})
      req = build_request(:modify_luna_client, params)
      req.send_request(options)
    end

    # This is documentation for **AWS CloudHSM Classic**. For more
    # information, see [AWS CloudHSM Classic FAQs][1], the [AWS CloudHSM
    # Classic User Guide][2], and the [AWS CloudHSM Classic API
    # Reference][3].
    #
    # **For information about the current version of AWS CloudHSM**, see
    # [AWS CloudHSM][4], the [AWS CloudHSM User Guide][5], and the [AWS
    # CloudHSM API Reference][6].
    #
    # Removes one or more tags from the specified AWS CloudHSM resource.
    #
    # To remove a tag, specify only the tag key to remove (not the value).
    # To overwrite the value for an existing tag, use AddTagsToResource.
    #
    #
    #
    # [1]: http://aws.amazon.com/cloudhsm/faqs-classic/
    # [2]: https://docs.aws.amazon.com/cloudhsm/classic/userguide/
    # [3]: https://docs.aws.amazon.com/cloudhsm/classic/APIReference/
    # [4]: http://aws.amazon.com/cloudhsm/
    # [5]: https://docs.aws.amazon.com/cloudhsm/latest/userguide/
    # [6]: https://docs.aws.amazon.com/cloudhsm/latest/APIReference/
    #
    # @option params [required, String] :resource_arn
    #   The Amazon Resource Name (ARN) of the AWS CloudHSM resource.
    #
    # @option params [required, Array<String>] :tag_key_list
    #   The tag key or keys to remove.
    #
    #   Specify only the tag key to remove (not the value). To overwrite the
    #   value for an existing tag, use AddTagsToResource.
    #
    # @return [Types::RemoveTagsFromResourceResponse] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::RemoveTagsFromResourceResponse#status #status} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.remove_tags_from_resource({
    #     resource_arn: "String", # required
    #     tag_key_list: ["TagKey"], # required
    #   })
    #
    # @example Response structure
    #
    #   resp.status #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/RemoveTagsFromResource AWS API Documentation
    #
    # @overload remove_tags_from_resource(params = {})
    # @param [Hash] params ({})
    def remove_tags_from_resource(params = {}, options = {})
      req = build_request(:remove_tags_from_resource, params)
      req.send_request(options)
    end

    # @!endgroup

    # @param params ({})
    # @api private
    def build_request(operation_name, params = {})
      handlers = @handlers.for(operation_name)
      tracer = config.telemetry_provider.tracer_provider.tracer(
        Aws::Telemetry.module_to_tracer_name('Aws::CloudHSM')
      )
      context = Seahorse::Client::RequestContext.new(
        operation_name: operation_name,
        operation: config.api.operation(operation_name),
        client: self,
        params: params,
        config: config,
        tracer: tracer
      )
      context[:gem_name] = 'aws-sdk-cloudhsm'
      context[:gem_version] = '1.70.0'
      Seahorse::Client::Request.new(handlers, context)
    end

    # @api private
    # @deprecated
    def waiter_names
      []
    end

    class << self

      # @api private
      attr_reader :identifier

      # @api private
      def errors_module
        Errors
      end

    end
  end
end
