# frozen_string_literal: true

# WARNING ABOUT GENERATED CODE
#
# This file is generated. See the contributing guide for more information:
# https://github.com/aws/aws-sdk-ruby/blob/version-3/CONTRIBUTING.md
#
# WARNING ABOUT GENERATED CODE

require 'seahorse/client/plugins/content_length'
require 'aws-sdk-core/plugins/credentials_configuration'
require 'aws-sdk-core/plugins/logging'
require 'aws-sdk-core/plugins/param_converter'
require 'aws-sdk-core/plugins/param_validator'
require 'aws-sdk-core/plugins/user_agent'
require 'aws-sdk-core/plugins/helpful_socket_errors'
require 'aws-sdk-core/plugins/retry_errors'
require 'aws-sdk-core/plugins/global_configuration'
require 'aws-sdk-core/plugins/regional_endpoint'
require 'aws-sdk-core/plugins/endpoint_discovery'
require 'aws-sdk-core/plugins/endpoint_pattern'
require 'aws-sdk-core/plugins/response_paging'
require 'aws-sdk-core/plugins/stub_responses'
require 'aws-sdk-core/plugins/idempotency_token'
require 'aws-sdk-core/plugins/invocation_id'
require 'aws-sdk-core/plugins/jsonvalue_converter'
require 'aws-sdk-core/plugins/client_metrics_plugin'
require 'aws-sdk-core/plugins/client_metrics_send_plugin'
require 'aws-sdk-core/plugins/transfer_encoding'
require 'aws-sdk-core/plugins/http_checksum'
require 'aws-sdk-core/plugins/checksum_algorithm'
require 'aws-sdk-core/plugins/request_compression'
require 'aws-sdk-core/plugins/defaults_mode'
require 'aws-sdk-core/plugins/recursion_detection'
require 'aws-sdk-core/plugins/telemetry'
require 'aws-sdk-core/plugins/sign'
require 'aws-sdk-core/plugins/protocols/json_rpc'
require 'aws-sdk-core/plugins/event_stream_configuration'

module Aws::Kinesis
  # An API client for Kinesis.  To construct a client, you need to configure a `:region` and `:credentials`.
  #
  #     client = Aws::Kinesis::Client.new(
  #       region: region_name,
  #       credentials: credentials,
  #       # ...
  #     )
  #
  # For details on configuring region and credentials see
  # the [developer guide](/sdk-for-ruby/v3/developer-guide/setup-config.html).
  #
  # See {#initialize} for a full list of supported configuration options.
  class Client < Seahorse::Client::Base

    include Aws::ClientStubs

    @identifier = :kinesis

    set_api(ClientApi::API)

    add_plugin(Seahorse::Client::Plugins::ContentLength)
    add_plugin(Aws::Plugins::CredentialsConfiguration)
    add_plugin(Aws::Plugins::Logging)
    add_plugin(Aws::Plugins::ParamConverter)
    add_plugin(Aws::Plugins::ParamValidator)
    add_plugin(Aws::Plugins::UserAgent)
    add_plugin(Aws::Plugins::HelpfulSocketErrors)
    add_plugin(Aws::Plugins::RetryErrors)
    add_plugin(Aws::Plugins::GlobalConfiguration)
    add_plugin(Aws::Plugins::RegionalEndpoint)
    add_plugin(Aws::Plugins::EndpointDiscovery)
    add_plugin(Aws::Plugins::EndpointPattern)
    add_plugin(Aws::Plugins::ResponsePaging)
    add_plugin(Aws::Plugins::StubResponses)
    add_plugin(Aws::Plugins::IdempotencyToken)
    add_plugin(Aws::Plugins::InvocationId)
    add_plugin(Aws::Plugins::JsonvalueConverter)
    add_plugin(Aws::Plugins::ClientMetricsPlugin)
    add_plugin(Aws::Plugins::ClientMetricsSendPlugin)
    add_plugin(Aws::Plugins::TransferEncoding)
    add_plugin(Aws::Plugins::HttpChecksum)
    add_plugin(Aws::Plugins::ChecksumAlgorithm)
    add_plugin(Aws::Plugins::RequestCompression)
    add_plugin(Aws::Plugins::DefaultsMode)
    add_plugin(Aws::Plugins::RecursionDetection)
    add_plugin(Aws::Plugins::Telemetry)
    add_plugin(Aws::Plugins::Sign)
    add_plugin(Aws::Plugins::Protocols::JsonRpc)
    add_plugin(Aws::Plugins::EventStreamConfiguration)
    add_plugin(Aws::Kinesis::Plugins::Endpoints)

    # @overload initialize(options)
    #   @param [Hash] options
    #
    #   @option options [Array<Seahorse::Client::Plugin>] :plugins ([]])
    #     A list of plugins to apply to the client. Each plugin is either a
    #     class name or an instance of a plugin class.
    #
    #   @option options [required, Aws::CredentialProvider] :credentials
    #     Your AWS credentials. This can be an instance of any one of the
    #     following classes:
    #
    #     * `Aws::Credentials` - Used for configuring static, non-refreshing
    #       credentials.
    #
    #     * `Aws::SharedCredentials` - Used for loading static credentials from a
    #       shared file, such as `~/.aws/config`.
    #
    #     * `Aws::AssumeRoleCredentials` - Used when you need to assume a role.
    #
    #     * `Aws::AssumeRoleWebIdentityCredentials` - Used when you need to
    #       assume a role after providing credentials via the web.
    #
    #     * `Aws::SSOCredentials` - Used for loading credentials from AWS SSO using an
    #       access token generated from `aws login`.
    #
    #     * `Aws::ProcessCredentials` - Used for loading credentials from a
    #       process that outputs to stdout.
    #
    #     * `Aws::InstanceProfileCredentials` - Used for loading credentials
    #       from an EC2 IMDS on an EC2 instance.
    #
    #     * `Aws::ECSCredentials` - Used for loading credentials from
    #       instances running in ECS.
    #
    #     * `Aws::CognitoIdentityCredentials` - Used for loading credentials
    #       from the Cognito Identity service.
    #
    #     When `:credentials` are not configured directly, the following
    #     locations will be searched for credentials:
    #
    #     * `Aws.config[:credentials]`
    #     * The `:access_key_id`, `:secret_access_key`, `:session_token`, and
    #       `:account_id` options.
    #     * ENV['AWS_ACCESS_KEY_ID'], ENV['AWS_SECRET_ACCESS_KEY'],
    #       ENV['AWS_SESSION_TOKEN'], and ENV['AWS_ACCOUNT_ID']
    #     * `~/.aws/credentials`
    #     * `~/.aws/config`
    #     * EC2/ECS IMDS instance profile - When used by default, the timeouts
    #       are very aggressive. Construct and pass an instance of
    #       `Aws::InstanceProfileCredentials` or `Aws::ECSCredentials` to
    #       enable retries and extended timeouts. Instance profile credential
    #       fetching can be disabled by setting ENV['AWS_EC2_METADATA_DISABLED']
    #       to true.
    #
    #   @option options [required, String] :region
    #     The AWS region to connect to.  The configured `:region` is
    #     used to determine the service `:endpoint`. When not passed,
    #     a default `:region` is searched for in the following locations:
    #
    #     * `Aws.config[:region]`
    #     * `ENV['AWS_REGION']`
    #     * `ENV['AMAZON_REGION']`
    #     * `ENV['AWS_DEFAULT_REGION']`
    #     * `~/.aws/credentials`
    #     * `~/.aws/config`
    #
    #   @option options [String] :access_key_id
    #
    #   @option options [String] :account_id
    #
    #   @option options [Boolean] :active_endpoint_cache (false)
    #     When set to `true`, a thread polling for endpoints will be running in
    #     the background every 60 secs (default). Defaults to `false`.
    #
    #   @option options [Boolean] :adaptive_retry_wait_to_fill (true)
    #     Used only in `adaptive` retry mode.  When true, the request will sleep
    #     until there is sufficent client side capacity to retry the request.
    #     When false, the request will raise a `RetryCapacityNotAvailableError` and will
    #     not retry instead of sleeping.
    #
    #   @option options [Boolean] :client_side_monitoring (false)
    #     When `true`, client-side metrics will be collected for all API requests from
    #     this client.
    #
    #   @option options [String] :client_side_monitoring_client_id ("")
    #     Allows you to provide an identifier for this client which will be attached to
    #     all generated client side metrics. Defaults to an empty string.
    #
    #   @option options [String] :client_side_monitoring_host ("127.0.0.1")
    #     Allows you to specify the DNS hostname or IPv4 or IPv6 address that the client
    #     side monitoring agent is running on, where client metrics will be published via UDP.
    #
    #   @option options [Integer] :client_side_monitoring_port (31000)
    #     Required for publishing client metrics. The port that the client side monitoring
    #     agent is running on, where client metrics will be published via UDP.
    #
    #   @option options [Aws::ClientSideMonitoring::Publisher] :client_side_monitoring_publisher (Aws::ClientSideMonitoring::Publisher)
    #     Allows you to provide a custom client-side monitoring publisher class. By default,
    #     will use the Client Side Monitoring Agent Publisher.
    #
    #   @option options [Boolean] :convert_params (true)
    #     When `true`, an attempt is made to coerce request parameters into
    #     the required types.
    #
    #   @option options [Boolean] :correct_clock_skew (true)
    #     Used only in `standard` and adaptive retry modes. Specifies whether to apply
    #     a clock skew correction and retry requests with skewed client clocks.
    #
    #   @option options [String] :defaults_mode ("legacy")
    #     See {Aws::DefaultsModeConfiguration} for a list of the
    #     accepted modes and the configuration defaults that are included.
    #
    #   @option options [Boolean] :disable_host_prefix_injection (false)
    #     When `true`, the SDK will not prepend the modeled host prefix to the endpoint.
    #
    #   @option options [Boolean] :disable_request_compression (false)
    #     When set to 'true' the request body will not be compressed
    #     for supported operations.
    #
    #   @option options [String, URI::HTTPS, URI::HTTP] :endpoint
    #     Normally you should not configure the `:endpoint` option
    #     directly. This is normally constructed from the `:region`
    #     option. Configuring `:endpoint` is normally reserved for
    #     connecting to test or custom endpoints. The endpoint should
    #     be a URI formatted like:
    #
    #         'http://example.com'
    #         'https://example.com'
    #         'http://example.com:123'
    #
    #   @option options [Integer] :endpoint_cache_max_entries (1000)
    #     Used for the maximum size limit of the LRU cache storing endpoints data
    #     for endpoint discovery enabled operations. Defaults to 1000.
    #
    #   @option options [Integer] :endpoint_cache_max_threads (10)
    #     Used for the maximum threads in use for polling endpoints to be cached, defaults to 10.
    #
    #   @option options [Integer] :endpoint_cache_poll_interval (60)
    #     When :endpoint_discovery and :active_endpoint_cache is enabled,
    #     Use this option to config the time interval in seconds for making
    #     requests fetching endpoints information. Defaults to 60 sec.
    #
    #   @option options [Boolean] :endpoint_discovery (false)
    #     When set to `true`, endpoint discovery will be enabled for operations when available.
    #
    #   @option options [Proc] :event_stream_handler
    #     When an EventStream or Proc object is provided, it will be used as callback for each chunk of event stream response received along the way.
    #
    #   @option options [Boolean] :ignore_configured_endpoint_urls
    #     Setting to true disables use of endpoint URLs provided via environment
    #     variables and the shared configuration file.
    #
    #   @option options [Proc] :input_event_stream_handler
    #     When an EventStream or Proc object is provided, it can be used for sending events for the event stream.
    #
    #   @option options [Aws::Log::Formatter] :log_formatter (Aws::Log::Formatter.default)
    #     The log formatter.
    #
    #   @option options [Symbol] :log_level (:info)
    #     The log level to send messages to the `:logger` at.
    #
    #   @option options [Logger] :logger
    #     The Logger instance to send log messages to.  If this option
    #     is not set, logging will be disabled.
    #
    #   @option options [Integer] :max_attempts (3)
    #     An integer representing the maximum number attempts that will be made for
    #     a single request, including the initial attempt.  For example,
    #     setting this value to 5 will result in a request being retried up to
    #     4 times. Used in `standard` and `adaptive` retry modes.
    #
    #   @option options [Proc] :output_event_stream_handler
    #     When an EventStream or Proc object is provided, it will be used as callback for each chunk of event stream response received along the way.
    #
    #   @option options [String] :profile ("default")
    #     Used when loading credentials from the shared credentials file
    #     at HOME/.aws/credentials.  When not specified, 'default' is used.
    #
    #   @option options [String] :request_checksum_calculation ("when_supported")
    #     Determines when a checksum will be calculated for request payloads. Values are:
    #
    #     * `when_supported` - (default) When set, a checksum will be
    #       calculated for all request payloads of operations modeled with the
    #       `httpChecksum` trait where `requestChecksumRequired` is `true` and/or a
    #       `requestAlgorithmMember` is modeled.
    #     * `when_required` - When set, a checksum will only be calculated for
    #       request payloads of operations modeled with the  `httpChecksum` trait where
    #       `requestChecksumRequired` is `true` or where a `requestAlgorithmMember`
    #       is modeled and supplied.
    #
    #   @option options [Integer] :request_min_compression_size_bytes (10240)
    #     The minimum size in bytes that triggers compression for request
    #     bodies. The value must be non-negative integer value between 0
    #     and 10485780 bytes inclusive.
    #
    #   @option options [String] :response_checksum_validation ("when_supported")
    #     Determines when checksum validation will be performed on response payloads. Values are:
    #
    #     * `when_supported` - (default) When set, checksum validation is performed on all
    #       response payloads of operations modeled with the `httpChecksum` trait where
    #       `responseAlgorithms` is modeled, except when no modeled checksum algorithms
    #       are supported.
    #     * `when_required` - When set, checksum validation is not performed on
    #       response payloads of operations unless the checksum algorithm is supported and
    #       the `requestValidationModeMember` member is set to `ENABLED`.
    #
    #   @option options [Proc] :retry_backoff
    #     A proc or lambda used for backoff. Defaults to 2**retries * retry_base_delay.
    #     This option is only used in the `legacy` retry mode.
    #
    #   @option options [Float] :retry_base_delay (0.3)
    #     The base delay in seconds used by the default backoff function. This option
    #     is only used in the `legacy` retry mode.
    #
    #   @option options [Symbol] :retry_jitter (:none)
    #     A delay randomiser function used by the default backoff function.
    #     Some predefined functions can be referenced by name - :none, :equal, :full,
    #     otherwise a Proc that takes and returns a number. This option is only used
    #     in the `legacy` retry mode.
    #
    #     @see https://www.awsarchitectureblog.com/2015/03/backoff.html
    #
    #   @option options [Integer] :retry_limit (3)
    #     The maximum number of times to retry failed requests.  Only
    #     ~ 500 level server errors and certain ~ 400 level client errors
    #     are retried.  Generally, these are throttling errors, data
    #     checksum errors, networking errors, timeout errors, auth errors,
    #     endpoint discovery, and errors from expired credentials.
    #     This option is only used in the `legacy` retry mode.
    #
    #   @option options [Integer] :retry_max_delay (0)
    #     The maximum number of seconds to delay between retries (0 for no limit)
    #     used by the default backoff function. This option is only used in the
    #     `legacy` retry mode.
    #
    #   @option options [String] :retry_mode ("legacy")
    #     Specifies which retry algorithm to use. Values are:
    #
    #     * `legacy` - The pre-existing retry behavior.  This is default value if
    #       no retry mode is provided.
    #
    #     * `standard` - A standardized set of retry rules across the AWS SDKs.
    #       This includes support for retry quotas, which limit the number of
    #       unsuccessful retries a client can make.
    #
    #     * `adaptive` - An experimental retry mode that includes all the
    #       functionality of `standard` mode along with automatic client side
    #       throttling.  This is a provisional mode that may change behavior
    #       in the future.
    #
    #   @option options [String] :sdk_ua_app_id
    #     A unique and opaque application ID that is appended to the
    #     User-Agent header as app/sdk_ua_app_id. It should have a
    #     maximum length of 50. This variable is sourced from environment
    #     variable AWS_SDK_UA_APP_ID or the shared config profile attribute sdk_ua_app_id.
    #
    #   @option options [String] :secret_access_key
    #
    #   @option options [String] :session_token
    #
    #   @option options [Array] :sigv4a_signing_region_set
    #     A list of regions that should be signed with SigV4a signing. When
    #     not passed, a default `:sigv4a_signing_region_set` is searched for
    #     in the following locations:
    #
    #     * `Aws.config[:sigv4a_signing_region_set]`
    #     * `ENV['AWS_SIGV4A_SIGNING_REGION_SET']`
    #     * `~/.aws/config`
    #
    #   @option options [Boolean] :simple_json (false)
    #     Disables request parameter conversion, validation, and formatting.
    #     Also disables response data type conversions. The request parameters
    #     hash must be formatted exactly as the API expects.This option is useful
    #     when you want to ensure the highest level of performance by avoiding
    #     overhead of walking request parameters and response data structures.
    #
    #   @option options [Boolean] :stub_responses (false)
    #     Causes the client to return stubbed responses. By default
    #     fake responses are generated and returned. You can specify
    #     the response data to return or errors to raise by calling
    #     {ClientStubs#stub_responses}. See {ClientStubs} for more information.
    #
    #     ** Please note ** When response stubbing is enabled, no HTTP
    #     requests are made, and retries are disabled.
    #
    #   @option options [Aws::Telemetry::TelemetryProviderBase] :telemetry_provider (Aws::Telemetry::NoOpTelemetryProvider)
    #     Allows you to provide a telemetry provider, which is used to
    #     emit telemetry data. By default, uses `NoOpTelemetryProvider` which
    #     will not record or emit any telemetry data. The SDK supports the
    #     following telemetry providers:
    #
    #     * OpenTelemetry (OTel) - To use the OTel provider, install and require the
    #     `opentelemetry-sdk` gem and then, pass in an instance of a
    #     `Aws::Telemetry::OTelProvider` for telemetry provider.
    #
    #   @option options [Aws::TokenProvider] :token_provider
    #     A Bearer Token Provider. This can be an instance of any one of the
    #     following classes:
    #
    #     * `Aws::StaticTokenProvider` - Used for configuring static, non-refreshing
    #       tokens.
    #
    #     * `Aws::SSOTokenProvider` - Used for loading tokens from AWS SSO using an
    #       access token generated from `aws login`.
    #
    #     When `:token_provider` is not configured directly, the `Aws::TokenProviderChain`
    #     will be used to search for tokens configured for your profile in shared configuration files.
    #
    #   @option options [Boolean] :use_dualstack_endpoint
    #     When set to `true`, dualstack enabled endpoints (with `.aws` TLD)
    #     will be used if available.
    #
    #   @option options [Boolean] :use_fips_endpoint
    #     When set to `true`, fips compatible endpoints will be used if available.
    #     When a `fips` region is used, the region is normalized and this config
    #     is set to `true`.
    #
    #   @option options [Boolean] :validate_params (true)
    #     When `true`, request parameters are validated before
    #     sending the request.
    #
    #   @option options [Aws::Kinesis::EndpointProvider] :endpoint_provider
    #     The endpoint provider used to resolve endpoints. Any object that responds to
    #     `#resolve_endpoint(parameters)` where `parameters` is a Struct similar to
    #     `Aws::Kinesis::EndpointParameters`.
    #
    #   @option options [Float] :http_continue_timeout (1)
    #     The number of seconds to wait for a 100-continue response before sending the
    #     request body.  This option has no effect unless the request has "Expect"
    #     header set to "100-continue".  Defaults to `nil` which  disables this
    #     behaviour.  This value can safely be set per request on the session.
    #
    #   @option options [Float] :http_idle_timeout (5)
    #     The number of seconds a connection is allowed to sit idle before it
    #     is considered stale.  Stale connections are closed and removed from the
    #     pool before making a request.
    #
    #   @option options [Float] :http_open_timeout (15)
    #     The default number of seconds to wait for response data.
    #     This value can safely be set per-request on the session.
    #
    #   @option options [URI::HTTP,String] :http_proxy
    #     A proxy to send requests through.  Formatted like 'http://proxy.com:123'.
    #
    #   @option options [Float] :http_read_timeout (60)
    #     The default number of seconds to wait for response data.
    #     This value can safely be set per-request on the session.
    #
    #   @option options [Boolean] :http_wire_trace (false)
    #     When `true`,  HTTP debug output will be sent to the `:logger`.
    #
    #   @option options [Proc] :on_chunk_received
    #     When a Proc object is provided, it will be used as callback when each chunk
    #     of the response body is received. It provides three arguments: the chunk,
    #     the number of bytes received, and the total number of
    #     bytes in the response (or nil if the server did not send a `content-length`).
    #
    #   @option options [Proc] :on_chunk_sent
    #     When a Proc object is provided, it will be used as callback when each chunk
    #     of the request body is sent. It provides three arguments: the chunk,
    #     the number of bytes read from the body, and the total number of
    #     bytes in the body.
    #
    #   @option options [Boolean] :raise_response_errors (true)
    #     When `true`, response errors are raised.
    #
    #   @option options [String] :ssl_ca_bundle
    #     Full path to the SSL certificate authority bundle file that should be used when
    #     verifying peer certificates.  If you do not pass `:ssl_ca_bundle` or
    #     `:ssl_ca_directory` the the system default will be used if available.
    #
    #   @option options [String] :ssl_ca_directory
    #     Full path of the directory that contains the unbundled SSL certificate
    #     authority files for verifying peer certificates.  If you do
    #     not pass `:ssl_ca_bundle` or `:ssl_ca_directory` the the system
    #     default will be used if available.
    #
    #   @option options [String] :ssl_ca_store
    #     Sets the X509::Store to verify peer certificate.
    #
    #   @option options [OpenSSL::X509::Certificate] :ssl_cert
    #     Sets a client certificate when creating http connections.
    #
    #   @option options [OpenSSL::PKey] :ssl_key
    #     Sets a client key when creating http connections.
    #
    #   @option options [Float] :ssl_timeout
    #     Sets the SSL timeout in seconds
    #
    #   @option options [Boolean] :ssl_verify_peer (true)
    #     When `true`, SSL peer certificates are verified when establishing a connection.
    #
    def initialize(*args)
      super
    end

    # @!group API Operations

    # Adds or updates tags for the specified Kinesis data stream. You can
    # assign up to 50 tags to a data stream.
    #
    # <note markdown="1"> When invoking this API, you must use either the `StreamARN` or the
    # `StreamName` parameter, or both. It is recommended that you use the
    # `StreamARN` input parameter when you invoke this API.
    #
    #  </note>
    #
    # If tags have already been assigned to the stream, `AddTagsToStream`
    # overwrites any existing tags that correspond to the specified tag
    # keys.
    #
    # AddTagsToStream has a limit of five transactions per second per
    # account.
    #
    # @option params [String] :stream_name
    #   The name of the stream.
    #
    # @option params [required, Hash<String,String>] :tags
    #   A set of up to 50 key-value pairs to use to create the tags. A tag
    #   consists of a required key and an optional value. You can add up to 50
    #   tags per resource.
    #
    # @option params [String] :stream_arn
    #   The ARN of the stream.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.add_tags_to_stream({
    #     stream_name: "StreamName",
    #     tags: { # required
    #       "TagKey" => "TagValue",
    #     },
    #     stream_arn: "StreamARN",
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/AddTagsToStream AWS API Documentation
    #
    # @overload add_tags_to_stream(params = {})
    # @param [Hash] params ({})
    def add_tags_to_stream(params = {}, options = {})
      req = build_request(:add_tags_to_stream, params)
      req.send_request(options)
    end

    # Creates a Kinesis data stream. A stream captures and transports data
    # records that are continuously emitted from different data sources or
    # *producers*. Scale-out within a stream is explicitly supported by
    # means of shards, which are uniquely identified groups of data records
    # in a stream.
    #
    # You can create your data stream using either on-demand or provisioned
    # capacity mode. Data streams with an on-demand mode require no capacity
    # planning and automatically scale to handle gigabytes of write and read
    # throughput per minute. With the on-demand mode, Kinesis Data Streams
    # automatically manages the shards in order to provide the necessary
    # throughput. For the data streams with a provisioned mode, you must
    # specify the number of shards for the data stream. Each shard can
    # support reads up to five transactions per second, up to a maximum data
    # read total of 2 MiB per second. Each shard can support writes up to
    # 1,000 records per second, up to a maximum data write total of 1 MiB
    # per second. If the amount of data input increases or decreases, you
    # can add or remove shards.
    #
    # The stream name identifies the stream. The name is scoped to the
    # Amazon Web Services account used by the application. It is also scoped
    # by Amazon Web Services Region. That is, two streams in two different
    # accounts can have the same name, and two streams in the same account,
    # but in two different Regions, can have the same name.
    #
    # `CreateStream` is an asynchronous operation. Upon receiving a
    # `CreateStream` request, Kinesis Data Streams immediately returns and
    # sets the stream status to `CREATING`. After the stream is created,
    # Kinesis Data Streams sets the stream status to `ACTIVE`. You should
    # perform read and write operations only on an `ACTIVE` stream.
    #
    # You receive a `LimitExceededException` when making a `CreateStream`
    # request when you try to do one of the following:
    #
    # * Have more than five streams in the `CREATING` state at any point in
    #   time.
    #
    # * Create more shards than are authorized for your account.
    #
    # For the default shard limit for an Amazon Web Services account, see
    # [Amazon Kinesis Data Streams Limits][1] in the *Amazon Kinesis Data
    # Streams Developer Guide*. To increase this limit, [contact Amazon Web
    # Services Support][2].
    #
    # You can use DescribeStreamSummary to check the stream status, which is
    # returned in `StreamStatus`.
    #
    # CreateStream has a limit of five transactions per second per account.
    #
    # You can add tags to the stream when making a `CreateStream` request by
    # setting the `Tags` parameter. If you pass the `Tags` parameter, in
    # addition to having the `kinesis:CreateStream` permission, you must
    # also have the `kinesis:AddTagsToStream` permission for the stream that
    # will be created. The `kinesis:TagResource` permission won’t work to
    # tag streams on creation. Tags will take effect from the `CREATING`
    # status of the stream, but you can't make any updates to the tags
    # until the stream is in `ACTIVE` state.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html
    # [2]: https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html
    #
    # @option params [required, String] :stream_name
    #   A name to identify the stream. The stream name is scoped to the Amazon
    #   Web Services account used by the application that creates the stream.
    #   It is also scoped by Amazon Web Services Region. That is, two streams
    #   in two different Amazon Web Services accounts can have the same name.
    #   Two streams in the same Amazon Web Services account but in two
    #   different Regions can also have the same name.
    #
    # @option params [Integer] :shard_count
    #   The number of shards that the stream will use. The throughput of the
    #   stream is a function of the number of shards; more shards are required
    #   for greater provisioned throughput.
    #
    # @option params [Types::StreamModeDetails] :stream_mode_details
    #   Indicates the capacity mode of the data stream. Currently, in Kinesis
    #   Data Streams, you can choose between an **on-demand** capacity mode
    #   and a **provisioned** capacity mode for your data streams.
    #
    # @option params [Hash<String,String>] :tags
    #   A set of up to 50 key-value pairs to use to create the tags. A tag
    #   consists of a required key and an optional value.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.create_stream({
    #     stream_name: "StreamName", # required
    #     shard_count: 1,
    #     stream_mode_details: {
    #       stream_mode: "PROVISIONED", # required, accepts PROVISIONED, ON_DEMAND
    #     },
    #     tags: {
    #       "TagKey" => "TagValue",
    #     },
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/CreateStream AWS API Documentation
    #
    # @overload create_stream(params = {})
    # @param [Hash] params ({})
    def create_stream(params = {}, options = {})
      req = build_request(:create_stream, params)
      req.send_request(options)
    end

    # Decreases the Kinesis data stream's retention period, which is the
    # length of time data records are accessible after they are added to the
    # stream. The minimum value of a stream's retention period is 24 hours.
    #
    # <note markdown="1"> When invoking this API, you must use either the `StreamARN` or the
    # `StreamName` parameter, or both. It is recommended that you use the
    # `StreamARN` input parameter when you invoke this API.
    #
    #  </note>
    #
    # This operation may result in lost data. For example, if the stream's
    # retention period is 48 hours and is decreased to 24 hours, any data
    # already in the stream that is older than 24 hours is inaccessible.
    #
    # @option params [String] :stream_name
    #   The name of the stream to modify.
    #
    # @option params [required, Integer] :retention_period_hours
    #   The new retention period of the stream, in hours. Must be less than
    #   the current retention period.
    #
    # @option params [String] :stream_arn
    #   The ARN of the stream.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.decrease_stream_retention_period({
    #     stream_name: "StreamName",
    #     retention_period_hours: 1, # required
    #     stream_arn: "StreamARN",
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DecreaseStreamRetentionPeriod AWS API Documentation
    #
    # @overload decrease_stream_retention_period(params = {})
    # @param [Hash] params ({})
    def decrease_stream_retention_period(params = {}, options = {})
      req = build_request(:decrease_stream_retention_period, params)
      req.send_request(options)
    end

    # Delete a policy for the specified data stream or consumer. Request
    # patterns can be one of the following:
    #
    # * Data stream pattern: `arn:aws.*:kinesis:.*:\d{12}:.*stream/\S+`
    #
    # * Consumer pattern:
    #   `^(arn):aws.*:kinesis:.*:\d{12}:.*stream\/[a-zA-Z0-9_.-]+\/consumer\/[a-zA-Z0-9_.-]+:[0-9]+`
    #
    # @option params [required, String] :resource_arn
    #   The Amazon Resource Name (ARN) of the data stream or consumer.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_resource_policy({
    #     resource_arn: "ResourceARN", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DeleteResourcePolicy AWS API Documentation
    #
    # @overload delete_resource_policy(params = {})
    # @param [Hash] params ({})
    def delete_resource_policy(params = {}, options = {})
      req = build_request(:delete_resource_policy, params)
      req.send_request(options)
    end

    # Deletes a Kinesis data stream and all its shards and data. You must
    # shut down any applications that are operating on the stream before you
    # delete the stream. If an application attempts to operate on a deleted
    # stream, it receives the exception `ResourceNotFoundException`.
    #
    # <note markdown="1"> When invoking this API, you must use either the `StreamARN` or the
    # `StreamName` parameter, or both. It is recommended that you use the
    # `StreamARN` input parameter when you invoke this API.
    #
    #  </note>
    #
    # If the stream is in the `ACTIVE` state, you can delete it. After a
    # `DeleteStream` request, the specified stream is in the `DELETING`
    # state until Kinesis Data Streams completes the deletion.
    #
    # **Note:** Kinesis Data Streams might continue to accept data read and
    # write operations, such as PutRecord, PutRecords, and GetRecords, on a
    # stream in the `DELETING` state until the stream deletion is complete.
    #
    # When you delete a stream, any shards in that stream are also deleted,
    # and any tags are dissociated from the stream.
    #
    # You can use the DescribeStreamSummary operation to check the state of
    # the stream, which is returned in `StreamStatus`.
    #
    # DeleteStream has a limit of five transactions per second per account.
    #
    # @option params [String] :stream_name
    #   The name of the stream to delete.
    #
    # @option params [Boolean] :enforce_consumer_deletion
    #   If this parameter is unset (`null`) or if you set it to `false`, and
    #   the stream has registered consumers, the call to `DeleteStream` fails
    #   with a `ResourceInUseException`.
    #
    # @option params [String] :stream_arn
    #   The ARN of the stream.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.delete_stream({
    #     stream_name: "StreamName",
    #     enforce_consumer_deletion: false,
    #     stream_arn: "StreamARN",
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DeleteStream AWS API Documentation
    #
    # @overload delete_stream(params = {})
    # @param [Hash] params ({})
    def delete_stream(params = {}, options = {})
      req = build_request(:delete_stream, params)
      req.send_request(options)
    end

    # To deregister a consumer, provide its ARN. Alternatively, you can
    # provide the ARN of the data stream and the name you gave the consumer
    # when you registered it. You may also provide all three parameters, as
    # long as they don't conflict with each other. If you don't know the
    # name or ARN of the consumer that you want to deregister, you can use
    # the ListStreamConsumers operation to get a list of the descriptions of
    # all the consumers that are currently registered with a given data
    # stream. The description of a consumer contains its name and ARN.
    #
    # This operation has a limit of five transactions per second per stream.
    #
    # @option params [String] :stream_arn
    #   The ARN of the Kinesis data stream that the consumer is registered
    #   with. For more information, see [Amazon Resource Names (ARNs) and
    #   Amazon Web Services Service Namespaces][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams
    #
    # @option params [String] :consumer_name
    #   The name that you gave to the consumer.
    #
    # @option params [String] :consumer_arn
    #   The ARN returned by Kinesis Data Streams when you registered the
    #   consumer. If you don't know the ARN of the consumer that you want to
    #   deregister, you can use the ListStreamConsumers operation to get a
    #   list of the descriptions of all the consumers that are currently
    #   registered with a given data stream. The description of a consumer
    #   contains its ARN.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.deregister_stream_consumer({
    #     stream_arn: "StreamARN",
    #     consumer_name: "ConsumerName",
    #     consumer_arn: "ConsumerARN",
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DeregisterStreamConsumer AWS API Documentation
    #
    # @overload deregister_stream_consumer(params = {})
    # @param [Hash] params ({})
    def deregister_stream_consumer(params = {}, options = {})
      req = build_request(:deregister_stream_consumer, params)
      req.send_request(options)
    end

    # Describes the shard limits and usage for the account.
    #
    # If you update your account limits, the old limits might be returned
    # for a few minutes.
    #
    # This operation has a limit of one transaction per second per account.
    #
    # @return [Types::DescribeLimitsOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeLimitsOutput#shard_limit #shard_limit} => Integer
    #   * {Types::DescribeLimitsOutput#open_shard_count #open_shard_count} => Integer
    #   * {Types::DescribeLimitsOutput#on_demand_stream_count #on_demand_stream_count} => Integer
    #   * {Types::DescribeLimitsOutput#on_demand_stream_count_limit #on_demand_stream_count_limit} => Integer
    #
    # @example Response structure
    #
    #   resp.shard_limit #=> Integer
    #   resp.open_shard_count #=> Integer
    #   resp.on_demand_stream_count #=> Integer
    #   resp.on_demand_stream_count_limit #=> Integer
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeLimits AWS API Documentation
    #
    # @overload describe_limits(params = {})
    # @param [Hash] params ({})
    def describe_limits(params = {}, options = {})
      req = build_request(:describe_limits, params)
      req.send_request(options)
    end

    # Describes the specified Kinesis data stream.
    #
    # <note markdown="1"> This API has been revised. It's highly recommended that you use the
    # DescribeStreamSummary API to get a summarized description of the
    # specified Kinesis data stream and the ListShards API to list the
    # shards in a specified data stream and obtain information about each
    # shard.
    #
    #  </note>
    #
    # <note markdown="1"> When invoking this API, you must use either the `StreamARN` or the
    # `StreamName` parameter, or both. It is recommended that you use the
    # `StreamARN` input parameter when you invoke this API.
    #
    #  </note>
    #
    # The information returned includes the stream name, Amazon Resource
    # Name (ARN), creation time, enhanced metric configuration, and shard
    # map. The shard map is an array of shard objects. For each shard
    # object, there is the hash key and sequence number ranges that the
    # shard spans, and the IDs of any earlier shards that played in a role
    # in creating the shard. Every record ingested in the stream is
    # identified by a sequence number, which is assigned when the record is
    # put into the stream.
    #
    # You can limit the number of shards returned by each call. For more
    # information, see [Retrieving Shards from a Stream][1] in the *Amazon
    # Kinesis Data Streams Developer Guide*.
    #
    # There are no guarantees about the chronological order shards returned.
    # To process shards in chronological order, use the ID of the parent
    # shard to track the lineage to the oldest shard.
    #
    # This operation has a limit of 10 transactions per second per account.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-retrieve-shards.html
    #
    # @option params [String] :stream_name
    #   The name of the stream to describe.
    #
    # @option params [Integer] :limit
    #   The maximum number of shards to return in a single call. The default
    #   value is 100. If you specify a value greater than 100, at most 100
    #   results are returned.
    #
    # @option params [String] :exclusive_start_shard_id
    #   The shard ID of the shard to start with.
    #
    #   Specify this parameter to indicate that you want to describe the
    #   stream starting with the shard whose ID immediately follows
    #   `ExclusiveStartShardId`.
    #
    #   If you don't specify this parameter, the default behavior for
    #   `DescribeStream` is to describe the stream starting with the first
    #   shard in the stream.
    #
    # @option params [String] :stream_arn
    #   The ARN of the stream.
    #
    # @return [Types::DescribeStreamOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeStreamOutput#stream_description #stream_description} => Types::StreamDescription
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_stream({
    #     stream_name: "StreamName",
    #     limit: 1,
    #     exclusive_start_shard_id: "ShardId",
    #     stream_arn: "StreamARN",
    #   })
    #
    # @example Response structure
    #
    #   resp.stream_description.stream_name #=> String
    #   resp.stream_description.stream_arn #=> String
    #   resp.stream_description.stream_status #=> String, one of "CREATING", "DELETING", "ACTIVE", "UPDATING"
    #   resp.stream_description.stream_mode_details.stream_mode #=> String, one of "PROVISIONED", "ON_DEMAND"
    #   resp.stream_description.shards #=> Array
    #   resp.stream_description.shards[0].shard_id #=> String
    #   resp.stream_description.shards[0].parent_shard_id #=> String
    #   resp.stream_description.shards[0].adjacent_parent_shard_id #=> String
    #   resp.stream_description.shards[0].hash_key_range.starting_hash_key #=> String
    #   resp.stream_description.shards[0].hash_key_range.ending_hash_key #=> String
    #   resp.stream_description.shards[0].sequence_number_range.starting_sequence_number #=> String
    #   resp.stream_description.shards[0].sequence_number_range.ending_sequence_number #=> String
    #   resp.stream_description.has_more_shards #=> Boolean
    #   resp.stream_description.retention_period_hours #=> Integer
    #   resp.stream_description.stream_creation_timestamp #=> Time
    #   resp.stream_description.enhanced_monitoring #=> Array
    #   resp.stream_description.enhanced_monitoring[0].shard_level_metrics #=> Array
    #   resp.stream_description.enhanced_monitoring[0].shard_level_metrics[0] #=> String, one of "IncomingBytes", "IncomingRecords", "OutgoingBytes", "OutgoingRecords", "WriteProvisionedThroughputExceeded", "ReadProvisionedThroughputExceeded", "IteratorAgeMilliseconds", "ALL"
    #   resp.stream_description.encryption_type #=> String, one of "NONE", "KMS"
    #   resp.stream_description.key_id #=> String
    #
    #
    # The following waiters are defined for this operation (see {Client#wait_until} for detailed usage):
    #
    #   * stream_exists
    #   * stream_not_exists
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeStream AWS API Documentation
    #
    # @overload describe_stream(params = {})
    # @param [Hash] params ({})
    def describe_stream(params = {}, options = {})
      req = build_request(:describe_stream, params)
      req.send_request(options)
    end

    # To get the description of a registered consumer, provide the ARN of
    # the consumer. Alternatively, you can provide the ARN of the data
    # stream and the name you gave the consumer when you registered it. You
    # may also provide all three parameters, as long as they don't conflict
    # with each other. If you don't know the name or ARN of the consumer
    # that you want to describe, you can use the ListStreamConsumers
    # operation to get a list of the descriptions of all the consumers that
    # are currently registered with a given data stream.
    #
    # This operation has a limit of 20 transactions per second per stream.
    #
    # <note markdown="1"> When making a cross-account call with `DescribeStreamConsumer`, make
    # sure to provide the ARN of the consumer.
    #
    #  </note>
    #
    # @option params [String] :stream_arn
    #   The ARN of the Kinesis data stream that the consumer is registered
    #   with. For more information, see [Amazon Resource Names (ARNs) and
    #   Amazon Web Services Service Namespaces][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams
    #
    # @option params [String] :consumer_name
    #   The name that you gave to the consumer.
    #
    # @option params [String] :consumer_arn
    #   The ARN returned by Kinesis Data Streams when you registered the
    #   consumer.
    #
    # @return [Types::DescribeStreamConsumerOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeStreamConsumerOutput#consumer_description #consumer_description} => Types::ConsumerDescription
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_stream_consumer({
    #     stream_arn: "StreamARN",
    #     consumer_name: "ConsumerName",
    #     consumer_arn: "ConsumerARN",
    #   })
    #
    # @example Response structure
    #
    #   resp.consumer_description.consumer_name #=> String
    #   resp.consumer_description.consumer_arn #=> String
    #   resp.consumer_description.consumer_status #=> String, one of "CREATING", "DELETING", "ACTIVE"
    #   resp.consumer_description.consumer_creation_timestamp #=> Time
    #   resp.consumer_description.stream_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeStreamConsumer AWS API Documentation
    #
    # @overload describe_stream_consumer(params = {})
    # @param [Hash] params ({})
    def describe_stream_consumer(params = {}, options = {})
      req = build_request(:describe_stream_consumer, params)
      req.send_request(options)
    end

    # Provides a summarized description of the specified Kinesis data stream
    # without the shard list.
    #
    # <note markdown="1"> When invoking this API, you must use either the `StreamARN` or the
    # `StreamName` parameter, or both. It is recommended that you use the
    # `StreamARN` input parameter when you invoke this API.
    #
    #  </note>
    #
    # The information returned includes the stream name, Amazon Resource
    # Name (ARN), status, record retention period, approximate creation
    # time, monitoring, encryption details, and open shard count.
    #
    # DescribeStreamSummary has a limit of 20 transactions per second per
    # account.
    #
    # @option params [String] :stream_name
    #   The name of the stream to describe.
    #
    # @option params [String] :stream_arn
    #   The ARN of the stream.
    #
    # @return [Types::DescribeStreamSummaryOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::DescribeStreamSummaryOutput#stream_description_summary #stream_description_summary} => Types::StreamDescriptionSummary
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.describe_stream_summary({
    #     stream_name: "StreamName",
    #     stream_arn: "StreamARN",
    #   })
    #
    # @example Response structure
    #
    #   resp.stream_description_summary.stream_name #=> String
    #   resp.stream_description_summary.stream_arn #=> String
    #   resp.stream_description_summary.stream_status #=> String, one of "CREATING", "DELETING", "ACTIVE", "UPDATING"
    #   resp.stream_description_summary.stream_mode_details.stream_mode #=> String, one of "PROVISIONED", "ON_DEMAND"
    #   resp.stream_description_summary.retention_period_hours #=> Integer
    #   resp.stream_description_summary.stream_creation_timestamp #=> Time
    #   resp.stream_description_summary.enhanced_monitoring #=> Array
    #   resp.stream_description_summary.enhanced_monitoring[0].shard_level_metrics #=> Array
    #   resp.stream_description_summary.enhanced_monitoring[0].shard_level_metrics[0] #=> String, one of "IncomingBytes", "IncomingRecords", "OutgoingBytes", "OutgoingRecords", "WriteProvisionedThroughputExceeded", "ReadProvisionedThroughputExceeded", "IteratorAgeMilliseconds", "ALL"
    #   resp.stream_description_summary.encryption_type #=> String, one of "NONE", "KMS"
    #   resp.stream_description_summary.key_id #=> String
    #   resp.stream_description_summary.open_shard_count #=> Integer
    #   resp.stream_description_summary.consumer_count #=> Integer
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeStreamSummary AWS API Documentation
    #
    # @overload describe_stream_summary(params = {})
    # @param [Hash] params ({})
    def describe_stream_summary(params = {}, options = {})
      req = build_request(:describe_stream_summary, params)
      req.send_request(options)
    end

    # Disables enhanced monitoring.
    #
    # <note markdown="1"> When invoking this API, you must use either the `StreamARN` or the
    # `StreamName` parameter, or both. It is recommended that you use the
    # `StreamARN` input parameter when you invoke this API.
    #
    #  </note>
    #
    # @option params [String] :stream_name
    #   The name of the Kinesis data stream for which to disable enhanced
    #   monitoring.
    #
    # @option params [required, Array<String>] :shard_level_metrics
    #   List of shard-level metrics to disable.
    #
    #   The following are the valid shard-level metrics. The value "`ALL`"
    #   disables every metric.
    #
    #   * `IncomingBytes`
    #
    #   * `IncomingRecords`
    #
    #   * `OutgoingBytes`
    #
    #   * `OutgoingRecords`
    #
    #   * `WriteProvisionedThroughputExceeded`
    #
    #   * `ReadProvisionedThroughputExceeded`
    #
    #   * `IteratorAgeMilliseconds`
    #
    #   * `ALL`
    #
    #   For more information, see [Monitoring the Amazon Kinesis Data Streams
    #   Service with Amazon CloudWatch][1] in the *Amazon Kinesis Data Streams
    #   Developer Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html
    #
    # @option params [String] :stream_arn
    #   The ARN of the stream.
    #
    # @return [Types::EnhancedMonitoringOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::EnhancedMonitoringOutput#stream_name #stream_name} => String
    #   * {Types::EnhancedMonitoringOutput#current_shard_level_metrics #current_shard_level_metrics} => Array&lt;String&gt;
    #   * {Types::EnhancedMonitoringOutput#desired_shard_level_metrics #desired_shard_level_metrics} => Array&lt;String&gt;
    #   * {Types::EnhancedMonitoringOutput#stream_arn #stream_arn} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.disable_enhanced_monitoring({
    #     stream_name: "StreamName",
    #     shard_level_metrics: ["IncomingBytes"], # required, accepts IncomingBytes, IncomingRecords, OutgoingBytes, OutgoingRecords, WriteProvisionedThroughputExceeded, ReadProvisionedThroughputExceeded, IteratorAgeMilliseconds, ALL
    #     stream_arn: "StreamARN",
    #   })
    #
    # @example Response structure
    #
    #   resp.stream_name #=> String
    #   resp.current_shard_level_metrics #=> Array
    #   resp.current_shard_level_metrics[0] #=> String, one of "IncomingBytes", "IncomingRecords", "OutgoingBytes", "OutgoingRecords", "WriteProvisionedThroughputExceeded", "ReadProvisionedThroughputExceeded", "IteratorAgeMilliseconds", "ALL"
    #   resp.desired_shard_level_metrics #=> Array
    #   resp.desired_shard_level_metrics[0] #=> String, one of "IncomingBytes", "IncomingRecords", "OutgoingBytes", "OutgoingRecords", "WriteProvisionedThroughputExceeded", "ReadProvisionedThroughputExceeded", "IteratorAgeMilliseconds", "ALL"
    #   resp.stream_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DisableEnhancedMonitoring AWS API Documentation
    #
    # @overload disable_enhanced_monitoring(params = {})
    # @param [Hash] params ({})
    def disable_enhanced_monitoring(params = {}, options = {})
      req = build_request(:disable_enhanced_monitoring, params)
      req.send_request(options)
    end

    # Enables enhanced Kinesis data stream monitoring for shard-level
    # metrics.
    #
    # <note markdown="1"> When invoking this API, you must use either the `StreamARN` or the
    # `StreamName` parameter, or both. It is recommended that you use the
    # `StreamARN` input parameter when you invoke this API.
    #
    #  </note>
    #
    # @option params [String] :stream_name
    #   The name of the stream for which to enable enhanced monitoring.
    #
    # @option params [required, Array<String>] :shard_level_metrics
    #   List of shard-level metrics to enable.
    #
    #   The following are the valid shard-level metrics. The value "`ALL`"
    #   enables every metric.
    #
    #   * `IncomingBytes`
    #
    #   * `IncomingRecords`
    #
    #   * `OutgoingBytes`
    #
    #   * `OutgoingRecords`
    #
    #   * `WriteProvisionedThroughputExceeded`
    #
    #   * `ReadProvisionedThroughputExceeded`
    #
    #   * `IteratorAgeMilliseconds`
    #
    #   * `ALL`
    #
    #   For more information, see [Monitoring the Amazon Kinesis Data Streams
    #   Service with Amazon CloudWatch][1] in the *Amazon Kinesis Data Streams
    #   Developer Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html
    #
    # @option params [String] :stream_arn
    #   The ARN of the stream.
    #
    # @return [Types::EnhancedMonitoringOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::EnhancedMonitoringOutput#stream_name #stream_name} => String
    #   * {Types::EnhancedMonitoringOutput#current_shard_level_metrics #current_shard_level_metrics} => Array&lt;String&gt;
    #   * {Types::EnhancedMonitoringOutput#desired_shard_level_metrics #desired_shard_level_metrics} => Array&lt;String&gt;
    #   * {Types::EnhancedMonitoringOutput#stream_arn #stream_arn} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.enable_enhanced_monitoring({
    #     stream_name: "StreamName",
    #     shard_level_metrics: ["IncomingBytes"], # required, accepts IncomingBytes, IncomingRecords, OutgoingBytes, OutgoingRecords, WriteProvisionedThroughputExceeded, ReadProvisionedThroughputExceeded, IteratorAgeMilliseconds, ALL
    #     stream_arn: "StreamARN",
    #   })
    #
    # @example Response structure
    #
    #   resp.stream_name #=> String
    #   resp.current_shard_level_metrics #=> Array
    #   resp.current_shard_level_metrics[0] #=> String, one of "IncomingBytes", "IncomingRecords", "OutgoingBytes", "OutgoingRecords", "WriteProvisionedThroughputExceeded", "ReadProvisionedThroughputExceeded", "IteratorAgeMilliseconds", "ALL"
    #   resp.desired_shard_level_metrics #=> Array
    #   resp.desired_shard_level_metrics[0] #=> String, one of "IncomingBytes", "IncomingRecords", "OutgoingBytes", "OutgoingRecords", "WriteProvisionedThroughputExceeded", "ReadProvisionedThroughputExceeded", "IteratorAgeMilliseconds", "ALL"
    #   resp.stream_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/EnableEnhancedMonitoring AWS API Documentation
    #
    # @overload enable_enhanced_monitoring(params = {})
    # @param [Hash] params ({})
    def enable_enhanced_monitoring(params = {}, options = {})
      req = build_request(:enable_enhanced_monitoring, params)
      req.send_request(options)
    end

    # Gets data records from a Kinesis data stream's shard.
    #
    # <note markdown="1"> When invoking this API, you must use either the `StreamARN` or the
    # `StreamName` parameter, or both. It is recommended that you use the
    # `StreamARN` input parameter when you invoke this API.
    #
    #  </note>
    #
    # Specify a shard iterator using the `ShardIterator` parameter. The
    # shard iterator specifies the position in the shard from which you want
    # to start reading data records sequentially. If there are no records
    # available in the portion of the shard that the iterator points to,
    # GetRecords returns an empty list. It might take multiple calls to get
    # to a portion of the shard that contains records.
    #
    # You can scale by provisioning multiple shards per stream while
    # considering service limits (for more information, see [Amazon Kinesis
    # Data Streams Limits][1] in the *Amazon Kinesis Data Streams Developer
    # Guide*). Your application should have one thread per shard, each
    # reading continuously from its stream. To read from a stream
    # continually, call GetRecords in a loop. Use GetShardIterator to get
    # the shard iterator to specify in the first GetRecords call. GetRecords
    # returns a new shard iterator in `NextShardIterator`. Specify the shard
    # iterator returned in `NextShardIterator` in subsequent calls to
    # GetRecords. If the shard has been closed, the shard iterator can't
    # return more data and GetRecords returns `null` in `NextShardIterator`.
    # You can terminate the loop when the shard is closed, or when the shard
    # iterator reaches the record with the sequence number or other
    # attribute that marks it as the last record to process.
    #
    # Each data record can be up to 1 MiB in size, and each shard can read
    # up to 2 MiB per second. You can ensure that your calls don't exceed
    # the maximum supported size or throughput by using the `Limit`
    # parameter to specify the maximum number of records that GetRecords can
    # return. Consider your average record size when determining this limit.
    # The maximum number of records that can be returned per call is 10,000.
    #
    # The size of the data returned by GetRecords varies depending on the
    # utilization of the shard. It is recommended that consumer applications
    # retrieve records via the `GetRecords` command using the 5 TPS limit to
    # remain caught up. Retrieving records less frequently can lead to
    # consumer applications falling behind. The maximum size of data that
    # GetRecords can return is 10 MiB. If a call returns this amount of
    # data, subsequent calls made within the next 5 seconds throw
    # `ProvisionedThroughputExceededException`. If there is insufficient
    # provisioned throughput on the stream, subsequent calls made within the
    # next 1 second throw `ProvisionedThroughputExceededException`.
    # GetRecords doesn't return any data when it throws an exception. For
    # this reason, we recommend that you wait 1 second between calls to
    # GetRecords. However, it's possible that the application will get
    # exceptions for longer than 1 second.
    #
    # To detect whether the application is falling behind in processing, you
    # can use the `MillisBehindLatest` response attribute. You can also
    # monitor the stream using CloudWatch metrics and other mechanisms (see
    # [Monitoring][2] in the *Amazon Kinesis Data Streams Developer Guide*).
    #
    # Each Amazon Kinesis record includes a value,
    # `ApproximateArrivalTimestamp`, that is set when a stream successfully
    # receives and stores a record. This is commonly referred to as a
    # server-side time stamp, whereas a client-side time stamp is set when a
    # data producer creates or sends the record to a stream (a data producer
    # is any data source putting data records into a stream, for example
    # with PutRecords). The time stamp has millisecond precision. There are
    # no guarantees about the time stamp accuracy, or that the time stamp is
    # always increasing. For example, records in a shard or across a stream
    # might have time stamps that are out of order.
    #
    # This operation has a limit of five transactions per second per shard.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html
    # [2]: https://docs.aws.amazon.com/kinesis/latest/dev/monitoring.html
    #
    # @option params [required, String] :shard_iterator
    #   The position in the shard from which you want to start sequentially
    #   reading data records. A shard iterator specifies this position using
    #   the sequence number of a data record in the shard.
    #
    # @option params [Integer] :limit
    #   The maximum number of records to return. Specify a value of up to
    #   10,000. If you specify a value that is greater than 10,000, GetRecords
    #   throws `InvalidArgumentException`. The default value is 10,000.
    #
    # @option params [String] :stream_arn
    #   The ARN of the stream.
    #
    # @return [Types::GetRecordsOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::GetRecordsOutput#records #records} => Array&lt;Types::Record&gt;
    #   * {Types::GetRecordsOutput#next_shard_iterator #next_shard_iterator} => String
    #   * {Types::GetRecordsOutput#millis_behind_latest #millis_behind_latest} => Integer
    #   * {Types::GetRecordsOutput#child_shards #child_shards} => Array&lt;Types::ChildShard&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.get_records({
    #     shard_iterator: "ShardIterator", # required
    #     limit: 1,
    #     stream_arn: "StreamARN",
    #   })
    #
    # @example Response structure
    #
    #   resp.records #=> Array
    #   resp.records[0].sequence_number #=> String
    #   resp.records[0].approximate_arrival_timestamp #=> Time
    #   resp.records[0].data #=> String
    #   resp.records[0].partition_key #=> String
    #   resp.records[0].encryption_type #=> String, one of "NONE", "KMS"
    #   resp.next_shard_iterator #=> String
    #   resp.millis_behind_latest #=> Integer
    #   resp.child_shards #=> Array
    #   resp.child_shards[0].shard_id #=> String
    #   resp.child_shards[0].parent_shards #=> Array
    #   resp.child_shards[0].parent_shards[0] #=> String
    #   resp.child_shards[0].hash_key_range.starting_hash_key #=> String
    #   resp.child_shards[0].hash_key_range.ending_hash_key #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetRecords AWS API Documentation
    #
    # @overload get_records(params = {})
    # @param [Hash] params ({})
    def get_records(params = {}, options = {})
      req = build_request(:get_records, params)
      req.send_request(options)
    end

    # Returns a policy attached to the specified data stream or consumer.
    # Request patterns can be one of the following:
    #
    # * Data stream pattern: `arn:aws.*:kinesis:.*:\d{12}:.*stream/\S+`
    #
    # * Consumer pattern:
    #   `^(arn):aws.*:kinesis:.*:\d{12}:.*stream\/[a-zA-Z0-9_.-]+\/consumer\/[a-zA-Z0-9_.-]+:[0-9]+`
    #
    # @option params [required, String] :resource_arn
    #   The Amazon Resource Name (ARN) of the data stream or consumer.
    #
    # @return [Types::GetResourcePolicyOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::GetResourcePolicyOutput#policy #policy} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.get_resource_policy({
    #     resource_arn: "ResourceARN", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.policy #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetResourcePolicy AWS API Documentation
    #
    # @overload get_resource_policy(params = {})
    # @param [Hash] params ({})
    def get_resource_policy(params = {}, options = {})
      req = build_request(:get_resource_policy, params)
      req.send_request(options)
    end

    # Gets an Amazon Kinesis shard iterator. A shard iterator expires 5
    # minutes after it is returned to the requester.
    #
    # <note markdown="1"> When invoking this API, you must use either the `StreamARN` or the
    # `StreamName` parameter, or both. It is recommended that you use the
    # `StreamARN` input parameter when you invoke this API.
    #
    #  </note>
    #
    # A shard iterator specifies the shard position from which to start
    # reading data records sequentially. The position is specified using the
    # sequence number of a data record in a shard. A sequence number is the
    # identifier associated with every record ingested in the stream, and is
    # assigned when a record is put into the stream. Each stream has one or
    # more shards.
    #
    # You must specify the shard iterator type. For example, you can set the
    # `ShardIteratorType` parameter to read exactly from the position
    # denoted by a specific sequence number by using the
    # `AT_SEQUENCE_NUMBER` shard iterator type. Alternatively, the parameter
    # can read right after the sequence number by using the
    # `AFTER_SEQUENCE_NUMBER` shard iterator type, using sequence numbers
    # returned by earlier calls to PutRecord, PutRecords, GetRecords, or
    # DescribeStream. In the request, you can specify the shard iterator
    # type `AT_TIMESTAMP` to read records from an arbitrary point in time,
    # `TRIM_HORIZON` to cause `ShardIterator` to point to the last untrimmed
    # record in the shard in the system (the oldest data record in the
    # shard), or `LATEST` so that you always read the most recent data in
    # the shard.
    #
    # When you read repeatedly from a stream, use a GetShardIterator request
    # to get the first shard iterator for use in your first GetRecords
    # request and for subsequent reads use the shard iterator returned by
    # the GetRecords request in `NextShardIterator`. A new shard iterator is
    # returned by every GetRecords request in `NextShardIterator`, which you
    # use in the `ShardIterator` parameter of the next GetRecords request.
    #
    # If a GetShardIterator request is made too often, you receive a
    # `ProvisionedThroughputExceededException`. For more information about
    # throughput limits, see GetRecords, and [Streams Limits][1] in the
    # *Amazon Kinesis Data Streams Developer Guide*.
    #
    # If the shard is closed, GetShardIterator returns a valid iterator for
    # the last sequence number of the shard. A shard can be closed as a
    # result of using SplitShard or MergeShards.
    #
    # GetShardIterator has a limit of five transactions per second per
    # account per open shard.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html
    #
    # @option params [String] :stream_name
    #   The name of the Amazon Kinesis data stream.
    #
    # @option params [required, String] :shard_id
    #   The shard ID of the Kinesis Data Streams shard to get the iterator
    #   for.
    #
    # @option params [required, String] :shard_iterator_type
    #   Determines how the shard iterator is used to start reading data
    #   records from the shard.
    #
    #   The following are the valid Amazon Kinesis shard iterator types:
    #
    #   * AT\_SEQUENCE\_NUMBER - Start reading from the position denoted by a
    #     specific sequence number, provided in the value
    #     `StartingSequenceNumber`.
    #
    #   * AFTER\_SEQUENCE\_NUMBER - Start reading right after the position
    #     denoted by a specific sequence number, provided in the value
    #     `StartingSequenceNumber`.
    #
    #   * AT\_TIMESTAMP - Start reading from the position denoted by a
    #     specific time stamp, provided in the value `Timestamp`.
    #
    #   * TRIM\_HORIZON - Start reading at the last untrimmed record in the
    #     shard in the system, which is the oldest data record in the shard.
    #
    #   * LATEST - Start reading just after the most recent record in the
    #     shard, so that you always read the most recent data in the shard.
    #
    # @option params [String] :starting_sequence_number
    #   The sequence number of the data record in the shard from which to
    #   start reading. Used with shard iterator type AT\_SEQUENCE\_NUMBER and
    #   AFTER\_SEQUENCE\_NUMBER.
    #
    # @option params [Time,DateTime,Date,Integer,String] :timestamp
    #   The time stamp of the data record from which to start reading. Used
    #   with shard iterator type AT\_TIMESTAMP. A time stamp is the Unix epoch
    #   date with precision in milliseconds. For example,
    #   `2016-04-04T19:58:46.480-00:00` or `1459799926.480`. If a record with
    #   this exact time stamp does not exist, the iterator returned is for the
    #   next (later) record. If the time stamp is older than the current trim
    #   horizon, the iterator returned is for the oldest untrimmed data record
    #   (TRIM\_HORIZON).
    #
    # @option params [String] :stream_arn
    #   The ARN of the stream.
    #
    # @return [Types::GetShardIteratorOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::GetShardIteratorOutput#shard_iterator #shard_iterator} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.get_shard_iterator({
    #     stream_name: "StreamName",
    #     shard_id: "ShardId", # required
    #     shard_iterator_type: "AT_SEQUENCE_NUMBER", # required, accepts AT_SEQUENCE_NUMBER, AFTER_SEQUENCE_NUMBER, TRIM_HORIZON, LATEST, AT_TIMESTAMP
    #     starting_sequence_number: "SequenceNumber",
    #     timestamp: Time.now,
    #     stream_arn: "StreamARN",
    #   })
    #
    # @example Response structure
    #
    #   resp.shard_iterator #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetShardIterator AWS API Documentation
    #
    # @overload get_shard_iterator(params = {})
    # @param [Hash] params ({})
    def get_shard_iterator(params = {}, options = {})
      req = build_request(:get_shard_iterator, params)
      req.send_request(options)
    end

    # Increases the Kinesis data stream's retention period, which is the
    # length of time data records are accessible after they are added to the
    # stream. The maximum value of a stream's retention period is 8760
    # hours (365 days).
    #
    # <note markdown="1"> When invoking this API, you must use either the `StreamARN` or the
    # `StreamName` parameter, or both. It is recommended that you use the
    # `StreamARN` input parameter when you invoke this API.
    #
    #  </note>
    #
    # If you choose a longer stream retention period, this operation
    # increases the time period during which records that have not yet
    # expired are accessible. However, it does not make previous, expired
    # data (older than the stream's previous retention period) accessible
    # after the operation has been called. For example, if a stream's
    # retention period is set to 24 hours and is increased to 168 hours, any
    # data that is older than 24 hours remains inaccessible to consumer
    # applications.
    #
    # @option params [String] :stream_name
    #   The name of the stream to modify.
    #
    # @option params [required, Integer] :retention_period_hours
    #   The new retention period of the stream, in hours. Must be more than
    #   the current retention period.
    #
    # @option params [String] :stream_arn
    #   The ARN of the stream.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.increase_stream_retention_period({
    #     stream_name: "StreamName",
    #     retention_period_hours: 1, # required
    #     stream_arn: "StreamARN",
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/IncreaseStreamRetentionPeriod AWS API Documentation
    #
    # @overload increase_stream_retention_period(params = {})
    # @param [Hash] params ({})
    def increase_stream_retention_period(params = {}, options = {})
      req = build_request(:increase_stream_retention_period, params)
      req.send_request(options)
    end

    # Lists the shards in a stream and provides information about each
    # shard. This operation has a limit of 1000 transactions per second per
    # data stream.
    #
    # <note markdown="1"> When invoking this API, you must use either the `StreamARN` or the
    # `StreamName` parameter, or both. It is recommended that you use the
    # `StreamARN` input parameter when you invoke this API.
    #
    #  </note>
    #
    # This action does not list expired shards. For information about
    # expired shards, see [Data Routing, Data Persistence, and Shard State
    # after a Reshard][1].
    #
    # This API is a new operation that is used by the Amazon Kinesis Client
    # Library (KCL). If you have a fine-grained IAM policy that only allows
    # specific operations, you must update your policy to allow calls to
    # this API. For more information, see [Controlling Access to Amazon
    # Kinesis Data Streams Resources Using IAM][2].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/streams/latest/dev/kinesis-using-sdk-java-after-resharding.html#kinesis-using-sdk-java-resharding-data-routing
    # [2]: https://docs.aws.amazon.com/streams/latest/dev/controlling-access.html
    #
    # @option params [String] :stream_name
    #   The name of the data stream whose shards you want to list.
    #
    #   You cannot specify this parameter if you specify the `NextToken`
    #   parameter.
    #
    # @option params [String] :next_token
    #   When the number of shards in the data stream is greater than the
    #   default value for the `MaxResults` parameter, or if you explicitly
    #   specify a value for `MaxResults` that is less than the number of
    #   shards in the data stream, the response includes a pagination token
    #   named `NextToken`. You can specify this `NextToken` value in a
    #   subsequent call to `ListShards` to list the next set of shards.
    #
    #   Don't specify `StreamName` or `StreamCreationTimestamp` if you
    #   specify `NextToken` because the latter unambiguously identifies the
    #   stream.
    #
    #   You can optionally specify a value for the `MaxResults` parameter when
    #   you specify `NextToken`. If you specify a `MaxResults` value that is
    #   less than the number of shards that the operation returns if you
    #   don't specify `MaxResults`, the response will contain a new
    #   `NextToken` value. You can use the new `NextToken` value in a
    #   subsequent call to the `ListShards` operation.
    #
    #   Tokens expire after 300 seconds. When you obtain a value for
    #   `NextToken` in the response to a call to `ListShards`, you have 300
    #   seconds to use that value. If you specify an expired token in a call
    #   to `ListShards`, you get `ExpiredNextTokenException`.
    #
    # @option params [String] :exclusive_start_shard_id
    #   Specify this parameter to indicate that you want to list the shards
    #   starting with the shard whose ID immediately follows
    #   `ExclusiveStartShardId`.
    #
    #   If you don't specify this parameter, the default behavior is for
    #   `ListShards` to list the shards starting with the first one in the
    #   stream.
    #
    #   You cannot specify this parameter if you specify `NextToken`.
    #
    # @option params [Integer] :max_results
    #   The maximum number of shards to return in a single call to
    #   `ListShards`. The maximum number of shards to return in a single call.
    #   The default value is 1000. If you specify a value greater than 1000,
    #   at most 1000 results are returned.
    #
    #   When the number of shards to be listed is greater than the value of
    #   `MaxResults`, the response contains a `NextToken` value that you can
    #   use in a subsequent call to `ListShards` to list the next set of
    #   shards.
    #
    # @option params [Time,DateTime,Date,Integer,String] :stream_creation_timestamp
    #   Specify this input parameter to distinguish data streams that have the
    #   same name. For example, if you create a data stream and then delete
    #   it, and you later create another data stream with the same name, you
    #   can use this input parameter to specify which of the two streams you
    #   want to list the shards for.
    #
    #   You cannot specify this parameter if you specify the `NextToken`
    #   parameter.
    #
    # @option params [Types::ShardFilter] :shard_filter
    #   Enables you to filter out the response of the `ListShards` API. You
    #   can only specify one filter at a time.
    #
    #   If you use the `ShardFilter` parameter when invoking the ListShards
    #   API, the `Type` is the required property and must be specified. If you
    #   specify the `AT_TRIM_HORIZON`, `FROM_TRIM_HORIZON`, or `AT_LATEST`
    #   types, you do not need to specify either the `ShardId` or the
    #   `Timestamp` optional properties.
    #
    #   If you specify the `AFTER_SHARD_ID` type, you must also provide the
    #   value for the optional `ShardId` property. The `ShardId` property is
    #   identical in fuctionality to the `ExclusiveStartShardId` parameter of
    #   the `ListShards` API. When `ShardId` property is specified, the
    #   response includes the shards starting with the shard whose ID
    #   immediately follows the `ShardId` that you provided.
    #
    #   If you specify the `AT_TIMESTAMP` or `FROM_TIMESTAMP_ID` type, you
    #   must also provide the value for the optional `Timestamp` property. If
    #   you specify the AT\_TIMESTAMP type, then all shards that were open at
    #   the provided timestamp are returned. If you specify the
    #   FROM\_TIMESTAMP type, then all shards starting from the provided
    #   timestamp to TIP are returned.
    #
    # @option params [String] :stream_arn
    #   The ARN of the stream.
    #
    # @return [Types::ListShardsOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ListShardsOutput#shards #shards} => Array&lt;Types::Shard&gt;
    #   * {Types::ListShardsOutput#next_token #next_token} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.list_shards({
    #     stream_name: "StreamName",
    #     next_token: "NextToken",
    #     exclusive_start_shard_id: "ShardId",
    #     max_results: 1,
    #     stream_creation_timestamp: Time.now,
    #     shard_filter: {
    #       type: "AFTER_SHARD_ID", # required, accepts AFTER_SHARD_ID, AT_TRIM_HORIZON, FROM_TRIM_HORIZON, AT_LATEST, AT_TIMESTAMP, FROM_TIMESTAMP
    #       shard_id: "ShardId",
    #       timestamp: Time.now,
    #     },
    #     stream_arn: "StreamARN",
    #   })
    #
    # @example Response structure
    #
    #   resp.shards #=> Array
    #   resp.shards[0].shard_id #=> String
    #   resp.shards[0].parent_shard_id #=> String
    #   resp.shards[0].adjacent_parent_shard_id #=> String
    #   resp.shards[0].hash_key_range.starting_hash_key #=> String
    #   resp.shards[0].hash_key_range.ending_hash_key #=> String
    #   resp.shards[0].sequence_number_range.starting_sequence_number #=> String
    #   resp.shards[0].sequence_number_range.ending_sequence_number #=> String
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListShards AWS API Documentation
    #
    # @overload list_shards(params = {})
    # @param [Hash] params ({})
    def list_shards(params = {}, options = {})
      req = build_request(:list_shards, params)
      req.send_request(options)
    end

    # Lists the consumers registered to receive data from a stream using
    # enhanced fan-out, and provides information about each consumer.
    #
    # This operation has a limit of 5 transactions per second per stream.
    #
    # @option params [required, String] :stream_arn
    #   The ARN of the Kinesis data stream for which you want to list the
    #   registered consumers. For more information, see [Amazon Resource Names
    #   (ARNs) and Amazon Web Services Service Namespaces][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams
    #
    # @option params [String] :next_token
    #   When the number of consumers that are registered with the data stream
    #   is greater than the default value for the `MaxResults` parameter, or
    #   if you explicitly specify a value for `MaxResults` that is less than
    #   the number of consumers that are registered with the data stream, the
    #   response includes a pagination token named `NextToken`. You can
    #   specify this `NextToken` value in a subsequent call to
    #   `ListStreamConsumers` to list the next set of registered consumers.
    #
    #   Don't specify `StreamName` or `StreamCreationTimestamp` if you
    #   specify `NextToken` because the latter unambiguously identifies the
    #   stream.
    #
    #   You can optionally specify a value for the `MaxResults` parameter when
    #   you specify `NextToken`. If you specify a `MaxResults` value that is
    #   less than the number of consumers that the operation returns if you
    #   don't specify `MaxResults`, the response will contain a new
    #   `NextToken` value. You can use the new `NextToken` value in a
    #   subsequent call to the `ListStreamConsumers` operation to list the
    #   next set of consumers.
    #
    #   Tokens expire after 300 seconds. When you obtain a value for
    #   `NextToken` in the response to a call to `ListStreamConsumers`, you
    #   have 300 seconds to use that value. If you specify an expired token in
    #   a call to `ListStreamConsumers`, you get `ExpiredNextTokenException`.
    #
    # @option params [Integer] :max_results
    #   The maximum number of consumers that you want a single call of
    #   `ListStreamConsumers` to return. The default value is 100. If you
    #   specify a value greater than 100, at most 100 results are returned.
    #
    # @option params [Time,DateTime,Date,Integer,String] :stream_creation_timestamp
    #   Specify this input parameter to distinguish data streams that have the
    #   same name. For example, if you create a data stream and then delete
    #   it, and you later create another data stream with the same name, you
    #   can use this input parameter to specify which of the two streams you
    #   want to list the consumers for.
    #
    #   You can't specify this parameter if you specify the NextToken
    #   parameter.
    #
    # @return [Types::ListStreamConsumersOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ListStreamConsumersOutput#consumers #consumers} => Array&lt;Types::Consumer&gt;
    #   * {Types::ListStreamConsumersOutput#next_token #next_token} => String
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.list_stream_consumers({
    #     stream_arn: "StreamARN", # required
    #     next_token: "NextToken",
    #     max_results: 1,
    #     stream_creation_timestamp: Time.now,
    #   })
    #
    # @example Response structure
    #
    #   resp.consumers #=> Array
    #   resp.consumers[0].consumer_name #=> String
    #   resp.consumers[0].consumer_arn #=> String
    #   resp.consumers[0].consumer_status #=> String, one of "CREATING", "DELETING", "ACTIVE"
    #   resp.consumers[0].consumer_creation_timestamp #=> Time
    #   resp.next_token #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListStreamConsumers AWS API Documentation
    #
    # @overload list_stream_consumers(params = {})
    # @param [Hash] params ({})
    def list_stream_consumers(params = {}, options = {})
      req = build_request(:list_stream_consumers, params)
      req.send_request(options)
    end

    # Lists your Kinesis data streams.
    #
    # The number of streams may be too large to return from a single call to
    # `ListStreams`. You can limit the number of returned streams using the
    # `Limit` parameter. If you do not specify a value for the `Limit`
    # parameter, Kinesis Data Streams uses the default limit, which is
    # currently 100.
    #
    # You can detect if there are more streams available to list by using
    # the `HasMoreStreams` flag from the returned output. If there are more
    # streams available, you can request more streams by using the name of
    # the last stream returned by the `ListStreams` request in the
    # `ExclusiveStartStreamName` parameter in a subsequent request to
    # `ListStreams`. The group of stream names returned by the subsequent
    # request is then added to the list. You can continue this process until
    # all the stream names have been collected in the list.
    #
    # ListStreams has a limit of five transactions per second per account.
    #
    # @option params [Integer] :limit
    #   The maximum number of streams to list. The default value is 100. If
    #   you specify a value greater than 100, at most 100 results are
    #   returned.
    #
    # @option params [String] :exclusive_start_stream_name
    #   The name of the stream to start the list with.
    #
    # @option params [String] :next_token
    #
    # @return [Types::ListStreamsOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ListStreamsOutput#stream_names #stream_names} => Array&lt;String&gt;
    #   * {Types::ListStreamsOutput#has_more_streams #has_more_streams} => Boolean
    #   * {Types::ListStreamsOutput#next_token #next_token} => String
    #   * {Types::ListStreamsOutput#stream_summaries #stream_summaries} => Array&lt;Types::StreamSummary&gt;
    #
    # The returned {Seahorse::Client::Response response} is a pageable response and is Enumerable. For details on usage see {Aws::PageableResponse PageableResponse}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.list_streams({
    #     limit: 1,
    #     exclusive_start_stream_name: "StreamName",
    #     next_token: "NextToken",
    #   })
    #
    # @example Response structure
    #
    #   resp.stream_names #=> Array
    #   resp.stream_names[0] #=> String
    #   resp.has_more_streams #=> Boolean
    #   resp.next_token #=> String
    #   resp.stream_summaries #=> Array
    #   resp.stream_summaries[0].stream_name #=> String
    #   resp.stream_summaries[0].stream_arn #=> String
    #   resp.stream_summaries[0].stream_status #=> String, one of "CREATING", "DELETING", "ACTIVE", "UPDATING"
    #   resp.stream_summaries[0].stream_mode_details.stream_mode #=> String, one of "PROVISIONED", "ON_DEMAND"
    #   resp.stream_summaries[0].stream_creation_timestamp #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListStreams AWS API Documentation
    #
    # @overload list_streams(params = {})
    # @param [Hash] params ({})
    def list_streams(params = {}, options = {})
      req = build_request(:list_streams, params)
      req.send_request(options)
    end

    # List all tags added to the specified Kinesis resource. Each tag is a
    # label consisting of a user-defined key and value. Tags can help you
    # manage, identify, organize, search for, and filter resources.
    #
    # For more information about tagging Kinesis resources, see [Tag your
    # Amazon Kinesis Data Streams resources][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/streams/latest/dev/tagging.html
    #
    # @option params [required, String] :resource_arn
    #   The Amazon Resource Name (ARN) of the Kinesis resource for which to
    #   list tags.
    #
    # @return [Types::ListTagsForResourceOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ListTagsForResourceOutput#tags #tags} => Array&lt;Types::Tag&gt;
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.list_tags_for_resource({
    #     resource_arn: "ResourceARN", # required
    #   })
    #
    # @example Response structure
    #
    #   resp.tags #=> Array
    #   resp.tags[0].key #=> String
    #   resp.tags[0].value #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListTagsForResource AWS API Documentation
    #
    # @overload list_tags_for_resource(params = {})
    # @param [Hash] params ({})
    def list_tags_for_resource(params = {}, options = {})
      req = build_request(:list_tags_for_resource, params)
      req.send_request(options)
    end

    # Lists the tags for the specified Kinesis data stream. This operation
    # has a limit of five transactions per second per account.
    #
    # <note markdown="1"> When invoking this API, you must use either the `StreamARN` or the
    # `StreamName` parameter, or both. It is recommended that you use the
    # `StreamARN` input parameter when you invoke this API.
    #
    #  </note>
    #
    # @option params [String] :stream_name
    #   The name of the stream.
    #
    # @option params [String] :exclusive_start_tag_key
    #   The key to use as the starting point for the list of tags. If this
    #   parameter is set, `ListTagsForStream` gets all tags that occur after
    #   `ExclusiveStartTagKey`.
    #
    # @option params [Integer] :limit
    #   The number of tags to return. If this number is less than the total
    #   number of tags associated with the stream, `HasMoreTags` is set to
    #   `true`. To list additional tags, set `ExclusiveStartTagKey` to the
    #   last key in the response.
    #
    # @option params [String] :stream_arn
    #   The ARN of the stream.
    #
    # @return [Types::ListTagsForStreamOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::ListTagsForStreamOutput#tags #tags} => Array&lt;Types::Tag&gt;
    #   * {Types::ListTagsForStreamOutput#has_more_tags #has_more_tags} => Boolean
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.list_tags_for_stream({
    #     stream_name: "StreamName",
    #     exclusive_start_tag_key: "TagKey",
    #     limit: 1,
    #     stream_arn: "StreamARN",
    #   })
    #
    # @example Response structure
    #
    #   resp.tags #=> Array
    #   resp.tags[0].key #=> String
    #   resp.tags[0].value #=> String
    #   resp.has_more_tags #=> Boolean
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListTagsForStream AWS API Documentation
    #
    # @overload list_tags_for_stream(params = {})
    # @param [Hash] params ({})
    def list_tags_for_stream(params = {}, options = {})
      req = build_request(:list_tags_for_stream, params)
      req.send_request(options)
    end

    # Merges two adjacent shards in a Kinesis data stream and combines them
    # into a single shard to reduce the stream's capacity to ingest and
    # transport data. This API is only supported for the data streams with
    # the provisioned capacity mode. Two shards are considered adjacent if
    # the union of the hash key ranges for the two shards form a contiguous
    # set with no gaps. For example, if you have two shards, one with a hash
    # key range of 276...381 and the other with a hash key range of
    # 382...454, then you could merge these two shards into a single shard
    # that would have a hash key range of 276...454. After the merge, the
    # single child shard receives data for all hash key values covered by
    # the two parent shards.
    #
    # <note markdown="1"> When invoking this API, you must use either the `StreamARN` or the
    # `StreamName` parameter, or both. It is recommended that you use the
    # `StreamARN` input parameter when you invoke this API.
    #
    #  </note>
    #
    # `MergeShards` is called when there is a need to reduce the overall
    # capacity of a stream because of excess capacity that is not being
    # used. You must specify the shard to be merged and the adjacent shard
    # for a stream. For more information about merging shards, see [Merge
    # Two Shards][1] in the *Amazon Kinesis Data Streams Developer Guide*.
    #
    # If the stream is in the `ACTIVE` state, you can call `MergeShards`. If
    # a stream is in the `CREATING`, `UPDATING`, or `DELETING` state,
    # `MergeShards` returns a `ResourceInUseException`. If the specified
    # stream does not exist, `MergeShards` returns a
    # `ResourceNotFoundException`.
    #
    # You can use DescribeStreamSummary to check the state of the stream,
    # which is returned in `StreamStatus`.
    #
    # `MergeShards` is an asynchronous operation. Upon receiving a
    # `MergeShards` request, Amazon Kinesis Data Streams immediately returns
    # a response and sets the `StreamStatus` to `UPDATING`. After the
    # operation is completed, Kinesis Data Streams sets the `StreamStatus`
    # to `ACTIVE`. Read and write operations continue to work while the
    # stream is in the `UPDATING` state.
    #
    # You use DescribeStreamSummary and the ListShards APIs to determine the
    # shard IDs that are specified in the `MergeShards` request.
    #
    # If you try to operate on too many streams in parallel using
    # CreateStream, DeleteStream, `MergeShards`, or SplitShard, you receive
    # a `LimitExceededException`.
    #
    # `MergeShards` has a limit of five transactions per second per account.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-resharding-merge.html
    #
    # @option params [String] :stream_name
    #   The name of the stream for the merge.
    #
    # @option params [required, String] :shard_to_merge
    #   The shard ID of the shard to combine with the adjacent shard for the
    #   merge.
    #
    # @option params [required, String] :adjacent_shard_to_merge
    #   The shard ID of the adjacent shard for the merge.
    #
    # @option params [String] :stream_arn
    #   The ARN of the stream.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.merge_shards({
    #     stream_name: "StreamName",
    #     shard_to_merge: "ShardId", # required
    #     adjacent_shard_to_merge: "ShardId", # required
    #     stream_arn: "StreamARN",
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/MergeShards AWS API Documentation
    #
    # @overload merge_shards(params = {})
    # @param [Hash] params ({})
    def merge_shards(params = {}, options = {})
      req = build_request(:merge_shards, params)
      req.send_request(options)
    end

    # Writes a single data record into an Amazon Kinesis data stream. Call
    # `PutRecord` to send data into the stream for real-time ingestion and
    # subsequent processing, one record at a time. Each shard can support
    # writes up to 1,000 records per second, up to a maximum data write
    # total of 1 MiB per second.
    #
    # <note markdown="1"> When invoking this API, you must use either the `StreamARN` or the
    # `StreamName` parameter, or both. It is recommended that you use the
    # `StreamARN` input parameter when you invoke this API.
    #
    #  </note>
    #
    # You must specify the name of the stream that captures, stores, and
    # transports the data; a partition key; and the data blob itself.
    #
    # The data blob can be any type of data; for example, a segment from a
    # log file, geographic/location data, website clickstream data, and so
    # on.
    #
    # The partition key is used by Kinesis Data Streams to distribute data
    # across shards. Kinesis Data Streams segregates the data records that
    # belong to a stream into multiple shards, using the partition key
    # associated with each data record to determine the shard to which a
    # given data record belongs.
    #
    # Partition keys are Unicode strings, with a maximum length limit of 256
    # characters for each key. An MD5 hash function is used to map partition
    # keys to 128-bit integer values and to map associated data records to
    # shards using the hash key ranges of the shards. You can override
    # hashing the partition key to determine the shard by explicitly
    # specifying a hash value using the `ExplicitHashKey` parameter. For
    # more information, see [Adding Data to a Stream][1] in the *Amazon
    # Kinesis Data Streams Developer Guide*.
    #
    # `PutRecord` returns the shard ID of where the data record was placed
    # and the sequence number that was assigned to the data record.
    #
    # Sequence numbers increase over time and are specific to a shard within
    # a stream, not across all shards within a stream. To guarantee strictly
    # increasing ordering, write serially to a shard and use the
    # `SequenceNumberForOrdering` parameter. For more information, see
    # [Adding Data to a Stream][1] in the *Amazon Kinesis Data Streams
    # Developer Guide*.
    #
    # After you write a record to a stream, you cannot modify that record or
    # its order within the stream.
    #
    # If a `PutRecord` request cannot be processed because of insufficient
    # provisioned throughput on the shard involved in the request,
    # `PutRecord` throws `ProvisionedThroughputExceededException`.
    #
    # By default, data records are accessible for 24 hours from the time
    # that they are added to a stream. You can use
    # IncreaseStreamRetentionPeriod or DecreaseStreamRetentionPeriod to
    # modify this retention period.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-add-data-to-stream
    #
    # @option params [String] :stream_name
    #   The name of the stream to put the data record into.
    #
    # @option params [required, String, StringIO, File] :data
    #   The data blob to put into the record, which is base64-encoded when the
    #   blob is serialized. When the data blob (the payload before
    #   base64-encoding) is added to the partition key size, the total size
    #   must not exceed the maximum record size (1 MiB).
    #
    # @option params [required, String] :partition_key
    #   Determines which shard in the stream the data record is assigned to.
    #   Partition keys are Unicode strings with a maximum length limit of 256
    #   characters for each key. Amazon Kinesis Data Streams uses the
    #   partition key as input to a hash function that maps the partition key
    #   and associated data to a specific shard. Specifically, an MD5 hash
    #   function is used to map partition keys to 128-bit integer values and
    #   to map associated data records to shards. As a result of this hashing
    #   mechanism, all data records with the same partition key map to the
    #   same shard within the stream.
    #
    # @option params [String] :explicit_hash_key
    #   The hash value used to explicitly determine the shard the data record
    #   is assigned to by overriding the partition key hash.
    #
    # @option params [String] :sequence_number_for_ordering
    #   Guarantees strictly increasing sequence numbers, for puts from the
    #   same client and to the same partition key. Usage: set the
    #   `SequenceNumberForOrdering` of record *n* to the sequence number of
    #   record *n-1* (as returned in the result when putting record *n-1*). If
    #   this parameter is not set, records are coarsely ordered based on
    #   arrival time.
    #
    # @option params [String] :stream_arn
    #   The ARN of the stream.
    #
    # @return [Types::PutRecordOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::PutRecordOutput#shard_id #shard_id} => String
    #   * {Types::PutRecordOutput#sequence_number #sequence_number} => String
    #   * {Types::PutRecordOutput#encryption_type #encryption_type} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.put_record({
    #     stream_name: "StreamName",
    #     data: "data", # required
    #     partition_key: "PartitionKey", # required
    #     explicit_hash_key: "HashKey",
    #     sequence_number_for_ordering: "SequenceNumber",
    #     stream_arn: "StreamARN",
    #   })
    #
    # @example Response structure
    #
    #   resp.shard_id #=> String
    #   resp.sequence_number #=> String
    #   resp.encryption_type #=> String, one of "NONE", "KMS"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutRecord AWS API Documentation
    #
    # @overload put_record(params = {})
    # @param [Hash] params ({})
    def put_record(params = {}, options = {})
      req = build_request(:put_record, params)
      req.send_request(options)
    end

    # Writes multiple data records into a Kinesis data stream in a single
    # call (also referred to as a `PutRecords` request). Use this operation
    # to send data into the stream for data ingestion and processing.
    #
    # <note markdown="1"> When invoking this API, you must use either the `StreamARN` or the
    # `StreamName` parameter, or both. It is recommended that you use the
    # `StreamARN` input parameter when you invoke this API.
    #
    #  </note>
    #
    # Each `PutRecords` request can support up to 500 records. Each record
    # in the request can be as large as 1 MiB, up to a limit of 5 MiB for
    # the entire request, including partition keys. Each shard can support
    # writes up to 1,000 records per second, up to a maximum data write
    # total of 1 MiB per second.
    #
    # You must specify the name of the stream that captures, stores, and
    # transports the data; and an array of request `Records`, with each
    # record in the array requiring a partition key and data blob. The
    # record size limit applies to the total size of the partition key and
    # data blob.
    #
    # The data blob can be any type of data; for example, a segment from a
    # log file, geographic/location data, website clickstream data, and so
    # on.
    #
    # The partition key is used by Kinesis Data Streams as input to a hash
    # function that maps the partition key and associated data to a specific
    # shard. An MD5 hash function is used to map partition keys to 128-bit
    # integer values and to map associated data records to shards. As a
    # result of this hashing mechanism, all data records with the same
    # partition key map to the same shard within the stream. For more
    # information, see [Adding Data to a Stream][1] in the *Amazon Kinesis
    # Data Streams Developer Guide*.
    #
    # Each record in the `Records` array may include an optional parameter,
    # `ExplicitHashKey`, which overrides the partition key to shard mapping.
    # This parameter allows a data producer to determine explicitly the
    # shard where the record is stored. For more information, see [Adding
    # Multiple Records with PutRecords][2] in the *Amazon Kinesis Data
    # Streams Developer Guide*.
    #
    # The `PutRecords` response includes an array of response `Records`.
    # Each record in the response array directly correlates with a record in
    # the request array using natural ordering, from the top to the bottom
    # of the request and response. The response `Records` array always
    # includes the same number of records as the request array.
    #
    # The response `Records` array includes both successfully and
    # unsuccessfully processed records. Kinesis Data Streams attempts to
    # process all records in each `PutRecords` request. A single record
    # failure does not stop the processing of subsequent records. As a
    # result, PutRecords doesn't guarantee the ordering of records. If you
    # need to read records in the same order they are written to the stream,
    # use PutRecord instead of `PutRecords`, and write to the same shard.
    #
    # A successfully processed record includes `ShardId` and
    # `SequenceNumber` values. The `ShardId` parameter identifies the shard
    # in the stream where the record is stored. The `SequenceNumber`
    # parameter is an identifier assigned to the put record, unique to all
    # records in the stream.
    #
    # An unsuccessfully processed record includes `ErrorCode` and
    # `ErrorMessage` values. `ErrorCode` reflects the type of error and can
    # be one of the following values:
    # `ProvisionedThroughputExceededException` or `InternalFailure`.
    # `ErrorMessage` provides more detailed information about the
    # `ProvisionedThroughputExceededException` exception including the
    # account ID, stream name, and shard ID of the record that was
    # throttled. For more information about partially successful responses,
    # see [Adding Multiple Records with PutRecords][3] in the *Amazon
    # Kinesis Data Streams Developer Guide*.
    #
    # After you write a record to a stream, you cannot modify that record or
    # its order within the stream.
    #
    # By default, data records are accessible for 24 hours from the time
    # that they are added to a stream. You can use
    # IncreaseStreamRetentionPeriod or DecreaseStreamRetentionPeriod to
    # modify this retention period.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-add-data-to-stream
    # [2]: https://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-putrecords
    # [3]: https://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-add-data-to-stream.html#kinesis-using-sdk-java-putrecords
    #
    # @option params [required, Array<Types::PutRecordsRequestEntry>] :records
    #   The records associated with the request.
    #
    # @option params [String] :stream_name
    #   The stream name associated with the request.
    #
    # @option params [String] :stream_arn
    #   The ARN of the stream.
    #
    # @return [Types::PutRecordsOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::PutRecordsOutput#failed_record_count #failed_record_count} => Integer
    #   * {Types::PutRecordsOutput#records #records} => Array&lt;Types::PutRecordsResultEntry&gt;
    #   * {Types::PutRecordsOutput#encryption_type #encryption_type} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.put_records({
    #     records: [ # required
    #       {
    #         data: "data", # required
    #         explicit_hash_key: "HashKey",
    #         partition_key: "PartitionKey", # required
    #       },
    #     ],
    #     stream_name: "StreamName",
    #     stream_arn: "StreamARN",
    #   })
    #
    # @example Response structure
    #
    #   resp.failed_record_count #=> Integer
    #   resp.records #=> Array
    #   resp.records[0].sequence_number #=> String
    #   resp.records[0].shard_id #=> String
    #   resp.records[0].error_code #=> String
    #   resp.records[0].error_message #=> String
    #   resp.encryption_type #=> String, one of "NONE", "KMS"
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutRecords AWS API Documentation
    #
    # @overload put_records(params = {})
    # @param [Hash] params ({})
    def put_records(params = {}, options = {})
      req = build_request(:put_records, params)
      req.send_request(options)
    end

    # Attaches a resource-based policy to a data stream or registered
    # consumer. If you are using an identity other than the root user of the
    # Amazon Web Services account that owns the resource, the calling
    # identity must have the `PutResourcePolicy` permissions on the
    # specified Kinesis Data Streams resource and belong to the owner's
    # account in order to use this operation. If you don't have
    # `PutResourcePolicy` permissions, Amazon Kinesis Data Streams returns a
    # `403 Access Denied error`. If you receive a
    # `ResourceNotFoundException`, check to see if you passed a valid stream
    # or consumer resource.
    #
    # Request patterns can be one of the following:
    #
    # * Data stream pattern: `arn:aws.*:kinesis:.*:\d{12}:.*stream/\S+`
    #
    # * Consumer pattern:
    #   `^(arn):aws.*:kinesis:.*:\d{12}:.*stream\/[a-zA-Z0-9_.-]+\/consumer\/[a-zA-Z0-9_.-]+:[0-9]+`
    #
    # For more information, see [Controlling Access to Amazon Kinesis Data
    # Streams Resources Using IAM][1].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/streams/latest/dev/controlling-access.html
    #
    # @option params [required, String] :resource_arn
    #   The Amazon Resource Name (ARN) of the data stream or consumer.
    #
    # @option params [required, String] :policy
    #   Details of the resource policy. It must include the identity of the
    #   principal and the actions allowed on this resource. This is formatted
    #   as a JSON string.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.put_resource_policy({
    #     resource_arn: "ResourceARN", # required
    #     policy: "Policy", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutResourcePolicy AWS API Documentation
    #
    # @overload put_resource_policy(params = {})
    # @param [Hash] params ({})
    def put_resource_policy(params = {}, options = {})
      req = build_request(:put_resource_policy, params)
      req.send_request(options)
    end

    # Registers a consumer with a Kinesis data stream. When you use this
    # operation, the consumer you register can then call SubscribeToShard to
    # receive data from the stream using enhanced fan-out, at a rate of up
    # to 2 MiB per second for every shard you subscribe to. This rate is
    # unaffected by the total number of consumers that read from the same
    # stream.
    #
    # You can add tags to the registered consumer when making a
    # `RegisterStreamConsumer` request by setting the `Tags` parameter. If
    # you pass the `Tags` parameter, in addition to having the
    # `kinesis:RegisterStreamConsumer` permission, you must also have the
    # `kinesis:TagResource` permission for the consumer that will be
    # registered. Tags will take effect from the `CREATING` status of the
    # consumer.
    #
    # You can register up to 20 consumers per stream. A given consumer can
    # only be registered with one stream at a time.
    #
    # For an example of how to use this operation, see [Enhanced Fan-Out
    # Using the Kinesis Data Streams API][1].
    #
    # The use of this operation has a limit of five transactions per second
    # per account. Also, only 5 consumers can be created simultaneously. In
    # other words, you cannot have more than 5 consumers in a `CREATING`
    # status at the same time. Registering a 6th consumer while there are 5
    # in a `CREATING` status results in a `LimitExceededException`.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/streams/latest/dev/building-enhanced-consumers-api.html
    #
    # @option params [required, String] :stream_arn
    #   The ARN of the Kinesis data stream that you want to register the
    #   consumer with. For more info, see [Amazon Resource Names (ARNs) and
    #   Amazon Web Services Service Namespaces][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams
    #
    # @option params [required, String] :consumer_name
    #   For a given Kinesis data stream, each consumer must have a unique
    #   name. However, consumer names don't have to be unique across data
    #   streams.
    #
    # @option params [Hash<String,String>] :tags
    #   A set of up to 50 key-value pairs. A tag consists of a required key
    #   and an optional value.
    #
    # @return [Types::RegisterStreamConsumerOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::RegisterStreamConsumerOutput#consumer #consumer} => Types::Consumer
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.register_stream_consumer({
    #     stream_arn: "StreamARN", # required
    #     consumer_name: "ConsumerName", # required
    #     tags: {
    #       "TagKey" => "TagValue",
    #     },
    #   })
    #
    # @example Response structure
    #
    #   resp.consumer.consumer_name #=> String
    #   resp.consumer.consumer_arn #=> String
    #   resp.consumer.consumer_status #=> String, one of "CREATING", "DELETING", "ACTIVE"
    #   resp.consumer.consumer_creation_timestamp #=> Time
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/RegisterStreamConsumer AWS API Documentation
    #
    # @overload register_stream_consumer(params = {})
    # @param [Hash] params ({})
    def register_stream_consumer(params = {}, options = {})
      req = build_request(:register_stream_consumer, params)
      req.send_request(options)
    end

    # Removes tags from the specified Kinesis data stream. Removed tags are
    # deleted and cannot be recovered after this operation successfully
    # completes.
    #
    # <note markdown="1"> When invoking this API, you must use either the `StreamARN` or the
    # `StreamName` parameter, or both. It is recommended that you use the
    # `StreamARN` input parameter when you invoke this API.
    #
    #  </note>
    #
    # If you specify a tag that does not exist, it is ignored.
    #
    # RemoveTagsFromStream has a limit of five transactions per second per
    # account.
    #
    # @option params [String] :stream_name
    #   The name of the stream.
    #
    # @option params [required, Array<String>] :tag_keys
    #   A list of tag keys. Each corresponding tag is removed from the stream.
    #
    # @option params [String] :stream_arn
    #   The ARN of the stream.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.remove_tags_from_stream({
    #     stream_name: "StreamName",
    #     tag_keys: ["TagKey"], # required
    #     stream_arn: "StreamARN",
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/RemoveTagsFromStream AWS API Documentation
    #
    # @overload remove_tags_from_stream(params = {})
    # @param [Hash] params ({})
    def remove_tags_from_stream(params = {}, options = {})
      req = build_request(:remove_tags_from_stream, params)
      req.send_request(options)
    end

    # Splits a shard into two new shards in the Kinesis data stream, to
    # increase the stream's capacity to ingest and transport data.
    # `SplitShard` is called when there is a need to increase the overall
    # capacity of a stream because of an expected increase in the volume of
    # data records being ingested. This API is only supported for the data
    # streams with the provisioned capacity mode.
    #
    # <note markdown="1"> When invoking this API, you must use either the `StreamARN` or the
    # `StreamName` parameter, or both. It is recommended that you use the
    # `StreamARN` input parameter when you invoke this API.
    #
    #  </note>
    #
    # You can also use `SplitShard` when a shard appears to be approaching
    # its maximum utilization; for example, the producers sending data into
    # the specific shard are suddenly sending more than previously
    # anticipated. You can also call `SplitShard` to increase stream
    # capacity, so that more Kinesis Data Streams applications can
    # simultaneously read data from the stream for real-time processing.
    #
    # You must specify the shard to be split and the new hash key, which is
    # the position in the shard where the shard gets split in two. In many
    # cases, the new hash key might be the average of the beginning and
    # ending hash key, but it can be any hash key value in the range being
    # mapped into the shard. For more information, see [Split a Shard][1] in
    # the *Amazon Kinesis Data Streams Developer Guide*.
    #
    # You can use DescribeStreamSummary and the ListShards APIs to determine
    # the shard ID and hash key values for the `ShardToSplit` and
    # `NewStartingHashKey` parameters that are specified in the `SplitShard`
    # request.
    #
    # `SplitShard` is an asynchronous operation. Upon receiving a
    # `SplitShard` request, Kinesis Data Streams immediately returns a
    # response and sets the stream status to `UPDATING`. After the operation
    # is completed, Kinesis Data Streams sets the stream status to `ACTIVE`.
    # Read and write operations continue to work while the stream is in the
    # `UPDATING` state.
    #
    # You can use DescribeStreamSummary to check the status of the stream,
    # which is returned in `StreamStatus`. If the stream is in the `ACTIVE`
    # state, you can call `SplitShard`.
    #
    # If the specified stream does not exist, DescribeStreamSummary returns
    # a `ResourceNotFoundException`. If you try to create more shards than
    # are authorized for your account, you receive a
    # `LimitExceededException`.
    #
    # For the default shard limit for an Amazon Web Services account, see
    # [Kinesis Data Streams Limits][2] in the *Amazon Kinesis Data Streams
    # Developer Guide*. To increase this limit, [contact Amazon Web Services
    # Support][3].
    #
    # If you try to operate on too many streams simultaneously using
    # CreateStream, DeleteStream, MergeShards, and/or SplitShard, you
    # receive a `LimitExceededException`.
    #
    # `SplitShard` has a limit of five transactions per second per account.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-resharding-split.html
    # [2]: https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html
    # [3]: https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html
    #
    # @option params [String] :stream_name
    #   The name of the stream for the shard split.
    #
    # @option params [required, String] :shard_to_split
    #   The shard ID of the shard to split.
    #
    # @option params [required, String] :new_starting_hash_key
    #   A hash key value for the starting hash key of one of the child shards
    #   created by the split. The hash key range for a given shard constitutes
    #   a set of ordered contiguous positive integers. The value for
    #   `NewStartingHashKey` must be in the range of hash keys being mapped
    #   into the shard. The `NewStartingHashKey` hash key value and all higher
    #   hash key values in hash key range are distributed to one of the child
    #   shards. All the lower hash key values in the range are distributed to
    #   the other child shard.
    #
    # @option params [String] :stream_arn
    #   The ARN of the stream.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.split_shard({
    #     stream_name: "StreamName",
    #     shard_to_split: "ShardId", # required
    #     new_starting_hash_key: "HashKey", # required
    #     stream_arn: "StreamARN",
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/SplitShard AWS API Documentation
    #
    # @overload split_shard(params = {})
    # @param [Hash] params ({})
    def split_shard(params = {}, options = {})
      req = build_request(:split_shard, params)
      req.send_request(options)
    end

    # Enables or updates server-side encryption using an Amazon Web Services
    # KMS key for a specified stream.
    #
    # <note markdown="1"> When invoking this API, you must use either the `StreamARN` or the
    # `StreamName` parameter, or both. It is recommended that you use the
    # `StreamARN` input parameter when you invoke this API.
    #
    #  </note>
    #
    # Starting encryption is an asynchronous operation. Upon receiving the
    # request, Kinesis Data Streams returns immediately and sets the status
    # of the stream to `UPDATING`. After the update is complete, Kinesis
    # Data Streams sets the status of the stream back to `ACTIVE`. Updating
    # or applying encryption normally takes a few seconds to complete, but
    # it can take minutes. You can continue to read and write data to your
    # stream while its status is `UPDATING`. Once the status of the stream
    # is `ACTIVE`, encryption begins for records written to the stream.
    #
    # API Limits: You can successfully apply a new Amazon Web Services KMS
    # key for server-side encryption 25 times in a rolling 24-hour period.
    #
    # Note: It can take up to 5 seconds after the stream is in an `ACTIVE`
    # status before all records written to the stream are encrypted. After
    # you enable encryption, you can verify that encryption is applied by
    # inspecting the API response from `PutRecord` or `PutRecords`.
    #
    # @option params [String] :stream_name
    #   The name of the stream for which to start encrypting records.
    #
    # @option params [required, String] :encryption_type
    #   The encryption type to use. The only valid value is `KMS`.
    #
    # @option params [required, String] :key_id
    #   The GUID for the customer-managed Amazon Web Services KMS key to use
    #   for encryption. This value can be a globally unique identifier, a
    #   fully specified Amazon Resource Name (ARN) to either an alias or a
    #   key, or an alias name prefixed by "alias/".You can also use a master
    #   key owned by Kinesis Data Streams by specifying the alias
    #   `aws/kinesis`.
    #
    #   * Key ARN example:
    #     `arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012`
    #
    #   * Alias ARN example:
    #     `arn:aws:kms:us-east-1:123456789012:alias/MyAliasName`
    #
    #   * Globally unique key ID example:
    #     `12345678-1234-1234-1234-123456789012`
    #
    #   * Alias name example: `alias/MyAliasName`
    #
    #   * Master key owned by Kinesis Data Streams: `alias/aws/kinesis`
    #
    # @option params [String] :stream_arn
    #   The ARN of the stream.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.start_stream_encryption({
    #     stream_name: "StreamName",
    #     encryption_type: "NONE", # required, accepts NONE, KMS
    #     key_id: "KeyId", # required
    #     stream_arn: "StreamARN",
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/StartStreamEncryption AWS API Documentation
    #
    # @overload start_stream_encryption(params = {})
    # @param [Hash] params ({})
    def start_stream_encryption(params = {}, options = {})
      req = build_request(:start_stream_encryption, params)
      req.send_request(options)
    end

    # Disables server-side encryption for a specified stream.
    #
    # <note markdown="1"> When invoking this API, you must use either the `StreamARN` or the
    # `StreamName` parameter, or both. It is recommended that you use the
    # `StreamARN` input parameter when you invoke this API.
    #
    #  </note>
    #
    # Stopping encryption is an asynchronous operation. Upon receiving the
    # request, Kinesis Data Streams returns immediately and sets the status
    # of the stream to `UPDATING`. After the update is complete, Kinesis
    # Data Streams sets the status of the stream back to `ACTIVE`. Stopping
    # encryption normally takes a few seconds to complete, but it can take
    # minutes. You can continue to read and write data to your stream while
    # its status is `UPDATING`. Once the status of the stream is `ACTIVE`,
    # records written to the stream are no longer encrypted by Kinesis Data
    # Streams.
    #
    # API Limits: You can successfully disable server-side encryption 25
    # times in a rolling 24-hour period.
    #
    # Note: It can take up to 5 seconds after the stream is in an `ACTIVE`
    # status before all records written to the stream are no longer subject
    # to encryption. After you disabled encryption, you can verify that
    # encryption is not applied by inspecting the API response from
    # `PutRecord` or `PutRecords`.
    #
    # @option params [String] :stream_name
    #   The name of the stream on which to stop encrypting records.
    #
    # @option params [required, String] :encryption_type
    #   The encryption type. The only valid value is `KMS`.
    #
    # @option params [required, String] :key_id
    #   The GUID for the customer-managed Amazon Web Services KMS key to use
    #   for encryption. This value can be a globally unique identifier, a
    #   fully specified Amazon Resource Name (ARN) to either an alias or a
    #   key, or an alias name prefixed by "alias/".You can also use a master
    #   key owned by Kinesis Data Streams by specifying the alias
    #   `aws/kinesis`.
    #
    #   * Key ARN example:
    #     `arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012`
    #
    #   * Alias ARN example:
    #     `arn:aws:kms:us-east-1:123456789012:alias/MyAliasName`
    #
    #   * Globally unique key ID example:
    #     `12345678-1234-1234-1234-123456789012`
    #
    #   * Alias name example: `alias/MyAliasName`
    #
    #   * Master key owned by Kinesis Data Streams: `alias/aws/kinesis`
    #
    # @option params [String] :stream_arn
    #   The ARN of the stream.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.stop_stream_encryption({
    #     stream_name: "StreamName",
    #     encryption_type: "NONE", # required, accepts NONE, KMS
    #     key_id: "KeyId", # required
    #     stream_arn: "StreamARN",
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/StopStreamEncryption AWS API Documentation
    #
    # @overload stop_stream_encryption(params = {})
    # @param [Hash] params ({})
    def stop_stream_encryption(params = {}, options = {})
      req = build_request(:stop_stream_encryption, params)
      req.send_request(options)
    end

    # Adds or updates tags for the specified Kinesis resource. Each tag is a
    # label consisting of a user-defined key and value. Tags can help you
    # manage, identify, organize, search for, and filter resources. You can
    # assign up to 50 tags to a Kinesis resource.
    #
    # @option params [required, Hash<String,String>] :tags
    #   An array of tags to be added to the Kinesis resource. A tag consists
    #   of a required key and an optional value. You can add up to 50 tags per
    #   resource.
    #
    #   Tags may only contain Unicode letters, digits, white space, or these
    #   symbols: \_ . : / = + - @.
    #
    # @option params [required, String] :resource_arn
    #   The Amazon Resource Name (ARN) of the Kinesis resource to which to add
    #   tags.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.tag_resource({
    #     tags: { # required
    #       "TagKey" => "TagValue",
    #     },
    #     resource_arn: "ResourceARN", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/TagResource AWS API Documentation
    #
    # @overload tag_resource(params = {})
    # @param [Hash] params ({})
    def tag_resource(params = {}, options = {})
      req = build_request(:tag_resource, params)
      req.send_request(options)
    end

    # Removes tags from the specified Kinesis resource. Removed tags are
    # deleted and can't be recovered after this operation completes
    # successfully.
    #
    # @option params [required, Array<String>] :tag_keys
    #   A list of tag key-value pairs. Existing tags of the resource whose
    #   keys are members of this list will be removed from the Kinesis
    #   resource.
    #
    # @option params [required, String] :resource_arn
    #   The Amazon Resource Name (ARN) of the Kinesis resource from which to
    #   remove tags.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.untag_resource({
    #     tag_keys: ["TagKey"], # required
    #     resource_arn: "ResourceARN", # required
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/UntagResource AWS API Documentation
    #
    # @overload untag_resource(params = {})
    # @param [Hash] params ({})
    def untag_resource(params = {}, options = {})
      req = build_request(:untag_resource, params)
      req.send_request(options)
    end

    # Updates the shard count of the specified stream to the specified
    # number of shards. This API is only supported for the data streams with
    # the provisioned capacity mode.
    #
    # <note markdown="1"> When invoking this API, you must use either the `StreamARN` or the
    # `StreamName` parameter, or both. It is recommended that you use the
    # `StreamARN` input parameter when you invoke this API.
    #
    #  </note>
    #
    # Updating the shard count is an asynchronous operation. Upon receiving
    # the request, Kinesis Data Streams returns immediately and sets the
    # status of the stream to `UPDATING`. After the update is complete,
    # Kinesis Data Streams sets the status of the stream back to `ACTIVE`.
    # Depending on the size of the stream, the scaling action could take a
    # few minutes to complete. You can continue to read and write data to
    # your stream while its status is `UPDATING`.
    #
    # To update the shard count, Kinesis Data Streams performs splits or
    # merges on individual shards. This can cause short-lived shards to be
    # created, in addition to the final shards. These short-lived shards
    # count towards your total shard limit for your account in the Region.
    #
    # When using this operation, we recommend that you specify a target
    # shard count that is a multiple of 25% (25%, 50%, 75%, 100%). You can
    # specify any target value within your shard limit. However, if you
    # specify a target that isn't a multiple of 25%, the scaling action
    # might take longer to complete.
    #
    # This operation has the following default limits. By default, you
    # cannot do the following:
    #
    # * Scale more than ten times per rolling 24-hour period per stream
    #
    # * Scale up to more than double your current shard count for a stream
    #
    # * Scale down below half your current shard count for a stream
    #
    # * Scale up to more than 10000 shards in a stream
    #
    # * Scale a stream with more than 10000 shards down unless the result is
    #   less than 10000 shards
    #
    # * Scale up to more than the shard limit for your account
    #
    # * Make over 10 TPS. TPS over 10 will trigger the
    #   LimitExceededException
    #
    # For the default limits for an Amazon Web Services account, see
    # [Streams Limits][1] in the *Amazon Kinesis Data Streams Developer
    # Guide*. To request an increase in the call rate limit, the shard limit
    # for this API, or your overall shard limit, use the [limits form][2].
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html
    # [2]: https://console.aws.amazon.com/support/v1#/case/create?issueType=service-limit-increase&amp;limitType=service-code-kinesis
    #
    # @option params [String] :stream_name
    #   The name of the stream.
    #
    # @option params [required, Integer] :target_shard_count
    #   The new number of shards. This value has the following default limits.
    #   By default, you cannot do the following:
    #
    #   * Set this value to more than double your current shard count for a
    #     stream.
    #
    #   * Set this value below half your current shard count for a stream.
    #
    #   * Set this value to more than 10000 shards in a stream (the default
    #     limit for shard count per stream is 10000 per account per region),
    #     unless you request a limit increase.
    #
    #   * Scale a stream with more than 10000 shards down unless you set this
    #     value to less than 10000 shards.
    #
    # @option params [required, String] :scaling_type
    #   The scaling type. Uniform scaling creates shards of equal size.
    #
    # @option params [String] :stream_arn
    #   The ARN of the stream.
    #
    # @return [Types::UpdateShardCountOutput] Returns a {Seahorse::Client::Response response} object which responds to the following methods:
    #
    #   * {Types::UpdateShardCountOutput#stream_name #stream_name} => String
    #   * {Types::UpdateShardCountOutput#current_shard_count #current_shard_count} => Integer
    #   * {Types::UpdateShardCountOutput#target_shard_count #target_shard_count} => Integer
    #   * {Types::UpdateShardCountOutput#stream_arn #stream_arn} => String
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.update_shard_count({
    #     stream_name: "StreamName",
    #     target_shard_count: 1, # required
    #     scaling_type: "UNIFORM_SCALING", # required, accepts UNIFORM_SCALING
    #     stream_arn: "StreamARN",
    #   })
    #
    # @example Response structure
    #
    #   resp.stream_name #=> String
    #   resp.current_shard_count #=> Integer
    #   resp.target_shard_count #=> Integer
    #   resp.stream_arn #=> String
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/UpdateShardCount AWS API Documentation
    #
    # @overload update_shard_count(params = {})
    # @param [Hash] params ({})
    def update_shard_count(params = {}, options = {})
      req = build_request(:update_shard_count, params)
      req.send_request(options)
    end

    # Updates the capacity mode of the data stream. Currently, in Kinesis
    # Data Streams, you can choose between an **on-demand** capacity mode
    # and a **provisioned** capacity mode for your data stream.
    #
    # @option params [required, String] :stream_arn
    #   Specifies the ARN of the data stream whose capacity mode you want to
    #   update.
    #
    # @option params [required, Types::StreamModeDetails] :stream_mode_details
    #   Specifies the capacity mode to which you want to set your data stream.
    #   Currently, in Kinesis Data Streams, you can choose between an
    #   **on-demand** capacity mode and a **provisioned** capacity mode for
    #   your data streams.
    #
    # @return [Struct] Returns an empty {Seahorse::Client::Response response}.
    #
    # @example Request syntax with placeholder values
    #
    #   resp = client.update_stream_mode({
    #     stream_arn: "StreamARN", # required
    #     stream_mode_details: { # required
    #       stream_mode: "PROVISIONED", # required, accepts PROVISIONED, ON_DEMAND
    #     },
    #   })
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/UpdateStreamMode AWS API Documentation
    #
    # @overload update_stream_mode(params = {})
    # @param [Hash] params ({})
    def update_stream_mode(params = {}, options = {})
      req = build_request(:update_stream_mode, params)
      req.send_request(options)
    end

    # @!endgroup

    # @param params ({})
    # @api private
    def build_request(operation_name, params = {})
      handlers = @handlers.for(operation_name)
      tracer = config.telemetry_provider.tracer_provider.tracer(
        Aws::Telemetry.module_to_tracer_name('Aws::Kinesis')
      )
      context = Seahorse::Client::RequestContext.new(
        operation_name: operation_name,
        operation: config.api.operation(operation_name),
        client: self,
        params: params,
        config: config,
        tracer: tracer
      )
      context[:gem_name] = 'aws-sdk-kinesis'
      context[:gem_version] = '1.80.0'
      Seahorse::Client::Request.new(handlers, context)
    end

    # Polls an API operation until a resource enters a desired state.
    #
    # ## Basic Usage
    #
    # A waiter will call an API operation until:
    #
    # * It is successful
    # * It enters a terminal state
    # * It makes the maximum number of attempts
    #
    # In between attempts, the waiter will sleep.
    #
    #     # polls in a loop, sleeping between attempts
    #     client.wait_until(waiter_name, params)
    #
    # ## Configuration
    #
    # You can configure the maximum number of polling attempts, and the
    # delay (in seconds) between each polling attempt. You can pass
    # configuration as the final arguments hash.
    #
    #     # poll for ~25 seconds
    #     client.wait_until(waiter_name, params, {
    #       max_attempts: 5,
    #       delay: 5,
    #     })
    #
    # ## Callbacks
    #
    # You can be notified before each polling attempt and before each
    # delay. If you throw `:success` or `:failure` from these callbacks,
    # it will terminate the waiter.
    #
    #     started_at = Time.now
    #     client.wait_until(waiter_name, params, {
    #
    #       # disable max attempts
    #       max_attempts: nil,
    #
    #       # poll for 1 hour, instead of a number of attempts
    #       before_wait: -> (attempts, response) do
    #         throw :failure if Time.now - started_at > 3600
    #       end
    #     })
    #
    # ## Handling Errors
    #
    # When a waiter is unsuccessful, it will raise an error.
    # All of the failure errors extend from
    # {Aws::Waiters::Errors::WaiterFailed}.
    #
    #     begin
    #       client.wait_until(...)
    #     rescue Aws::Waiters::Errors::WaiterFailed
    #       # resource did not enter the desired state in time
    #     end
    #
    # ## Valid Waiters
    #
    # The following table lists the valid waiter names, the operations they call,
    # and the default `:delay` and `:max_attempts` values.
    #
    # | waiter_name       | params                   | :delay   | :max_attempts |
    # | ----------------- | ------------------------ | -------- | ------------- |
    # | stream_exists     | {Client#describe_stream} | 10       | 18            |
    # | stream_not_exists | {Client#describe_stream} | 10       | 18            |
    #
    # @raise [Errors::FailureStateError] Raised when the waiter terminates
    #   because the waiter has entered a state that it will not transition
    #   out of, preventing success.
    #
    # @raise [Errors::TooManyAttemptsError] Raised when the configured
    #   maximum number of attempts have been made, and the waiter is not
    #   yet successful.
    #
    # @raise [Errors::UnexpectedError] Raised when an error is encounted
    #   while polling for a resource that is not expected.
    #
    # @raise [Errors::NoSuchWaiterError] Raised when you request to wait
    #   for an unknown state.
    #
    # @return [Boolean] Returns `true` if the waiter was successful.
    # @param [Symbol] waiter_name
    # @param [Hash] params ({})
    # @param [Hash] options ({})
    # @option options [Integer] :max_attempts
    # @option options [Integer] :delay
    # @option options [Proc] :before_attempt
    # @option options [Proc] :before_wait
    def wait_until(waiter_name, params = {}, options = {})
      w = waiter(waiter_name, options)
      yield(w.waiter) if block_given? # deprecated
      w.wait(params)
    end

    # @api private
    # @deprecated
    def waiter_names
      waiters.keys
    end

    private

    # @param [Symbol] waiter_name
    # @param [Hash] options ({})
    def waiter(waiter_name, options = {})
      waiter_class = waiters[waiter_name]
      if waiter_class
        waiter_class.new(options.merge(client: self))
      else
        raise Aws::Waiters::Errors::NoSuchWaiterError.new(waiter_name, waiters.keys)
      end
    end

    def waiters
      {
        stream_exists: Waiters::StreamExists,
        stream_not_exists: Waiters::StreamNotExists
      }
    end

    class << self

      # @api private
      attr_reader :identifier

      # @api private
      def errors_module
        Errors
      end

    end
  end
end
