# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2018_06_01
  module Models
    #
    # The publishing profile of a gallery Image Version.
    #
    class GalleryImageVersionPublishingProfile < GalleryArtifactPublishingProfileBase

      include MsRestAzure

      # @return [Integer] The number of replicas of the Image Version to be
      # created per region. This property would take effect for a region when
      # regionalReplicaCount is not specified. This property is updatable.
      attr_accessor :replica_count

      # @return [Boolean] If set to true, Virtual Machines deployed from the
      # latest version of the Image Definition won't use this Image Version.
      attr_accessor :exclude_from_latest

      # @return [DateTime] The timestamp for when the gallery Image Version is
      # published.
      attr_accessor :published_date

      # @return [DateTime] The end of life date of the gallery Image Version.
      # This property can be used for decommissioning purposes. This property
      # is updatable.
      attr_accessor :end_of_life_date


      #
      # Mapper for GalleryImageVersionPublishingProfile class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'GalleryImageVersionPublishingProfile',
          type: {
            name: 'Composite',
            class_name: 'GalleryImageVersionPublishingProfile',
            model_properties: {
              target_regions: {
                client_side_validation: true,
                required: false,
                serialized_name: 'targetRegions',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'TargetRegionElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'TargetRegion'
                      }
                  }
                }
              },
              source: {
                client_side_validation: true,
                required: true,
                serialized_name: 'source',
                type: {
                  name: 'Composite',
                  class_name: 'GalleryArtifactSource'
                }
              },
              replica_count: {
                client_side_validation: true,
                required: false,
                serialized_name: 'replicaCount',
                type: {
                  name: 'Number'
                }
              },
              exclude_from_latest: {
                client_side_validation: true,
                required: false,
                serialized_name: 'excludeFromLatest',
                type: {
                  name: 'Boolean'
                }
              },
              published_date: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'publishedDate',
                type: {
                  name: 'DateTime'
                }
              },
              end_of_life_date: {
                client_side_validation: true,
                required: false,
                serialized_name: 'endOfLifeDate',
                type: {
                  name: 'DateTime'
                }
              }
            }
          }
        }
      end
    end
  end
end
