# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2019_04_01
  module Models
    #
    # Describes scaling information of a SKU.
    #
    class ResourceSkuRestrictions

      include MsRestAzure

      # @return [ResourceSkuRestrictionsType] The type of restrictions.
      # Possible values include: 'Location', 'Zone'
      attr_accessor :type

      # @return [Array<String>] The value of restrictions. If the restriction
      # type is set to location. This would be different locations where the
      # SKU is restricted.
      attr_accessor :values

      # @return [ResourceSkuRestrictionInfo] The information about the
      # restriction where the SKU cannot be used.
      attr_accessor :restriction_info

      # @return [ResourceSkuRestrictionsReasonCode] The reason for restriction.
      # Possible values include: 'QuotaId', 'NotAvailableForSubscription'
      attr_accessor :reason_code


      #
      # Mapper for ResourceSkuRestrictions class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'ResourceSkuRestrictions',
          type: {
            name: 'Composite',
            class_name: 'ResourceSkuRestrictions',
            model_properties: {
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'Enum',
                  module: 'ResourceSkuRestrictionsType'
                }
              },
              values: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'values',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              restriction_info: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'restrictionInfo',
                type: {
                  name: 'Composite',
                  class_name: 'ResourceSkuRestrictionInfo'
                }
              },
              reason_code: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'reasonCode',
                type: {
                  name: 'Enum',
                  module: 'ResourceSkuRestrictionsReasonCode'
                }
              }
            }
          }
        }
      end
    end
  end
end
