# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2019_12_01
  module Models
    #
    # Describes the parameters of ephemeral disk settings that can be specified
    # for operating system disk. <br><br> NOTE: The ephemeral disk settings can
    # only be specified for managed disk.
    #
    class DiffDiskSettings

      include MsRestAzure

      # @return [DiffDiskOptions] Specifies the ephemeral disk settings for
      # operating system disk. Possible values include: 'Local'
      attr_accessor :option

      # @return [DiffDiskPlacement] Specifies the ephemeral disk placement for
      # operating system disk.<br><br> Possible values are: <br><br>
      # **CacheDisk** <br><br> **ResourceDisk** <br><br> Default: **CacheDisk**
      # if one is configured for the VM size otherwise **ResourceDisk** is
      # used.<br><br> Refer to VM size documentation for Windows VM at
      # https://docs.microsoft.com/en-us/azure/virtual-machines/windows/sizes
      # and Linux VM at
      # https://docs.microsoft.com/en-us/azure/virtual-machines/linux/sizes to
      # check which VM sizes exposes a cache disk. Possible values include:
      # 'CacheDisk', 'ResourceDisk'
      attr_accessor :placement


      #
      # Mapper for DiffDiskSettings class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'DiffDiskSettings',
          type: {
            name: 'Composite',
            class_name: 'DiffDiskSettings',
            model_properties: {
              option: {
                client_side_validation: true,
                required: false,
                serialized_name: 'option',
                type: {
                  name: 'String'
                }
              },
              placement: {
                client_side_validation: true,
                required: false,
                serialized_name: 'placement',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
