# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2019_12_01
  #
  # Compute Client
  #
  class VirtualMachineScaleSetVMs
    include MsRestAzure

    #
    # Creates and initializes a new instance of the VirtualMachineScaleSetVMs class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [ComputeManagementClient] reference to the ComputeManagementClient
    attr_reader :client

    #
    # Reimages (upgrade the operating system) a specific virtual machine in a VM
    # scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param vm_scale_set_vmreimage_input
    # [VirtualMachineScaleSetVMReimageParameters] Parameters for the Reimaging
    # Virtual machine in ScaleSet.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def reimage(resource_group_name, vm_scale_set_name, instance_id, vm_scale_set_vmreimage_input:nil, custom_headers:nil)
      response = reimage_async(resource_group_name, vm_scale_set_name, instance_id, vm_scale_set_vmreimage_input:vm_scale_set_vmreimage_input, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param vm_scale_set_vmreimage_input
    # [VirtualMachineScaleSetVMReimageParameters] Parameters for the Reimaging
    # Virtual machine in ScaleSet.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def reimage_async(resource_group_name, vm_scale_set_name, instance_id, vm_scale_set_vmreimage_input:nil, custom_headers:nil)
      # Send request
      promise = begin_reimage_async(resource_group_name, vm_scale_set_name, instance_id, vm_scale_set_vmreimage_input:vm_scale_set_vmreimage_input, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Allows you to re-image all the disks ( including data disks ) in the a VM
    # scale set instance. This operation is only supported for managed disks.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def reimage_all(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      response = reimage_all_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def reimage_all_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      # Send request
      promise = begin_reimage_all_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Deallocates a specific virtual machine in a VM scale set. Shuts down the
    # virtual machine and releases the compute resources it uses. You are not
    # billed for the compute resources of this virtual machine once it is
    # deallocated.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def deallocate(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      response = deallocate_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def deallocate_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      # Send request
      promise = begin_deallocate_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Updates a virtual machine of a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set where the
    # extension should be create or updated.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param parameters [VirtualMachineScaleSetVM] Parameters supplied to the
    # Update Virtual Machine Scale Sets VM operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSetVM] operation results.
    #
    def update(resource_group_name, vm_scale_set_name, instance_id, parameters, custom_headers:nil)
      response = update_async(resource_group_name, vm_scale_set_name, instance_id, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set where the
    # extension should be create or updated.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param parameters [VirtualMachineScaleSetVM] Parameters supplied to the
    # Update Virtual Machine Scale Sets VM operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def update_async(resource_group_name, vm_scale_set_name, instance_id, parameters, custom_headers:nil)
      # Send request
      promise = begin_update_async(resource_group_name, vm_scale_set_name, instance_id, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineScaleSetVM.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Deletes a virtual machine from a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      response = delete_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      # Send request
      promise = begin_delete_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets a virtual machine from a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param expand [InstanceViewTypes] The expand expression to apply on the
    # operation. Possible values include: 'instanceView'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSetVM] operation results.
    #
    def get(resource_group_name, vm_scale_set_name, instance_id, expand:nil, custom_headers:nil)
      response = get_async(resource_group_name, vm_scale_set_name, instance_id, expand:expand, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a virtual machine from a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param expand [InstanceViewTypes] The expand expression to apply on the
    # operation. Possible values include: 'instanceView'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, vm_scale_set_name, instance_id, expand:nil, custom_headers:nil)
      get_async(resource_group_name, vm_scale_set_name, instance_id, expand:expand, custom_headers:custom_headers).value!
    end

    #
    # Gets a virtual machine from a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param expand [InstanceViewTypes] The expand expression to apply on the
    # operation. Possible values include: 'instanceView'
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, vm_scale_set_name, instance_id, expand:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'$expand' => expand,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineScaleSetVM.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the status of a virtual machine from a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSetVMInstanceView] operation results.
    #
    def get_instance_view(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      response = get_instance_view_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the status of a virtual machine from a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_instance_view_with_http_info(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      get_instance_view_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
    end

    #
    # Gets the status of a virtual machine from a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_instance_view_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/instanceView'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineScaleSetVMInstanceView.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a list of all virtual machines in a VM scale sets.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_machine_scale_set_name [String] The name of the VM scale set.
    # @param filter [String] The filter to apply to the operation. Allowed values
    # are 'startswith(instanceView/statuses/code, 'PowerState') eq true',
    # 'properties/latestModelApplied eq true', 'properties/latestModelApplied eq
    # false'.
    # @param select [String] The list parameters. Allowed values are
    # 'instanceView', 'instanceView/statuses'.
    # @param expand [String] The expand expression to apply to the operation.
    # Allowed values are 'instanceView'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<VirtualMachineScaleSetVM>] operation results.
    #
    def list(resource_group_name, virtual_machine_scale_set_name, filter:nil, select:nil, expand:nil, custom_headers:nil)
      first_page = list_as_lazy(resource_group_name, virtual_machine_scale_set_name, filter:filter, select:select, expand:expand, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Gets a list of all virtual machines in a VM scale sets.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_machine_scale_set_name [String] The name of the VM scale set.
    # @param filter [String] The filter to apply to the operation. Allowed values
    # are 'startswith(instanceView/statuses/code, 'PowerState') eq true',
    # 'properties/latestModelApplied eq true', 'properties/latestModelApplied eq
    # false'.
    # @param select [String] The list parameters. Allowed values are
    # 'instanceView', 'instanceView/statuses'.
    # @param expand [String] The expand expression to apply to the operation.
    # Allowed values are 'instanceView'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(resource_group_name, virtual_machine_scale_set_name, filter:nil, select:nil, expand:nil, custom_headers:nil)
      list_async(resource_group_name, virtual_machine_scale_set_name, filter:filter, select:select, expand:expand, custom_headers:custom_headers).value!
    end

    #
    # Gets a list of all virtual machines in a VM scale sets.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_machine_scale_set_name [String] The name of the VM scale set.
    # @param filter [String] The filter to apply to the operation. Allowed values
    # are 'startswith(instanceView/statuses/code, 'PowerState') eq true',
    # 'properties/latestModelApplied eq true', 'properties/latestModelApplied eq
    # false'.
    # @param select [String] The list parameters. Allowed values are
    # 'instanceView', 'instanceView/statuses'.
    # @param expand [String] The expand expression to apply to the operation.
    # Allowed values are 'instanceView'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(resource_group_name, virtual_machine_scale_set_name, filter:nil, select:nil, expand:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_machine_scale_set_name is nil' if virtual_machine_scale_set_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{virtualMachineScaleSetName}/virtualMachines'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualMachineScaleSetName' => virtual_machine_scale_set_name,'subscriptionId' => @client.subscription_id},
          query_params: {'$filter' => filter,'$select' => select,'$expand' => expand,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineScaleSetVMListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Power off (stop) a virtual machine in a VM scale set. Note that resources are
    # still attached and you are getting charged for the resources. Instead, use
    # deallocate to release resources and avoid charges.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param skip_shutdown [Boolean] The parameter to request non-graceful VM
    # shutdown. True value for this flag indicates non-graceful shutdown whereas
    # false indicates otherwise. Default value for this flag is false if not
    # specified
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def power_off(resource_group_name, vm_scale_set_name, instance_id, skip_shutdown:false, custom_headers:nil)
      response = power_off_async(resource_group_name, vm_scale_set_name, instance_id, skip_shutdown:skip_shutdown, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param skip_shutdown [Boolean] The parameter to request non-graceful VM
    # shutdown. True value for this flag indicates non-graceful shutdown whereas
    # false indicates otherwise. Default value for this flag is false if not
    # specified
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def power_off_async(resource_group_name, vm_scale_set_name, instance_id, skip_shutdown:false, custom_headers:nil)
      # Send request
      promise = begin_power_off_async(resource_group_name, vm_scale_set_name, instance_id, skip_shutdown:skip_shutdown, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Restarts a virtual machine in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def restart(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      response = restart_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def restart_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      # Send request
      promise = begin_restart_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Starts a virtual machine in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def start(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      response = start_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def start_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      # Send request
      promise = begin_start_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Shuts down the virtual machine in the virtual machine scale set, moves it to
    # a new node, and powers it back on.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def redeploy(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      response = redeploy_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def redeploy_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      # Send request
      promise = begin_redeploy_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Shuts down the virtual machine in a VMScaleSet, moves it to an already
    # updated node, and powers it back on during the self-service phase of planned
    # maintenance.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def perform_maintenance(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      response = perform_maintenance_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def perform_maintenance_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      # Send request
      promise = begin_perform_maintenance_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # The operation to simulate the eviction of spot virtual machine in a VM scale
    # set. The eviction will occur within 30 minutes of calling the API
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def simulate_eviction(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      response = simulate_eviction_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
      nil
    end

    #
    # The operation to simulate the eviction of spot virtual machine in a VM scale
    # set. The eviction will occur within 30 minutes of calling the API
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def simulate_eviction_with_http_info(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      simulate_eviction_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
    end

    #
    # The operation to simulate the eviction of spot virtual machine in a VM scale
    # set. The eviction will occur within 30 minutes of calling the API
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def simulate_eviction_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/simulateEviction'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Run command on a virtual machine in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param parameters [RunCommandInput] Parameters supplied to the Run command
    # operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RunCommandResult] operation results.
    #
    def run_command(resource_group_name, vm_scale_set_name, instance_id, parameters, custom_headers:nil)
      response = run_command_async(resource_group_name, vm_scale_set_name, instance_id, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param parameters [RunCommandInput] Parameters supplied to the Run command
    # operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def run_command_async(resource_group_name, vm_scale_set_name, instance_id, parameters, custom_headers:nil)
      # Send request
      promise = begin_run_command_async(resource_group_name, vm_scale_set_name, instance_id, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::RunCommandResult.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Reimages (upgrade the operating system) a specific virtual machine in a VM
    # scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param vm_scale_set_vmreimage_input
    # [VirtualMachineScaleSetVMReimageParameters] Parameters for the Reimaging
    # Virtual machine in ScaleSet.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_reimage(resource_group_name, vm_scale_set_name, instance_id, vm_scale_set_vmreimage_input:nil, custom_headers:nil)
      response = begin_reimage_async(resource_group_name, vm_scale_set_name, instance_id, vm_scale_set_vmreimage_input:vm_scale_set_vmreimage_input, custom_headers:custom_headers).value!
      nil
    end

    #
    # Reimages (upgrade the operating system) a specific virtual machine in a VM
    # scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param vm_scale_set_vmreimage_input
    # [VirtualMachineScaleSetVMReimageParameters] Parameters for the Reimaging
    # Virtual machine in ScaleSet.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_reimage_with_http_info(resource_group_name, vm_scale_set_name, instance_id, vm_scale_set_vmreimage_input:nil, custom_headers:nil)
      begin_reimage_async(resource_group_name, vm_scale_set_name, instance_id, vm_scale_set_vmreimage_input:vm_scale_set_vmreimage_input, custom_headers:custom_headers).value!
    end

    #
    # Reimages (upgrade the operating system) a specific virtual machine in a VM
    # scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param vm_scale_set_vmreimage_input
    # [VirtualMachineScaleSetVMReimageParameters] Parameters for the Reimaging
    # Virtual machine in ScaleSet.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_reimage_async(resource_group_name, vm_scale_set_name, instance_id, vm_scale_set_vmreimage_input:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineScaleSetVMReimageParameters.mapper()
      request_content = @client.serialize(request_mapper,  vm_scale_set_vmreimage_input)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/reimage'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Allows you to re-image all the disks ( including data disks ) in the a VM
    # scale set instance. This operation is only supported for managed disks.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_reimage_all(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      response = begin_reimage_all_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
      nil
    end

    #
    # Allows you to re-image all the disks ( including data disks ) in the a VM
    # scale set instance. This operation is only supported for managed disks.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_reimage_all_with_http_info(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      begin_reimage_all_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
    end

    #
    # Allows you to re-image all the disks ( including data disks ) in the a VM
    # scale set instance. This operation is only supported for managed disks.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_reimage_all_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/reimageall'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Deallocates a specific virtual machine in a VM scale set. Shuts down the
    # virtual machine and releases the compute resources it uses. You are not
    # billed for the compute resources of this virtual machine once it is
    # deallocated.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_deallocate(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      response = begin_deallocate_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
      nil
    end

    #
    # Deallocates a specific virtual machine in a VM scale set. Shuts down the
    # virtual machine and releases the compute resources it uses. You are not
    # billed for the compute resources of this virtual machine once it is
    # deallocated.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_deallocate_with_http_info(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      begin_deallocate_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
    end

    #
    # Deallocates a specific virtual machine in a VM scale set. Shuts down the
    # virtual machine and releases the compute resources it uses. You are not
    # billed for the compute resources of this virtual machine once it is
    # deallocated.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_deallocate_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/deallocate'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Updates a virtual machine of a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set where the
    # extension should be create or updated.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param parameters [VirtualMachineScaleSetVM] Parameters supplied to the
    # Update Virtual Machine Scale Sets VM operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSetVM] operation results.
    #
    def begin_update(resource_group_name, vm_scale_set_name, instance_id, parameters, custom_headers:nil)
      response = begin_update_async(resource_group_name, vm_scale_set_name, instance_id, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates a virtual machine of a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set where the
    # extension should be create or updated.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param parameters [VirtualMachineScaleSetVM] Parameters supplied to the
    # Update Virtual Machine Scale Sets VM operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_update_with_http_info(resource_group_name, vm_scale_set_name, instance_id, parameters, custom_headers:nil)
      begin_update_async(resource_group_name, vm_scale_set_name, instance_id, parameters, custom_headers:custom_headers).value!
    end

    #
    # Updates a virtual machine of a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set where the
    # extension should be create or updated.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param parameters [VirtualMachineScaleSetVM] Parameters supplied to the
    # Update Virtual Machine Scale Sets VM operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_update_async(resource_group_name, vm_scale_set_name, instance_id, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineScaleSetVM.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineScaleSetVM.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineScaleSetVM.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a virtual machine from a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      response = begin_delete_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
      nil
    end

    #
    # Deletes a virtual machine from a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      begin_delete_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
    end

    #
    # Deletes a virtual machine from a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Power off (stop) a virtual machine in a VM scale set. Note that resources are
    # still attached and you are getting charged for the resources. Instead, use
    # deallocate to release resources and avoid charges.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param skip_shutdown [Boolean] The parameter to request non-graceful VM
    # shutdown. True value for this flag indicates non-graceful shutdown whereas
    # false indicates otherwise. Default value for this flag is false if not
    # specified
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_power_off(resource_group_name, vm_scale_set_name, instance_id, skip_shutdown:false, custom_headers:nil)
      response = begin_power_off_async(resource_group_name, vm_scale_set_name, instance_id, skip_shutdown:skip_shutdown, custom_headers:custom_headers).value!
      nil
    end

    #
    # Power off (stop) a virtual machine in a VM scale set. Note that resources are
    # still attached and you are getting charged for the resources. Instead, use
    # deallocate to release resources and avoid charges.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param skip_shutdown [Boolean] The parameter to request non-graceful VM
    # shutdown. True value for this flag indicates non-graceful shutdown whereas
    # false indicates otherwise. Default value for this flag is false if not
    # specified
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_power_off_with_http_info(resource_group_name, vm_scale_set_name, instance_id, skip_shutdown:false, custom_headers:nil)
      begin_power_off_async(resource_group_name, vm_scale_set_name, instance_id, skip_shutdown:skip_shutdown, custom_headers:custom_headers).value!
    end

    #
    # Power off (stop) a virtual machine in a VM scale set. Note that resources are
    # still attached and you are getting charged for the resources. Instead, use
    # deallocate to release resources and avoid charges.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param skip_shutdown [Boolean] The parameter to request non-graceful VM
    # shutdown. True value for this flag indicates non-graceful shutdown whereas
    # false indicates otherwise. Default value for this flag is false if not
    # specified
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_power_off_async(resource_group_name, vm_scale_set_name, instance_id, skip_shutdown:false, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/poweroff'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'skipShutdown' => skip_shutdown,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Restarts a virtual machine in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_restart(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      response = begin_restart_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
      nil
    end

    #
    # Restarts a virtual machine in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_restart_with_http_info(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      begin_restart_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
    end

    #
    # Restarts a virtual machine in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_restart_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/restart'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Starts a virtual machine in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_start(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      response = begin_start_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
      nil
    end

    #
    # Starts a virtual machine in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_start_with_http_info(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      begin_start_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
    end

    #
    # Starts a virtual machine in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_start_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/start'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Shuts down the virtual machine in the virtual machine scale set, moves it to
    # a new node, and powers it back on.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_redeploy(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      response = begin_redeploy_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
      nil
    end

    #
    # Shuts down the virtual machine in the virtual machine scale set, moves it to
    # a new node, and powers it back on.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_redeploy_with_http_info(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      begin_redeploy_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
    end

    #
    # Shuts down the virtual machine in the virtual machine scale set, moves it to
    # a new node, and powers it back on.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_redeploy_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/redeploy'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Shuts down the virtual machine in a VMScaleSet, moves it to an already
    # updated node, and powers it back on during the self-service phase of planned
    # maintenance.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_perform_maintenance(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      response = begin_perform_maintenance_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
      nil
    end

    #
    # Shuts down the virtual machine in a VMScaleSet, moves it to an already
    # updated node, and powers it back on during the self-service phase of planned
    # maintenance.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_perform_maintenance_with_http_info(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      begin_perform_maintenance_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:custom_headers).value!
    end

    #
    # Shuts down the virtual machine in a VMScaleSet, moves it to an already
    # updated node, and powers it back on during the self-service phase of planned
    # maintenance.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_perform_maintenance_async(resource_group_name, vm_scale_set_name, instance_id, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/performMaintenance'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Run command on a virtual machine in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param parameters [RunCommandInput] Parameters supplied to the Run command
    # operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RunCommandResult] operation results.
    #
    def begin_run_command(resource_group_name, vm_scale_set_name, instance_id, parameters, custom_headers:nil)
      response = begin_run_command_async(resource_group_name, vm_scale_set_name, instance_id, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Run command on a virtual machine in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param parameters [RunCommandInput] Parameters supplied to the Run command
    # operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_run_command_with_http_info(resource_group_name, vm_scale_set_name, instance_id, parameters, custom_headers:nil)
      begin_run_command_async(resource_group_name, vm_scale_set_name, instance_id, parameters, custom_headers:custom_headers).value!
    end

    #
    # Run command on a virtual machine in a VM scale set.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_scale_set_name [String] The name of the VM scale set.
    # @param instance_id [String] The instance ID of the virtual machine.
    # @param parameters [RunCommandInput] Parameters supplied to the Run command
    # operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_run_command_async(resource_group_name, vm_scale_set_name, instance_id, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_scale_set_name is nil' if vm_scale_set_name.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::RunCommandInput.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/runCommand'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmScaleSetName' => vm_scale_set_name,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::RunCommandResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a list of all virtual machines in a VM scale sets.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSetVMListResult] operation results.
    #
    def list_next(next_page_link, custom_headers:nil)
      response = list_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a list of all virtual machines in a VM scale sets.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers:nil)
      list_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Gets a list of all virtual machines in a VM scale sets.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineScaleSetVMListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a list of all virtual machines in a VM scale sets.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_machine_scale_set_name [String] The name of the VM scale set.
    # @param filter [String] The filter to apply to the operation. Allowed values
    # are 'startswith(instanceView/statuses/code, 'PowerState') eq true',
    # 'properties/latestModelApplied eq true', 'properties/latestModelApplied eq
    # false'.
    # @param select [String] The list parameters. Allowed values are
    # 'instanceView', 'instanceView/statuses'.
    # @param expand [String] The expand expression to apply to the operation.
    # Allowed values are 'instanceView'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineScaleSetVMListResult] which provide lazy access to
    # pages of the response.
    #
    def list_as_lazy(resource_group_name, virtual_machine_scale_set_name, filter:nil, select:nil, expand:nil, custom_headers:nil)
      response = list_async(resource_group_name, virtual_machine_scale_set_name, filter:filter, select:select, expand:expand, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

  end
end
