# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2019_12_01
  #
  # Compute Client
  #
  class VirtualMachines
    include MsRestAzure

    #
    # Creates and initializes a new instance of the VirtualMachines class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [ComputeManagementClient] reference to the ComputeManagementClient
    attr_reader :client

    #
    # Gets all the virtual machines under the specified subscription for the
    # specified location.
    #
    # @param location [String] The location for which virtual machines under the
    # subscription are queried.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<VirtualMachine>] operation results.
    #
    def list_by_location(location, custom_headers:nil)
      first_page = list_by_location_as_lazy(location, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Gets all the virtual machines under the specified subscription for the
    # specified location.
    #
    # @param location [String] The location for which virtual machines under the
    # subscription are queried.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_location_with_http_info(location, custom_headers:nil)
      list_by_location_async(location, custom_headers:custom_headers).value!
    end

    #
    # Gets all the virtual machines under the specified subscription for the
    # specified location.
    #
    # @param location [String] The location for which virtual machines under the
    # subscription are queried.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_location_async(location, custom_headers:nil)
      fail ArgumentError, 'location is nil' if location.nil?
      fail ArgumentError, "'location' should satisfy the constraint - 'Pattern': '^[-\w\._]+$'" if !location.nil? && location.match(Regexp.new('^^[-\w\._]+$$')).nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/virtualMachines'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'location' => location,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Captures the VM by copying virtual hard disks of the VM and outputs a
    # template that can be used to create similar VMs.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [VirtualMachineCaptureParameters] Parameters supplied to
    # the Capture Virtual Machine operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineCaptureResult] operation results.
    #
    def capture(resource_group_name, vm_name, parameters, custom_headers:nil)
      response = capture_async(resource_group_name, vm_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [VirtualMachineCaptureParameters] Parameters supplied to
    # the Capture Virtual Machine operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def capture_async(resource_group_name, vm_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_capture_async(resource_group_name, vm_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineCaptureResult.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # The operation to create or update a virtual machine. Please note some
    # properties can be set only during virtual machine creation.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [VirtualMachine] Parameters supplied to the Create Virtual
    # Machine operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachine] operation results.
    #
    def create_or_update(resource_group_name, vm_name, parameters, custom_headers:nil)
      response = create_or_update_async(resource_group_name, vm_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [VirtualMachine] Parameters supplied to the Create Virtual
    # Machine operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_async(resource_group_name, vm_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_create_or_update_async(resource_group_name, vm_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachine.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # The operation to update a virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [VirtualMachineUpdate] Parameters supplied to the Update
    # Virtual Machine operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachine] operation results.
    #
    def update(resource_group_name, vm_name, parameters, custom_headers:nil)
      response = update_async(resource_group_name, vm_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [VirtualMachineUpdate] Parameters supplied to the Update
    # Virtual Machine operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def update_async(resource_group_name, vm_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_update_async(resource_group_name, vm_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachine.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # The operation to delete a virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(resource_group_name, vm_name, custom_headers:nil)
      response = delete_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, vm_name, custom_headers:nil)
      # Send request
      promise = begin_delete_async(resource_group_name, vm_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Retrieves information about the model view or the instance view of a virtual
    # machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param expand [InstanceViewTypes] The expand expression to apply on the
    # operation. Possible values include: 'instanceView'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachine] operation results.
    #
    def get(resource_group_name, vm_name, expand:nil, custom_headers:nil)
      response = get_async(resource_group_name, vm_name, expand:expand, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves information about the model view or the instance view of a virtual
    # machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param expand [InstanceViewTypes] The expand expression to apply on the
    # operation. Possible values include: 'instanceView'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, vm_name, expand:nil, custom_headers:nil)
      get_async(resource_group_name, vm_name, expand:expand, custom_headers:custom_headers).value!
    end

    #
    # Retrieves information about the model view or the instance view of a virtual
    # machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param expand [InstanceViewTypes] The expand expression to apply on the
    # operation. Possible values include: 'instanceView'
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, vm_name, expand:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_name is nil' if vm_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmName' => vm_name,'subscriptionId' => @client.subscription_id},
          query_params: {'$expand' => expand,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachine.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves information about the run-time state of a virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineInstanceView] operation results.
    #
    def instance_view(resource_group_name, vm_name, custom_headers:nil)
      response = instance_view_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves information about the run-time state of a virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def instance_view_with_http_info(resource_group_name, vm_name, custom_headers:nil)
      instance_view_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
    end

    #
    # Retrieves information about the run-time state of a virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def instance_view_async(resource_group_name, vm_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_name is nil' if vm_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/instanceView'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmName' => vm_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineInstanceView.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Converts virtual machine disks from blob-based to managed disks. Virtual
    # machine must be stop-deallocated before invoking this operation. <br>For
    # Windows, please refer to [Convert a virtual machine from unmanaged disks to
    # managed
    # disks.](https://docs.microsoft.com/en-us/azure/virtual-machines/windows/convert-unmanaged-to-managed-disks).<br>For
    # Linux, please refer to [Convert a virtual machine from unmanaged disks to
    # managed
    # disks.](https://docs.microsoft.com/en-us/azure/virtual-machines/linux/convert-unmanaged-to-managed-disks).
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def convert_to_managed_disks(resource_group_name, vm_name, custom_headers:nil)
      response = convert_to_managed_disks_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def convert_to_managed_disks_async(resource_group_name, vm_name, custom_headers:nil)
      # Send request
      promise = begin_convert_to_managed_disks_async(resource_group_name, vm_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Shuts down the virtual machine and releases the compute resources. You are
    # not billed for the compute resources that this virtual machine uses.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def deallocate(resource_group_name, vm_name, custom_headers:nil)
      response = deallocate_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def deallocate_async(resource_group_name, vm_name, custom_headers:nil)
      # Send request
      promise = begin_deallocate_async(resource_group_name, vm_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Sets the OS state of the virtual machine to generalized. It is recommended to
    # sysprep the virtual machine before performing this operation. <br>For
    # Windows, please refer to [Create a managed image of a generalized VM in
    # Azure](https://docs.microsoft.com/en-us/azure/virtual-machines/windows/capture-image-resource).<br>For
    # Linux, please refer to [How to create an image of a virtual machine or
    # VHD](https://docs.microsoft.com/en-us/azure/virtual-machines/linux/capture-image).
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def generalize(resource_group_name, vm_name, custom_headers:nil)
      response = generalize_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # Sets the OS state of the virtual machine to generalized. It is recommended to
    # sysprep the virtual machine before performing this operation. <br>For
    # Windows, please refer to [Create a managed image of a generalized VM in
    # Azure](https://docs.microsoft.com/en-us/azure/virtual-machines/windows/capture-image-resource).<br>For
    # Linux, please refer to [How to create an image of a virtual machine or
    # VHD](https://docs.microsoft.com/en-us/azure/virtual-machines/linux/capture-image).
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def generalize_with_http_info(resource_group_name, vm_name, custom_headers:nil)
      generalize_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
    end

    #
    # Sets the OS state of the virtual machine to generalized. It is recommended to
    # sysprep the virtual machine before performing this operation. <br>For
    # Windows, please refer to [Create a managed image of a generalized VM in
    # Azure](https://docs.microsoft.com/en-us/azure/virtual-machines/windows/capture-image-resource).<br>For
    # Linux, please refer to [How to create an image of a virtual machine or
    # VHD](https://docs.microsoft.com/en-us/azure/virtual-machines/linux/capture-image).
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def generalize_async(resource_group_name, vm_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_name is nil' if vm_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/generalize'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmName' => vm_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Lists all of the virtual machines in the specified resource group. Use the
    # nextLink property in the response to get the next page of virtual machines.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<VirtualMachine>] operation results.
    #
    def list(resource_group_name, custom_headers:nil)
      first_page = list_as_lazy(resource_group_name, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Lists all of the virtual machines in the specified resource group. Use the
    # nextLink property in the response to get the next page of virtual machines.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(resource_group_name, custom_headers:nil)
      list_async(resource_group_name, custom_headers:custom_headers).value!
    end

    #
    # Lists all of the virtual machines in the specified resource group. Use the
    # nextLink property in the response to get the next page of virtual machines.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(resource_group_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all of the virtual machines in the specified subscription. Use the
    # nextLink property in the response to get the next page of virtual machines.
    #
    # @param status_only [String] statusOnly=true enables fetching run time status
    # of all Virtual Machines in the subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<VirtualMachine>] operation results.
    #
    def list_all(status_only:nil, custom_headers:nil)
      first_page = list_all_as_lazy(status_only:status_only, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Lists all of the virtual machines in the specified subscription. Use the
    # nextLink property in the response to get the next page of virtual machines.
    #
    # @param status_only [String] statusOnly=true enables fetching run time status
    # of all Virtual Machines in the subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_all_with_http_info(status_only:nil, custom_headers:nil)
      list_all_async(status_only:status_only, custom_headers:custom_headers).value!
    end

    #
    # Lists all of the virtual machines in the specified subscription. Use the
    # nextLink property in the response to get the next page of virtual machines.
    #
    # @param status_only [String] statusOnly=true enables fetching run time status
    # of all Virtual Machines in the subscription.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_all_async(status_only:nil, custom_headers:nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Compute/virtualMachines'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version,'statusOnly' => status_only},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all available virtual machine sizes to which the specified virtual
    # machine can be resized.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineSizeListResult] operation results.
    #
    def list_available_sizes(resource_group_name, vm_name, custom_headers:nil)
      response = list_available_sizes_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists all available virtual machine sizes to which the specified virtual
    # machine can be resized.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_available_sizes_with_http_info(resource_group_name, vm_name, custom_headers:nil)
      list_available_sizes_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
    end

    #
    # Lists all available virtual machine sizes to which the specified virtual
    # machine can be resized.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_available_sizes_async(resource_group_name, vm_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_name is nil' if vm_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/vmSizes'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmName' => vm_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineSizeListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The operation to power off (stop) a virtual machine. The virtual machine can
    # be restarted with the same provisioned resources. You are still charged for
    # this virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param skip_shutdown [Boolean] The parameter to request non-graceful VM
    # shutdown. True value for this flag indicates non-graceful shutdown whereas
    # false indicates otherwise. Default value for this flag is false if not
    # specified
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def power_off(resource_group_name, vm_name, skip_shutdown:false, custom_headers:nil)
      response = power_off_async(resource_group_name, vm_name, skip_shutdown:skip_shutdown, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param skip_shutdown [Boolean] The parameter to request non-graceful VM
    # shutdown. True value for this flag indicates non-graceful shutdown whereas
    # false indicates otherwise. Default value for this flag is false if not
    # specified
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def power_off_async(resource_group_name, vm_name, skip_shutdown:false, custom_headers:nil)
      # Send request
      promise = begin_power_off_async(resource_group_name, vm_name, skip_shutdown:skip_shutdown, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # The operation to reapply a virtual machine's state.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def reapply(resource_group_name, vm_name, custom_headers:nil)
      response = reapply_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def reapply_async(resource_group_name, vm_name, custom_headers:nil)
      # Send request
      promise = begin_reapply_async(resource_group_name, vm_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # The operation to restart a virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def restart(resource_group_name, vm_name, custom_headers:nil)
      response = restart_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def restart_async(resource_group_name, vm_name, custom_headers:nil)
      # Send request
      promise = begin_restart_async(resource_group_name, vm_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # The operation to start a virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def start(resource_group_name, vm_name, custom_headers:nil)
      response = start_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def start_async(resource_group_name, vm_name, custom_headers:nil)
      # Send request
      promise = begin_start_async(resource_group_name, vm_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Shuts down the virtual machine, moves it to a new node, and powers it back
    # on.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def redeploy(resource_group_name, vm_name, custom_headers:nil)
      response = redeploy_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def redeploy_async(resource_group_name, vm_name, custom_headers:nil)
      # Send request
      promise = begin_redeploy_async(resource_group_name, vm_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Reimages the virtual machine which has an ephemeral OS disk back to its
    # initial state.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [VirtualMachineReimageParameters] Parameters supplied to
    # the Reimage Virtual Machine operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def reimage(resource_group_name, vm_name, parameters:nil, custom_headers:nil)
      response = reimage_async(resource_group_name, vm_name, parameters:parameters, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [VirtualMachineReimageParameters] Parameters supplied to
    # the Reimage Virtual Machine operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def reimage_async(resource_group_name, vm_name, parameters:nil, custom_headers:nil)
      # Send request
      promise = begin_reimage_async(resource_group_name, vm_name, parameters:parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Shuts down the virtual machine, moves it to an already updated node, and
    # powers it back on during the self-service phase of planned maintenance.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def perform_maintenance(resource_group_name, vm_name, custom_headers:nil)
      response = perform_maintenance_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def perform_maintenance_async(resource_group_name, vm_name, custom_headers:nil)
      # Send request
      promise = begin_perform_maintenance_async(resource_group_name, vm_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # The operation to simulate the eviction of spot virtual machine. The eviction
    # will occur within 30 minutes of calling the API
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def simulate_eviction(resource_group_name, vm_name, custom_headers:nil)
      response = simulate_eviction_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # The operation to simulate the eviction of spot virtual machine. The eviction
    # will occur within 30 minutes of calling the API
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def simulate_eviction_with_http_info(resource_group_name, vm_name, custom_headers:nil)
      simulate_eviction_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
    end

    #
    # The operation to simulate the eviction of spot virtual machine. The eviction
    # will occur within 30 minutes of calling the API
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def simulate_eviction_async(resource_group_name, vm_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_name is nil' if vm_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/simulateEviction'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmName' => vm_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Run command on the VM.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [RunCommandInput] Parameters supplied to the Run command
    # operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RunCommandResult] operation results.
    #
    def run_command(resource_group_name, vm_name, parameters, custom_headers:nil)
      response = run_command_async(resource_group_name, vm_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [RunCommandInput] Parameters supplied to the Run command
    # operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def run_command_async(resource_group_name, vm_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_run_command_async(resource_group_name, vm_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::RunCommandResult.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Captures the VM by copying virtual hard disks of the VM and outputs a
    # template that can be used to create similar VMs.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [VirtualMachineCaptureParameters] Parameters supplied to
    # the Capture Virtual Machine operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineCaptureResult] operation results.
    #
    def begin_capture(resource_group_name, vm_name, parameters, custom_headers:nil)
      response = begin_capture_async(resource_group_name, vm_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Captures the VM by copying virtual hard disks of the VM and outputs a
    # template that can be used to create similar VMs.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [VirtualMachineCaptureParameters] Parameters supplied to
    # the Capture Virtual Machine operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_capture_with_http_info(resource_group_name, vm_name, parameters, custom_headers:nil)
      begin_capture_async(resource_group_name, vm_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Captures the VM by copying virtual hard disks of the VM and outputs a
    # template that can be used to create similar VMs.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [VirtualMachineCaptureParameters] Parameters supplied to
    # the Capture Virtual Machine operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_capture_async(resource_group_name, vm_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_name is nil' if vm_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineCaptureParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/capture'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmName' => vm_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineCaptureResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The operation to create or update a virtual machine. Please note some
    # properties can be set only during virtual machine creation.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [VirtualMachine] Parameters supplied to the Create Virtual
    # Machine operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachine] operation results.
    #
    def begin_create_or_update(resource_group_name, vm_name, parameters, custom_headers:nil)
      response = begin_create_or_update_async(resource_group_name, vm_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # The operation to create or update a virtual machine. Please note some
    # properties can be set only during virtual machine creation.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [VirtualMachine] Parameters supplied to the Create Virtual
    # Machine operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_with_http_info(resource_group_name, vm_name, parameters, custom_headers:nil)
      begin_create_or_update_async(resource_group_name, vm_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # The operation to create or update a virtual machine. Please note some
    # properties can be set only during virtual machine creation.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [VirtualMachine] Parameters supplied to the Create Virtual
    # Machine operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_async(resource_group_name, vm_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_name is nil' if vm_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachine.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmName' => vm_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachine.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachine.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The operation to update a virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [VirtualMachineUpdate] Parameters supplied to the Update
    # Virtual Machine operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachine] operation results.
    #
    def begin_update(resource_group_name, vm_name, parameters, custom_headers:nil)
      response = begin_update_async(resource_group_name, vm_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # The operation to update a virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [VirtualMachineUpdate] Parameters supplied to the Update
    # Virtual Machine operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_update_with_http_info(resource_group_name, vm_name, parameters, custom_headers:nil)
      begin_update_async(resource_group_name, vm_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # The operation to update a virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [VirtualMachineUpdate] Parameters supplied to the Update
    # Virtual Machine operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_update_async(resource_group_name, vm_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_name is nil' if vm_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineUpdate.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmName' => vm_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachine.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachine.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The operation to delete a virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(resource_group_name, vm_name, custom_headers:nil)
      response = begin_delete_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # The operation to delete a virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, vm_name, custom_headers:nil)
      begin_delete_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
    end

    #
    # The operation to delete a virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, vm_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_name is nil' if vm_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmName' => vm_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Converts virtual machine disks from blob-based to managed disks. Virtual
    # machine must be stop-deallocated before invoking this operation. <br>For
    # Windows, please refer to [Convert a virtual machine from unmanaged disks to
    # managed
    # disks.](https://docs.microsoft.com/en-us/azure/virtual-machines/windows/convert-unmanaged-to-managed-disks).<br>For
    # Linux, please refer to [Convert a virtual machine from unmanaged disks to
    # managed
    # disks.](https://docs.microsoft.com/en-us/azure/virtual-machines/linux/convert-unmanaged-to-managed-disks).
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_convert_to_managed_disks(resource_group_name, vm_name, custom_headers:nil)
      response = begin_convert_to_managed_disks_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # Converts virtual machine disks from blob-based to managed disks. Virtual
    # machine must be stop-deallocated before invoking this operation. <br>For
    # Windows, please refer to [Convert a virtual machine from unmanaged disks to
    # managed
    # disks.](https://docs.microsoft.com/en-us/azure/virtual-machines/windows/convert-unmanaged-to-managed-disks).<br>For
    # Linux, please refer to [Convert a virtual machine from unmanaged disks to
    # managed
    # disks.](https://docs.microsoft.com/en-us/azure/virtual-machines/linux/convert-unmanaged-to-managed-disks).
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_convert_to_managed_disks_with_http_info(resource_group_name, vm_name, custom_headers:nil)
      begin_convert_to_managed_disks_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
    end

    #
    # Converts virtual machine disks from blob-based to managed disks. Virtual
    # machine must be stop-deallocated before invoking this operation. <br>For
    # Windows, please refer to [Convert a virtual machine from unmanaged disks to
    # managed
    # disks.](https://docs.microsoft.com/en-us/azure/virtual-machines/windows/convert-unmanaged-to-managed-disks).<br>For
    # Linux, please refer to [Convert a virtual machine from unmanaged disks to
    # managed
    # disks.](https://docs.microsoft.com/en-us/azure/virtual-machines/linux/convert-unmanaged-to-managed-disks).
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_convert_to_managed_disks_async(resource_group_name, vm_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_name is nil' if vm_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/convertToManagedDisks'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmName' => vm_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Shuts down the virtual machine and releases the compute resources. You are
    # not billed for the compute resources that this virtual machine uses.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_deallocate(resource_group_name, vm_name, custom_headers:nil)
      response = begin_deallocate_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # Shuts down the virtual machine and releases the compute resources. You are
    # not billed for the compute resources that this virtual machine uses.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_deallocate_with_http_info(resource_group_name, vm_name, custom_headers:nil)
      begin_deallocate_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
    end

    #
    # Shuts down the virtual machine and releases the compute resources. You are
    # not billed for the compute resources that this virtual machine uses.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_deallocate_async(resource_group_name, vm_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_name is nil' if vm_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/deallocate'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmName' => vm_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # The operation to power off (stop) a virtual machine. The virtual machine can
    # be restarted with the same provisioned resources. You are still charged for
    # this virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param skip_shutdown [Boolean] The parameter to request non-graceful VM
    # shutdown. True value for this flag indicates non-graceful shutdown whereas
    # false indicates otherwise. Default value for this flag is false if not
    # specified
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_power_off(resource_group_name, vm_name, skip_shutdown:false, custom_headers:nil)
      response = begin_power_off_async(resource_group_name, vm_name, skip_shutdown:skip_shutdown, custom_headers:custom_headers).value!
      nil
    end

    #
    # The operation to power off (stop) a virtual machine. The virtual machine can
    # be restarted with the same provisioned resources. You are still charged for
    # this virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param skip_shutdown [Boolean] The parameter to request non-graceful VM
    # shutdown. True value for this flag indicates non-graceful shutdown whereas
    # false indicates otherwise. Default value for this flag is false if not
    # specified
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_power_off_with_http_info(resource_group_name, vm_name, skip_shutdown:false, custom_headers:nil)
      begin_power_off_async(resource_group_name, vm_name, skip_shutdown:skip_shutdown, custom_headers:custom_headers).value!
    end

    #
    # The operation to power off (stop) a virtual machine. The virtual machine can
    # be restarted with the same provisioned resources. You are still charged for
    # this virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param skip_shutdown [Boolean] The parameter to request non-graceful VM
    # shutdown. True value for this flag indicates non-graceful shutdown whereas
    # false indicates otherwise. Default value for this flag is false if not
    # specified
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_power_off_async(resource_group_name, vm_name, skip_shutdown:false, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_name is nil' if vm_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/powerOff'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmName' => vm_name,'subscriptionId' => @client.subscription_id},
          query_params: {'skipShutdown' => skip_shutdown,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # The operation to reapply a virtual machine's state.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_reapply(resource_group_name, vm_name, custom_headers:nil)
      response = begin_reapply_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # The operation to reapply a virtual machine's state.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_reapply_with_http_info(resource_group_name, vm_name, custom_headers:nil)
      begin_reapply_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
    end

    #
    # The operation to reapply a virtual machine's state.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_reapply_async(resource_group_name, vm_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_name is nil' if vm_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/reapply'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmName' => vm_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # The operation to restart a virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_restart(resource_group_name, vm_name, custom_headers:nil)
      response = begin_restart_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # The operation to restart a virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_restart_with_http_info(resource_group_name, vm_name, custom_headers:nil)
      begin_restart_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
    end

    #
    # The operation to restart a virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_restart_async(resource_group_name, vm_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_name is nil' if vm_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/restart'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmName' => vm_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # The operation to start a virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_start(resource_group_name, vm_name, custom_headers:nil)
      response = begin_start_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # The operation to start a virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_start_with_http_info(resource_group_name, vm_name, custom_headers:nil)
      begin_start_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
    end

    #
    # The operation to start a virtual machine.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_start_async(resource_group_name, vm_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_name is nil' if vm_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/start'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmName' => vm_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Shuts down the virtual machine, moves it to a new node, and powers it back
    # on.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_redeploy(resource_group_name, vm_name, custom_headers:nil)
      response = begin_redeploy_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # Shuts down the virtual machine, moves it to a new node, and powers it back
    # on.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_redeploy_with_http_info(resource_group_name, vm_name, custom_headers:nil)
      begin_redeploy_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
    end

    #
    # Shuts down the virtual machine, moves it to a new node, and powers it back
    # on.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_redeploy_async(resource_group_name, vm_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_name is nil' if vm_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/redeploy'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmName' => vm_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Reimages the virtual machine which has an ephemeral OS disk back to its
    # initial state.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [VirtualMachineReimageParameters] Parameters supplied to
    # the Reimage Virtual Machine operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_reimage(resource_group_name, vm_name, parameters:nil, custom_headers:nil)
      response = begin_reimage_async(resource_group_name, vm_name, parameters:parameters, custom_headers:custom_headers).value!
      nil
    end

    #
    # Reimages the virtual machine which has an ephemeral OS disk back to its
    # initial state.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [VirtualMachineReimageParameters] Parameters supplied to
    # the Reimage Virtual Machine operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_reimage_with_http_info(resource_group_name, vm_name, parameters:nil, custom_headers:nil)
      begin_reimage_async(resource_group_name, vm_name, parameters:parameters, custom_headers:custom_headers).value!
    end

    #
    # Reimages the virtual machine which has an ephemeral OS disk back to its
    # initial state.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [VirtualMachineReimageParameters] Parameters supplied to
    # the Reimage Virtual Machine operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_reimage_async(resource_group_name, vm_name, parameters:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_name is nil' if vm_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineReimageParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/reimage'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmName' => vm_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Shuts down the virtual machine, moves it to an already updated node, and
    # powers it back on during the self-service phase of planned maintenance.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_perform_maintenance(resource_group_name, vm_name, custom_headers:nil)
      response = begin_perform_maintenance_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # Shuts down the virtual machine, moves it to an already updated node, and
    # powers it back on during the self-service phase of planned maintenance.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_perform_maintenance_with_http_info(resource_group_name, vm_name, custom_headers:nil)
      begin_perform_maintenance_async(resource_group_name, vm_name, custom_headers:custom_headers).value!
    end

    #
    # Shuts down the virtual machine, moves it to an already updated node, and
    # powers it back on during the self-service phase of planned maintenance.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_perform_maintenance_async(resource_group_name, vm_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_name is nil' if vm_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/performMaintenance'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmName' => vm_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Run command on the VM.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [RunCommandInput] Parameters supplied to the Run command
    # operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RunCommandResult] operation results.
    #
    def begin_run_command(resource_group_name, vm_name, parameters, custom_headers:nil)
      response = begin_run_command_async(resource_group_name, vm_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Run command on the VM.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [RunCommandInput] Parameters supplied to the Run command
    # operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_run_command_with_http_info(resource_group_name, vm_name, parameters, custom_headers:nil)
      begin_run_command_async(resource_group_name, vm_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Run command on the VM.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param vm_name [String] The name of the virtual machine.
    # @param parameters [RunCommandInput] Parameters supplied to the Run command
    # operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_run_command_async(resource_group_name, vm_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vm_name is nil' if vm_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::RunCommandInput.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommand'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'vmName' => vm_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::RunCommandResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all the virtual machines under the specified subscription for the
    # specified location.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineListResult] operation results.
    #
    def list_by_location_next(next_page_link, custom_headers:nil)
      response = list_by_location_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets all the virtual machines under the specified subscription for the
    # specified location.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_location_next_with_http_info(next_page_link, custom_headers:nil)
      list_by_location_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Gets all the virtual machines under the specified subscription for the
    # specified location.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_location_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all of the virtual machines in the specified resource group. Use the
    # nextLink property in the response to get the next page of virtual machines.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineListResult] operation results.
    #
    def list_next(next_page_link, custom_headers:nil)
      response = list_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists all of the virtual machines in the specified resource group. Use the
    # nextLink property in the response to get the next page of virtual machines.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers:nil)
      list_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Lists all of the virtual machines in the specified resource group. Use the
    # nextLink property in the response to get the next page of virtual machines.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all of the virtual machines in the specified subscription. Use the
    # nextLink property in the response to get the next page of virtual machines.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineListResult] operation results.
    #
    def list_all_next(next_page_link, custom_headers:nil)
      response = list_all_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists all of the virtual machines in the specified subscription. Use the
    # nextLink property in the response to get the next page of virtual machines.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_all_next_with_http_info(next_page_link, custom_headers:nil)
      list_all_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Lists all of the virtual machines in the specified subscription. Use the
    # nextLink property in the response to get the next page of virtual machines.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_all_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2019_12_01::Models::VirtualMachineListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all the virtual machines under the specified subscription for the
    # specified location.
    #
    # @param location [String] The location for which virtual machines under the
    # subscription are queried.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineListResult] which provide lazy access to pages of the
    # response.
    #
    def list_by_location_as_lazy(location, custom_headers:nil)
      response = list_by_location_async(location, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_location_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

    #
    # Lists all of the virtual machines in the specified resource group. Use the
    # nextLink property in the response to get the next page of virtual machines.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineListResult] which provide lazy access to pages of the
    # response.
    #
    def list_as_lazy(resource_group_name, custom_headers:nil)
      response = list_async(resource_group_name, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

    #
    # Lists all of the virtual machines in the specified subscription. Use the
    # nextLink property in the response to get the next page of virtual machines.
    #
    # @param status_only [String] statusOnly=true enables fetching run time status
    # of all Virtual Machines in the subscription.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualMachineListResult] which provide lazy access to pages of the
    # response.
    #
    def list_all_as_lazy(status_only:nil, custom_headers:nil)
      response = list_all_async(status_only:status_only, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_all_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

  end
end
