# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2020_06_01
  module Models
    #
    # Describes the properties of the last installed patch summary.
    #
    class LastPatchInstallationSummary

      include MsRestAzure

      # @return [PatchOperationStatus] The overall success or failure status of
      # the operation. It remains "InProgress" until the operation completes.
      # At that point it will become "Failed", "Succeeded", or
      # "CompletedWithWarnings.". Possible values include: 'InProgress',
      # 'Failed', 'Succeeded', 'CompletedWithWarnings'
      attr_accessor :status

      # @return [String] The activity ID of the operation that produced this
      # result. It is used to correlate across CRP and extension logs.
      attr_accessor :installation_activity_id

      # @return [Boolean] Describes whether the operation ran out of time
      # before it completed all its intended actions
      attr_accessor :maintenance_window_exceeded

      # @return [RebootStatus] The reboot status of the machine after the patch
      # operation. It will be in "NotNeeded" status if reboot is not needed
      # after the patch operation. "Required" will be the status once the patch
      # is applied and machine is required to reboot. "Started" will be the
      # reboot status when the machine has started to reboot. "Failed" will be
      # the status if the machine is failed to reboot. "Completed" will be the
      # status once the machine is rebooted successfully. Possible values
      # include: 'NotNeeded', 'Required', 'Started', 'Failed', 'Completed'
      attr_accessor :reboot_status

      # @return [Integer] The number of all available patches but not going to
      # be installed because it didn't match a classification or inclusion list
      # entry.
      attr_accessor :not_selected_patch_count

      # @return [Integer] The number of all available patches but excluded
      # explicitly by a customer-specified exclusion list match.
      attr_accessor :excluded_patch_count

      # @return [Integer] The number of all available patches expected to be
      # installed over the course of the patch installation operation.
      attr_accessor :pending_patch_count

      # @return [Integer] The count of patches that successfully installed.
      attr_accessor :installed_patch_count

      # @return [Integer] The count of patches that failed installation.
      attr_accessor :failed_patch_count

      # @return [DateTime] The UTC timestamp when the operation began.
      attr_accessor :start_time

      # @return [DateTime] The UTC timestamp when the operation began.
      attr_accessor :last_modified_time

      # @return [String] The person or system account that started the
      # operation
      attr_accessor :started_by

      # @return [ApiError] The errors that were encountered during execution of
      # the operation. The details array contains the list of them.
      attr_accessor :error


      #
      # Mapper for LastPatchInstallationSummary class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'LastPatchInstallationSummary',
          type: {
            name: 'Composite',
            class_name: 'LastPatchInstallationSummary',
            model_properties: {
              status: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'status',
                type: {
                  name: 'String'
                }
              },
              installation_activity_id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'installationActivityId',
                type: {
                  name: 'String'
                }
              },
              maintenance_window_exceeded: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'maintenanceWindowExceeded',
                type: {
                  name: 'Boolean'
                }
              },
              reboot_status: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'rebootStatus',
                type: {
                  name: 'String'
                }
              },
              not_selected_patch_count: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'notSelectedPatchCount',
                type: {
                  name: 'Number'
                }
              },
              excluded_patch_count: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'excludedPatchCount',
                type: {
                  name: 'Number'
                }
              },
              pending_patch_count: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'pendingPatchCount',
                type: {
                  name: 'Number'
                }
              },
              installed_patch_count: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'installedPatchCount',
                type: {
                  name: 'Number'
                }
              },
              failed_patch_count: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'failedPatchCount',
                type: {
                  name: 'Number'
                }
              },
              start_time: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'startTime',
                type: {
                  name: 'DateTime'
                }
              },
              last_modified_time: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'lastModifiedTime',
                type: {
                  name: 'DateTime'
                }
              },
              started_by: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'startedBy',
                type: {
                  name: 'String'
                }
              },
              error: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'error',
                type: {
                  name: 'Composite',
                  class_name: 'ApiError'
                }
              }
            }
          }
        }
      end
    end
  end
end
