# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2020_06_30
  module Models
    #
    # The Private Endpoint Connection resource.
    #
    class PrivateEndpointConnection

      include MsRestAzure

      # @return [PrivateEndpoint] The resource of private end point.
      attr_accessor :private_endpoint

      # @return [PrivateLinkServiceConnectionState] A collection of information
      # about the state of the connection between DiskAccess and Virtual
      # Network.
      attr_accessor :private_link_service_connection_state

      # @return [PrivateEndpointConnectionProvisioningState] The provisioning
      # state of the private endpoint connection resource. Possible values
      # include: 'Succeeded', 'Creating', 'Deleting', 'Failed'
      attr_accessor :provisioning_state

      # @return [String] private endpoint connection Id
      attr_accessor :id

      # @return [String] private endpoint connection name
      attr_accessor :name

      # @return [String] private endpoint connection type
      attr_accessor :type


      #
      # Mapper for PrivateEndpointConnection class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'PrivateEndpointConnection',
          type: {
            name: 'Composite',
            class_name: 'PrivateEndpointConnection',
            model_properties: {
              private_endpoint: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.privateEndpoint',
                type: {
                  name: 'Composite',
                  class_name: 'PrivateEndpoint'
                }
              },
              private_link_service_connection_state: {
                client_side_validation: true,
                required: true,
                serialized_name: 'properties.privateLinkServiceConnectionState',
                type: {
                  name: 'Composite',
                  class_name: 'PrivateLinkServiceConnectionState'
                }
              },
              provisioning_state: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.provisioningState',
                type: {
                  name: 'String'
                }
              },
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
