# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2020_10_01_preview
  #
  # Compute Client
  #
  class CloudServiceRoleInstances
    include MsRestAzure

    #
    # Creates and initializes a new instance of the CloudServiceRoleInstances class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [ComputeManagementClient] reference to the ComputeManagementClient
    attr_reader :client

    #
    # Deletes a role instance from a cloud service.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      response = delete_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      # Send request
      promise = begin_delete_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets a role instance from a cloud service.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param expand [InstanceViewTypes] The expand expression to apply to the
    # operation. Possible values include: 'instanceView'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RoleInstance] operation results.
    #
    def get(role_instance_name, resource_group_name, cloud_service_name, expand:nil, custom_headers:nil)
      response = get_async(role_instance_name, resource_group_name, cloud_service_name, expand:expand, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a role instance from a cloud service.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param expand [InstanceViewTypes] The expand expression to apply to the
    # operation. Possible values include: 'instanceView'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(role_instance_name, resource_group_name, cloud_service_name, expand:nil, custom_headers:nil)
      get_async(role_instance_name, resource_group_name, cloud_service_name, expand:expand, custom_headers:custom_headers).value!
    end

    #
    # Gets a role instance from a cloud service.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param expand [InstanceViewTypes] The expand expression to apply to the
    # operation. Possible values include: 'instanceView'
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(role_instance_name, resource_group_name, cloud_service_name, expand:nil, custom_headers:nil)
      fail ArgumentError, 'role_instance_name is nil' if role_instance_name.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'roleInstanceName' => role_instance_name,'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version,'$expand' => expand},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::RoleInstance.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves information about the run-time state of a role instance in a cloud
    # service.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RoleInstanceInstanceView] operation results.
    #
    def get_instance_view(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      response = get_instance_view_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves information about the run-time state of a role instance in a cloud
    # service.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_instance_view_with_http_info(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      get_instance_view_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
    end

    #
    # Retrieves information about the run-time state of a role instance in a cloud
    # service.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_instance_view_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      fail ArgumentError, 'role_instance_name is nil' if role_instance_name.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}/instanceView'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'roleInstanceName' => role_instance_name,'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::RoleInstanceInstanceView.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the list of all role instances in a cloud service. Use nextLink property
    # in the response to get the next page of role instances. Do this till nextLink
    # is null to fetch all the role instances.
    #
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param expand [InstanceViewTypes] The expand expression to apply to the
    # operation. Possible values include: 'instanceView'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<RoleInstance>] operation results.
    #
    def list(resource_group_name, cloud_service_name, expand:nil, custom_headers:nil)
      first_page = list_as_lazy(resource_group_name, cloud_service_name, expand:expand, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the list of all role instances in a cloud service. Use nextLink property
    # in the response to get the next page of role instances. Do this till nextLink
    # is null to fetch all the role instances.
    #
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param expand [InstanceViewTypes] The expand expression to apply to the
    # operation. Possible values include: 'instanceView'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(resource_group_name, cloud_service_name, expand:nil, custom_headers:nil)
      list_async(resource_group_name, cloud_service_name, expand:expand, custom_headers:custom_headers).value!
    end

    #
    # Gets the list of all role instances in a cloud service. Use nextLink property
    # in the response to get the next page of role instances. Do this till nextLink
    # is null to fetch all the role instances.
    #
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param expand [InstanceViewTypes] The expand expression to apply to the
    # operation. Possible values include: 'instanceView'
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(resource_group_name, cloud_service_name, expand:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/roleInstances'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version,'$expand' => expand},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::RoleInstanceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The Reboot Role Instance asynchronous operation requests a reboot of a role
    # instance in the cloud service.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def restart(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      response = restart_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def restart_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      # Send request
      promise = begin_restart_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # The Reimage Role Instance asynchronous operation reinstalls the operating
    # system on instances of web roles or worker roles.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def reimage(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      response = reimage_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def reimage_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      # Send request
      promise = begin_reimage_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # The Rebuild Role Instance asynchronous operation reinstalls the operating
    # system on instances of web roles or worker roles and initializes the storage
    # resources that are used by them. If you do not want to initialize storage
    # resources, you can use Reimage Role Instance.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def rebuild(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      response = rebuild_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def rebuild_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      # Send request
      promise = begin_rebuild_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets a remote desktop file for a role instance in a cloud service.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NOT_IMPLEMENTED] operation results.
    #
    def get_remote_desktop_file(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      response = get_remote_desktop_file_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a remote desktop file for a role instance in a cloud service.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_remote_desktop_file_with_http_info(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      get_remote_desktop_file_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
    end

    #
    # Gets a remote desktop file for a role instance in a cloud service.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_remote_desktop_file_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      fail ArgumentError, 'role_instance_name is nil' if role_instance_name.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}/remoteDesktopFile'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'roleInstanceName' => role_instance_name,'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              client_side_validation: true,
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Stream'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a role instance from a cloud service.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      response = begin_delete_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # Deletes a role instance from a cloud service.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      begin_delete_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
    end

    #
    # Deletes a role instance from a cloud service.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      fail ArgumentError, 'role_instance_name is nil' if role_instance_name.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'roleInstanceName' => role_instance_name,'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # The Reboot Role Instance asynchronous operation requests a reboot of a role
    # instance in the cloud service.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_restart(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      response = begin_restart_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # The Reboot Role Instance asynchronous operation requests a reboot of a role
    # instance in the cloud service.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_restart_with_http_info(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      begin_restart_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
    end

    #
    # The Reboot Role Instance asynchronous operation requests a reboot of a role
    # instance in the cloud service.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_restart_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      fail ArgumentError, 'role_instance_name is nil' if role_instance_name.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}/restart'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'roleInstanceName' => role_instance_name,'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # The Reimage Role Instance asynchronous operation reinstalls the operating
    # system on instances of web roles or worker roles.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_reimage(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      response = begin_reimage_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # The Reimage Role Instance asynchronous operation reinstalls the operating
    # system on instances of web roles or worker roles.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_reimage_with_http_info(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      begin_reimage_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
    end

    #
    # The Reimage Role Instance asynchronous operation reinstalls the operating
    # system on instances of web roles or worker roles.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_reimage_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      fail ArgumentError, 'role_instance_name is nil' if role_instance_name.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}/reimage'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'roleInstanceName' => role_instance_name,'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # The Rebuild Role Instance asynchronous operation reinstalls the operating
    # system on instances of web roles or worker roles and initializes the storage
    # resources that are used by them. If you do not want to initialize storage
    # resources, you can use Reimage Role Instance.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_rebuild(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      response = begin_rebuild_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # The Rebuild Role Instance asynchronous operation reinstalls the operating
    # system on instances of web roles or worker roles and initializes the storage
    # resources that are used by them. If you do not want to initialize storage
    # resources, you can use Reimage Role Instance.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_rebuild_with_http_info(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      begin_rebuild_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
    end

    #
    # The Rebuild Role Instance asynchronous operation reinstalls the operating
    # system on instances of web roles or worker roles and initializes the storage
    # resources that are used by them. If you do not want to initialize storage
    # resources, you can use Reimage Role Instance.
    #
    # @param role_instance_name [String] Name of the role instance.
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_rebuild_async(role_instance_name, resource_group_name, cloud_service_name, custom_headers:nil)
      fail ArgumentError, 'role_instance_name is nil' if role_instance_name.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}/rebuild'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'roleInstanceName' => role_instance_name,'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the list of all role instances in a cloud service. Use nextLink property
    # in the response to get the next page of role instances. Do this till nextLink
    # is null to fetch all the role instances.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RoleInstanceListResult] operation results.
    #
    def list_next(next_page_link, custom_headers:nil)
      response = list_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the list of all role instances in a cloud service. Use nextLink property
    # in the response to get the next page of role instances. Do this till nextLink
    # is null to fetch all the role instances.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers:nil)
      list_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Gets the list of all role instances in a cloud service. Use nextLink property
    # in the response to get the next page of role instances. Do this till nextLink
    # is null to fetch all the role instances.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::RoleInstanceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the list of all role instances in a cloud service. Use nextLink property
    # in the response to get the next page of role instances. Do this till nextLink
    # is null to fetch all the role instances.
    #
    # @param resource_group_name [String]
    # @param cloud_service_name [String]
    # @param expand [InstanceViewTypes] The expand expression to apply to the
    # operation. Possible values include: 'instanceView'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RoleInstanceListResult] which provide lazy access to pages of the
    # response.
    #
    def list_as_lazy(resource_group_name, cloud_service_name, expand:nil, custom_headers:nil)
      response = list_async(resource_group_name, cloud_service_name, expand:expand, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

  end
end
