# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2020_10_01_preview
  #
  # Compute Client
  #
  class CloudServices
    include MsRestAzure

    #
    # Creates and initializes a new instance of the CloudServices class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [ComputeManagementClient] reference to the ComputeManagementClient
    attr_reader :client

    #
    # Create or update a cloud service. Please note some properties can be set only
    # during cloud service creation.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [CloudService] The cloud service object.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CloudService] operation results.
    #
    def create_or_update(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      response = create_or_update_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [CloudService] The cloud service object.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_async(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      # Send request
      promise = begin_create_or_update_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::CloudService.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Update a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [CloudServiceUpdate] The cloud service object.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CloudService] operation results.
    #
    def update(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      response = update_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [CloudServiceUpdate] The cloud service object.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def update_async(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      # Send request
      promise = begin_update_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::CloudService.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Deletes a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(resource_group_name, cloud_service_name, custom_headers:nil)
      response = delete_async(resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, cloud_service_name, custom_headers:nil)
      # Send request
      promise = begin_delete_async(resource_group_name, cloud_service_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Display information about a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CloudService] operation results.
    #
    def get(resource_group_name, cloud_service_name, custom_headers:nil)
      response = get_async(resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Display information about a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, cloud_service_name, custom_headers:nil)
      get_async(resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
    end

    #
    # Display information about a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, cloud_service_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::CloudService.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the status of a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CloudServiceInstanceView] operation results.
    #
    def get_instance_view(resource_group_name, cloud_service_name, custom_headers:nil)
      response = get_instance_view_async(resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the status of a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_instance_view_with_http_info(resource_group_name, cloud_service_name, custom_headers:nil)
      get_instance_view_async(resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
    end

    #
    # Gets the status of a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_instance_view_async(resource_group_name, cloud_service_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/instanceView'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::CloudServiceInstanceView.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a list of all cloud services in the subscription, regardless of the
    # associated resource group. Use nextLink property in the response to get the
    # next page of Cloud Services. Do this till nextLink is null to fetch all the
    # Cloud Services.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<CloudService>] operation results.
    #
    def list_all(custom_headers:nil)
      first_page = list_all_as_lazy(custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Gets a list of all cloud services in the subscription, regardless of the
    # associated resource group. Use nextLink property in the response to get the
    # next page of Cloud Services. Do this till nextLink is null to fetch all the
    # Cloud Services.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_all_with_http_info(custom_headers:nil)
      list_all_async(custom_headers:custom_headers).value!
    end

    #
    # Gets a list of all cloud services in the subscription, regardless of the
    # associated resource group. Use nextLink property in the response to get the
    # next page of Cloud Services. Do this till nextLink is null to fetch all the
    # Cloud Services.
    #
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_all_async(custom_headers:nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Compute/cloudServices'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::CloudServiceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a list of all cloud services under a resource group. Use nextLink
    # property in the response to get the next page of Cloud Services. Do this till
    # nextLink is null to fetch all the Cloud Services.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<CloudService>] operation results.
    #
    def list(resource_group_name, custom_headers:nil)
      first_page = list_as_lazy(resource_group_name, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Gets a list of all cloud services under a resource group. Use nextLink
    # property in the response to get the next page of Cloud Services. Do this till
    # nextLink is null to fetch all the Cloud Services.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(resource_group_name, custom_headers:nil)
      list_async(resource_group_name, custom_headers:custom_headers).value!
    end

    #
    # Gets a list of all cloud services under a resource group. Use nextLink
    # property in the response to get the next page of Cloud Services. Do this till
    # nextLink is null to fetch all the Cloud Services.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(resource_group_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::CloudServiceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Starts the cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def start(resource_group_name, cloud_service_name, custom_headers:nil)
      response = start_async(resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def start_async(resource_group_name, cloud_service_name, custom_headers:nil)
      # Send request
      promise = begin_start_async(resource_group_name, cloud_service_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Power off the cloud service. Note that resources are still attached and you
    # are getting charged for the resources.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def power_off(resource_group_name, cloud_service_name, custom_headers:nil)
      response = power_off_async(resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def power_off_async(resource_group_name, cloud_service_name, custom_headers:nil)
      # Send request
      promise = begin_power_off_async(resource_group_name, cloud_service_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Restarts one or more role instances in a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [RoleInstances] List of cloud service role instance names.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def restart(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      response = restart_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [RoleInstances] List of cloud service role instance names.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def restart_async(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      # Send request
      promise = begin_restart_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Reimage asynchronous operation reinstalls the operating system on instances
    # of web roles or worker roles.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [RoleInstances] List of cloud service role instance names.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def reimage(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      response = reimage_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [RoleInstances] List of cloud service role instance names.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def reimage_async(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      # Send request
      promise = begin_reimage_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Rebuild Role Instances reinstalls the operating system on instances of web
    # roles or worker roles and initializes the storage resources that are used by
    # them. If you do not want to initialize storage resources, you can use Reimage
    # Role Instances.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [RoleInstances] List of cloud service role instance names.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def rebuild(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      response = rebuild_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [RoleInstances] List of cloud service role instance names.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def rebuild_async(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      # Send request
      promise = begin_rebuild_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Deletes role instances in a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [RoleInstances] List of cloud service role instance names.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete_instances(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      response = delete_instances_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [RoleInstances] List of cloud service role instance names.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_instances_async(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      # Send request
      promise = begin_delete_instances_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Create or update a cloud service. Please note some properties can be set only
    # during cloud service creation.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [CloudService] The cloud service object.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CloudService] operation results.
    #
    def begin_create_or_update(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      response = begin_create_or_update_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create or update a cloud service. Please note some properties can be set only
    # during cloud service creation.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [CloudService] The cloud service object.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_with_http_info(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      begin_create_or_update_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers).value!
    end

    #
    # Create or update a cloud service. Please note some properties can be set only
    # during cloud service creation.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [CloudService] The cloud service object.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_async(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::CloudService.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::CloudService.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::CloudService.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Update a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [CloudServiceUpdate] The cloud service object.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CloudService] operation results.
    #
    def begin_update(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      response = begin_update_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [CloudServiceUpdate] The cloud service object.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_update_with_http_info(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      begin_update_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers).value!
    end

    #
    # Update a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [CloudServiceUpdate] The cloud service object.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_update_async(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::CloudServiceUpdate.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::CloudService.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(resource_group_name, cloud_service_name, custom_headers:nil)
      response = begin_delete_async(resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # Deletes a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, cloud_service_name, custom_headers:nil)
      begin_delete_async(resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
    end

    #
    # Deletes a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, cloud_service_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Starts the cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_start(resource_group_name, cloud_service_name, custom_headers:nil)
      response = begin_start_async(resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # Starts the cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_start_with_http_info(resource_group_name, cloud_service_name, custom_headers:nil)
      begin_start_async(resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
    end

    #
    # Starts the cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_start_async(resource_group_name, cloud_service_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/start'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Power off the cloud service. Note that resources are still attached and you
    # are getting charged for the resources.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_power_off(resource_group_name, cloud_service_name, custom_headers:nil)
      response = begin_power_off_async(resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # Power off the cloud service. Note that resources are still attached and you
    # are getting charged for the resources.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_power_off_with_http_info(resource_group_name, cloud_service_name, custom_headers:nil)
      begin_power_off_async(resource_group_name, cloud_service_name, custom_headers:custom_headers).value!
    end

    #
    # Power off the cloud service. Note that resources are still attached and you
    # are getting charged for the resources.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_power_off_async(resource_group_name, cloud_service_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/poweroff'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Restarts one or more role instances in a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [RoleInstances] List of cloud service role instance names.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_restart(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      response = begin_restart_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers).value!
      nil
    end

    #
    # Restarts one or more role instances in a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [RoleInstances] List of cloud service role instance names.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_restart_with_http_info(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      begin_restart_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers).value!
    end

    #
    # Restarts one or more role instances in a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [RoleInstances] List of cloud service role instance names.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_restart_async(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::RoleInstances.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/restart'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Reimage asynchronous operation reinstalls the operating system on instances
    # of web roles or worker roles.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [RoleInstances] List of cloud service role instance names.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_reimage(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      response = begin_reimage_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers).value!
      nil
    end

    #
    # Reimage asynchronous operation reinstalls the operating system on instances
    # of web roles or worker roles.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [RoleInstances] List of cloud service role instance names.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_reimage_with_http_info(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      begin_reimage_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers).value!
    end

    #
    # Reimage asynchronous operation reinstalls the operating system on instances
    # of web roles or worker roles.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [RoleInstances] List of cloud service role instance names.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_reimage_async(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::RoleInstances.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/reimage'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Rebuild Role Instances reinstalls the operating system on instances of web
    # roles or worker roles and initializes the storage resources that are used by
    # them. If you do not want to initialize storage resources, you can use Reimage
    # Role Instances.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [RoleInstances] List of cloud service role instance names.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_rebuild(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      response = begin_rebuild_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers).value!
      nil
    end

    #
    # Rebuild Role Instances reinstalls the operating system on instances of web
    # roles or worker roles and initializes the storage resources that are used by
    # them. If you do not want to initialize storage resources, you can use Reimage
    # Role Instances.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [RoleInstances] List of cloud service role instance names.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_rebuild_with_http_info(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      begin_rebuild_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers).value!
    end

    #
    # Rebuild Role Instances reinstalls the operating system on instances of web
    # roles or worker roles and initializes the storage resources that are used by
    # them. If you do not want to initialize storage resources, you can use Reimage
    # Role Instances.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [RoleInstances] List of cloud service role instance names.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_rebuild_async(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::RoleInstances.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/rebuild'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Deletes role instances in a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [RoleInstances] List of cloud service role instance names.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete_instances(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      response = begin_delete_instances_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers).value!
      nil
    end

    #
    # Deletes role instances in a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [RoleInstances] List of cloud service role instance names.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_instances_with_http_info(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      begin_delete_instances_async(resource_group_name, cloud_service_name, parameters:parameters, custom_headers:custom_headers).value!
    end

    #
    # Deletes role instances in a cloud service.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param cloud_service_name [String] Name of the cloud service.
    # @param parameters [RoleInstances] List of cloud service role instance names.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_instances_async(resource_group_name, cloud_service_name, parameters:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'cloud_service_name is nil' if cloud_service_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::RoleInstances.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/delete'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'cloudServiceName' => cloud_service_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets a list of all cloud services in the subscription, regardless of the
    # associated resource group. Use nextLink property in the response to get the
    # next page of Cloud Services. Do this till nextLink is null to fetch all the
    # Cloud Services.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CloudServiceListResult] operation results.
    #
    def list_all_next(next_page_link, custom_headers:nil)
      response = list_all_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a list of all cloud services in the subscription, regardless of the
    # associated resource group. Use nextLink property in the response to get the
    # next page of Cloud Services. Do this till nextLink is null to fetch all the
    # Cloud Services.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_all_next_with_http_info(next_page_link, custom_headers:nil)
      list_all_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Gets a list of all cloud services in the subscription, regardless of the
    # associated resource group. Use nextLink property in the response to get the
    # next page of Cloud Services. Do this till nextLink is null to fetch all the
    # Cloud Services.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_all_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::CloudServiceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a list of all cloud services under a resource group. Use nextLink
    # property in the response to get the next page of Cloud Services. Do this till
    # nextLink is null to fetch all the Cloud Services.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CloudServiceListResult] operation results.
    #
    def list_next(next_page_link, custom_headers:nil)
      response = list_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a list of all cloud services under a resource group. Use nextLink
    # property in the response to get the next page of Cloud Services. Do this till
    # nextLink is null to fetch all the Cloud Services.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers:nil)
      list_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Gets a list of all cloud services under a resource group. Use nextLink
    # property in the response to get the next page of Cloud Services. Do this till
    # nextLink is null to fetch all the Cloud Services.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Compute::Mgmt::V2020_10_01_preview::Models::CloudServiceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a list of all cloud services in the subscription, regardless of the
    # associated resource group. Use nextLink property in the response to get the
    # next page of Cloud Services. Do this till nextLink is null to fetch all the
    # Cloud Services.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CloudServiceListResult] which provide lazy access to pages of the
    # response.
    #
    def list_all_as_lazy(custom_headers:nil)
      response = list_all_async(custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_all_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

    #
    # Gets a list of all cloud services under a resource group. Use nextLink
    # property in the response to get the next page of Cloud Services. Do this till
    # nextLink is null to fetch all the Cloud Services.
    #
    # @param resource_group_name [String] Name of the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CloudServiceListResult] which provide lazy access to pages of the
    # response.
    #
    def list_as_lazy(resource_group_name, custom_headers:nil)
      response = list_async(resource_group_name, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

  end
end
