# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2020_10_01_preview
  module Models
    #
    # Cloud service properties
    #
    class CloudServiceProperties

      include MsRestAzure

      # @return [String] Specifies a URL that refers to the location of the
      # service package in the Blob service. The service package URL can be
      # Shared Access Signature (SAS) URI from any storage account.
      # This is a write-only property and is not returned in GET calls.
      attr_accessor :package_url

      # @return [String] Specifies the XML service configuration (.cscfg) for
      # the cloud service.
      attr_accessor :configuration

      # @return [String] Specifies a URL that refers to the location of the
      # service configuration in the Blob service. The service package URL  can
      # be Shared Access Signature (SAS) URI from any storage account.
      # This is a write-only property and is not returned in GET calls.
      attr_accessor :configuration_url

      # @return [Boolean] (Optional) Indicates whether to start the cloud
      # service immediately after it is created. The default value is `true`.
      # If false, the service model is still deployed, but the code is not run
      # immediately. Instead, the service is PoweredOff until you call Start,
      # at which time the service will be started. A deployed service still
      # incurs charges, even if it is poweredoff.
      attr_accessor :start_cloud_service

      # @return [CloudServiceUpgradeMode] Possible values include: 'Auto',
      # 'Manual', 'Simultaneous'
      attr_accessor :upgrade_mode

      # @return [CloudServiceRoleProfile]
      attr_accessor :role_profile

      # @return [CloudServiceOsProfile]
      attr_accessor :os_profile

      # @return [CloudServiceNetworkProfile]
      attr_accessor :network_profile

      # @return [CloudServiceExtensionProfile]
      attr_accessor :extension_profile

      # @return [String] The provisioning state, which only appears in the
      # response.
      attr_accessor :provisioning_state

      # @return [String] The unique identifier for the cloud service.
      attr_accessor :unique_id


      #
      # Mapper for CloudServiceProperties class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'CloudServiceProperties',
          type: {
            name: 'Composite',
            class_name: 'CloudServiceProperties',
            model_properties: {
              package_url: {
                client_side_validation: true,
                required: false,
                serialized_name: 'packageUrl',
                type: {
                  name: 'String'
                }
              },
              configuration: {
                client_side_validation: true,
                required: false,
                serialized_name: 'configuration',
                type: {
                  name: 'String'
                }
              },
              configuration_url: {
                client_side_validation: true,
                required: false,
                serialized_name: 'configurationUrl',
                type: {
                  name: 'String'
                }
              },
              start_cloud_service: {
                client_side_validation: true,
                required: false,
                serialized_name: 'startCloudService',
                type: {
                  name: 'Boolean'
                }
              },
              upgrade_mode: {
                client_side_validation: true,
                required: false,
                serialized_name: 'upgradeMode',
                type: {
                  name: 'String'
                }
              },
              role_profile: {
                client_side_validation: true,
                required: false,
                serialized_name: 'roleProfile',
                type: {
                  name: 'Composite',
                  class_name: 'CloudServiceRoleProfile'
                }
              },
              os_profile: {
                client_side_validation: true,
                required: false,
                serialized_name: 'osProfile',
                type: {
                  name: 'Composite',
                  class_name: 'CloudServiceOsProfile'
                }
              },
              network_profile: {
                client_side_validation: true,
                required: false,
                serialized_name: 'networkProfile',
                type: {
                  name: 'Composite',
                  class_name: 'CloudServiceNetworkProfile'
                }
              },
              extension_profile: {
                client_side_validation: true,
                required: false,
                serialized_name: 'extensionProfile',
                type: {
                  name: 'Composite',
                  class_name: 'CloudServiceExtensionProfile'
                }
              },
              provisioning_state: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'provisioningState',
                type: {
                  name: 'String'
                }
              },
              unique_id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'uniqueId',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
