# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Compute::Mgmt::V2020_12_01
  module Models
    #
    # Specifies information about the Dedicated host.
    #
    class DedicatedHost < Resource

      include MsRestAzure

      # @return [Integer] Fault domain of the dedicated host within a dedicated
      # host group.
      attr_accessor :platform_fault_domain

      # @return [Boolean] Specifies whether the dedicated host should be
      # replaced automatically in case of a failure. The value is defaulted to
      # 'true' when not provided.
      attr_accessor :auto_replace_on_failure

      # @return [String] A unique id generated and assigned to the dedicated
      # host by the platform. <br><br> Does not change throughout the lifetime
      # of the host.
      attr_accessor :host_id

      # @return [Array<SubResourceReadOnly>] A list of references to all
      # virtual machines in the Dedicated Host.
      attr_accessor :virtual_machines

      # @return [DedicatedHostLicenseTypes] Specifies the software license type
      # that will be applied to the VMs deployed on the dedicated host.
      # <br><br> Possible values are: <br><br> **None** <br><br>
      # **Windows_Server_Hybrid** <br><br> **Windows_Server_Perpetual**
      # <br><br> Default: **None**. Possible values include: 'None',
      # 'Windows_Server_Hybrid', 'Windows_Server_Perpetual'
      attr_accessor :license_type

      # @return [DateTime] The date when the host was first provisioned.
      attr_accessor :provisioning_time

      # @return [String] The provisioning state, which only appears in the
      # response.
      attr_accessor :provisioning_state

      # @return [DedicatedHostInstanceView] The dedicated host instance view.
      attr_accessor :instance_view

      # @return [Sku] SKU of the dedicated host for Hardware Generation and VM
      # family. Only name is required to be set. List Microsoft.Compute SKUs
      # for a list of possible values.
      attr_accessor :sku


      #
      # Mapper for DedicatedHost class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'DedicatedHost',
          type: {
            name: 'Composite',
            class_name: 'DedicatedHost',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              location: {
                client_side_validation: true,
                required: true,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              tags: {
                client_side_validation: true,
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              platform_fault_domain: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.platformFaultDomain',
                constraints: {
                  InclusiveMinimum: 0
                },
                type: {
                  name: 'Number'
                }
              },
              auto_replace_on_failure: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.autoReplaceOnFailure',
                type: {
                  name: 'Boolean'
                }
              },
              host_id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.hostId',
                type: {
                  name: 'String'
                }
              },
              virtual_machines: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.virtualMachines',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'SubResourceReadOnlyElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'SubResourceReadOnly'
                      }
                  }
                }
              },
              license_type: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.licenseType',
                type: {
                  name: 'Enum',
                  module: 'DedicatedHostLicenseTypes'
                }
              },
              provisioning_time: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.provisioningTime',
                type: {
                  name: 'DateTime'
                }
              },
              provisioning_state: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.provisioningState',
                type: {
                  name: 'String'
                }
              },
              instance_view: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.instanceView',
                type: {
                  name: 'Composite',
                  class_name: 'DedicatedHostInstanceView'
                }
              },
              sku: {
                client_side_validation: true,
                required: true,
                serialized_name: 'sku',
                type: {
                  name: 'Composite',
                  class_name: 'Sku'
                }
              }
            }
          }
        }
      end
    end
  end
end
