# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::KeyVault::Mgmt::V2019_09_01
  #
  # The Azure management API provides a RESTful set of web services that
  # interact with Azure Key Vault.
  #
  class Keys
    include MsRestAzure

    #
    # Creates and initializes a new instance of the Keys class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [KeyVaultManagementClient] reference to the KeyVaultManagementClient
    attr_reader :client

    #
    # Creates the first version of a new key if it does not exist. If it already
    # exists, then the existing key is returned without any write operations being
    # performed. This API does not create subsequent versions, and does not update
    # existing keys.
    #
    # @param resource_group_name [String] The name of the resource group which
    # contains the specified key vault.
    # @param vault_name [String] The name of the key vault which contains the key
    # to be created.
    # @param key_name [String] The name of the key to be created.
    # @param parameters [KeyCreateParameters] The parameters used to create the
    # specified key.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Key] operation results.
    #
    def create_if_not_exist(resource_group_name, vault_name, key_name, parameters, custom_headers:nil)
      response = create_if_not_exist_async(resource_group_name, vault_name, key_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates the first version of a new key if it does not exist. If it already
    # exists, then the existing key is returned without any write operations being
    # performed. This API does not create subsequent versions, and does not update
    # existing keys.
    #
    # @param resource_group_name [String] The name of the resource group which
    # contains the specified key vault.
    # @param vault_name [String] The name of the key vault which contains the key
    # to be created.
    # @param key_name [String] The name of the key to be created.
    # @param parameters [KeyCreateParameters] The parameters used to create the
    # specified key.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_if_not_exist_with_http_info(resource_group_name, vault_name, key_name, parameters, custom_headers:nil)
      create_if_not_exist_async(resource_group_name, vault_name, key_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Creates the first version of a new key if it does not exist. If it already
    # exists, then the existing key is returned without any write operations being
    # performed. This API does not create subsequent versions, and does not update
    # existing keys.
    #
    # @param resource_group_name [String] The name of the resource group which
    # contains the specified key vault.
    # @param vault_name [String] The name of the key vault which contains the key
    # to be created.
    # @param key_name [String] The name of the key to be created.
    # @param parameters [KeyCreateParameters] The parameters used to create the
    # specified key.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_if_not_exist_async(resource_group_name, vault_name, key_name, parameters, custom_headers:nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vault_name is nil' if vault_name.nil?
      fail ArgumentError, "'vault_name' should satisfy the constraint - 'Pattern': '^[a-zA-Z0-9-]{3,24}$'" if !vault_name.nil? && vault_name.match(Regexp.new('^^[a-zA-Z0-9-]{3,24}$$')).nil?
      fail ArgumentError, 'key_name is nil' if key_name.nil?
      fail ArgumentError, "'key_name' should satisfy the constraint - 'Pattern': '^[a-zA-Z0-9-]{1,127}$'" if !key_name.nil? && key_name.match(Regexp.new('^^[a-zA-Z0-9-]{1,127}$$')).nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::KeyVault::Mgmt::V2019_09_01::Models::KeyCreateParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/keys/{keyName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'vaultName' => vault_name,'keyName' => key_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::KeyVault::Mgmt::V2019_09_01::Models::Key.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the current version of the specified key from the specified key vault.
    #
    # @param resource_group_name [String] The name of the resource group which
    # contains the specified key vault.
    # @param vault_name [String] The name of the vault which contains the key to be
    # retrieved.
    # @param key_name [String] The name of the key to be retrieved.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Key] operation results.
    #
    def get(resource_group_name, vault_name, key_name, custom_headers:nil)
      response = get_async(resource_group_name, vault_name, key_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the current version of the specified key from the specified key vault.
    #
    # @param resource_group_name [String] The name of the resource group which
    # contains the specified key vault.
    # @param vault_name [String] The name of the vault which contains the key to be
    # retrieved.
    # @param key_name [String] The name of the key to be retrieved.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, vault_name, key_name, custom_headers:nil)
      get_async(resource_group_name, vault_name, key_name, custom_headers:custom_headers).value!
    end

    #
    # Gets the current version of the specified key from the specified key vault.
    #
    # @param resource_group_name [String] The name of the resource group which
    # contains the specified key vault.
    # @param vault_name [String] The name of the vault which contains the key to be
    # retrieved.
    # @param key_name [String] The name of the key to be retrieved.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, vault_name, key_name, custom_headers:nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vault_name is nil' if vault_name.nil?
      fail ArgumentError, "'vault_name' should satisfy the constraint - 'Pattern': '^[a-zA-Z0-9-]{3,24}$'" if !vault_name.nil? && vault_name.match(Regexp.new('^^[a-zA-Z0-9-]{3,24}$$')).nil?
      fail ArgumentError, 'key_name is nil' if key_name.nil?
      fail ArgumentError, "'key_name' should satisfy the constraint - 'Pattern': '^[a-zA-Z0-9-]{1,127}$'" if !key_name.nil? && key_name.match(Regexp.new('^^[a-zA-Z0-9-]{1,127}$$')).nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/keys/{keyName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'vaultName' => vault_name,'keyName' => key_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::KeyVault::Mgmt::V2019_09_01::Models::Key.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the keys in the specified key vault.
    #
    # @param resource_group_name [String] The name of the resource group which
    # contains the specified key vault.
    # @param vault_name [String] The name of the vault which contains the keys to
    # be retrieved.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Key>] operation results.
    #
    def list(resource_group_name, vault_name, custom_headers:nil)
      first_page = list_as_lazy(resource_group_name, vault_name, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Lists the keys in the specified key vault.
    #
    # @param resource_group_name [String] The name of the resource group which
    # contains the specified key vault.
    # @param vault_name [String] The name of the vault which contains the keys to
    # be retrieved.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(resource_group_name, vault_name, custom_headers:nil)
      list_async(resource_group_name, vault_name, custom_headers:custom_headers).value!
    end

    #
    # Lists the keys in the specified key vault.
    #
    # @param resource_group_name [String] The name of the resource group which
    # contains the specified key vault.
    # @param vault_name [String] The name of the vault which contains the keys to
    # be retrieved.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(resource_group_name, vault_name, custom_headers:nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vault_name is nil' if vault_name.nil?
      fail ArgumentError, "'vault_name' should satisfy the constraint - 'Pattern': '^[a-zA-Z0-9-]{3,24}$'" if !vault_name.nil? && vault_name.match(Regexp.new('^^[a-zA-Z0-9-]{3,24}$$')).nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/keys'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'vaultName' => vault_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::KeyVault::Mgmt::V2019_09_01::Models::KeyListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the specified version of the specified key in the specified key vault.
    #
    # @param resource_group_name [String] The name of the resource group which
    # contains the specified key vault.
    # @param vault_name [String] The name of the vault which contains the key
    # version to be retrieved.
    # @param key_name [String] The name of the key version to be retrieved.
    # @param key_version [String] The version of the key to be retrieved.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Key] operation results.
    #
    def get_version(resource_group_name, vault_name, key_name, key_version, custom_headers:nil)
      response = get_version_async(resource_group_name, vault_name, key_name, key_version, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the specified version of the specified key in the specified key vault.
    #
    # @param resource_group_name [String] The name of the resource group which
    # contains the specified key vault.
    # @param vault_name [String] The name of the vault which contains the key
    # version to be retrieved.
    # @param key_name [String] The name of the key version to be retrieved.
    # @param key_version [String] The version of the key to be retrieved.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_version_with_http_info(resource_group_name, vault_name, key_name, key_version, custom_headers:nil)
      get_version_async(resource_group_name, vault_name, key_name, key_version, custom_headers:custom_headers).value!
    end

    #
    # Gets the specified version of the specified key in the specified key vault.
    #
    # @param resource_group_name [String] The name of the resource group which
    # contains the specified key vault.
    # @param vault_name [String] The name of the vault which contains the key
    # version to be retrieved.
    # @param key_name [String] The name of the key version to be retrieved.
    # @param key_version [String] The version of the key to be retrieved.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_version_async(resource_group_name, vault_name, key_name, key_version, custom_headers:nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vault_name is nil' if vault_name.nil?
      fail ArgumentError, "'vault_name' should satisfy the constraint - 'Pattern': '^[a-zA-Z0-9-]{3,24}$'" if !vault_name.nil? && vault_name.match(Regexp.new('^^[a-zA-Z0-9-]{3,24}$$')).nil?
      fail ArgumentError, 'key_name is nil' if key_name.nil?
      fail ArgumentError, "'key_name' should satisfy the constraint - 'Pattern': '^[a-zA-Z0-9-]{1,127}$'" if !key_name.nil? && key_name.match(Regexp.new('^^[a-zA-Z0-9-]{1,127}$$')).nil?
      fail ArgumentError, 'key_version is nil' if key_version.nil?
      fail ArgumentError, "'key_version' should satisfy the constraint - 'Pattern': '^[a-fA-F0-9]{32}$'" if !key_version.nil? && key_version.match(Regexp.new('^^[a-fA-F0-9]{32}$$')).nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/keys/{keyName}/versions/{keyVersion}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'vaultName' => vault_name,'keyName' => key_name,'keyVersion' => key_version},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::KeyVault::Mgmt::V2019_09_01::Models::Key.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the versions of the specified key in the specified key vault.
    #
    # @param resource_group_name [String] The name of the resource group which
    # contains the specified key vault.
    # @param vault_name [String] The name of the vault which contains the key
    # versions to be retrieved.
    # @param key_name [String] The name of the key versions to be retrieved.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Key>] operation results.
    #
    def list_versions(resource_group_name, vault_name, key_name, custom_headers:nil)
      first_page = list_versions_as_lazy(resource_group_name, vault_name, key_name, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Lists the versions of the specified key in the specified key vault.
    #
    # @param resource_group_name [String] The name of the resource group which
    # contains the specified key vault.
    # @param vault_name [String] The name of the vault which contains the key
    # versions to be retrieved.
    # @param key_name [String] The name of the key versions to be retrieved.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_versions_with_http_info(resource_group_name, vault_name, key_name, custom_headers:nil)
      list_versions_async(resource_group_name, vault_name, key_name, custom_headers:custom_headers).value!
    end

    #
    # Lists the versions of the specified key in the specified key vault.
    #
    # @param resource_group_name [String] The name of the resource group which
    # contains the specified key vault.
    # @param vault_name [String] The name of the vault which contains the key
    # versions to be retrieved.
    # @param key_name [String] The name of the key versions to be retrieved.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_versions_async(resource_group_name, vault_name, key_name, custom_headers:nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'vault_name is nil' if vault_name.nil?
      fail ArgumentError, "'vault_name' should satisfy the constraint - 'Pattern': '^[a-zA-Z0-9-]{3,24}$'" if !vault_name.nil? && vault_name.match(Regexp.new('^^[a-zA-Z0-9-]{3,24}$$')).nil?
      fail ArgumentError, 'key_name is nil' if key_name.nil?
      fail ArgumentError, "'key_name' should satisfy the constraint - 'Pattern': '^[a-zA-Z0-9-]{1,127}$'" if !key_name.nil? && key_name.match(Regexp.new('^^[a-zA-Z0-9-]{1,127}$$')).nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/keys/{keyName}/versions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'vaultName' => vault_name,'keyName' => key_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::KeyVault::Mgmt::V2019_09_01::Models::KeyListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the keys in the specified key vault.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [KeyListResult] operation results.
    #
    def list_next(next_page_link, custom_headers:nil)
      response = list_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists the keys in the specified key vault.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers:nil)
      list_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Lists the keys in the specified key vault.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::KeyVault::Mgmt::V2019_09_01::Models::KeyListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the versions of the specified key in the specified key vault.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [KeyListResult] operation results.
    #
    def list_versions_next(next_page_link, custom_headers:nil)
      response = list_versions_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists the versions of the specified key in the specified key vault.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_versions_next_with_http_info(next_page_link, custom_headers:nil)
      list_versions_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Lists the versions of the specified key in the specified key vault.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_versions_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::KeyVault::Mgmt::V2019_09_01::Models::KeyListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the keys in the specified key vault.
    #
    # @param resource_group_name [String] The name of the resource group which
    # contains the specified key vault.
    # @param vault_name [String] The name of the vault which contains the keys to
    # be retrieved.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [KeyListResult] which provide lazy access to pages of the response.
    #
    def list_as_lazy(resource_group_name, vault_name, custom_headers:nil)
      response = list_async(resource_group_name, vault_name, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

    #
    # Lists the versions of the specified key in the specified key vault.
    #
    # @param resource_group_name [String] The name of the resource group which
    # contains the specified key vault.
    # @param vault_name [String] The name of the vault which contains the key
    # versions to be retrieved.
    # @param key_name [String] The name of the key versions to be retrieved.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [KeyListResult] which provide lazy access to pages of the response.
    #
    def list_versions_as_lazy(resource_group_name, vault_name, key_name, custom_headers:nil)
      response = list_versions_async(resource_group_name, vault_name, key_name, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_versions_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

  end
end
