# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Network::Mgmt::V2018_06_01
  module Models
    #
    # VpnConnection Resource.
    #
    class VpnConnection < SubResource

      include MsRestAzure

      # @return [SubResource] Id of the connected vpn site.
      attr_accessor :remote_vpn_site

      # @return [Integer] routing weight for vpn connection.
      attr_accessor :routing_weight

      # @return [VpnConnectionStatus] The connection status. Possible values
      # include: 'Unknown', 'Connecting', 'Connected', 'NotConnected'
      attr_accessor :connection_status

      # @return [Integer] Ingress bytes transferred.
      attr_accessor :ingress_bytes_transferred

      # @return [Integer] Egress bytes transferred.
      attr_accessor :egress_bytes_transferred

      # @return [Integer] Expected bandwidth in MBPS.
      attr_accessor :connection_bandwidth_in_mbps

      # @return [String] SharedKey for the vpn connection.
      attr_accessor :shared_key

      # @return [Boolean] EnableBgp flag
      attr_accessor :enable_bgp

      # @return [Array<IpsecPolicy>] The IPSec Policies to be considered by
      # this connection.
      attr_accessor :ipsec_policies

      # @return [ProvisioningState] The provisioning state of the resource.
      # Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
      attr_accessor :provisioning_state

      # @return [String] The name of the resource that is unique within a
      # resource group. This name can be used to access the resource.
      attr_accessor :name

      # @return [String] Gets a unique read-only string that changes whenever
      # the resource is updated.
      attr_accessor :etag


      #
      # Mapper for VpnConnection class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'VpnConnection',
          type: {
            name: 'Composite',
            class_name: 'VpnConnection',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              remote_vpn_site: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.remoteVpnSite',
                type: {
                  name: 'Composite',
                  class_name: 'SubResource'
                }
              },
              routing_weight: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.routingWeight',
                type: {
                  name: 'Number'
                }
              },
              connection_status: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.connectionStatus',
                type: {
                  name: 'String'
                }
              },
              ingress_bytes_transferred: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.ingressBytesTransferred',
                type: {
                  name: 'Number'
                }
              },
              egress_bytes_transferred: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.egressBytesTransferred',
                type: {
                  name: 'Number'
                }
              },
              connection_bandwidth_in_mbps: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.connectionBandwidthInMbps',
                type: {
                  name: 'Number'
                }
              },
              shared_key: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.sharedKey',
                type: {
                  name: 'String'
                }
              },
              enable_bgp: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.enableBgp',
                type: {
                  name: 'Boolean'
                }
              },
              ipsec_policies: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.ipsecPolicies',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'IpsecPolicyElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'IpsecPolicy'
                      }
                  }
                }
              },
              provisioning_state: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.provisioningState',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              etag: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'etag',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
