# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Network::Mgmt::V2019_12_01
  #
  # VirtualNetworkGateways
  #
  class VirtualNetworkGateways
    include MsRestAzure

    #
    # Creates and initializes a new instance of the VirtualNetworkGateways class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [NetworkManagementClient] reference to the NetworkManagementClient
    attr_reader :client

    #
    # Creates or updates a virtual network gateway in the specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VirtualNetworkGateway] Parameters supplied to create or
    # update virtual network gateway operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualNetworkGateway] operation results.
    #
    def create_or_update(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      response = create_or_update_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VirtualNetworkGateway] Parameters supplied to create or
    # update virtual network gateway operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_create_or_update_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VirtualNetworkGateway.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets the specified virtual network gateway by resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualNetworkGateway] operation results.
    #
    def get(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      response = get_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the specified virtual network gateway by resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      get_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
    end

    #
    # Gets the specified virtual network gateway by resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_name is nil' if virtual_network_gateway_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualNetworkGatewayName' => virtual_network_gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VirtualNetworkGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes the specified virtual network gateway.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      response = delete_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      # Send request
      promise = begin_delete_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Updates a virtual network gateway tags.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [TagsObject] Parameters supplied to update virtual network
    # gateway tags.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualNetworkGateway] operation results.
    #
    def update_tags(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      response = update_tags_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [TagsObject] Parameters supplied to update virtual network
    # gateway tags.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def update_tags_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_update_tags_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VirtualNetworkGateway.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets all virtual network gateways by resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<VirtualNetworkGateway>] operation results.
    #
    def list(resource_group_name, custom_headers:nil)
      first_page = list_as_lazy(resource_group_name, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Gets all virtual network gateways by resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(resource_group_name, custom_headers:nil)
      list_async(resource_group_name, custom_headers:custom_headers).value!
    end

    #
    # Gets all virtual network gateways by resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(resource_group_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VirtualNetworkGatewayListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all the connections in a virtual network gateway.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<VirtualNetworkGatewayConnectionListEntity>] operation results.
    #
    def list_connections(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      first_page = list_connections_as_lazy(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Gets all the connections in a virtual network gateway.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_connections_with_http_info(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      list_connections_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
    end

    #
    # Gets all the connections in a virtual network gateway.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_connections_async(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_name is nil' if virtual_network_gateway_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/connections'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualNetworkGatewayName' => virtual_network_gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VirtualNetworkGatewayListConnectionsResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Resets the primary of the virtual network gateway in the specified resource
    # group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param gateway_vip [String] Virtual network gateway vip address supplied to
    # the begin reset of the active-active feature enabled gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualNetworkGateway] operation results.
    #
    def reset(resource_group_name, virtual_network_gateway_name, gateway_vip:nil, custom_headers:nil)
      response = reset_async(resource_group_name, virtual_network_gateway_name, gateway_vip:gateway_vip, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param gateway_vip [String] Virtual network gateway vip address supplied to
    # the begin reset of the active-active feature enabled gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def reset_async(resource_group_name, virtual_network_gateway_name, gateway_vip:nil, custom_headers:nil)
      # Send request
      promise = begin_reset_async(resource_group_name, virtual_network_gateway_name, gateway_vip:gateway_vip, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VirtualNetworkGateway.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Resets the VPN client shared key of the virtual network gateway in the
    # specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def reset_vpn_client_shared_key(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      response = reset_vpn_client_shared_key_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def reset_vpn_client_shared_key_async(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      # Send request
      promise = begin_reset_vpn_client_shared_key_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Generates VPN client package for P2S client of the virtual network gateway in
    # the specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VpnClientParameters] Parameters supplied to the generate
    # virtual network gateway VPN client package operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [String] operation results.
    #
    def generatevpnclientpackage(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      response = generatevpnclientpackage_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VpnClientParameters] Parameters supplied to the generate
    # virtual network gateway VPN client package operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def generatevpnclientpackage_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_generatevpnclientpackage_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = {
            client_side_validation: true,
            required: false,
            serialized_name: 'parsed_response',
            type: {
              name: 'String'
            }
          }
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Generates VPN profile for P2S client of the virtual network gateway in the
    # specified resource group. Used for IKEV2 and radius based authentication.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VpnClientParameters] Parameters supplied to the generate
    # virtual network gateway VPN client package operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [String] operation results.
    #
    def generate_vpn_profile(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      response = generate_vpn_profile_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VpnClientParameters] Parameters supplied to the generate
    # virtual network gateway VPN client package operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def generate_vpn_profile_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_generate_vpn_profile_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = {
            client_side_validation: true,
            required: false,
            serialized_name: 'parsed_response',
            type: {
              name: 'String'
            }
          }
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Gets pre-generated VPN profile for P2S client of the virtual network gateway
    # in the specified resource group. The profile needs to be generated first
    # using generateVpnProfile.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [String] operation results.
    #
    def get_vpn_profile_package_url(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      response = get_vpn_profile_package_url_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def get_vpn_profile_package_url_async(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      # Send request
      promise = begin_get_vpn_profile_package_url_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = {
            client_side_validation: true,
            required: false,
            serialized_name: 'parsed_response',
            type: {
              name: 'String'
            }
          }
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # The GetBgpPeerStatus operation retrieves the status of all BGP peers.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param peer [String] The IP address of the peer to retrieve the status of.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BgpPeerStatusListResult] operation results.
    #
    def get_bgp_peer_status(resource_group_name, virtual_network_gateway_name, peer:nil, custom_headers:nil)
      response = get_bgp_peer_status_async(resource_group_name, virtual_network_gateway_name, peer:peer, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param peer [String] The IP address of the peer to retrieve the status of.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def get_bgp_peer_status_async(resource_group_name, virtual_network_gateway_name, peer:nil, custom_headers:nil)
      # Send request
      promise = begin_get_bgp_peer_status_async(resource_group_name, virtual_network_gateway_name, peer:peer, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::BgpPeerStatusListResult.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Gets a xml format representation for supported vpn devices.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [String] operation results.
    #
    def supported_vpn_devices(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      response = supported_vpn_devices_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a xml format representation for supported vpn devices.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def supported_vpn_devices_with_http_info(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      supported_vpn_devices_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
    end

    #
    # Gets a xml format representation for supported vpn devices.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def supported_vpn_devices_async(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_name is nil' if virtual_network_gateway_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/supportedvpndevices'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualNetworkGatewayName' => virtual_network_gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              client_side_validation: true,
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'String'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # This operation retrieves a list of routes the virtual network gateway has
    # learned, including routes learned from BGP peers.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GatewayRouteListResult] operation results.
    #
    def get_learned_routes(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      response = get_learned_routes_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def get_learned_routes_async(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      # Send request
      promise = begin_get_learned_routes_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::GatewayRouteListResult.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # This operation retrieves a list of routes the virtual network gateway is
    # advertising to the specified peer.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param peer [String] The IP address of the peer.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GatewayRouteListResult] operation results.
    #
    def get_advertised_routes(resource_group_name, virtual_network_gateway_name, peer, custom_headers:nil)
      response = get_advertised_routes_async(resource_group_name, virtual_network_gateway_name, peer, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param peer [String] The IP address of the peer.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def get_advertised_routes_async(resource_group_name, virtual_network_gateway_name, peer, custom_headers:nil)
      # Send request
      promise = begin_get_advertised_routes_async(resource_group_name, virtual_network_gateway_name, peer, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::GatewayRouteListResult.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # The Set VpnclientIpsecParameters operation sets the vpnclient ipsec policy
    # for P2S client of virtual network gateway in the specified resource group
    # through Network resource provider.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param vpnclient_ipsec_params [VpnClientIPsecParameters] Parameters supplied
    # to the Begin Set vpnclient ipsec parameters of Virtual Network Gateway P2S
    # client operation through Network resource provider.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VpnClientIPsecParameters] operation results.
    #
    def set_vpnclient_ipsec_parameters(resource_group_name, virtual_network_gateway_name, vpnclient_ipsec_params, custom_headers:nil)
      response = set_vpnclient_ipsec_parameters_async(resource_group_name, virtual_network_gateway_name, vpnclient_ipsec_params, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param vpnclient_ipsec_params [VpnClientIPsecParameters] Parameters supplied
    # to the Begin Set vpnclient ipsec parameters of Virtual Network Gateway P2S
    # client operation through Network resource provider.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def set_vpnclient_ipsec_parameters_async(resource_group_name, virtual_network_gateway_name, vpnclient_ipsec_params, custom_headers:nil)
      # Send request
      promise = begin_set_vpnclient_ipsec_parameters_async(resource_group_name, virtual_network_gateway_name, vpnclient_ipsec_params, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VpnClientIPsecParameters.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # The Get VpnclientIpsecParameters operation retrieves information about the
    # vpnclient ipsec policy for P2S client of virtual network gateway in the
    # specified resource group through Network resource provider.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The virtual network gateway
    # name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VpnClientIPsecParameters] operation results.
    #
    def get_vpnclient_ipsec_parameters(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      response = get_vpnclient_ipsec_parameters_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The virtual network gateway
    # name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def get_vpnclient_ipsec_parameters_async(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      # Send request
      promise = begin_get_vpnclient_ipsec_parameters_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VpnClientIPsecParameters.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Gets a xml format representation for vpn device configuration script.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_connection_name [String] The name of the
    # virtual network gateway connection for which the configuration script is
    # generated.
    # @param parameters [VpnDeviceScriptParameters] Parameters supplied to the
    # generate vpn device script operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [String] operation results.
    #
    def vpn_device_configuration_script(resource_group_name, virtual_network_gateway_connection_name, parameters, custom_headers:nil)
      response = vpn_device_configuration_script_async(resource_group_name, virtual_network_gateway_connection_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a xml format representation for vpn device configuration script.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_connection_name [String] The name of the
    # virtual network gateway connection for which the configuration script is
    # generated.
    # @param parameters [VpnDeviceScriptParameters] Parameters supplied to the
    # generate vpn device script operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def vpn_device_configuration_script_with_http_info(resource_group_name, virtual_network_gateway_connection_name, parameters, custom_headers:nil)
      vpn_device_configuration_script_async(resource_group_name, virtual_network_gateway_connection_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Gets a xml format representation for vpn device configuration script.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_connection_name [String] The name of the
    # virtual network gateway connection for which the configuration script is
    # generated.
    # @param parameters [VpnDeviceScriptParameters] Parameters supplied to the
    # generate vpn device script operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def vpn_device_configuration_script_async(resource_group_name, virtual_network_gateway_connection_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_connection_name is nil' if virtual_network_gateway_connection_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VpnDeviceScriptParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/connections/{virtualNetworkGatewayConnectionName}/vpndeviceconfigurationscript'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualNetworkGatewayConnectionName' => virtual_network_gateway_connection_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              client_side_validation: true,
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'String'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Starts packet capture on virtual network gateway in the specified resource
    # group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VpnPacketCaptureStartParameters] Virtual network gateway
    # packet capture parameters supplied to start packet capture on gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [String] operation results.
    #
    def start_packet_capture(resource_group_name, virtual_network_gateway_name, parameters:nil, custom_headers:nil)
      response = start_packet_capture_async(resource_group_name, virtual_network_gateway_name, parameters:parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VpnPacketCaptureStartParameters] Virtual network gateway
    # packet capture parameters supplied to start packet capture on gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def start_packet_capture_async(resource_group_name, virtual_network_gateway_name, parameters:nil, custom_headers:nil)
      # Send request
      promise = begin_start_packet_capture_async(resource_group_name, virtual_network_gateway_name, parameters:parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = {
            client_side_validation: true,
            required: false,
            serialized_name: 'parsed_response',
            type: {
              name: 'String'
            }
          }
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Stops packet capture on virtual network gateway in the specified resource
    # group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VpnPacketCaptureStopParameters] Virtual network gateway
    # packet capture parameters supplied to stop packet capture on gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [String] operation results.
    #
    def stop_packet_capture(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      response = stop_packet_capture_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VpnPacketCaptureStopParameters] Virtual network gateway
    # packet capture parameters supplied to stop packet capture on gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def stop_packet_capture_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_stop_packet_capture_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = {
            client_side_validation: true,
            required: false,
            serialized_name: 'parsed_response',
            type: {
              name: 'String'
            }
          }
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Get VPN client connection health detail per P2S client connection of the
    # virtual network gateway in the specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VpnClientConnectionHealthDetailListResult] operation results.
    #
    def get_vpnclient_connection_health(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      response = get_vpnclient_connection_health_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def get_vpnclient_connection_health_async(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      # Send request
      promise = begin_get_vpnclient_connection_health_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VpnClientConnectionHealthDetailListResult.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Disconnect vpn connections of virtual network gateway in the specified
    # resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param request [P2SVpnConnectionRequest] The parameters are supplied to
    # disconnect vpn connections.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def disconnect_virtual_network_gateway_vpn_connections(resource_group_name, virtual_network_gateway_name, request, custom_headers:nil)
      response = disconnect_virtual_network_gateway_vpn_connections_async(resource_group_name, virtual_network_gateway_name, request, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param request [P2SVpnConnectionRequest] The parameters are supplied to
    # disconnect vpn connections.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def disconnect_virtual_network_gateway_vpn_connections_async(resource_group_name, virtual_network_gateway_name, request, custom_headers:nil)
      # Send request
      promise = begin_disconnect_virtual_network_gateway_vpn_connections_async(resource_group_name, virtual_network_gateway_name, request, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Creates or updates a virtual network gateway in the specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VirtualNetworkGateway] Parameters supplied to create or
    # update virtual network gateway operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualNetworkGateway] operation results.
    #
    def begin_create_or_update(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      response = begin_create_or_update_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates or updates a virtual network gateway in the specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VirtualNetworkGateway] Parameters supplied to create or
    # update virtual network gateway operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_with_http_info(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      begin_create_or_update_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Creates or updates a virtual network gateway in the specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VirtualNetworkGateway] Parameters supplied to create or
    # update virtual network gateway operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_name is nil' if virtual_network_gateway_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VirtualNetworkGateway.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualNetworkGatewayName' => virtual_network_gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VirtualNetworkGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VirtualNetworkGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes the specified virtual network gateway.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      response = begin_delete_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # Deletes the specified virtual network gateway.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      begin_delete_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
    end

    #
    # Deletes the specified virtual network gateway.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_name is nil' if virtual_network_gateway_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualNetworkGatewayName' => virtual_network_gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204 || status_code == 202 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Updates a virtual network gateway tags.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [TagsObject] Parameters supplied to update virtual network
    # gateway tags.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualNetworkGateway] operation results.
    #
    def begin_update_tags(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      response = begin_update_tags_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates a virtual network gateway tags.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [TagsObject] Parameters supplied to update virtual network
    # gateway tags.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_update_tags_with_http_info(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      begin_update_tags_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Updates a virtual network gateway tags.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [TagsObject] Parameters supplied to update virtual network
    # gateway tags.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_update_tags_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_name is nil' if virtual_network_gateway_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2019_12_01::Models::TagsObject.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualNetworkGatewayName' => virtual_network_gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VirtualNetworkGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Resets the primary of the virtual network gateway in the specified resource
    # group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param gateway_vip [String] Virtual network gateway vip address supplied to
    # the begin reset of the active-active feature enabled gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualNetworkGateway] operation results.
    #
    def begin_reset(resource_group_name, virtual_network_gateway_name, gateway_vip:nil, custom_headers:nil)
      response = begin_reset_async(resource_group_name, virtual_network_gateway_name, gateway_vip:gateway_vip, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Resets the primary of the virtual network gateway in the specified resource
    # group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param gateway_vip [String] Virtual network gateway vip address supplied to
    # the begin reset of the active-active feature enabled gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_reset_with_http_info(resource_group_name, virtual_network_gateway_name, gateway_vip:nil, custom_headers:nil)
      begin_reset_async(resource_group_name, virtual_network_gateway_name, gateway_vip:gateway_vip, custom_headers:custom_headers).value!
    end

    #
    # Resets the primary of the virtual network gateway in the specified resource
    # group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param gateway_vip [String] Virtual network gateway vip address supplied to
    # the begin reset of the active-active feature enabled gateway.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_reset_async(resource_group_name, virtual_network_gateway_name, gateway_vip:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_name is nil' if virtual_network_gateway_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/reset'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualNetworkGatewayName' => virtual_network_gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'gatewayVip' => gateway_vip,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VirtualNetworkGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Resets the VPN client shared key of the virtual network gateway in the
    # specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_reset_vpn_client_shared_key(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      response = begin_reset_vpn_client_shared_key_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # Resets the VPN client shared key of the virtual network gateway in the
    # specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_reset_vpn_client_shared_key_with_http_info(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      begin_reset_vpn_client_shared_key_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
    end

    #
    # Resets the VPN client shared key of the virtual network gateway in the
    # specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_reset_vpn_client_shared_key_async(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_name is nil' if virtual_network_gateway_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/resetvpnclientsharedkey'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualNetworkGatewayName' => virtual_network_gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Generates VPN client package for P2S client of the virtual network gateway in
    # the specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VpnClientParameters] Parameters supplied to the generate
    # virtual network gateway VPN client package operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [String] operation results.
    #
    def begin_generatevpnclientpackage(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      response = begin_generatevpnclientpackage_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Generates VPN client package for P2S client of the virtual network gateway in
    # the specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VpnClientParameters] Parameters supplied to the generate
    # virtual network gateway VPN client package operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_generatevpnclientpackage_with_http_info(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      begin_generatevpnclientpackage_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Generates VPN client package for P2S client of the virtual network gateway in
    # the specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VpnClientParameters] Parameters supplied to the generate
    # virtual network gateway VPN client package operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_generatevpnclientpackage_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_name is nil' if virtual_network_gateway_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VpnClientParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/generatevpnclientpackage'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualNetworkGatewayName' => virtual_network_gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              client_side_validation: true,
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'String'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Generates VPN profile for P2S client of the virtual network gateway in the
    # specified resource group. Used for IKEV2 and radius based authentication.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VpnClientParameters] Parameters supplied to the generate
    # virtual network gateway VPN client package operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [String] operation results.
    #
    def begin_generate_vpn_profile(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      response = begin_generate_vpn_profile_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Generates VPN profile for P2S client of the virtual network gateway in the
    # specified resource group. Used for IKEV2 and radius based authentication.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VpnClientParameters] Parameters supplied to the generate
    # virtual network gateway VPN client package operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_generate_vpn_profile_with_http_info(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      begin_generate_vpn_profile_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Generates VPN profile for P2S client of the virtual network gateway in the
    # specified resource group. Used for IKEV2 and radius based authentication.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VpnClientParameters] Parameters supplied to the generate
    # virtual network gateway VPN client package operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_generate_vpn_profile_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_name is nil' if virtual_network_gateway_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VpnClientParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/generatevpnprofile'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualNetworkGatewayName' => virtual_network_gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              client_side_validation: true,
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'String'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets pre-generated VPN profile for P2S client of the virtual network gateway
    # in the specified resource group. The profile needs to be generated first
    # using generateVpnProfile.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [String] operation results.
    #
    def begin_get_vpn_profile_package_url(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      response = begin_get_vpn_profile_package_url_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets pre-generated VPN profile for P2S client of the virtual network gateway
    # in the specified resource group. The profile needs to be generated first
    # using generateVpnProfile.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_get_vpn_profile_package_url_with_http_info(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      begin_get_vpn_profile_package_url_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
    end

    #
    # Gets pre-generated VPN profile for P2S client of the virtual network gateway
    # in the specified resource group. The profile needs to be generated first
    # using generateVpnProfile.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_get_vpn_profile_package_url_async(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_name is nil' if virtual_network_gateway_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getvpnprofilepackageurl'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualNetworkGatewayName' => virtual_network_gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              client_side_validation: true,
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'String'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The GetBgpPeerStatus operation retrieves the status of all BGP peers.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param peer [String] The IP address of the peer to retrieve the status of.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BgpPeerStatusListResult] operation results.
    #
    def begin_get_bgp_peer_status(resource_group_name, virtual_network_gateway_name, peer:nil, custom_headers:nil)
      response = begin_get_bgp_peer_status_async(resource_group_name, virtual_network_gateway_name, peer:peer, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # The GetBgpPeerStatus operation retrieves the status of all BGP peers.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param peer [String] The IP address of the peer to retrieve the status of.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_get_bgp_peer_status_with_http_info(resource_group_name, virtual_network_gateway_name, peer:nil, custom_headers:nil)
      begin_get_bgp_peer_status_async(resource_group_name, virtual_network_gateway_name, peer:peer, custom_headers:custom_headers).value!
    end

    #
    # The GetBgpPeerStatus operation retrieves the status of all BGP peers.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param peer [String] The IP address of the peer to retrieve the status of.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_get_bgp_peer_status_async(resource_group_name, virtual_network_gateway_name, peer:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_name is nil' if virtual_network_gateway_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getBgpPeerStatus'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualNetworkGatewayName' => virtual_network_gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'peer' => peer,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::BgpPeerStatusListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # This operation retrieves a list of routes the virtual network gateway has
    # learned, including routes learned from BGP peers.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GatewayRouteListResult] operation results.
    #
    def begin_get_learned_routes(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      response = begin_get_learned_routes_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # This operation retrieves a list of routes the virtual network gateway has
    # learned, including routes learned from BGP peers.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_get_learned_routes_with_http_info(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      begin_get_learned_routes_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
    end

    #
    # This operation retrieves a list of routes the virtual network gateway has
    # learned, including routes learned from BGP peers.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_get_learned_routes_async(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_name is nil' if virtual_network_gateway_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getLearnedRoutes'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualNetworkGatewayName' => virtual_network_gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::GatewayRouteListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # This operation retrieves a list of routes the virtual network gateway is
    # advertising to the specified peer.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param peer [String] The IP address of the peer.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GatewayRouteListResult] operation results.
    #
    def begin_get_advertised_routes(resource_group_name, virtual_network_gateway_name, peer, custom_headers:nil)
      response = begin_get_advertised_routes_async(resource_group_name, virtual_network_gateway_name, peer, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # This operation retrieves a list of routes the virtual network gateway is
    # advertising to the specified peer.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param peer [String] The IP address of the peer.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_get_advertised_routes_with_http_info(resource_group_name, virtual_network_gateway_name, peer, custom_headers:nil)
      begin_get_advertised_routes_async(resource_group_name, virtual_network_gateway_name, peer, custom_headers:custom_headers).value!
    end

    #
    # This operation retrieves a list of routes the virtual network gateway is
    # advertising to the specified peer.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param peer [String] The IP address of the peer.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_get_advertised_routes_async(resource_group_name, virtual_network_gateway_name, peer, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_name is nil' if virtual_network_gateway_name.nil?
      fail ArgumentError, 'peer is nil' if peer.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getAdvertisedRoutes'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualNetworkGatewayName' => virtual_network_gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'peer' => peer,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::GatewayRouteListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The Set VpnclientIpsecParameters operation sets the vpnclient ipsec policy
    # for P2S client of virtual network gateway in the specified resource group
    # through Network resource provider.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param vpnclient_ipsec_params [VpnClientIPsecParameters] Parameters supplied
    # to the Begin Set vpnclient ipsec parameters of Virtual Network Gateway P2S
    # client operation through Network resource provider.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VpnClientIPsecParameters] operation results.
    #
    def begin_set_vpnclient_ipsec_parameters(resource_group_name, virtual_network_gateway_name, vpnclient_ipsec_params, custom_headers:nil)
      response = begin_set_vpnclient_ipsec_parameters_async(resource_group_name, virtual_network_gateway_name, vpnclient_ipsec_params, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # The Set VpnclientIpsecParameters operation sets the vpnclient ipsec policy
    # for P2S client of virtual network gateway in the specified resource group
    # through Network resource provider.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param vpnclient_ipsec_params [VpnClientIPsecParameters] Parameters supplied
    # to the Begin Set vpnclient ipsec parameters of Virtual Network Gateway P2S
    # client operation through Network resource provider.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_set_vpnclient_ipsec_parameters_with_http_info(resource_group_name, virtual_network_gateway_name, vpnclient_ipsec_params, custom_headers:nil)
      begin_set_vpnclient_ipsec_parameters_async(resource_group_name, virtual_network_gateway_name, vpnclient_ipsec_params, custom_headers:custom_headers).value!
    end

    #
    # The Set VpnclientIpsecParameters operation sets the vpnclient ipsec policy
    # for P2S client of virtual network gateway in the specified resource group
    # through Network resource provider.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param vpnclient_ipsec_params [VpnClientIPsecParameters] Parameters supplied
    # to the Begin Set vpnclient ipsec parameters of Virtual Network Gateway P2S
    # client operation through Network resource provider.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_set_vpnclient_ipsec_parameters_async(resource_group_name, virtual_network_gateway_name, vpnclient_ipsec_params, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_name is nil' if virtual_network_gateway_name.nil?
      fail ArgumentError, 'vpnclient_ipsec_params is nil' if vpnclient_ipsec_params.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VpnClientIPsecParameters.mapper()
      request_content = @client.serialize(request_mapper,  vpnclient_ipsec_params)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/setvpnclientipsecparameters'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualNetworkGatewayName' => virtual_network_gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VpnClientIPsecParameters.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # The Get VpnclientIpsecParameters operation retrieves information about the
    # vpnclient ipsec policy for P2S client of virtual network gateway in the
    # specified resource group through Network resource provider.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The virtual network gateway
    # name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VpnClientIPsecParameters] operation results.
    #
    def begin_get_vpnclient_ipsec_parameters(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      response = begin_get_vpnclient_ipsec_parameters_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # The Get VpnclientIpsecParameters operation retrieves information about the
    # vpnclient ipsec policy for P2S client of virtual network gateway in the
    # specified resource group through Network resource provider.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The virtual network gateway
    # name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_get_vpnclient_ipsec_parameters_with_http_info(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      begin_get_vpnclient_ipsec_parameters_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
    end

    #
    # The Get VpnclientIpsecParameters operation retrieves information about the
    # vpnclient ipsec policy for P2S client of virtual network gateway in the
    # specified resource group through Network resource provider.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The virtual network gateway
    # name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_get_vpnclient_ipsec_parameters_async(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_name is nil' if virtual_network_gateway_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getvpnclientipsecparameters'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualNetworkGatewayName' => virtual_network_gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VpnClientIPsecParameters.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Starts packet capture on virtual network gateway in the specified resource
    # group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VpnPacketCaptureStartParameters] Virtual network gateway
    # packet capture parameters supplied to start packet capture on gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [String] operation results.
    #
    def begin_start_packet_capture(resource_group_name, virtual_network_gateway_name, parameters:nil, custom_headers:nil)
      response = begin_start_packet_capture_async(resource_group_name, virtual_network_gateway_name, parameters:parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Starts packet capture on virtual network gateway in the specified resource
    # group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VpnPacketCaptureStartParameters] Virtual network gateway
    # packet capture parameters supplied to start packet capture on gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_start_packet_capture_with_http_info(resource_group_name, virtual_network_gateway_name, parameters:nil, custom_headers:nil)
      begin_start_packet_capture_async(resource_group_name, virtual_network_gateway_name, parameters:parameters, custom_headers:custom_headers).value!
    end

    #
    # Starts packet capture on virtual network gateway in the specified resource
    # group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VpnPacketCaptureStartParameters] Virtual network gateway
    # packet capture parameters supplied to start packet capture on gateway.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_start_packet_capture_async(resource_group_name, virtual_network_gateway_name, parameters:nil, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_name is nil' if virtual_network_gateway_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VpnPacketCaptureStartParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/startPacketCapture'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualNetworkGatewayName' => virtual_network_gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              client_side_validation: true,
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'String'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Stops packet capture on virtual network gateway in the specified resource
    # group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VpnPacketCaptureStopParameters] Virtual network gateway
    # packet capture parameters supplied to stop packet capture on gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [String] operation results.
    #
    def begin_stop_packet_capture(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      response = begin_stop_packet_capture_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Stops packet capture on virtual network gateway in the specified resource
    # group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VpnPacketCaptureStopParameters] Virtual network gateway
    # packet capture parameters supplied to stop packet capture on gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_stop_packet_capture_with_http_info(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      begin_stop_packet_capture_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Stops packet capture on virtual network gateway in the specified resource
    # group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param parameters [VpnPacketCaptureStopParameters] Virtual network gateway
    # packet capture parameters supplied to stop packet capture on gateway.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_stop_packet_capture_async(resource_group_name, virtual_network_gateway_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_name is nil' if virtual_network_gateway_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VpnPacketCaptureStopParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/stopPacketCapture'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualNetworkGatewayName' => virtual_network_gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              client_side_validation: true,
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'String'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get VPN client connection health detail per P2S client connection of the
    # virtual network gateway in the specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VpnClientConnectionHealthDetailListResult] operation results.
    #
    def begin_get_vpnclient_connection_health(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      response = begin_get_vpnclient_connection_health_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get VPN client connection health detail per P2S client connection of the
    # virtual network gateway in the specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_get_vpnclient_connection_health_with_http_info(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      begin_get_vpnclient_connection_health_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
    end

    #
    # Get VPN client connection health detail per P2S client connection of the
    # virtual network gateway in the specified resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_get_vpnclient_connection_health_async(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_name is nil' if virtual_network_gateway_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getVpnClientConnectionHealth'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'virtualNetworkGatewayName' => virtual_network_gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VpnClientConnectionHealthDetailListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Disconnect vpn connections of virtual network gateway in the specified
    # resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param request [P2SVpnConnectionRequest] The parameters are supplied to
    # disconnect vpn connections.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_disconnect_virtual_network_gateway_vpn_connections(resource_group_name, virtual_network_gateway_name, request, custom_headers:nil)
      response = begin_disconnect_virtual_network_gateway_vpn_connections_async(resource_group_name, virtual_network_gateway_name, request, custom_headers:custom_headers).value!
      nil
    end

    #
    # Disconnect vpn connections of virtual network gateway in the specified
    # resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param request [P2SVpnConnectionRequest] The parameters are supplied to
    # disconnect vpn connections.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_disconnect_virtual_network_gateway_vpn_connections_with_http_info(resource_group_name, virtual_network_gateway_name, request, custom_headers:nil)
      begin_disconnect_virtual_network_gateway_vpn_connections_async(resource_group_name, virtual_network_gateway_name, request, custom_headers:custom_headers).value!
    end

    #
    # Disconnect vpn connections of virtual network gateway in the specified
    # resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param request [P2SVpnConnectionRequest] The parameters are supplied to
    # disconnect vpn connections.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_disconnect_virtual_network_gateway_vpn_connections_async(resource_group_name, virtual_network_gateway_name, request, custom_headers:nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'virtual_network_gateway_name is nil' if virtual_network_gateway_name.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2019_12_01::Models::P2SVpnConnectionRequest.mapper()
      request_content = @client.serialize(request_mapper,  request)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/disconnectVirtualNetworkGatewayVpnConnections'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'virtualNetworkGatewayName' => virtual_network_gateway_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets all virtual network gateways by resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualNetworkGatewayListResult] operation results.
    #
    def list_next(next_page_link, custom_headers:nil)
      response = list_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets all virtual network gateways by resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers:nil)
      list_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Gets all virtual network gateways by resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VirtualNetworkGatewayListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all the connections in a virtual network gateway.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualNetworkGatewayListConnectionsResult] operation results.
    #
    def list_connections_next(next_page_link, custom_headers:nil)
      response = list_connections_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets all the connections in a virtual network gateway.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_connections_next_with_http_info(next_page_link, custom_headers:nil)
      list_connections_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Gets all the connections in a virtual network gateway.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_connections_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2019_12_01::Models::VirtualNetworkGatewayListConnectionsResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all virtual network gateways by resource group.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualNetworkGatewayListResult] which provide lazy access to pages
    # of the response.
    #
    def list_as_lazy(resource_group_name, custom_headers:nil)
      response = list_async(resource_group_name, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

    #
    # Gets all the connections in a virtual network gateway.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param virtual_network_gateway_name [String] The name of the virtual network
    # gateway.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VirtualNetworkGatewayListConnectionsResult] which provide lazy
    # access to pages of the response.
    #
    def list_connections_as_lazy(resource_group_name, virtual_network_gateway_name, custom_headers:nil)
      response = list_connections_async(resource_group_name, virtual_network_gateway_name, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_connections_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

  end
end
