# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Network::Mgmt::V2020_06_01
  #
  # ConnectionMonitors
  #
  class ConnectionMonitors
    include MsRestAzure

    #
    # Creates and initializes a new instance of the ConnectionMonitors class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [NetworkManagementClient] reference to the NetworkManagementClient
    attr_reader :client

    #
    # Create or update a connection monitor.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param parameters [ConnectionMonitor] Parameters that define the operation to
    # create a connection monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectionMonitorResult] operation results.
    #
    def create_or_update(resource_group_name, network_watcher_name, connection_monitor_name, parameters, custom_headers:nil)
      response = create_or_update_async(resource_group_name, network_watcher_name, connection_monitor_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param parameters [ConnectionMonitor] Parameters that define the operation to
    # create a connection monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_async(resource_group_name, network_watcher_name, connection_monitor_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_create_or_update_async(resource_group_name, network_watcher_name, connection_monitor_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2020_06_01::Models::ConnectionMonitorResult.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets a connection monitor by name.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectionMonitorResult] operation results.
    #
    def get(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      response = get_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a connection monitor by name.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      get_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:custom_headers).value!
    end

    #
    # Gets a connection monitor by name.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'connection_monitor_name is nil' if connection_monitor_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'connectionMonitorName' => connection_monitor_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_06_01::Models::ConnectionMonitorResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes the specified connection monitor.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      response = delete_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      # Send request
      promise = begin_delete_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Update tags of the specified connection monitor.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param parameters [TagsObject] Parameters supplied to update connection
    # monitor tags.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectionMonitorResult] operation results.
    #
    def update_tags(resource_group_name, network_watcher_name, connection_monitor_name, parameters, custom_headers:nil)
      response = update_tags_async(resource_group_name, network_watcher_name, connection_monitor_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update tags of the specified connection monitor.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param parameters [TagsObject] Parameters supplied to update connection
    # monitor tags.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_tags_with_http_info(resource_group_name, network_watcher_name, connection_monitor_name, parameters, custom_headers:nil)
      update_tags_async(resource_group_name, network_watcher_name, connection_monitor_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Update tags of the specified connection monitor.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_watcher_name [String] The name of the network watcher.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param parameters [TagsObject] Parameters supplied to update connection
    # monitor tags.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_tags_async(resource_group_name, network_watcher_name, connection_monitor_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'connection_monitor_name is nil' if connection_monitor_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2020_06_01::Models::TagsObject.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'connectionMonitorName' => connection_monitor_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_06_01::Models::ConnectionMonitorResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Stops the specified connection monitor.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def stop(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      response = stop_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def stop_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      # Send request
      promise = begin_stop_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Starts the specified connection monitor.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def start(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      response = start_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def start_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      # Send request
      promise = begin_start_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Query a snapshot of the most recent connection states.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name given to the connection
    # monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectionMonitorQueryResult] operation results.
    #
    def query(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      response = query_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name given to the connection
    # monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def query_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      # Send request
      promise = begin_query_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2020_06_01::Models::ConnectionMonitorQueryResult.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method, FinalStateVia::LOCATION)
      end

      promise
    end

    #
    # Lists all connection monitors for the specified Network Watcher.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectionMonitorListResult] operation results.
    #
    def list(resource_group_name, network_watcher_name, custom_headers:nil)
      response = list_async(resource_group_name, network_watcher_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists all connection monitors for the specified Network Watcher.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(resource_group_name, network_watcher_name, custom_headers:nil)
      list_async(resource_group_name, network_watcher_name, custom_headers:custom_headers).value!
    end

    #
    # Lists all connection monitors for the specified Network Watcher.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(resource_group_name, network_watcher_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_06_01::Models::ConnectionMonitorListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create or update a connection monitor.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param parameters [ConnectionMonitor] Parameters that define the operation to
    # create a connection monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectionMonitorResult] operation results.
    #
    def begin_create_or_update(resource_group_name, network_watcher_name, connection_monitor_name, parameters, custom_headers:nil)
      response = begin_create_or_update_async(resource_group_name, network_watcher_name, connection_monitor_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create or update a connection monitor.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param parameters [ConnectionMonitor] Parameters that define the operation to
    # create a connection monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_with_http_info(resource_group_name, network_watcher_name, connection_monitor_name, parameters, custom_headers:nil)
      begin_create_or_update_async(resource_group_name, network_watcher_name, connection_monitor_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Create or update a connection monitor.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param parameters [ConnectionMonitor] Parameters that define the operation to
    # create a connection monitor.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_async(resource_group_name, network_watcher_name, connection_monitor_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'connection_monitor_name is nil' if connection_monitor_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2020_06_01::Models::ConnectionMonitor.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'connectionMonitorName' => connection_monitor_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_06_01::Models::ConnectionMonitorResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_06_01::Models::ConnectionMonitorResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes the specified connection monitor.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      response = begin_delete_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # Deletes the specified connection monitor.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      begin_delete_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:custom_headers).value!
    end

    #
    # Deletes the specified connection monitor.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'connection_monitor_name is nil' if connection_monitor_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'connectionMonitorName' => connection_monitor_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Stops the specified connection monitor.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_stop(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      response = begin_stop_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # Stops the specified connection monitor.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_stop_with_http_info(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      begin_stop_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:custom_headers).value!
    end

    #
    # Stops the specified connection monitor.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_stop_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'connection_monitor_name is nil' if connection_monitor_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}/stop'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'connectionMonitorName' => connection_monitor_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Starts the specified connection monitor.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_start(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      response = begin_start_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # Starts the specified connection monitor.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_start_with_http_info(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      begin_start_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:custom_headers).value!
    end

    #
    # Starts the specified connection monitor.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name of the connection monitor.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_start_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'connection_monitor_name is nil' if connection_monitor_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}/start'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'connectionMonitorName' => connection_monitor_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Query a snapshot of the most recent connection states.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name given to the connection
    # monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectionMonitorQueryResult] operation results.
    #
    def begin_query(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      response = begin_query_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Query a snapshot of the most recent connection states.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name given to the connection
    # monitor.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_query_with_http_info(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      begin_query_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:custom_headers).value!
    end

    #
    # Query a snapshot of the most recent connection states.
    #
    # @param resource_group_name [String] The name of the resource group containing
    # Network Watcher.
    # @param network_watcher_name [String] The name of the Network Watcher
    # resource.
    # @param connection_monitor_name [String] The name given to the connection
    # monitor.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_query_async(resource_group_name, network_watcher_name, connection_monitor_name, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_watcher_name is nil' if network_watcher_name.nil?
      fail ArgumentError, 'connection_monitor_name is nil' if connection_monitor_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}/query'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkWatcherName' => network_watcher_name,'connectionMonitorName' => connection_monitor_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRest::HttpOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_06_01::Models::ConnectionMonitorQueryResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_06_01::Models::ConnectionMonitorQueryResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
