# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Network::Mgmt::V2020_07_01
  #
  # InboundSecurityRuleOperations
  #
  class InboundSecurityRuleOperations
    include MsRestAzure

    #
    # Creates and initializes a new instance of the InboundSecurityRuleOperations class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [NetworkManagementClient] reference to the NetworkManagementClient
    attr_reader :client

    #
    # Creates or updates the specified Network Virtual Appliance Inbound Security
    # Rules.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_virtual_appliance_name [String] The name of the Network
    # Virtual Appliance.
    # @param rule_collection_name [String] The name of security rule collection.
    # @param parameters [InboundSecurityRule] Parameters supplied to the create or
    # update Network Virtual Appliance Inbound Security Rules operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [InboundSecurityRule] operation results.
    #
    def create_or_update(resource_group_name, network_virtual_appliance_name, rule_collection_name, parameters, custom_headers:nil)
      response = create_or_update_async(resource_group_name, network_virtual_appliance_name, rule_collection_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_virtual_appliance_name [String] The name of the Network
    # Virtual Appliance.
    # @param rule_collection_name [String] The name of security rule collection.
    # @param parameters [InboundSecurityRule] Parameters supplied to the create or
    # update Network Virtual Appliance Inbound Security Rules operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_async(resource_group_name, network_virtual_appliance_name, rule_collection_name, parameters, custom_headers:nil)
      # Send request
      promise = begin_create_or_update_async(resource_group_name, network_virtual_appliance_name, rule_collection_name, parameters, custom_headers:custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::Network::Mgmt::V2020_07_01::Models::InboundSecurityRule.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Creates or updates the specified Network Virtual Appliance Inbound Security
    # Rules.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_virtual_appliance_name [String] The name of the Network
    # Virtual Appliance.
    # @param rule_collection_name [String] The name of security rule collection.
    # @param parameters [InboundSecurityRule] Parameters supplied to the create or
    # update Network Virtual Appliance Inbound Security Rules operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [InboundSecurityRule] operation results.
    #
    def begin_create_or_update(resource_group_name, network_virtual_appliance_name, rule_collection_name, parameters, custom_headers:nil)
      response = begin_create_or_update_async(resource_group_name, network_virtual_appliance_name, rule_collection_name, parameters, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates or updates the specified Network Virtual Appliance Inbound Security
    # Rules.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_virtual_appliance_name [String] The name of the Network
    # Virtual Appliance.
    # @param rule_collection_name [String] The name of security rule collection.
    # @param parameters [InboundSecurityRule] Parameters supplied to the create or
    # update Network Virtual Appliance Inbound Security Rules operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_with_http_info(resource_group_name, network_virtual_appliance_name, rule_collection_name, parameters, custom_headers:nil)
      begin_create_or_update_async(resource_group_name, network_virtual_appliance_name, rule_collection_name, parameters, custom_headers:custom_headers).value!
    end

    #
    # Creates or updates the specified Network Virtual Appliance Inbound Security
    # Rules.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param network_virtual_appliance_name [String] The name of the Network
    # Virtual Appliance.
    # @param rule_collection_name [String] The name of security rule collection.
    # @param parameters [InboundSecurityRule] Parameters supplied to the create or
    # update Network Virtual Appliance Inbound Security Rules operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_async(resource_group_name, network_virtual_appliance_name, rule_collection_name, parameters, custom_headers:nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'network_virtual_appliance_name is nil' if network_virtual_appliance_name.nil?
      fail ArgumentError, 'rule_collection_name is nil' if rule_collection_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Network::Mgmt::V2020_07_01::Models::InboundSecurityRule.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkVirtualAppliances/{networkVirtualApplianceName}/inboundSecurityRules/{ruleCollectionName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'networkVirtualApplianceName' => network_virtual_appliance_name,'ruleCollectionName' => rule_collection_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_07_01::Models::InboundSecurityRule.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Network::Mgmt::V2020_07_01::Models::InboundSecurityRule.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
