# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Network::Mgmt::V2020_08_01
  module Models
    #
    # VpnGatewayNatRule Resource.
    #
    class VpnGatewayNatRule < SubResource

      include MsRestAzure

      # @return [ProvisioningState] The provisioning state of the NAT Rule
      # resource. Possible values include: 'Succeeded', 'Updating', 'Deleting',
      # 'Failed'
      attr_accessor :provisioning_state

      # @return [VpnNatRuleType] The type of NAT rule for VPN NAT. Possible
      # values include: 'Static', 'Dynamic'
      attr_accessor :vpn_gateway_nat_rule_properties_type

      # @return [VpnNatRuleMode] The Source NAT direction of a VPN NAT.
      # Possible values include: 'EgressSnat', 'IngressSnat'
      attr_accessor :mode

      # @return [Array<VpnNatRuleMapping>] The private IP address internal
      # mapping for NAT.
      attr_accessor :internal_mappings

      # @return [Array<VpnNatRuleMapping>] The private IP address external
      # mapping for NAT.
      attr_accessor :external_mappings

      # @return [String] The IP Configuration ID this NAT rule applies to.
      attr_accessor :ip_configuration_id

      # @return [Array<SubResource>] List of egress VpnSiteLinkConnections.
      attr_accessor :egress_vpn_site_link_connections

      # @return [Array<SubResource>] List of ingress VpnSiteLinkConnections.
      attr_accessor :ingress_vpn_site_link_connections

      # @return [String] The name of the resource that is unique within a
      # resource group. This name can be used to access the resource.
      attr_accessor :name

      # @return [String] A unique read-only string that changes whenever the
      # resource is updated.
      attr_accessor :etag

      # @return [String] Resource type.
      attr_accessor :type


      #
      # Mapper for VpnGatewayNatRule class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'VpnGatewayNatRule',
          type: {
            name: 'Composite',
            class_name: 'VpnGatewayNatRule',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              provisioning_state: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.provisioningState',
                type: {
                  name: 'String'
                }
              },
              vpn_gateway_nat_rule_properties_type: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.type',
                type: {
                  name: 'String'
                }
              },
              mode: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.mode',
                type: {
                  name: 'String'
                }
              },
              internal_mappings: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.internalMappings',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'VpnNatRuleMappingElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'VpnNatRuleMapping'
                      }
                  }
                }
              },
              external_mappings: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.externalMappings',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'VpnNatRuleMappingElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'VpnNatRuleMapping'
                      }
                  }
                }
              },
              ip_configuration_id: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.ipConfigurationId',
                type: {
                  name: 'String'
                }
              },
              egress_vpn_site_link_connections: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.egressVpnSiteLinkConnections',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'SubResourceElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'SubResource'
                      }
                  }
                }
              },
              ingress_vpn_site_link_connections: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.ingressVpnSiteLinkConnections',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'SubResourceElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'SubResource'
                      }
                  }
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              etag: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'etag',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
