# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Network2::Mgmt::V2016_09_01
  module Models
    #
    # A load balancer probe.
    #
    class Probe < SubResource

      include MsRestAzure2

      # @return [Array<SubResource>] The load balancer rules that use this
      # probe.
      attr_accessor :load_balancing_rules

      # @return [ProbeProtocol] The protocol of the end point. Possible values
      # are: 'Http' or 'Tcp'. If 'Tcp' is specified, a received ACK is required
      # for the probe to be successful. If 'Http' is specified, a 200 OK
      # response from the specifies URI is required for the probe to be
      # successful. Possible values include: 'Http', 'Tcp'
      attr_accessor :protocol

      # @return [Integer] The port for communicating the probe. Possible values
      # range from 1 to 65535, inclusive.
      attr_accessor :port

      # @return [Integer] The interval, in seconds, for how frequently to probe
      # the endpoint for health status. Typically, the interval is slightly
      # less than half the allocated timeout period (in seconds) which allows
      # two full probes before taking the instance out of rotation. The default
      # value is 15, the minimum value is 5.
      attr_accessor :interval_in_seconds

      # @return [Integer] The number of probes where if no response, will
      # result in stopping further traffic from being delivered to the
      # endpoint. This values allows endpoints to be taken out of rotation
      # faster or slower than the typical times used in Azure.
      attr_accessor :number_of_probes

      # @return [String] The URI used for requesting health status from the VM.
      # Path is required if a protocol is set to http. Otherwise, it is not
      # allowed. There is no default value.
      attr_accessor :request_path

      # @return [String] Gets the provisioning state of the public IP resource.
      # Possible values are: 'Updating', 'Deleting', and 'Failed'.
      attr_accessor :provisioning_state

      # @return [String] Gets name of the resource that is unique within a
      # resource group. This name can be used to access the resource.
      attr_accessor :name

      # @return [String] A unique read-only string that changes whenever the
      # resource is updated.
      attr_accessor :etag


      #
      # Mapper for Probe class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'Probe',
          type: {
            name: 'Composite',
            class_name: 'Probe',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              load_balancing_rules: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.loadBalancingRules',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'SubResourceElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'SubResource'
                      }
                  }
                }
              },
              protocol: {
                client_side_validation: true,
                required: true,
                serialized_name: 'properties.protocol',
                type: {
                  name: 'String'
                }
              },
              port: {
                client_side_validation: true,
                required: true,
                serialized_name: 'properties.port',
                type: {
                  name: 'Number'
                }
              },
              interval_in_seconds: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.intervalInSeconds',
                type: {
                  name: 'Number'
                }
              },
              number_of_probes: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.numberOfProbes',
                type: {
                  name: 'Number'
                }
              },
              request_path: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.requestPath',
                type: {
                  name: 'String'
                }
              },
              provisioning_state: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.provisioningState',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              etag: {
                client_side_validation: true,
                required: false,
                serialized_name: 'etag',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
