# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Network2::Mgmt::V2020_04_01
  module Models
    #
    # IpAllocation resource.
    #
    class IpAllocation < Resource

      include MsRestAzure2

      # @return [SubResource] The Subnet that using the prefix of this
      # IpAllocation resource.
      attr_accessor :subnet

      # @return [SubResource] The VirtualNetwork that using the prefix of this
      # IpAllocation resource.
      attr_accessor :virtual_network

      # @return [IpAllocationType] The type for the IpAllocation. Possible
      # values include: 'Undefined', 'Hypernet'
      attr_accessor :ip_allocation_type

      # @return [String] The address prefix for the IpAllocation.
      attr_accessor :prefix

      # @return [Integer] The address prefix length for the IpAllocation.
      # Default value: 0 .
      attr_accessor :prefix_length

      # @return [IPVersion] The address prefix Type for the IpAllocation.
      # Possible values include: 'IPv4', 'IPv6'
      attr_accessor :prefix_type

      # @return [String] The IPAM allocation ID.
      attr_accessor :ipam_allocation_id

      # @return [Hash{String => String}] IpAllocation tags.
      attr_accessor :allocation_tags

      # @return [String] A unique read-only string that changes whenever the
      # resource is updated.
      attr_accessor :etag


      #
      # Mapper for IpAllocation class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'IpAllocation',
          type: {
            name: 'Composite',
            class_name: 'IpAllocation',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              location: {
                client_side_validation: true,
                required: false,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              tags: {
                client_side_validation: true,
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              subnet: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.subnet',
                type: {
                  name: 'Composite',
                  class_name: 'SubResource'
                }
              },
              virtual_network: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.virtualNetwork',
                type: {
                  name: 'Composite',
                  class_name: 'SubResource'
                }
              },
              ip_allocation_type: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.type',
                type: {
                  name: 'String'
                }
              },
              prefix: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.prefix',
                type: {
                  name: 'String'
                }
              },
              prefix_length: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.prefixLength',
                default_value: 0,
                type: {
                  name: 'Number'
                }
              },
              prefix_type: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.prefixType',
                type: {
                  name: 'String'
                }
              },
              ipam_allocation_id: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.ipamAllocationId',
                type: {
                  name: 'String'
                }
              },
              allocation_tags: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.allocationTags',
                type: {
                  name: 'Dictionary',
                  value: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              etag: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'etag',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
