# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Network2::Mgmt::V2020_04_01
  module Models
    #
    # NetworkVirtualAppliance Resource.
    #
    class NetworkVirtualAppliance < Resource

      include MsRestAzure2

      # @return [Array<String>] BootStrapConfigurationBlob storage URLs.
      attr_accessor :boot_strap_configuration_blob

      # @return [SubResource] The Virtual Hub where Network Virtual Appliance
      # is being deployed.
      attr_accessor :virtual_hub

      # @return [Array<String>] CloudInitConfigurationBlob storage URLs.
      attr_accessor :cloud_init_configuration_blob

      # @return [Integer] VirtualAppliance ASN.
      attr_accessor :virtual_appliance_asn

      # @return [Array<VirtualApplianceNicProperties>] List of Virtual
      # Appliance Network Interfaces.
      attr_accessor :virtual_appliance_nics

      # @return [ProvisioningState] The provisioning state of the resource.
      # Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
      attr_accessor :provisioning_state

      # @return [ManagedServiceIdentity] The service principal that has read
      # access to cloud-init and config blob.
      attr_accessor :identity

      # @return [VirtualApplianceSkuProperties] Network Virtual Appliance SKU.
      attr_accessor :sku

      # @return [String] A unique read-only string that changes whenever the
      # resource is updated.
      attr_accessor :etag


      #
      # Mapper for NetworkVirtualAppliance class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'NetworkVirtualAppliance',
          type: {
            name: 'Composite',
            class_name: 'NetworkVirtualAppliance',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              location: {
                client_side_validation: true,
                required: false,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              tags: {
                client_side_validation: true,
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              boot_strap_configuration_blob: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.bootStrapConfigurationBlob',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              virtual_hub: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.virtualHub',
                type: {
                  name: 'Composite',
                  class_name: 'SubResource'
                }
              },
              cloud_init_configuration_blob: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.cloudInitConfigurationBlob',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              virtual_appliance_asn: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.virtualApplianceAsn',
                constraints: {
                  InclusiveMaximum: 4294967295,
                  InclusiveMinimum: 0
                },
                type: {
                  name: 'Number'
                }
              },
              virtual_appliance_nics: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.virtualApplianceNics',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'VirtualApplianceNicPropertiesElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'VirtualApplianceNicProperties'
                      }
                  }
                }
              },
              provisioning_state: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.provisioningState',
                type: {
                  name: 'String'
                }
              },
              identity: {
                client_side_validation: true,
                required: false,
                serialized_name: 'identity',
                type: {
                  name: 'Composite',
                  class_name: 'ManagedServiceIdentity'
                }
              },
              sku: {
                client_side_validation: true,
                required: false,
                serialized_name: 'sku',
                type: {
                  name: 'Composite',
                  class_name: 'VirtualApplianceSkuProperties'
                }
              },
              etag: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'etag',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
