# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Network2::Mgmt::V2020_06_01
  module Models
    #
    # NetworkVirtualAppliance Resource.
    #
    class NetworkVirtualAppliance < Resource

      include MsRestAzure2

      # @return [VirtualApplianceSkuProperties] Network Virtual Appliance SKU.
      attr_accessor :nva_sku

      # @return [String] Address Prefix.
      attr_accessor :address_prefix

      # @return [Array<String>] BootStrapConfigurationBlobs storage URLs.
      attr_accessor :boot_strap_configuration_blobs

      # @return [SubResource] The Virtual Hub where Network Virtual Appliance
      # is being deployed.
      attr_accessor :virtual_hub

      # @return [Array<String>] CloudInitConfigurationBlob storage URLs.
      attr_accessor :cloud_init_configuration_blobs

      # @return [String] CloudInitConfiguration string in plain text.
      attr_accessor :cloud_init_configuration

      # @return [Integer] VirtualAppliance ASN.
      attr_accessor :virtual_appliance_asn

      # @return [Array<VirtualApplianceNicProperties>] List of Virtual
      # Appliance Network Interfaces.
      attr_accessor :virtual_appliance_nics

      # @return [Array<SubResource>] List of references to
      # VirtualApplianceSite.
      attr_accessor :virtual_appliance_sites

      # @return [Array<SubResource>] List of references to
      # InboundSecurityRules.
      attr_accessor :inbound_security_rules

      # @return [ProvisioningState] The provisioning state of the resource.
      # Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
      attr_accessor :provisioning_state

      # @return [ManagedServiceIdentity] The service principal that has read
      # access to cloud-init and config blob.
      attr_accessor :identity

      # @return [String] A unique read-only string that changes whenever the
      # resource is updated.
      attr_accessor :etag


      #
      # Mapper for NetworkVirtualAppliance class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'NetworkVirtualAppliance',
          type: {
            name: 'Composite',
            class_name: 'NetworkVirtualAppliance',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              location: {
                client_side_validation: true,
                required: false,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              tags: {
                client_side_validation: true,
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              nva_sku: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.nvaSku',
                type: {
                  name: 'Composite',
                  class_name: 'VirtualApplianceSkuProperties'
                }
              },
              address_prefix: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.addressPrefix',
                type: {
                  name: 'String'
                }
              },
              boot_strap_configuration_blobs: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.bootStrapConfigurationBlobs',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              virtual_hub: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.virtualHub',
                type: {
                  name: 'Composite',
                  class_name: 'SubResource'
                }
              },
              cloud_init_configuration_blobs: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.cloudInitConfigurationBlobs',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              cloud_init_configuration: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.cloudInitConfiguration',
                type: {
                  name: 'String'
                }
              },
              virtual_appliance_asn: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.virtualApplianceAsn',
                constraints: {
                  InclusiveMaximum: 4294967295,
                  InclusiveMinimum: 0
                },
                type: {
                  name: 'Number'
                }
              },
              virtual_appliance_nics: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.virtualApplianceNics',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'VirtualApplianceNicPropertiesElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'VirtualApplianceNicProperties'
                      }
                  }
                }
              },
              virtual_appliance_sites: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.virtualApplianceSites',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'SubResourceElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'SubResource'
                      }
                  }
                }
              },
              inbound_security_rules: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.inboundSecurityRules',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'SubResourceElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'SubResource'
                      }
                  }
                }
              },
              provisioning_state: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.provisioningState',
                type: {
                  name: 'String'
                }
              },
              identity: {
                client_side_validation: true,
                required: false,
                serialized_name: 'identity',
                type: {
                  name: 'Composite',
                  class_name: 'ManagedServiceIdentity'
                }
              },
              etag: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'etag',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
