# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Resources::Mgmt::V2020_06_01
  module Models
    #
    # Information about a single resource change predicted by What-If
    # operation.
    #
    class WhatIfChange

      include MsRestAzure

      # @return [String] Resource ID
      attr_accessor :resource_id

      # @return [ChangeType] Type of change that will be made to the resource
      # when the deployment is executed. Possible values include: 'Create',
      # 'Delete', 'Ignore', 'Deploy', 'NoChange', 'Modify'
      attr_accessor :change_type

      # @return The snapshot of the resource before the deployment is executed.
      attr_accessor :before

      # @return The predicted snapshot of the resource after the deployment is
      # executed.
      attr_accessor :after

      # @return [Array<WhatIfPropertyChange>] The predicted changes to resource
      # properties.
      attr_accessor :delta


      #
      # Mapper for WhatIfChange class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'WhatIfChange',
          type: {
            name: 'Composite',
            class_name: 'WhatIfChange',
            model_properties: {
              resource_id: {
                client_side_validation: true,
                required: true,
                serialized_name: 'resourceId',
                type: {
                  name: 'String'
                }
              },
              change_type: {
                client_side_validation: true,
                required: true,
                serialized_name: 'changeType',
                type: {
                  name: 'Enum',
                  module: 'ChangeType'
                }
              },
              before: {
                client_side_validation: true,
                required: false,
                serialized_name: 'before',
                type: {
                  name: 'Object'
                }
              },
              after: {
                client_side_validation: true,
                required: false,
                serialized_name: 'after',
                type: {
                  name: 'Object'
                }
              },
              delta: {
                client_side_validation: true,
                required: false,
                serialized_name: 'delta',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'WhatIfPropertyChangeElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'WhatIfPropertyChange'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
