# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2015_06_01_preview
  module Models
    #
    # Model object.
    #
    #
    class JitNetworkAccessRequestPort

      include MsRestAzure

      # @return [Integer]
      attr_accessor :number

      # @return [String] Mutually exclusive with the
      # "allowedSourceAddressPrefixes" parameter. Should be an IP address or
      # CIDR, for example "192.168.0.3" or "192.168.0.0/16".
      attr_accessor :allowed_source_address_prefix

      # @return [Array<String>] Mutually exclusive with the
      # "allowedSourceAddressPrefix" parameter.
      attr_accessor :allowed_source_address_prefixes

      # @return [DateTime] The date & time at which the request ends in UTC
      attr_accessor :end_time_utc

      # @return [Status] The status of the port. Possible values include:
      # 'Revoked', 'Initiated'
      attr_accessor :status

      # @return [StatusReason] A description of why the `status` has its value.
      # Possible values include: 'Expired', 'UserRequested',
      # 'NewerRequestInitiated'
      attr_accessor :status_reason

      # @return [Integer] The port which is mapped to this port's `number` in
      # the Azure Firewall, if applicable
      attr_accessor :mapped_port


      #
      # Mapper for JitNetworkAccessRequestPort class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'JitNetworkAccessRequestPort',
          type: {
            name: 'Composite',
            class_name: 'JitNetworkAccessRequestPort',
            model_properties: {
              number: {
                client_side_validation: true,
                required: true,
                serialized_name: 'number',
                type: {
                  name: 'Number'
                }
              },
              allowed_source_address_prefix: {
                client_side_validation: true,
                required: false,
                serialized_name: 'allowedSourceAddressPrefix',
                type: {
                  name: 'String'
                }
              },
              allowed_source_address_prefixes: {
                client_side_validation: true,
                required: false,
                serialized_name: 'allowedSourceAddressPrefixes',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              end_time_utc: {
                client_side_validation: true,
                required: true,
                serialized_name: 'endTimeUtc',
                type: {
                  name: 'DateTime'
                }
              },
              status: {
                client_side_validation: true,
                required: true,
                serialized_name: 'status',
                type: {
                  name: 'String'
                }
              },
              status_reason: {
                client_side_validation: true,
                required: true,
                serialized_name: 'statusReason',
                type: {
                  name: 'String'
                }
              },
              mapped_port: {
                client_side_validation: true,
                required: false,
                serialized_name: 'mappedPort',
                type: {
                  name: 'Number'
                }
              }
            }
          }
        }
      end
    end
  end
end
