# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2017_08_01_preview
  #
  # API spec for Microsoft.Security (Azure Security Center) resource provider
  #
  class InformationProtectionPolicies
    include MsRestAzure

    #
    # Creates and initializes a new instance of the InformationProtectionPolicies class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [SecurityCenter] reference to the SecurityCenter
    attr_reader :client

    #
    # Details of the information protection policy.
    #
    # @param scope [String] Scope of the query, can be subscription
    # (/subscriptions/0b06d9ea-afe6-4779-bd59-30e5c2d9d13f) or management group
    # (/providers/Microsoft.Management/managementGroups/mgName).
    # @param information_protection_policy_name [Enum] Name of the information
    # protection policy. Possible values include: 'effective', 'custom'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [InformationProtectionPolicy] operation results.
    #
    def get(scope, information_protection_policy_name, custom_headers:nil)
      response = get_async(scope, information_protection_policy_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Details of the information protection policy.
    #
    # @param scope [String] Scope of the query, can be subscription
    # (/subscriptions/0b06d9ea-afe6-4779-bd59-30e5c2d9d13f) or management group
    # (/providers/Microsoft.Management/managementGroups/mgName).
    # @param information_protection_policy_name [Enum] Name of the information
    # protection policy. Possible values include: 'effective', 'custom'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(scope, information_protection_policy_name, custom_headers:nil)
      get_async(scope, information_protection_policy_name, custom_headers:custom_headers).value!
    end

    #
    # Details of the information protection policy.
    #
    # @param scope [String] Scope of the query, can be subscription
    # (/subscriptions/0b06d9ea-afe6-4779-bd59-30e5c2d9d13f) or management group
    # (/providers/Microsoft.Management/managementGroups/mgName).
    # @param information_protection_policy_name [Enum] Name of the information
    # protection policy. Possible values include: 'effective', 'custom'
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(scope, information_protection_policy_name, custom_headers:nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'scope is nil' if scope.nil?
      fail ArgumentError, 'information_protection_policy_name is nil' if information_protection_policy_name.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{scope}/providers/Microsoft.Security/informationProtectionPolicies/{informationProtectionPolicyName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'informationProtectionPolicyName' => information_protection_policy_name},
          skip_encoding_path_params: {'scope' => scope},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2017_08_01_preview::Models::InformationProtectionPolicy.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Details of the information protection policy.
    #
    # @param scope [String] Scope of the query, can be subscription
    # (/subscriptions/0b06d9ea-afe6-4779-bd59-30e5c2d9d13f) or management group
    # (/providers/Microsoft.Management/managementGroups/mgName).
    # @param information_protection_policy_name [Enum] Name of the information
    # protection policy. Possible values include: 'effective', 'custom'
    # @param information_protection_policy [InformationProtectionPolicy]
    # Information protection policy.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [InformationProtectionPolicy] operation results.
    #
    def create_or_update(scope, information_protection_policy_name, information_protection_policy, custom_headers:nil)
      response = create_or_update_async(scope, information_protection_policy_name, information_protection_policy, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Details of the information protection policy.
    #
    # @param scope [String] Scope of the query, can be subscription
    # (/subscriptions/0b06d9ea-afe6-4779-bd59-30e5c2d9d13f) or management group
    # (/providers/Microsoft.Management/managementGroups/mgName).
    # @param information_protection_policy_name [Enum] Name of the information
    # protection policy. Possible values include: 'effective', 'custom'
    # @param information_protection_policy [InformationProtectionPolicy]
    # Information protection policy.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_with_http_info(scope, information_protection_policy_name, information_protection_policy, custom_headers:nil)
      create_or_update_async(scope, information_protection_policy_name, information_protection_policy, custom_headers:custom_headers).value!
    end

    #
    # Details of the information protection policy.
    #
    # @param scope [String] Scope of the query, can be subscription
    # (/subscriptions/0b06d9ea-afe6-4779-bd59-30e5c2d9d13f) or management group
    # (/providers/Microsoft.Management/managementGroups/mgName).
    # @param information_protection_policy_name [Enum] Name of the information
    # protection policy. Possible values include: 'effective', 'custom'
    # @param information_protection_policy [InformationProtectionPolicy]
    # Information protection policy.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_async(scope, information_protection_policy_name, information_protection_policy, custom_headers:nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'scope is nil' if scope.nil?
      fail ArgumentError, 'information_protection_policy_name is nil' if information_protection_policy_name.nil?
      fail ArgumentError, 'information_protection_policy is nil' if information_protection_policy.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      # Serialize Request
      request_mapper = Azure::Security::Mgmt::V2017_08_01_preview::Models::InformationProtectionPolicy.mapper()
      request_content = @client.serialize(request_mapper,  information_protection_policy)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '{scope}/providers/Microsoft.Security/informationProtectionPolicies/{informationProtectionPolicyName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'informationProtectionPolicyName' => information_protection_policy_name},
          skip_encoding_path_params: {'scope' => scope},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2017_08_01_preview::Models::InformationProtectionPolicy.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2017_08_01_preview::Models::InformationProtectionPolicy.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Information protection policies of a specific management group.
    #
    # @param scope [String] Scope of the query, can be subscription
    # (/subscriptions/0b06d9ea-afe6-4779-bd59-30e5c2d9d13f) or management group
    # (/providers/Microsoft.Management/managementGroups/mgName).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<InformationProtectionPolicy>] operation results.
    #
    def list(scope, custom_headers:nil)
      first_page = list_as_lazy(scope, custom_headers:custom_headers)
      first_page.get_all_items
    end

    #
    # Information protection policies of a specific management group.
    #
    # @param scope [String] Scope of the query, can be subscription
    # (/subscriptions/0b06d9ea-afe6-4779-bd59-30e5c2d9d13f) or management group
    # (/providers/Microsoft.Management/managementGroups/mgName).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(scope, custom_headers:nil)
      list_async(scope, custom_headers:custom_headers).value!
    end

    #
    # Information protection policies of a specific management group.
    #
    # @param scope [String] Scope of the query, can be subscription
    # (/subscriptions/0b06d9ea-afe6-4779-bd59-30e5c2d9d13f) or management group
    # (/providers/Microsoft.Management/managementGroups/mgName).
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(scope, custom_headers:nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'scope is nil' if scope.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{scope}/providers/Microsoft.Security/informationProtectionPolicies'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'scope' => scope},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2017_08_01_preview::Models::InformationProtectionPolicyList.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Information protection policies of a specific management group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [InformationProtectionPolicyList] operation results.
    #
    def list_next(next_page_link, custom_headers:nil)
      response = list_next_async(next_page_link, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Information protection policies of a specific management group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers:nil)
      list_next_async(next_page_link, custom_headers:custom_headers).value!
    end

    #
    # Information protection policies of a specific management group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers:nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2017_08_01_preview::Models::InformationProtectionPolicyList.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Information protection policies of a specific management group.
    #
    # @param scope [String] Scope of the query, can be subscription
    # (/subscriptions/0b06d9ea-afe6-4779-bd59-30e5c2d9d13f) or management group
    # (/providers/Microsoft.Management/managementGroups/mgName).
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [InformationProtectionPolicyList] which provide lazy access to pages
    # of the response.
    #
    def list_as_lazy(scope, custom_headers:nil)
      response = list_async(scope, custom_headers:custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers:custom_headers)
        end
        page
      end
    end

  end
end
