# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2017_08_01_preview
  module Models
    #
    # Security Analytics of a security solution
    #
    class IoTSecuritySolutionAnalyticsModel < Resource

      include MsRestAzure

      # @return [IoTSeverityMetrics] Security Analytics of a security solution
      attr_accessor :metrics

      # @return [Integer] number of unhealthy devices
      attr_accessor :unhealthy_device_count

      # @return
      # [Array<IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem>]
      # The list of devices metrics by the aggregated date.
      attr_accessor :devices_metrics

      # @return [IoTSecurityAlertedDevicesList] The list of top 3 devices with
      # the most attacked.
      attr_accessor :top_alerted_devices

      # @return [IoTSecurityDeviceAlertsList] The list of most prevalent 3
      # alerts.
      attr_accessor :most_prevalent_device_alerts

      # @return [IoTSecurityDeviceRecommendationsList] The list of most
      # prevalent 3 recommendations.
      attr_accessor :most_prevalent_device_recommendations


      #
      # Mapper for IoTSecuritySolutionAnalyticsModel class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'IoTSecuritySolutionAnalyticsModel',
          type: {
            name: 'Composite',
            class_name: 'IoTSecuritySolutionAnalyticsModel',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              metrics: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.metrics',
                type: {
                  name: 'Composite',
                  class_name: 'IoTSeverityMetrics'
                }
              },
              unhealthy_device_count: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.unhealthyDeviceCount',
                type: {
                  name: 'Number'
                }
              },
              devices_metrics: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.devicesMetrics',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItemElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem'
                      }
                  }
                }
              },
              top_alerted_devices: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.topAlertedDevices',
                type: {
                  name: 'Composite',
                  class_name: 'IoTSecurityAlertedDevicesList'
                }
              },
              most_prevalent_device_alerts: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.mostPrevalentDeviceAlerts',
                type: {
                  name: 'Composite',
                  class_name: 'IoTSecurityDeviceAlertsList'
                }
              },
              most_prevalent_device_recommendations: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.mostPrevalentDeviceRecommendations',
                type: {
                  name: 'Composite',
                  class_name: 'IoTSecurityDeviceRecommendationsList'
                }
              }
            }
          }
        }
      end
    end
  end
end
