# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2017_08_01_preview
  #
  # A service client - single point of access to the REST API.
  #
  class SecurityCenter < MsRestAzure::AzureServiceClient
    include MsRestAzure
    include MsRestAzure::Serialization

    # @return [String] the base URI of the service.
    attr_accessor :base_url

    # @return Credentials needed for the client to connect to Azure.
    attr_reader :credentials

    # @return [String] API version for the operation
    attr_reader :api_version

    # @return [String] Azure subscription ID
    attr_accessor :subscription_id

    # @return [String] The preferred language for the response.
    attr_accessor :accept_language

    # @return [Integer] The retry timeout in seconds for Long Running
    # Operations. Default value is 30.
    attr_accessor :long_running_operation_retry_timeout

    # @return [Boolean] Whether a unique x-ms-client-request-id should be
    # generated. When set to true a unique x-ms-client-request-id value is
    # generated and included in each request. Default is true.
    attr_accessor :generate_client_request_id

    # @return [AdvancedThreatProtection] advanced_threat_protection
    attr_reader :advanced_threat_protection

    # @return [AutoProvisioningSettings] auto_provisioning_settings
    attr_reader :auto_provisioning_settings

    # @return [Compliances] compliances
    attr_reader :compliances

    # @return [DeviceSecurityGroups] device_security_groups
    attr_reader :device_security_groups

    # @return [InformationProtectionPolicies] information_protection_policies
    attr_reader :information_protection_policies

    # @return [IoTSecuritySolutionsAnalytics] io_tsecurity_solutions_analytics
    attr_reader :io_tsecurity_solutions_analytics

    # @return [IoTSecuritySolutionsAnalyticsAggregatedAlerts]
    # io_tsecurity_solutions_analytics_aggregated_alerts
    attr_reader :io_tsecurity_solutions_analytics_aggregated_alerts

    # @return [IoTSecuritySolutionsAnalyticsAggregatedAlert]
    # io_tsecurity_solutions_analytics_aggregated_alert
    attr_reader :io_tsecurity_solutions_analytics_aggregated_alert

    # @return [IoTSecuritySolutionsAnalyticsRecommendation]
    # io_tsecurity_solutions_analytics_recommendation
    attr_reader :io_tsecurity_solutions_analytics_recommendation

    # @return [IoTSecuritySolutionsAnalyticsRecommendations]
    # io_tsecurity_solutions_analytics_recommendations
    attr_reader :io_tsecurity_solutions_analytics_recommendations

    # @return [IoTSecuritySolutions] io_tsecurity_solutions
    attr_reader :io_tsecurity_solutions

    # @return [IoTSecuritySolutionsResourceGroup]
    # io_tsecurity_solutions_resource_group
    attr_reader :io_tsecurity_solutions_resource_group

    # @return [IotSecuritySolution] iot_security_solution
    attr_reader :iot_security_solution

    # @return [Pricings] pricings
    attr_reader :pricings

    # @return [SecurityContacts] security_contacts
    attr_reader :security_contacts

    # @return [Settings] settings
    attr_reader :settings

    # @return [WorkspaceSettings] workspace_settings
    attr_reader :workspace_settings

    #
    # Creates initializes a new instance of the SecurityCenter class.
    # @param credentials [MsRest::ServiceClientCredentials] credentials to authorize HTTP requests made by the service client.
    # @param base_url [String] the base URI of the service.
    # @param options [Array] filters to be applied to the HTTP requests.
    #
    def initialize(credentials = nil, base_url = nil, options = nil)
      super(credentials, options)
      @base_url = base_url || 'https://management.azure.com'

      fail ArgumentError, 'invalid type of credentials input parameter' unless credentials.is_a?(MsRest::ServiceClientCredentials) unless credentials.nil?
      @credentials = credentials

      @advanced_threat_protection = AdvancedThreatProtection.new(self)
      @auto_provisioning_settings = AutoProvisioningSettings.new(self)
      @compliances = Compliances.new(self)
      @device_security_groups = DeviceSecurityGroups.new(self)
      @information_protection_policies = InformationProtectionPolicies.new(self)
      @io_tsecurity_solutions_analytics = IoTSecuritySolutionsAnalytics.new(self)
      @io_tsecurity_solutions_analytics_aggregated_alerts = IoTSecuritySolutionsAnalyticsAggregatedAlerts.new(self)
      @io_tsecurity_solutions_analytics_aggregated_alert = IoTSecuritySolutionsAnalyticsAggregatedAlert.new(self)
      @io_tsecurity_solutions_analytics_recommendation = IoTSecuritySolutionsAnalyticsRecommendation.new(self)
      @io_tsecurity_solutions_analytics_recommendations = IoTSecuritySolutionsAnalyticsRecommendations.new(self)
      @io_tsecurity_solutions = IoTSecuritySolutions.new(self)
      @io_tsecurity_solutions_resource_group = IoTSecuritySolutionsResourceGroup.new(self)
      @iot_security_solution = IotSecuritySolution.new(self)
      @pricings = Pricings.new(self)
      @security_contacts = SecurityContacts.new(self)
      @settings = Settings.new(self)
      @workspace_settings = WorkspaceSettings.new(self)
      @api_version = '2017-08-01-preview'
      @accept_language = 'en-US'
      @long_running_operation_retry_timeout = 30
      @generate_client_request_id = true
      add_telemetry
    end

    #
    # Makes a request and returns the body of the response.
    # @param method [Symbol] with any of the following values :get, :put, :post, :patch, :delete.
    # @param path [String] the path, relative to {base_url}.
    # @param options [Hash{String=>String}] specifying any request options like :body.
    # @return [Hash{String=>String}] containing the body of the response.
    # Example:
    #
    #  request_content = "{'location':'westus','tags':{'tag1':'val1','tag2':'val2'}}"
    #  path = "/path"
    #  options = {
    #    body: request_content,
    #    query_params: {'api-version' => '2016-02-01'}
    #  }
    #  result = @client.make_request(:put, path, options)
    #
    def make_request(method, path, options = {})
      result = make_request_with_http_info(method, path, options)
      result.body unless result.nil?
    end

    #
    # Makes a request and returns the operation response.
    # @param method [Symbol] with any of the following values :get, :put, :post, :patch, :delete.
    # @param path [String] the path, relative to {base_url}.
    # @param options [Hash{String=>String}] specifying any request options like :body.
    # @return [MsRestAzure::AzureOperationResponse] Operation response containing the request, response and status.
    #
    def make_request_with_http_info(method, path, options = {})
      result = make_request_async(method, path, options).value!
      result.body = result.response.body.to_s.empty? ? nil : JSON.load(result.response.body)
      result
    end

    #
    # Makes a request asynchronously.
    # @param method [Symbol] with any of the following values :get, :put, :post, :patch, :delete.
    # @param path [String] the path, relative to {base_url}.
    # @param options [Hash{String=>String}] specifying any request options like :body.
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def make_request_async(method, path, options = {})
      fail ArgumentError, 'method is nil' if method.nil?
      fail ArgumentError, 'path is nil' if path.nil?

      request_url = options[:base_url] || @base_url
      if(!options[:headers].nil? && !options[:headers]['Content-Type'].nil?)
        @request_headers['Content-Type'] = options[:headers]['Content-Type']
      end

      request_headers = @request_headers
      request_headers.merge!({'accept-language' => @accept_language}) unless @accept_language.nil?
      options.merge!({headers: request_headers.merge(options[:headers] || {})})
      options.merge!({credentials: @credentials}) unless @credentials.nil?

      super(request_url, method, path, options)
    end


    private
    #
    # Adds telemetry information.
    #
    def add_telemetry
        sdk_information = 'azure_mgmt_security'
        sdk_information = "#{sdk_information}/0.19.0"
        add_user_agent_information(sdk_information)
    end
  end
end
