# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2018_06_01
  module Models
    #
    # Azure Security Center is provided in two pricing tiers: free and
    # standard, with the standard tier available with a trial period. The
    # standard tier offers advanced security capabilities, while the free tier
    # offers basic security features.
    #
    class Pricing < Resource

      include MsRestAzure

      # @return [PricingTier] The pricing tier value. Azure Security Center is
      # provided in two pricing tiers: free and standard, with the standard
      # tier available with a trial period. The standard tier offers advanced
      # security capabilities, while the free tier offers basic security
      # features. Possible values include: 'Free', 'Standard'
      attr_accessor :pricing_tier

      # @return [Duration] The duration left for the subscriptions free trial
      # period - in ISO 8601 format (e.g. P3Y6M4DT12H30M5S).
      attr_accessor :free_trial_remaining_time


      #
      # Mapper for Pricing class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'Pricing',
          type: {
            name: 'Composite',
            class_name: 'Pricing',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              pricing_tier: {
                client_side_validation: true,
                required: true,
                serialized_name: 'properties.pricingTier',
                type: {
                  name: 'String'
                }
              },
              free_trial_remaining_time: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.freeTrialRemainingTime',
                type: {
                  name: 'TimeSpan'
                }
              }
            }
          }
        }
      end
    end
  end
end
