# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2019_08_01
  module Models
    #
    # List of IoT Security solution aggregated alert data.
    #
    class IoTSecurityAggregatedAlertList

      include MsRestAzure

      include MsRest::JSONable
      # @return [Array<IoTSecurityAggregatedAlert>] List of aggregated alerts
      # data.
      attr_accessor :value

      # @return [String] When there is too much alert data for one page, use
      # this URI to fetch the next page.
      attr_accessor :next_link

      # return [Proc] with next page method call.
      attr_accessor :next_method

      #
      # Gets the rest of the items for the request, enabling auto-pagination.
      #
      # @return [Array<IoTSecurityAggregatedAlert>] operation results.
      #
      def get_all_items
        items = @value
        page = self
        while page.next_link != nil && !page.next_link.strip.empty? do
          page = page.get_next_page
          items.concat(page.value)
        end
        items
      end

      #
      # Gets the next page of results.
      #
      # @return [IoTSecurityAggregatedAlertList] with next page content.
      #
      def get_next_page
        response = @next_method.call(@next_link).value! unless @next_method.nil?
        unless response.nil?
          @next_link = response.body.next_link
          @value = response.body.value
          self
        end
      end

      #
      # Mapper for IoTSecurityAggregatedAlertList class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'IoTSecurityAggregatedAlertList',
          type: {
            name: 'Composite',
            class_name: 'IoTSecurityAggregatedAlertList',
            model_properties: {
              value: {
                client_side_validation: true,
                required: true,
                serialized_name: 'value',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'IoTSecurityAggregatedAlertElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'IoTSecurityAggregatedAlert'
                      }
                  }
                }
              },
              next_link: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'nextLink',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
