# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2020_01_01_preview
  module Models
    #
    # Calculation result data
    #
    class SecureScoreControlScore

      include MsRestAzure

      # @return [Integer] Maximum control score (0..10)
      attr_accessor :max

      # @return [Float] Actual score for the control = (achieved points / total
      # points) * max score. if total points is zeroed, the return number is
      # 0.00
      attr_accessor :current

      # @return [Float] Ratio of the current score divided by the maximum.
      # Rounded to 4 digits after the decimal point
      attr_accessor :percentage


      #
      # Mapper for SecureScoreControlScore class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'SecureScoreControlScore',
          type: {
            name: 'Composite',
            class_name: 'SecureScoreControlScore',
            model_properties: {
              max: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'max',
                constraints: {
                  InclusiveMaximum: 10,
                  InclusiveMinimum: 0
                },
                type: {
                  name: 'Number'
                }
              },
              current: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'current',
                constraints: {
                  InclusiveMaximum: 10,
                  InclusiveMinimum: 0
                },
                type: {
                  name: 'Double'
                }
              },
              percentage: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'percentage',
                constraints: {
                  InclusiveMaximum: 1,
                  InclusiveMinimum: 0
                },
                type: {
                  name: 'Double'
                }
              }
            }
          }
        }
      end
    end
  end
end
