# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2020_01_01
  module Models
    #
    # The resource whose properties describes the Adaptive Network Hardening
    # settings for some Azure resource
    #
    class AdaptiveNetworkHardening < Resource

      include MsRestAzure

      # @return [Array<Rule>] The security rules which are recommended to be
      # effective on the VM
      attr_accessor :rules

      # @return [DateTime] The UTC time on which the rules were calculated
      attr_accessor :rules_calculation_time

      # @return [Array<EffectiveNetworkSecurityGroups>] The Network Security
      # Groups effective on the network interfaces of the protected resource
      attr_accessor :effective_network_security_groups


      #
      # Mapper for AdaptiveNetworkHardening class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'AdaptiveNetworkHardening',
          type: {
            name: 'Composite',
            class_name: 'AdaptiveNetworkHardening',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              rules: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.rules',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'RuleElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'Rule'
                      }
                  }
                }
              },
              rules_calculation_time: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.rulesCalculationTime',
                type: {
                  name: 'DateTime'
                }
              },
              effective_network_security_groups: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.effectiveNetworkSecurityGroups',
                type: {
                  name: 'Sequence',
                  element: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'EffectiveNetworkSecurityGroupsElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'EffectiveNetworkSecurityGroups'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
