# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2020_01_01
  module Models
    #
    # Security assessment on a resource
    #
    class SecurityAssessment < Resource

      include MsRestAzure

      # @return [ResourceDetails]
      attr_accessor :resource_details

      # @return [String] User friendly display name of the assessment
      attr_accessor :display_name

      # @return [AssessmentStatus]
      attr_accessor :status

      # @return [Hash{String => String}] Additional data regarding the
      # assessment
      attr_accessor :additional_data

      # @return [AssessmentLinks]
      attr_accessor :links

      # @return [SecurityAssessmentMetadataProperties]
      attr_accessor :metadata

      # @return [SecurityAssessmentPartnerData]
      attr_accessor :partners_data


      #
      # Mapper for SecurityAssessment class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'SecurityAssessment',
          type: {
            name: 'Composite',
            class_name: 'SecurityAssessment',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              resource_details: {
                client_side_validation: true,
                required: true,
                serialized_name: 'properties.resourceDetails',
                type: {
                  name: 'Composite',
                  polymorphic_discriminator: 'source',
                  uber_parent: 'ResourceDetails',
                  class_name: 'ResourceDetails'
                }
              },
              display_name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.displayName',
                type: {
                  name: 'String'
                }
              },
              status: {
                client_side_validation: true,
                required: true,
                serialized_name: 'properties.status',
                type: {
                  name: 'Composite',
                  class_name: 'AssessmentStatus'
                }
              },
              additional_data: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.additionalData',
                type: {
                  name: 'Dictionary',
                  value: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              links: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.links',
                type: {
                  name: 'Composite',
                  class_name: 'AssessmentLinks'
                }
              },
              metadata: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.metadata',
                type: {
                  name: 'Composite',
                  class_name: 'SecurityAssessmentMetadataProperties'
                }
              },
              partners_data: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.partnersData',
                type: {
                  name: 'Composite',
                  class_name: 'SecurityAssessmentPartnerData'
                }
              }
            }
          }
        }
      end
    end
  end
end
