# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2020_07_01_preview
  #
  # API spec for Microsoft.Security (Azure Security Center) resource provider
  #
  class SqlVulnerabilityAssessmentScanResults
    include MsRestAzure

    #
    # Creates and initializes a new instance of the SqlVulnerabilityAssessmentScanResults class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [SecurityCenter] reference to the SecurityCenter
    attr_reader :client

    #
    # Gets the scan results of a single rule in a scan record.
    #
    # @param scan_id [String] The scan Id. Type 'latest' to get the scan results
    # for the latest scan.
    # @param scan_result_id [String] The rule Id of the results.
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ScanResult] operation results.
    #
    def get(scan_id, scan_result_id, workspace_id, api_version, resource_id, custom_headers:nil)
      response = get_async(scan_id, scan_result_id, workspace_id, api_version, resource_id, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the scan results of a single rule in a scan record.
    #
    # @param scan_id [String] The scan Id. Type 'latest' to get the scan results
    # for the latest scan.
    # @param scan_result_id [String] The rule Id of the results.
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(scan_id, scan_result_id, workspace_id, api_version, resource_id, custom_headers:nil)
      get_async(scan_id, scan_result_id, workspace_id, api_version, resource_id, custom_headers:custom_headers).value!
    end

    #
    # Gets the scan results of a single rule in a scan record.
    #
    # @param scan_id [String] The scan Id. Type 'latest' to get the scan results
    # for the latest scan.
    # @param scan_result_id [String] The rule Id of the results.
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(scan_id, scan_result_id, workspace_id, api_version, resource_id, custom_headers:nil)
      fail ArgumentError, 'scan_id is nil' if scan_id.nil?
      fail ArgumentError, 'scan_result_id is nil' if scan_result_id.nil?
      fail ArgumentError, 'workspace_id is nil' if workspace_id.nil?
      fail ArgumentError, 'api_version is nil' if api_version.nil?
      fail ArgumentError, 'resource_id is nil' if resource_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}/scanResults/{scanResultId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'scanId' => scan_id,'scanResultId' => scan_result_id},
          skip_encoding_path_params: {'resourceId' => resource_id},
          query_params: {'workspaceId' => workspace_id,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2020_07_01_preview::Models::ScanResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets a list of scan results for a single scan record.
    #
    # @param scan_id [String] The scan Id. Type 'latest' to get the scan results
    # for the latest scan.
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ScanResults] operation results.
    #
    def list(scan_id, workspace_id, api_version, resource_id, custom_headers:nil)
      response = list_async(scan_id, workspace_id, api_version, resource_id, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a list of scan results for a single scan record.
    #
    # @param scan_id [String] The scan Id. Type 'latest' to get the scan results
    # for the latest scan.
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(scan_id, workspace_id, api_version, resource_id, custom_headers:nil)
      list_async(scan_id, workspace_id, api_version, resource_id, custom_headers:custom_headers).value!
    end

    #
    # Gets a list of scan results for a single scan record.
    #
    # @param scan_id [String] The scan Id. Type 'latest' to get the scan results
    # for the latest scan.
    # @param workspace_id [String] The workspace Id.
    # @param api_version [String] The api version.
    # @param resource_id [String] The identifier of the resource.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(scan_id, workspace_id, api_version, resource_id, custom_headers:nil)
      fail ArgumentError, 'scan_id is nil' if scan_id.nil?
      fail ArgumentError, 'workspace_id is nil' if workspace_id.nil?
      fail ArgumentError, 'api_version is nil' if api_version.nil?
      fail ArgumentError, 'resource_id is nil' if resource_id.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}/scanResults'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'scanId' => scan_id},
          skip_encoding_path_params: {'resourceId' => resource_id},
          query_params: {'workspaceId' => workspace_id,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2020_07_01_preview::Models::ScanResults.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
