# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Security::Mgmt::V2020_08_06_preview
  #
  # API spec for Microsoft.Security (Azure Security Center) resource provider
  #
  class IotSensors
    include MsRestAzure

    #
    # Creates and initializes a new instance of the IotSensors class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [SecurityCenter] reference to the SecurityCenter
    attr_reader :client

    #
    # List IoT sensors
    #
    # @param scope [String] Scope of the query (IoT Hub,
    # /providers/Microsoft.Devices/iotHubs/myHub)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [IotSensorsList] operation results.
    #
    def list(scope, custom_headers:nil)
      response = list_async(scope, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List IoT sensors
    #
    # @param scope [String] Scope of the query (IoT Hub,
    # /providers/Microsoft.Devices/iotHubs/myHub)
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(scope, custom_headers:nil)
      list_async(scope, custom_headers:custom_headers).value!
    end

    #
    # List IoT sensors
    #
    # @param scope [String] Scope of the query (IoT Hub,
    # /providers/Microsoft.Devices/iotHubs/myHub)
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(scope, custom_headers:nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'scope is nil' if scope.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{scope}/providers/Microsoft.Security/iotSensors'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'scope' => scope},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2020_08_06_preview::Models::IotSensorsList.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get IoT sensor
    #
    # @param scope [String] Scope of the query (IoT Hub,
    # /providers/Microsoft.Devices/iotHubs/myHub)
    # @param iot_sensor_name [String] Name of the IoT sensor
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [IotSensor] operation results.
    #
    def get(scope, iot_sensor_name, custom_headers:nil)
      response = get_async(scope, iot_sensor_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get IoT sensor
    #
    # @param scope [String] Scope of the query (IoT Hub,
    # /providers/Microsoft.Devices/iotHubs/myHub)
    # @param iot_sensor_name [String] Name of the IoT sensor
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(scope, iot_sensor_name, custom_headers:nil)
      get_async(scope, iot_sensor_name, custom_headers:custom_headers).value!
    end

    #
    # Get IoT sensor
    #
    # @param scope [String] Scope of the query (IoT Hub,
    # /providers/Microsoft.Devices/iotHubs/myHub)
    # @param iot_sensor_name [String] Name of the IoT sensor
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(scope, iot_sensor_name, custom_headers:nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'scope is nil' if scope.nil?
      fail ArgumentError, 'iot_sensor_name is nil' if iot_sensor_name.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{scope}/providers/Microsoft.Security/iotSensors/{iotSensorName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'iotSensorName' => iot_sensor_name},
          skip_encoding_path_params: {'scope' => scope},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2020_08_06_preview::Models::IotSensor.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create or update IoT sensor
    #
    # @param scope [String] Scope of the query (IoT Hub,
    # /providers/Microsoft.Devices/iotHubs/myHub)
    # @param iot_sensor_name [String] Name of the IoT sensor
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [IotSensor] operation results.
    #
    def create_or_update(scope, iot_sensor_name, custom_headers:nil)
      response = create_or_update_async(scope, iot_sensor_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create or update IoT sensor
    #
    # @param scope [String] Scope of the query (IoT Hub,
    # /providers/Microsoft.Devices/iotHubs/myHub)
    # @param iot_sensor_name [String] Name of the IoT sensor
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_with_http_info(scope, iot_sensor_name, custom_headers:nil)
      create_or_update_async(scope, iot_sensor_name, custom_headers:custom_headers).value!
    end

    #
    # Create or update IoT sensor
    #
    # @param scope [String] Scope of the query (IoT Hub,
    # /providers/Microsoft.Devices/iotHubs/myHub)
    # @param iot_sensor_name [String] Name of the IoT sensor
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_async(scope, iot_sensor_name, custom_headers:nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'scope is nil' if scope.nil?
      fail ArgumentError, 'iot_sensor_name is nil' if iot_sensor_name.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{scope}/providers/Microsoft.Security/iotSensors/{iotSensorName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'iotSensorName' => iot_sensor_name},
          skip_encoding_path_params: {'scope' => scope},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2020_08_06_preview::Models::IotSensor.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::Security::Mgmt::V2020_08_06_preview::Models::IotSensor.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete IoT sensor
    #
    # @param scope [String] Scope of the query (IoT Hub,
    # /providers/Microsoft.Devices/iotHubs/myHub)
    # @param iot_sensor_name [String] Name of the IoT sensor
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete(scope, iot_sensor_name, custom_headers:nil)
      response = delete_async(scope, iot_sensor_name, custom_headers:custom_headers).value!
      nil
    end

    #
    # Delete IoT sensor
    #
    # @param scope [String] Scope of the query (IoT Hub,
    # /providers/Microsoft.Devices/iotHubs/myHub)
    # @param iot_sensor_name [String] Name of the IoT sensor
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_with_http_info(scope, iot_sensor_name, custom_headers:nil)
      delete_async(scope, iot_sensor_name, custom_headers:custom_headers).value!
    end

    #
    # Delete IoT sensor
    #
    # @param scope [String] Scope of the query (IoT Hub,
    # /providers/Microsoft.Devices/iotHubs/myHub)
    # @param iot_sensor_name [String] Name of the IoT sensor
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_async(scope, iot_sensor_name, custom_headers:nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'scope is nil' if scope.nil?
      fail ArgumentError, 'iot_sensor_name is nil' if iot_sensor_name.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{scope}/providers/Microsoft.Security/iotSensors/{iotSensorName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'iotSensorName' => iot_sensor_name},
          skip_encoding_path_params: {'scope' => scope},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Download sensor activation file
    #
    # @param scope [String] Scope of the query (IoT Hub,
    # /providers/Microsoft.Devices/iotHubs/myHub)
    # @param iot_sensor_name [String] Name of the IoT sensor
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NOT_IMPLEMENTED] operation results.
    #
    def download_activation(scope, iot_sensor_name, custom_headers:nil)
      response = download_activation_async(scope, iot_sensor_name, custom_headers:custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Download sensor activation file
    #
    # @param scope [String] Scope of the query (IoT Hub,
    # /providers/Microsoft.Devices/iotHubs/myHub)
    # @param iot_sensor_name [String] Name of the IoT sensor
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def download_activation_with_http_info(scope, iot_sensor_name, custom_headers:nil)
      download_activation_async(scope, iot_sensor_name, custom_headers:custom_headers).value!
    end

    #
    # Download sensor activation file
    #
    # @param scope [String] Scope of the query (IoT Hub,
    # /providers/Microsoft.Devices/iotHubs/myHub)
    # @param iot_sensor_name [String] Name of the IoT sensor
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def download_activation_async(scope, iot_sensor_name, custom_headers:nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, 'scope is nil' if scope.nil?
      fail ArgumentError, 'iot_sensor_name is nil' if iot_sensor_name.nil?


      request_headers = {}
      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{scope}/providers/Microsoft.Security/iotSensors/{iotSensorName}/downloadActivation'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'iotSensorName' => iot_sensor_name},
          skip_encoding_path_params: {'scope' => scope},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        result.correlation_request_id = http_response['x-ms-correlation-request-id'] unless http_response['x-ms-correlation-request-id'].nil?
        result.client_request_id = http_response['x-ms-client-request-id'] unless http_response['x-ms-client-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              client_side_validation: true,
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Stream'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

  end
end
