# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Storage::Mgmt::V2015_06_15
  module Models
    #
    # The storage account.
    #
    class StorageAccount < Resource

      include MsRestAzure

      # @return [ProvisioningState] The status of the storage account at the
      # time the operation was called. Possible values include: 'Creating',
      # 'ResolvingDNS', 'Succeeded'
      attr_accessor :provisioning_state

      # @return [AccountType] The type of the storage account. Possible values
      # include: 'Standard_LRS', 'Standard_ZRS', 'Standard_GRS',
      # 'Standard_RAGRS', 'Premium_LRS'
      attr_accessor :account_type

      # @return [Endpoints] The URLs that are used to perform a retrieval of a
      # public blob, queue, or table object. Note that Standard_ZRS and
      # Premium_LRS accounts only return the blob endpoint.
      attr_accessor :primary_endpoints

      # @return [String] The location of the primary data center for the
      # storage account.
      attr_accessor :primary_location

      # @return [AccountStatus] The status indicating whether the primary
      # location of the storage account is available or unavailable. Possible
      # values include: 'Available', 'Unavailable'
      attr_accessor :status_of_primary

      # @return [DateTime] The timestamp of the most recent instance of a
      # failover to the secondary location. Only the most recent timestamp is
      # retained. This element is not returned if there has never been a
      # failover instance. Only available if the accountType is Standard_GRS or
      # Standard_RAGRS.
      attr_accessor :last_geo_failover_time

      # @return [String] The location of the geo-replicated secondary for the
      # storage account. Only available if the accountType is Standard_GRS or
      # Standard_RAGRS.
      attr_accessor :secondary_location

      # @return [AccountStatus] The status indicating whether the secondary
      # location of the storage account is available or unavailable. Only
      # available if the SKU name is Standard_GRS or Standard_RAGRS. Possible
      # values include: 'Available', 'Unavailable'
      attr_accessor :status_of_secondary

      # @return [DateTime] The creation date and time of the storage account in
      # UTC.
      attr_accessor :creation_time

      # @return [CustomDomain] The custom domain the user assigned to this
      # storage account.
      attr_accessor :custom_domain

      # @return [Endpoints] The URLs that are used to perform a retrieval of a
      # public blob, queue, or table object from the secondary location of the
      # storage account. Only available if the SKU name is Standard_RAGRS.
      attr_accessor :secondary_endpoints


      #
      # Mapper for StorageAccount class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'StorageAccount',
          type: {
            name: 'Composite',
            class_name: 'StorageAccount',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              location: {
                client_side_validation: true,
                required: false,
                serialized_name: 'location',
                type: {
                  name: 'String'
                }
              },
              tags: {
                client_side_validation: true,
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              provisioning_state: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.provisioningState',
                type: {
                  name: 'Enum',
                  module: 'ProvisioningState'
                }
              },
              account_type: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.accountType',
                type: {
                  name: 'Enum',
                  module: 'AccountType'
                }
              },
              primary_endpoints: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.primaryEndpoints',
                type: {
                  name: 'Composite',
                  class_name: 'Endpoints'
                }
              },
              primary_location: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.primaryLocation',
                type: {
                  name: 'String'
                }
              },
              status_of_primary: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.statusOfPrimary',
                type: {
                  name: 'Enum',
                  module: 'AccountStatus'
                }
              },
              last_geo_failover_time: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.lastGeoFailoverTime',
                type: {
                  name: 'DateTime'
                }
              },
              secondary_location: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.secondaryLocation',
                type: {
                  name: 'String'
                }
              },
              status_of_secondary: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.statusOfSecondary',
                type: {
                  name: 'Enum',
                  module: 'AccountStatus'
                }
              },
              creation_time: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.creationTime',
                type: {
                  name: 'DateTime'
                }
              },
              custom_domain: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.customDomain',
                type: {
                  name: 'Composite',
                  class_name: 'CustomDomain'
                }
              },
              secondary_endpoints: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.secondaryEndpoints',
                type: {
                  name: 'Composite',
                  class_name: 'Endpoints'
                }
              }
            }
          }
        }
      end
    end
  end
end
