# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Storage::Mgmt::V2021_01_01
  module Models
    #
    # An object that wraps the blob inventory rule. Each rule is uniquely
    # defined by name.
    #
    class BlobInventoryPolicyRule

      include MsRestAzure

      # @return [Boolean] Rule is enabled when set to true.
      attr_accessor :enabled

      # @return [String] A rule name can contain any combination of alpha
      # numeric characters. Rule name is case-sensitive. It must be unique
      # within a policy.
      attr_accessor :name

      # @return [BlobInventoryPolicyDefinition] An object that defines the blob
      # inventory policy rule.
      attr_accessor :definition


      #
      # Mapper for BlobInventoryPolicyRule class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'BlobInventoryPolicyRule',
          type: {
            name: 'Composite',
            class_name: 'BlobInventoryPolicyRule',
            model_properties: {
              enabled: {
                client_side_validation: true,
                required: true,
                serialized_name: 'enabled',
                type: {
                  name: 'Boolean'
                }
              },
              name: {
                client_side_validation: true,
                required: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              definition: {
                client_side_validation: true,
                required: true,
                serialized_name: 'definition',
                type: {
                  name: 'Composite',
                  class_name: 'BlobInventoryPolicyDefinition'
                }
              }
            }
          }
        }
      end
    end
  end
end
