# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Storage::Mgmt::V2021_01_01
  module Models
    #
    # The encryption settings on the storage account.
    #
    class Encryption

      include MsRestAzure

      # @return [EncryptionServices] List of services which support encryption.
      attr_accessor :services

      # @return [KeySource] The encryption keySource (provider). Possible
      # values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault.
      # Possible values include: 'Microsoft.Storage', 'Microsoft.Keyvault'.
      # Default value: 'Microsoft.Storage' .
      attr_accessor :key_source

      # @return [Boolean] A boolean indicating whether or not the service
      # applies a secondary layer of encryption with platform managed keys for
      # data at rest.
      attr_accessor :require_infrastructure_encryption

      # @return [KeyVaultProperties] Properties provided by key vault.
      attr_accessor :key_vault_properties

      # @return [EncryptionIdentity] The identity to be used with service-side
      # encryption at rest.
      attr_accessor :encryption_identity


      #
      # Mapper for Encryption class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'Encryption',
          type: {
            name: 'Composite',
            class_name: 'Encryption',
            model_properties: {
              services: {
                client_side_validation: true,
                required: false,
                serialized_name: 'services',
                type: {
                  name: 'Composite',
                  class_name: 'EncryptionServices'
                }
              },
              key_source: {
                client_side_validation: true,
                required: true,
                serialized_name: 'keySource',
                default_value: 'Microsoft.Storage',
                type: {
                  name: 'String'
                }
              },
              require_infrastructure_encryption: {
                client_side_validation: true,
                required: false,
                serialized_name: 'requireInfrastructureEncryption',
                type: {
                  name: 'Boolean'
                }
              },
              key_vault_properties: {
                client_side_validation: true,
                required: false,
                serialized_name: 'keyvaultproperties',
                type: {
                  name: 'Composite',
                  class_name: 'KeyVaultProperties'
                }
              },
              encryption_identity: {
                client_side_validation: true,
                required: false,
                serialized_name: 'identity',
                type: {
                  name: 'Composite',
                  class_name: 'EncryptionIdentity'
                }
              }
            }
          }
        }
      end
    end
  end
end
