# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Storage::Mgmt::V2021_01_01
  module Models
    #
    # The Encryption Scope resource.
    #
    class EncryptionScope < Resource

      include MsRestAzure

      # @return [EncryptionScopeSource] The provider for the encryption scope.
      # Possible values (case-insensitive):  Microsoft.Storage,
      # Microsoft.KeyVault. Possible values include: 'Microsoft.Storage',
      # 'Microsoft.KeyVault'
      attr_accessor :source

      # @return [EncryptionScopeState] The state of the encryption scope.
      # Possible values (case-insensitive):  Enabled, Disabled. Possible values
      # include: 'Enabled', 'Disabled'
      attr_accessor :state

      # @return [DateTime] Gets the creation date and time of the encryption
      # scope in UTC.
      attr_accessor :creation_time

      # @return [DateTime] Gets the last modification date and time of the
      # encryption scope in UTC.
      attr_accessor :last_modified_time

      # @return [EncryptionScopeKeyVaultProperties] The key vault properties
      # for the encryption scope. This is a required field if encryption scope
      # 'source' attribute is set to 'Microsoft.KeyVault'.
      attr_accessor :key_vault_properties

      # @return [Boolean] A boolean indicating whether or not the service
      # applies a secondary layer of encryption with platform managed keys for
      # data at rest.
      attr_accessor :require_infrastructure_encryption


      #
      # Mapper for EncryptionScope class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'EncryptionScope',
          type: {
            name: 'Composite',
            class_name: 'EncryptionScope',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              source: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.source',
                type: {
                  name: 'String'
                }
              },
              state: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.state',
                type: {
                  name: 'String'
                }
              },
              creation_time: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.creationTime',
                type: {
                  name: 'DateTime'
                }
              },
              last_modified_time: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.lastModifiedTime',
                type: {
                  name: 'DateTime'
                }
              },
              key_vault_properties: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.keyVaultProperties',
                type: {
                  name: 'Composite',
                  class_name: 'EncryptionScopeKeyVaultProperties'
                }
              },
              require_infrastructure_encryption: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.requireInfrastructureEncryption',
                type: {
                  name: 'Boolean'
                }
              }
            }
          }
        }
      end
    end
  end
end
