# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::Storage::Mgmt::V2021_01_01
  module Models
    #
    # The file share properties be listed out.
    #
    class FileShareItem < AzureEntityResource

      include MsRestAzure

      # @return [DateTime] Returns the date and time the share was last
      # modified.
      attr_accessor :last_modified_time

      # @return [Hash{String => String}] A name-value pair to associate with
      # the share as metadata.
      attr_accessor :metadata

      # @return [Integer] The maximum size of the share, in gigabytes. Must be
      # greater than 0, and less than or equal to 5TB (5120). For Large File
      # Shares, the maximum size is 102400.
      attr_accessor :share_quota

      # @return [EnabledProtocols] The authentication protocol that is used for
      # the file share. Can only be specified when creating a share. Possible
      # values include: 'SMB', 'NFS'
      attr_accessor :enabled_protocols

      # @return [RootSquashType] The property is for NFS share only. The
      # default is NoRootSquash. Possible values include: 'NoRootSquash',
      # 'RootSquash', 'AllSquash'
      attr_accessor :root_squash

      # @return [String] The version of the share.
      attr_accessor :version

      # @return [Boolean] Indicates whether the share was deleted.
      attr_accessor :deleted

      # @return [DateTime] The deleted time if the share was deleted.
      attr_accessor :deleted_time

      # @return [Integer] Remaining retention days for share that was soft
      # deleted.
      attr_accessor :remaining_retention_days

      # @return [ShareAccessTier] Access tier for specific share. GpV2 account
      # can choose between TransactionOptimized (default), Hot, and Cool.
      # FileStorage account can choose Premium. Possible values include:
      # 'TransactionOptimized', 'Hot', 'Cool', 'Premium'
      attr_accessor :access_tier

      # @return [DateTime] Indicates the last modification time for share
      # access tier.
      attr_accessor :access_tier_change_time

      # @return [String] Indicates if there is a pending transition for access
      # tier.
      attr_accessor :access_tier_status

      # @return [Integer] The approximate size of the data stored on the share.
      # Note that this value may not include all recently created or recently
      # resized files.
      attr_accessor :share_usage_bytes

      # @return [DateTime] Creation time of share snapshot returned in the
      # response of list shares with expand param "snapshots".
      attr_accessor :snapshot_time


      #
      # Mapper for FileShareItem class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          client_side_validation: true,
          required: false,
          serialized_name: 'FileShareItem',
          type: {
            name: 'Composite',
            class_name: 'FileShareItem',
            model_properties: {
              id: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'id',
                type: {
                  name: 'String'
                }
              },
              name: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              type: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'type',
                type: {
                  name: 'String'
                }
              },
              etag: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'etag',
                type: {
                  name: 'String'
                }
              },
              last_modified_time: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.lastModifiedTime',
                type: {
                  name: 'DateTime'
                }
              },
              metadata: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.metadata',
                type: {
                  name: 'Dictionary',
                  value: {
                      client_side_validation: true,
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              },
              share_quota: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.shareQuota',
                constraints: {
                  InclusiveMaximum: 102400,
                  InclusiveMinimum: 1
                },
                type: {
                  name: 'Number'
                }
              },
              enabled_protocols: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.enabledProtocols',
                type: {
                  name: 'String'
                }
              },
              root_squash: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.rootSquash',
                type: {
                  name: 'String'
                }
              },
              version: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.version',
                type: {
                  name: 'String'
                }
              },
              deleted: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.deleted',
                type: {
                  name: 'Boolean'
                }
              },
              deleted_time: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.deletedTime',
                type: {
                  name: 'DateTime'
                }
              },
              remaining_retention_days: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.remainingRetentionDays',
                type: {
                  name: 'Number'
                }
              },
              access_tier: {
                client_side_validation: true,
                required: false,
                serialized_name: 'properties.accessTier',
                type: {
                  name: 'String'
                }
              },
              access_tier_change_time: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.accessTierChangeTime',
                type: {
                  name: 'DateTime'
                }
              },
              access_tier_status: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.accessTierStatus',
                type: {
                  name: 'String'
                }
              },
              share_usage_bytes: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.shareUsageBytes',
                type: {
                  name: 'Number'
                }
              },
              snapshot_time: {
                client_side_validation: true,
                required: false,
                read_only: true,
                serialized_name: 'properties.snapshotTime',
                type: {
                  name: 'DateTime'
                }
              }
            }
          }
        }
      end
    end
  end
end
